/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.KeepDeletedCells;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.end2end.AlterTableIT;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.index.GlobalIndexChecker;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.mapreduce.index.IndexUpgradeTool;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.QueryServicesOptions;
import org.apache.phoenix.schema.ColumnAlreadyExistsException;
import org.apache.phoenix.schema.LiteralTTLExpression;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.SchemaNotFoundException;
import org.apache.phoenix.schema.TTLExpression;
import org.apache.phoenix.schema.TableAlreadyExistsException;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class CreateTableIT
extends ParallelStatsDisabledIT {
    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap props = Maps.newHashMapWithExpectedSize((int)1);
        props.put("phoenix.max.lookback.age.seconds", Integer.toString(3600));
        props.put("phoenix.use.stats.parallelization", Boolean.toString(false));
        CreateTableIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    @Test
    public void testStartKeyStopKey() throws SQLException {
        Properties props = new Properties();
        Connection conn = DriverManager.getConnection(CreateTableIT.getUrl(), props);
        String tableName = CreateTableIT.generateUniqueName();
        conn.createStatement().execute("CREATE TABLE " + tableName + " (pk char(2) not null primary key) SPLIT ON ('EA','EZ')");
        conn.close();
        String query = "select count(*) from  " + tableName + "  where pk >= 'EA' and pk < 'EZ'";
        conn = DriverManager.getConnection(CreateTableIT.getUrl(), props);
        Statement statement = conn.createStatement();
        statement.execute(query);
        PhoenixStatement pstatement = statement.unwrap(PhoenixStatement.class);
        List splits = pstatement.getQueryPlan().getSplits();
        Assert.assertTrue((splits.size() > 0 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSplitsWithFile() throws Exception {
        File splitFile = new File("splitFile.txt");
        try {
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(splitFile));){
                writer.write("EA");
                writer.newLine();
                writer.write("EZ");
            }
            Properties props = new Properties();
            Connection conn = DriverManager.getConnection(CreateTableIT.getUrl(), props);
            String tableName = CreateTableIT.generateUniqueName();
            conn.createStatement().execute("CREATE TABLE " + tableName + " (pk char(2) not null primary key) SPLITS_FILE='splitFile.txt'");
            conn.close();
            String query = "select * from  " + tableName;
            conn = DriverManager.getConnection(CreateTableIT.getUrl(), props);
            Statement statement = conn.createStatement();
            statement.execute(query);
            PhoenixStatement pstatement = statement.unwrap(PhoenixStatement.class);
            List splits = pstatement.getQueryPlan().getSplits();
            Assert.assertEquals((long)3L, (long)splits.size());
        }
        finally {
            splitFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSplitsWithAbsoluteFileName() throws Exception {
        File splitFile = new File("splitFile.txt");
        try {
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(splitFile));){
                writer.write("EA");
                writer.newLine();
                writer.write("EZ");
            }
            Properties props = new Properties();
            Connection conn = DriverManager.getConnection(CreateTableIT.getUrl(), props);
            String tableName = CreateTableIT.generateUniqueName();
            String createTableSql = "CREATE TABLE " + tableName + " (pk char(2) not null primary key) SPLITS_FILE='" + splitFile.getAbsolutePath() + "'";
            conn.createStatement().execute(createTableSql);
            conn.close();
            String query = "select * from  " + tableName;
            conn = DriverManager.getConnection(CreateTableIT.getUrl(), props);
            Statement statement = conn.createStatement();
            statement.execute(query);
            PhoenixStatement pstatement = statement.unwrap(PhoenixStatement.class);
            List splits = pstatement.getQueryPlan().getSplits();
            Assert.assertEquals((long)3L, (long)splits.size());
        }
        finally {
            splitFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSplitsWithBadFileName() throws Exception {
        Properties props = new Properties();
        String tableName = CreateTableIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(CreateTableIT.getUrl(), props);){
            conn.createStatement().execute("CREATE TABLE " + tableName + " (pk char(2) not null primary key) SPLITS_FILE='bad-split-file.txt'");
            Assert.fail((String)"Shouldn't come here");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSplitsWithBothSplitPointsAndSplitFileProvided() throws Exception {
        Properties props = new Properties();
        String tableName = CreateTableIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(CreateTableIT.getUrl(), props);){
            conn.createStatement().execute("CREATE TABLE " + tableName + " (pk char(2) not null primary key) SPLITS_FILE='bad-split-file.txt' SPLIT ON ('EA','EZ')");
            Assert.fail((String)"Shouldn't come here");
        }
    }

    @Test
    public void testCreateAlterTableWithDuplicateColumn() throws Exception {
        Properties props = new Properties();
        int failureCount = 0;
        int expectedExecCount = 0;
        String tableName = CreateTableIT.generateUniqueName();
        String viewName = CreateTableIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(CreateTableIT.getUrl(), props);){
            try {
                conn.createStatement().execute(String.format("CREATE TABLE %s (name VARCHAR NOT NULL PRIMARY KEY, city VARCHAR, name1 VARCHAR, name VARCHAR)", tableName));
                Assert.fail((String)"Should have failed with ColumnAlreadyExistsException");
            }
            catch (ColumnAlreadyExistsException e) {
                ++failureCount;
            }
            try {
                conn.createStatement().execute(String.format("CREATE TABLE %s (name VARCHAR NOT NULL PRIMARY KEY, city VARCHAR, name1 VARCHAR, name1 VARCHAR)", tableName));
                Assert.fail((String)"Should have failed with ColumnAlreadyExistsException");
            }
            catch (ColumnAlreadyExistsException e) {
                ++failureCount;
            }
            try {
                conn.createStatement().execute(String.format("CREATE TABLE %s (key1 VARCHAR NOT NULL PRIMARY KEY, city VARCHAR, name1 VARCHAR, key1 INTEGER)", tableName));
                Assert.fail((String)"Should have failed with ColumnAlreadyExistsException");
            }
            catch (ColumnAlreadyExistsException e) {
                ++failureCount;
            }
            try {
                conn.createStatement().execute(String.format("CREATE TABLE %s (name VARCHAR NOT NULL, name1 VARCHAR NOT NULL, name2 VARCHAR, name VARCHAR CONSTRAINT PK PRIMARY KEY(name, name1))", tableName));
                Assert.fail((String)"Should have failed with ColumnAlreadyExistsException");
            }
            catch (ColumnAlreadyExistsException e) {
                ++failureCount;
            }
            try {
                conn.createStatement().execute(String.format("CREATE TABLE %s (name VARCHAR NOT NULL, name1 VARCHAR NOT NULL, name2 VARCHAR, name3 VARCHAR CONSTRAINT PK PRIMARY KEY(name, name1))", tableName));
                ++expectedExecCount;
                conn.createStatement().execute(String.format("CREATE VIEW %s (name1 CHAR(5)) AS SELECT * FROM %s", viewName, tableName));
                Assert.fail((String)"Should have failed with ColumnAlreadyExistsException");
            }
            catch (ColumnAlreadyExistsException e) {
                ++failureCount;
            }
            try {
                conn.createStatement().execute(String.format("DROP TABLE %s", tableName));
                conn.createStatement().execute(String.format("CREATE TABLE %s (name VARCHAR NOT NULL, name1 VARCHAR NOT NULL, name2 VARCHAR, name3 VARCHAR CONSTRAINT PK PRIMARY KEY(name, name1))", tableName));
                ++expectedExecCount;
                conn.createStatement().execute(String.format("ALTER TABLE %s ADD name1 INTEGER", tableName));
                Assert.fail((String)"Should have failed with ColumnAlreadyExistsException");
            }
            catch (ColumnAlreadyExistsException e) {
                ++failureCount;
            }
            try {
                conn.createStatement().execute(String.format("DROP TABLE %s", tableName));
                conn.createStatement().execute(String.format("CREATE TABLE %s (name VARCHAR NOT NULL PRIMARY KEY, city VARCHAR, name1 VARCHAR, name2 VARCHAR)", tableName));
                ++expectedExecCount;
                conn.createStatement().execute(String.format("ALTER TABLE %s ADD name VARCHAR", tableName));
                Assert.fail((String)"Should have failed with ColumnAlreadyExistsException");
            }
            catch (ColumnAlreadyExistsException e) {
                ++failureCount;
            }
            Assert.assertEquals((long)7L, (long)failureCount);
            Assert.assertEquals((long)3L, (long)expectedExecCount);
            conn.createStatement().execute(String.format("DROP TABLE %s", tableName));
            conn.createStatement().execute(String.format("CREATE TABLE %s (name VARCHAR NOT NULL PRIMARY KEY, city VARCHAR, name1 VARCHAR, a.name VARCHAR)", tableName));
            conn.createStatement().execute(String.format("DROP TABLE %s", tableName));
            conn.createStatement().execute(String.format("CREATE TABLE %s (name VARCHAR NOT NULL PRIMARY KEY, city VARCHAR, name1 VARCHAR, name2 VARCHAR)", tableName));
            conn.createStatement().execute(String.format("ALTER TABLE %s ADD a.name VARCHAR", tableName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateTable() throws Exception {
        Throwable throwable;
        Connection conn3;
        String schemaName = "TEST";
        String tableName = schemaName + CreateTableIT.generateUniqueName();
        Properties props = new Properties();
        String ddl = "CREATE TABLE " + tableName + "(                data.addtime VARCHAR ,\n                data.dir VARCHAR ,\n                data.end_time VARCHAR ,\n                data.file VARCHAR ,\n                data.fk_log VARCHAR ,\n                data.host VARCHAR ,\n                data.r VARCHAR ,\n                data.size VARCHAR ,\n                data.start_time VARCHAR ,\n                data.stat_date DATE ,\n                data.stat_hour VARCHAR ,\n                data.stat_minute VARCHAR ,\n                data.state VARCHAR ,\n                data.title VARCHAR ,\n                data.\"user\" VARCHAR ,\n                data.inrow VARCHAR ,\n                data.jobid VARCHAR ,\n                data.jobtype VARCHAR ,\n                data.level VARCHAR ,\n                data.msg VARCHAR ,\n                data.outrow VARCHAR ,\n                data.pass_time VARCHAR ,\n                data.type VARCHAR ,\n                id INTEGER not null primary key desc\n                ) ";
        try (Connection conn2 = DriverManager.getConnection(CreateTableIT.getUrl(), props);){
            conn2.createStatement().execute(ddl);
        }
        Admin admin = driver.getConnectionQueryServices(CreateTableIT.getUrl(), props).getAdmin();
        Assert.assertNotNull((Object)admin.getDescriptor(TableName.valueOf((String)tableName)));
        ColumnFamilyDescriptor[] columnFamilies = admin.getDescriptor(TableName.valueOf((String)tableName)).getColumnFamilies();
        Assert.assertEquals((Object)BloomType.ROW, (Object)columnFamilies[0].getBloomFilterType());
        try {
            conn3 = DriverManager.getConnection(CreateTableIT.getUrl(), props);
            throwable = null;
            try {
                conn3.createStatement().execute(ddl);
                Assert.fail();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (conn3 != null) {
                    if (throwable != null) {
                        try {
                            conn3.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        conn3.close();
                    }
                }
            }
        }
        catch (TableAlreadyExistsException conn3) {
            // empty catch block
        }
        conn3 = DriverManager.getConnection(CreateTableIT.getUrl(), props);
        throwable = null;
        try {
            conn3.createStatement().execute("DROP TABLE " + tableName);
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            if (conn3 != null) {
                if (throwable != null) {
                    try {
                        conn3.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    conn3.close();
                }
            }
        }
        props.setProperty("phoenix.schema.isNamespaceMappingEnabled", Boolean.TRUE.toString());
        conn3 = DriverManager.getConnection(CreateTableIT.getUrl(), props);
        throwable = null;
        try {
            conn3.createStatement().execute("CREATE SCHEMA " + schemaName);
        }
        catch (Throwable throwable6) {
            throwable = throwable6;
            throw throwable6;
        }
        finally {
            if (conn3 != null) {
                if (throwable != null) {
                    try {
                        conn3.close();
                    }
                    catch (Throwable throwable7) {
                        throwable.addSuppressed(throwable7);
                    }
                } else {
                    conn3.close();
                }
            }
        }
        try {
            conn3 = DriverManager.getConnection(CreateTableIT.getUrl(), props);
            throwable = null;
            try {
                conn3.createStatement().execute(ddl);
                Assert.assertNotEquals(null, (Object)admin.getDescriptor(TableName.valueOf((byte[])SchemaUtil.getPhysicalTableName((byte[])tableName.getBytes(), (boolean)true).getName())));
            }
            catch (Throwable throwable8) {
                throwable = throwable8;
                throw throwable8;
            }
            finally {
                if (conn3 != null) {
                    if (throwable != null) {
                        try {
                            conn3.close();
                        }
                        catch (Throwable throwable9) {
                            throwable.addSuppressed(throwable9);
                        }
                    } else {
                        conn3.close();
                    }
                }
            }
        }
        finally {
            admin.close();
        }
        props.setProperty("phoenix.schema.dropMetaData", Boolean.TRUE.toString());
        conn3 = DriverManager.getConnection(CreateTableIT.getUrl(), props);
        throwable = null;
        try {
            conn3.createStatement().execute("DROP TABLE " + tableName);
        }
        catch (Throwable throwable10) {
            throwable = throwable10;
            throw throwable10;
        }
        finally {
            if (conn3 != null) {
                if (throwable != null) {
                    try {
                        conn3.close();
                    }
                    catch (Throwable throwable11) {
                        throwable.addSuppressed(throwable11);
                    }
                } else {
                    conn3.close();
                }
            }
        }
    }

    @Test
    public void testCreateMultiTenantTable() throws Exception {
        Properties props = new Properties();
        Connection conn = DriverManager.getConnection(CreateTableIT.getUrl(), props);
        String tableName = CreateTableIT.generateUniqueName();
        String ddl = "CREATE TABLE  " + tableName + " (                TenantId UNSIGNED_INT NOT NULL ,\n                Id UNSIGNED_INT NOT NULL ,\n                val VARCHAR ,\n                CONSTRAINT pk PRIMARY KEY(TenantId, Id) \n                ) MULTI_TENANT=true";
        conn.createStatement().execute(ddl);
        conn = DriverManager.getConnection(CreateTableIT.getUrl(), props);
        try {
            conn.createStatement().execute(ddl);
            Assert.fail();
        }
        catch (TableAlreadyExistsException tableAlreadyExistsException) {
            // empty catch block
        }
        conn = DriverManager.getConnection(CreateTableIT.getUrl(), props);
        conn.createStatement().execute("DROP TABLE  " + tableName);
    }

    @Test
    public void testCreateTableColumnFamilyHBaseAttribs1() throws Exception {
        String tableName = CreateTableIT.generateUniqueName();
        String ddl = "create table IF NOT EXISTS  " + tableName + "  ( id char(1) NOT NULL, col1 integer NOT NULL, col2 bigint NOT NULL, CONSTRAINT NAME_PK PRIMARY KEY (id, col1, col2) ) TTL=86400, SALT_BUCKETS = 4";
        Properties props = new Properties();
        Connection conn = DriverManager.getConnection(CreateTableIT.getUrl(), props);
        conn.createStatement().execute(ddl);
        Admin admin = driver.getConnectionQueryServices(CreateTableIT.getUrl(), props).getAdmin();
        ColumnFamilyDescriptor[] columnFamilies = admin.getDescriptor(TableName.valueOf((String)tableName)).getColumnFamilies();
        Assert.assertEquals((long)1L, (long)columnFamilies.length);
        Assert.assertEquals((long)86400L, (long)columnFamilies[0].getTimeToLive());
        TestUtil.assertTTLValue(conn, tableName, (TTLExpression)new LiteralTTLExpression(86400));
    }

    @Test
    public void testCreatingTooManyIndexesIsNotAllowed() throws Exception {
        String tableName = CreateTableIT.generateUniqueName();
        String ddl = "CREATE TABLE " + tableName + " (\nID VARCHAR(15) PRIMARY KEY,\nCOL1 BIGINT,COL2 BIGINT,COL3 BIGINT,COL4 BIGINT) ";
        Properties props = new Properties();
        Connection conn = DriverManager.getConnection(CreateTableIT.getUrl(), props);
        conn.createStatement().execute(ddl);
        int maxIndexes = conn.unwrap(PhoenixConnection.class).getQueryServices().getProps().getInt("phoenix.index.maxIndexesPerTable", 10);
        for (int i = 0; i < maxIndexes; ++i) {
            conn.createStatement().execute("CREATE LOCAL INDEX I_" + i + tableName + " ON " + tableName + "(COL1) INCLUDE (COL2,COL3,COL4)");
        }
        try {
            conn.createStatement().execute("CREATE LOCAL INDEX I_" + maxIndexes + tableName + " ON " + tableName + "(COL1) INCLUDE (COL2,COL3,COL4)");
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.TOO_MANY_INDEXES.getErrorCode(), (long)e.getErrorCode());
        }
    }

    @Test
    public void testCreateTableColumnFamilyHBaseAttribs2() throws Exception {
        String tableName = CreateTableIT.generateUniqueName();
        String ddl = "create table IF NOT EXISTS  " + tableName + "  ( id char(1) NOT NULL, col1 integer NOT NULL, b.col2 bigint, c.col3 bigint,  CONSTRAINT NAME_PK PRIMARY KEY (id, col1) ) TTL=86400, SALT_BUCKETS = 4";
        Properties props = new Properties();
        Connection conn = DriverManager.getConnection(CreateTableIT.getUrl(), props);
        conn.createStatement().execute(ddl);
        Admin admin = driver.getConnectionQueryServices(CreateTableIT.getUrl(), props).getAdmin();
        ColumnFamilyDescriptor[] columnFamilies = admin.getDescriptor(TableName.valueOf((String)tableName)).getColumnFamilies();
        Assert.assertEquals((long)2L, (long)columnFamilies.length);
        Assert.assertEquals((long)86400L, (long)columnFamilies[0].getTimeToLive());
        Assert.assertEquals((Object)"B", (Object)columnFamilies[0].getNameAsString());
        Assert.assertEquals((long)86400L, (long)columnFamilies[1].getTimeToLive());
        Assert.assertEquals((Object)"C", (Object)columnFamilies[1].getNameAsString());
        TestUtil.assertTTLValue(conn, tableName, (TTLExpression)new LiteralTTLExpression(86400));
    }

    @Test
    public void testCreateTableColumnFamilyHBaseAttribs3() throws Exception {
        String tableName = CreateTableIT.generateUniqueName();
        String ddl = "create table IF NOT EXISTS  " + tableName + "  ( id char(1) NOT NULL, col1 integer NOT NULL, b.col2 bigint, col3 bigint,  CONSTRAINT NAME_PK PRIMARY KEY (id, col1) ) TTL=86400, SALT_BUCKETS = 4";
        Properties props = new Properties();
        Connection conn = DriverManager.getConnection(CreateTableIT.getUrl(), props);
        conn.createStatement().execute(ddl);
        Admin admin = driver.getConnectionQueryServices(CreateTableIT.getUrl(), props).getAdmin();
        ColumnFamilyDescriptor[] columnFamilies = admin.getDescriptor(TableName.valueOf((String)tableName)).getColumnFamilies();
        Assert.assertEquals((long)2L, (long)columnFamilies.length);
        Assert.assertEquals((Object)"0", (Object)columnFamilies[0].getNameAsString());
        Assert.assertEquals((long)86400L, (long)columnFamilies[0].getTimeToLive());
        Assert.assertEquals((Object)"B", (Object)columnFamilies[1].getNameAsString());
        Assert.assertEquals((long)86400L, (long)columnFamilies[1].getTimeToLive());
        TestUtil.assertTTLValue(conn, tableName, (TTLExpression)new LiteralTTLExpression(86400));
    }

    @Test
    public void testCreateTableColumnFamilyHBaseAttribs4() throws Exception {
        String tableName = CreateTableIT.generateUniqueName();
        String ddl = "create table IF NOT EXISTS  " + tableName + "  ( id char(1) NOT NULL, col1 integer NOT NULL, b.col2 bigint, col3 bigint,  CONSTRAINT NAME_PK PRIMARY KEY (id, col1) ) b.BLOCKSIZE=50000, SALT_BUCKETS = 4";
        Properties props = new Properties();
        Connection conn = DriverManager.getConnection(CreateTableIT.getUrl(), props);
        conn.createStatement().execute(ddl);
        Admin admin = driver.getConnectionQueryServices(CreateTableIT.getUrl(), props).getAdmin();
        ColumnFamilyDescriptor[] columnFamilies = admin.getDescriptor(TableName.valueOf((String)tableName)).getColumnFamilies();
        Assert.assertEquals((long)2L, (long)columnFamilies.length);
        Assert.assertEquals((Object)"0", (Object)columnFamilies[0].getNameAsString());
        Assert.assertEquals((long)65536L, (long)columnFamilies[0].getBlocksize());
        Assert.assertEquals((Object)"B", (Object)columnFamilies[1].getNameAsString());
        Assert.assertEquals((long)50000L, (long)columnFamilies[1].getBlocksize());
    }

    @Test
    public void testCreateTableColumnFamilyHBaseAttribs5() throws Exception {
        String tableName = CreateTableIT.generateUniqueName();
        String ddl = "create table IF NOT EXISTS  " + tableName + "  ( id char(1) NOT NULL, col1 integer NOT NULL, b.col2 bigint, c.col3 bigint,  CONSTRAINT NAME_PK PRIMARY KEY (id, col1) ) b.BLOCKSIZE=50000, c.BLOCKSIZE=60000, SALT_BUCKETS = 4";
        Properties props = new Properties();
        Connection conn = DriverManager.getConnection(CreateTableIT.getUrl(), props);
        conn.createStatement().execute(ddl);
        Admin admin = driver.getConnectionQueryServices(CreateTableIT.getUrl(), props).getAdmin();
        ColumnFamilyDescriptor[] columnFamilies = admin.getDescriptor(TableName.valueOf((String)tableName)).getColumnFamilies();
        Assert.assertEquals((long)2L, (long)columnFamilies.length);
        Assert.assertEquals((Object)"B", (Object)columnFamilies[0].getNameAsString());
        Assert.assertEquals((long)50000L, (long)columnFamilies[0].getBlocksize());
        Assert.assertEquals((Object)"C", (Object)columnFamilies[1].getNameAsString());
        Assert.assertEquals((long)60000L, (long)columnFamilies[1].getBlocksize());
    }

    @Test
    public void testCreateTableColumnFamilyHBaseAttribs6() throws Exception {
        String tableName = CreateTableIT.generateUniqueName();
        String ddl = "create table IF NOT EXISTS  " + tableName + "  ( id char(1) NOT NULL, col1 integer NOT NULL, col2 bigint, col3 bigint,  CONSTRAINT NAME_PK PRIMARY KEY (id, col1) ) DEFAULT_COLUMN_FAMILY='a', TTL=10000, SALT_BUCKETS = 4";
        Properties props = new Properties();
        Connection conn = DriverManager.getConnection(CreateTableIT.getUrl(), props);
        conn.createStatement().execute(ddl);
        Admin admin = driver.getConnectionQueryServices(CreateTableIT.getUrl(), props).getAdmin();
        ColumnFamilyDescriptor[] columnFamilies = admin.getDescriptor(TableName.valueOf((String)tableName)).getColumnFamilies();
        Assert.assertEquals((long)1L, (long)columnFamilies.length);
        Assert.assertEquals((Object)"a", (Object)columnFamilies[0].getNameAsString());
        Assert.assertEquals((long)10000L, (long)columnFamilies[0].getTimeToLive());
        TestUtil.assertTTLValue(conn, tableName, (TTLExpression)new LiteralTTLExpression(10000));
    }

    @Test
    public void testCreateTableColumnFamilyHBaseAttribs7() throws Exception {
        String tableName = CreateTableIT.generateUniqueName();
        String ddl = "create table IF NOT EXISTS  " + tableName + "  ( id char(1) NOT NULL, col1 integer NOT NULL, CONSTRAINT NAME_PK PRIMARY KEY (id, col1) ) DEFAULT_COLUMN_FAMILY='a', TTL=10000, SALT_BUCKETS = 4";
        Properties props = new Properties();
        Connection conn = DriverManager.getConnection(CreateTableIT.getUrl(), props);
        conn.createStatement().execute(ddl);
        Admin admin = driver.getConnectionQueryServices(CreateTableIT.getUrl(), props).getAdmin();
        ColumnFamilyDescriptor[] columnFamilies = admin.getDescriptor(TableName.valueOf((String)tableName)).getColumnFamilies();
        Assert.assertEquals((long)1L, (long)columnFamilies.length);
        Assert.assertEquals((Object)"a", (Object)columnFamilies[0].getNameAsString());
        Assert.assertEquals((long)10000L, (long)columnFamilies[0].getTimeToLive());
        TestUtil.assertTTLValue(conn, tableName, (TTLExpression)new LiteralTTLExpression(10000));
    }

    @Test
    public void testCreateTableColumnFamilyHBaseAttribs8() throws Exception {
        String tableName = CreateTableIT.generateUniqueName();
        String ddl = "create table IF NOT EXISTS  " + tableName + "  ( id char(1) NOT NULL, col1 integer NOT NULL, col2 bigint NOT NULL, CONSTRAINT NAME_PK PRIMARY KEY (id, col1, col2) ) BLOOMFILTER = 'NONE', SALT_BUCKETS = 4";
        Properties props = new Properties();
        Connection conn = DriverManager.getConnection(CreateTableIT.getUrl(), props);
        conn.createStatement().execute(ddl);
        Admin admin = driver.getConnectionQueryServices(CreateTableIT.getUrl(), props).getAdmin();
        ColumnFamilyDescriptor[] columnFamilies = admin.getDescriptor(TableName.valueOf((String)tableName)).getColumnFamilies();
        Assert.assertEquals((Object)BloomType.NONE, (Object)columnFamilies[0].getBloomFilterType());
    }

    @Test
    public void testNotNullConstraintForNonPKColumn() throws Exception {
        String tableName = CreateTableIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + " (  ORGANIZATION_ID CHAR(15) NOT NULL,  EVENT_TIME DATE NOT NULL, USER_ID CHAR(15) NOT NULL,  ENTRY_POINT_ID CHAR(15) NOT NULL, ENTRY_POINT_TYPE CHAR(2) NOT NULL ,  APEX_LIMIT_ID CHAR(15) NOT NULL,  USERNAME CHAR(80),   NAMESPACE_PREFIX VARCHAR, ENTRY_POINT_NAME VARCHAR  NOT NULL ,  EXECUTION_UNIT_NO VARCHAR, LIMIT_TYPE VARCHAR,  LIMIT_VALUE DOUBLE   CONSTRAINT PK PRIMARY KEY (     ORGANIZATION_ID, EVENT_TIME,USER_ID,ENTRY_POINT_ID, ENTRY_POINT_TYPE, APEX_LIMIT_ID  ) ) VERSIONS=1";
        Properties props = new Properties();
        Connection conn = DriverManager.getConnection(CreateTableIT.getUrl(), props);
        try {
            conn.createStatement().execute(ddl);
            Assert.fail((String)" Non pk column ENTRY_POINT_NAME has a NOT NULL constraint");
        }
        catch (SQLException sqle) {
            Assert.assertEquals((long)SQLExceptionCode.KEY_VALUE_NOT_NULL.getErrorCode(), (long)sqle.getErrorCode());
        }
    }

    @Test
    public void testNotNullConstraintForWithSinglePKCol() throws Exception {
        String tableName = CreateTableIT.generateUniqueName();
        String ddl = "create table  " + tableName + " (k integer primary key, v bigint not null)";
        Properties props = new Properties();
        Connection conn = DriverManager.getConnection(CreateTableIT.getUrl(), props);
        try {
            conn.createStatement().execute(ddl);
            Assert.fail((String)" Non pk column V has a NOT NULL constraint");
        }
        catch (SQLException sqle) {
            Assert.assertEquals((long)SQLExceptionCode.KEY_VALUE_NOT_NULL.getErrorCode(), (long)sqle.getErrorCode());
        }
    }

    @Test
    public void testSpecifyingColumnFamilyForTTLFails() throws Exception {
        String tableName = CreateTableIT.generateUniqueName();
        String ddl = "create table IF NOT EXISTS  " + tableName + "  ( id char(1) NOT NULL, col1 integer NOT NULL, CF.col2 integer, CONSTRAINT NAME_PK PRIMARY KEY (id, col1) ) DEFAULT_COLUMN_FAMILY='a', CF.TTL=10000, SALT_BUCKETS = 4";
        Properties props = new Properties();
        Connection conn = DriverManager.getConnection(CreateTableIT.getUrl(), props);
        try {
            conn.createStatement().execute(ddl);
        }
        catch (SQLException sqle) {
            Assert.assertEquals((long)SQLExceptionCode.COLUMN_FAMILY_NOT_ALLOWED_FOR_PROPERTY.getErrorCode(), (long)sqle.getErrorCode());
        }
    }

    @Test
    public void testCreateTableWithoutSchema() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.setProperty("phoenix.schema.isNamespaceMappingEnabled", Boolean.toString(true));
        String schemaName = CreateTableIT.generateUniqueName();
        String createSchemaDDL = "CREATE SCHEMA " + schemaName;
        String tableName = CreateTableIT.generateUniqueName();
        String createTableDDL = "CREATE TABLE " + schemaName + "." + tableName + " (pk INTEGER PRIMARY KEY)";
        String dropTableDDL = "DROP TABLE " + schemaName + "." + tableName;
        try (Connection conn = DriverManager.getConnection(CreateTableIT.getUrl(), props);){
            try {
                conn.createStatement().execute(createTableDDL);
                Assert.fail();
            }
            catch (SchemaNotFoundException schemaNotFoundException) {
                // empty catch block
            }
            conn.createStatement().execute(createSchemaDDL);
        }
        conn = DriverManager.getConnection(CreateTableIT.getUrl(), props);
        var8_9 = null;
        try {
            conn.createStatement().execute(createTableDDL);
        }
        catch (Throwable throwable) {
            var8_9 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var8_9 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var8_9.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = DriverManager.getConnection(CreateTableIT.getUrl(), props);
        var8_9 = null;
        try {
            conn.createStatement().execute(dropTableDDL);
        }
        catch (Throwable throwable) {
            var8_9 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var8_9 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var8_9.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
        props.setProperty("phoenix.schema.isNamespaceMappingEnabled", Boolean.toString(false));
        try {
            conn = DriverManager.getConnection(CreateTableIT.getUrl(), props);
            var8_9 = null;
            try {
                conn.createStatement().execute(createTableDDL);
            }
            catch (Throwable throwable) {
                var8_9 = throwable;
                throw throwable;
            }
            finally {
                if (conn != null) {
                    if (var8_9 != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable) {
                            var8_9.addSuppressed(throwable);
                        }
                    } else {
                        conn.close();
                    }
                }
            }
        }
        catch (SchemaNotFoundException e) {
            Assert.fail();
        }
    }

    @Test
    public void testCreateTableIfNotExistsForEncodedColumnNames() throws Exception {
        ResultSet rs2;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = CreateTableIT.generateUniqueName();
        String createTableDDL = "CREATE TABLE IF NOT EXISTS " + tableName + " (pk INTEGER PRIMARY KEY)";
        try (Connection conn = DriverManager.getConnection(CreateTableIT.getUrl(), props);){
            conn.createStatement().execute(createTableDDL);
            this.assertColumnEncodingMetadata(PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, tableName, conn);
        }
        conn = DriverManager.getConnection(CreateTableIT.getUrl(), props);
        var5_5 = null;
        try {
            conn.createStatement().execute(createTableDDL);
            rs2 = conn.createStatement().executeQuery("SELECT * FROM " + tableName);
            Assert.assertFalse((boolean)rs2.next());
            this.assertColumnEncodingMetadata(PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, tableName, conn);
        }
        catch (Throwable rs2) {
            var5_5 = rs2;
            throw rs2;
        }
        finally {
            if (conn != null) {
                if (var5_5 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable rs2) {
                        var5_5.addSuppressed(rs2);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = DriverManager.getConnection(CreateTableIT.getUrl(), props);
        var5_5 = null;
        try {
            conn.createStatement().execute(createTableDDL + " COLUMN_ENCODED_BYTES = 1");
            rs2 = conn.createStatement().executeQuery("SELECT * FROM " + tableName);
            Assert.assertFalse((boolean)rs2.next());
            this.assertColumnEncodingMetadata(PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, tableName, conn);
        }
        catch (Throwable rs3) {
            var5_5 = rs3;
            throw rs3;
        }
        finally {
            if (conn != null) {
                if (var5_5 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable rs3) {
                        var5_5.addSuppressed(rs3);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = DriverManager.getConnection(CreateTableIT.getUrl(), props);
        var5_5 = null;
        try {
            conn.createStatement().execute(createTableDDL + " COLUMN_ENCODED_BYTES = 0");
            rs2 = conn.createStatement().executeQuery("SELECT * FROM " + tableName);
            Assert.assertFalse((boolean)rs2.next());
            this.assertColumnEncodingMetadata(PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, tableName, conn);
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var5_5 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    private void assertColumnEncodingMetadata(PTable.QualifierEncodingScheme expectedEncodingScheme, PTable.ImmutableStorageScheme expectedStorageScheme, String tableName, Connection conn) throws Exception {
        PhoenixConnection phxConn = conn.unwrap(PhoenixConnection.class);
        PTable table = phxConn.getTable(new PTableKey(null, tableName));
        Assert.assertEquals((Object)expectedEncodingScheme, (Object)table.getEncodingScheme());
        Assert.assertEquals((Object)expectedStorageScheme, (Object)table.getImmutableStorageScheme());
    }

    @Test
    public void testMultiTenantImmutableTableMetadata() throws Exception {
        String createTableDDL;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String nonEncodedOneCellPerColumnMultiTenantTable = CreateTableIT.generateUniqueName();
        String twoByteQualifierEncodedOneCellPerColumnMultiTenantTable = CreateTableIT.generateUniqueName();
        String oneByteQualifierEncodedOneCellPerColumnMultiTenantTable = CreateTableIT.generateUniqueName();
        String twoByteQualifierSingleCellArrayWithOffsetsMultitenantTable = CreateTableIT.generateUniqueName();
        String oneByteQualifierSingleCellArrayWithOffsetsMultitenantTable = CreateTableIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(CreateTableIT.getUrl(), props);){
            createTableDDL = "create IMMUTABLE TABLE " + nonEncodedOneCellPerColumnMultiTenantTable + " ( id char(1) NOT NULL, col1 integer NOT NULL, col2 bigint NOT NULL, CONSTRAINT NAME_PK PRIMARY KEY (id, col1, col2)) MULTI_TENANT=true, COLUMN_ENCODED_BYTES=0";
            conn.createStatement().execute(createTableDDL);
            this.assertColumnEncodingMetadata(PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, nonEncodedOneCellPerColumnMultiTenantTable, conn);
        }
        props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        conn = DriverManager.getConnection(CreateTableIT.getUrl(), props);
        var9_8 = null;
        try {
            createTableDDL = "create IMMUTABLE table " + twoByteQualifierEncodedOneCellPerColumnMultiTenantTable + " ( id char(1) NOT NULL, col1 integer NOT NULL, col2 bigint NOT NULL, CONSTRAINT NAME_PK PRIMARY KEY (id, col1, col2)) MULTI_TENANT=true";
            conn.createStatement().execute(createTableDDL);
            this.assertColumnEncodingMetadata(PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, twoByteQualifierEncodedOneCellPerColumnMultiTenantTable, conn);
        }
        catch (Throwable throwable) {
            var9_8 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var9_8 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var9_8.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
        props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        conn = DriverManager.getConnection(CreateTableIT.getUrl(), props);
        var9_8 = null;
        try {
            createTableDDL = "create IMMUTABLE table " + oneByteQualifierEncodedOneCellPerColumnMultiTenantTable + " ( id char(1) NOT NULL, col1 integer NOT NULL, col2 bigint NOT NULL, CONSTRAINT NAME_PK PRIMARY KEY (id, col1, col2)) MULTI_TENANT=true, COLUMN_ENCODED_BYTES = 1";
            conn.createStatement().execute(createTableDDL);
            this.assertColumnEncodingMetadata(PTable.QualifierEncodingScheme.ONE_BYTE_QUALIFIERS, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, oneByteQualifierEncodedOneCellPerColumnMultiTenantTable, conn);
        }
        catch (Throwable throwable) {
            var9_8 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var9_8 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var9_8.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
        props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        conn = DriverManager.getConnection(CreateTableIT.getUrl(), props);
        var9_8 = null;
        try {
            createTableDDL = "create IMMUTABLE table " + twoByteQualifierSingleCellArrayWithOffsetsMultitenantTable + " ( id char(1) NOT NULL, col1 integer NOT NULL, col2 bigint NOT NULL, CONSTRAINT NAME_PK PRIMARY KEY (id, col1, col2)) MULTI_TENANT=true, IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS";
            conn.createStatement().execute(createTableDDL);
            this.assertColumnEncodingMetadata(PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS, PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS, twoByteQualifierSingleCellArrayWithOffsetsMultitenantTable, conn);
        }
        catch (Throwable throwable) {
            var9_8 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var9_8 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var9_8.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
        props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        conn = DriverManager.getConnection(CreateTableIT.getUrl(), props);
        var9_8 = null;
        try {
            createTableDDL = "create IMMUTABLE table " + oneByteQualifierSingleCellArrayWithOffsetsMultitenantTable + " ( id char(1) NOT NULL, col1 integer NOT NULL, col2 bigint NOT NULL, CONSTRAINT NAME_PK PRIMARY KEY (id, col1, col2)) MULTI_TENANT=true, IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS, COLUMN_ENCODED_BYTES=1";
            conn.createStatement().execute(createTableDDL);
            this.assertColumnEncodingMetadata(PTable.QualifierEncodingScheme.ONE_BYTE_QUALIFIERS, PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS, oneByteQualifierSingleCellArrayWithOffsetsMultitenantTable, conn);
        }
        catch (Throwable throwable) {
            var9_8 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var9_8 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var9_8.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test
    public void testCreateChangeDetectionEnabledTable() throws Exception {
        String schemaName = CreateTableIT.generateUniqueName();
        String tableName = CreateTableIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        try (PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(CreateTableIT.getUrl());){
            String ddl = "CREATE TABLE " + fullTableName + " (id char(1) NOT NULL, col1 integer NOT NULL, col2 bigint NOT NULL, CONSTRAINT NAME_PK PRIMARY KEY (id, col1, col2)) CHANGE_DETECTION_ENABLED=true";
            conn.createStatement().execute(ddl);
            PTable table = conn.getTableNoCache(fullTableName);
            Assert.assertTrue((boolean)table.isChangeDetectionEnabled());
            AlterTableIT.verifySchemaExport(table, CreateTableIT.getUtility().getConfiguration());
        }
    }

    @Test
    public void testCreateIndexWithDifferentStorageAndEncoding() throws Exception {
        this.verifyIndexSchemeChange(false, false);
        this.verifyIndexSchemeChange(false, true);
        this.verifyIndexSchemeChange(true, false);
        this.verifyIndexSchemeChange(true, true);
        String tableName = CreateTableIT.generateUniqueName();
        String indexName = CreateTableIT.generateUniqueName();
        String createTableDDL = "create IMMUTABLE TABLE " + tableName + "(id char(1) NOT NULL, col1 char(1), col2 char(1) CONSTRAINT NAME_PK PRIMARY KEY (id)) IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS";
        String createIndexDDL = "create INDEX " + indexName + " ON " + tableName + " (col1) INCLUDE (col2) IMMUTABLE_STORAGE_SCHEME=ONE_CELL_PER_COLUMN";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(CreateTableIT.getUrl(), props);){
            conn.createStatement().execute(createTableDDL);
            this.assertColumnEncodingMetadata(PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS, PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS, tableName, conn);
            boolean failed = false;
            try {
                conn.createStatement().execute(createIndexDDL);
            }
            catch (SQLException e) {
                Assert.assertEquals((long)e.getErrorCode(), (long)SQLExceptionCode.INVALID_IMMUTABLE_STORAGE_SCHEME_CHANGE.getErrorCode());
                failed = true;
            }
            Assert.assertEquals((Object)true, (Object)failed);
        }
    }

    private void verifyIndexSchemeChange(boolean immutable, boolean multiTenant) throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String nonEncodedOneCellPerColumnTable = CreateTableIT.generateUniqueName();
        String createTableBaseDDL = "create " + (immutable ? " IMMUTABLE " : "") + " TABLE %s ( id char(1) NOT NULL, col1 integer NOT NULL, col2 bigint NOT NULL, CONSTRAINT NAME_PK PRIMARY KEY (id, col1, col2)) MULTI_TENANT=" + (multiTenant ? "true," : "false,");
        String createIndexBaseDDL = "create index %s ON %s (col1) INCLUDE (col2) ";
        try (Connection conn = DriverManager.getConnection(CreateTableIT.getUrl(), props);){
            String createTableDDL = String.format(createTableBaseDDL, nonEncodedOneCellPerColumnTable);
            createTableDDL = createTableDDL + "IMMUTABLE_STORAGE_SCHEME=ONE_CELL_PER_COLUMN, COLUMN_ENCODED_BYTES=0";
            conn.createStatement().execute(createTableDDL);
            this.assertColumnEncodingMetadata(PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, nonEncodedOneCellPerColumnTable, conn);
            String idxName = "IDX_" + CreateTableIT.generateUniqueName();
            String createIndexDDL = String.format(createIndexBaseDDL, idxName, nonEncodedOneCellPerColumnTable);
            conn.createStatement().execute(createIndexDDL);
            this.assertColumnEncodingMetadata(PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, idxName, conn);
            idxName = "IDX_" + CreateTableIT.generateUniqueName();
            createIndexDDL = String.format(createIndexBaseDDL, idxName, nonEncodedOneCellPerColumnTable);
            createIndexDDL = createIndexDDL + "IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS";
            conn.createStatement().execute(createIndexDDL);
            this.assertColumnEncodingMetadata(PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS, PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS, idxName, conn);
            idxName = "IDX_" + CreateTableIT.generateUniqueName();
            createIndexDDL = String.format(createIndexBaseDDL, idxName, nonEncodedOneCellPerColumnTable);
            createIndexDDL = createIndexDDL + "IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS, COLUMN_ENCODED_BYTES=3";
            conn.createStatement().execute(createIndexDDL);
            this.assertColumnEncodingMetadata(PTable.QualifierEncodingScheme.THREE_BYTE_QUALIFIERS, PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS, idxName, conn);
            createIndexDDL = String.format(createIndexBaseDDL, idxName, nonEncodedOneCellPerColumnTable);
            createIndexDDL = createIndexDDL + "IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS, COLUMN_ENCODED_BYTES=0";
            boolean failed = false;
            try {
                conn.createStatement().execute(createIndexDDL);
            }
            catch (SQLException e) {
                failed = true;
                Assert.assertEquals((long)SQLExceptionCode.INVALID_IMMUTABLE_STORAGE_SCHEME_AND_COLUMN_QUALIFIER_BYTES.getErrorCode(), (long)e.getErrorCode());
            }
            Assert.assertEquals((Object)true, (Object)failed);
        }
    }

    private void verifyUCFValueInSysCat(String tableName, String createTableString, Properties props, long expectedUCFInSysCat) throws SQLException {
        String readSysCatQuery = "SELECT TABLE_NAME, UPDATE_CACHE_FREQUENCY FROM SYSTEM.CATALOG WHERE TABLE_NAME = '" + tableName + "'  AND TABLE_TYPE='u'";
        try (Connection connection = DriverManager.getConnection(CreateTableIT.getUrl(), props);
             Statement stmt = connection.createStatement();){
            stmt.execute(createTableString);
            try (ResultSet rs = stmt.executeQuery(readSysCatQuery);){
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((long)expectedUCFInSysCat, (long)rs.getLong(2));
            }
            stmt.execute("drop table " + tableName);
        }
    }

    @Test
    public void testCreateTableNoUpdateCacheFreq() throws Exception {
        String tableName = CreateTableIT.generateUniqueName();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String createTableString = "CREATE TABLE " + tableName + " (k VARCHAR PRIMARY KEY, v1 VARCHAR, v2 VARCHAR)";
        this.verifyUCFValueInSysCat(tableName, createTableString, props, QueryServicesOptions.DEFAULT_UPDATE_CACHE_FREQUENCY);
    }

    @Test
    public void testCreateTableWithTableLevelUpdateCacheFreq() throws Exception {
        String tableName = CreateTableIT.generateUniqueName();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        HashMap<String, Long> expectedUCF = new HashMap<String, Long>();
        expectedUCF.put("10", new Long(10L));
        expectedUCF.put("0", new Long(0L));
        expectedUCF.put("10000", new Long(10000L));
        expectedUCF.put("ALWAYS", new Long(0L));
        expectedUCF.put("NEVER", new Long(Long.MAX_VALUE));
        for (Map.Entry entry : expectedUCF.entrySet()) {
            String tableLevelUCF = (String)entry.getKey();
            long expectedUCFInSysCat = (Long)entry.getValue();
            String createTableString = "CREATE TABLE " + tableName + " (k VARCHAR PRIMARY KEY,v1 VARCHAR, v2 VARCHAR) UPDATE_CACHE_FREQUENCY = " + tableLevelUCF;
            this.verifyUCFValueInSysCat(tableName, createTableString, props, expectedUCFInSysCat);
        }
    }

    @Test
    public void testCreateTableWithInvalidTableUpdateCacheFreqShouldThrow() throws Exception {
        String tableName = CreateTableIT.generateUniqueName();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        ArrayList<String> invalidUCF = new ArrayList<String>();
        invalidUCF.add("GIBBERISH");
        invalidUCF.add("10000.6");
        for (String tableLevelUCF : invalidUCF) {
            String createTableString = "CREATE TABLE " + tableName + " (k VARCHAR PRIMARY KEY,v1 VARCHAR, v2 VARCHAR) UPDATE_CACHE_FREQUENCY = " + tableLevelUCF;
            try {
                this.verifyUCFValueInSysCat(tableName, createTableString, props, -1L);
                Assert.fail();
            }
            catch (IllegalArgumentException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("Table's UPDATE_CACHE_FREQUENCY"));
            }
        }
    }

    @Test
    public void testCreateTableWithConnLevelUpdateCacheFreq() throws Exception {
        String tableName = CreateTableIT.generateUniqueName();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        HashMap<String, Long> expectedUCF = new HashMap<String, Long>();
        expectedUCF.put("10", new Long(10L));
        expectedUCF.put("0", new Long(0L));
        expectedUCF.put("10000", new Long(10000L));
        expectedUCF.put("ALWAYS", new Long(0L));
        expectedUCF.put("NEVER", new Long(Long.MAX_VALUE));
        for (Map.Entry entry : expectedUCF.entrySet()) {
            String connLevelUCF = (String)entry.getKey();
            long expectedUCFInSysCat = (Long)entry.getValue();
            String createTableString = "CREATE TABLE " + tableName + " (k VARCHAR PRIMARY KEY,v1 VARCHAR, v2 VARCHAR)";
            props.put("phoenix.default.update.cache.frequency", connLevelUCF);
            this.verifyUCFValueInSysCat(tableName, createTableString, props, expectedUCFInSysCat);
        }
    }

    @Test
    public void testCreateTableWithNamespaceMappingEnabled() throws Exception {
        String NS = "NS_" + CreateTableIT.generateUniqueName();
        String TBL = "TBL_" + CreateTableIT.generateUniqueName();
        String CF = "CF";
        Properties props = new Properties();
        props.setProperty("phoenix.schema.isNamespaceMappingEnabled", Boolean.TRUE.toString());
        try (Connection conn = DriverManager.getConnection(CreateTableIT.getUrl(), props);){
            conn.createStatement().execute("CREATE SCHEMA " + NS);
            String table = NS + "." + TBL;
            conn.createStatement().execute("CREATE TABLE " + table + " (PK VARCHAR PRIMARY KEY, " + "CF" + ".COL VARCHAR)");
            Assert.assertTrue((boolean)QueryUtil.getExplainPlan((ResultSet)conn.createStatement().executeQuery("explain select * from " + table)).contains(NS + ":" + TBL));
            conn.createStatement().execute("DROP TABLE " + table);
            table = "\"" + NS + "." + TBL + "\"";
            conn.createStatement().execute("CREATE TABLE " + table + " (PK VARCHAR PRIMARY KEY, " + "CF" + ".COL VARCHAR)");
            Assert.assertTrue((boolean)QueryUtil.getExplainPlan((ResultSet)conn.createStatement().executeQuery("explain select * from " + table)).contains(NS + "." + TBL));
            conn.createStatement().execute("DROP TABLE " + table);
            table = NS + ".\"" + NS + "." + TBL + "\"";
            conn.createStatement().execute("CREATE TABLE " + table + " (PK VARCHAR PRIMARY KEY, " + "CF" + ".COL VARCHAR)");
            Assert.assertTrue((boolean)QueryUtil.getExplainPlan((ResultSet)conn.createStatement().executeQuery("explain select * from " + table)).contains(NS + ":" + NS + "." + TBL));
            conn.createStatement().execute("DROP TABLE " + table);
            conn.createStatement().execute("DROP SCHEMA " + NS);
        }
    }

    @Test
    public void testSetTableDescriptorPropertyOnView() throws Exception {
        Properties props = new Properties();
        String dataTableFullName = CreateTableIT.generateUniqueName();
        String ddl = "CREATE TABLE " + dataTableFullName + " (\nID1 VARCHAR(15) NOT NULL,\nID2 VARCHAR(15) NOT NULL,\nCREATED_DATE DATE,\nCREATION_TIME BIGINT,\nLAST_USED DATE,\nCONSTRAINT PK PRIMARY KEY (ID1, ID2)) ";
        Connection conn1 = DriverManager.getConnection(CreateTableIT.getUrl(), props);
        conn1.createStatement().execute(ddl);
        conn1.close();
        String viewFullName = CreateTableIT.generateUniqueName();
        Connection conn2 = DriverManager.getConnection(CreateTableIT.getUrl(), props);
        ddl = "CREATE VIEW " + viewFullName + " AS SELECT * FROM " + dataTableFullName + " WHERE CREATION_TIME = 1 THROW_INDEX_WRITE_FAILURE = FALSE";
        try {
            conn2.createStatement().execute(ddl);
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.VIEW_WITH_PROPERTIES.getErrorCode(), (long)e.getErrorCode());
        }
        conn2.close();
    }

    @Test
    public void testCreateViewFromNonExistentTable() throws Exception {
        try (Connection conn = DriverManager.getConnection(CreateTableIT.getUrl());){
            conn.createStatement().execute("CREATE TABLE IF NOT EXISTS S.T1 (A INTEGER PRIMARY KEY, B INTEGER)");
            try {
                conn.createStatement().execute("CREATE VIEW IF NOT EXISTS V1(C INTEGER) AS SELECT * FROM T2");
                Assert.fail((String)"Creating view on non-existent table should have failed");
            }
            catch (TableNotFoundException e) {
                Assert.assertEquals((Object)"T2", (Object)e.getTableName());
                Assert.assertEquals((Object)"", (Object)e.getSchemaName());
                Assert.assertEquals((Object)"ERROR 1012 (42M03): Table undefined. tableName=T2", (Object)e.getMessage());
            }
            conn.createStatement().execute("CREATE VIEW IF NOT EXISTS V1(C INTEGER) AS SELECT * FROM S.T1");
            try {
                conn.createStatement().execute("CREATE VIEW IF NOT EXISTS V2(C INTEGER) AS SELECT * FROM S.T2");
                Assert.fail((String)"Creating view on non-existent table should have failed");
            }
            catch (TableNotFoundException e) {
                Assert.assertEquals((Object)"T2", (Object)e.getTableName());
                Assert.assertEquals((Object)"S", (Object)e.getSchemaName());
                Assert.assertEquals((Object)"ERROR 1012 (42M03): Table undefined. tableName=S.T2", (Object)e.getMessage());
            }
        }
    }

    @Test
    public void testSettingGuidePostWidth() throws Exception {
        try (Connection conn = DriverManager.getConnection(CreateTableIT.getUrl());){
            String dataTable = CreateTableIT.generateUniqueName();
            int guidePostWidth = 20;
            String ddl = "CREATE TABLE " + dataTable + " (k INTEGER PRIMARY KEY, a bigint, b bigint) GUIDE_POSTS_WIDTH=" + guidePostWidth;
            conn.createStatement().execute(ddl);
            Assert.assertEquals((long)20L, (long)this.checkGuidePostWidth(dataTable));
            String viewName = "V_" + CreateTableIT.generateUniqueName();
            ddl = "CREATE VIEW " + viewName + " AS SELECT * FROM " + dataTable + " GUIDE_POSTS_WIDTH=" + guidePostWidth;
            try {
                conn.createStatement().execute(ddl);
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.CANNOT_SET_GUIDE_POST_WIDTH.getErrorCode(), (long)e.getErrorCode());
            }
            ddl = "CREATE VIEW " + viewName + " AS SELECT * FROM " + dataTable;
            conn.createStatement().execute(ddl);
            String globalIndex = "GI_" + CreateTableIT.generateUniqueName();
            ddl = "CREATE INDEX " + globalIndex + " ON " + dataTable + "(a) INCLUDE (b) GUIDE_POSTS_WIDTH = " + guidePostWidth;
            try {
                conn.createStatement().execute(ddl);
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.CANNOT_SET_GUIDE_POST_WIDTH.getErrorCode(), (long)e.getErrorCode());
            }
            String localIndex = "LI_" + CreateTableIT.generateUniqueName();
            ddl = "CREATE LOCAL INDEX " + localIndex + " ON " + dataTable + "(b) INCLUDE (a) GUIDE_POSTS_WIDTH = " + guidePostWidth;
            try {
                conn.createStatement().execute(ddl);
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.CANNOT_SET_GUIDE_POST_WIDTH.getErrorCode(), (long)e.getErrorCode());
            }
            String viewIndex = "VI_" + CreateTableIT.generateUniqueName();
            ddl = "CREATE LOCAL INDEX " + viewIndex + " ON " + dataTable + "(b) INCLUDE (a) GUIDE_POSTS_WIDTH = " + guidePostWidth;
            try {
                conn.createStatement().execute(ddl);
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.CANNOT_SET_GUIDE_POST_WIDTH.getErrorCode(), (long)e.getErrorCode());
            }
        }
    }

    @Test
    public void testTableDescriptorPriority() throws SQLException, IOException {
        String tableName = "TBL_" + CreateTableIT.generateUniqueName();
        String indexName = "IND_" + CreateTableIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)"S", (String)tableName);
        String fullIndexeName = SchemaUtil.getTableName((String)"S", (String)indexName);
        try (Admin admin = driver.getConnectionQueryServices(CreateTableIT.getUrl(), new Properties()).getAdmin();
             Connection c = DriverManager.getConnection(CreateTableIT.getUrl());){
            Object htd;
            ResultSet rs = c.getMetaData().getTables("", "\"SYSTEM\"", null, new String[]{PTableType.SYSTEM.toString()});
            ReadOnlyProps p = c.unwrap(PhoenixConnection.class).getQueryServices().getProps();
            while (rs.next()) {
                String schemaName = rs.getString("TABLE_SCHEM");
                String tName = rs.getString("TABLE_NAME");
                TableName hbaseTableName = SchemaUtil.getPhysicalTableName((String)SchemaUtil.getTableName((String)schemaName, (String)tName), (ReadOnlyProps)p);
                htd = admin.getDescriptor(hbaseTableName);
                String val = htd.getValue("PRIORITY");
                Assert.assertNotNull((String)("PRIORITY is not set for table:" + htd), (Object)val);
                Assert.assertTrue((Integer.parseInt(val) >= IndexUtil.getMetadataPriority((Configuration)config) ? 1 : 0) != 0);
            }
            Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
            String ddl = "CREATE TABLE " + fullTableName + "(   varchar_pk VARCHAR NOT NULL,    char_pk CHAR(10) NOT NULL,    int_pk INTEGER NOT NULL,    long_pk BIGINT NOT NULL,    decimal_pk DECIMAL(31, 10) NOT NULL,    date_pk DATE NOT NULL,    a.varchar_col1 VARCHAR,    a.char_col1 CHAR(10),    a.int_col1 INTEGER,    a.long_col1 BIGINT,    a.decimal_col1 DECIMAL(31, 10),    a.date1 DATE,    b.varchar_col2 VARCHAR,    b.char_col2 CHAR(10),    b.int_col2 INTEGER,    b.long_col2 BIGINT,    b.decimal_col2 DECIMAL(31, 10),    b.date2 DATE    CONSTRAINT pk PRIMARY KEY (varchar_pk, char_pk, int_pk, long_pk DESC, decimal_pk, date_pk)) ";
            Connection conn = DriverManager.getConnection(CreateTableIT.getUrl(), props);
            htd = null;
            try {
                conn.setAutoCommit(false);
                Statement stmt = conn.createStatement();
                stmt.execute(ddl);
                BaseTest.populateTestTable(fullTableName);
                ddl = "CREATE INDEX " + indexName + " ON " + fullTableName + " (long_col1, long_col2) INCLUDE (decimal_col1, decimal_col2)";
                stmt.execute(ddl);
            }
            catch (Throwable stmt) {
                htd = stmt;
                throw stmt;
            }
            finally {
                if (conn != null) {
                    if (htd != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable stmt) {
                            ((Throwable)htd).addSuppressed(stmt);
                        }
                    } else {
                        conn.close();
                    }
                }
            }
            TableDescriptor dataTable = admin.getDescriptor(TableName.valueOf((String)fullTableName));
            String val = dataTable.getValue("PRIORITY");
            Assert.assertTrue((val == null || Integer.parseInt(val) < 200 ? 1 : 0) != 0);
            TableDescriptor indexTable = admin.getDescriptor(TableName.valueOf((String)fullIndexeName));
            val = indexTable.getValue("PRIORITY");
            Assert.assertNotNull((String)("PRIORITY is not set for table:" + indexTable), (Object)val);
            Assert.assertTrue((Integer.parseInt(val) >= IndexUtil.getIndexPriority((Configuration)config) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testCreateTableSchemaVersionAndTopicName() throws Exception {
        Properties props = new Properties();
        String schemaName = CreateTableIT.generateUniqueName();
        String tableName = CreateTableIT.generateUniqueName();
        String version = "V1.0";
        String topicName = "MyTopicName";
        try (Connection conn = DriverManager.getConnection(CreateTableIT.getUrl(), props);){
            CreateTableIT.testCreateTableSchemaVersionAndTopicNameHelper(conn, schemaName, tableName, "V1.0", "MyTopicName");
        }
    }

    public static void testCreateTableSchemaVersionAndTopicNameHelper(Connection conn, String schemaName, String tableName, String dataTableVersion, String topicName) throws Exception {
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        String ddl = "CREATE TABLE " + dataTableFullName + " (\nID1 VARCHAR(15) NOT NULL,\nID2 VARCHAR(15) NOT NULL,\nCREATED_DATE DATE,\nCREATION_TIME BIGINT,\nLAST_USED DATE,\nCONSTRAINT PK PRIMARY KEY (ID1, ID2)) SCHEMA_VERSION='" + dataTableVersion + "'";
        if (topicName != null) {
            ddl = ddl + ", STREAMING_TOPIC_NAME='" + topicName + "'";
        }
        conn.createStatement().execute(ddl);
        PTable table = conn.unwrap(PhoenixConnection.class).getTableNoCache(dataTableFullName);
        Assert.assertEquals((Object)dataTableVersion, (Object)table.getSchemaVersion());
        if (topicName != null) {
            Assert.assertEquals((Object)topicName, (Object)table.getStreamingTopicName());
        } else {
            Assert.assertNull((Object)table.getStreamingTopicName());
        }
    }

    @Test
    public void testCreateTableDDLTimestamp() throws Exception {
        Properties props = new Properties();
        String schemaName = CreateTableIT.generateUniqueName();
        String tableName = CreateTableIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        String ddl = "CREATE TABLE " + dataTableFullName + " (\nID1 VARCHAR(15) NOT NULL,\nID2 VARCHAR(15) NOT NULL,\nCREATED_DATE DATE,\nCREATION_TIME BIGINT,\nLAST_USED DATE,\nCONSTRAINT PK PRIMARY KEY (ID1, ID2)) ";
        long startTS = EnvironmentEdgeManager.currentTimeMillis();
        try (Connection conn = DriverManager.getConnection(CreateTableIT.getUrl(), props);){
            conn.createStatement().execute(ddl);
            CreateTableIT.verifyLastDDLTimestamp(dataTableFullName, startTS, conn);
        }
    }

    @Test
    public void testCreateTableWithColumnQualifiers() throws Exception {
        Properties props = new Properties();
        Connection conn = DriverManager.getConnection(CreateTableIT.getUrl(), props);
        String tableName = CreateTableIT.generateUniqueName();
        String ddl = "CREATE TABLE \"" + tableName + "\"(K VARCHAR NOT NULL PRIMARY KEY, INT INTEGER ENCODED_QUALIFIER 11, INT2 INTEGER ENCODED_QUALIFIER 12, INT3 INTEGER ENCODED_QUALIFIER 14) COLUMN_QUALIFIER_COUNTER ('" + "0" + "'=15)";
        conn.createStatement().execute(ddl);
        PhoenixConnection pconn = conn.unwrap(PhoenixConnection.class);
        PTable table = pconn.getTable(new PTableKey(null, tableName));
        PTable.QualifierEncodingScheme encodingScheme = table.getEncodingScheme();
        Assert.assertNotEquals((Object)PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, (Object)encodingScheme);
        PTable.EncodedCQCounter cqCounter = table.getEncodedCQCounter();
        Assert.assertEquals((long)15L, (long)((Integer)cqCounter.values().get("0")).intValue());
        Assert.assertEquals((long)11L, (long)encodingScheme.decode(table.getColumnForColumnName("INT").getColumnQualifierBytes()));
        Assert.assertEquals((long)12L, (long)encodingScheme.decode(table.getColumnForColumnName("INT2").getColumnQualifierBytes()));
        Assert.assertEquals((long)14L, (long)encodingScheme.decode(table.getColumnForColumnName("INT3").getColumnQualifierBytes()));
    }

    @Test
    public void testCreateTableWithNotOrderedColumnQualifiers() throws Exception {
        Properties props = new Properties();
        Connection conn = DriverManager.getConnection(CreateTableIT.getUrl(), props);
        String tableName = CreateTableIT.generateUniqueName();
        String ddl = "CREATE TABLE \"" + tableName + "\"(K VARCHAR NOT NULL PRIMARY KEY, INT3 INTEGER ENCODED_QUALIFIER 14, INT INTEGER ENCODED_QUALIFIER 11, INT2 INTEGER ENCODED_QUALIFIER 12) COLUMN_QUALIFIER_COUNTER ('" + "0" + "'=15)";
        conn.createStatement().execute(ddl);
        PhoenixConnection pconn = conn.unwrap(PhoenixConnection.class);
        PTable table = pconn.getTable(new PTableKey(null, tableName));
        PTable.QualifierEncodingScheme encodingScheme = table.getEncodingScheme();
        Assert.assertNotEquals((Object)PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, (Object)encodingScheme);
        PTable.EncodedCQCounter cqCounter = table.getEncodedCQCounter();
        Assert.assertEquals((long)15L, (long)((Integer)cqCounter.values().get("0")).intValue());
        Assert.assertEquals((long)11L, (long)encodingScheme.decode(table.getColumnForColumnName("INT").getColumnQualifierBytes()));
        Assert.assertEquals((long)12L, (long)encodingScheme.decode(table.getColumnForColumnName("INT2").getColumnQualifierBytes()));
        Assert.assertEquals((long)14L, (long)encodingScheme.decode(table.getColumnForColumnName("INT3").getColumnQualifierBytes()));
    }

    @Test
    public void testCreateTableWithColumnQualifiersWithoutCounter() throws Exception {
        Properties props = new Properties();
        Connection conn = DriverManager.getConnection(CreateTableIT.getUrl(), props);
        String tableName = CreateTableIT.generateUniqueName();
        String ddl = "CREATE TABLE \"" + tableName + "\"(K VARCHAR NOT NULL PRIMARY KEY, INT INTEGER ENCODED_QUALIFIER 11, INT2 INTEGER ENCODED_QUALIFIER 12, INT3 INTEGER ENCODED_QUALIFIER 14)";
        conn.createStatement().execute(ddl);
        PhoenixConnection pconn = conn.unwrap(PhoenixConnection.class);
        PTable table = pconn.getTable(new PTableKey(null, tableName));
        PTable.QualifierEncodingScheme encodingScheme = table.getEncodingScheme();
        Assert.assertNotEquals((Object)PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, (Object)encodingScheme);
        PTable.EncodedCQCounter cqCounter = table.getEncodedCQCounter();
        Assert.assertEquals((long)15L, (long)((Integer)cqCounter.values().get("0")).intValue());
        Assert.assertEquals((long)11L, (long)encodingScheme.decode(table.getColumnForColumnName("INT").getColumnQualifierBytes()));
        Assert.assertEquals((long)12L, (long)encodingScheme.decode(table.getColumnForColumnName("INT2").getColumnQualifierBytes()));
        Assert.assertEquals((long)14L, (long)encodingScheme.decode(table.getColumnForColumnName("INT3").getColumnQualifierBytes()));
    }

    @Test
    public void testCreateTableWithColumnQualifiersMultipleFamilies() throws Exception {
        Properties props = new Properties();
        Connection conn = DriverManager.getConnection(CreateTableIT.getUrl(), props);
        String tableName = CreateTableIT.generateUniqueName();
        String ddl = "CREATE IMMUTABLE TABLE \"" + tableName + "\"(K VARCHAR NOT NULL PRIMARY KEY, A.INT INTEGER ENCODED_QUALIFIER 11, A.INT2 INTEGER ENCODED_QUALIFIER 13, B.INT3 INTEGER ENCODED_QUALIFIER 12) COLUMN_QUALIFIER_COUNTER ('A'=14, 'B'=13)";
        conn.createStatement().execute(ddl);
        PhoenixConnection pconn = conn.unwrap(PhoenixConnection.class);
        PTable table = pconn.getTable(new PTableKey(null, tableName));
        PTable.QualifierEncodingScheme encodingScheme = table.getEncodingScheme();
        Assert.assertNotEquals((Object)PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, (Object)encodingScheme);
        PTable.EncodedCQCounter cqCounter = table.getEncodedCQCounter();
        Assert.assertEquals((long)14L, (long)((Integer)cqCounter.values().get("A")).intValue());
        Assert.assertEquals((long)13L, (long)((Integer)cqCounter.values().get("B")).intValue());
        Assert.assertEquals((long)11L, (long)encodingScheme.decode(table.getColumnForColumnName("INT").getColumnQualifierBytes()));
        Assert.assertEquals((long)13L, (long)encodingScheme.decode(table.getColumnForColumnName("INT2").getColumnQualifierBytes()));
        Assert.assertEquals((long)12L, (long)encodingScheme.decode(table.getColumnForColumnName("INT3").getColumnQualifierBytes()));
    }

    @Test
    public void testCreateTableWithColumnQualifiersMultipleFamiliesWithoutCounter() throws Exception {
        Properties props = new Properties();
        Connection conn = DriverManager.getConnection(CreateTableIT.getUrl(), props);
        String tableName = CreateTableIT.generateUniqueName();
        String ddl = "CREATE IMMUTABLE TABLE \"" + tableName + "\"(K VARCHAR NOT NULL PRIMARY KEY, A.INT INTEGER ENCODED_QUALIFIER 11, A.INT2 INTEGER ENCODED_QUALIFIER 13, B.INT3 INTEGER ENCODED_QUALIFIER 12)";
        conn.createStatement().execute(ddl);
        PhoenixConnection pconn = conn.unwrap(PhoenixConnection.class);
        PTable table = pconn.getTable(new PTableKey(null, tableName));
        PTable.QualifierEncodingScheme encodingScheme = table.getEncodingScheme();
        Assert.assertNotEquals((Object)PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, (Object)encodingScheme);
        PTable.EncodedCQCounter cqCounter = table.getEncodedCQCounter();
        Assert.assertEquals((long)14L, (long)((Integer)cqCounter.values().get("A")).intValue());
        Assert.assertEquals((long)13L, (long)((Integer)cqCounter.values().get("B")).intValue());
        Assert.assertEquals((long)11L, (long)encodingScheme.decode(table.getColumnForColumnName("INT").getColumnQualifierBytes()));
        Assert.assertEquals((long)13L, (long)encodingScheme.decode(table.getColumnForColumnName("INT2").getColumnQualifierBytes()));
        Assert.assertEquals((long)12L, (long)encodingScheme.decode(table.getColumnForColumnName("INT3").getColumnQualifierBytes()));
    }

    @Test
    public void testCreateTableWithColumnQualifiersDuplicateCQ() throws Exception {
        block2: {
            Properties props = new Properties();
            Connection conn = DriverManager.getConnection(CreateTableIT.getUrl(), props);
            String tableName = CreateTableIT.generateUniqueName();
            String ddl = "CREATE TABLE \"" + tableName + "\"(K VARCHAR NOT NULL PRIMARY KEY, INT INTEGER ENCODED_QUALIFIER 11, INT2 INTEGER ENCODED_QUALIFIER 11, INT3 INTEGER ENCODED_QUALIFIER 14) COLUMN_QUALIFIER_COUNTER ('0'=15)";
            try {
                conn.createStatement().execute(ddl);
                Assert.fail((String)"Duplicate Column Qualifiers");
            }
            catch (SQLException e) {
                if (e.getErrorCode() == SQLExceptionCode.DUPLICATE_CQ.getErrorCode()) break block2;
                Assert.fail((String)"Duplicate Column Qualifiers");
            }
        }
    }

    @Test
    public void testCreateTableInvalidColumnQualifier() throws Exception {
        String ddl;
        String tableName;
        Connection conn;
        block10: {
            block9: {
                block8: {
                    Properties props = new Properties();
                    conn = DriverManager.getConnection(CreateTableIT.getUrl(), props);
                    tableName = CreateTableIT.generateUniqueName();
                    ddl = "CREATE TABLE \"" + tableName + "\"(K VARCHAR NOT NULL PRIMARY KEY, INT INTEGER ENCODED_QUALIFIER 11, INT2 INTEGER ENCODED_QUALIFIER 9, INT3 INTEGER ENCODED_QUALIFIER 14) COLUMN_QUALIFIER_COUNTER ('0'=15)";
                    try {
                        conn.createStatement().execute(ddl);
                        Assert.fail((String)"Invalid Column Qualifier");
                    }
                    catch (SQLException e) {
                        if (e.getErrorCode() == SQLExceptionCode.INVALID_CQ.getErrorCode()) break block8;
                        Assert.fail((String)"Invalid Column Qualifier");
                    }
                }
                ddl = "CREATE TABLE \"" + tableName + "\"(K VARCHAR NOT NULL PRIMARY KEY, INT INTEGER ENCODED_QUALIFIER 11) COLUMN_QUALIFIER_COUNTER ('0'=8)";
                try {
                    conn.createStatement().execute(ddl);
                    Assert.fail((String)"Invalid Column Qualifier");
                }
                catch (SQLException e) {
                    if (e.getErrorCode() == SQLExceptionCode.INVALID_CQ.getErrorCode()) break block9;
                    Assert.fail((String)"Invalid Column Qualifier");
                }
            }
            ddl = "CREATE TABLE \"" + tableName + "\"(K VARCHAR NOT NULL PRIMARY KEY, INT INTEGER ENCODED_QUALIFIER 15) COLUMN_QUALIFIER_COUNTER ('0'=13)";
            try {
                conn.createStatement().execute(ddl);
                Assert.fail((String)"Invalid Column Qualifier");
            }
            catch (SQLException e) {
                if (e.getErrorCode() == SQLExceptionCode.INVALID_CQ.getErrorCode()) break block10;
                Assert.fail((String)"Invalid Column Qualifier");
            }
        }
        ddl = "CREATE IMMUTABLE TABLE \"" + tableName + "\"(K VARCHAR NOT NULL PRIMARY KEY, INT1 INTEGER, INT2 INTEGER DEFAULT_COLUMN_FAMILY=dFCOLUMN_QUALIFIER_COUNTER (\"0\"=13)";
        try {
            conn.createStatement().execute(ddl);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateTableMissingColumnQualifier() throws Exception {
        block5: {
            String ddl;
            String tableName;
            Connection conn;
            block4: {
                Properties props = new Properties();
                conn = DriverManager.getConnection(CreateTableIT.getUrl(), props);
                tableName = CreateTableIT.generateUniqueName();
                ddl = "CREATE TABLE \"" + tableName + "\"(K VARCHAR NOT NULL PRIMARY KEY, INT INTEGER, INT2 INTEGER ENCODED_QUALIFIER 12)";
                try {
                    conn.createStatement().execute(ddl);
                    Assert.fail((String)"Invalid Column Qualifier");
                }
                catch (SQLException e) {
                    if (e.getErrorCode() == SQLExceptionCode.MISSING_CQ.getErrorCode()) break block4;
                    Assert.fail((String)"Missing Column Qualifier");
                }
            }
            ddl = "CREATE TABLE \"" + tableName + "\"(K VARCHAR NOT NULL PRIMARY KEY, INT INTEGER ENCODED_QUALIFIER 11, INT2 INTEGER) COLUMN_QUALIFIER_COUNTER ('0'=13)";
            try {
                conn.createStatement().execute(ddl);
                Assert.fail((String)"Invalid Column Qualifier");
            }
            catch (SQLException e) {
                if (e.getErrorCode() == SQLExceptionCode.MISSING_CQ.getErrorCode()) break block5;
                Assert.fail((String)"Missing Column Qualifier");
            }
        }
    }

    @Test
    public void testCreateTableDefaultColumnQualifier() throws Exception {
        Properties props = new Properties();
        Connection conn = DriverManager.getConnection(CreateTableIT.getUrl(), props);
        String tableName = CreateTableIT.generateUniqueName();
        String ddl = "CREATE IMMUTABLE TABLE \"" + tableName + "\"(K VARCHAR NOT NULL PRIMARY KEY, INT1 INTEGER, INT2 INTEGER, a.INT3 INTEGER, \"A\".INT4 INTEGER, \"b\".INT5 INTEGER, \"B\".INT6 INTEGER) DEFAULT_COLUMN_FAMILY=dF";
        conn.createStatement().execute(ddl);
        PhoenixConnection pconn = conn.unwrap(PhoenixConnection.class);
        PTable table = pconn.getTable(new PTableKey(null, tableName));
        PTable.QualifierEncodingScheme encodingScheme = table.getEncodingScheme();
        Assert.assertNotEquals((Object)PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, (Object)encodingScheme);
        PTable.EncodedCQCounter cqCounter = table.getEncodedCQCounter();
        Assert.assertEquals((long)13L, (long)((Integer)cqCounter.values().get("dF")).intValue());
        Assert.assertEquals((long)13L, (long)((Integer)cqCounter.values().get("A")).intValue());
        Assert.assertEquals((long)12L, (long)((Integer)cqCounter.values().get("b")).intValue());
        Assert.assertEquals((long)12L, (long)((Integer)cqCounter.values().get("B")).intValue());
        Assert.assertEquals((long)11L, (long)encodingScheme.decode(table.getColumnForColumnName("INT1").getColumnQualifierBytes()));
        Assert.assertEquals((long)12L, (long)encodingScheme.decode(table.getColumnForColumnName("INT2").getColumnQualifierBytes()));
        Assert.assertEquals((long)11L, (long)encodingScheme.decode(table.getColumnForColumnName("INT3").getColumnQualifierBytes()));
        Assert.assertEquals((long)12L, (long)encodingScheme.decode(table.getColumnForColumnName("INT4").getColumnQualifierBytes()));
        Assert.assertEquals((long)11L, (long)encodingScheme.decode(table.getColumnForColumnName("INT5").getColumnQualifierBytes()));
        Assert.assertEquals((long)11L, (long)encodingScheme.decode(table.getColumnForColumnName("INT6").getColumnQualifierBytes()));
    }

    @Test
    public void testCoprocessorsForCreateIndexOnOldImplementation() throws Exception {
        String tableName = CreateTableIT.generateUniqueName();
        String index1Name = CreateTableIT.generateUniqueName();
        String index2Name = CreateTableIT.generateUniqueName();
        String ddl = "create table  " + tableName + " ( k integer PRIMARY KEY, v1 integer, v2 integer)";
        String index1Ddl = "create index  " + index1Name + " on " + tableName + " (v1)";
        String index2Ddl = "create index  " + index2Name + " on " + tableName + " (v2)";
        Properties props = new Properties();
        Admin admin = driver.getConnectionQueryServices(CreateTableIT.getUrl(), props).getAdmin();
        try (Connection conn = DriverManager.getConnection(CreateTableIT.getUrl());
             Statement stmt = conn.createStatement();){
            stmt.execute(ddl);
            stmt.execute(index1Ddl);
            TableDescriptor index1DescriptorBefore = admin.getDescriptor(TableName.valueOf((String)index1Name));
            Assert.assertTrue((boolean)index1DescriptorBefore.hasCoprocessor(GlobalIndexChecker.class.getName()));
            IndexUpgradeTool iut = new IndexUpgradeTool("rollback", tableName, null, File.createTempFile("index_upgrade_", null).toString(), false, null, false);
            iut.setConf(CreateTableIT.getUtility().getConfiguration());
            iut.prepareToolSetup();
            Assert.assertEquals((long)0L, (long)iut.executeTool());
            TableDescriptor index1DescriptorAfter = admin.getDescriptor(TableName.valueOf((String)index1Name));
            Assert.assertFalse((boolean)index1DescriptorAfter.hasCoprocessor(GlobalIndexChecker.class.getName()));
            stmt.execute(index2Ddl);
            TableDescriptor index2Descriptor = admin.getDescriptor(TableName.valueOf((String)index2Name));
            Assert.assertFalse((boolean)index2Descriptor.hasCoprocessor(GlobalIndexChecker.class.getName()));
        }
    }

    @Test
    public void testCoprocessorsForTransactionalCreateIndexOnOldImplementation() throws Exception {
        String tableName = CreateTableIT.generateUniqueName();
        String index1Name = CreateTableIT.generateUniqueName();
        String ddl = "create table  " + tableName + " ( k integer PRIMARY KEY, v1 integer, v2 integer) TRANSACTIONAL=TRUE";
        String index1Ddl = "create index  " + index1Name + " on " + tableName + " (v1)";
        Properties props = new Properties();
        Admin admin = driver.getConnectionQueryServices(CreateTableIT.getUrl(), props).getAdmin();
        try (Connection conn = DriverManager.getConnection(CreateTableIT.getUrl());
             Statement stmt = conn.createStatement();){
            stmt.execute(ddl);
            stmt.execute(index1Ddl);
            TableDescriptor index1DescriptorBefore = admin.getDescriptor(TableName.valueOf((String)index1Name));
            Assert.assertFalse((boolean)index1DescriptorBefore.hasCoprocessor(GlobalIndexChecker.class.getName()));
            IndexUpgradeTool iut = new IndexUpgradeTool("rollback", tableName, null, File.createTempFile("index_upgrade_", null).toString(), false, null, false);
            iut.setConf(CreateTableIT.getUtility().getConfiguration());
            iut.prepareToolSetup();
            Assert.assertEquals((long)0L, (long)iut.executeTool());
            TableDescriptor index1DescriptorAfter = admin.getDescriptor(TableName.valueOf((String)index1Name));
            Assert.assertFalse((boolean)index1DescriptorAfter.hasCoprocessor(GlobalIndexChecker.class.getName()));
        }
    }

    @Test
    public void testCreateTableWithNoVerify() throws SQLException, IOException, InterruptedException {
        String tableName = SchemaUtil.getTableName((String)CreateTableIT.generateUniqueName(), (String)CreateTableIT.generateUniqueName());
        byte[] tableBytes = tableName.getBytes();
        byte[] familyName = Bytes.toBytes((String)SchemaUtil.normalizeIdentifier((String)"0"));
        byte[][] splits = new byte[][]{Bytes.toBytes((int)20), Bytes.toBytes((int)30)};
        try (Admin admin = driver.getConnectionQueryServices(CreateTableIT.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES)).getAdmin();){
            admin.createTable(TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((byte[])tableBytes)).addColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])familyName).setKeepDeletedCells(KeepDeletedCells.TRUE).build()).build(), (byte[][])splits);
        }
        byte[] uintCol = Bytes.toBytes((String)"UINT_COL");
        byte[] ulongCol = Bytes.toBytes((String)"ULONG_COL");
        byte[] key_1 = ByteUtil.concat((byte[])Bytes.toBytes((int)20), (byte[][])new byte[][]{Bytes.toBytes((long)200L), Bytes.toBytes((String)"b")});
        byte[] key_2 = ByteUtil.concat((byte[])Bytes.toBytes((int)40), (byte[][])new byte[][]{Bytes.toBytes((long)400L), Bytes.toBytes((String)"d")});
        byte[] emptyColumnQualifier = Bytes.toBytes((String)"_0");
        ConnectionQueryServices services = driver.getConnectionQueryServices(CreateTableIT.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
        try (Table hTable = services.getTable(tableBytes);){
            ArrayList<Put> mutations = new ArrayList<Put>();
            Put put = new Put(key_1);
            put.addColumn(familyName, uintCol, Long.MAX_VALUE, Bytes.toBytes((int)5000));
            put.addColumn(familyName, ulongCol, Long.MAX_VALUE, Bytes.toBytes((long)50000L));
            mutations.add(put);
            put = new Put(key_2);
            put.addColumn(familyName, uintCol, Long.MAX_VALUE, Bytes.toBytes((int)4000));
            put.addColumn(familyName, ulongCol, Long.MAX_VALUE, Bytes.toBytes((long)40000L));
            mutations.add(put);
            hTable.batch(mutations, null);
            Result result = hTable.get(new Get(key_1));
            Assert.assertFalse((boolean)result.isEmpty());
            result = hTable.get(new Get(key_2));
            Assert.assertFalse((boolean)result.isEmpty());
        }
        String ddl = "create table " + tableName + "   (uint_key unsigned_int not null,    ulong_key unsigned_long not null,    string_key varchar not null,\n    uint_col unsigned_int,    ulong_col unsigned_long    CONSTRAINT pk PRIMARY KEY (uint_key, ulong_key, string_key)) noverify COLUMN_ENCODED_BYTES=NONE";
        try (Connection conn = DriverManager.getConnection(url);){
            conn.createStatement().execute(ddl);
        }
        var13_17 = null;
        try (Table hTable = services.getTable(tableBytes);){
            Result result = hTable.get(new Get(key_1));
            byte[] value = result.getValue(familyName, uintCol);
            Assert.assertEquals((long)5000L, (long)Bytes.toInt((byte[])value));
            value = result.getValue(familyName, ulongCol);
            Assert.assertEquals((long)50000L, (long)Bytes.toLong((byte[])value));
            value = result.getValue(familyName, emptyColumnQualifier);
            Assert.assertNull((Object)value);
            result = hTable.get(new Get(key_2));
            value = result.getValue(familyName, uintCol);
            Assert.assertEquals((long)4000L, (long)Bytes.toInt((byte[])value));
            value = result.getValue(familyName, ulongCol);
            Assert.assertEquals((long)40000L, (long)Bytes.toLong((byte[])value));
            value = result.getValue(familyName, emptyColumnQualifier);
            Assert.assertNull((Object)value);
        }
        catch (Throwable throwable) {
            var13_17 = throwable;
            throw throwable;
        }
    }

    public static long verifyLastDDLTimestamp(String tableFullName, long startTS, Connection conn) throws SQLException {
        long endTS = EnvironmentEdgeManager.currentTimeMillis();
        long ddlTimestamp = CreateTableIT.getLastDDLTimestamp(conn, tableFullName);
        Assert.assertTrue((String)("PTable DDL Timestamp: " + ddlTimestamp + " not in the expected range: (" + startTS + ", " + endTS + ")"), (ddlTimestamp >= startTS && ddlTimestamp <= endTS ? 1 : 0) != 0);
        return ddlTimestamp;
    }

    public static long getLastDDLTimestamp(Connection conn, String tableFullName) throws SQLException {
        PTable table = conn.unwrap(PhoenixConnection.class).getTableNoCache(tableFullName);
        Assert.assertNotNull((String)"PTable is null!", (Object)table);
        Assert.assertNotNull((String)"DDL timestamp is null!", (Object)table.getLastDDLTimestamp());
        return table.getLastDDLTimestamp();
    }

    private int checkGuidePostWidth(String tableName) throws Exception {
        try (Connection conn = DriverManager.getConnection(CreateTableIT.getUrl());){
            String query = "SELECT GUIDE_POSTS_WIDTH FROM SYSTEM.CATALOG WHERE TABLE_NAME = ? AND COLUMN_FAMILY IS NULL AND COLUMN_NAME IS NULL";
            PreparedStatement stmt = conn.prepareStatement(query);
            stmt.setString(1, tableName);
            ResultSet rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            int n = rs.getInt(1);
            return n;
        }
    }
}

