/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.schema.SchemaAlreadyExistsException;
import org.apache.phoenix.util.ClientUtil;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class CreateSchemaIT
extends ParallelStatsDisabledIT {
    @Test
    public void testCreateSchema() throws Exception {
        Throwable throwable;
        Admin admin2;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.setProperty("phoenix.schema.isNamespaceMappingEnabled", Boolean.toString(true));
        String schemaName = CreateSchemaIT.generateUniqueName();
        String schemaName1 = schemaName.toLowerCase();
        String schemaName2 = schemaName.toLowerCase();
        String ddl1 = "CREATE SCHEMA \"" + schemaName1 + "\"";
        String ddl2 = "CREATE SCHEMA " + schemaName2;
        try (Connection conn = DriverManager.getConnection(CreateSchemaIT.getUrl(), props);){
            admin2 = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();
            throwable = null;
            try {
                conn.createStatement().execute(ddl1);
                Assert.assertTrue((boolean)ClientUtil.isHBaseNamespaceAvailable((Admin)admin2, (String)schemaName1));
                conn.createStatement().execute(ddl2);
                Assert.assertTrue((boolean)ClientUtil.isHBaseNamespaceAvailable((Admin)admin2, (String)schemaName2.toUpperCase()));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (admin2 != null) {
                    if (throwable != null) {
                        try {
                            admin2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        admin2.close();
                    }
                }
            }
        }
        try {
            conn = DriverManager.getConnection(CreateSchemaIT.getUrl(), props);
            var8_9 = null;
            try {
                conn.createStatement().execute(ddl1);
                Assert.fail();
            }
            catch (Throwable admin2) {
                var8_9 = admin2;
                throw admin2;
            }
            finally {
                if (conn != null) {
                    if (var8_9 != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable admin2) {
                            var8_9.addSuppressed(admin2);
                        }
                    } else {
                        conn.close();
                    }
                }
            }
        }
        catch (SchemaAlreadyExistsException conn2) {
            // empty catch block
        }
        conn = DriverManager.getConnection(CreateSchemaIT.getUrl(), props);
        var8_9 = null;
        try {
            admin2 = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();
            throwable = null;
            try {
                try {
                    conn.createStatement().execute("CREATE SCHEMA \"default\"");
                    Assert.fail();
                }
                catch (SQLException e) {
                    Assert.assertEquals((long)SQLExceptionCode.SCHEMA_NOT_ALLOWED.getErrorCode(), (long)e.getErrorCode());
                }
                try {
                    conn.createStatement().execute("CREATE SCHEMA \"hbase\"");
                    Assert.fail();
                }
                catch (SQLException e) {
                    Assert.assertEquals((long)SQLExceptionCode.SCHEMA_NOT_ALLOWED.getErrorCode(), (long)e.getErrorCode());
                }
                conn.createStatement().execute("CREATE SCHEMA \"" + "default".toUpperCase() + "\"");
                conn.createStatement().execute("CREATE SCHEMA \"" + "hbase".toUpperCase() + "\"");
                Assert.assertTrue((boolean)ClientUtil.isHBaseNamespaceAvailable((Admin)admin2, (String)"default".toUpperCase()));
                Assert.assertTrue((boolean)ClientUtil.isHBaseNamespaceAvailable((Admin)admin2, (String)"hbase".toUpperCase()));
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (admin2 != null) {
                    if (throwable != null) {
                        try {
                            admin2.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        admin2.close();
                    }
                }
            }
        }
        catch (Throwable throwable6) {
            var8_9 = throwable6;
            throw throwable6;
        }
        finally {
            if (conn != null) {
                if (var8_9 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable7) {
                        var8_9.addSuppressed(throwable7);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }
}

