/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Properties;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class CountDistinctApproximateHyperLogLogIT
extends ParallelStatsDisabledIT {
    private String tableName;

    @Before
    public void generateTableNames() {
        this.tableName = "T_" + CountDistinctApproximateHyperLogLogIT.generateUniqueName();
    }

    @Test(expected=ColumnNotFoundException.class)
    public void testDistinctCountException() throws Exception {
        String query = "SELECT APPROX_COUNT_DISTINCT(x) FROM " + this.tableName;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(CountDistinctApproximateHyperLogLogIT.getUrl(), props);
             PreparedStatement statement = conn.prepareStatement(query);){
            this.prepareTableWithValues(conn, 100);
            ResultSet resultSet = statement.executeQuery();
        }
    }

    @Test
    public void testDistinctCountOnConstant() throws Exception {
        String query = "SELECT APPROX_COUNT_DISTINCT(20) FROM " + this.tableName;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(CountDistinctApproximateHyperLogLogIT.getUrl(), props);
             PreparedStatement statement = conn.prepareStatement(query);){
            this.prepareTableWithValues(conn, 100);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getLong(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testDistinctCountOnSingleColumn() throws Exception {
        String query = "SELECT APPROX_COUNT_DISTINCT(i2) FROM " + this.tableName;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(CountDistinctApproximateHyperLogLogIT.getUrl(), props);
             PreparedStatement statement = conn.prepareStatement(query);){
            this.prepareTableWithValues(conn, 100);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)10L, (long)rs.getLong(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testDistinctCountOnMutlipleColumns() throws Exception {
        String query = "SELECT APPROX_COUNT_DISTINCT(i1||i2) FROM " + this.tableName;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(CountDistinctApproximateHyperLogLogIT.getUrl(), props);
             PreparedStatement statement = conn.prepareStatement(query);){
            this.prepareTableWithValues(conn, 100);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)100L, (long)rs.getLong(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testDistinctCountOnjoining() throws Exception {
        String query = "SELECT APPROX_COUNT_DISTINCT(a.i1||a.i2||b.i2) FROM " + this.tableName + " a, " + this.tableName + " b where a.i1=b.i1 and a.i2 = b.i2";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(CountDistinctApproximateHyperLogLogIT.getUrl(), props);
             PreparedStatement statement = conn.prepareStatement(query);){
            this.prepareTableWithValues(conn, 100);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)100L, (long)rs.getLong(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testDistinctCountPlanExplain() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String query = "SELECT APPROX_COUNT_DISTINCT(i1||i2) FROM " + this.tableName;
        try (Connection conn = DriverManager.getConnection(CountDistinctApproximateHyperLogLogIT.getUrl(), props);){
            this.prepareTableWithValues(conn, 100);
            ExplainPlan plan = conn.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
            ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
            Assert.assertEquals((Object)this.tableName, (Object)explainPlanAttributes.getTableName());
            Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
            Assert.assertEquals((Object)"FULL SCAN ", (Object)explainPlanAttributes.getExplainScanType());
            Assert.assertEquals((Object)"SERVER FILTER BY FIRST KEY ONLY", (Object)explainPlanAttributes.getServerWhereFilter());
            Assert.assertEquals((Object)"SERVER AGGREGATE INTO SINGLE ROW", (Object)explainPlanAttributes.getServerAggregate());
        }
    }

    private final void prepareTableWithValues(Connection conn, int nRows) throws Exception {
        conn.createStatement().execute("create table " + this.tableName + "\n   (i1 integer not null, i2 integer not null\n    CONSTRAINT pk PRIMARY KEY (i1,i2))");
        PreparedStatement stmt = conn.prepareStatement("upsert into " + this.tableName + " VALUES (?, ?)");
        for (int i = 0; i < nRows; ++i) {
            stmt.setInt(1, i);
            stmt.setInt(2, i * 10 % 100);
            stmt.execute();
        }
        conn.commit();
    }
}

