/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class ConvertTimezoneFunctionIT
extends ParallelStatsDisabledIT {
    @Test
    public void testDateConvertTimezoneEurope() throws Exception {
        Connection conn = DriverManager.getConnection(ConvertTimezoneFunctionIT.getUrl());
        String timezone_offset_test = ConvertTimezoneFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + timezone_offset_test + " (k1 INTEGER NOT NULL, dates DATE CONSTRAINT pk PRIMARY KEY (k1))";
        conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + timezone_offset_test + " (k1, dates) VALUES (1, TO_DATE('2014-03-01 00:00:00'))";
        conn.createStatement().execute(dml);
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT k1, dates, CONVERT_TZ(dates, 'UTC', 'Europe/Prague') FROM " + timezone_offset_test);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1393635600000L, (long)rs.getDate(3).getTime());
    }

    @Test
    public void testTimestampConvertTimezoneEurope() throws Exception {
        Connection conn = DriverManager.getConnection(ConvertTimezoneFunctionIT.getUrl());
        String timezone_offset_test = ConvertTimezoneFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + timezone_offset_test + " (k1 INTEGER NOT NULL, timestamps TIMESTAMP CONSTRAINT pk PRIMARY KEY (k1))";
        conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + timezone_offset_test + " (k1, timestamps) VALUES (1, TO_TIMESTAMP('2014-03-01 00:00:00'))";
        conn.createStatement().execute(dml);
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT k1, timestamps, CONVERT_TZ(timestamps, 'UTC', 'Europe/Prague') FROM " + timezone_offset_test);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1393635600000L, (long)rs.getDate(3).getTime());
    }

    @Test
    public void testConvertTimezoneAmerica() throws Exception {
        Connection conn = DriverManager.getConnection(ConvertTimezoneFunctionIT.getUrl());
        String timezone_offset_test = ConvertTimezoneFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + timezone_offset_test + " (k1 INTEGER NOT NULL, dates DATE CONSTRAINT pk PRIMARY KEY (k1))";
        conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + timezone_offset_test + " (k1, dates) VALUES (1, TO_DATE('2014-03-01 00:00:00'))";
        conn.createStatement().execute(dml);
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT k1, dates, CONVERT_TZ(dates, 'UTC', 'America/Adak') FROM " + timezone_offset_test);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1393596000000L, (long)rs.getDate(3).getTime());
    }

    @Test
    public void nullInDateParameter() throws Exception {
        Connection conn = DriverManager.getConnection(ConvertTimezoneFunctionIT.getUrl());
        String timezone_offset_test = ConvertTimezoneFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + timezone_offset_test + " (k1 INTEGER NOT NULL, dates DATE CONSTRAINT pk PRIMARY KEY (k1))";
        conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + timezone_offset_test + " (k1) VALUES (1)";
        conn.createStatement().execute(dml);
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT k1, dates, CONVERT_TZ(dates, 'UTC', 'America/Adak') FROM " + timezone_offset_test);
        Assert.assertTrue((boolean)rs.next());
        rs.getDate(3);
        Assert.assertTrue((boolean)rs.wasNull());
    }

    @Test
    public void nullInFirstTimezoneParameter() throws Exception {
        Connection conn = DriverManager.getConnection(ConvertTimezoneFunctionIT.getUrl());
        String timezone_offset_test = ConvertTimezoneFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + timezone_offset_test + " (k1 INTEGER NOT NULL, dates DATE, tz VARCHAR, CONSTRAINT pk PRIMARY KEY (k1))";
        conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + timezone_offset_test + " (k1, dates) VALUES (1, TO_DATE('2014-03-01 00:00:00'))";
        conn.createStatement().execute(dml);
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT k1, dates, CONVERT_TZ(dates, tz, 'America/Adak') FROM " + timezone_offset_test);
        Assert.assertTrue((boolean)rs.next());
        rs.getDate(3);
        Assert.assertTrue((boolean)rs.wasNull());
    }

    @Test
    public void nullInSecondTimezoneParameter() throws Exception {
        Connection conn = DriverManager.getConnection(ConvertTimezoneFunctionIT.getUrl());
        String timezone_offset_test = ConvertTimezoneFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + timezone_offset_test + " (k1 INTEGER NOT NULL, dates DATE, tz VARCHAR, CONSTRAINT pk PRIMARY KEY (k1))";
        conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + timezone_offset_test + " (k1, dates) VALUES (1, TO_DATE('2014-03-01 00:00:00'))";
        conn.createStatement().execute(dml);
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT k1, dates, CONVERT_TZ(dates, 'America/Adak', tz) FROM " + timezone_offset_test);
        Assert.assertTrue((boolean)rs.next());
        rs.getDate(3);
        Assert.assertTrue((boolean)rs.wasNull());
    }

    @Test
    public void unknownTimezone() throws Exception {
        Connection conn = DriverManager.getConnection(ConvertTimezoneFunctionIT.getUrl());
        String timezone_offset_test = ConvertTimezoneFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + timezone_offset_test + " (k1 INTEGER NOT NULL, dates DATE CONSTRAINT pk PRIMARY KEY (k1))";
        conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + timezone_offset_test + " (k1, dates) VALUES (1, TO_DATE('2014-03-01 00:00:00'))";
        conn.createStatement().execute(dml);
        conn.commit();
        try {
            ResultSet rs = conn.createStatement().executeQuery("SELECT k1, dates, CONVERT_TZ(dates, 'UNKNOWN_TIMEZONE', 'America/Adak') FROM " + timezone_offset_test);
            rs.next();
            rs.getDate(3).getTime();
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.ILLEGAL_DATA.getErrorCode(), (long)e.getErrorCode());
        }
    }

    @Test
    public void testConvertMultipleRecords() throws Exception {
        Connection conn = DriverManager.getConnection(ConvertTimezoneFunctionIT.getUrl());
        String timezone_offset_test = ConvertTimezoneFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + timezone_offset_test + " (k1 INTEGER NOT NULL, dates DATE CONSTRAINT pk PRIMARY KEY (k1))";
        Statement stmt = conn.createStatement();
        stmt.execute(ddl);
        stmt.execute("UPSERT INTO " + timezone_offset_test + " (k1, dates) VALUES (1, TO_DATE('2014-03-01 00:00:00'))");
        stmt.execute("UPSERT INTO " + timezone_offset_test + " (k1, dates) VALUES (2, TO_DATE('2014-03-01 00:00:00'))");
        conn.commit();
        ResultSet rs = stmt.executeQuery("SELECT k1, dates, CONVERT_TZ(dates, 'UTC', 'America/Adak') FROM " + timezone_offset_test);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1393596000000L, (long)rs.getDate(3).getTime());
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1393596000000L, (long)rs.getDate(3).getTime());
        Assert.assertFalse((boolean)rs.next());
    }
}

