/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.jdbc.PhoenixTestDriver;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.util.ReadOnlyProps;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class ContextClassloaderIT
extends BaseTest {
    private static HBaseTestingUtility hbaseTestUtil;
    private static PhoenixTestDriver driver;
    private static ClassLoader badContextClassloader;

    @BeforeClass
    public static synchronized void setUpBeforeClass() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        ContextClassloaderIT.setUpConfigForMiniCluster(conf);
        hbaseTestUtil = new HBaseTestingUtility(conf);
        hbaseTestUtil.startMiniCluster();
        String clientPort = hbaseTestUtil.getConfiguration().get("hbase.zookeeper.property.clientPort");
        String url = "jdbc:phoenix+zk:localhost:" + clientPort + ';' + "test=true";
        driver = ContextClassloaderIT.initAndRegisterTestDriver(url, ReadOnlyProps.EMPTY_PROPS);
        Connection conn = DriverManager.getConnection(url);
        Statement stmt = conn.createStatement();
        stmt.execute("CREATE TABLE test (ID INTEGER NOT NULL PRIMARY KEY, NAME VARCHAR)");
        stmt.execute("UPSERT INTO test VALUES (1, 'name1')");
        stmt.execute("UPSERT INTO test VALUES (2, 'name2')");
        stmt.close();
        conn.commit();
        conn.close();
        badContextClassloader = new URLClassLoader(new URL[]{File.createTempFile("invalid", ".jar").toURI().toURL()}, null);
    }

    protected static String getUrl() {
        return "jdbc:phoenix:localhost:" + hbaseTestUtil.getZkCluster().getClientPort() + ";test=true";
    }

    @Test
    public void testQueryWithDifferentContextClassloader() throws SQLException, InterruptedException {
        Runnable target = new Runnable(){

            @Override
            public void run() {
                try {
                    Connection conn = DriverManager.getConnection(ContextClassloaderIT.getUrl());
                    Statement stmt = conn.createStatement();
                    ResultSet rs = stmt.executeQuery("select * from test where name = 'name2'");
                    while (rs.next()) {
                    }
                    rs.close();
                    stmt.close();
                    conn.close();
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        BadContextClassloaderThread t = new BadContextClassloaderThread(target);
        t.start();
        t.join();
        Assert.assertFalse((boolean)t.failed);
    }

    @Test
    public void testGetDatabaseMetadataWithDifferentContextClassloader() throws InterruptedException {
        Runnable target = new Runnable(){

            @Override
            public void run() {
                try {
                    Connection conn = DriverManager.getConnection(ContextClassloaderIT.getUrl());
                    ResultSet tablesRs = conn.getMetaData().getTables(null, null, null, null);
                    while (tablesRs.next()) {
                    }
                    tablesRs.close();
                    conn.close();
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        BadContextClassloaderThread t = new BadContextClassloaderThread(target);
        t.start();
        t.join();
        Assert.assertFalse((boolean)t.failed);
    }

    @Test
    public void testExecuteDdlWithDifferentContextClassloader() throws InterruptedException {
        Runnable target = new Runnable(){

            @Override
            public void run() {
                try {
                    Connection conn = DriverManager.getConnection(ContextClassloaderIT.getUrl());
                    Statement stmt = conn.createStatement();
                    stmt.execute("CREATE TABLE T2 (ID INTEGER NOT NULL PRIMARY KEY, NAME VARCHAR)");
                    stmt.execute("UPSERT INTO T2 VALUES (1, 'name1')");
                    conn.commit();
                    ResultSet rs = stmt.executeQuery("SELECT * FROM T2");
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertFalse((boolean)rs.next());
                    rs.close();
                    stmt.close();
                    conn.close();
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        BadContextClassloaderThread t = new BadContextClassloaderThread(target);
        t.start();
        t.join();
        Assert.assertFalse((boolean)t.failed);
    }

    static class BadContextClassloaderThread
    extends Thread {
        private final Runnable target;
        boolean failed = false;

        public BadContextClassloaderThread(Runnable target) {
            super("BadContextClassloaderThread");
            this.target = target;
            this.setContextClassLoader(badContextClassloader);
        }

        @Override
        public void run() {
            try {
                this.target.run();
            }
            catch (Throwable t) {
                this.failed = true;
                throw new RuntimeException(t);
            }
        }
    }
}

