/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDriver;
import org.apache.phoenix.jdbc.PhoenixTestDriver;
import org.apache.phoenix.mapreduce.util.ConnectionUtil;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.query.ConfigurationFactory;
import org.apache.phoenix.util.InstanceResolver;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class ConnectionIT {
    private static HBaseTestingUtility hbaseTestUtil;
    private static Configuration conf;
    private static int tableCounter;

    @BeforeClass
    public static synchronized void setUp() throws Exception {
        hbaseTestUtil = new HBaseTestingUtility();
        conf = hbaseTestUtil.getConfiguration();
        BaseTest.setUpConfigForMiniCluster(conf);
        conf.set("zookeeper.znode.parent", "/hbase-test");
        conf.set("hbase.client.registry.impl", "org.apache.hadoop.hbase.client.ZKConnectionRegistry");
        hbaseTestUtil.startMiniCluster();
        Class.forName(PhoenixDriver.class.getName());
        DriverManager.registerDriver((Driver)((Object)new PhoenixTestDriver()));
        InstanceResolver.clearSingletons();
        InstanceResolver.getSingleton(ConfigurationFactory.class, (Object)new ConfigurationFactory(){

            public Configuration getConfiguration() {
                return new Configuration(conf);
            }

            public Configuration getConfiguration(Configuration confToClone) {
                Configuration copy = new Configuration(conf);
                copy.addResource(confToClone);
                return copy;
            }
        });
    }

    @AfterClass
    public static synchronized void cleanUp() throws Exception {
        InstanceResolver.clearSingletons();
    }

    @Test
    public void testInputAndOutputConnections() throws SQLException {
        try (Connection inputConnection = ConnectionUtil.getInputConnection((Configuration)conf);){
            this.smoke(inputConnection);
        }
        var2_2 = null;
        try (Connection outputConnection = ConnectionUtil.getOutputConnection((Configuration)conf);){
            this.smoke(outputConnection);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
    }

    private void smoke(Connection conn) throws SQLException {
        String table = "t" + tableCounter++;
        try (Statement stmt = conn.createStatement();){
            stmt.execute("create table " + table + " (a integer primary key,b varchar)");
            stmt.execute("upsert into " + table + " values(1,'foo')");
            conn.commit();
            ResultSet rs = stmt.executeQuery("select count(*) from " + table);
            rs.next();
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
        }
    }

    @Test
    public void testZkConnections() throws SQLException {
        String zkQuorum = conf.get("hbase.zookeeper.quorum");
        String zkPort = conf.get("hbase.zookeeper.property.clientPort");
        try (PhoenixConnection conn1 = (PhoenixConnection)DriverManager.getConnection("jdbc:phoenix");
             PhoenixConnection conn2 = (PhoenixConnection)DriverManager.getConnection("jdbc:phoenix+zk");
             PhoenixConnection conn3 = (PhoenixConnection)DriverManager.getConnection("jdbc:phoenix+zk:" + zkQuorum + ":" + zkPort);){
            this.smoke((Connection)conn1);
            this.smoke((Connection)conn2);
            this.smoke((Connection)conn3);
            Assert.assertEquals((Object)conn1.getQueryServices(), (Object)conn2.getQueryServices());
            Assert.assertEquals((Object)conn1.getQueryServices(), (Object)conn3.getQueryServices());
        }
    }

    @Test
    public void testMasterConnections() throws SQLException {
        Assume.assumeTrue((VersionInfo.compareVersion((String)VersionInfo.getVersion(), (String)"2.3.0") >= 0 ? 1 : 0) != 0);
        int masterPortString = conf.getInt("hbase.master.port", 16000);
        String masterHosts = conf.get("hbase.masters");
        try (PhoenixConnection conn1 = (PhoenixConnection)DriverManager.getConnection("jdbc:phoenix+master");
             PhoenixConnection conn2 = (PhoenixConnection)DriverManager.getConnection("jdbc:phoenix+master:" + masterHosts.replaceAll(":", "\\\\:") + ":" + masterPortString);){
            this.smoke((Connection)conn1);
            this.smoke((Connection)conn2);
            Assert.assertEquals((Object)conn1.getQueryServices(), (Object)conn2.getQueryServices());
        }
    }

    @Test
    public void testRPCConnections() throws SQLException {
        Assume.assumeTrue((VersionInfo.compareVersion((String)VersionInfo.getVersion(), (String)"2.5.0") >= 0 ? 1 : 0) != 0);
        String masterHosts = conf.get("hbase.masters");
        conf.set("hbase.client.bootstrap.servers", masterHosts);
        try (PhoenixConnection conn1 = (PhoenixConnection)DriverManager.getConnection("jdbc:phoenix+rpc");
             PhoenixConnection conn2 = (PhoenixConnection)DriverManager.getConnection("jdbc:phoenix+rpc:" + masterHosts.replaceAll(":", "\\\\:"));){
            this.smoke((Connection)conn1);
            this.smoke((Connection)conn2);
            Assert.assertEquals((Object)conn1.getQueryServices(), (Object)conn2.getQueryServices());
        }
    }

    @Test
    public void testQueryPlanIsNullByDefault() throws SQLException {
        String tableName = "TEST_QUERY_PLAN_" + tableCounter++;
        try (PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection("jdbc:phoenix");){
            String initialQueryPlan = conn.getActivityLogger().getExplainPlanInfo();
            Assert.assertNull((String)"Query plan should be null by default (disabled)", (Object)initialQueryPlan);
            try (Statement stmt = conn.createStatement();){
                stmt.execute("CREATE TABLE " + tableName + " (id INTEGER PRIMARY KEY, name VARCHAR)");
                stmt.execute("UPSERT INTO " + tableName + " VALUES (1, 'test1')");
                stmt.execute("UPSERT INTO " + tableName + " VALUES (2, 'test2')");
                conn.commit();
            }
            stmt = conn.createStatement();
            var6_8 = null;
            try {
                ResultSet rs = stmt.executeQuery("SELECT * FROM " + tableName);
                while (rs.next()) {
                }
                String queryPlan = conn.getActivityLogger().getExplainPlanInfo();
                Assert.assertNull((String)"Query plan should be null after query execution (disabled by default)", (Object)queryPlan);
            }
            catch (Throwable throwable) {
                var6_8 = throwable;
                throw throwable;
            }
            finally {
                if (stmt != null) {
                    if (var6_8 != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable) {
                            var6_8.addSuppressed(throwable);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
    }
}

