/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.phoenix.end2end.ConcurrentMutationsExtendedIT;
import org.apache.phoenix.end2end.IndexToolIT;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.RunUntilFailure;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={NeedsOwnMiniClusterTest.class})
@RunWith(value=RunUntilFailure.class)
public class ConcurrentUpsertsWithoutIndexedColsIT
extends BaseTest {
    private static final Random RANDOM = new Random(5L);
    private static final Logger LOGGER = LoggerFactory.getLogger(ConcurrentUpsertsWithoutIndexedColsIT.class);
    private static final Map<String, String> PROPS = ImmutableMap.of((Object)"phoenix.global.index.row.age.threshold.to.delete.ms", (Object)Long.toString(0L), (Object)"phoenix.max.lookback.age.seconds", (Object)Integer.toString(1000000));

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        ConcurrentUpsertsWithoutIndexedColsIT.setUpTestDriver(new ReadOnlyProps(PROPS.entrySet().iterator()));
    }

    @Test
    public void testConcurrentUpsertsWithoutIndexedColumns() throws Exception {
        int nThreads = 4;
        int batchSize = 100;
        int nRows = 997;
        String tableName = ConcurrentUpsertsWithoutIndexedColsIT.generateUniqueName();
        String indexName = ConcurrentUpsertsWithoutIndexedColsIT.generateUniqueName();
        Connection conn = DriverManager.getConnection(ConcurrentUpsertsWithoutIndexedColsIT.getUrl());
        conn.createStatement().execute("CREATE TABLE " + tableName + "(k1 INTEGER NOT NULL, k2 INTEGER NOT NULL, a.v1 INTEGER, b.v2 INTEGER, c.v3 INTEGER, d.v4 INTEGER,CONSTRAINT pk PRIMARY KEY (k1,k2))  COLUMN_ENCODED_BYTES = 0, VERSIONS=1");
        TestUtil.addCoprocessor(conn, tableName, ConcurrentMutationsExtendedIT.DelayingRegionObserver.class);
        conn.createStatement().execute("CREATE INDEX " + indexName + " ON " + tableName + "(v1) INCLUDE(v2, v3)");
        CountDownLatch doneSignal = new CountDownLatch(nThreads);
        ExecutorService executorService = Executors.newFixedThreadPool(nThreads, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("test-concurrent-upsert-%d").build());
        for (int i = 0; i < nThreads; ++i) {
            TestRunnable testRunnable = new TestRunnable(tableName, 997, 100, doneSignal);
            executorService.submit(testRunnable);
        }
        Assert.assertTrue((String)"Ran out of time", (boolean)doneSignal.await(1300L, TimeUnit.SECONDS));
        executorService.shutdown();
        executorService.awaitTermination(5L, TimeUnit.SECONDS);
        IndexToolIT.verifyIndexTable(tableName, indexName, conn);
    }

    private static class TestRunnable
    implements Runnable {
        private final String tableName;
        private final int nRows;
        private final int batchSize;
        private final CountDownLatch doneSignal;

        public TestRunnable(String tableName, int nRows, int batchSize, CountDownLatch doneSignal) {
            this.tableName = tableName;
            this.nRows = nRows;
            this.batchSize = batchSize;
            this.doneSignal = doneSignal;
        }

        @Override
        public void run() {
            try {
                Connection conn = DriverManager.getConnection(ConcurrentUpsertsWithoutIndexedColsIT.getUrl());
                for (int i = 0; i < 1000; ++i) {
                    if (RANDOM.nextInt() % 1000 < 10) {
                        conn.createStatement().execute("UPSERT INTO " + this.tableName + " (k1, k2, b.v2, c.v3, d.v4) VALUES (" + RANDOM.nextInt() % this.nRows + ", 0, " + (RANDOM.nextBoolean() ? null : Integer.valueOf(RANDOM.nextInt())) + ", " + (RANDOM.nextBoolean() ? null : Integer.valueOf(RANDOM.nextInt())) + ", " + (RANDOM.nextBoolean() ? null : Integer.valueOf(RANDOM.nextInt())) + ")");
                    } else {
                        conn.createStatement().execute("UPSERT INTO " + this.tableName + " VALUES (" + i % this.nRows + ", 0, " + (RANDOM.nextBoolean() ? null : Integer.valueOf(RANDOM.nextInt())) + ", " + (RANDOM.nextBoolean() ? null : Integer.valueOf(RANDOM.nextInt())) + ", " + (RANDOM.nextBoolean() ? null : Integer.valueOf(RANDOM.nextInt())) + ", " + (RANDOM.nextBoolean() ? null : Integer.valueOf(RANDOM.nextInt())) + ")");
                    }
                    if (i % this.batchSize != 0) continue;
                    conn.commit();
                    LOGGER.info("Committed batch no: {}", (Object)i);
                }
                conn.commit();
            }
            catch (SQLException e) {
                LOGGER.error("Error during concurrent upserts. ", (Throwable)e);
                throw new RuntimeException(e);
            }
            finally {
                this.doneSignal.countDown();
            }
        }
    }
}

