/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.util.EnvironmentEdge;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.IndexScrutiny;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.RunUntilFailure;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@Category(value={ParallelStatsDisabledTest.class})
@RunWith(value=RunUntilFailure.class)
public class ConcurrentMutationsIT
extends ParallelStatsDisabledIT {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore(value="PHOENIX-4058 Generate correct index updates when DeleteColumn processed before Put with same timestamp")
    public void testSetIndexedColumnToNullAndValueAtSameTS() throws Exception {
        try {
            MyClock clock = new MyClock(1000L);
            EnvironmentEdgeManager.injectEdge((EnvironmentEdge)clock);
            String tableName = ConcurrentMutationsIT.generateUniqueName();
            String indexName = ConcurrentMutationsIT.generateUniqueName();
            Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
            Connection conn = DriverManager.getConnection(ConcurrentMutationsIT.getUrl(), props);
            conn.createStatement().execute("CREATE TABLE " + tableName + "(k1 CHAR(2) NOT NULL, k2 CHAR(2) NOT NULL, ts TIMESTAMP, V VARCHAR, V2 VARCHAR, CONSTRAINT pk PRIMARY KEY (k1,k2)) COLUMN_ENCODED_BYTES = 0");
            conn.close();
            conn = DriverManager.getConnection(ConcurrentMutationsIT.getUrl(), props);
            conn.createStatement().execute("CREATE INDEX " + indexName + " ON " + tableName + "(k2,k1,ts) INCLUDE (V, v2)");
            conn.close();
            conn = DriverManager.getConnection(ConcurrentMutationsIT.getUrl(), props);
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES('aa','aa',?, '0')");
            stmt.setTimestamp(1, new Timestamp(1000L));
            stmt.executeUpdate();
            conn.commit();
            conn.close();
            clock.setAdvance(false);
            conn = DriverManager.getConnection(ConcurrentMutationsIT.getUrl(), props);
            stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES('aa','aa',?, null)");
            Timestamp expectedTimestamp = null;
            stmt.setTimestamp(1, expectedTimestamp);
            stmt.executeUpdate();
            conn.commit();
            stmt.setTimestamp(1, new Timestamp(3000L));
            stmt.executeUpdate();
            conn.commit();
            clock.setAdvance(true);
            conn.close();
            conn = DriverManager.getConnection(ConcurrentMutationsIT.getUrl(), props);
            IndexScrutiny.scrutinizeIndex(conn, tableName, indexName);
            ResultSet rs = conn.createStatement().executeQuery("SELECT /*+ NO_INDEX */ ts,v FROM " + tableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals(expectedTimestamp, (Object)rs.getTimestamp(1));
            Assert.assertEquals(null, (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
            rs = conn.createStatement().executeQuery("SELECT \"0:TS\", \"0:V\" FROM " + indexName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals(expectedTimestamp, (Object)rs.getTimestamp(1));
            Assert.assertEquals(null, (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
            conn.close();
        }
        finally {
            EnvironmentEdgeManager.injectEdge(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetIndexedColumnToNullAndValueAtSameTSWithStoreNulls1() throws Exception {
        try {
            MyClock clock = new MyClock(1000L);
            EnvironmentEdgeManager.injectEdge((EnvironmentEdge)clock);
            String tableName = ConcurrentMutationsIT.generateUniqueName();
            String indexName = ConcurrentMutationsIT.generateUniqueName();
            Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
            Connection conn = DriverManager.getConnection(ConcurrentMutationsIT.getUrl(), props);
            conn.createStatement().execute("CREATE TABLE " + tableName + "(k1 CHAR(2) NOT NULL, k2 CHAR(2) NOT NULL, ts TIMESTAMP, V VARCHAR, V2 VARCHAR, CONSTRAINT pk PRIMARY KEY (k1,k2)) COLUMN_ENCODED_BYTES = 0, STORE_NULLS=true");
            conn.close();
            conn = DriverManager.getConnection(ConcurrentMutationsIT.getUrl(), props);
            conn.createStatement().execute("CREATE INDEX " + indexName + " ON " + tableName + "(k2,k1,ts) INCLUDE (V, v2)");
            conn.close();
            conn = DriverManager.getConnection(ConcurrentMutationsIT.getUrl(), props);
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES('aa','aa',?, '0')");
            stmt.setTimestamp(1, new Timestamp(1000L));
            stmt.executeUpdate();
            conn.commit();
            conn.close();
            clock.setAdvance(false);
            conn = DriverManager.getConnection(ConcurrentMutationsIT.getUrl(), props);
            stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES('aa','aa',?, null)");
            Timestamp expectedTimestamp = null;
            stmt.setTimestamp(1, expectedTimestamp);
            stmt.executeUpdate();
            conn.commit();
            expectedTimestamp = new Timestamp(3000L);
            stmt.setTimestamp(1, expectedTimestamp);
            stmt.executeUpdate();
            clock.setAdvance(true);
            conn.commit();
            conn.close();
            conn = DriverManager.getConnection(ConcurrentMutationsIT.getUrl(), props);
            IndexScrutiny.scrutinizeIndex(conn, tableName, indexName);
            ResultSet rs = conn.createStatement().executeQuery("SELECT /*+ NO_INDEX */ ts,v FROM " + tableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)expectedTimestamp, (Object)rs.getTimestamp(1));
            Assert.assertEquals(null, (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
            rs = conn.createStatement().executeQuery("SELECT \"0:TS\", \"0:V\" FROM " + indexName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)expectedTimestamp, (Object)rs.getTimestamp(1));
            Assert.assertEquals(null, (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
            conn.close();
        }
        finally {
            EnvironmentEdgeManager.injectEdge(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetIndexedColumnToNullAndValueAtSameTSWithStoreNulls2() throws Exception {
        try {
            long ts;
            MyClock clock = new MyClock(1000L);
            EnvironmentEdgeManager.injectEdge((EnvironmentEdge)clock);
            String tableName = ConcurrentMutationsIT.generateUniqueName();
            String indexName = ConcurrentMutationsIT.generateUniqueName();
            Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
            clock.time = ts = 1000L;
            Connection conn = DriverManager.getConnection(ConcurrentMutationsIT.getUrl(), props);
            conn.createStatement().execute("CREATE TABLE " + tableName + "(k1 CHAR(2) NOT NULL, k2 CHAR(2) NOT NULL, ts TIMESTAMP, V VARCHAR, V2 VARCHAR, CONSTRAINT pk PRIMARY KEY (k1,k2)) COLUMN_ENCODED_BYTES = 0, STORE_NULLS=true");
            conn.close();
            clock.time = ts = 1010L;
            conn = DriverManager.getConnection(ConcurrentMutationsIT.getUrl(), props);
            conn.createStatement().execute("CREATE INDEX " + indexName + " ON " + tableName + "(k2,k1,ts) INCLUDE (V, v2)");
            conn.close();
            clock.time = ts = 1020L;
            conn = DriverManager.getConnection(ConcurrentMutationsIT.getUrl(), props);
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES('aa','aa',?, '0')");
            stmt.setTimestamp(1, new Timestamp(1000L));
            stmt.executeUpdate();
            conn.commit();
            conn.close();
            clock.time = ts = 1040L;
            conn = DriverManager.getConnection(ConcurrentMutationsIT.getUrl(), props);
            stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES('aa','aa',?, null)");
            Timestamp expectedTimestamp = new Timestamp(3000L);
            stmt.setTimestamp(1, expectedTimestamp);
            stmt.executeUpdate();
            conn.commit();
            expectedTimestamp = null;
            stmt.setTimestamp(1, expectedTimestamp);
            stmt.executeUpdate();
            conn.commit();
            conn.close();
            clock.time = ts = 1050L;
            conn = DriverManager.getConnection(ConcurrentMutationsIT.getUrl(), props);
            IndexScrutiny.scrutinizeIndex(conn, tableName, indexName);
            ResultSet rs = conn.createStatement().executeQuery("SELECT /*+ NO_INDEX */ ts,v FROM " + tableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)expectedTimestamp, (Object)rs.getTimestamp(1));
            Assert.assertEquals(null, (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
            rs = conn.createStatement().executeQuery("SELECT \"0:TS\", \"0:V\" FROM " + indexName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)expectedTimestamp, (Object)rs.getTimestamp(1));
            Assert.assertEquals(null, (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
            conn.close();
        }
        finally {
            EnvironmentEdgeManager.injectEdge(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore(value="It is not possible to assign the same timestamp two separately committed mutations in the current model\n except when the server time goes backward. In that case, the behavior is not deterministic")
    @Test
    public void testDeleteRowAndUpsertValueAtSameTS1() throws Exception {
        try {
            long ts;
            MyClock clock = new MyClock(1000L);
            EnvironmentEdgeManager.injectEdge((EnvironmentEdge)clock);
            String tableName = ConcurrentMutationsIT.generateUniqueName();
            String indexName = ConcurrentMutationsIT.generateUniqueName();
            Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
            clock.time = ts = 1000L;
            Connection conn = DriverManager.getConnection(ConcurrentMutationsIT.getUrl(), props);
            conn.createStatement().execute("CREATE TABLE " + tableName + "(k1 CHAR(2) NOT NULL, k2 CHAR(2) NOT NULL, ts TIMESTAMP, A.V VARCHAR, B.V2 VARCHAR, CONSTRAINT pk PRIMARY KEY (k1,k2)) COLUMN_ENCODED_BYTES = 0, STORE_NULLS=true");
            conn.close();
            conn = DriverManager.getConnection(ConcurrentMutationsIT.getUrl(), props);
            conn.createStatement().execute("CREATE INDEX " + indexName + " ON " + tableName + "(k2,k1,ts) INCLUDE (V, v2)");
            conn.close();
            conn = DriverManager.getConnection(ConcurrentMutationsIT.getUrl(), props);
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES('aa','aa',?, '0','1')");
            stmt.setTimestamp(1, new Timestamp(1000L));
            stmt.executeUpdate();
            conn.commit();
            conn.close();
            clock.setAdvance(false);
            conn = DriverManager.getConnection(ConcurrentMutationsIT.getUrl(), props);
            stmt = conn.prepareStatement("DELETE FROM " + tableName + " WHERE (K1,K2) = ('aa','aa')");
            stmt.executeUpdate();
            conn.commit();
            Timestamp expectedTimestamp = new Timestamp(6000L);
            stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES('aa','aa',?, null,'3')");
            stmt.setTimestamp(1, expectedTimestamp);
            stmt.executeUpdate();
            conn.commit();
            clock.setAdvance(true);
            conn.close();
            conn = DriverManager.getConnection(ConcurrentMutationsIT.getUrl(), props);
            long rowCount = IndexScrutiny.scrutinizeIndex(conn, tableName, indexName);
            Assert.assertEquals((long)0L, (long)rowCount);
            conn.close();
        }
        finally {
            EnvironmentEdgeManager.injectEdge(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteRowAndUpsertValueAtSameTS2() throws Exception {
        try {
            MyClock clock = new MyClock(1000L);
            EnvironmentEdgeManager.injectEdge((EnvironmentEdge)clock);
            String tableName = ConcurrentMutationsIT.generateUniqueName();
            String indexName = ConcurrentMutationsIT.generateUniqueName();
            Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
            Connection conn = DriverManager.getConnection(ConcurrentMutationsIT.getUrl(), props);
            conn.createStatement().execute("CREATE TABLE " + tableName + "(k1 CHAR(2) NOT NULL, k2 CHAR(2) NOT NULL, ts TIMESTAMP, V VARCHAR, V2 VARCHAR, CONSTRAINT pk PRIMARY KEY (k1,k2)) COLUMN_ENCODED_BYTES = 0, STORE_NULLS=true");
            conn.close();
            conn = DriverManager.getConnection(ConcurrentMutationsIT.getUrl(), props);
            conn.createStatement().execute("CREATE INDEX " + indexName + " ON " + tableName + "(k2,k1,ts) INCLUDE (V, v2)");
            conn.close();
            conn = DriverManager.getConnection(ConcurrentMutationsIT.getUrl(), props);
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES('aa','aa',?, '0')");
            stmt.setTimestamp(1, new Timestamp(1000L));
            stmt.executeUpdate();
            conn.commit();
            conn.close();
            clock.setAdvance(false);
            conn = DriverManager.getConnection(ConcurrentMutationsIT.getUrl(), props);
            Timestamp expectedTimestamp = new Timestamp(3000L);
            stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES('aa','aa',?, null)");
            stmt.setTimestamp(1, expectedTimestamp);
            stmt.executeUpdate();
            conn.commit();
            stmt = conn.prepareStatement("DELETE FROM " + tableName + " WHERE (K1,K2) = ('aa','aa')");
            stmt.executeUpdate();
            conn.commit();
            clock.setAdvance(true);
            conn.close();
            conn = DriverManager.getConnection(ConcurrentMutationsIT.getUrl(), props);
            long rowCount = IndexScrutiny.scrutinizeIndex(conn, tableName, indexName);
            Assert.assertEquals((long)0L, (long)rowCount);
            conn.close();
        }
        finally {
            EnvironmentEdgeManager.injectEdge(null);
        }
    }

    private static class MyClock
    extends EnvironmentEdge {
        public volatile long time;
        boolean shouldAdvance = true;

        public MyClock(long time) {
            this.time = time;
        }

        public long currentTime() {
            if (this.shouldAdvance) {
                return this.time++;
            }
            return this.time;
        }

        public void setAdvance(boolean val) {
            this.shouldAdvance = val;
        }
    }
}

