/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class ColumnEncodedBytesPropIT
extends ParallelStatsDisabledIT {
    private String generateColsDDL(int numCols) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numCols; ++i) {
            if (i > 0) {
                sb.append(" , ");
            }
            sb.append("col_").append(i).append(" VARCHAR ");
        }
        return sb.toString();
    }

    @Test
    public void testValidateProperty() throws SQLException {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String dataTableFullName1 = SchemaUtil.getTableName((String)"", (String)ColumnEncodedBytesPropIT.generateUniqueName());
        String dataTableFullName2 = SchemaUtil.getTableName((String)"", (String)ColumnEncodedBytesPropIT.generateUniqueName());
        try (Connection conn = DriverManager.getConnection(ColumnEncodedBytesPropIT.getUrl(), props);){
            Statement stmt = conn.createStatement();
            String ddl = "CREATE TABLE  " + dataTableFullName1 + "  (id varchar not null, val varchar   CONSTRAINT pk PRIMARY KEY (id)) COLUMN_ENCODED_BYTES=4";
            stmt.execute(ddl);
            ddl = "CREATE TABLE  " + dataTableFullName2 + "  (id varchar not null, val varchar   CONSTRAINT pk PRIMARY KEY (id)) COLUMN_ENCODED_BYTES=NONE";
            stmt.execute(ddl);
            PhoenixConnection phxConn = conn.unwrap(PhoenixConnection.class);
            PTable dataTable1 = phxConn.getTable(new PTableKey(null, dataTableFullName1));
            Assert.assertEquals((String)"Encoding scheme set incorrectly", (Object)PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS, (Object)dataTable1.getEncodingScheme());
            PTable dataTable2 = phxConn.getTable(new PTableKey(null, dataTableFullName2));
            Assert.assertEquals((String)"Encoding scheme set incorrectly", (Object)PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, (Object)dataTable2.getEncodingScheme());
        }
    }

    @Test
    public void testValidateMaxCols() throws SQLException {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String dataTableFullName = SchemaUtil.getTableName((String)"", (String)ColumnEncodedBytesPropIT.generateUniqueName());
        try (Connection conn = DriverManager.getConnection(ColumnEncodedBytesPropIT.getUrl(), props);){
            Statement stmt = conn.createStatement();
            try {
                stmt.execute("CREATE TABLE  " + dataTableFullName + "  (id varchar not null, " + this.generateColsDDL(PTable.QualifierEncodingScheme.ONE_BYTE_QUALIFIERS.getMaxQualifier() - 11 + 2) + "  CONSTRAINT pk PRIMARY KEY (id)) COLUMN_ENCODED_BYTES=1");
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.MAX_COLUMNS_EXCEEDED.getErrorCode(), (long)e.getErrorCode());
            }
            stmt.execute("CREATE TABLE  " + dataTableFullName + "  (id varchar not null, " + this.generateColsDDL(PTable.QualifierEncodingScheme.ONE_BYTE_QUALIFIERS.getMaxQualifier() - 11 + 1) + "  CONSTRAINT pk PRIMARY KEY (id)) COLUMN_ENCODED_BYTES=1");
            try {
                stmt.execute("ALTER TABLE  " + dataTableFullName + " ADD val_x VARCHAR");
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.MAX_COLUMNS_EXCEEDED.getErrorCode(), (long)e.getErrorCode());
            }
        }
    }

    @Test
    public void testAppendOnlySchema() throws SQLException {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String dataTableFullName = SchemaUtil.getTableName((String)"", (String)ColumnEncodedBytesPropIT.generateUniqueName());
        String view1 = SchemaUtil.getTableName((String)"", (String)ColumnEncodedBytesPropIT.generateUniqueName());
        String view2 = SchemaUtil.getTableName((String)"", (String)ColumnEncodedBytesPropIT.generateUniqueName());
        try (PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(ColumnEncodedBytesPropIT.getUrl(), props);){
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE IMMUTABLE TABLE  " + dataTableFullName + "  (id varchar not null, v1 varchar   CONSTRAINT pk PRIMARY KEY (id)) COLUMN_ENCODED_BYTES=2, APPEND_ONLY_SCHEMA=true, UPDATE_CACHE_FREQUENCY=NEVER");
            stmt.execute("ALTER TABLE  " + dataTableFullName + "  ADD v2 varchar");
            stmt.execute("CREATE VIEW  " + view1 + "(v3 varchar, v4 varchar)  AS SELECT * FROM " + dataTableFullName + " WHERE v1='a'");
            stmt.execute("CREATE VIEW  " + view2 + "(v3 bigint, v4 integer)  AS SELECT * FROM " + dataTableFullName + " WHERE v1='b'");
            PTable v1 = conn.getTable(view1);
            PTable v2 = conn.getTable(view1);
            Assert.assertEquals((long)v1.getColumns().size(), (long)v2.getColumns().size());
            for (int i = 1; i < v1.getColumns().size(); ++i) {
                PColumn c1 = (PColumn)v1.getColumns().get(i);
                PColumn c2 = (PColumn)v2.getColumns().get(i);
                Assert.assertEquals((long)(11 + i - Math.abs(Short.MIN_VALUE)), (long)Bytes.toShort((byte[])c1.getColumnQualifierBytes()));
                Assert.assertEquals((long)(11 + i - Math.abs(Short.MIN_VALUE)), (long)Bytes.toShort((byte[])c2.getColumnQualifierBytes()));
            }
            try {
                stmt.execute("ALTER TABLE  " + dataTableFullName + "  ADD v5 varchar");
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.CANNOT_MUTATE_TABLE.getErrorCode(), (long)e.getErrorCode());
            }
            conn.setAutoCommit(true);
            stmt.execute("UPSERT INTO " + view1 + " VALUES('a','a','c','d','e')");
            stmt.execute("UPSERT INTO " + view2 + " VALUES('b','b','c',1, 2)");
            ResultSet rs1 = stmt.executeQuery("SELECT * FROM " + view1);
            Assert.assertTrue((boolean)rs1.next());
            Assert.assertEquals((Object)"a", (Object)rs1.getString(1));
            Assert.assertEquals((Object)"d", (Object)rs1.getString(4));
            Assert.assertEquals((Object)"e", (Object)rs1.getString(5));
            Assert.assertFalse((boolean)rs1.next());
            ResultSet rs2 = stmt.executeQuery("SELECT * FROM " + view2);
            Assert.assertTrue((boolean)rs2.next());
            Assert.assertEquals((Object)"b", (Object)rs2.getString(1));
            Assert.assertEquals((long)1L, (long)rs2.getLong(4));
            Assert.assertEquals((long)2L, (long)rs2.getInt(5));
            Assert.assertFalse((boolean)rs2.next());
        }
    }
}

