/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class CollationKeyFunctionIT
extends ParallelStatsDisabledIT {
    private String tableName;
    private String[] dataArray = new String[]{"\u963f", "\u55c4", "\u963e", "\u554a", "\u4ec8", "\u3d9a", "\u9f51", "a", "b", "\u00e4", "A", "a", "\u00e4", "A", null};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void initAndPopulateTable() throws Exception {
        Connection conn = null;
        Statement stmt = null;
        this.tableName = CollationKeyFunctionIT.generateUniqueName();
        try {
            conn = DriverManager.getConnection(CollationKeyFunctionIT.getUrl());
            String ddl = "CREATE TABLE " + this.tableName + " (id INTEGER PRIMARY KEY, data VARCHAR)";
            conn.createStatement().execute(ddl);
            for (int i = 0; i < this.dataArray.length; ++i) {
                PreparedStatement ps = conn.prepareStatement("upsert into " + this.tableName + " values(?, ?)");
                ps.setInt(1, i);
                ps.setString(2, this.dataArray[i]);
                ps.executeUpdate();
            }
            conn.commit();
        }
        finally {
            TestUtil.closeStmtAndConn(stmt, conn);
        }
    }

    @Test
    public void testZhSort() throws Exception {
        this.queryWithCollKeyDefaultArgsWithExpectedOrder("zh", false, 0, 6, new Integer[]{4, 3, 1, 5, 2, 0, 6});
    }

    @Test
    public void testZhTwSort() throws Exception {
        this.queryWithCollKeyDefaultArgsWithExpectedOrder("zh_TW", false, 0, 6, new Integer[]{4, 3, 1, 5, 2, 0, 6});
    }

    @Test
    public void testZhTwStrokeSort() throws Exception {
        this.queryWithCollKeyDefaultArgsWithExpectedOrder("zh_TW_STROKE", false, 0, 6, new Integer[]{4, 2, 0, 3, 1, 6, 5});
    }

    @Test
    public void testZhStrokeSort() throws Exception {
        this.queryWithCollKeyDefaultArgsWithExpectedOrder("zh__STROKE", false, 0, 6, new Integer[]{4, 2, 0, 3, 1, 6, 5});
    }

    @Test
    public void testZhPinyinSort() throws Exception {
        this.queryWithCollKeyDefaultArgsWithExpectedOrder("zh__PINYIN", false, 0, 6, new Integer[]{0, 1, 3, 4, 6, 2, 5});
    }

    @Test
    public void testUpperCaseSort() throws Exception {
        this.queryWithCollKeyUpperCaseWithExpectedOrder("en", 7, 13, new Integer[]{7, 10, 11, 13, 9, 12, 8});
    }

    @Test
    public void testPrimaryStrengthSort() throws Exception {
        this.queryWithCollKeyWithStrengthWithExpectedOrder("en", 0, false, 7, 13, new Integer[]{7, 9, 10, 11, 12, 13, 8});
    }

    @Test
    public void testSecondaryStrengthSort() throws Exception {
        this.queryWithCollKeyWithStrengthWithExpectedOrder("en", 1, false, 7, 13, new Integer[]{7, 10, 11, 13, 9, 12, 8});
    }

    @Test
    public void testTertiaryStrengthSort() throws Exception {
        this.queryWithCollKeyWithStrengthWithExpectedOrder("en", 2, false, 7, 13, new Integer[]{7, 11, 10, 13, 9, 12, 8});
    }

    @Test
    public void testTertiaryStrengthSortDesc() throws Exception {
        this.queryWithCollKeyWithStrengthWithExpectedOrder("en", 2, true, 7, 13, new Integer[]{8, 12, 9, 13, 10, 11, 7});
    }

    @Test
    public void testSortWithNullInputAsc() throws Exception {
        this.queryWithCollKeyDefaultArgsWithExpectedOrder("en", false, 13, 14, new Integer[]{14, 13});
    }

    @Test
    public void testSortWithNullInputDesc() throws Exception {
        this.queryWithCollKeyDefaultArgsWithExpectedOrder("en", true, 13, 14, new Integer[]{14, 13});
    }

    private void queryWithCollKeyDefaultArgsWithExpectedOrder(String localeString, boolean isDescending, Integer beginIndex, Integer endIndex, Integer[] expectedIndexOrder) throws Exception {
        String sortOrder = isDescending ? "DESC" : "";
        String query = String.format("SELECT id, data FROM %s WHERE ID BETWEEN %d AND %d ORDER BY COLLATION_KEY(data, '%s') %s", this.tableName, beginIndex, endIndex, localeString, sortOrder);
        this.queryWithExpectedOrder(query, expectedIndexOrder);
    }

    private void queryWithCollKeyUpperCaseWithExpectedOrder(String localeString, Integer beginIndex, Integer endIndex, Integer[] expectedIndexOrder) throws Exception {
        String query = String.format("SELECT id, data FROM %s WHERE ID BETWEEN %d AND %d ORDER BY COLLATION_KEY(data, '%s', true), id", this.tableName, beginIndex, endIndex, localeString);
        this.queryWithExpectedOrder(query, expectedIndexOrder);
    }

    private void queryWithCollKeyWithStrengthWithExpectedOrder(String localeString, Integer strength, boolean isDescending, Integer beginIndex, Integer endIndex, Integer[] expectedIndexOrder) throws Exception {
        String sortOrder = isDescending ? "DESC" : "";
        String query = String.format("SELECT id, data FROM %s WHERE ID BETWEEN %d AND %d ORDER BY COLLATION_KEY(data, '%s', false, %d) %s, id %s", this.tableName, beginIndex, endIndex, localeString, strength, sortOrder, sortOrder);
        this.queryWithExpectedOrder(query, expectedIndexOrder);
    }

    private void queryWithExpectedOrder(String query, Integer[] expectedIndexOrder) throws Exception {
        Connection conn = DriverManager.getConnection(CollationKeyFunctionIT.getUrl());
        PreparedStatement ps = conn.prepareStatement(query);
        ResultSet rs = ps.executeQuery();
        int i = 0;
        while (rs.next()) {
            int expectedId = expectedIndexOrder[i];
            Assert.assertEquals((String)("For row " + i + ": The ID did not match the expected index"), (long)expectedId, (long)rs.getInt(1));
            Assert.assertEquals((String)("For row " + i + ": The data did not match the expected entry from the data array"), (Object)this.dataArray[expectedId], (Object)rs.getString(2));
            ++i;
        }
        Assert.assertEquals((String)"The result set returned a different number of rows from the data array", (long)expectedIndexOrder.length, (long)i);
    }
}

