/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class CoalesceFunctionIT
extends ParallelStatsDisabledIT {
    @Test
    public void testCoalesce() throws Exception {
        String tenantId = CoalesceFunctionIT.getOrganizationId();
        String tableName = CoalesceFunctionIT.initATableValues(tenantId, CoalesceFunctionIT.getDefaultSplits(tenantId), CoalesceFunctionIT.getUrl());
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(CoalesceFunctionIT.getUrl(), props);
        String query = "SELECT entity_id, a_integer + COALESCE(x_integer,1) FROM " + tableName + " WHERE organization_id = ? AND a_integer >= 6 AND a_integer <= 7";
        PreparedStatement statement = conn.prepareStatement(query);
        statement.setString(1, tenantId);
        ResultSet rs = statement.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"00B623122312312", (Object)rs.getString(1));
        Assert.assertEquals((long)7L, (long)rs.getInt(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"00B723122312312", (Object)rs.getString(1));
        Assert.assertEquals((long)12L, (long)rs.getInt(2));
        Assert.assertFalse((boolean)rs.next());
        conn.close();
    }

    @Test
    public void coalesceWithSumExplicitLong() throws Exception {
        Connection conn = DriverManager.getConnection(CoalesceFunctionIT.getUrl());
        String tableName = CoalesceFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE " + tableName + "(    ID BIGINT NOT NULL,     \"COUNT\" BIGINT     CONSTRAINT pk PRIMARY KEY(ID))";
        conn.createStatement().execute(ddl);
        conn.createStatement().execute("UPSERT INTO " + tableName + "(ID, \"COUNT\") VALUES(2, null)");
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT COALESCE(SUM(\"COUNT\"), CAST(0 AS BIGINT)) FROM  " + tableName + " GROUP BY ID");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)0L, (long)rs.getLong(1));
        Assert.assertFalse((boolean)rs.wasNull());
    }

    @Test
    public void coalesceWithSumImplicitLong() throws Exception {
        Connection conn = DriverManager.getConnection(CoalesceFunctionIT.getUrl());
        String tableName = CoalesceFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE " + tableName + "(    ID BIGINT NOT NULL,     \"COUNT\" BIGINT     CONSTRAINT pk PRIMARY KEY(ID))";
        conn.createStatement().execute(ddl);
        conn.createStatement().execute("UPSERT INTO " + tableName + "(ID, \"COUNT\") VALUES(2, null)");
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT COALESCE(SUM(\"COUNT\"), 0) FROM " + tableName + " GROUP BY ID");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)0L, (long)rs.getLong(1));
        Assert.assertFalse((boolean)rs.wasNull());
    }

    @Test
    public void coalesceWithSecondParamAsExpression() throws Exception {
        Connection conn = DriverManager.getConnection(CoalesceFunctionIT.getUrl());
        String tableName = CoalesceFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE " + tableName + "(    ID BIGINT NOT NULL,     \"COUNT\" BIGINT     CONSTRAINT pk PRIMARY KEY(ID))";
        conn.createStatement().execute(ddl);
        conn.createStatement().execute("UPSERT INTO " + tableName + "(ID, \"COUNT\") VALUES(2, null)");
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT COALESCE(SUM(\"COUNT\"), SUM(ID)) FROM " + tableName + " GROUP BY ID");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)2L, (long)rs.getLong(1));
        Assert.assertFalse((boolean)rs.wasNull());
    }

    @Test
    public void nonTypedSecondParameterLong() throws Exception {
        Connection conn = DriverManager.getConnection(CoalesceFunctionIT.getUrl());
        String tableName = CoalesceFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE " + tableName + "(    ID BIGINT NOT NULL,     \"COUNT\" BIGINT     CONSTRAINT pk PRIMARY KEY(ID))";
        conn.createStatement().execute(ddl);
        conn.createStatement().execute("UPSERT INTO " + tableName + "(ID, \"COUNT\") VALUES(2, null)");
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT COALESCE(NTH_VALUE(\"COUNT\", 100) WITHIN GROUP (ORDER BY \"COUNT\" DESC), 0) FROM " + tableName + " GROUP BY ID");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)0L, (long)rs.getLong(1));
        Assert.assertFalse((boolean)rs.wasNull());
    }

    @Test
    public void nonTypedSecondParameterUnsignedDataTypes() throws Exception {
        Connection conn = DriverManager.getConnection(CoalesceFunctionIT.getUrl());
        String tableName = CoalesceFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE " + tableName + "(    ID BIGINT NOT NULL,     \"COUNT\" UNSIGNED_INT     CONSTRAINT pk PRIMARY KEY(ID))";
        conn.createStatement().execute(ddl);
        conn.createStatement().execute("UPSERT INTO " + tableName + " (ID, \"COUNT\") VALUES(2, null)");
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT  COALESCE(NTH_VALUE(\"COUNT\", 100) WITHIN GROUP (ORDER BY \"COUNT\" DESC), 1)  FROM " + tableName + " GROUP BY ID");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.wasNull());
    }

    @Test
    public void testWithNthValueAggregationFunction() throws Exception {
        Connection conn = DriverManager.getConnection(CoalesceFunctionIT.getUrl());
        String tableName = CoalesceFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE " + tableName + "(    ID BIGINT NOT NULL,     \"DATE\" TIMESTAMP NOT NULL,     \"COUNT\" BIGINT     CONSTRAINT pk PRIMARY KEY(ID, \"DATE\"))";
        conn.createStatement().execute(ddl);
        conn.createStatement().execute("UPSERT INTO " + tableName + "(ID, \"DATE\", \"COUNT\") VALUES(1, CURRENT_TIME(), 1)");
        conn.createStatement().execute("UPSERT INTO " + tableName + "(ID, \"DATE\", \"COUNT\") VALUES(1, CURRENT_TIME(), 2)");
        conn.createStatement().execute("UPSERT INTO " + tableName + "(ID, \"DATE\", \"COUNT\") VALUES(2, CURRENT_TIME(), 1)");
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT  COALESCE(            NTH_VALUE(\"COUNT\", 2000)            WITHIN GROUP (ORDER BY \"COUNT\" DESC),       0)FROM  " + tableName + " GROUP BY ID");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)0L, (long)rs.getLong(1));
        Assert.assertFalse((boolean)rs.wasNull());
    }

    @Test
    public void wrongDataTypeOfSecondParameter() throws Exception {
        Connection conn = DriverManager.getConnection(CoalesceFunctionIT.getUrl());
        String tableName = CoalesceFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE " + tableName + "(    ID UNSIGNED_INT NOT NULL,     \"COUNT\" UNSIGNED_INT     CONSTRAINT pk PRIMARY KEY(ID))";
        conn.createStatement().execute(ddl);
        conn.createStatement().execute("UPSERT INTO " + tableName + "(ID, \"COUNT\") VALUES(2, null)");
        conn.commit();
        try {
            conn.createStatement().executeQuery("SELECT COALESCE(MIN(\"COUNT\"), -1) FROM " + tableName + " GROUP BY ID");
            Assert.fail((String)"CANNOT CONVERT TYPE exception expected");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Test
    public void testImplicitSecondArgCastingException() throws Exception {
        Connection conn = DriverManager.getConnection(CoalesceFunctionIT.getUrl());
        String tableName = CoalesceFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE " + tableName + "(    ID INTEGER NOT NULL,     \"COUNT\" UNSIGNED_INT     CONSTRAINT pk PRIMARY KEY(ID))";
        conn.createStatement().execute(ddl);
        conn.createStatement().execute("UPSERT INTO " + tableName + "(ID, \"COUNT\") VALUES(-2, null)");
        conn.commit();
        try {
            ResultSet rs = conn.createStatement().executeQuery("SELECT COALESCE(MIN(\"COUNT\"), ID) FROM " + tableName + " GROUP BY ID");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)0L, (long)rs.getLong(1));
            Assert.fail((String)"Should not cast -2 to UNSIGNED_INT");
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.ILLEGAL_DATA.getErrorCode(), (long)e.getErrorCode());
        }
    }

    @Test
    public void testImplicitSecondArgCasting() throws Exception {
        Connection conn = DriverManager.getConnection(CoalesceFunctionIT.getUrl());
        String tableName = CoalesceFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE " + tableName + "(    ID DOUBLE NOT NULL,     \"COUNT\" INTEGER     CONSTRAINT pk PRIMARY KEY(ID))";
        conn.createStatement().execute(ddl);
        conn.createStatement().execute("UPSERT INTO " + tableName + "(ID, \"COUNT\") VALUES(2.0, null)");
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT COALESCE(MIN(\"COUNT\"), ID) FROM " + tableName + " GROUP BY ID");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)2L, (long)rs.getLong(1));
        Assert.assertFalse((boolean)rs.wasNull());
    }

    @Test
    public void testCoalesceInRowKeyColumn() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(CoalesceFunctionIT.getUrl(), props);
        String tableName = CoalesceFunctionIT.generateUniqueName();
        conn.createStatement().execute("CREATE TABLE " + tableName + "(k1 decimal, k2 decimal, constraint pk primary key (k1,k2))");
        conn.createStatement().execute("UPSERT INTO " + tableName + "(k2) VALUES (1)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES (2,2)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES (3,3)");
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT coalesce(k1, 1) ,k2 FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertEquals((long)1L, (long)rs.getInt(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)2L, (long)rs.getInt(1));
        Assert.assertEquals((long)2L, (long)rs.getInt(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)3L, (long)rs.getInt(1));
        Assert.assertEquals((long)3L, (long)rs.getInt(2));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testNull() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(CoalesceFunctionIT.getUrl(), props);
        String tableName = CoalesceFunctionIT.generateUniqueName();
        conn.createStatement().execute("CREATE TABLE " + tableName + "(k1 decimal, k2 decimal, constraint pk primary key (k1))");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES (1,1)");
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT coalesce(null, null) FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        rs.getInt(1);
        Assert.assertTrue((boolean)rs.wasNull());
        Assert.assertFalse((boolean)rs.next());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCoalesceFunction() throws Exception {
        String tenantId = CoalesceFunctionIT.getOrganizationId();
        String tableName = CoalesceFunctionIT.initATableValues(CoalesceFunctionIT.generateUniqueName(), tenantId, CoalesceFunctionIT.getDefaultSplits(tenantId), new Date(System.currentTimeMillis()), null, CoalesceFunctionIT.getUrl(), null);
        String query = "SELECT entity_id FROM " + tableName + " WHERE coalesce(X_DECIMAL,0.0) = 0.0";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(CoalesceFunctionIT.getUrl(), props);
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO  " + tableName + " (organization_id,entity_id,x_decimal) values(?,?,?)");
        stmt.setString(1, CoalesceFunctionIT.getOrganizationId());
        stmt.setString(2, "00A123122312312");
        stmt.setBigDecimal(3, BigDecimal.valueOf(1.0));
        stmt.execute();
        stmt.setString(2, "00A323122312312");
        stmt.setBigDecimal(3, BigDecimal.valueOf(2.0));
        stmt.execute();
        stmt.setString(2, "00A423122312312");
        stmt.setBigDecimal(3, BigDecimal.valueOf(3.0));
        stmt.execute();
        stmt.setString(2, "00B523122312312");
        stmt.setBigDecimal(3, BigDecimal.valueOf(0.0));
        stmt.execute();
        stmt.setString(2, "00B623122312312");
        stmt.setBigDecimal(3, BigDecimal.valueOf(4.0));
        stmt.execute();
        conn.commit();
        conn = DriverManager.getConnection(CoalesceFunctionIT.getUrl(), props);
        try {
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"00A223122312312");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"00B523122312312");
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }
}

