/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.io.FileUtils;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixTestDriver;
import org.apache.phoenix.schema.IllegalDataException;
import org.apache.phoenix.schema.types.PArrayDataType;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.phoenix.util.CSVCommonsLoader;
import org.apache.phoenix.util.DateUtil;
import org.apache.phoenix.util.PhoenixRuntime;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TemporaryFolder;

@Category(value={ParallelStatsDisabledTest.class})
public class CSVCommonsLoaderIT
extends ParallelStatsDisabledIT {
    private static final String DATATYPE_TABLE = "DATATYPE";
    private static final String DATATYPES_CSV_VALUES = "CKEY, CVARCHAR, CCHAR, CINTEGER, CDECIMAL, CUNSIGNED_INT, CBOOLEAN, CBIGINT, CUNSIGNED_LONG, CTIME, CDATE\nKEY1,A,A,2147483647,1.1,0,TRUE,9223372036854775807,0,1990-12-31 10:59:59,1999-12-31 23:59:59\nKEY2,B,B,-2147483648,-1.1,2147483647,FALSE,-9223372036854775808,9223372036854775807,2000-01-01 00:00:01,2012-02-29 23:59:59\nKEY3,,,,,,,,,,\n";
    private static final String STOCK_CSV_VALUES = "AAPL,APPLE Inc.\nCRM,SALESFORCE\nGOOG,Google\nHOG,Harlet-Davidson Inc.\nHPQ,Hewlett Packard\nINTC,Intel\nMSFT,Microsoft\nWAG,Walgreens\nWMT,Walmart\n";
    private static final String[] STOCK_COLUMNS_WITH_BOGUS = new String[]{"SYMBOL", "BOGUS"};
    private static final String[] STOCK_COLUMNS = new String[]{"SYMBOL", "COMPANY"};
    private static final String STOCK_CSV_VALUES_WITH_HEADER = STOCK_COLUMNS[0] + "," + STOCK_COLUMNS[1] + "\n" + "AAPL,APPLE Inc.\nCRM,SALESFORCE\nGOOG,Google\nHOG,Harlet-Davidson Inc.\nHPQ,Hewlett Packard\nINTC,Intel\nMSFT,Microsoft\nWAG,Walgreens\nWMT,Walmart\n";
    private static final String STOCK_CSV_VALUES_WITH_DELIMITER = "APPL\u0001\u0002APPLE\n Inc\u0002\nMSFT\u0001Microsoft\n";
    private static final String STOCK_TDV_VALUES = "AAPL\tAPPLE Inc\nCRM\tSALESFORCE\nGOOG\tGoogle\nHOG\tHarlet-Davidson Inc.\nHPQ\tHewlett Packard\nINTC\tIntel\nMSFT\tMicrosoft\nWAG\tWalgreens\nWMT\tWalmart\n";
    private static final String STOCK_TDV_VALUES_WITH_HEADER = STOCK_COLUMNS[0] + "\t" + STOCK_COLUMNS[1] + "\n" + "AAPL\tAPPLE Inc\nCRM\tSALESFORCE\nGOOG\tGoogle\nHOG\tHarlet-Davidson Inc.\nHPQ\tHewlett Packard\nINTC\tIntel\nMSFT\tMicrosoft\nWAG\tWalgreens\nWMT\tWalmart\n";
    private static final String ENCAPSULATED_CHARS_TABLE = "ENCAPSULATEDCHAR";
    private static final String[] ENCAPSULATED_CHARS_COLUMNS = new String[]{"MYKEY", "MYVALUE"};
    private static final String CSV_VALUES_ENCAPSULATED_CONTROL_CHARS = "ALL THREEF,\"This has a all three , , \"\" \r\n in it. \"\nCOMMA,\"This has a comma , in it. \"\nCRLF,\"This has a crlf \r\n in it. \"\nQUOTE,\"This has a quote \"\" in it. \"\n";
    private static final String CSV_VALUES_ENCAPSULATED_CONTROL_CHARS_WITH_HEADER = ENCAPSULATED_CHARS_COLUMNS[0] + "," + ENCAPSULATED_CHARS_COLUMNS[1] + "\n" + "ALL THREEF,\"This has a all three , , \"\" \r\n in it. \"\nCOMMA,\"This has a comma , in it. \"\nCRLF,\"This has a crlf \r\n in it. \"\nQUOTE,\"This has a quote \"\" in it. \"\n";
    private static final String CSV_VALUES_BAD_ENCAPSULATED_CONTROL_CHARS = "ALL THREEF,\"This has a all three , , \"\" \r\n in it. \"\nCOMMA,\"This has a comma , in it. \"\nCRLF,\"This has a crlf \r\n in it. \"\nBADENCAPSULATEDQUOTE,\"\"This has a bad quote in it. \"\n";
    private static final String CSV_VALUES_BAD_ENCAPSULATED_CONTROL_CHARS_WITH_HEADER = ENCAPSULATED_CHARS_COLUMNS[0] + "," + ENCAPSULATED_CHARS_COLUMNS[1] + "\n" + "ALL THREEF,\"This has a all three , , \"\" \r\n in it. \"\nCOMMA,\"This has a comma , in it. \"\nCRLF,\"This has a crlf \r\n in it. \"\nBADENCAPSULATEDQUOTE,\"\"This has a bad quote in it. \"\n";
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCSVCommonsUpsert() throws Exception {
        CSVParser parser = null;
        PhoenixConnection conn = null;
        try {
            String stockTableName = CSVCommonsLoaderIT.generateUniqueName();
            String statements = "CREATE TABLE IF NOT EXISTS " + stockTableName + "(SYMBOL VARCHAR NOT NULL PRIMARY KEY, COMPANY VARCHAR);";
            conn = DriverManager.getConnection(CSVCommonsLoaderIT.getUrl()).unwrap(PhoenixConnection.class);
            PhoenixRuntime.executeStatements((Connection)conn, (Reader)new StringReader(statements), null);
            CSVCommonsLoader csvUtil = new CSVCommonsLoader(conn, stockTableName, Collections.emptyList(), true);
            csvUtil.upsert((Reader)new StringReader(STOCK_CSV_VALUES_WITH_HEADER));
            PreparedStatement statement = conn.prepareStatement("SELECT SYMBOL, COMPANY FROM " + stockTableName);
            ResultSet phoenixResultSet = statement.executeQuery();
            parser = new CSVParser((Reader)new StringReader(STOCK_CSV_VALUES_WITH_HEADER), csvUtil.getFormat());
            for (CSVRecord record : parser) {
                Assert.assertTrue((boolean)phoenixResultSet.next());
                int i = 0;
                for (String value : record) {
                    Assert.assertEquals((Object)value, (Object)phoenixResultSet.getString(i + 1));
                    ++i;
                }
            }
            Assert.assertFalse((boolean)phoenixResultSet.next());
        }
        finally {
            if (parser != null) {
                parser.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCSVCommonsUpsert_MultiTenant() throws Exception {
        CSVParser parser = null;
        PhoenixConnection globalConn = null;
        PhoenixConnection tenantConn = null;
        try {
            String stockTableMultiName = CSVCommonsLoaderIT.generateUniqueName();
            String statements = "CREATE TABLE IF NOT EXISTS " + stockTableMultiName + "(TENANT_ID VARCHAR NOT NULL, SYMBOL VARCHAR NOT NULL, COMPANY VARCHAR, CONSTRAINT PK PRIMARY KEY(TENANT_ID,SYMBOL)) MULTI_TENANT = true;";
            globalConn = DriverManager.getConnection(CSVCommonsLoaderIT.getUrl()).unwrap(PhoenixConnection.class);
            PhoenixRuntime.executeStatements((Connection)globalConn, (Reader)new StringReader(statements), null);
            globalConn.close();
            tenantConn = new PhoenixTestDriver().connect(CSVCommonsLoaderIT.getUrl() + ";TenantId=acme", new Properties()).unwrap(PhoenixConnection.class);
            CSVCommonsLoader csvUtil = new CSVCommonsLoader(tenantConn, stockTableMultiName, Collections.emptyList(), true);
            csvUtil.upsert((Reader)new StringReader(STOCK_CSV_VALUES_WITH_HEADER));
            PreparedStatement statement = tenantConn.prepareStatement("SELECT SYMBOL, COMPANY FROM " + stockTableMultiName);
            ResultSet phoenixResultSet = statement.executeQuery();
            parser = new CSVParser((Reader)new StringReader(STOCK_CSV_VALUES_WITH_HEADER), csvUtil.getFormat());
            for (CSVRecord record : parser) {
                Assert.assertTrue((boolean)phoenixResultSet.next());
                int i = 0;
                for (String value : record) {
                    Assert.assertEquals((Object)value, (Object)phoenixResultSet.getString(i + 1));
                    ++i;
                }
            }
            Assert.assertFalse((boolean)phoenixResultSet.next());
        }
        finally {
            if (parser != null) {
                parser.close();
            }
            if (tenantConn != null) {
                tenantConn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTDVCommonsUpsert() throws Exception {
        CSVParser parser = null;
        PhoenixConnection conn = null;
        try {
            String stockTableName = CSVCommonsLoaderIT.generateUniqueName();
            String statements = "CREATE TABLE IF NOT EXISTS " + stockTableName + "(SYMBOL VARCHAR NOT NULL PRIMARY KEY, COMPANY VARCHAR);";
            conn = DriverManager.getConnection(CSVCommonsLoaderIT.getUrl()).unwrap(PhoenixConnection.class);
            PhoenixRuntime.executeStatements((Connection)conn, (Reader)new StringReader(statements), null);
            CSVCommonsLoader csvUtil = new CSVCommonsLoader(conn, stockTableName, Collections.emptyList(), true, '\t', '\"', null, ":");
            csvUtil.upsert((Reader)new StringReader(STOCK_TDV_VALUES_WITH_HEADER));
            PreparedStatement statement = conn.prepareStatement("SELECT SYMBOL, COMPANY FROM " + stockTableName);
            ResultSet phoenixResultSet = statement.executeQuery();
            parser = new CSVParser((Reader)new StringReader(STOCK_TDV_VALUES_WITH_HEADER), csvUtil.getFormat());
            for (CSVRecord record : parser) {
                Assert.assertTrue((boolean)phoenixResultSet.next());
                int i = 0;
                for (String value : record) {
                    Assert.assertEquals((Object)value, (Object)phoenixResultSet.getString(i + 1));
                    ++i;
                }
            }
            Assert.assertFalse((boolean)phoenixResultSet.next());
        }
        finally {
            if (parser != null) {
                parser.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCSVUpsertWithCustomDelimiters() throws Exception {
        CSVParser parser = null;
        PhoenixConnection conn = null;
        try {
            String stockTableName = CSVCommonsLoaderIT.generateUniqueName();
            String statements = "CREATE TABLE IF NOT EXISTS " + stockTableName + "(SYMBOL VARCHAR NOT NULL PRIMARY KEY, COMPANY VARCHAR);";
            conn = DriverManager.getConnection(CSVCommonsLoaderIT.getUrl()).unwrap(PhoenixConnection.class);
            PhoenixRuntime.executeStatements((Connection)conn, (Reader)new StringReader(statements), null);
            CSVCommonsLoader csvUtil = new CSVCommonsLoader(conn, stockTableName, Arrays.asList(STOCK_COLUMNS), true, '1', '2', Character.valueOf('3'), ":");
            csvUtil.upsert((Reader)new StringReader(STOCK_CSV_VALUES_WITH_DELIMITER));
            PreparedStatement statement = conn.prepareStatement("SELECT SYMBOL, COMPANY FROM " + stockTableName);
            ResultSet phoenixResultSet = statement.executeQuery();
            parser = new CSVParser((Reader)new StringReader(STOCK_CSV_VALUES_WITH_DELIMITER), csvUtil.getFormat());
            for (CSVRecord record : parser) {
                Assert.assertTrue((boolean)phoenixResultSet.next());
                int i = 0;
                for (String value : record) {
                    Assert.assertEquals((Object)value, (Object)phoenixResultSet.getString(i + 1));
                    ++i;
                }
            }
            Assert.assertFalse((boolean)phoenixResultSet.next());
        }
        finally {
            if (parser != null) {
                parser.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCSVUpsertWithColumns() throws Exception {
        CSVParser parser = null;
        PhoenixConnection conn = null;
        try {
            String stockTableName = CSVCommonsLoaderIT.generateUniqueName();
            String statements = "CREATE TABLE IF NOT EXISTS " + stockTableName + "(SYMBOL VARCHAR NOT NULL PRIMARY KEY, COMPANY VARCHAR);";
            conn = DriverManager.getConnection(CSVCommonsLoaderIT.getUrl()).unwrap(PhoenixConnection.class);
            PhoenixRuntime.executeStatements((Connection)conn, (Reader)new StringReader(statements), null);
            CSVCommonsLoader csvUtil = new CSVCommonsLoader(conn, stockTableName, Arrays.asList(STOCK_COLUMNS), true);
            csvUtil.upsert((Reader)new StringReader(STOCK_CSV_VALUES));
            PreparedStatement statement = conn.prepareStatement("SELECT SYMBOL, COMPANY FROM " + stockTableName);
            ResultSet phoenixResultSet = statement.executeQuery();
            parser = new CSVParser((Reader)new StringReader(STOCK_CSV_VALUES), csvUtil.getFormat());
            for (CSVRecord record : parser) {
                Assert.assertTrue((boolean)phoenixResultSet.next());
                int i = 0;
                for (String value : record) {
                    Assert.assertEquals((Object)value, (Object)phoenixResultSet.getString(i + 1));
                    ++i;
                }
            }
            Assert.assertFalse((boolean)phoenixResultSet.next());
        }
        finally {
            if (parser != null) {
                parser.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCSVUpsertWithNoColumns() throws Exception {
        CSVParser parser = null;
        PhoenixConnection conn = null;
        try {
            String stockTableName = CSVCommonsLoaderIT.generateUniqueName();
            String statements = "CREATE TABLE IF NOT EXISTS " + stockTableName + "(SYMBOL VARCHAR NOT NULL PRIMARY KEY, COMPANY VARCHAR);";
            conn = DriverManager.getConnection(CSVCommonsLoaderIT.getUrl()).unwrap(PhoenixConnection.class);
            PhoenixRuntime.executeStatements((Connection)conn, (Reader)new StringReader(statements), null);
            CSVCommonsLoader csvUtil = new CSVCommonsLoader(conn, stockTableName, null, true);
            csvUtil.upsert((Reader)new StringReader(STOCK_CSV_VALUES));
            PreparedStatement statement = conn.prepareStatement("SELECT SYMBOL, COMPANY FROM " + stockTableName);
            ResultSet phoenixResultSet = statement.executeQuery();
            parser = new CSVParser((Reader)new StringReader(STOCK_CSV_VALUES), csvUtil.getFormat());
            for (CSVRecord record : parser) {
                Assert.assertTrue((boolean)phoenixResultSet.next());
                int i = 0;
                for (String value : record) {
                    Assert.assertEquals((Object)value, (Object)phoenixResultSet.getString(i + 1));
                    ++i;
                }
            }
            Assert.assertFalse((boolean)phoenixResultSet.next());
        }
        finally {
            if (parser != null) {
                parser.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCSVUpsertWithBogusColumn() throws Exception {
        CSVParser parser = null;
        PhoenixConnection conn = null;
        try {
            String stockTableName = CSVCommonsLoaderIT.generateUniqueName();
            String statements = "CREATE TABLE IF NOT EXISTS " + stockTableName + "(SYMBOL VARCHAR NOT NULL PRIMARY KEY, COMPANY VARCHAR);";
            conn = DriverManager.getConnection(CSVCommonsLoaderIT.getUrl()).unwrap(PhoenixConnection.class);
            PhoenixRuntime.executeStatements((Connection)conn, (Reader)new StringReader(statements), null);
            CSVCommonsLoader csvUtil = new CSVCommonsLoader(conn, stockTableName, Arrays.asList(STOCK_COLUMNS_WITH_BOGUS), false);
            csvUtil.upsert((Reader)new StringReader(STOCK_CSV_VALUES));
            PreparedStatement statement = conn.prepareStatement("SELECT SYMBOL, COMPANY FROM " + stockTableName);
            ResultSet phoenixResultSet = statement.executeQuery();
            parser = new CSVParser((Reader)new StringReader(STOCK_CSV_VALUES), csvUtil.getFormat());
            for (CSVRecord record : parser) {
                Assert.assertTrue((boolean)phoenixResultSet.next());
                Assert.assertEquals((Object)record.get(0), (Object)phoenixResultSet.getString(1));
                Assert.assertNull((Object)phoenixResultSet.getString(2));
            }
            Assert.assertFalse((boolean)phoenixResultSet.next());
        }
        finally {
            if (parser != null) {
                parser.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCSVUpsertWithInvalidNumericalData_StrictMode() throws Exception {
        Object parser = null;
        PhoenixConnection conn = null;
        try {
            String stockTableName = CSVCommonsLoaderIT.generateUniqueName();
            String statements = "CREATE TABLE IF NOT EXISTS " + stockTableName + "(SYMBOL VARCHAR NOT NULL PRIMARY KEY, COMPANY_ID BIGINT);";
            conn = DriverManager.getConnection(CSVCommonsLoaderIT.getUrl()).unwrap(PhoenixConnection.class);
            PhoenixRuntime.executeStatements((Connection)conn, (Reader)new StringReader(statements), null);
            CSVCommonsLoader csvUtil = new CSVCommonsLoader(conn, stockTableName, Arrays.asList("SYMBOL", "COMPANY_ID"), true);
            try {
                csvUtil.upsert((Reader)new StringReader(STOCK_CSV_VALUES));
                Assert.fail((String)"Running an upsert with data that can't be upserted in strict mode should throw an exception");
            }
            catch (IllegalDataException illegalDataException) {
                // empty catch block
            }
        }
        finally {
            if (parser != null) {
                parser.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCSVUpsertWithAllColumn() throws Exception {
        Object parser = null;
        PhoenixConnection conn = null;
        try {
            String stockTableName = CSVCommonsLoaderIT.generateUniqueName();
            String statements = "CREATE TABLE IF NOT EXISTS " + stockTableName + "(SYMBOL VARCHAR NOT NULL PRIMARY KEY, COMPANY VARCHAR);";
            conn = DriverManager.getConnection(CSVCommonsLoaderIT.getUrl()).unwrap(PhoenixConnection.class);
            PhoenixRuntime.executeStatements((Connection)conn, (Reader)new StringReader(statements), null);
            CSVCommonsLoader csvUtil = new CSVCommonsLoader(conn, stockTableName, Arrays.asList("FOO", "BAR"), false);
            try {
                csvUtil.upsert((Reader)new StringReader(STOCK_CSV_VALUES));
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("ERROR 504 (42703): Undefined column. columnName=" + stockTableName + ".[FOO, BAR]"));
            }
        }
        finally {
            if (parser != null) {
                parser.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCSVUpsertWithBogusColumnStrict() throws Exception {
        Object parser = null;
        PhoenixConnection conn = null;
        try {
            String stockTableName = CSVCommonsLoaderIT.generateUniqueName();
            String statements = "CREATE TABLE IF NOT EXISTS " + stockTableName + "(SYMBOL VARCHAR NOT NULL PRIMARY KEY, COMPANY VARCHAR);";
            conn = DriverManager.getConnection(CSVCommonsLoaderIT.getUrl()).unwrap(PhoenixConnection.class);
            PhoenixRuntime.executeStatements((Connection)conn, (Reader)new StringReader(statements), null);
            CSVCommonsLoader csvUtil = new CSVCommonsLoader(conn, stockTableName, Arrays.asList(STOCK_COLUMNS_WITH_BOGUS), true);
            try {
                csvUtil.upsert((Reader)new StringReader(STOCK_CSV_VALUES));
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("ERROR 504 (42703): Undefined column. columnName=" + stockTableName + ".BOGUS"));
            }
        }
        finally {
            if (parser != null) {
                parser.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAllDatatypes() throws Exception {
        CSVParser parser = null;
        PhoenixConnection conn = null;
        try {
            String statements = "CREATE TABLE IF NOT EXISTS DATATYPE (CKEY VARCHAR NOT NULL PRIMARY KEY,  CVARCHAR VARCHAR, CCHAR CHAR(10), CINTEGER INTEGER, CDECIMAL DECIMAL(31,10), CUNSIGNED_INT UNSIGNED_INT, CBOOLEAN BOOLEAN, CBIGINT BIGINT, CUNSIGNED_LONG UNSIGNED_LONG, CTIME TIME, CDATE DATE);";
            conn = DriverManager.getConnection(CSVCommonsLoaderIT.getUrl()).unwrap(PhoenixConnection.class);
            PhoenixRuntime.executeStatements((Connection)conn, (Reader)new StringReader(statements), null);
            CSVCommonsLoader csvUtil = new CSVCommonsLoader(conn, DATATYPE_TABLE, Collections.emptyList(), true);
            csvUtil.upsert((Reader)new StringReader(DATATYPES_CSV_VALUES));
            PreparedStatement statement = conn.prepareStatement("SELECT CKEY, CVARCHAR, CCHAR, CINTEGER, CDECIMAL, CUNSIGNED_INT, CBOOLEAN, CBIGINT, CUNSIGNED_LONG, CTIME, CDATE FROM DATATYPE");
            ResultSet phoenixResultSet = statement.executeQuery();
            parser = new CSVParser((Reader)new StringReader(DATATYPES_CSV_VALUES), csvUtil.getFormat());
            for (CSVRecord record : parser) {
                String timeFieldValue;
                Assert.assertTrue((boolean)phoenixResultSet.next());
                int i = 0;
                int size = record.size();
                for (String value : record) {
                    Assert.assertEquals((Object)value, (Object)phoenixResultSet.getObject(i + 1).toString().toUpperCase());
                    if (i < size - 2) break;
                    ++i;
                }
                Assert.assertEquals((Object)((timeFieldValue = record.get(9)).isEmpty() ? null : DateUtil.parseTime((String)record.get(9))), (Object)phoenixResultSet.getTime("CTIME"));
                String dateField = record.get(10);
                Assert.assertEquals((Object)(dateField.isEmpty() ? null : DateUtil.parseDate((String)record.get(10))), (Object)phoenixResultSet.getDate("CDATE"));
            }
            Assert.assertFalse((boolean)phoenixResultSet.next());
        }
        finally {
            if (parser != null) {
                parser.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCSVCommonsUpsertEncapsulatedControlChars() throws Exception {
        CSVParser parser = null;
        PhoenixConnection conn = null;
        try {
            String statements = "CREATE TABLE IF NOT EXISTS ENCAPSULATEDCHAR(MYKEY VARCHAR NOT NULL PRIMARY KEY, MYVALUE VARCHAR);";
            conn = DriverManager.getConnection(CSVCommonsLoaderIT.getUrl()).unwrap(PhoenixConnection.class);
            PhoenixRuntime.executeStatements((Connection)conn, (Reader)new StringReader(statements), null);
            CSVCommonsLoader csvUtil = new CSVCommonsLoader(conn, ENCAPSULATED_CHARS_TABLE, Collections.emptyList(), true);
            csvUtil.upsert((Reader)new StringReader(CSV_VALUES_ENCAPSULATED_CONTROL_CHARS_WITH_HEADER));
            PreparedStatement statement = conn.prepareStatement("SELECT MYKEY, MYVALUE FROM ENCAPSULATEDCHAR");
            ResultSet phoenixResultSet = statement.executeQuery();
            parser = new CSVParser((Reader)new StringReader(CSV_VALUES_ENCAPSULATED_CONTROL_CHARS_WITH_HEADER), csvUtil.getFormat());
            for (CSVRecord record : parser) {
                Assert.assertTrue((boolean)phoenixResultSet.next());
                int i = 0;
                for (String value : record) {
                    Assert.assertEquals((Object)value, (Object)phoenixResultSet.getString(i + 1));
                    ++i;
                }
            }
            Assert.assertFalse((boolean)phoenixResultSet.next());
        }
        finally {
            if (parser != null) {
                parser.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCSVCommonsUpsertBadEncapsulatedControlChars() throws Exception {
        Object parser = null;
        PhoenixConnection conn = null;
        try {
            String statements = "CREATE TABLE IF NOT EXISTS ENCAPSULATEDCHAR(MYKEY VARCHAR NOT NULL PRIMARY KEY, MYVALUE VARCHAR);";
            conn = DriverManager.getConnection(CSVCommonsLoaderIT.getUrl()).unwrap(PhoenixConnection.class);
            PhoenixRuntime.executeStatements((Connection)conn, (Reader)new StringReader(statements), null);
            CSVCommonsLoader csvUtil = new CSVCommonsLoader(conn, ENCAPSULATED_CHARS_TABLE, Collections.emptyList(), true);
            try {
                csvUtil.upsert((Reader)new StringReader(CSV_VALUES_BAD_ENCAPSULATED_CONTROL_CHARS_WITH_HEADER));
                Assert.fail();
            }
            catch (RuntimeException e) {
                Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("invalid char between encapsulated token and delimiter"));
            }
        }
        finally {
            if (parser != null) {
                parser.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCSVCommonsUpsert_WithArray() throws Exception {
        Object parser = null;
        PhoenixConnection conn = null;
        try {
            String statements = "CREATE TABLE IF NOT EXISTS ARRAY_TABLE (ID BIGINT NOT NULL PRIMARY KEY, VALARRAY INTEGER ARRAY);";
            conn = DriverManager.getConnection(CSVCommonsLoaderIT.getUrl()).unwrap(PhoenixConnection.class);
            PhoenixRuntime.executeStatements((Connection)conn, (Reader)new StringReader(statements), null);
            CSVCommonsLoader csvUtil = new CSVCommonsLoader(conn, "ARRAY_TABLE", (List)ImmutableList.of(), true, ',', '\"', null, "!");
            csvUtil.upsert((Reader)new StringReader("ID,VALARRAY\n1,2!3!4\n"));
            PreparedStatement statement = conn.prepareStatement("SELECT ID, VALARRAY FROM ARRAY_TABLE");
            ResultSet phoenixResultSet = statement.executeQuery();
            Assert.assertTrue((boolean)phoenixResultSet.next());
            Assert.assertEquals((long)1L, (long)phoenixResultSet.getLong(1));
            Assert.assertEquals((Object)PArrayDataType.instantiatePhoenixArray((PDataType)PInteger.INSTANCE, (Object[])new Integer[]{2, 3, 4}), (Object)phoenixResultSet.getArray(2));
            Assert.assertFalse((boolean)phoenixResultSet.next());
        }
        finally {
            if (parser != null) {
                parser.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCSVCommonsUpsert_WithTimestamp() throws Exception {
        Object parser = null;
        PhoenixConnection conn = null;
        try {
            String statements = "CREATE TABLE IF NOT EXISTS TS_TABLE (ID BIGINT NOT NULL PRIMARY KEY, TS TIMESTAMP);";
            conn = DriverManager.getConnection(CSVCommonsLoaderIT.getUrl()).unwrap(PhoenixConnection.class);
            PhoenixRuntime.executeStatements((Connection)conn, (Reader)new StringReader(statements), null);
            CSVCommonsLoader csvUtil = new CSVCommonsLoader(conn, "TS_TABLE", (List)ImmutableList.of(), true, ',', '\"', null, "!");
            csvUtil.upsert((Reader)new StringReader("ID,TS\n1,1970-01-01 00:00:10\n2,1970-01-01 00:00:10.123\n"));
            PreparedStatement statement = conn.prepareStatement("SELECT ID, TS FROM TS_TABLE ORDER BY ID");
            ResultSet phoenixResultSet = statement.executeQuery();
            Assert.assertTrue((boolean)phoenixResultSet.next());
            Assert.assertEquals((long)1L, (long)phoenixResultSet.getLong(1));
            Assert.assertEquals((long)10000L, (long)phoenixResultSet.getTimestamp(2).getTime());
            Assert.assertTrue((boolean)phoenixResultSet.next());
            Assert.assertEquals((long)2L, (long)phoenixResultSet.getLong(1));
            Assert.assertEquals((long)10123L, (long)phoenixResultSet.getTimestamp(2).getTime());
            Assert.assertFalse((boolean)phoenixResultSet.next());
        }
        finally {
            if (parser != null) {
                parser.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Test
    public void testCSVCommonsUpsert_NonExistentTable() throws Exception {
        try (PhoenixConnection conn = null;){
            conn = DriverManager.getConnection(CSVCommonsLoaderIT.getUrl()).unwrap(PhoenixConnection.class);
            CSVCommonsLoader csvUtil = new CSVCommonsLoader(conn, "NONEXISTENTTABLE", null, true, ',', '\"', null, "!");
            csvUtil.upsert((Reader)new StringReader("ID,VALARRAY\n1,2!3!4\n"));
            Assert.fail((String)"Trying to load a non-existent table should fail");
        }
    }

    @Test
    public void testLowerCaseTable() throws Exception {
        Connection conn = DriverManager.getConnection(CSVCommonsLoaderIT.getUrl());
        conn.setAutoCommit(true);
        String tableName = CSVCommonsLoaderIT.generateUniqueName().toLowerCase();
        String t1 = CSVCommonsLoaderIT.generateUniqueName();
        String t2 = t1 + CSVCommonsLoaderIT.generateUniqueName();
        String csvFileName = "test.csv";
        conn.createStatement().execute("CREATE TABLE \"" + tableName + "\" (k1 VARCHAR NOT NULL, k2 VARCHAR, CONSTRAINT PK PRIMARY KEY(K1,K2))");
        File tempFile = this.tempFolder.newFile(csvFileName);
        FileUtils.writeStringToFile((File)tempFile, (String)("'" + t1 + "','x'"));
        try {
            CSVCommonsLoader csvLoader = new CSVCommonsLoader(conn.unwrap(PhoenixConnection.class), "" + tableName + "", null, false, ',', '\"', Character.valueOf('\\'), null);
            csvLoader.upsert(tempFile.getAbsolutePath());
        }
        catch (Exception e) {
            Assert.fail((String)("Failed with Exception:" + e.getMessage()));
        }
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM \"" + tableName + "\" order by k2");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)("'" + t1 + "'"), (Object)rs.getString(1));
        Assert.assertEquals((Object)"'x'", (Object)rs.getString(2));
        Assert.assertFalse((boolean)rs.next());
    }
}

