/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.coprocessorclient.metrics.MetricsPhoenixCoprocessorSourceFactory;
import org.apache.phoenix.coprocessorclient.metrics.MetricsPhoenixMasterSource;
import org.apache.phoenix.end2end.CDCBaseIT;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.TestPhoenixMasterObserver;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class CDCStream2IT
extends CDCBaseIT {
    private static final MetricsPhoenixMasterSource METRICS_SOURCE = MetricsPhoenixCoprocessorSourceFactory.getInstance().getPhoenixMasterSource();

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("phoenix.max.lookback.age.seconds", Integer.toString(3600));
        props.put("phoenix.use.stats.parallelization", Boolean.toString(false));
        props.put("hbase.coprocessor.master.classes", TestPhoenixMasterObserver.class.getName());
        CDCStream2IT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    @Test
    public void testPartitionMetadataWithRetries() throws Exception {
        Connection conn = this.newConnection();
        String tableName = CDCStream2IT.generateUniqueName();
        this.createTableAndEnableCDC(conn, tableName, false);
        Assert.assertEquals((String)"Post split partition update failures should be 0 initially", (long)0L, (long)METRICS_SOURCE.getPostSplitPartitionUpdateFailureCount());
        Assert.assertEquals((String)"Post merge partition update failures should be 0 initially", (long)0L, (long)METRICS_SOURCE.getPostMergePartitionUpdateFailureCount());
        TestUtil.splitTable(conn, tableName, Bytes.toBytes((String)"m"));
        Assert.assertEquals((String)"Post split partition update failures should be 24 after retries", (long)24L, (long)METRICS_SOURCE.getPostSplitPartitionUpdateFailureCount());
        List<HRegionLocation> regions = TestUtil.getAllTableRegions(conn, tableName);
        TestUtil.mergeTableRegions(conn, tableName, regions.stream().map(HRegionLocation::getRegion).map(RegionInfo::getEncodedName).collect(Collectors.toList()));
        Assert.assertEquals((String)"Post merge partition update failures should be 15 after retries", (long)15L, (long)METRICS_SOURCE.getPostMergePartitionUpdateFailureCount());
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM SYSTEM.CDC_STREAM WHERE TABLE_NAME='" + tableName + "'");
        ArrayList<CDCBaseIT.PartitionMetadata> mergedDaughter = new ArrayList<CDCBaseIT.PartitionMetadata>();
        ArrayList<CDCBaseIT.PartitionMetadata> splitParents = new ArrayList<CDCBaseIT.PartitionMetadata>();
        while (rs.next()) {
            CDCBaseIT.PartitionMetadata pm = new CDCBaseIT.PartitionMetadata(rs);
            if (pm.startKey == null && pm.endKey == null && pm.endTime == 0L) {
                mergedDaughter.add(pm);
            }
            if (pm.startKey == null && pm.endKey == null) continue;
            splitParents.add(pm);
        }
        Assert.assertEquals((long)2L, (long)mergedDaughter.size());
        Assert.assertEquals((long)2L, (long)splitParents.size());
        Assert.assertEquals((Object)((CDCBaseIT.PartitionMetadata)mergedDaughter.get((int)0)).startTime, (Object)((CDCBaseIT.PartitionMetadata)mergedDaughter.get((int)1)).startTime);
        Assert.assertEquals((Object)((CDCBaseIT.PartitionMetadata)mergedDaughter.get((int)0)).endTime, (Object)((CDCBaseIT.PartitionMetadata)mergedDaughter.get((int)1)).endTime);
        Assert.assertEquals((Object)((CDCBaseIT.PartitionMetadata)mergedDaughter.get((int)0)).partitionId, (Object)((CDCBaseIT.PartitionMetadata)mergedDaughter.get((int)1)).partitionId);
        Assert.assertTrue((boolean)mergedDaughter.stream().anyMatch(d -> Objects.equals(d.parentPartitionId, ((CDCBaseIT.PartitionMetadata)splitParents.get((int)0)).partitionId)));
        Assert.assertTrue((boolean)mergedDaughter.stream().anyMatch(d -> Objects.equals(d.parentPartitionId, ((CDCBaseIT.PartitionMetadata)splitParents.get((int)1)).partitionId)));
        for (CDCBaseIT.PartitionMetadata splitDaughter : splitParents) {
            Assert.assertEquals((Object)((CDCBaseIT.PartitionMetadata)mergedDaughter.get((int)0)).startTime, (Object)splitDaughter.endTime);
        }
    }
}

