/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Base64;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.end2end.IndexToolIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.schema.types.PDouble;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.util.CDCUtil;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.bson.BsonArray;
import org.bson.BsonBinary;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonNull;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.RawBsonDocument;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class Bson5IT
extends ParallelStatsDisabledIT {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private static String getJsonString(String jsonFilePath) throws IOException {
        URL fileUrl = Bson5IT.class.getClassLoader().getResource(jsonFilePath);
        Preconditions.checkArgument((fileUrl != null ? 1 : 0) != 0, (Object)("File path " + jsonFilePath + " seems invalid"));
        return FileUtils.readFileToString((File)new File(fileUrl.getFile()), (Charset)Charset.defaultCharset());
    }

    @Test
    public void testBsonOpsWithSqlConditionsUpdateSuccess() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = Bson5IT.generateUniqueName();
        String cdcName = Bson5IT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(Bson5IT.getUrl(), props);){
            String ddl = "CREATE TABLE " + tableName + " (PK1 VARCHAR NOT NULL, C1 VARCHAR, COL BSON CONSTRAINT pk PRIMARY KEY(PK1))";
            String cdcDdl = "CREATE CDC " + cdcName + " ON " + tableName;
            conn.createStatement().execute(ddl);
            conn.createStatement().execute(cdcDdl);
            IndexToolIT.runIndexTool(false, "", tableName, "\"" + CDCUtil.getCDCIndexName((String)cdcName) + "\"");
            Timestamp ts1 = new Timestamp(System.currentTimeMillis());
            Thread.sleep(100L);
            String sample1 = Bson5IT.getJsonString("json/sample_01.json");
            String sample2 = Bson5IT.getJsonString("json/sample_02.json");
            String sample3 = Bson5IT.getJsonString("json/sample_03.json");
            RawBsonDocument bsonDocument1 = RawBsonDocument.parse((String)sample1);
            RawBsonDocument bsonDocument2 = RawBsonDocument.parse((String)sample2);
            RawBsonDocument bsonDocument3 = RawBsonDocument.parse((String)sample3);
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?,?,?)");
            stmt.setString(1, "pk0001");
            stmt.setString(2, "0002");
            stmt.setObject(3, bsonDocument1);
            stmt.executeUpdate();
            stmt.setString(1, "pk1010");
            stmt.setString(2, "1010");
            stmt.setObject(3, bsonDocument2);
            stmt.executeUpdate();
            stmt.setString(1, "pk1011");
            stmt.setString(2, "1011");
            stmt.setObject(3, bsonDocument3);
            stmt.executeUpdate();
            conn.commit();
            Thread.sleep(100L);
            Timestamp ts2 = new Timestamp(System.currentTimeMillis());
            Bson5IT.testCDCAfterFirstUpsert(conn, cdcName, ts1, ts2, (BsonDocument)bsonDocument1, (BsonDocument)bsonDocument2, (BsonDocument)bsonDocument3);
            ts1 = new Timestamp(System.currentTimeMillis());
            Thread.sleep(100L);
            String conditionExpression = "#press = :press AND #track[0].#shot[2][0].#city.#standard[50] = :softly";
            BsonDocument conditionDoc = new BsonDocument();
            conditionDoc.put("$EXPR", (BsonValue)new BsonString(conditionExpression));
            conditionDoc.put("$VAL", (BsonValue)new BsonDocument().append(":press", (BsonValue)new BsonString("beat")).append(":softly", (BsonValue)new BsonString("softly")));
            conditionDoc.put("$KEYS", (BsonValue)new BsonDocument().append("#press", (BsonValue)new BsonString("press")).append("#track", (BsonValue)new BsonString("track")).append("#shot", (BsonValue)new BsonString("shot")).append("#city", (BsonValue)new BsonString("city")).append("#standard", (BsonValue)new BsonString("standard")));
            String query = "SELECT * FROM " + tableName + " WHERE PK1 = 'pk0001' AND C1 = '0002' AND NOT BSON_CONDITION_EXPRESSION(COL, '" + conditionDoc.toJson() + "')";
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"pk0001", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0002", (Object)rs.getString(2));
            BsonDocument document1 = (BsonDocument)rs.getObject(3);
            Assert.assertEquals((Object)bsonDocument1, (Object)document1);
            Assert.assertFalse((boolean)rs.next());
            conditionExpression = "#press = :press AND #track[0].#shot[2][0].#city.#standard[5] = :softly";
            conditionDoc = new BsonDocument();
            conditionDoc.put("$EXPR", (BsonValue)new BsonString(conditionExpression));
            conditionDoc.put("$VAL", (BsonValue)new BsonDocument().append(":press", (BsonValue)new BsonString("beat")).append(":softly", (BsonValue)new BsonString("softly")));
            conditionDoc.put("$KEYS", (BsonValue)new BsonDocument().append("#press", (BsonValue)new BsonString("press")).append("#track", (BsonValue)new BsonString("track")).append("#shot", (BsonValue)new BsonString("shot")).append("#city", (BsonValue)new BsonString("city")).append("#standard", (BsonValue)new BsonString("standard")));
            query = "SELECT * FROM " + tableName + " WHERE PK1 = ? AND C1 = ? AND BSON_CONDITION_EXPRESSION(COL, ?)";
            PreparedStatement ps = conn.prepareStatement(query);
            ps.setString(1, "pk0001");
            ps.setString(2, "0002");
            ps.setObject(3, conditionDoc);
            rs = ps.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"pk0001", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0002", (Object)rs.getString(2));
            document1 = (BsonDocument)rs.getObject(3);
            Assert.assertEquals((Object)bsonDocument1, (Object)document1);
            Assert.assertFalse((boolean)rs.next());
            BsonDocument updateExp = new BsonDocument().append("$SET", (BsonValue)new BsonDocument().append("browserling", (BsonValue)new BsonBinary(PDouble.INSTANCE.toBytes((Object)-5.0516934054880095E8))).append("track[0].shot[2][0].city.standard[5]", (BsonValue)new BsonString("soft")).append("track[0].shot[2][0].city.problem[2]", (BsonValue)new BsonString("track[0].shot[2][0].city.problem[2] + 529.435"))).append("$UNSET", (BsonValue)new BsonDocument().append("track[0].shot[2][0].city.flame", (BsonValue)new BsonNull()));
            stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?) ON DUPLICATE KEY UPDATE COL = CASE WHEN BSON_CONDITION_EXPRESSION(COL, '" + conditionDoc.toJson() + "') THEN BSON_UPDATE_EXPRESSION(COL, '" + updateExp + "') ELSE COL END, C1 = ?");
            stmt.setString(1, "pk0001");
            stmt.setString(2, "0003");
            stmt.executeUpdate();
            updateExp = new BsonDocument().append("$ADD", (BsonValue)new BsonDocument().append("new_samples", (BsonValue)new BsonDocument().append("$set", (BsonValue)new BsonArray(Arrays.asList(new BsonBinary(Bytes.toBytes((String)"Sample10")), new BsonBinary(Bytes.toBytes((String)"Sample12")), new BsonBinary(Bytes.toBytes((String)"Sample13")), new BsonBinary(Bytes.toBytes((String)"Sample14"))))))).append("$DELETE_FROM_SET", (BsonValue)new BsonDocument().append("new_samples", (BsonValue)new BsonDocument().append("$set", (BsonValue)new BsonArray(Arrays.asList(new BsonBinary(Bytes.toBytes((String)"Sample02")), new BsonBinary(Bytes.toBytes((String)"Sample03"))))))).append("$SET", (BsonValue)new BsonDocument().append("newrecord", ((BsonArray)document1.get((Object)"track")).get(0))).append("$UNSET", (BsonValue)new BsonDocument().append("rather[3].outline.halfway.so[2][2]", (BsonValue)new BsonNull()));
            conditionExpression = "field_not_exists(newrecord) AND field_exists(#rather[3].#outline.#halfway.#so[2][2])";
            conditionDoc = new BsonDocument();
            conditionDoc.put("$EXPR", (BsonValue)new BsonString(conditionExpression));
            conditionDoc.put("$VAL", (BsonValue)new BsonDocument());
            conditionDoc.put("$KEYS", (BsonValue)new BsonDocument().append("#rather", (BsonValue)new BsonString("rather")).append("#outline", (BsonValue)new BsonString("outline")).append("#halfway", (BsonValue)new BsonString("halfway")).append("#so", (BsonValue)new BsonString("so")));
            stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?) ON DUPLICATE KEY UPDATE COL = CASE WHEN BSON_CONDITION_EXPRESSION(COL, '" + conditionDoc.toJson() + "') THEN BSON_UPDATE_EXPRESSION(COL, '" + updateExp + "') ELSE COL END");
            stmt.setString(1, "pk1010");
            stmt.executeUpdate();
            updateExp = new BsonDocument().append("$SET", (BsonValue)new BsonDocument().append("result[1].location.state", (BsonValue)new BsonString("AK"))).append("$UNSET", (BsonValue)new BsonDocument().append("result[4].emails[1]", (BsonValue)new BsonNull()));
            conditionExpression = "#result[2].#location.#coordinates.#latitude > :latitude OR (field_exists(#result[1].#location) AND #result[1].#location.#state != :state AND field_exists(#result[4].#emails[1]))";
            conditionDoc = new BsonDocument();
            conditionDoc.put("$EXPR", (BsonValue)new BsonString(conditionExpression));
            conditionDoc.put("$VAL", (BsonValue)new BsonDocument().append(":latitude", (BsonValue)new BsonDouble(0.0)).append(":state", (BsonValue)new BsonString("AK")));
            conditionDoc.put("$KEYS", (BsonValue)new BsonDocument().append("#result", (BsonValue)new BsonString("result")).append("#location", (BsonValue)new BsonString("location")).append("#coordinates", (BsonValue)new BsonString("coordinates")).append("#latitude", (BsonValue)new BsonString("latitude")).append("#state", (BsonValue)new BsonString("state")).append("#emails", (BsonValue)new BsonString("emails")));
            stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?) ON DUPLICATE KEY UPDATE COL = CASE WHEN BSON_CONDITION_EXPRESSION(COL, '" + conditionDoc.toJson() + "') THEN BSON_UPDATE_EXPRESSION(COL, '" + updateExp + "') ELSE COL END");
            stmt.setString(1, "pk1011");
            stmt.executeUpdate();
            conn.commit();
            Thread.sleep(100L);
            ts2 = new Timestamp(System.currentTimeMillis());
            Bson5IT.testCDCPostUpdate(conn, cdcName, ts1, ts2, (BsonDocument)bsonDocument1, (BsonDocument)bsonDocument2, (BsonDocument)bsonDocument3);
            query = "SELECT * FROM " + tableName;
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"pk0001", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0003", (Object)rs.getString(2));
            document1 = (BsonDocument)rs.getObject(3);
            String updatedJson = Bson5IT.getJsonString("json/sample_updated_01.json");
            Assert.assertEquals((Object)RawBsonDocument.parse((String)updatedJson), (Object)document1);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"pk1010", (Object)rs.getString(1));
            Assert.assertEquals((Object)"1010", (Object)rs.getString(2));
            BsonDocument document2 = (BsonDocument)rs.getObject(3);
            updatedJson = Bson5IT.getJsonString("json/sample_updated_02.json");
            Assert.assertEquals((Object)RawBsonDocument.parse((String)updatedJson), (Object)document2);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"pk1011", (Object)rs.getString(1));
            Assert.assertEquals((Object)"1011", (Object)rs.getString(2));
            BsonDocument document3 = (BsonDocument)rs.getObject(3);
            updatedJson = Bson5IT.getJsonString("json/sample_updated_03.json");
            Assert.assertEquals((Object)RawBsonDocument.parse((String)updatedJson), (Object)document3);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testBsonOpsWithSqlConditionsUpdateFailure() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = Bson5IT.generateUniqueName();
        String cdcName = Bson5IT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(Bson5IT.getUrl(), props);){
            String ddl = "CREATE TABLE " + tableName + " (PK1 VARCHAR NOT NULL, C1 VARCHAR, COL BSON CONSTRAINT pk PRIMARY KEY(PK1))";
            String cdcDdl = "CREATE CDC " + cdcName + " ON " + tableName;
            conn.createStatement().execute(ddl);
            conn.createStatement().execute(cdcDdl);
            IndexToolIT.runIndexTool(false, "", tableName, "\"" + CDCUtil.getCDCIndexName((String)cdcName) + "\"");
            Timestamp ts1 = new Timestamp(System.currentTimeMillis());
            Thread.sleep(100L);
            String sample1 = Bson5IT.getJsonString("json/sample_01.json");
            String sample2 = Bson5IT.getJsonString("json/sample_02.json");
            String sample3 = Bson5IT.getJsonString("json/sample_03.json");
            RawBsonDocument bsonDocument1 = RawBsonDocument.parse((String)sample1);
            RawBsonDocument bsonDocument2 = RawBsonDocument.parse((String)sample2);
            RawBsonDocument bsonDocument3 = RawBsonDocument.parse((String)sample3);
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?,?,?)");
            stmt.setString(1, "pk0001");
            stmt.setString(2, "0002");
            stmt.setObject(3, bsonDocument1);
            stmt.executeUpdate();
            stmt.setString(1, "pk1010");
            stmt.setString(2, "1010");
            stmt.setObject(3, bsonDocument2);
            stmt.executeUpdate();
            stmt.setString(1, "pk1011");
            stmt.setString(2, "1011");
            stmt.setObject(3, bsonDocument3);
            stmt.executeUpdate();
            conn.commit();
            Thread.sleep(100L);
            Timestamp ts2 = new Timestamp(System.currentTimeMillis());
            Bson5IT.testCDCAfterFirstUpsert(conn, cdcName, ts1, ts2, (BsonDocument)bsonDocument1, (BsonDocument)bsonDocument2, (BsonDocument)bsonDocument3);
            Thread.sleep(100L);
            ts1 = new Timestamp(System.currentTimeMillis());
            Thread.sleep(100L);
            String conditionExpression = "#press = :press AND #track[0].#shot[2][0].#city.#standard[50] = :softly";
            BsonDocument conditionDoc = new BsonDocument();
            conditionDoc.put("$EXPR", (BsonValue)new BsonString(conditionExpression));
            conditionDoc.put("$VAL", (BsonValue)new BsonDocument().append(":press", (BsonValue)new BsonString("beat")).append(":softly", (BsonValue)new BsonString("softly")));
            conditionDoc.put("$KEYS", (BsonValue)new BsonDocument().append("#press", (BsonValue)new BsonString("press")).append("#track", (BsonValue)new BsonString("track")).append("#shot", (BsonValue)new BsonString("shot")).append("#city", (BsonValue)new BsonString("city")).append("#standard", (BsonValue)new BsonString("standard")));
            String query = "SELECT * FROM " + tableName + " WHERE PK1 = 'pk0001' AND C1 = '0002' AND NOT BSON_CONDITION_EXPRESSION(COL, '" + conditionDoc.toJson() + "')";
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"pk0001", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0002", (Object)rs.getString(2));
            BsonDocument document1 = (BsonDocument)rs.getObject(3);
            Assert.assertEquals((Object)bsonDocument1, (Object)document1);
            Assert.assertFalse((boolean)rs.next());
            conditionExpression = "#press = :press AND #track[0].#shot[2][0].#city.#standard[5] <> :softly";
            conditionDoc = new BsonDocument();
            conditionDoc.put("$EXPR", (BsonValue)new BsonString(conditionExpression));
            conditionDoc.put("$VAL", (BsonValue)new BsonDocument().append(":press", (BsonValue)new BsonString("beat")).append(":softly", (BsonValue)new BsonString("softly")));
            conditionDoc.put("$KEYS", (BsonValue)new BsonDocument().append("#press", (BsonValue)new BsonString("press")).append("#track", (BsonValue)new BsonString("track")).append("#shot", (BsonValue)new BsonString("shot")).append("#city", (BsonValue)new BsonString("city")).append("#standard", (BsonValue)new BsonString("standard")));
            BsonDocument updateExp = new BsonDocument().append("$SET", (BsonValue)new BsonDocument().append("browserling", (BsonValue)new BsonBinary(PDouble.INSTANCE.toBytes((Object)-5.0516934054880095E8))).append("track[0].shot[2][0].city.standard[5]", (BsonValue)new BsonString("soft")).append("track[0].shot[2][0].city.problem[2]", (BsonValue)new BsonString("track[0].shot[2][0].city.problem[2] + 529.435"))).append("$UNSET", (BsonValue)new BsonDocument().append("track[0].shot[2][0].city.flame", (BsonValue)new BsonNull()));
            stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?) ON DUPLICATE KEY UPDATE COL = CASE WHEN BSON_CONDITION_EXPRESSION(COL, '" + conditionDoc.toJson() + "') THEN BSON_UPDATE_EXPRESSION(COL, '" + updateExp + "') ELSE COL END, C1 = ?");
            stmt.setString(1, "pk0001");
            stmt.setString(2, "0003");
            stmt.executeUpdate();
            updateExp = new BsonDocument().append("$ADD", (BsonValue)new BsonDocument().append("new_samples", (BsonValue)new BsonDocument().append("$set", (BsonValue)new BsonArray(Arrays.asList(new BsonBinary(Bytes.toBytes((String)"Sample10")), new BsonBinary(Bytes.toBytes((String)"Sample12")), new BsonBinary(Bytes.toBytes((String)"Sample13")), new BsonBinary(Bytes.toBytes((String)"Sample14"))))))).append("$DELETE_FROM_SET", (BsonValue)new BsonDocument().append("new_samples", (BsonValue)new BsonDocument().append("$set", (BsonValue)new BsonArray(Arrays.asList(new BsonBinary(Bytes.toBytes((String)"Sample02")), new BsonBinary(Bytes.toBytes((String)"Sample03"))))))).append("$SET", (BsonValue)new BsonDocument().append("newrecord", ((BsonArray)document1.get((Object)"track")).get(0))).append("$UNSET", (BsonValue)new BsonDocument().append("rather[3].outline.halfway.so[2][2]", (BsonValue)new BsonNull()));
            conditionExpression = "field_not_exists(newrecord) AND field_exists(#rather[3].#outline.#halfway.#so[2][20])";
            conditionDoc = new BsonDocument();
            conditionDoc.put("$EXPR", (BsonValue)new BsonString(conditionExpression));
            conditionDoc.put("$VAL", (BsonValue)new BsonDocument());
            conditionDoc.put("$KEYS", (BsonValue)new BsonDocument().append("#rather", (BsonValue)new BsonString("rather")).append("#outline", (BsonValue)new BsonString("outline")).append("#halfway", (BsonValue)new BsonString("halfway")).append("#so", (BsonValue)new BsonString("so")));
            stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?) ON DUPLICATE KEY UPDATE COL = CASE WHEN BSON_CONDITION_EXPRESSION(COL, '" + conditionDoc.toJson() + "') THEN BSON_UPDATE_EXPRESSION(COL, '" + updateExp + "') ELSE COL END");
            stmt.setString(1, "pk1010");
            stmt.executeUpdate();
            updateExp = new BsonDocument().append("$SET", (BsonValue)new BsonDocument().append("result[1].location.state", (BsonValue)new BsonString("AK"))).append("$UNSET", (BsonValue)new BsonDocument().append("result[4].emails[1]", (BsonValue)new BsonNull()));
            conditionExpression = "#result[2].#location.#coordinates.#latitude > :latitude OR (field_exists(#result[1].#location) AND #result[1].#location.#state != :state AND field_not_exists(#result[4].#emails[1]))";
            conditionDoc = new BsonDocument();
            conditionDoc.put("$EXPR", (BsonValue)new BsonString(conditionExpression));
            conditionDoc.put("$VAL", (BsonValue)new BsonDocument().append(":latitude", (BsonValue)new BsonDouble(0.0)).append(":state", (BsonValue)new BsonString("AK")));
            conditionDoc.put("$KEYS", (BsonValue)new BsonDocument().append("#result", (BsonValue)new BsonString("result")).append("#location", (BsonValue)new BsonString("location")).append("#coordinates", (BsonValue)new BsonString("coordinates")).append("#latitude", (BsonValue)new BsonString("latitude")).append("#state", (BsonValue)new BsonString("state")).append("#emails", (BsonValue)new BsonString("emails")));
            stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?) ON DUPLICATE KEY UPDATE COL = CASE WHEN BSON_CONDITION_EXPRESSION(COL, '" + conditionDoc.toJson() + "') THEN BSON_UPDATE_EXPRESSION(COL, '" + updateExp + "') ELSE COL END");
            stmt.setString(1, "pk1011");
            stmt.executeUpdate();
            conn.commit();
            Thread.sleep(100L);
            ts2 = new Timestamp(System.currentTimeMillis());
            Bson5IT.testCDCUpdateOneRowChange(conn, cdcName, ts1, ts2, (BsonDocument)bsonDocument1);
            query = "SELECT * FROM " + tableName;
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"pk0001", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0003", (Object)rs.getString(2));
            document1 = (BsonDocument)rs.getObject(3);
            Assert.assertEquals((Object)bsonDocument1, (Object)document1);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"pk1010", (Object)rs.getString(1));
            Assert.assertEquals((Object)"1010", (Object)rs.getString(2));
            BsonDocument document2 = (BsonDocument)rs.getObject(3);
            Assert.assertEquals((Object)bsonDocument2, (Object)document2);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"pk1011", (Object)rs.getString(1));
            Assert.assertEquals((Object)"1011", (Object)rs.getString(2));
            BsonDocument document3 = (BsonDocument)rs.getObject(3);
            Assert.assertEquals((Object)bsonDocument3, (Object)document3);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    private static void testCDCAfterFirstUpsert(Connection conn, String cdcName, Timestamp ts1, Timestamp ts2, BsonDocument bsonDocument1, BsonDocument bsonDocument2, BsonDocument bsonDocument3) throws SQLException, JsonProcessingException {
        try (PreparedStatement pst = conn.prepareStatement("SELECT /*+ CDC_INCLUDE(PRE, POST) */ * FROM " + cdcName + " WHERE PHOENIX_ROW_TIMESTAMP() >= ? AND PHOENIX_ROW_TIMESTAMP() <= ?");){
            pst.setTimestamp(1, ts1);
            pst.setTimestamp(2, ts2);
            ResultSet rs = pst.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            String cdcVal = rs.getString(3);
            Map map = (Map)OBJECT_MAPPER.readValue(cdcVal, Map.class);
            Map preImage = (Map)map.get("pre_image");
            Assert.assertNull(preImage.get("COL"));
            Map postImage = (Map)map.get("post_image");
            String encodedBytes = (String)postImage.get("COL");
            byte[] bytes = Base64.getDecoder().decode(encodedBytes);
            RawBsonDocument r1 = new RawBsonDocument(bytes, 0, bytes.length);
            Assert.assertEquals((Object)bsonDocument1, (Object)r1);
            Assert.assertTrue((boolean)rs.next());
            cdcVal = rs.getString(3);
            map = (Map)OBJECT_MAPPER.readValue(cdcVal, Map.class);
            preImage = (Map)map.get("pre_image");
            Assert.assertNull(preImage.get("COL"));
            postImage = (Map)map.get("post_image");
            encodedBytes = (String)postImage.get("COL");
            bytes = Base64.getDecoder().decode(encodedBytes);
            RawBsonDocument r2 = new RawBsonDocument(bytes, 0, bytes.length);
            Assert.assertEquals((Object)bsonDocument2, (Object)r2);
            Assert.assertTrue((boolean)rs.next());
            cdcVal = rs.getString(3);
            map = (Map)OBJECT_MAPPER.readValue(cdcVal, Map.class);
            preImage = (Map)map.get("pre_image");
            Assert.assertNull(preImage.get("COL"));
            postImage = (Map)map.get("post_image");
            encodedBytes = (String)postImage.get("COL");
            bytes = Base64.getDecoder().decode(encodedBytes);
            RawBsonDocument r3 = new RawBsonDocument(bytes, 0, bytes.length);
            Assert.assertEquals((Object)bsonDocument3, (Object)r3);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    private static void testCDCPostUpdate(Connection conn, String cdcName, Timestamp ts1, Timestamp ts2, BsonDocument bsonDocument1, BsonDocument bsonDocument2, BsonDocument bsonDocument3) throws SQLException, IOException {
        try (PreparedStatement pst = conn.prepareStatement("SELECT /*+ CDC_INCLUDE(PRE, POST) */ * FROM " + cdcName + " WHERE PHOENIX_ROW_TIMESTAMP() >= ? AND PHOENIX_ROW_TIMESTAMP() <= ?");){
            pst.setTimestamp(1, ts1);
            pst.setTimestamp(2, ts2);
            ResultSet rs = pst.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            String cdcVal = rs.getString(3);
            Map map = (Map)OBJECT_MAPPER.readValue(cdcVal, Map.class);
            Map preImage = (Map)map.get("pre_image");
            String encodedBytes = (String)preImage.get("COL");
            byte[] bytes = Base64.getDecoder().decode(encodedBytes);
            RawBsonDocument preDoc = new RawBsonDocument(bytes, 0, bytes.length);
            Assert.assertEquals((Object)bsonDocument1, (Object)preDoc);
            Map postImage = (Map)map.get("post_image");
            encodedBytes = (String)postImage.get("COL");
            bytes = Base64.getDecoder().decode(encodedBytes);
            RawBsonDocument postDoc = new RawBsonDocument(bytes, 0, bytes.length);
            Assert.assertEquals((Object)RawBsonDocument.parse((String)Bson5IT.getJsonString("json/sample_updated_01.json")), (Object)postDoc);
            Assert.assertTrue((boolean)rs.next());
            cdcVal = rs.getString(3);
            map = (Map)OBJECT_MAPPER.readValue(cdcVal, Map.class);
            preImage = (Map)map.get("pre_image");
            encodedBytes = (String)preImage.get("COL");
            bytes = Base64.getDecoder().decode(encodedBytes);
            preDoc = new RawBsonDocument(bytes, 0, bytes.length);
            Assert.assertEquals((Object)bsonDocument2, (Object)preDoc);
            postImage = (Map)map.get("post_image");
            encodedBytes = (String)postImage.get("COL");
            bytes = Base64.getDecoder().decode(encodedBytes);
            postDoc = new RawBsonDocument(bytes, 0, bytes.length);
            Assert.assertEquals((Object)RawBsonDocument.parse((String)Bson5IT.getJsonString("json/sample_updated_02.json")), (Object)postDoc);
            Assert.assertTrue((boolean)rs.next());
            cdcVal = rs.getString(3);
            map = (Map)OBJECT_MAPPER.readValue(cdcVal, Map.class);
            preImage = (Map)map.get("pre_image");
            encodedBytes = (String)preImage.get("COL");
            bytes = Base64.getDecoder().decode(encodedBytes);
            preDoc = new RawBsonDocument(bytes, 0, bytes.length);
            Assert.assertEquals((Object)bsonDocument3, (Object)preDoc);
            postImage = (Map)map.get("post_image");
            encodedBytes = (String)postImage.get("COL");
            bytes = Base64.getDecoder().decode(encodedBytes);
            postDoc = new RawBsonDocument(bytes, 0, bytes.length);
            Assert.assertEquals((Object)RawBsonDocument.parse((String)Bson5IT.getJsonString("json/sample_updated_03.json")), (Object)postDoc);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    private static void testCDCUpdateOneRowChange(Connection conn, String cdcName, Timestamp ts1, Timestamp ts2, BsonDocument bsonDocument1) throws SQLException, IOException {
        try (PreparedStatement pst = conn.prepareStatement("SELECT /*+ CDC_INCLUDE(PRE, POST) */ * FROM " + cdcName + " WHERE PHOENIX_ROW_TIMESTAMP() >= ? AND PHOENIX_ROW_TIMESTAMP() <= ?");){
            pst.setTimestamp(1, ts1);
            pst.setTimestamp(2, ts2);
            ResultSet rs = pst.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            String cdcVal = rs.getString(3);
            Map map = (Map)OBJECT_MAPPER.readValue(cdcVal, Map.class);
            Map preImage = (Map)map.get("pre_image");
            String encodedBytes = (String)preImage.get("COL");
            byte[] bytes = Base64.getDecoder().decode(encodedBytes);
            RawBsonDocument preDoc = new RawBsonDocument(bytes, 0, bytes.length);
            Assert.assertEquals((Object)bsonDocument1, (Object)preDoc);
            Map postImage = (Map)map.get("post_image");
            encodedBytes = (String)postImage.get("COL");
            bytes = Base64.getDecoder().decode(encodedBytes);
            RawBsonDocument postDoc = new RawBsonDocument(bytes, 0, bytes.length);
            Assert.assertEquals((Object)bsonDocument1, (Object)postDoc);
            Assert.assertFalse((boolean)rs.next());
        }
    }
}

