/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.schema.types.PDouble;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.bson.BsonArray;
import org.bson.BsonBinary;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonNull;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.RawBsonDocument;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={ParallelStatsDisabledTest.class})
@RunWith(value=Parameterized.class)
public class Bson4IT
extends ParallelStatsDisabledIT {
    private final boolean columnEncoded;
    private final boolean coveredIndex;

    public Bson4IT(boolean columnEncoded, boolean coveredIndex) {
        this.columnEncoded = columnEncoded;
        this.coveredIndex = coveredIndex;
    }

    @Parameterized.Parameters(name="Bson4IT_columnEncoded={0}, coveredIndex={1}")
    public static synchronized Collection<Object[]> data() {
        return Arrays.asList({false, false}, {false, true}, {true, false}, {true, true});
    }

    private static String getJsonString(String jsonFilePath) throws IOException {
        URL fileUrl = Bson4IT.class.getClassLoader().getResource(jsonFilePath);
        Preconditions.checkArgument((fileUrl != null ? 1 : 0) != 0, (Object)("File path " + jsonFilePath + " seems invalid"));
        return FileUtils.readFileToString((File)new File(fileUrl.getFile()), (Charset)Charset.defaultCharset());
    }

    @Test
    public void testBsonValueFunction() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = Bson4IT.generateUniqueName();
        String indexName1 = "IDX1_" + tableName;
        String indexName2 = "IDX2_" + tableName;
        try (Connection conn = DriverManager.getConnection(Bson4IT.getUrl(), props);){
            String ddl = "CREATE TABLE " + tableName + " (PK1 VARCHAR NOT NULL, C1 VARCHAR, COL BSON CONSTRAINT pk PRIMARY KEY(PK1)) " + (this.columnEncoded ? "" : "COLUMN_ENCODED_BYTES=0");
            String indexDdl1 = !this.coveredIndex ? "CREATE UNCOVERED INDEX " + indexName1 + " ON " + tableName + "(BSON_VALUE(COL, 'rather[3].outline.clock', 'VARCHAR')) WHERE BSON_VALUE(COL, 'rather[3].outline.clock', 'VARCHAR') IS NOT NULL" : "CREATE INDEX " + indexName1 + " ON " + tableName + "(BSON_VALUE(COL, 'rather[3].outline.clock', 'VARCHAR')) INCLUDE(COL) WHERE BSON_VALUE(COL, 'rather[3].outline.clock', 'VARCHAR') IS NOT NULL";
            String indexDdl2 = !this.coveredIndex ? "CREATE UNCOVERED INDEX " + indexName2 + " ON " + tableName + "(BSON_VALUE(COL, 'result[1].location.coordinates.longitude', 'DOUBLE')) WHERE BSON_VALUE(COL, 'result[1].location.coordinates.longitude', 'DOUBLE') IS NOT NULL" : "CREATE INDEX " + indexName2 + " ON " + tableName + "(BSON_VALUE(COL, 'result[1].location.coordinates.longitude', 'DOUBLE')) INCLUDE(COL) WHERE BSON_VALUE(COL, 'result[1].location.coordinates.longitude', 'DOUBLE') IS NOT NULL";
            conn.createStatement().execute(ddl);
            conn.createStatement().execute(indexDdl1);
            conn.createStatement().execute(indexDdl2);
            String sample1 = Bson4IT.getJsonString("json/sample_01.json");
            String sample2 = Bson4IT.getJsonString("json/sample_02.json");
            String sample3 = Bson4IT.getJsonString("json/sample_03.json");
            RawBsonDocument bsonDocument1 = RawBsonDocument.parse((String)sample1);
            RawBsonDocument bsonDocument2 = RawBsonDocument.parse((String)sample2);
            RawBsonDocument bsonDocument3 = RawBsonDocument.parse((String)sample3);
            Bson4IT.upsertRows(conn, tableName, (BsonDocument)bsonDocument1, (BsonDocument)bsonDocument2, (BsonDocument)bsonDocument3);
            conn.commit();
            ResultSet rs = conn.createStatement().executeQuery("SELECT count(*) FROM " + tableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            rs = conn.createStatement().executeQuery("SELECT count(*) FROM " + indexName1);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            rs = conn.createStatement().executeQuery("SELECT count(*) FROM " + indexName2);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            PreparedStatement ps = conn.prepareStatement("SELECT PK1, COL FROM " + tableName + " WHERE BSON_VALUE(COL, 'result[1].location.coordinates.longitude', 'DOUBLE') = ?");
            ps.setDouble(1, 52.3736);
            rs = ps.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"pk1011", (Object)rs.getString(1));
            BsonDocument actualDoc = (BsonDocument)rs.getObject(2);
            Assert.assertEquals((Object)bsonDocument3, (Object)actualDoc);
            Assert.assertFalse((boolean)rs.next());
            Bson4IT.validateExplainPlan(ps, indexName2, "RANGE SCAN ");
            ps = conn.prepareStatement("SELECT PK1, COL FROM " + tableName + " WHERE BSON_VALUE(COL, 'rather[3].outline.clock', 'VARCHAR') = ?");
            ps.setString(1, "personal");
            rs = ps.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"pk1010", (Object)rs.getString(1));
            actualDoc = (BsonDocument)rs.getObject(2);
            Assert.assertEquals((Object)bsonDocument2, (Object)actualDoc);
            Assert.assertFalse((boolean)rs.next());
            Bson4IT.validateExplainPlan(ps, indexName1, "RANGE SCAN ");
            BsonDocument updateExp = new BsonDocument().append("$ADD", (BsonValue)new BsonDocument().append("new_samples", (BsonValue)new BsonDocument().append("$set", (BsonValue)new BsonArray(Arrays.asList(new BsonBinary(Bytes.toBytes((String)"Sample10")), new BsonBinary(Bytes.toBytes((String)"Sample12")), new BsonBinary(Bytes.toBytes((String)"Sample13")), new BsonBinary(Bytes.toBytes((String)"Sample14"))))))).append("$DELETE_FROM_SET", (BsonValue)new BsonDocument().append("new_samples", (BsonValue)new BsonDocument().append("$set", (BsonValue)new BsonArray(Arrays.asList(new BsonBinary(Bytes.toBytes((String)"Sample02")), new BsonBinary(Bytes.toBytes((String)"Sample03"))))))).append("$SET", (BsonValue)new BsonDocument().append("rather[3].outline.clock", (BsonValue)new BsonString("personal2"))).append("$UNSET", (BsonValue)new BsonDocument().append("rather[3].outline.halfway.so[2][2]", (BsonValue)new BsonNull()));
            String conditionExpression = "field_not_exists(newrecord) AND field_exists(rather[3].outline.halfway.so[2][2])";
            BsonDocument conditionDoc = new BsonDocument();
            conditionDoc.put("$EXPR", (BsonValue)new BsonString(conditionExpression));
            conditionDoc.put("$VAL", (BsonValue)new BsonDocument());
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?) ON DUPLICATE KEY UPDATE COL = CASE WHEN BSON_CONDITION_EXPRESSION(COL, '" + conditionDoc.toJson() + "') THEN BSON_UPDATE_EXPRESSION(COL, '" + updateExp + "') ELSE COL END");
            stmt.setString(1, "pk1010");
            stmt.executeUpdate();
            conn.commit();
            ps = conn.prepareStatement("SELECT PK1, COL FROM " + tableName + " WHERE BSON_VALUE(COL, 'rather[3].outline.clock', 'VARCHAR') = ?");
            ps.setString(1, "personal");
            rs = ps.executeQuery();
            Assert.assertFalse((boolean)rs.next());
            Bson4IT.validateExplainPlan(ps, indexName1, "RANGE SCAN ");
            ps = conn.prepareStatement("SELECT PK1, COL FROM " + tableName + " WHERE BSON_VALUE(COL, 'result[1].location.coordinates.longitude', 'DOUBLE') = ?");
            ps.setDouble(1, 52.37);
            rs = ps.executeQuery();
            Assert.assertFalse((boolean)rs.next());
            Bson4IT.validateExplainPlan(ps, indexName2, "RANGE SCAN ");
        }
    }

    @Test
    public void testBsonValueWithBinaryEncoded() throws Exception {
        byte[] doc1Field1 = new byte[]{0, 1, 2, 3, 0, 1, 5, 6, 7, 8, 0, 10, 11, 12, 13, 0, 0, -1, 15, 16, 17, 18, 19};
        byte[] doc1Field2 = new byte[]{1, 0, 2, 3, 4, 0, 6, 7, 8, 9, 0, 11, 12, 13, 14, 0, 16, 17, 18, 19, 20};
        byte[] doc1Field3 = new byte[]{1, 2, 0, 3, 4, 5, 0, 7, 8, 9, 10, 0, 12, 13, 14, 15, 0, 17, 18, 19, 20, 21};
        byte[] doc1Field4 = new byte[]{1, 2, 3, 0, 4, 5, 6, 0, 8, 9, 10, 11, 0, 13, 14, 15, 16, 0, 18, 19, 20, 21, 22};
        byte[] doc1Field5 = new byte[]{1, 2, 3, 4, 0, 5, 6, 7, 0, 9, 10, 11, 12, 0, 14, 15, 16, 17, 0, 19, 20, 21, 22, 23};
        byte[] doc2Field1 = new byte[]{0, 25, 35, 45, 0, 55, 65, 75, 85, 0, 95, 105, 115, 125, 0, 15, 25, 35, 45, 55};
        byte[] doc2Field2 = new byte[]{25, 0, 35, 45, 55, 0, 65, 75, 85, 95, 0, 105, 115, 125, -125, 0, 15, 25, 35, 45, 55};
        byte[] doc2Field3 = new byte[]{25, 35, 0, 45, 55, 65, 0, 75, 85, 95, 105, 0, 115, 125, -125, -115, 0, 15, 25, 35, 45, 55};
        byte[] doc2Field4 = new byte[]{25, 35, 45, 0, 55, 65, 75, 0, 85, 95, 105, 115, 0, 125, -125, -115, -105, 0, 15, 25, 35, 45, 55};
        byte[] doc2Field5 = new byte[]{25, 35, 45, 55, 0, 65, 75, 85, 0, 95, 105, 115, 125, 0, -125, -115, -105, -95, 0, 15, 25, 35, 45, 55};
        byte[] doc3Field1 = new byte[]{0, -1, -2, -3, 0, -5, -6, -7, -8, 0, -10, -11, -12, -13, 0, -15, -16, -17, -18, -19};
        byte[] doc3Field2 = new byte[]{-1, 0, -2, -3, -4, 0, -6, -7, -8, -9, 0, -11, -12, -13, -14, 0, -16, -17, -18, -19, -20};
        byte[] doc3Field3 = new byte[]{-1, -2, 0, -3, -4, -5, 0, -7, -8, -9, -10, 0, -12, -13, -14, -15, 0, -17, -18, -19, -20, -21};
        byte[] doc3Field4 = new byte[]{-1, -2, -3, 0, -4, -5, -6, 0, -8, -9, -10, -11, 0, -13, -14, -15, -16, 0, -18, -19, -20, -21, -22};
        byte[] doc3Field5 = new byte[]{-1, -2, -3, -4, 0, -5, -6, -7, 0, -9, -10, -11, -12, 0, -14, -15, -16, -17, 0, -19, -20, -21, -22, -23};
        byte[] doc4Field1 = new byte[]{0, -1, -2, -3, 0, 0, -4, -6, -7, -8, 0, -10, -11, -12, -13, 0, -15, -16, -17, -18, -19};
        byte[] doc4Field2 = new byte[]{-1, 0, -2, -3, -4, 0, 6, -7, -8, -9, 0, -11, -12, -13, -14, 0, -16, -17, -18, -19, -20};
        byte[] doc4Field30 = new byte[]{-1, -2, 0, -3, -4, -5, 0, 0, -7, 8, -9, -10, -1, 0, -1, -12, -13, -14, -15, 0, -17, -18, -19, -20, -21};
        byte[] doc4Field4 = new byte[]{-1, -2, -3, 0, -4, -5, -6, 0, -8, -9, -10, -11, -1, 0, 1, -13, -14, -15, -16, 0, -18, -19, -20, -21, -22};
        byte[] doc4Field5 = new byte[]{-1, -1, 0, -2, -3, -4, 0, -5, -6, -7, 0, -9, -10, -11, -12, 0, -14, -15, -16, -17, 0, -19, -20, -21, -22, -23};
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = Bson4IT.generateUniqueName();
        String indexName1 = "IDX1_" + tableName;
        String indexName2 = "IDX2_" + tableName;
        try (Connection conn = DriverManager.getConnection(Bson4IT.getUrl(), props);){
            String ddl = "CREATE TABLE " + tableName + " (PK1 VARCHAR NOT NULL, C1 VARCHAR, COL BSON CONSTRAINT pk PRIMARY KEY(PK1))";
            String indexDdl1 = !this.coveredIndex ? "CREATE UNCOVERED INDEX " + indexName1 + " ON " + tableName + "(BSON_VALUE(COL, 'binary_field1', 'VARBINARY_ENCODED')) WHERE BSON_VALUE(COL, 'binary_field1', 'VARBINARY_ENCODED') IS NOT NULL" : "CREATE INDEX " + indexName1 + " ON " + tableName + "(BSON_VALUE(COL, 'binary_field1', 'VARBINARY_ENCODED')) INCLUDE(COL, C1) WHERE BSON_VALUE(COL, 'binary_field1', 'VARBINARY_ENCODED') IS NOT NULL";
            String indexDdl2 = !this.coveredIndex ? "CREATE UNCOVERED INDEX " + indexName2 + " ON " + tableName + "(BSON_VALUE(COL, 'binary_field3', 'VARBINARY_ENCODED')) WHERE BSON_VALUE(COL, 'binary_field3', 'VARBINARY_ENCODED') IS NOT NULL" : "CREATE INDEX " + indexName2 + " ON " + tableName + "(BSON_VALUE(COL, 'binary_field3', 'VARBINARY_ENCODED')) INCLUDE(COL, C1) WHERE BSON_VALUE(COL, 'binary_field3', 'VARBINARY_ENCODED') IS NOT NULL";
            conn.createStatement().execute(ddl);
            conn.createStatement().execute(indexDdl1);
            conn.createStatement().execute(indexDdl2);
            BsonDocument doc1 = new BsonDocument().append("binary_field1", (BsonValue)new BsonBinary(doc1Field1)).append("binary_field2", (BsonValue)new BsonBinary(doc1Field2)).append("binary_field3", (BsonValue)new BsonBinary(doc1Field3)).append("binary_field4", (BsonValue)new BsonBinary(doc1Field4)).append("binary_field5", (BsonValue)new BsonBinary(doc1Field5));
            BsonDocument doc2 = new BsonDocument().append("binary_field1", (BsonValue)new BsonBinary(doc2Field1)).append("binary_field2", (BsonValue)new BsonBinary(doc2Field2)).append("binary_field3", (BsonValue)new BsonBinary(doc2Field3)).append("binary_field4", (BsonValue)new BsonBinary(doc2Field4)).append("binary_field5", (BsonValue)new BsonBinary(doc2Field5));
            BsonDocument doc3 = new BsonDocument().append("binary_field1", (BsonValue)new BsonBinary(doc3Field1)).append("binary_field2", (BsonValue)new BsonBinary(doc3Field2)).append("binary_field3", (BsonValue)new BsonBinary(doc3Field3)).append("binary_field4", (BsonValue)new BsonBinary(doc3Field4)).append("binary_field5", (BsonValue)new BsonBinary(doc3Field5));
            BsonDocument doc4 = new BsonDocument().append("binary_field1", (BsonValue)new BsonBinary(doc4Field1)).append("binary_field2", (BsonValue)new BsonBinary(doc4Field2)).append("binary_field30", (BsonValue)new BsonBinary(doc4Field30)).append("binary_field4", (BsonValue)new BsonBinary(doc4Field4)).append("binary_field5", (BsonValue)new BsonBinary(doc4Field5));
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?,?,?)");
            stmt.setString(1, "pk1");
            stmt.setString(2, "c1_value1");
            stmt.setObject(3, doc1);
            stmt.executeUpdate();
            stmt.setString(1, "pk2");
            stmt.setString(2, "c1_value2");
            stmt.setObject(3, doc2);
            stmt.executeUpdate();
            stmt.setString(1, "pk3");
            stmt.setString(2, "c1_value3");
            stmt.setObject(3, doc3);
            stmt.executeUpdate();
            stmt.setString(1, "pk4");
            stmt.setString(2, "c1_value4");
            stmt.setObject(3, doc4);
            stmt.executeUpdate();
            conn.commit();
            ResultSet rs = conn.createStatement().executeQuery("SELECT count(*) FROM " + tableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)4L, (long)rs.getInt(1));
            rs = conn.createStatement().executeQuery("SELECT count(*) FROM " + indexName1);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)4L, (long)rs.getInt(1));
            rs = conn.createStatement().executeQuery("SELECT count(*) FROM " + indexName2);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            PreparedStatement ps = conn.prepareStatement("SELECT PK1, C1, COL, BSON_VALUE(COL, 'binary_field2', 'VARBINARY_ENCODED') FROM " + tableName + " WHERE BSON_VALUE(COL, 'binary_field1', 'VARBINARY_ENCODED') = ?");
            ps.setBytes(1, doc1Field1);
            rs = ps.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"pk1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"c1_value1", (Object)rs.getString(2));
            BsonDocument actualDoc = (BsonDocument)rs.getObject(3);
            Assert.assertEquals((Object)doc1, (Object)actualDoc);
            Assert.assertArrayEquals((byte[])doc1Field2, (byte[])rs.getBytes(4));
            Assert.assertFalse((boolean)rs.next());
            Bson4IT.validateExplainPlan(ps, indexName1, "RANGE SCAN ");
            ps = conn.prepareStatement("SELECT PK1, C1, COL FROM " + tableName + " WHERE BSON_VALUE(COL, 'binary_field3', 'VARBINARY_ENCODED') = ?");
            ps.setBytes(1, doc2Field3);
            rs = ps.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"pk2", (Object)rs.getString(1));
            Assert.assertEquals((Object)"c1_value2", (Object)rs.getString(2));
            actualDoc = (BsonDocument)rs.getObject(3);
            Assert.assertEquals((Object)doc2, (Object)actualDoc);
            Assert.assertFalse((boolean)rs.next());
            Bson4IT.validateExplainPlan(ps, indexName2, "RANGE SCAN ");
            ps = conn.prepareStatement("SELECT PK1, C1, COL FROM " + tableName + " WHERE BSON_VALUE(COL, 'binary_field1', 'VARBINARY_ENCODED') = ?");
            ps.setBytes(1, new byte[]{0, 1, 2, 3, 0, 0, 1, 5, 6, 7, 8, 0, 10, 11, 12, 13, 0, 0, -1, 15, 16, 17, 18, 19});
            rs = ps.executeQuery();
            Assert.assertFalse((boolean)rs.next());
            Bson4IT.validateExplainPlan(ps, indexName1, "RANGE SCAN ");
            ps = conn.prepareStatement("SELECT PK1, C1, COL, BSON_VALUE(COL, 'binary_field5', 'VARBINARY_ENCODED') FROM " + tableName + " WHERE C1 = ? AND BSON_VALUE(COL, 'binary_field1', 'VARBINARY_ENCODED') = ?");
            ps.setString(1, "c1_value2");
            ps.setBytes(2, doc2Field1);
            rs = ps.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"pk2", (Object)rs.getString(1));
            Assert.assertEquals((Object)"c1_value2", (Object)rs.getString(2));
            actualDoc = (BsonDocument)rs.getObject(3);
            Assert.assertEquals((Object)doc2, (Object)actualDoc);
            Assert.assertArrayEquals((byte[])doc2Field5, (byte[])rs.getBytes(4));
            Assert.assertFalse((boolean)rs.next());
            Bson4IT.validateExplainPlan(ps, indexName1, "RANGE SCAN ");
            ps = conn.prepareStatement("SELECT PK1, C1, COL FROM " + tableName + " WHERE C1 = ?");
            ps.setString(1, "c1_value3");
            rs = ps.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"pk3", (Object)rs.getString(1));
            Assert.assertEquals((Object)"c1_value3", (Object)rs.getString(2));
            actualDoc = (BsonDocument)rs.getObject(3);
            Assert.assertEquals((Object)doc3, (Object)actualDoc);
            Assert.assertFalse((boolean)rs.next());
            Bson4IT.validateExplainPlan(ps, tableName, "FULL SCAN ");
        }
    }

    @Test
    public void testBsonValueFunctionWithBSONType() throws Exception {
        Assume.assumeTrue((this.coveredIndex && this.columnEncoded ? 1 : 0) != 0);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = Bson4IT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(Bson4IT.getUrl(), props);){
            String ddl = "CREATE TABLE " + tableName + " (PK1 VARCHAR NOT NULL, C1 VARCHAR, COL BSON CONSTRAINT pk PRIMARY KEY(PK1)) " + (this.columnEncoded ? "" : "COLUMN_ENCODED_BYTES=0");
            conn.createStatement().execute(ddl);
            String sample1 = Bson4IT.getJsonString("json/sample_01.json");
            String sample2 = Bson4IT.getJsonString("json/sample_02.json");
            String sample3 = Bson4IT.getJsonString("json/sample_03.json");
            String result = Bson4IT.getJsonString("json/result_03.json");
            RawBsonDocument bsonDocument1 = RawBsonDocument.parse((String)sample1);
            RawBsonDocument bsonDocument2 = RawBsonDocument.parse((String)sample2);
            RawBsonDocument bsonDocument3 = RawBsonDocument.parse((String)sample3);
            RawBsonDocument bsonResultDocument = RawBsonDocument.parse((String)result);
            Bson4IT.upsertRows(conn, tableName, (BsonDocument)bsonDocument1, (BsonDocument)bsonDocument2, (BsonDocument)bsonDocument3);
            conn.commit();
            ResultSet rs = conn.createStatement().executeQuery("SELECT count(*) FROM " + tableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            PreparedStatement ps = conn.prepareStatement("SELECT PK1, COL, BSON_VALUE(COL, 'result[1]', 'BSON') FROM " + tableName + " WHERE BSON_VALUE(COL, 'result[1].location', 'BSON') = ?");
            Document info = new Document().append("street", (Object)"4897 Gerhold Lodge").append("city", (Object)"Minneapolis").append("state", (Object)"Arkansas").append("country", (Object)"Democratic Republic of the Congo").append("zip", (Object)"79299").append("coordinates", (Object)new Document().append("latitude", (Object)3.4015).append("longitude", (Object)52.3736));
            RawBsonDocument document = RawBsonDocument.parse((String)info.toJson());
            ps.setObject(1, document);
            rs = ps.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"pk1011", (Object)rs.getString(1));
            BsonDocument actualDoc = (BsonDocument)rs.getObject(3);
            Assert.assertEquals((Object)bsonResultDocument, (Object)actualDoc);
            Assert.assertFalse((boolean)rs.next());
            Bson4IT.validateExplainPlan(ps, tableName, "FULL SCAN ");
        }
    }

    @Test
    public void testBsonReturnValueWithEmptyUpdateExpression() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = Bson4IT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(Bson4IT.getUrl(), props);){
            conn.setAutoCommit(true);
            conn.createStatement().execute("CREATE TABLE " + tableName + " ( hk VARCHAR NOT NULL,  sk VARCHAR NOT NULL,  col BSON,  CONSTRAINT pk PRIMARY KEY (hk, sk))");
            RawBsonDocument bsonDoc = RawBsonDocument.parse((String)"{\"a\":1,\"b\":2}");
            PreparedStatement p = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?,?,?)");
            p.setString(1, "h1");
            p.setString(2, "s1");
            p.setObject(3, bsonDoc);
            p.execute();
            p = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?,?)  ON DUPLICATE KEY UPDATE\n COL = BSON_UPDATE_EXPRESSION(COL,'{}')");
            p.setString(1, "h1");
            p.setString(2, "s1");
            Pair resultPair = p.unwrap(PhoenixPreparedStatement.class).executeAtomicUpdateReturnRow();
            Assert.assertEquals((long)1L, (long)((Integer)resultPair.getFirst()).intValue());
            Assert.assertEquals((Object)bsonDoc, (Object)((ResultSet)resultPair.getSecond()).getObject(3));
            p = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?,?)  ON DUPLICATE KEY UPDATE\n COL = BSON_UPDATE_EXPRESSION(COL,?)");
            p.setString(1, "h1");
            p.setString(2, "s1");
            p.setObject(3, new BsonDocument());
            resultPair = p.unwrap(PhoenixPreparedStatement.class).executeAtomicUpdateReturnRow();
            Assert.assertEquals((long)1L, (long)((Integer)resultPair.getFirst()).intValue());
            Assert.assertEquals((Object)bsonDoc, (Object)((ResultSet)resultPair.getSecond()).getObject(3));
        }
    }

    @Test
    public void testConditionalUpsertReturnRow() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = Bson4IT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(Bson4IT.getUrl(), props);){
            conn.setAutoCommit(true);
            String ddl = "CREATE TABLE " + tableName + " (PK1 VARCHAR NOT NULL, C1 VARCHAR, COL BSON CONSTRAINT pk PRIMARY KEY(PK1))";
            conn.createStatement().execute(ddl);
            String sample1 = Bson4IT.getJsonString("json/sample_01.json");
            String sample2 = Bson4IT.getJsonString("json/sample_02.json");
            String sample3 = Bson4IT.getJsonString("json/sample_03.json");
            RawBsonDocument bsonDocument1 = RawBsonDocument.parse((String)sample1);
            RawBsonDocument bsonDocument2 = RawBsonDocument.parse((String)sample2);
            RawBsonDocument bsonDocument3 = RawBsonDocument.parse((String)sample3);
            Bson4IT.upsertRows(conn, tableName, (BsonDocument)bsonDocument1, (BsonDocument)bsonDocument2, (BsonDocument)bsonDocument3);
            String conditionExpression = "press = :press AND track[0].shot[2][0].city.standard[50] = :softly";
            BsonDocument conditionDoc = new BsonDocument();
            conditionDoc.put("$EXPR", (BsonValue)new BsonString(conditionExpression));
            conditionDoc.put("$VAL", (BsonValue)new BsonDocument().append(":press", (BsonValue)new BsonString("beat")).append(":softly", (BsonValue)new BsonString("softly")));
            String query = "SELECT * FROM " + tableName + " WHERE PK1 = 'pk0001' AND C1 = '0002' AND NOT BSON_CONDITION_EXPRESSION(COL, '" + conditionDoc.toJson() + "')";
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"pk0001", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0002", (Object)rs.getString(2));
            BsonDocument document1 = (BsonDocument)rs.getObject(3);
            Assert.assertEquals((Object)bsonDocument1, (Object)document1);
            Assert.assertFalse((boolean)rs.next());
            conditionExpression = "press = :press AND track[0].shot[2][0].city.standard[5] = :softly";
            conditionDoc = new BsonDocument();
            conditionDoc.put("$EXPR", (BsonValue)new BsonString(conditionExpression));
            conditionDoc.put("$VAL", (BsonValue)new BsonDocument().append(":press", (BsonValue)new BsonString("beat")).append(":softly", (BsonValue)new BsonString("softly")));
            query = "SELECT * FROM " + tableName + " WHERE PK1 = 'pk0001' AND C1 = '0002' AND BSON_CONDITION_EXPRESSION(COL, '" + conditionDoc.toJson() + "')";
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"pk0001", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0002", (Object)rs.getString(2));
            document1 = (BsonDocument)rs.getObject(3);
            Assert.assertEquals((Object)bsonDocument1, (Object)document1);
            Assert.assertFalse((boolean)rs.next());
            BsonDocument updateExp = new BsonDocument().append("$SET", (BsonValue)new BsonDocument().append("browserling", (BsonValue)new BsonBinary(PDouble.INSTANCE.toBytes((Object)-5.0516934054880095E8))).append("track[0].shot[2][0].city.standard[5]", (BsonValue)new BsonString("soft")).append("track[0].shot[2][0].city.problem[2]", (BsonValue)new BsonString("track[0].shot[2][0].city.problem[2] + 529.435"))).append("$UNSET", (BsonValue)new BsonDocument().append("track[0].shot[2][0].city.flame", (BsonValue)new BsonNull()));
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?) ON DUPLICATE KEY UPDATE_ONLY COL = CASE WHEN BSON_CONDITION_EXPRESSION(COL, '" + conditionDoc.toJson() + "') THEN BSON_UPDATE_EXPRESSION(COL, '" + updateExp + "') ELSE COL END, C1 = ? RETURNING *");
            stmt.setString(1, "pk0001");
            stmt.setString(2, "0003");
            Bson4IT.assertReturnedRowResult(stmt, "json/sample_updated_01.json", true);
            updateExp = new BsonDocument().append("$ADD", (BsonValue)new BsonDocument().append("new_samples", (BsonValue)new BsonDocument().append("$set", (BsonValue)new BsonArray(Arrays.asList(new BsonBinary(Bytes.toBytes((String)"Sample10")), new BsonBinary(Bytes.toBytes((String)"Sample12")), new BsonBinary(Bytes.toBytes((String)"Sample13")), new BsonBinary(Bytes.toBytes((String)"Sample14"))))))).append("$DELETE_FROM_SET", (BsonValue)new BsonDocument().append("new_samples", (BsonValue)new BsonDocument().append("$set", (BsonValue)new BsonArray(Arrays.asList(new BsonBinary(Bytes.toBytes((String)"Sample02")), new BsonBinary(Bytes.toBytes((String)"Sample03"))))))).append("$SET", (BsonValue)new BsonDocument().append("newrecord", ((BsonArray)document1.get((Object)"track")).get(0))).append("$UNSET", (BsonValue)new BsonDocument().append("rather[3].outline.halfway.so[2][2]", (BsonValue)new BsonNull()));
            conditionExpression = "field_not_exists(newrecord) AND field_exists(rather[3].outline.halfway.so[2][2])";
            conditionDoc = new BsonDocument();
            conditionDoc.put("$EXPR", (BsonValue)new BsonString(conditionExpression));
            conditionDoc.put("$VAL", (BsonValue)new BsonDocument());
            stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?) ON DUPLICATE KEY UPDATE COL = CASE WHEN BSON_CONDITION_EXPRESSION(COL, '" + conditionDoc.toJson() + "') THEN BSON_UPDATE_EXPRESSION(COL, '" + updateExp + "') ELSE COL END RETURNING *");
            stmt.setString(1, "pk1010");
            Bson4IT.assertReturnedRowResult(stmt, "json/sample_updated_02.json", true);
            updateExp = new BsonDocument().append("$SET", (BsonValue)new BsonDocument().append("result[1].location.state", (BsonValue)new BsonString("AK"))).append("$UNSET", (BsonValue)new BsonDocument().append("result[4].emails[1]", (BsonValue)new BsonNull()));
            conditionExpression = "result[2].location.coordinates.latitude > :latitude OR (field_exists(result[1].location) AND result[1].location.state != :state AND field_exists(result[4].emails[1]))";
            conditionDoc = new BsonDocument();
            conditionDoc.put("$EXPR", (BsonValue)new BsonString(conditionExpression));
            conditionDoc.put("$VAL", (BsonValue)new BsonDocument().append(":latitude", (BsonValue)new BsonDouble(0.0)).append(":state", (BsonValue)new BsonString("AK")));
            stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?) ON DUPLICATE KEY UPDATE COL = CASE WHEN BSON_CONDITION_EXPRESSION(COL, '" + conditionDoc.toJson() + "') THEN BSON_UPDATE_EXPRESSION(COL, '" + updateExp + "') ELSE COL END RETURNING *");
            stmt.setString(1, "pk1011");
            Bson4IT.assertReturnedRowResult(stmt, "json/sample_updated_03.json", true);
            conditionExpression = "press = :press AND track[0].shot[2][0].city.standard[5] = :softly";
            conditionDoc = new BsonDocument();
            conditionDoc.put("$EXPR", (BsonValue)new BsonString(conditionExpression));
            conditionDoc.put("$VAL", (BsonValue)new BsonDocument().append(":press", (BsonValue)new BsonString("incorrect_value")).append(":softly", (BsonValue)new BsonString("incorrect_value")));
            updateExp = new BsonDocument().append("$SET", (BsonValue)new BsonDocument().append("new_field1", (BsonValue)new BsonBinary(PDouble.INSTANCE.toBytes((Object)-5.0516934054880095E8))).append("track[0].shot[2][0].city.standard[5]", (BsonValue)new BsonString("soft_new_val")).append("track[0].shot[2][0].city.problem[2]", (BsonValue)new BsonString("track[0].shot[2][0].city.problem[2] + 123")));
            stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?) ON DUPLICATE KEY UPDATE COL = CASE WHEN BSON_CONDITION_EXPRESSION(COL, '" + conditionDoc.toJson() + "') THEN BSON_UPDATE_EXPRESSION(COL, '" + updateExp + "') ELSE COL END RETURNING *");
            stmt.setString(1, "pk0001");
            Bson4IT.assertReturnedRowResult(stmt, "json/sample_updated_01.json", false);
            stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?) ON DUPLICATE KEY UPDATE_ONLY COL = CASE WHEN BSON_CONDITION_EXPRESSION(COL, '" + conditionDoc.toJson() + "') THEN BSON_UPDATE_EXPRESSION(COL, '" + updateExp + "') ELSE COL END RETURNING *");
            stmt.setString(1, "pk000111");
            Bson4IT.assertReturnedRowResult(stmt, null, false);
            Bson4IT.verifyRows(tableName, conn, false);
            stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?) ON DUPLICATE KEY UPDATE COL = CASE WHEN BSON_CONDITION_EXPRESSION(COL, '" + conditionDoc.toJson() + "') THEN BSON_UPDATE_EXPRESSION(COL, '" + updateExp + "') ELSE COL END RETURNING *");
            stmt.setString(1, "pk000123456");
            Bson4IT.assertReturnedRowResult(stmt, null, true);
            Bson4IT.verifyRows(tableName, conn, true);
        }
    }

    @Test
    public void testConditionalUpsertReturnOldRow() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = Bson4IT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(Bson4IT.getUrl(), props);){
            conn.setAutoCommit(true);
            String ddl = "CREATE TABLE " + tableName + " (PK1 VARCHAR NOT NULL, C1 VARCHAR, COL BSON CONSTRAINT pk PRIMARY KEY(PK1))";
            conn.createStatement().execute(ddl);
            String sample1 = Bson4IT.getJsonString("json/sample_01.json");
            String sample2 = Bson4IT.getJsonString("json/sample_02.json");
            String sample3 = Bson4IT.getJsonString("json/sample_03.json");
            RawBsonDocument bsonDocument1 = RawBsonDocument.parse((String)sample1);
            RawBsonDocument bsonDocument2 = RawBsonDocument.parse((String)sample2);
            RawBsonDocument bsonDocument3 = RawBsonDocument.parse((String)sample3);
            Bson4IT.upsertRows(conn, tableName, (BsonDocument)bsonDocument1, (BsonDocument)bsonDocument2, (BsonDocument)bsonDocument3);
            String conditionExpression = "press = :press AND track[0].shot[2][0].city.standard[50] = :softly";
            BsonDocument conditionDoc = new BsonDocument();
            conditionDoc.put("$EXPR", (BsonValue)new BsonString(conditionExpression));
            conditionDoc.put("$VAL", (BsonValue)new BsonDocument().append(":press", (BsonValue)new BsonString("beat")).append(":softly", (BsonValue)new BsonString("softly")));
            String query = "SELECT * FROM " + tableName + " WHERE PK1 = 'pk0001' AND C1 = '0002' AND NOT BSON_CONDITION_EXPRESSION(COL, '" + conditionDoc.toJson() + "')";
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"pk0001", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0002", (Object)rs.getString(2));
            BsonDocument document1 = (BsonDocument)rs.getObject(3);
            Assert.assertEquals((Object)bsonDocument1, (Object)document1);
            Assert.assertFalse((boolean)rs.next());
            conditionExpression = "press = :press AND track[0].shot[2][0].city.standard[5] = :softly";
            conditionDoc = new BsonDocument();
            conditionDoc.put("$EXPR", (BsonValue)new BsonString(conditionExpression));
            conditionDoc.put("$VAL", (BsonValue)new BsonDocument().append(":press", (BsonValue)new BsonString("beat")).append(":softly", (BsonValue)new BsonString("softly")));
            query = "SELECT * FROM " + tableName + " WHERE PK1 = 'pk0001' AND C1 = '0002' AND BSON_CONDITION_EXPRESSION(COL, '" + conditionDoc.toJson() + "')";
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"pk0001", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0002", (Object)rs.getString(2));
            document1 = (BsonDocument)rs.getObject(3);
            Assert.assertEquals((Object)bsonDocument1, (Object)document1);
            Assert.assertFalse((boolean)rs.next());
            BsonDocument updateExp = new BsonDocument().append("$SET", (BsonValue)new BsonDocument().append("browserling", (BsonValue)new BsonBinary(PDouble.INSTANCE.toBytes((Object)-5.0516934054880095E8))).append("track[0].shot[2][0].city.standard[5]", (BsonValue)new BsonString("soft")).append("track[0].shot[2][0].city.problem[2]", (BsonValue)new BsonString("track[0].shot[2][0].city.problem[2] + 529.435"))).append("$UNSET", (BsonValue)new BsonDocument().append("track[0].shot[2][0].city.flame", (BsonValue)new BsonNull()));
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?) ON DUPLICATE KEY UPDATE COL = CASE WHEN BSON_CONDITION_EXPRESSION(COL, '" + conditionDoc.toJson() + "') THEN BSON_UPDATE_EXPRESSION(COL, '" + updateExp + "') ELSE COL END, C1 = ?");
            stmt.setString(1, "pk0001");
            stmt.setString(2, "0003");
            Bson4IT.assertReturnedOldRowResult(stmt, "json/sample_01.json", true);
            updateExp = new BsonDocument().append("$ADD", (BsonValue)new BsonDocument().append("new_samples", (BsonValue)new BsonDocument().append("$set", (BsonValue)new BsonArray(Arrays.asList(new BsonBinary(Bytes.toBytes((String)"Sample10")), new BsonBinary(Bytes.toBytes((String)"Sample12")), new BsonBinary(Bytes.toBytes((String)"Sample13")), new BsonBinary(Bytes.toBytes((String)"Sample14"))))))).append("$DELETE_FROM_SET", (BsonValue)new BsonDocument().append("new_samples", (BsonValue)new BsonDocument().append("$set", (BsonValue)new BsonArray(Arrays.asList(new BsonBinary(Bytes.toBytes((String)"Sample02")), new BsonBinary(Bytes.toBytes((String)"Sample03"))))))).append("$SET", (BsonValue)new BsonDocument().append("newrecord", ((BsonArray)document1.get((Object)"track")).get(0))).append("$UNSET", (BsonValue)new BsonDocument().append("rather[3].outline.halfway.so[2][2]", (BsonValue)new BsonNull()));
            conditionExpression = "field_not_exists(newrecord) AND field_exists(rather[3].outline.halfway.so[2][2])";
            conditionDoc = new BsonDocument();
            conditionDoc.put("$EXPR", (BsonValue)new BsonString(conditionExpression));
            conditionDoc.put("$VAL", (BsonValue)new BsonDocument());
            stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?) ON DUPLICATE KEY UPDATE COL = CASE WHEN BSON_CONDITION_EXPRESSION(COL, '" + conditionDoc.toJson() + "') THEN BSON_UPDATE_EXPRESSION(COL, '" + updateExp + "') ELSE COL END");
            stmt.setString(1, "pk1010");
            Bson4IT.assertReturnedOldRowResult(stmt, "json/sample_02.json", true);
            updateExp = new BsonDocument().append("$SET", (BsonValue)new BsonDocument().append("result[1].location.state", (BsonValue)new BsonString("AK"))).append("$UNSET", (BsonValue)new BsonDocument().append("result[4].emails[1]", (BsonValue)new BsonNull()));
            conditionExpression = "result[2].location.coordinates.latitude > :latitude OR (field_exists(result[1].location) AND result[1].location.state != :state AND field_exists(result[4].emails[1]))";
            conditionDoc = new BsonDocument();
            conditionDoc.put("$EXPR", (BsonValue)new BsonString(conditionExpression));
            conditionDoc.put("$VAL", (BsonValue)new BsonDocument().append(":latitude", (BsonValue)new BsonDouble(0.0)).append(":state", (BsonValue)new BsonString("AK")));
            stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?) ON DUPLICATE KEY UPDATE_ONLY COL = CASE WHEN BSON_CONDITION_EXPRESSION(COL, '" + conditionDoc.toJson() + "') THEN BSON_UPDATE_EXPRESSION(COL, '" + updateExp + "') ELSE COL END");
            stmt.setString(1, "pk1011");
            Bson4IT.assertReturnedOldRowResult(stmt, "json/sample_03.json", true);
            conditionExpression = "press = :press AND track[0].shot[2][0].city.standard[5] = :softly";
            conditionDoc = new BsonDocument();
            conditionDoc.put("$EXPR", (BsonValue)new BsonString(conditionExpression));
            conditionDoc.put("$VAL", (BsonValue)new BsonDocument().append(":press", (BsonValue)new BsonString("incorrect_value")).append(":softly", (BsonValue)new BsonString("incorrect_value")));
            updateExp = new BsonDocument().append("$SET", (BsonValue)new BsonDocument().append("new_field1", (BsonValue)new BsonBinary(PDouble.INSTANCE.toBytes((Object)-5.0516934054880095E8))).append("track[0].shot[2][0].city.standard[5]", (BsonValue)new BsonString("soft_new_val")).append("track[0].shot[2][0].city.problem[2]", (BsonValue)new BsonString("track[0].shot[2][0].city.problem[2] + 123")));
            stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?) ON DUPLICATE KEY UPDATE_ONLY COL = CASE WHEN BSON_CONDITION_EXPRESSION(COL, '" + conditionDoc.toJson() + "') THEN BSON_UPDATE_EXPRESSION(COL, '" + updateExp + "') ELSE COL END");
            stmt.setString(1, "pk0001");
            Bson4IT.assertReturnedOldRowResult(stmt, "json/sample_updated_01.json", false);
            stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?) ON DUPLICATE KEY UPDATE_ONLY COL = CASE WHEN BSON_CONDITION_EXPRESSION(COL, '" + conditionDoc.toJson() + "') THEN BSON_UPDATE_EXPRESSION(COL, '" + updateExp + "') ELSE COL END");
            stmt.setString(1, "pk00012345");
            Bson4IT.assertReturnedOldRowResult(stmt, null, false);
            Bson4IT.verifyRows(tableName, conn, false);
            stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?) ON DUPLICATE KEY UPDATE COL = CASE WHEN BSON_CONDITION_EXPRESSION(COL, '" + conditionDoc.toJson() + "') THEN BSON_UPDATE_EXPRESSION(COL, '" + updateExp + "') ELSE COL END");
            stmt.setString(1, "pk000123456");
            Bson4IT.assertReturnedOldRowResult(stmt, null, true);
            Bson4IT.verifyRows(tableName, conn, true);
        }
    }

    @Test
    public void testBsonPk() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = Bson4IT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(Bson4IT.getUrl(), props);){
            conn.setAutoCommit(true);
            String ddl = "CREATE TABLE " + tableName + " (PK1 BSON NOT NULL, C1 VARCHAR CONSTRAINT pk PRIMARY KEY(PK1))";
            conn.createStatement().execute(ddl);
            String sample1 = Bson4IT.getJsonString("json/sample_01.json");
            String sample2 = Bson4IT.getJsonString("json/sample_02.json");
            String sample3 = Bson4IT.getJsonString("json/sample_03.json");
            RawBsonDocument bsonDocument1 = RawBsonDocument.parse((String)sample1);
            RawBsonDocument bsonDocument2 = RawBsonDocument.parse((String)sample2);
            RawBsonDocument bsonDocument3 = RawBsonDocument.parse((String)sample3);
            Bson4IT.upsertRowsWithBsonPkCol(conn, tableName, (BsonDocument)bsonDocument1, (BsonDocument)bsonDocument2, (BsonDocument)bsonDocument3);
            String conditionExpression = "press = :press AND track[0].shot[2][0].city.standard[5] = :softly";
            BsonDocument conditionDoc = new BsonDocument();
            conditionDoc.put("$EXPR", (BsonValue)new BsonString(conditionExpression));
            conditionDoc.put("$VAL", (BsonValue)new BsonDocument().append(":press", (BsonValue)new BsonString("beat")).append(":softly", (BsonValue)new BsonString("softly")));
            String query = "SELECT * FROM " + tableName + " WHERE PK1 = ?";
            PreparedStatement pst = conn.prepareStatement(query);
            pst.setObject(1, bsonDocument1);
            ResultSet rs = pst.executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"0002", (Object)rs.getString(2));
            BsonDocument document1 = (BsonDocument)rs.getObject(1);
            Assert.assertEquals((Object)bsonDocument1, (Object)document1);
            Assert.assertFalse((boolean)rs.next());
            Bson4IT.validateExplainPlan(pst, tableName, "POINT LOOKUP ON 1 KEY ");
            query = "SELECT * FROM " + tableName + " WHERE PK1 = CAST('" + sample2 + "' AS BSON)";
            Statement stmt = conn.createStatement();
            rs = stmt.executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"1010", (Object)rs.getString(2));
            BsonDocument document2 = (BsonDocument)rs.getObject(1);
            Assert.assertEquals((Object)bsonDocument2, (Object)document2);
            Assert.assertFalse((boolean)rs.next());
            Bson4IT.validateExplainPlan(stmt, query, tableName, "POINT LOOKUP ON 1 KEY ");
            query = "SELECT * FROM " + tableName + " WHERE PK1 != CAST('" + sample1 + "' AS BSON)";
            stmt = conn.createStatement();
            rs = stmt.executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"1011", (Object)rs.getString(2));
            document2 = (BsonDocument)rs.getObject(1);
            Assert.assertEquals((Object)bsonDocument3, (Object)document2);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"1010", (Object)rs.getString(2));
            BsonDocument document3 = (BsonDocument)rs.getObject(1);
            Assert.assertEquals((Object)bsonDocument2, (Object)document3);
            Assert.assertFalse((boolean)rs.next());
            Bson4IT.validateExplainPlan(stmt, query, tableName, "FULL SCAN ");
            query = "SELECT * FROM " + tableName;
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"0002", (Object)rs.getString(2));
            document1 = (BsonDocument)rs.getObject(1);
            Assert.assertEquals((Object)bsonDocument1, (Object)document1);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"1011", (Object)rs.getString(2));
            document2 = (BsonDocument)rs.getObject(1);
            Assert.assertEquals((Object)bsonDocument3, (Object)document2);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"1010", (Object)rs.getString(2));
            document3 = (BsonDocument)rs.getObject(1);
            Assert.assertEquals((Object)bsonDocument2, (Object)document3);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testIndexingONBsonNotAllowed() throws Exception {
        Assume.assumeTrue((this.coveredIndex && this.columnEncoded ? 1 : 0) != 0);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = Bson4IT.generateUniqueName();
        String indexName1 = "IDX1_" + tableName;
        String indexName2 = "IDX2_" + tableName;
        try (Connection conn = DriverManager.getConnection(Bson4IT.getUrl(), props);){
            String ddl = "CREATE TABLE " + tableName + " (PK1 VARCHAR NOT NULL, C1 VARCHAR, COL BSON  CONSTRAINT pk PRIMARY KEY(PK1)) " + (this.columnEncoded ? "" : "COLUMN_ENCODED_BYTES=0");
            String indexDdl1 = "CREATE INDEX " + indexName1 + " ON " + tableName + "(COL)";
            String indexDdl2 = "CREATE INDEX " + indexName2 + " ON " + tableName + "(C1)";
            conn.createStatement().execute(ddl);
            try {
                conn.createStatement().execute(indexDdl1);
                Assert.fail((String)"Should have seen SQLExceptionCode.BSON_IN_ROW_KEY");
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.BSON_IN_ROW_KEY.getErrorCode(), (long)e.getErrorCode());
            }
            conn.createStatement().execute(indexDdl2);
            String sample1 = Bson4IT.getJsonString("json/sample_01.json");
            String sample2 = Bson4IT.getJsonString("json/sample_02.json");
            String sample3 = Bson4IT.getJsonString("json/sample_03.json");
            RawBsonDocument bsonDocument1 = RawBsonDocument.parse((String)sample1);
            RawBsonDocument bsonDocument2 = RawBsonDocument.parse((String)sample2);
            RawBsonDocument bsonDocument3 = RawBsonDocument.parse((String)sample3);
            Bson4IT.upsertRows(conn, tableName, (BsonDocument)bsonDocument1, (BsonDocument)bsonDocument2, (BsonDocument)bsonDocument3);
            conn.commit();
            ResultSet rs = conn.createStatement().executeQuery("SELECT count(*) FROM " + indexName2);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
        }
    }

    private static void upsertRowsWithBsonPkCol(Connection conn, String tableName, BsonDocument bsonDocument1, BsonDocument bsonDocument2, BsonDocument bsonDocument3) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?,?)");
        stmt.setString(2, "0002");
        stmt.setObject(1, bsonDocument1);
        stmt.executeUpdate();
        stmt.setString(2, "1010");
        stmt.setObject(1, bsonDocument2);
        stmt.executeUpdate();
        stmt.setString(2, "1011");
        stmt.setObject(1, bsonDocument3);
        stmt.executeUpdate();
    }

    private static void upsertRows(Connection conn, String tableName, BsonDocument bsonDocument1, BsonDocument bsonDocument2, BsonDocument bsonDocument3) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?,?,?)");
        stmt.setString(1, "pk0001");
        stmt.setString(2, "0002");
        stmt.setObject(3, bsonDocument1);
        stmt.executeUpdate();
        stmt.setString(1, "pk1010");
        stmt.setString(2, "1010");
        stmt.setObject(3, bsonDocument2);
        stmt.executeUpdate();
        stmt.setString(1, "pk1011");
        stmt.setString(2, "1011");
        stmt.setObject(3, bsonDocument3);
        stmt.executeUpdate();
    }

    private static void verifyRows(String tableName, Connection conn, boolean isNewRowAdded) throws SQLException, IOException {
        String query = "SELECT * FROM " + tableName;
        ResultSet rs = conn.createStatement().executeQuery(query);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"pk0001", (Object)rs.getString(1));
        Assert.assertEquals((Object)"0003", (Object)rs.getString(2));
        BsonDocument document1 = (BsonDocument)rs.getObject(3);
        String updatedJson = Bson4IT.getJsonString("json/sample_updated_01.json");
        Assert.assertEquals((Object)RawBsonDocument.parse((String)updatedJson), (Object)document1);
        if (isNewRowAdded) {
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"pk000123456", (Object)rs.getString(1));
            Assert.assertNull((Object)rs.getString(2));
            Assert.assertNull((Object)rs.getObject(3));
        }
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"pk1010", (Object)rs.getString(1));
        Assert.assertEquals((Object)"1010", (Object)rs.getString(2));
        BsonDocument document2 = (BsonDocument)rs.getObject(3);
        updatedJson = Bson4IT.getJsonString("json/sample_updated_02.json");
        Assert.assertEquals((Object)RawBsonDocument.parse((String)updatedJson), (Object)document2);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"pk1011", (Object)rs.getString(1));
        Assert.assertEquals((Object)"1011", (Object)rs.getString(2));
        BsonDocument document3 = (BsonDocument)rs.getObject(3);
        updatedJson = Bson4IT.getJsonString("json/sample_updated_03.json");
        Assert.assertEquals((Object)RawBsonDocument.parse((String)updatedJson), (Object)document3);
        Assert.assertFalse((boolean)rs.next());
    }

    private static void assertReturnedRowResult(PreparedStatement stmt, String jsonPath, boolean success) throws SQLException, IOException {
        stmt.execute();
        Assert.assertEquals((long)(success ? 1L : 0L), (long)stmt.getUpdateCount());
        ResultSet resultSet = stmt.getResultSet();
        Assert.assertTrue((boolean)resultSet.next());
        Assert.assertEquals((Object)(jsonPath == null ? null : RawBsonDocument.parse((String)Bson4IT.getJsonString(jsonPath))), (Object)resultSet.getObject(3));
    }

    private static void assertReturnedOldRowResult(PreparedStatement stmt, String jsonPath, boolean success) throws SQLException, IOException {
        Pair resultPair = stmt.unwrap(PhoenixPreparedStatement.class).executeAtomicUpdateReturnOldRow();
        Assert.assertEquals((long)(success ? 1L : 0L), (long)((Integer)resultPair.getFirst()).intValue());
        ResultSet resultSet = (ResultSet)resultPair.getSecond();
        if (success) {
            Assert.assertEquals((Object)(jsonPath == null ? null : RawBsonDocument.parse((String)Bson4IT.getJsonString(jsonPath))), (Object)resultSet.getObject(3));
            Assert.assertFalse((boolean)resultSet.next());
        } else {
            Assert.assertEquals((Object)(jsonPath == null ? null : RawBsonDocument.parse((String)Bson4IT.getJsonString(jsonPath))), (Object)resultSet.getObject(3));
        }
    }

    private static void validateExplainPlan(PreparedStatement ps, String tableName, String scanType) throws SQLException {
        ExplainPlan plan = ps.unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
        Bson4IT.validatePlan(tableName, scanType, plan);
    }

    private static void validateExplainPlan(Statement stmt, String query, String tableName, String scanType) throws SQLException {
        ExplainPlan plan = stmt.unwrap(PhoenixStatement.class).optimizeQuery(query).getExplainPlan();
        Bson4IT.validatePlan(tableName, scanType, plan);
    }

    private static void validatePlan(String tableName, String scanType, ExplainPlan plan) {
        ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
        Assert.assertEquals((Object)tableName, (Object)explainPlanAttributes.getTableName());
        Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
        Assert.assertEquals((Object)scanType, (Object)explainPlanAttributes.getExplainScanType());
    }
}

