/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.filter.SubstringComparator;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.compile.CreateTableCompiler;
import org.apache.phoenix.compile.FromCompiler;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.compile.WhereOptimizer;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.RowKeyColumnExpression;
import org.apache.phoenix.expression.visitor.ExpressionVisitor;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.ParseNodeVisitor;
import org.apache.phoenix.parse.SQLParser;
import org.apache.phoenix.parse.SelectStatement;
import org.apache.phoenix.parse.TableName;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PDatum;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.RowKeyValueAccessor;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.ResultTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PChar;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PSmallint;
import org.apache.phoenix.schema.types.PTimestamp;
import org.apache.phoenix.schema.types.PTinyint;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.schema.types.PVarbinaryEncoded;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.ViewUtil;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseRowKeyMatcherTestIT
extends ParallelStatsDisabledIT {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseRowKeyMatcherTestIT.class);
    public static final String TENANT_URL_FMT = "%s;%s=%s";
    public static final String ORG_ID_PREFIX = "00D0x0000";
    public static final String ORG_ID_FMT = "%s%06d";
    public static final String PARTITION_FMT = "%03d";
    public static final String BASE_TABLE_NAME_FMT = "TEST_ENTITY.%s";
    public static final String INDEX_TABLE_NAME_FMT = "_IDX_TEST_ENTITY.%s";
    public static final String GLOBAL_VIEW_NAME_FMT = "TEST_ENTITY.G1_%s";
    public static final String TENANT_VIEW_NAME_FMT = "TEST_ENTITY.TV_%s_%d";
    public static final String LEAF_VIEW_NAME_FMT = "TEST_ENTITY.Z%02d_%02d_%s";
    public static final String ROW_ID_FMT = "00R0x000%07d";
    public static final String ZID_FMT = "00Z0x000%07d";
    public static final String COL1_FMT = "a%05d";
    public static final String COL2_FMT = "b%05d";
    public static final String COL3_FMT = "b%05d";
    public static final Random RANDOM_GEN = new Random();
    public static final int MAX_ROWS = 10000;

    private String getType(PDataType pkType) {
        String pkTypeStr = "VARCHAR(25)";
        switch (pkType.getSqlType()) {
            case 12: {
                pkTypeStr = "VARCHAR(25)";
                break;
            }
            case 1: {
                pkTypeStr = "CHAR(15)";
                break;
            }
            case 3: {
                pkTypeStr = "DECIMAL(8,2)";
                break;
            }
            case 4: {
                pkTypeStr = "INTEGER";
                break;
            }
            case -5: {
                pkTypeStr = "BIGINT";
                break;
            }
            case 91: {
                pkTypeStr = "DATE";
                break;
            }
            case 93: {
                pkTypeStr = "TIMESTAMP";
                break;
            }
            case -3: {
                pkTypeStr = "VARBINARY";
                break;
            }
            case 9000: {
                pkTypeStr = "VARBINARY_ENCODED";
                break;
            }
            default: {
                pkTypeStr = "VARCHAR(25)";
            }
        }
        return pkTypeStr;
    }

    private Object getData(PDataType type) {
        Random rnd = new Random();
        switch (type.getSqlType()) {
            case 12: {
                return RandomStringUtils.randomAlphanumeric((int)25);
            }
            case 1: {
                return RandomStringUtils.randomAlphanumeric((int)15);
            }
            case 3: {
                return Math.floor((double)rnd.nextInt(50000) * rnd.nextDouble());
            }
            case 4: {
                return rnd.nextInt(50000);
            }
            case -5: {
                return rnd.nextLong();
            }
            case 91: {
                return new Date(System.currentTimeMillis() + (long)rnd.nextInt(50000));
            }
            case 93: {
                return new Timestamp(System.currentTimeMillis() + (long)rnd.nextInt(50000));
            }
            case -3: 
            case 9000: {
                byte[] varBytes = ByteUtil.concat((byte[])RandomStringUtils.randomAlphanumeric((int)25).getBytes(), (byte[][])new byte[][]{Bytes.toBytes((int)rnd.nextInt(50000)), Bytes.toBytes((double)Math.floor((double)rnd.nextInt(50000) * rnd.nextDouble()))});
                return PVarbinary.INSTANCE.toStringLiteral((Object)varBytes);
            }
        }
        return RandomStringUtils.randomAlphanumeric((int)25);
    }

    private Object getPKData(String testPKTypes) {
        Random rnd = new Random();
        switch (testPKTypes) {
            case "VARCHAR": {
                return RandomStringUtils.randomAlphanumeric((int)25);
            }
            case "CHAR(15)": {
                return RandomStringUtils.randomAlphanumeric((int)15);
            }
            case "CHAR(3)": {
                return RandomStringUtils.randomAlphanumeric((int)3);
            }
            case "DECIMAL": {
                return Math.floor((double)rnd.nextInt(50000) * rnd.nextDouble());
            }
            case "INTEGER": {
                return rnd.nextInt(50000);
            }
            case "BIGINT": {
                return rnd.nextInt(50000);
            }
            case "DATE": {
                return new Date(System.currentTimeMillis() + (long)rnd.nextInt(50000));
            }
            case "TIMESTAMP": {
                return new Timestamp(System.currentTimeMillis() + (long)rnd.nextInt(50000));
            }
        }
        return RandomStringUtils.randomAlphanumeric((int)25);
    }

    private void createBaseTable(String tableName, boolean isMultiTenant, PDataType tenantDataType) throws SQLException {
        String baseTableName = String.format(BASE_TABLE_NAME_FMT, tableName);
        try (Connection globalConnection = DriverManager.getConnection(BaseRowKeyMatcherTestIT.getUrl());
             Statement cstmt = globalConnection.createStatement();){
            String CO_BASE_TBL_TEMPLATE = "CREATE TABLE IF NOT EXISTS %s(OID %s NOT NULL,KP CHAR(3) NOT NULL, COL1 VARCHAR,CREATED_DATE DATE,CREATED_BY CHAR(15),LAST_UPDATE DATE,LAST_UPDATE_BY CHAR(15),SYSTEM_MODSTAMP DATE CONSTRAINT pk PRIMARY KEY (OID,KP)) COLUMN_ENCODED_BYTES=0 %s";
            cstmt.execute(String.format(CO_BASE_TBL_TEMPLATE, baseTableName, this.getType(tenantDataType), isMultiTenant ? ", MULTI_TENANT=true" : ""));
        }
    }

    /*
     * Exception decompiling
     */
    private Pair<String, byte[]> createGlobalView(String tableName, int partition, PDataType[] pkTypes, SortOrder[] pkOrders, boolean hasGlobalViewIndexes) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private Pair<String, byte[]> createTenantView(boolean extendPK, int partition, PDataType tenantIdType, int tenant, int tenantViewNum, String[] pkNames, PDataType[] pkTypes) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upsertTenantViewRows(boolean isMultiTenant, boolean extendPK, int partition, PDataType tenantIdType, int tenant, int tenantViewNum, int rowIndex, String[] pkNames, PDataType[] pkTypes) throws SQLException {
        String tenantId;
        Object pk3;
        Object pk2;
        Object pk1;
        String col2;
        String col1;
        String rid;
        block65: {
            rid = String.format(ROW_ID_FMT, rowIndex);
            String zid = String.format(ZID_FMT, rowIndex);
            col1 = String.format(COL1_FMT, rowIndex, RANDOM_GEN.nextInt(10000));
            col2 = String.format("b%05d", rowIndex, RANDOM_GEN.nextInt(10000));
            String col3 = String.format("b%05d", rowIndex, RANDOM_GEN.nextInt(10000));
            pk1 = null;
            pk2 = null;
            pk3 = null;
            String partitionName = String.format(PARTITION_FMT, partition);
            tenantId = "";
            tenantId = tenantIdType.getSqlType() == 12 || tenantIdType.getSqlType() == 1 ? String.format(ORG_ID_FMT, ORG_ID_PREFIX, tenant) : String.format("%015d", tenant);
            String tenantConnectionUrl = String.format(TENANT_URL_FMT, BaseRowKeyMatcherTestIT.getUrl(), "TenantId", tenantId);
            String tenantViewName = String.format(TENANT_VIEW_NAME_FMT, partitionName, tenantViewNum);
            try (PhoenixConnection tenantConnection = DriverManager.getConnection(tenantConnectionUrl).unwrap(PhoenixConnection.class);){
                tenantConnection.setAutoCommit(true);
                String TENANT_VIEW_WITH_PK = String.format("UPSERT INTO %s(ROW_ID, ZID, COL1, COL2, COL3, SYSTEM_MODSTAMP) VALUES(?, ?, ?, ?, ?, ?)", tenantViewName);
                String TENANT_VIEW_WO_PK = String.format("UPSERT INTO %s(ID1, ID2, ID3, ROW_ID, COL1, COL2, SYSTEM_MODSTAMP) VALUES(?, ?, ?, ?, ?, ?, ?)", tenantViewName);
                String NON_MULTI_TENANT_VIEW_WO_PK = String.format("UPSERT INTO %s(OID, ID1, ID2, ID3, ROW_ID, COL1, COL2, SYSTEM_MODSTAMP) VALUES(?, ?, ?, ?, ?, ?, ?, ?)", tenantViewName);
                String NON_MULTI_TENANT_VIEW_WITH_PK = String.format("UPSERT INTO %s(OID, ROW_ID, ZID, COL1, COL2, COL3, SYSTEM_MODSTAMP) VALUES(?, ?, ?, ?, ?, ?, ?)", tenantViewName);
                if (isMultiTenant) {
                    if (extendPK) {
                        try (PreparedStatement pstmt = tenantConnection.prepareStatement(TENANT_VIEW_WITH_PK);){
                            pstmt.setObject(1, rid);
                            pstmt.setObject(2, zid);
                            pstmt.setObject(3, col1);
                            pstmt.setObject(4, col2);
                            pstmt.setObject(5, col3);
                            pstmt.setObject(6, new Date(System.currentTimeMillis()));
                            pstmt.execute();
                            break block65;
                        }
                    }
                    pk1 = this.getData(pkTypes[0]);
                    pk2 = this.getData(pkTypes[1]);
                    pk3 = this.getData(pkTypes[2]);
                    try (PreparedStatement pstmt = tenantConnection.prepareStatement(TENANT_VIEW_WO_PK);){
                        pstmt.setObject(1, pk1);
                        pstmt.setObject(2, pk2);
                        pstmt.setObject(3, pk3);
                        pstmt.setObject(4, rid);
                        pstmt.setObject(5, col1);
                        pstmt.setObject(6, col2);
                        pstmt.setObject(7, new Date(System.currentTimeMillis()));
                        pstmt.execute();
                        break block65;
                    }
                }
                if (extendPK) {
                    try (PreparedStatement pstmt = tenantConnection.prepareStatement(NON_MULTI_TENANT_VIEW_WITH_PK);){
                        pstmt.setObject(1, tenantId);
                        pstmt.setObject(2, rid);
                        pstmt.setObject(3, zid);
                        pstmt.setObject(4, col1);
                        pstmt.setObject(5, col2);
                        pstmt.setObject(6, col3);
                        pstmt.setObject(7, new Date(System.currentTimeMillis()));
                        pstmt.execute();
                        break block65;
                    }
                }
                pk1 = this.getData(pkTypes[0]);
                pk2 = this.getData(pkTypes[1]);
                pk3 = this.getData(pkTypes[2]);
                try (PreparedStatement pstmt = tenantConnection.prepareStatement(NON_MULTI_TENANT_VIEW_WO_PK);){
                    pstmt.setObject(1, tenantId);
                    pstmt.setObject(2, pk1);
                    pstmt.setObject(3, pk2);
                    pstmt.setObject(4, pk3);
                    pstmt.setObject(5, rid);
                    pstmt.setObject(6, col1);
                    pstmt.setObject(7, col2);
                    pstmt.setObject(8, new Date(System.currentTimeMillis()));
                    pstmt.execute();
                }
            }
            catch (Throwable throwable) {
                LOGGER.debug(String.format("Upsert values tenantId = %s, pk1 = %s, pk2 = %s, pk3 = %s, rid = %s, col1 = %s, col2 = %s", tenantId, pk1, pk2, pk3, rid, col1, col2));
                throw throwable;
            }
        }
        LOGGER.debug(String.format("Upsert values tenantId = %s, pk1 = %s, pk2 = %s, pk3 = %s, rid = %s, col1 = %s, col2 = %s", tenantId, pk1, pk2, pk3, rid, col1, col2));
    }

    private Pair<String, byte[]> getRowKeyMatchersFromView(PhoenixConnection connection, String viewName) throws SQLException {
        PName tenantId = connection.getTenantId();
        PTable view = PhoenixRuntime.getTable((Connection)connection, (String)viewName);
        String tenantViewKey = String.format("%s.%s", tenantId, viewName);
        byte[] rowKeyMatcher = view.getRowKeyMatcher();
        return new Pair((Object)tenantViewKey, (Object)rowKeyMatcher);
    }

    byte[] getRowKeyMatcherFromSyscatIndex(String tenantId, String schemaName, String tableName, boolean useIndexTable) throws SQLException {
        String SYS_CATALOG_ROW_KEY_MATCHER_HEADER_SQL = "SELECT ROW_KEY_MATCHER FROM SYSTEM.CATALOG WHERE %s AND TABLE_SCHEM <> 'SYSTEM' AND TABLE_NAME = '%s' AND  ROW_KEY_MATCHER IS NOT NULL";
        String SYS_CATALOG_IDX_ROW_KEY_MATCHER_HEADER_SQL = "SELECT \"0:ROW_KEY_MATCHER\" FROM SYSTEM.SYS_ROW_KEY_MATCHER_IDX WHERE %s AND \":TABLE_SCHEM\" = '%s' AND \":TABLE_NAME\" = '%s'";
        try (Connection connection = DriverManager.getConnection(BaseRowKeyMatcherTestIT.getUrl());){
            Statement stmt = connection.createStatement();
            String tenantClause = useIndexTable ? (tenantId == null || tenantId.isEmpty() ? "\":TENANT_ID\" IS NULL" : String.format("\":TENANT_ID\" = '%s'", tenantId)) : (tenantId == null || tenantId.isEmpty() ? "TENANT_ID IS NULL" : String.format("TENANT_ID = '%s'", tenantId));
            String sql = useIndexTable ? String.format("SELECT \"0:ROW_KEY_MATCHER\" FROM SYSTEM.SYS_ROW_KEY_MATCHER_IDX WHERE %s AND \":TABLE_SCHEM\" = '%s' AND \":TABLE_NAME\" = '%s'", tenantClause, schemaName, tableName) : String.format("SELECT ROW_KEY_MATCHER FROM SYSTEM.CATALOG WHERE %s AND TABLE_SCHEM <> 'SYSTEM' AND TABLE_NAME = '%s' AND  ROW_KEY_MATCHER IS NOT NULL", tenantClause, tableName);
            stmt.execute(sql);
            ResultSet rs = stmt.getResultSet();
            byte[] matcherBytes = rs.next() ? rs.getBytes(1) : ByteUtil.EMPTY_BYTE_ARRAY;
            LOGGER.info("Row key matcher SQL: {}", (Object)sql);
            LOGGER.info("Row key matcher: {}, {}", (Object)Bytes.toStringBinary((byte[])matcherBytes), (Object)Bytes.toStringBinary((byte[])PVarbinaryEncoded.INSTANCE.toBytes((Object)matcherBytes)));
            byte[] byArray = PVarbinaryEncoded.INSTANCE.toBytes((Object)matcherBytes);
            return byArray;
        }
    }

    private Pair<String, byte[]> getRowKeyMatchersFromView(PhoenixConnection connection, PTable view) throws SQLException {
        return this.getRowKeyMatchersFromView(connection, view.getName().getString());
    }

    private byte[] assertRowKeyMatcherForView(PhoenixConnection connection, PTable view, Pair<String, byte[]> rowKeyInfo) throws SQLException {
        String viewStatement = view.getViewStatement();
        SelectStatement viewSelectStatement = new SQLParser(viewStatement).parseQuery();
        PhoenixPreparedStatement preparedViewStatement = connection.prepareStatement(viewStatement).unwrap(PhoenixPreparedStatement.class);
        ColumnResolver resolver = FromCompiler.getResolverForQuery((SelectStatement)viewSelectStatement, (PhoenixConnection)connection);
        StatementContext viewStatementContext = new StatementContext((PhoenixStatement)preparedViewStatement, resolver);
        PTable viewStatementTable = viewStatementContext.getCurrentTable().getTable();
        int nColumns = viewStatementTable.getColumns().size();
        BitSet isViewColumnReferencedToBe = new BitSet(nColumns);
        CreateTableCompiler.ColumnTrackingExpressionCompiler expressionCompiler = new CreateTableCompiler.ColumnTrackingExpressionCompiler(viewStatementContext, isViewColumnReferencedToBe);
        ParseNode whereNode = viewSelectStatement.getWhere();
        Expression whereExpression = (Expression)whereNode.accept((ParseNodeVisitor)expressionCompiler);
        byte[][] viewColumnConstantsToBe = new byte[nColumns][];
        CreateTableCompiler.ViewWhereExpressionVisitor visitor = new CreateTableCompiler.ViewWhereExpressionVisitor(viewStatementTable, (byte[][])viewColumnConstantsToBe);
        whereExpression.accept((ExpressionVisitor)visitor);
        TableName tableName = TableName.createNormalized((String)view.getSchemaName().getString(), (String)view.getTableName().getString());
        byte[] rowKeyMatcher1 = PVarbinaryEncoded.INSTANCE.toBytes((Object)WhereOptimizer.getRowKeyMatcher((StatementContext)viewStatementContext, (TableName)tableName, (PTable)viewStatementTable, (Expression)whereExpression));
        byte[] rowKeyMatcher2 = PVarbinaryEncoded.INSTANCE.toBytes((Object)WhereOptimizer.getRowKeyMatcher((PhoenixConnection)connection, (TableName)tableName, (PTable)viewStatementTable, (byte[][])viewColumnConstantsToBe, (BitSet)isViewColumnReferencedToBe));
        byte[] rowKeyMatcher3 = this.getRowKeyMatcherFromSyscatIndex(view.getTenantId() != null ? view.getTenantId().getString() : null, view.getSchemaName().getString(), view.getTableName().getString(), false);
        byte[] rowKeyMatcher4 = this.getRowKeyMatcherFromSyscatIndex(view.getTenantId() != null ? view.getTenantId().getString() : null, view.getSchemaName().getString(), view.getTableName().getString(), true);
        LOGGER.debug(String.format("target-view-name = %s, physical = %s, stmt-table = %s\n, row-matcher-0 = %s (syscat)\n, row-matcher-1 = %s\n, row-matcher-2 = %s\n", view.getName().getString(), viewStatementTable.getPhysicalName().getString(), viewStatementTable.getName().getString(), Bytes.toStringBinary((byte[])((byte[])rowKeyInfo.getSecond())), Bytes.toStringBinary((byte[])rowKeyMatcher1), Bytes.toStringBinary((byte[])rowKeyMatcher2)));
        Assert.assertTrue((String)"RowKey matcher pattern do not match", (Bytes.compareTo((byte[])((byte[])rowKeyInfo.getSecond()), (byte[])rowKeyMatcher1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"RowKey matcher patterns do not match", (Bytes.compareTo((byte[])((byte[])rowKeyInfo.getSecond()), (byte[])rowKeyMatcher2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"RowKey matcher patterns do not match", (Bytes.compareTo((byte[])((byte[])rowKeyInfo.getSecond()), (byte[])rowKeyMatcher3) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"RowKey matcher patterns do not match", (Bytes.compareTo((byte[])((byte[])rowKeyInfo.getSecond()), (byte[])rowKeyMatcher4) == 0 ? 1 : 0) != 0);
        return rowKeyMatcher1;
    }

    private Map<String, byte[]> assertRowKeyMatchersForTable(String url, String parentSchemaName, String parentTableName) {
        HashMap viewToRowKeyMap = Maps.newHashMap();
        Properties tenantProps = PropertiesUtil.deepCopy((Properties)new Properties());
        try (Connection globalConnection = DriverManager.getConnection(url);){
            ConnectionQueryServices cqs = globalConnection.unwrap(PhoenixConnection.class).getQueryServices();
            try (Table childLinkTable = cqs.getTable(SchemaUtil.getPhysicalName((byte[])PhoenixDatabaseMetaData.SYSTEM_LINK_HBASE_TABLE_NAME.toBytes(), (ReadOnlyProps)cqs.getProps()).getName());){
                Pair allDescendants = ViewUtil.findAllDescendantViews((Table)childLinkTable, (Configuration)cqs.getConfiguration(), (byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])parentSchemaName.getBytes(), (byte[])parentTableName.getBytes(), (long)Long.MAX_VALUE, (boolean)false, (boolean)true);
                for (PTable view : (List)allDescendants.getFirst()) {
                    PName tenantId = view.getTenantId();
                    String viewName = view.getName().getString();
                    Connection stmtConnection = tenantId == null ? globalConnection : DriverManager.getConnection(String.format(TENANT_URL_FMT, url, "TenantId", tenantId.getString()), tenantProps);
                    Pair<String, byte[]> rowKeyInfo = this.getRowKeyMatchersFromView(stmtConnection.unwrap(PhoenixConnection.class), view);
                    this.assertRowKeyMatcherForView(stmtConnection.unwrap(PhoenixConnection.class), view, rowKeyInfo);
                    viewToRowKeyMap.put(rowKeyInfo.getFirst(), rowKeyInfo.getSecond());
                }
            }
        }
        catch (IOException | SQLException e) {
            LOGGER.info(e.getMessage());
            Assert.fail();
        }
        return viewToRowKeyMap;
    }

    private String getWhereClause(String[] pkNames, PDataType[] testPKTypes) {
        StringBuilder builder = new StringBuilder("WHERE ");
        Random rnd = new Random();
        block10: for (int b = 0; b < testPKTypes.length; ++b) {
            if (b > 0) {
                builder.append(" AND ");
            }
            switch (testPKTypes[b].getSqlType()) {
                case 12: {
                    builder.append(pkNames[b]).append(" = ").append("'").append(RandomStringUtils.randomAlphanumeric((int)25)).append("'");
                    continue block10;
                }
                case 1: {
                    builder.append(pkNames[b]).append(" = ").append("'").append(RandomStringUtils.randomAlphanumeric((int)15)).append("'");
                    continue block10;
                }
                case 3: {
                    builder.append(pkNames[b]).append(" = ").append(rnd.nextDouble());
                    continue block10;
                }
                case 4: {
                    builder.append(pkNames[b]).append(" = ").append(rnd.nextInt(500000));
                    continue block10;
                }
                case -5: {
                    builder.append(pkNames[b]).append(" = ").append(rnd.nextLong());
                    continue block10;
                }
                case 91: {
                    builder.append(pkNames[b]).append(" = ").append(" TO_DATE('2022-03-21T15:03:57+00:00') ");
                    continue block10;
                }
                case 93: {
                    builder.append(pkNames[b]).append(" = ").append(" TO_TIMESTAMP('2019-10-27T16:17:57+00:00') ");
                    continue block10;
                }
                case -3: 
                case 9000: {
                    byte[] varBytes = ByteUtil.concat((byte[])RandomStringUtils.randomAlphanumeric((int)25).getBytes(), (byte[][])new byte[][]{Bytes.toBytes((int)rnd.nextInt(50000)), Bytes.toBytes((double)Math.floor((double)rnd.nextInt(50000) * rnd.nextDouble()))});
                    builder.append(pkNames[b]).append(" = ").append(PVarbinary.INSTANCE.toStringLiteral((Object)varBytes));
                    continue block10;
                }
                default: {
                    builder.append(pkNames[b]).append("=").append("'").append(RandomStringUtils.randomAlphanumeric((int)15)).append("'");
                }
            }
        }
        return builder.toString();
    }

    private void assertHBaseRowKeyMatchesPrefix(PhoenixConnection connection, byte[] hbaseTableName, int rowId, byte[] prefix) throws IOException, SQLException {
        byte[] rowkey = ByteUtil.EMPTY_BYTE_ARRAY;
        String rid = String.format(ROW_ID_FMT, rowId);
        try (Table tbl = connection.getQueryServices().getTable(hbaseTableName);){
            PName tenantId = connection.getTenantId();
            Scan allRows = new Scan();
            FilterList andFilter = new FilterList(new Filter[0]);
            andFilter.addFilter((Filter)new RowFilter(CompareOperator.EQUAL, (ByteArrayComparable)new SubstringComparator(rid)));
            allRows.setFilter((Filter)andFilter);
            ResultScanner scanner = tbl.getScanner(allRows);
            int numMatchingRows = 0;
            Result result = scanner.next();
            while (result != null) {
                rowkey = result.getRow();
                ++numMatchingRows;
                result = scanner.next();
            }
            PrefixFilter matchFilter = new PrefixFilter(prefix);
            LOGGER.debug(String.format("row-key = %s, tenantId = %s, prefix = %s, matched = %s", Bytes.toStringBinary((byte[])rowkey), tenantId, Bytes.toStringBinary((byte[])prefix), !matchFilter.filterRowKey((Cell)KeyValueUtil.createFirstOnRow((byte[])rowkey))));
            Assert.assertEquals((String)String.format("Expected rows do match for table = %s, rowId = %s", Bytes.toString((byte[])hbaseTableName), rid), (long)1L, (long)numMatchingRows);
        }
    }

    private void assertIndexTableRowKeyMatchesPrefix(PhoenixConnection connection, PTable viewIndex, byte[] hbaseIndexTableName, int rowId) throws IOException, SQLException {
        byte[] rowkey = ByteUtil.EMPTY_BYTE_ARRAY;
        String rid = String.format(ROW_ID_FMT, rowId);
        try (Table tbl = connection.getQueryServices().getTable(hbaseIndexTableName);){
            Scan allRows = new Scan();
            FilterList andFilter = new FilterList(new Filter[0]);
            andFilter.addFilter((Filter)new RowFilter(CompareOperator.EQUAL, (ByteArrayComparable)new SubstringComparator(rid)));
            allRows.setFilter((Filter)andFilter);
            ResultScanner scanner = tbl.getScanner(allRows);
            int numMatchingRows = 0;
            Result result = scanner.next();
            while (result != null) {
                PColumn viewIndexIdPKColumn = (PColumn)viewIndex.getPKColumns().get(0);
                RowKeyColumnExpression viewIndexIdColExpr = new RowKeyColumnExpression((PDatum)viewIndexIdPKColumn, new RowKeyValueAccessor(viewIndex.getPKColumns(), 0));
                ImmutableBytesWritable ptr = new ImmutableBytesWritable();
                viewIndexIdColExpr.evaluate((Tuple)new ResultTuple(result), ptr);
                long actualViewIndexID = this.hasLongViewIndexEnabled() ? PLong.INSTANCE.getCodec().decodeLong(ptr, SortOrder.ASC) : (long)PSmallint.INSTANCE.getCodec().decodeShort(ptr, SortOrder.ASC);
                Assert.assertTrue((String)"ViewIndexId's not match", (viewIndex.getViewIndexId() == actualViewIndexID ? 1 : 0) != 0);
                rowkey = result.getRow();
                ++numMatchingRows;
                result = scanner.next();
            }
            Assert.assertEquals((String)String.format("Expected rows do match for index table = %s, row-key = %s, rowId = %s", Bytes.toString((byte[])hbaseIndexTableName), Bytes.toStringBinary((byte[])rowkey), rowId), (long)1L, (long)numMatchingRows);
        }
    }

    protected abstract boolean hasLongViewIndexEnabled();

    private SortOrder[][] getSortOrders() {
        SortOrder[][] sortOrders = new SortOrder[][]{{SortOrder.ASC, SortOrder.ASC, SortOrder.ASC}, {SortOrder.ASC, SortOrder.ASC, SortOrder.DESC}, {SortOrder.ASC, SortOrder.DESC, SortOrder.ASC}, {SortOrder.ASC, SortOrder.DESC, SortOrder.DESC}, {SortOrder.DESC, SortOrder.ASC, SortOrder.ASC}, {SortOrder.DESC, SortOrder.ASC, SortOrder.DESC}, {SortOrder.DESC, SortOrder.DESC, SortOrder.ASC}, {SortOrder.DESC, SortOrder.DESC, SortOrder.DESC}};
        return sortOrders;
    }

    private List<PDataType[]> getTestCases() {
        ArrayList<PDataType[]> testCases = new ArrayList<PDataType[]>();
        testCases.add(new PDataType[]{PInteger.INSTANCE, PInteger.INSTANCE, PInteger.INSTANCE});
        testCases.add(new PDataType[]{PLong.INSTANCE, PLong.INSTANCE, PLong.INSTANCE});
        testCases.add(new PDataType[]{PTimestamp.INSTANCE, PTimestamp.INSTANCE, PTimestamp.INSTANCE});
        testCases.add(new PDataType[]{PChar.INSTANCE, PChar.INSTANCE, PChar.INSTANCE});
        testCases.add(new PDataType[]{PDecimal.INSTANCE, PDecimal.INSTANCE, PInteger.INSTANCE});
        testCases.add(new PDataType[]{PDate.INSTANCE, PDate.INSTANCE, PDate.INSTANCE});
        testCases.add(new PDataType[]{PVarchar.INSTANCE, PVarchar.INSTANCE, PInteger.INSTANCE});
        testCases.add(new PDataType[]{PVarbinaryEncoded.INSTANCE, PVarchar.INSTANCE, PVarbinaryEncoded.INSTANCE});
        return testCases;
    }

    @Test
    public void testViewsWithExtendedPK() {
        try {
            List<PDataType[]> testCases = this.getTestCases();
            SortOrder[][] sortOrders = this.getSortOrders();
            String tableName = "";
            tableName = this.createViewHierarchy(testCases, sortOrders, 500, 5000, 3, true, true, false);
            this.assertRowKeyMatchersForTable(BaseRowKeyMatcherTestIT.getUrl(), SchemaUtil.getSchemaNameFromFullName((String)tableName), SchemaUtil.getTableNameFromFullName((String)tableName));
            tableName = this.createViewHierarchy(testCases, sortOrders, 600, 6000, 3, false, true, false);
            this.assertRowKeyMatchersForTable(BaseRowKeyMatcherTestIT.getUrl(), SchemaUtil.getSchemaNameFromFullName((String)tableName), SchemaUtil.getTableNameFromFullName((String)tableName));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
    }

    @Test
    public void testViewsWithVariousTenantIdTypes() {
        try {
            ArrayList<PDataType[]> testCases = new ArrayList<PDataType[]>();
            testCases.add(new PDataType[]{PInteger.INSTANCE, PInteger.INSTANCE, PInteger.INSTANCE});
            SortOrder[][] sortOrders = new SortOrder[][]{{SortOrder.ASC, SortOrder.ASC, SortOrder.ASC}};
            String tableName = "";
            tableName = this.createViewHierarchy((PDataType)PInteger.INSTANCE, testCases, sortOrders, 700, 7000, 3, true, true, false);
            this.assertRowKeyMatchersForTable(BaseRowKeyMatcherTestIT.getUrl(), SchemaUtil.getSchemaNameFromFullName((String)tableName), SchemaUtil.getTableNameFromFullName((String)tableName));
            this.assertRowKeyMatchersForTable(BaseRowKeyMatcherTestIT.getUrl(), SchemaUtil.getSchemaNameFromFullName((String)tableName), SchemaUtil.getTableNameFromFullName((String)tableName));
            tableName = this.createViewHierarchy((PDataType)PLong.INSTANCE, testCases, sortOrders, 710, 7100, 3, true, true, false);
            this.assertRowKeyMatchersForTable(BaseRowKeyMatcherTestIT.getUrl(), SchemaUtil.getSchemaNameFromFullName((String)tableName), SchemaUtil.getTableNameFromFullName((String)tableName));
            this.assertRowKeyMatchersForTable(BaseRowKeyMatcherTestIT.getUrl(), SchemaUtil.getSchemaNameFromFullName((String)tableName), SchemaUtil.getTableNameFromFullName((String)tableName));
            tableName = this.createViewHierarchy((PDataType)PSmallint.INSTANCE, testCases, sortOrders, 720, 7200, 3, true, true, false);
            this.assertRowKeyMatchersForTable(BaseRowKeyMatcherTestIT.getUrl(), SchemaUtil.getSchemaNameFromFullName((String)tableName), SchemaUtil.getTableNameFromFullName((String)tableName));
            this.assertRowKeyMatchersForTable(BaseRowKeyMatcherTestIT.getUrl(), SchemaUtil.getSchemaNameFromFullName((String)tableName), SchemaUtil.getTableNameFromFullName((String)tableName));
            tableName = this.createViewHierarchy((PDataType)PTinyint.INSTANCE, testCases, sortOrders, 730, 7300, 3, true, true, false);
            this.assertRowKeyMatchersForTable(BaseRowKeyMatcherTestIT.getUrl(), SchemaUtil.getSchemaNameFromFullName((String)tableName), SchemaUtil.getTableNameFromFullName((String)tableName));
            this.assertRowKeyMatchersForTable(BaseRowKeyMatcherTestIT.getUrl(), SchemaUtil.getSchemaNameFromFullName((String)tableName), SchemaUtil.getTableNameFromFullName((String)tableName));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
    }

    @Test
    public void testViewsWithoutExtendedPK() {
        try {
            List<PDataType[]> testCases = this.getTestCases();
            SortOrder[][] sortOrders = this.getSortOrders();
            String tableName = "";
            tableName = this.createViewHierarchy(testCases, sortOrders, 100, 1000, 3, true, false, false);
            this.assertRowKeyMatchersForTable(BaseRowKeyMatcherTestIT.getUrl(), SchemaUtil.getSchemaNameFromFullName((String)tableName), SchemaUtil.getTableNameFromFullName((String)tableName));
            tableName = this.createViewHierarchy(testCases, sortOrders, 200, 2000, 3, false, false, false);
            this.assertRowKeyMatchersForTable(BaseRowKeyMatcherTestIT.getUrl(), SchemaUtil.getSchemaNameFromFullName((String)tableName), SchemaUtil.getTableNameFromFullName((String)tableName));
            tableName = this.createViewHierarchy(testCases, sortOrders, 300, 3000, 3, true, false, true);
            this.assertRowKeyMatchersForTable(BaseRowKeyMatcherTestIT.getUrl(), SchemaUtil.getSchemaNameFromFullName((String)tableName), SchemaUtil.getTableNameFromFullName((String)tableName));
            tableName = this.createViewHierarchy(testCases, sortOrders, 400, 4000, 3, false, false, true);
            this.assertRowKeyMatchersForTable(BaseRowKeyMatcherTestIT.getUrl(), SchemaUtil.getSchemaNameFromFullName((String)tableName), SchemaUtil.getTableNameFromFullName((String)tableName));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
    }

    @Test
    public void testNonMultiTenantExtendedViewsWithViewIndexesFail() {
        try {
            ArrayList<PDataType[]> testCases = new ArrayList<PDataType[]>();
            testCases.add(new PDataType[]{PInteger.INSTANCE, PInteger.INSTANCE, PInteger.INSTANCE});
            SortOrder[][] sortOrders = new SortOrder[][]{{SortOrder.ASC, SortOrder.ASC, SortOrder.ASC}};
            this.createViewHierarchy(testCases, sortOrders, 900, 9000, 3, false, true, true);
            Assert.fail();
        }
        catch (SQLException sqle) {
            Assert.assertEquals((long)SQLExceptionCode.VIEW_CANNOT_EXTEND_PK_WITH_PARENT_INDEXES.getErrorCode(), (long)sqle.getErrorCode());
        }
        catch (Exception e) {
            Assert.fail((String)("SQLException expected: " + SQLExceptionCode.VIEW_CANNOT_EXTEND_PK_WITH_PARENT_INDEXES));
        }
    }

    @Test
    public void testMultiTenantExtendedViewsWithViewIndexesFail() {
        try {
            ArrayList<PDataType[]> testCases = new ArrayList<PDataType[]>();
            testCases.add(new PDataType[]{PInteger.INSTANCE, PInteger.INSTANCE, PInteger.INSTANCE});
            SortOrder[][] sortOrders = new SortOrder[][]{{SortOrder.ASC, SortOrder.ASC, SortOrder.ASC}};
            String tableName = "";
            tableName = this.createViewHierarchy(testCases, sortOrders, 910, 9100, 3, true, true, true);
            this.assertRowKeyMatchersForTable(BaseRowKeyMatcherTestIT.getUrl(), SchemaUtil.getSchemaNameFromFullName((String)tableName), SchemaUtil.getTableNameFromFullName((String)tableName));
            Assert.fail();
        }
        catch (SQLException sqle) {
            Assert.assertEquals((long)SQLExceptionCode.VIEW_CANNOT_EXTEND_PK_WITH_PARENT_INDEXES.getErrorCode(), (long)sqle.getErrorCode());
        }
        catch (Exception e) {
            Assert.fail((String)("SQLException expected: " + SQLExceptionCode.VIEW_CANNOT_EXTEND_PK_WITH_PARENT_INDEXES));
        }
    }

    private String createViewHierarchy(List<PDataType[]> testCases, SortOrder[][] sortOrders, int startPartition, int startRowId, int numTenants, boolean isMultiTenant, boolean extendPK, boolean hasGlobalViewIndexes) throws Exception {
        return this.createViewHierarchy((PDataType)PChar.INSTANCE, testCases, sortOrders, startPartition, startRowId, numTenants, isMultiTenant, extendPK, hasGlobalViewIndexes);
    }

    private String createViewHierarchy(PDataType tenantIdType, List<PDataType[]> testCases, SortOrder[][] sortOrders, int startPartition, int startRowId, int numTenants, boolean isMultiTenant, boolean extendPK, boolean hasGlobalViewIndexes) throws Exception {
        int tenant;
        int testCase;
        HashMap actualViewToRowKeyMap = Maps.newHashMap();
        String tableName = BaseTest.generateUniqueName();
        this.createBaseTable(tableName, isMultiTenant, tenantIdType);
        String baseTableName = String.format(BASE_TABLE_NAME_FMT, tableName);
        String indexTableName = String.format(INDEX_TABLE_NAME_FMT, tableName);
        int partition = startPartition;
        int rowId = startRowId;
        for (int testCase2 = 0; testCase2 < testCases.size(); ++testCase2) {
            for (int index = 0; index < sortOrders.length; ++index) {
                Pair<String, byte[]> gvRowKeyInfo = this.createGlobalView(tableName, ++partition, testCases.get(testCase2), sortOrders[index], hasGlobalViewIndexes);
                actualViewToRowKeyMap.put(gvRowKeyInfo.getFirst(), gvRowKeyInfo.getSecond());
                LOGGER.debug(String.format("Created global view %s with partition = %d", gvRowKeyInfo.getFirst(), partition));
            }
        }
        partition = startPartition;
        String[] globalViewPKNames = new String[]{"ID1", "ID2", "ID3"};
        for (testCase = 0; testCase < testCases.size(); ++testCase) {
            for (int index = 0; index < sortOrders.length; ++index) {
                ++partition;
                for (tenant = 1; tenant <= numTenants; ++tenant) {
                    Pair<String, byte[]> tvRowKeyInfo = this.createTenantView(extendPK, partition, tenantIdType, tenant, 1, globalViewPKNames, testCases.get(testCase));
                    actualViewToRowKeyMap.put(tvRowKeyInfo.getFirst(), tvRowKeyInfo.getSecond());
                    LOGGER.debug(String.format("Created tenant view %s [partition = %d]", tvRowKeyInfo.getFirst(), partition));
                }
            }
        }
        partition = startPartition;
        for (testCase = 0; testCase < testCases.size(); ++testCase) {
            for (int index = 0; index < sortOrders.length; ++index) {
                ++partition;
                for (tenant = 1; tenant <= numTenants; ++tenant) {
                    ++rowId;
                    try {
                        this.upsertTenantViewRows(isMultiTenant, extendPK, partition, tenantIdType, tenant, 1, rowId, globalViewPKNames, testCases.get(testCase));
                        continue;
                    }
                    catch (Exception ex) {
                        String testInfo = Arrays.stream((Object[])testCases.get(testCase)).map(String::valueOf).collect(Collectors.joining(","));
                        String sortInfo = Arrays.stream(sortOrders[index]).map(String::valueOf).collect(Collectors.joining(","));
                        String pkInfo = Arrays.stream(globalViewPKNames).map(String::valueOf).collect(Collectors.joining(","));
                        LOGGER.error(ex.getMessage());
                        ex.printStackTrace();
                        Assert.fail((String)String.format("isMultiTenant(%s), extendPK(%s), partition(%d), tenant(%s), rowId(%s), pkInfo(%s), testInfo(%s), sortInfo(%s)", isMultiTenant, extendPK, partition, tenant, rowId, pkInfo, testInfo, sortInfo));
                    }
                }
            }
        }
        partition = startPartition;
        rowId = startRowId;
        for (testCase = 0; testCase < testCases.size(); ++testCase) {
            for (int index = 0; index < sortOrders.length; ++index) {
                ++partition;
                for (tenant = 1; tenant <= numTenants; ++tenant) {
                    ++rowId;
                    String partitionName = String.format(PARTITION_FMT, partition);
                    String tenantId = "";
                    tenantId = tenantIdType.getSqlType() == 12 || tenantIdType.getSqlType() == 1 ? String.format(ORG_ID_FMT, ORG_ID_PREFIX, tenant) : String.format("%015d", tenant);
                    String tenantConnectionUrl = String.format(TENANT_URL_FMT, BaseRowKeyMatcherTestIT.getUrl(), "TenantId", tenantId);
                    String tenantViewName = String.format(TENANT_VIEW_NAME_FMT, partitionName, 1);
                    String tenantViewKey = String.format("%s.%s", tenantId, tenantViewName);
                    try (PhoenixConnection tenantConnection = DriverManager.getConnection(tenantConnectionUrl).unwrap(PhoenixConnection.class);){
                        this.assertHBaseRowKeyMatchesPrefix(tenantConnection, baseTableName.getBytes(StandardCharsets.UTF_8), rowId, (byte[])actualViewToRowKeyMap.get(tenantViewKey));
                        if (!hasGlobalViewIndexes) continue;
                        PTable view = PhoenixRuntime.getTable((Connection)tenantConnection, (String)tenantViewName);
                        this.assertIndexTableRowKeyMatchesPrefix(tenantConnection, (PTable)view.getIndexes().get(0), indexTableName.getBytes(StandardCharsets.UTF_8), rowId);
                        continue;
                    }
                }
            }
        }
        return baseTableName;
    }
}

