/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.SQLTimeoutException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public abstract class BaseQueryIT
extends ParallelStatsDisabledIT {
    protected static final String tenantId = BaseQueryIT.getOrganizationId();
    protected static final String NO_INDEX = "";
    protected static final String[] GLOBAL_INDEX_DDLS = new String[]{"CREATE INDEX IF NOT EXISTS %s ON %s (a_integer DESC) INCLUDE (    A_STRING,     B_STRING,     A_DATE)", "CREATE INDEX IF NOT EXISTS %s ON %s (a_integer, a_string) INCLUDE (    B_STRING,     A_DATE)", "CREATE INDEX IF NOT EXISTS %s ON %s (a_integer) INCLUDE (    A_STRING,     B_STRING,     A_DATE)", ""};
    protected static final String[] LOCAL_INDEX_DDLS = new String[]{"CREATE LOCAL INDEX %s ON %s (a_integer DESC) INCLUDE (    A_STRING,     B_STRING,     A_DATE)", "CREATE LOCAL INDEX %s ON %s (a_integer, a_string) INCLUDE (    B_STRING,     A_DATE)", "CREATE LOCAL INDEX %s ON %s (a_integer) INCLUDE (    A_STRING,     B_STRING,     A_DATE)"};
    private static final String[] INDEX_DDLS = new String[GLOBAL_INDEX_DDLS.length + LOCAL_INDEX_DDLS.length];
    protected static Date date;
    protected static String tableName;
    protected static String indexName;
    private static final Logger LOGGER;

    @Parameterized.BeforeParam
    public static synchronized void initTables(String idxDdl, boolean columnEncoded, boolean keepDeletedCells) throws Exception {
        StringBuilder optionBuilder = new StringBuilder();
        if (!columnEncoded) {
            optionBuilder.append("COLUMN_ENCODED_BYTES=0");
        }
        if (keepDeletedCells) {
            if (optionBuilder.length() > 0) {
                optionBuilder.append(",");
            }
            optionBuilder.append("KEEP_DELETED_CELLS=true");
        }
        String tableDDLOptions = optionBuilder.toString();
        try {
            date = new Date(System.currentTimeMillis());
            tableName = BaseQueryIT.initATableValues(BaseQueryIT.generateUniqueName(), tenantId, BaseQueryIT.getDefaultSplits(tenantId), date, null, BaseQueryIT.getUrl(), tableDDLOptions);
        }
        catch (Exception e) {
            LOGGER.error("Exception when creating aTable ", (Throwable)e);
            throw e;
        }
        indexName = BaseQueryIT.generateUniqueName();
        if (idxDdl.length() > 0) {
            String indexDDL = String.format(idxDdl, indexName, tableName);
            Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
            props.setProperty("phoenix.query.timeoutMs", "30000");
            try (Connection conn = DriverManager.getConnection(BaseQueryIT.getUrl(), props);){
                conn.createStatement().execute(indexDDL);
            }
            catch (SQLTimeoutException e) {
                LOGGER.info("Query timed out. Retrying one more time.", (Throwable)e);
                try (Connection conn2 = DriverManager.getConnection(BaseQueryIT.getUrl(), props);){
                    conn2.createStatement().execute(indexDDL);
                }
                catch (Exception ex) {
                    LOGGER.error("Exception while creating index during second retry: " + indexDDL, (Throwable)ex);
                    throw ex;
                }
            }
            catch (Exception e) {
                LOGGER.error("Exception while creating index: " + indexDDL, (Throwable)e);
                throw e;
            }
        }
    }

    public BaseQueryIT(String idxDdl, boolean columnEncoded, boolean keepDeletedCells) {
    }

    public static Collection<Object> allIndexes() {
        ArrayList testCases = Lists.newArrayList();
        for (String indexDDL : INDEX_DDLS) {
            for (boolean columnEncoded : new boolean[]{false}) {
                testCases.add(new Object[]{indexDDL, columnEncoded, false});
            }
        }
        return testCases;
    }

    public static Collection<Object> allIndexesWithEncoded() {
        ArrayList testCases = Lists.newArrayList();
        for (String indexDDL : INDEX_DDLS) {
            for (boolean columnEncoded : new boolean[]{false, true}) {
                testCases.add(new Object[]{indexDDL, columnEncoded, false});
            }
        }
        return testCases;
    }

    public static Collection<Object> allIndexesWithEncodedAndKeepDeleted() {
        ArrayList testCases = Lists.newArrayList();
        for (String indexDDL : INDEX_DDLS) {
            for (boolean columnEncoded : new boolean[]{false, true}) {
                testCases.add(new Object[]{indexDDL, columnEncoded, true});
            }
        }
        return testCases;
    }

    static {
        int i = 0;
        for (String s : GLOBAL_INDEX_DDLS) {
            BaseQueryIT.INDEX_DDLS[i++] = s;
        }
        for (String s : LOCAL_INDEX_DDLS) {
            BaseQueryIT.INDEX_DDLS[i++] = s;
        }
        LOGGER = LoggerFactory.getLogger(BaseQueryIT.class);
    }
}

