/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.ReadOnlyProps;
import org.junit.BeforeClass;
import org.junit.runners.Parameterized;

public class BaseMutationBatchFailedStateMetricIT
extends ParallelStatsDisabledIT {
    String create_table = "CREATE TABLE IF NOT EXISTS %s(ID VARCHAR NOT NULL PRIMARY KEY, VAL1 INTEGER, VAL2 INTEGER)";
    String indexName = BaseMutationBatchFailedStateMetricIT.generateUniqueName();
    String create_index = "CREATE INDEX " + this.indexName + " ON %s(VAL1 DESC) INCLUDE (VAL2)";
    String upsertStatement = "UPSERT INTO %s VALUES(?, ?, ?)";
    String deleteTableName = BaseMutationBatchFailedStateMetricIT.generateUniqueName();
    private final boolean transactional;
    private String transactionProvider;

    public BaseMutationBatchFailedStateMetricIT(String transactionProvider) {
        boolean bl = this.transactional = transactionProvider != null;
        if (this.transactional) {
            this.create_table = this.create_table + (this.transactional ? " TRANSACTIONAL=true,TRANSACTION_PROVIDER='" + transactionProvider + "'" : "");
        }
        this.transactionProvider = transactionProvider;
        this.createTables();
        this.populateTables();
    }

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap serverProps = Maps.newHashMapWithExpectedSize((int)3);
        serverProps.put("hbase.coprocessor.abortonerror", "false");
        serverProps.put("com.saleforce.hbase.index.checkversion", "false");
        HashMap clientProps = Maps.newHashMapWithExpectedSize((int)2);
        clientProps.put("phoenix.query.request.metrics.enabled", String.valueOf(true));
        clientProps.put("phoenix.transactions.enabled", "true");
        BaseMutationBatchFailedStateMetricIT.setUpTestDriver(new ReadOnlyProps(serverProps.entrySet().iterator()), new ReadOnlyProps(clientProps.entrySet().iterator()));
    }

    @Parameterized.Parameters(name="MutationBatchFailedStateMetricWithAllDeleteIT_transactionProvider={0}")
    public static synchronized Collection<Object[]> data() {
        return Arrays.asList({"OMID"}, {null});
    }

    private void populateTables() {
        int NROWS = 5;
        try (Connection conn = DriverManager.getConnection(BaseMutationBatchFailedStateMetricIT.getUrl());){
            try (PreparedStatement dataPreparedStatement = conn.prepareStatement(String.format(this.upsertStatement, this.deleteTableName));){
                for (int i = 1; i <= 5; ++i) {
                    dataPreparedStatement.setString(1, "ROW_" + i);
                    dataPreparedStatement.setInt(2, i);
                    dataPreparedStatement.setInt(3, i * 2);
                    dataPreparedStatement.execute();
                }
            }
            conn.commit();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void createTables() {
        try (Connection con = DriverManager.getConnection(BaseMutationBatchFailedStateMetricIT.getUrl());){
            Statement stmt = con.createStatement();
            stmt.execute(String.format(this.create_table, this.deleteTableName));
            stmt.execute(String.format(this.create_index, this.deleteTableName));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

