/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.ParallelStatsDisabledWithRegionMovesIT;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.schema.types.PChar;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryBuilder;
import org.apache.phoenix.util.TestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class BaseAggregateWithRegionMoves2IT
extends ParallelStatsDisabledWithRegionMovesIT {
    @Before
    public void setUp() throws Exception {
        hasTestStarted = true;
    }

    @After
    public void tearDown() throws Exception {
        countOfDummyResults = 0;
        TABLE_NAMES.clear();
        hasTestStarted = false;
    }

    @Test
    public void testGroupByArray() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(BaseAggregateWithRegionMoves2IT.getUrl(), props);
        String tableName = BaseAggregateWithRegionMoves2IT.generateUniqueName();
        TABLE_NAMES.add(tableName);
        conn.createStatement().execute("CREATE TABLE " + tableName + "(\n  a VARCHAR NOT NULL,\n  b VARCHAR,\n  c INTEGER,\n  d VARCHAR,\n  e VARCHAR ARRAY,\n  f BIGINT,\n  g BIGINT,\n  CONSTRAINT pk PRIMARY KEY(a)\n)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('1', 'val', 100, 'a', ARRAY ['b'], 1, 2)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('2', 'val', 100, 'a', ARRAY ['b'], 3, 4)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('3', 'val', 100, 'a', ARRAY ['b','c'], 5, 6)");
        conn.commit();
        QueryBuilder queryBuilder = new QueryBuilder().setSelectExpression("C, SUM(F + G) AS SUMONE, D, E").setSelectExpressionColumns((List)Lists.newArrayList((Object[])new String[]{"A", "B", "C", "F", "G", "D", "E"})).setWhereClause("B = 'val' AND A IN ('1','2','3')").setFullTableName(tableName).setGroupByClause("C, D, E").setOrderByClause("SUMONE desc");
        ResultSet rs = this.executeQuery(conn, queryBuilder);
        Assert.assertTrue((boolean)rs.next());
        BaseAggregateWithRegionMoves2IT.moveRegionsOfTable(tableName);
        Assert.assertEquals((long)100L, (long)rs.getInt(1));
        Assert.assertEquals((long)11L, (long)rs.getLong(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)100L, (long)rs.getInt(1));
        Assert.assertEquals((long)10L, (long)rs.getLong(2));
        Assert.assertFalse((boolean)rs.next());
        conn.close();
    }

    @Test
    public void testGroupByOrderPreserving() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.put("phoenix.query.force.rowkeyorder", Boolean.FALSE.toString());
        Connection conn = DriverManager.getConnection(BaseAggregateWithRegionMoves2IT.getUrl(), props);
        String tableName = BaseAggregateWithRegionMoves2IT.generateUniqueName();
        TABLE_NAMES.add(tableName);
        conn.createStatement().execute("CREATE TABLE " + tableName + "(ORGANIZATION_ID char(15) not null, \nJOURNEY_ID char(15) not null, \nDATASOURCE SMALLINT not null, \nMATCH_STATUS TINYINT not null, \nEXTERNAL_DATASOURCE_KEY varchar(30), \nENTITY_ID char(15) not null, \nCONSTRAINT PK PRIMARY KEY (\n    ORGANIZATION_ID, \n    JOURNEY_ID, \n    DATASOURCE, \n    MATCH_STATUS,\n    EXTERNAL_DATASOURCE_KEY,\n    ENTITY_ID))");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('000001111122222', '333334444455555', 0, 0, 'abc', '666667777788888')");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('000001111122222', '333334444455555', 0, 0, 'abcd', '666667777788889')");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('000001111122222', '333334444455555', 0, 0, 'abc', '666667777788899')");
        conn.commit();
        QueryBuilder queryBuilder = new QueryBuilder().setSelectExpression("COUNT(1), EXTERNAL_DATASOURCE_KEY As DUP_COUNT").setSelectExpressionColumns((List)Lists.newArrayList((Object[])new String[]{"EXTERNAL_DATASOURCE_KEY", "MATCH_STATUS", "JOURNEY_ID", "DATASOURCE", "ORGANIZATION_ID"})).setWhereClause("JOURNEY_ID='333334444455555' AND DATASOURCE=0 AND MATCH_STATUS <= 1 and ORGANIZATION_ID='000001111122222'").setFullTableName(tableName).setGroupByClause("MATCH_STATUS, EXTERNAL_DATASOURCE_KEY").setHavingClause("COUNT(1) > 1");
        ResultSet rs = this.executeQuery(conn, queryBuilder);
        Assert.assertTrue((boolean)rs.next());
        BaseAggregateWithRegionMoves2IT.moveRegionsOfTable(tableName);
        Assert.assertEquals((long)2L, (long)rs.getLong(1));
        Assert.assertEquals((Object)"abc", (Object)rs.getString(2));
        Assert.assertFalse((boolean)rs.next());
        ExplainPlan plan = conn.prepareStatement(queryBuilder.build()).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
        ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
        Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
        Assert.assertEquals((Object)"RANGE SCAN ", (Object)explainPlanAttributes.getExplainScanType());
        Assert.assertEquals((Object)tableName, (Object)explainPlanAttributes.getTableName());
        Assert.assertEquals((Object)" ['000001111122222','333334444455555',0,*] - ['000001111122222','333334444455555',0,1]", (Object)explainPlanAttributes.getKeyRanges());
        Assert.assertEquals((Object)"SERVER FILTER BY FIRST KEY ONLY", (Object)explainPlanAttributes.getServerWhereFilter());
        Assert.assertEquals((Object)"SERVER AGGREGATE INTO ORDERED DISTINCT ROWS BY [MATCH_STATUS, EXTERNAL_DATASOURCE_KEY]", (Object)explainPlanAttributes.getServerAggregate());
        Assert.assertEquals((Object)"COUNT(1) > 1", (Object)explainPlanAttributes.getClientFilterBy());
    }

    @Test
    public void testGroupByOrderPreservingDescSort() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(BaseAggregateWithRegionMoves2IT.getUrl(), props);
        String tableName = BaseAggregateWithRegionMoves2IT.generateUniqueName();
        TABLE_NAMES.add(tableName);
        conn.createStatement().execute("DROP TABLE IF EXISTS " + tableName + " CASCADE");
        conn.createStatement().execute("CREATE TABLE " + tableName + " (k1 char(1) not null, k2 char(1) not null, constraint pk primary key (k1,k2)) split on ('ac','jc','nc')");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('a', 'a')");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('a', 'b')");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('a', 'c')");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('a', 'd')");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('j', 'a')");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('j', 'b')");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('j', 'c')");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('j', 'd')");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('n', 'a')");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('n', 'b')");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('n', 'c')");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('n', 'd')");
        conn.commit();
        QueryBuilder queryBuilder = new QueryBuilder().setSelectExpression("K1,COUNT(*)").setSelectColumns((List)Lists.newArrayList((Object[])new String[]{"K1"})).setFullTableName(tableName).setGroupByClause("K1").setOrderByClause("K1 DESC");
        ResultSet rs = this.executeQuery(conn, queryBuilder);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"n", (Object)rs.getString(1));
        Assert.assertEquals((long)4L, (long)rs.getLong(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"j", (Object)rs.getString(1));
        Assert.assertEquals((long)4L, (long)rs.getLong(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertEquals((long)4L, (long)rs.getLong(2));
        Assert.assertFalse((boolean)rs.next());
        ExplainPlan plan = conn.prepareStatement(queryBuilder.build()).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
        ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
        Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
        Assert.assertEquals((Object)"REVERSE", (Object)explainPlanAttributes.getClientSortedBy());
        Assert.assertEquals((Object)"FULL SCAN ", (Object)explainPlanAttributes.getExplainScanType());
        Assert.assertEquals((Object)tableName, (Object)explainPlanAttributes.getTableName());
        Assert.assertEquals((Object)"SERVER FILTER BY FIRST KEY ONLY", (Object)explainPlanAttributes.getServerWhereFilter());
        Assert.assertEquals((Object)"SERVER AGGREGATE INTO ORDERED DISTINCT ROWS BY [K1]", (Object)explainPlanAttributes.getServerAggregate());
    }

    @Test
    public void testSumGroupByOrderPreservingDesc() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(BaseAggregateWithRegionMoves2IT.getUrl(), props);
        String tableName = BaseAggregateWithRegionMoves2IT.generateUniqueName();
        TABLE_NAMES.add(tableName);
        PreparedStatement stmt = conn.prepareStatement("CREATE TABLE " + tableName + " (k1 char(1) not null, k2 integer not null, constraint pk primary key (k1,k2)) split on (?,?,?)");
        stmt.setBytes(1, ByteUtil.concat((byte[])PChar.INSTANCE.toBytes((Object)"a"), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)3)}));
        stmt.setBytes(2, ByteUtil.concat((byte[])PChar.INSTANCE.toBytes((Object)"j"), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)3)}));
        stmt.setBytes(3, ByteUtil.concat((byte[])PChar.INSTANCE.toBytes((Object)"n"), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)3)}));
        stmt.execute();
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('a', 1)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('a', 2)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('a', 3)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('a', 4)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('b', 5)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('j', 1)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('j', 2)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('j', 3)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('j', 4)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('n', 1)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('n', 2)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('n', 3)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('n', 4)");
        conn.commit();
        QueryBuilder queryBuilder = new QueryBuilder().setSelectExpression("K1,SUM(K2)").setSelectExpressionColumns((List)Lists.newArrayList((Object[])new String[]{"K1", "K2"})).setFullTableName(tableName).setGroupByClause("K1").setOrderByClause("K1 DESC");
        ResultSet rs = this.executeQuery(conn, queryBuilder);
        Assert.assertTrue((boolean)rs.next());
        BaseAggregateWithRegionMoves2IT.moveRegionsOfTable(tableName);
        Assert.assertEquals((Object)"n", (Object)rs.getString(1));
        Assert.assertEquals((long)10L, (long)rs.getLong(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"j", (Object)rs.getString(1));
        Assert.assertEquals((long)10L, (long)rs.getLong(2));
        Assert.assertTrue((boolean)rs.next());
        BaseAggregateWithRegionMoves2IT.moveRegionsOfTable(tableName);
        Assert.assertEquals((Object)"b", (Object)rs.getString(1));
        Assert.assertEquals((long)5L, (long)rs.getLong(2));
        Assert.assertTrue((boolean)rs.next());
        BaseAggregateWithRegionMoves2IT.moveRegionsOfTable(tableName);
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertEquals((long)10L, (long)rs.getLong(2));
        Assert.assertFalse((boolean)rs.next());
        ExplainPlan plan = conn.prepareStatement(queryBuilder.build()).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
        ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
        Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
        Assert.assertEquals((Object)"REVERSE", (Object)explainPlanAttributes.getClientSortedBy());
        Assert.assertEquals((Object)"FULL SCAN ", (Object)explainPlanAttributes.getExplainScanType());
        Assert.assertEquals((Object)tableName, (Object)explainPlanAttributes.getTableName());
        Assert.assertEquals((Object)"SERVER FILTER BY FIRST KEY ONLY", (Object)explainPlanAttributes.getServerWhereFilter());
        Assert.assertEquals((Object)"SERVER AGGREGATE INTO ORDERED DISTINCT ROWS BY [K1]", (Object)explainPlanAttributes.getServerAggregate());
    }

    @Test
    public void testSumGroupByOrderPreservingDescWithoutSplit() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(BaseAggregateWithRegionMoves2IT.getUrl(), props);
        String tableName = BaseAggregateWithRegionMoves2IT.generateUniqueName();
        TABLE_NAMES.add(tableName);
        PreparedStatement stmt = conn.prepareStatement("CREATE TABLE " + tableName + " (k1 char(1) not null, k2 integer not null, constraint pk primary key (k1,k2))");
        stmt.execute();
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('a', 1)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('a', 2)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('a', 3)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('a', 4)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('b', 5)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('j', 1)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('j', 2)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('j', 3)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('j', 4)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('n', 1)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('n', 2)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('n', 3)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('n', 4)");
        conn.commit();
        QueryBuilder queryBuilder = new QueryBuilder().setSelectExpression("K1,SUM(K2)").setSelectExpressionColumns((List)Lists.newArrayList((Object[])new String[]{"K1", "K2"})).setFullTableName(tableName).setWhereClause("K1 >= 'a' AND K1 < 'o'").setGroupByClause("K1").setOrderByClause("K1 DESC");
        ResultSet rs = this.executeQuery(conn, queryBuilder);
        Assert.assertTrue((boolean)rs.next());
        BaseAggregateWithRegionMoves2IT.moveRegionsOfTable(tableName);
        Assert.assertEquals((Object)"n", (Object)rs.getString(1));
        Assert.assertEquals((long)10L, (long)rs.getLong(2));
        Assert.assertTrue((boolean)rs.next());
        BaseAggregateWithRegionMoves2IT.moveRegionsOfTable(tableName);
        Assert.assertEquals((Object)"j", (Object)rs.getString(1));
        Assert.assertEquals((long)10L, (long)rs.getLong(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"b", (Object)rs.getString(1));
        Assert.assertEquals((long)5L, (long)rs.getLong(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertEquals((long)10L, (long)rs.getLong(2));
        Assert.assertFalse((boolean)rs.next());
        ExplainPlan plan = conn.prepareStatement(queryBuilder.build()).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
        ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
        Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
        Assert.assertEquals((Object)"REVERSE", (Object)explainPlanAttributes.getClientSortedBy());
        Assert.assertEquals((Object)"RANGE SCAN ", (Object)explainPlanAttributes.getExplainScanType());
        Assert.assertEquals((Object)tableName, (Object)explainPlanAttributes.getTableName());
    }

    @Test
    public void testSumGroupByOrderPreservingAsc() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(BaseAggregateWithRegionMoves2IT.getUrl(), props);
        String tableName = BaseAggregateWithRegionMoves2IT.generateUniqueName();
        TABLE_NAMES.add(tableName);
        PreparedStatement stmt = conn.prepareStatement("CREATE TABLE " + tableName + " (k1 char(1) not null, k2 integer not null, constraint pk primary key (k1,k2)) split on (?,?,?)");
        stmt.setBytes(1, ByteUtil.concat((byte[])PChar.INSTANCE.toBytes((Object)"a"), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)3)}));
        stmt.setBytes(2, ByteUtil.concat((byte[])PChar.INSTANCE.toBytes((Object)"j"), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)3)}));
        stmt.setBytes(3, ByteUtil.concat((byte[])PChar.INSTANCE.toBytes((Object)"n"), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)3)}));
        stmt.execute();
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('a', 1)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('a', 2)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('a', 3)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('a', 4)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('b', 5)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('j', 1)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('j', 2)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('j', 3)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('j', 4)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('n', 1)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('n', 2)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('n', 3)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('n', 4)");
        conn.commit();
        QueryBuilder queryBuilder = new QueryBuilder().setSelectExpression("K1,SUM(K2)").setSelectExpressionColumns((List)Lists.newArrayList((Object[])new String[]{"K1", "K2"})).setFullTableName(tableName).setGroupByClause("K1").setOrderByClause("K1 ASC");
        ResultSet rs = this.executeQuery(conn, queryBuilder);
        Assert.assertTrue((boolean)rs.next());
        BaseAggregateWithRegionMoves2IT.moveRegionsOfTable(tableName);
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertEquals((long)10L, (long)rs.getLong(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"b", (Object)rs.getString(1));
        Assert.assertEquals((long)5L, (long)rs.getLong(2));
        Assert.assertTrue((boolean)rs.next());
        BaseAggregateWithRegionMoves2IT.moveRegionsOfTable(tableName);
        Assert.assertEquals((Object)"j", (Object)rs.getString(1));
        Assert.assertEquals((long)10L, (long)rs.getLong(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"n", (Object)rs.getString(1));
        Assert.assertEquals((long)10L, (long)rs.getLong(2));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testSumGroupByOrderPreservingAscWithoutSplits() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(BaseAggregateWithRegionMoves2IT.getUrl(), props);
        String tableName = BaseAggregateWithRegionMoves2IT.generateUniqueName();
        TABLE_NAMES.add(tableName);
        PreparedStatement stmt = conn.prepareStatement("CREATE TABLE " + tableName + " (k1 char(1) not null, k2 integer not null, constraint pk primary key (k1,k2))");
        stmt.execute();
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('a', 1)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('a', 2)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('a', 3)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('a', 4)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('b', 5)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('j', 1)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('j', 2)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('j', 3)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('j', 4)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('n', 1)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('n', 2)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('n', 3)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('n', 4)");
        conn.commit();
        QueryBuilder queryBuilder = new QueryBuilder().setSelectExpression("K1,SUM(K2)").setSelectExpressionColumns((List)Lists.newArrayList((Object[])new String[]{"K1", "K2"})).setFullTableName(tableName).setGroupByClause("K1").setOrderByClause("K1 ASC");
        ResultSet rs = this.executeQuery(conn, queryBuilder);
        Assert.assertTrue((boolean)rs.next());
        BaseAggregateWithRegionMoves2IT.moveRegionsOfTable(tableName);
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertEquals((long)10L, (long)rs.getLong(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"b", (Object)rs.getString(1));
        Assert.assertEquals((long)5L, (long)rs.getLong(2));
        Assert.assertTrue((boolean)rs.next());
        BaseAggregateWithRegionMoves2IT.moveRegionsOfTable(tableName);
        Assert.assertEquals((Object)"j", (Object)rs.getString(1));
        Assert.assertEquals((long)10L, (long)rs.getLong(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"n", (Object)rs.getString(1));
        Assert.assertEquals((long)10L, (long)rs.getLong(2));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testAvgGroupByOrderPreservingWithNoStats() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(BaseAggregateWithRegionMoves2IT.getUrl(), props);
        String tableName = BaseAggregateWithRegionMoves2IT.generateUniqueName();
        this.initAvgGroupTable(conn, tableName, "");
        this.testAvgGroupByOrderPreserving(conn, tableName, 4);
    }

    protected void initAvgGroupTable(Connection conn, String tableName, String tableProps) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement("CREATE TABLE " + tableName + " (k1 char(1) not null, k2 integer not null, constraint pk primary key (k1,k2)) " + tableProps + " split on (?,?,?)");
        TABLE_NAMES.add(tableName);
        stmt.setBytes(1, ByteUtil.concat((byte[])PChar.INSTANCE.toBytes((Object)"a"), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)3)}));
        stmt.setBytes(2, ByteUtil.concat((byte[])PChar.INSTANCE.toBytes((Object)"j"), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)3)}));
        stmt.setBytes(3, ByteUtil.concat((byte[])PChar.INSTANCE.toBytes((Object)"n"), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)3)}));
        stmt.execute();
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('a', 1)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('a', 2)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('a', 3)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('a', 6)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('b', 5)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('j', 1)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('j', 2)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('j', 3)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('j', 10)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('n', 1)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('n', 2)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('n', 3)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('n', 2)");
        conn.commit();
    }

    protected void testAvgGroupByOrderPreserving(Connection conn, String tableName, int splitSize) throws SQLException, IOException {
        TABLE_NAMES.add(tableName);
        QueryBuilder queryBuilder = new QueryBuilder().setSelectExpression("K1, AVG(K2)").setSelectExpressionColumns((List)Lists.newArrayList((Object[])new String[]{"K1", "K2"})).setFullTableName(tableName).setGroupByClause("K1").setOrderByClause("K1");
        ResultSet rs = this.executeQuery(conn, queryBuilder);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertEquals((double)3.0, (double)rs.getDouble(2), (double)1.0E-6);
        Assert.assertTrue((boolean)rs.next());
        BaseAggregateWithRegionMoves2IT.moveRegionsOfTable(tableName);
        Assert.assertEquals((Object)"b", (Object)rs.getString(1));
        Assert.assertEquals((double)5.0, (double)rs.getDouble(2), (double)1.0E-6);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"j", (Object)rs.getString(1));
        Assert.assertEquals((double)4.0, (double)rs.getDouble(2), (double)1.0E-6);
        Assert.assertTrue((boolean)rs.next());
        BaseAggregateWithRegionMoves2IT.moveRegionsOfTable(tableName);
        Assert.assertEquals((Object)"n", (Object)rs.getString(1));
        Assert.assertEquals((double)2.0, (double)rs.getDouble(2), (double)1.0E-6);
        Assert.assertFalse((boolean)rs.next());
        ExplainPlan plan = conn.prepareStatement(queryBuilder.build()).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
        ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
        Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
        Assert.assertEquals((Object)"FULL SCAN ", (Object)explainPlanAttributes.getExplainScanType());
        Assert.assertEquals((Object)tableName, (Object)explainPlanAttributes.getTableName());
        Assert.assertEquals((Object)"SERVER FILTER BY FIRST KEY ONLY", (Object)explainPlanAttributes.getServerWhereFilter());
        Assert.assertEquals((Object)"SERVER AGGREGATE INTO ORDERED DISTINCT ROWS BY [K1]", (Object)explainPlanAttributes.getServerAggregate());
        TestUtil.analyzeTable(conn, tableName);
        List<KeyRange> splits = TestUtil.getAllSplits(conn, tableName);
        Assert.assertEquals((long)splitSize, (long)splits.size());
    }

    @Test
    public void testGroupByOrderByDescBug3451() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(BaseAggregateWithRegionMoves2IT.getUrl(), props);){
            String tableName = BaseAggregateWithRegionMoves2IT.generateUniqueName();
            String sql = "CREATE TABLE " + tableName + " (\n            ORGANIZATION_ID CHAR(15) NOT NULL,\n            CONTAINER_ID CHAR(15) NOT NULL,\n            ENTITY_ID CHAR(15) NOT NULL,\n            SCORE DOUBLE,\n            CONSTRAINT TEST_PK PRIMARY KEY (\n               ORGANIZATION_ID,\n               CONTAINER_ID,\n               ENTITY_ID\n             )\n         )";
            conn.createStatement().execute(sql);
            String indexName = BaseAggregateWithRegionMoves2IT.generateUniqueName();
            TABLE_NAMES.add(tableName);
            TABLE_NAMES.add(indexName);
            conn.createStatement().execute("CREATE INDEX " + indexName + " ON " + tableName + "(ORGANIZATION_ID,CONTAINER_ID, SCORE DESC, ENTITY_ID DESC)");
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES ('org2','container2','entityId6',1.1)");
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES ('org2','container1','entityId5',1.2)");
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES ('org2','container2','entityId4',1.3)");
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES ('org2','container1','entityId5',1.2)");
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES ('org2','container1','entityId3',1.4)");
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES ('org2','container3','entityId7',1.35)");
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES ('org2','container3','entityId8',1.45)");
            conn.commit();
            QueryBuilder queryBuilder = new QueryBuilder().setDistinct(true).setSelectColumns((List)Lists.newArrayList((Object[])new String[]{"ENTITY_ID", "SCORE", "ORGANIZATION_ID", "CONTAINER_ID"})).setFullTableName(tableName).setWhereClause("ORGANIZATION_ID = 'org2' AND CONTAINER_ID IN ('container1','container2','container3')").setOrderByClause("SCORE DESC").setLimit(2);
            ResultSet rs = this.executeQuery(conn, queryBuilder);
            Assert.assertTrue((boolean)rs.next());
            BaseAggregateWithRegionMoves2IT.moveRegionsOfTable(tableName);
            Assert.assertEquals((Object)"entityId8", (Object)rs.getString(1));
            Assert.assertEquals((double)1.45, (double)rs.getDouble(2), (double)0.001);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"entityId3", (Object)rs.getString(1));
            Assert.assertEquals((double)1.4, (double)rs.getDouble(2), (double)0.001);
            Assert.assertFalse((boolean)rs.next());
            String expectedPhoenixPlan = "";
            BaseAggregateWithRegionMoves2IT.validateQueryPlan(conn, queryBuilder, expectedPhoenixPlan, null);
        }
    }

    protected static void assertResultSet(ResultSet rs, Object[][] rows, String tableName) throws Exception {
        boolean switchToRegionMove = true;
        for (int rowIndex = 0; rowIndex < rows.length; ++rowIndex) {
            Assert.assertTrue((String)("rowIndex:[" + rowIndex + "] rs.next error!"), (boolean)rs.next());
            if (switchToRegionMove) {
                BaseAggregateWithRegionMoves2IT.moveRegionsOfTable(tableName);
                switchToRegionMove = false;
            } else {
                switchToRegionMove = true;
            }
            for (int columnIndex = 1; columnIndex <= rows[rowIndex].length; ++columnIndex) {
                Object realValue = rs.getObject(columnIndex);
                Object expectedValue = rows[rowIndex][columnIndex - 1];
                if (realValue == null) {
                    Assert.assertNull((String)("rowIndex:[" + rowIndex + "],columnIndex:[" + columnIndex + "]"), (Object)expectedValue);
                    continue;
                }
                Assert.assertEquals((String)("rowIndex:[" + rowIndex + "],columnIndex:[" + columnIndex + "]"), (Object)expectedValue, (Object)realValue);
            }
        }
        Assert.assertFalse((boolean)rs.next());
    }
}

