/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.phoenix.end2end.BackwardCompatibilityIT;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Assume;

public final class BackwardCompatibilityTestUtil {
    public static final String SQL_DIR = "sql_files/";
    public static final String RESULTS_AND_GOLD_FILES_DIR = "gold_files/";
    public static final String COMPATIBLE_CLIENTS_JSON = "compatible_client_versions.json";
    public static final String BASH = "/bin/bash";
    public static final String EXECUTE_QUERY_SH = "scripts/execute_query.sh";
    public static final String QUERY_PREFIX = "query_";
    public static final String RESULT_PREFIX = "result_";
    public static final String GOLD_PREFIX = "gold_";
    public static final String SQL_EXTENSION = ".sql";
    public static final String TEXT_EXTENSION = ".txt";
    public static final String CREATE_ADD = "create_add";
    public static final String CREATE_TMP_TABLE = "create_tmp_table";
    public static final String CREATE_DIVERGED_VIEW = "create_diverged_view";
    public static final String UNORDERED_GROUP_BY = "unorder_groupby";
    public static final String ORDERED_GROUP_BY = "ordered_groupby";
    public static final String ORDER_BY_NON_PK = "orderby_nonpk";
    public static final String OFFSET = "offset";
    public static final String CREATE_UNORDERED_GROUP_BY = "create_unorder_groupby";
    public static final String CREATE_ORDERED_GROUP_BY = "create_ordered_groupby";
    public static final String CREATE_ORDER_BY_NON_PK = "create_orderby_nonpk";
    public static final String CREATE_OFFSET = "create_offset";
    public static final String ADD_DATA = "add_data";
    public static final String ADD_DELETE = "add_delete";
    public static final String ADD_VIEW_INDEX = "add_view_index";
    public static final String DELETE = "delete";
    public static final String DELETE_FOR_SPLITABLE_SYSCAT = "delete_for_splitable_syscat";
    public static final String VIEW_INDEX = "view_index";
    public static final String SELECT_AND_DROP_TABLE = "select_and_drop_table";
    public static final String QUERY_UNORDERED_GROUP_BY = "query_unorder_groupby";
    public static final String QUERY_ORDERED_GROUP_BY = "query_ordered_groupby";
    public static final String QUERY_OFFSET = "query_offset";
    public static final String QUERY_ORDER_BY_NON_PK = "query_orderby_nonpk";
    public static final String QUERY_CREATE_ADD = "query_create_add";
    public static final String QUERY_ADD_DATA = "query_add_data";
    public static final String QUERY_ADD_DELETE = "query_add_delete";
    public static final String QUERY_DELETE = "query_delete";
    public static final String QUERY_DELETE_FOR_SPLITTABLE_SYSCAT = "query_delete_for_splitable_syscat";
    public static final String QUERY_SELECT_AND_DROP_TABLE = "query_select_and_drop_table";
    public static final String QUERY_CREATE_DIVERGED_VIEW = "query_create_diverged_view";
    public static final String QUERY_VIEW_INDEX = "query_view_index";
    public static final String INDEX_REBUILD_ASYNC = "index_rebuild_async";
    public static final String QUERY_INDEX_REBUILD_ASYNC = "query_index_rebuild_async";
    public static final String MVN_HOME = "maven.home";
    public static final String JAVA_TMP_DIR = "java.io.tmpdir";

    private BackwardCompatibilityTestUtil() {
    }

    public static List<MavenCoordinates> computeClientVersions() throws Exception {
        String hbaseVersion = VersionInfo.getVersion();
        Pattern p = Pattern.compile("\\d+\\.\\d+");
        Matcher m = p.matcher(hbaseVersion);
        String hbaseProfile = null;
        if (m.find()) {
            hbaseProfile = m.group();
        }
        ArrayList clientVersions = Lists.newArrayList();
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        try (InputStream inputStream = BackwardCompatibilityIT.class.getClassLoader().getResourceAsStream(COMPATIBLE_CLIENTS_JSON);){
            Assert.assertNotNull((Object)inputStream);
            JsonNode jsonNode = mapper.readTree(inputStream);
            JsonNode HBaseProfile = jsonNode.get(hbaseProfile);
            for (JsonNode clientVersion : HBaseProfile) {
                clientVersions.add(mapper.treeToValue((TreeNode)clientVersion, MavenCoordinates.class));
            }
        }
        return clientVersions;
    }

    public static void executeQueryWithClientVersion(MavenCoordinates clientVersion, String operation, String zkQuorum) throws Exception {
        ArrayList cmdParams = Lists.newArrayList();
        cmdParams.add(BASH);
        URL fileUrl = BackwardCompatibilityIT.class.getClassLoader().getResource(EXECUTE_QUERY_SH);
        Assert.assertNotNull((Object)fileUrl);
        cmdParams.add(new File(fileUrl.getFile()).getAbsolutePath());
        cmdParams.add(zkQuorum);
        cmdParams.add(clientVersion.getGroupId());
        cmdParams.add(clientVersion.getArtifactId());
        cmdParams.add(clientVersion.getVersion());
        fileUrl = BackwardCompatibilityIT.class.getClassLoader().getResource(SQL_DIR + operation + SQL_EXTENSION);
        Assert.assertNotNull((Object)fileUrl);
        cmdParams.add(new File(fileUrl.getFile()).getAbsolutePath());
        fileUrl = BackwardCompatibilityIT.class.getClassLoader().getResource(RESULTS_AND_GOLD_FILES_DIR);
        Assert.assertNotNull((Object)fileUrl);
        String resultFilePath = new File(fileUrl.getFile()).getAbsolutePath() + "/" + RESULT_PREFIX + operation + TEXT_EXTENSION;
        cmdParams.add(resultFilePath);
        cmdParams.add(System.getProperty(JAVA_TMP_DIR));
        if (System.getProperty(MVN_HOME) != null) {
            cmdParams.add(System.getProperty(MVN_HOME));
        }
        ProcessBuilder pb = new ProcessBuilder(cmdParams);
        final Process p = pb.start();
        final StringBuffer sb = new StringBuffer();
        Thread outputStreamThread = new Thread(){

            @Override
            public void run() {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        sb.append(line);
                    }
                }
                catch (Exception e) {
                    sb.append(e.getMessage());
                }
            }
        };
        outputStreamThread.start();
        Thread errorStreamThread = new Thread(){

            @Override
            public void run() {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(p.getErrorStream()));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        sb.append(line);
                    }
                }
                catch (Exception e) {
                    sb.append(e.getMessage());
                }
            }
        };
        errorStreamThread.start();
        p.waitFor();
        String resultDump = "PLACEHOLDER. Could not read result file";
        try {
            resultDump = new String(Files.readAllBytes(Paths.get(resultFilePath, new String[0])));
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertEquals((String)String.format("Executing the query failed%s. Check the result file: %s\nResult file dump follows:\n%s", sb.length() > 0 ? sb.append(" with : ").toString() : "", resultFilePath, resultDump), (long)0L, (long)p.exitValue());
    }

    public static void checkForPreConditions(MavenCoordinates compatibleClientVersion, Configuration conf) throws Exception {
        Assume.assumeFalse((boolean)compatibleClientVersion.getVersion().contains("5.3.0"));
        try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);
             Admin admin = conn.getAdmin();){
            Assert.assertFalse((boolean)admin.tableExists(TableName.valueOf((String)"SYSTEM", (String)"CATALOG")));
        }
    }

    private static void saveResultSet(ResultSet rs, BufferedWriter br) throws Exception {
        int i;
        ResultSetMetaData rsm = rs.getMetaData();
        int columnCount = rsm.getColumnCount();
        StringBuilder row = new StringBuilder(BackwardCompatibilityTestUtil.formatStringWithQuotes(rsm.getColumnName(1)));
        for (i = 2; i <= columnCount; ++i) {
            row.append(",").append(BackwardCompatibilityTestUtil.formatStringWithQuotes(rsm.getColumnName(i)));
        }
        br.write(row.toString());
        br.write("\n");
        while (rs.next()) {
            row = new StringBuilder(BackwardCompatibilityTestUtil.formatStringWithQuotes(rs.getString(1)));
            for (i = 2; i <= columnCount; ++i) {
                row.append(",").append(BackwardCompatibilityTestUtil.formatStringWithQuotes(rs.getString(i)));
            }
            br.write(row.toString());
            br.write("\n");
        }
    }

    private static String formatStringWithQuotes(String str) {
        return str != null ? String.format("'%s'", str) : "''";
    }

    private static BufferedReader getBufferedReaderForResource(String relativePath) throws FileNotFoundException {
        URL fileUrl = BackwardCompatibilityTestUtil.class.getClassLoader().getResource(relativePath);
        Assert.assertNotNull((Object)fileUrl);
        return new BufferedReader(new FileReader(new File(fileUrl.getFile())));
    }

    public static void assertExpectedOutput(String result) throws Exception {
        String line;
        List resultFile = Lists.newArrayList();
        ArrayList goldFile = Lists.newArrayList();
        try (BufferedReader resultFileReader = BackwardCompatibilityTestUtil.getBufferedReaderForResource("gold_files/result_" + result + TEXT_EXTENSION);){
            while ((line = resultFileReader.readLine()) != null) {
                resultFile.add(line.trim());
            }
        }
        var5_5 = null;
        try (BufferedReader goldFileReader = BackwardCompatibilityTestUtil.getBufferedReaderForResource("gold_files/gold_" + result + TEXT_EXTENSION);){
            while ((line = goldFileReader.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || line.startsWith("*") || line.startsWith("/")) continue;
                goldFile.add(line);
            }
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        int index = resultFile.indexOf(goldFile.get(0));
        Assert.assertNotEquals((String)"Mismatch found between gold file and result file", (long)-1L, (long)index);
        resultFile = resultFile.subList(index, resultFile.size());
        Assert.assertEquals((Object)goldFile, (Object)resultFile);
    }

    public static void executeQueriesWithCurrentVersion(String operation, String url, UpgradeProps upgradeProps) throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        if (UpgradeProps.SET_MAX_LOOK_BACK_AGE.equals((Object)upgradeProps)) {
            props.put("phoenix.max.lookback.age.seconds", Integer.toString(15));
        }
        try (java.sql.Connection conn = DriverManager.getConnection(url, props);){
            StringBuilder sb = new StringBuilder();
            try (BufferedReader reader = BackwardCompatibilityTestUtil.getBufferedReaderForResource(SQL_DIR + operation + SQL_EXTENSION);){
                String sqlCommand;
                while ((sqlCommand = reader.readLine()) != null) {
                    if ((sqlCommand = sqlCommand.trim()).length() == 0 || sqlCommand.startsWith("/") || sqlCommand.startsWith("*")) continue;
                    sb.append(sqlCommand);
                }
            }
            String[] sqlCommands = sb.toString().split(";");
            URL fileUrl = BackwardCompatibilityIT.class.getClassLoader().getResource(RESULTS_AND_GOLD_FILES_DIR);
            Assert.assertNotNull((Object)fileUrl);
            String resultFile = new File(fileUrl.getFile()).getAbsolutePath() + "/" + RESULT_PREFIX + operation + TEXT_EXTENSION;
            try (BufferedWriter br = new BufferedWriter(new FileWriter(resultFile));){
                for (String command : sqlCommands) {
                    try (PreparedStatement stmt = conn.prepareStatement(command);){
                        stmt.execute();
                        ResultSet rs = stmt.getResultSet();
                        if (rs != null) {
                            BackwardCompatibilityTestUtil.saveResultSet(rs, br);
                        }
                    }
                    conn.commit();
                }
            }
        }
    }

    public static class MavenCoordinates {
        private String groupId = "org.apache.phoenix";
        private String artifactId;
        private String version;

        public String getGroupId() {
            return this.groupId;
        }

        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public void setArtifactId(String artifactId) {
            this.artifactId = artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String toString() {
            return this.groupId + ":" + this.artifactId + ":" + this.version;
        }
    }

    public static enum UpgradeProps {
        NONE,
        SET_MAX_LOOK_BACK_AGE;

    }
}

