/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.SequenceNotFoundException;
import org.apache.phoenix.schema.TableAlreadyExistsException;
import org.apache.phoenix.schema.types.PInteger;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={ParallelStatsDisabledTest.class})
@RunWith(value=Parameterized.class)
public class AutoPartitionViewsIT
extends ParallelStatsDisabledIT {
    private String tableDDLOptions;
    private boolean isMultiTenant;
    private final String TENANT_SPECIFIC_URL1 = AutoPartitionViewsIT.getUrl() + ';' + "TenantId" + "=tenant1";
    private final String TENANT_SPECIFIC_URL2 = AutoPartitionViewsIT.getUrl() + ';' + "TenantId" + "=tenant2";

    @Parameterized.Parameters(name="AutoPartitionViewsIT_salted={0},multi-tenant={1}")
    public static synchronized Collection<Boolean[]> data() {
        return Arrays.asList({false, false}, {false, true}, {true, false}, {true, true});
    }

    public AutoPartitionViewsIT(boolean salted, boolean isMultiTenant) {
        this.isMultiTenant = isMultiTenant;
        StringBuilder optionBuilder = new StringBuilder(" AUTO_PARTITION_SEQ=\"%s\"");
        if (salted) {
            optionBuilder.append(", SALTED=4 ");
        }
        if (isMultiTenant) {
            optionBuilder.append(", MULTI_TENANT=true ");
        }
        this.tableDDLOptions = optionBuilder.toString();
    }

    @Test
    public void testValidateAttributes() throws SQLException {
        try (Connection conn = DriverManager.getConnection(AutoPartitionViewsIT.getUrl());
             Connection viewConn1 = this.isMultiTenant ? DriverManager.getConnection(this.TENANT_SPECIFIC_URL1) : DriverManager.getConnection(AutoPartitionViewsIT.getUrl());
             Connection viewConn2 = this.isMultiTenant ? DriverManager.getConnection(this.TENANT_SPECIFIC_URL1) : DriverManager.getConnection(AutoPartitionViewsIT.getUrl());){
            String ddl;
            String tableName = AutoPartitionViewsIT.generateUniqueName();
            String autoSeqName = AutoPartitionViewsIT.generateUniqueName();
            try {
                ddl = String.format("CREATE TABLE " + tableName + " (%s metricId VARCHAR, val1 DOUBLE, val2 DOUBLE CONSTRAINT PK PRIMARY KEY( %s metricId)) %s", this.isMultiTenant ? "tenantId VARCHAR, " : "", this.isMultiTenant ? "tenantId, " : "", String.format(this.tableDDLOptions, autoSeqName));
                conn.createStatement().execute(ddl);
                Assert.fail((String)"Sequence value must be castable to the auto partition id column data type");
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.SEQUENCE_NOT_CASTABLE_TO_AUTO_PARTITION_ID_COLUMN.getErrorCode(), (long)e.getErrorCode());
            }
            ddl = String.format("CREATE TABLE " + tableName + " (%s metricId INTEGER NOT NULL, val1 DOUBLE, val2 DOUBLE CONSTRAINT PK PRIMARY KEY( %s metricId)) %s", this.isMultiTenant ? "tenantId VARCHAR NOT NULL, " : "", this.isMultiTenant ? "tenantId, " : "", String.format(this.tableDDLOptions, autoSeqName));
            conn.createStatement().execute(ddl);
            String baseViewName = AutoPartitionViewsIT.generateUniqueName();
            String metricView1 = baseViewName + "_VIEW1";
            String metricView2 = baseViewName + "_VIEW2";
            String metricView3 = baseViewName + "_VIEW3";
            String metricView4 = baseViewName + "_VIEW4";
            try {
                viewConn1.createStatement().execute("CREATE VIEW " + metricView1 + "  AS SELECT * FROM " + tableName);
                Assert.fail((String)"Auto-partition sequence must be created before view is created");
            }
            catch (SequenceNotFoundException sequenceNotFoundException) {
                // empty catch block
            }
            conn.createStatement().execute("CREATE SEQUENCE " + autoSeqName + " start with " + 0x7FFFFFFD + " cache 1");
            viewConn1.createStatement().execute("CREATE VIEW " + metricView1 + " AS SELECT * FROM " + tableName + " WHERE val2=1.2");
            viewConn1.createStatement().execute("CREATE VIEW " + metricView2 + " AS SELECT * FROM " + tableName);
            viewConn1.createStatement().execute("CREATE VIEW " + metricView3 + " AS SELECT * FROM " + tableName + " WHERE val1=1.0 OR val2=2.0");
            try {
                viewConn1.createStatement().execute("CREATE VIEW " + metricView4 + " AS SELECT * FROM " + tableName);
                Assert.fail((String)"Creating a view with a partition id that is too large should fail");
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.CANNOT_COERCE_AUTO_PARTITION_ID.getErrorCode(), (long)e.getErrorCode());
            }
            if (this.isMultiTenant) {
                viewConn1.createStatement().execute("SELECT * FROM " + metricView1);
                viewConn1.createStatement().execute("SELECT * FROM " + metricView2);
                viewConn1.createStatement().execute("SELECT * FROM " + metricView3);
            }
            PhoenixConnection pconn = viewConn1.unwrap(PhoenixConnection.class);
            PTable view1 = pconn.getTable(new PTableKey(pconn.getTenantId(), metricView1));
            PTable view2 = pconn.getTable(new PTableKey(pconn.getTenantId(), metricView2));
            PTable view3 = pconn.getTable(new PTableKey(pconn.getTenantId(), metricView3));
            String expectedViewStatement1 = "SELECT * FROM \"" + tableName + "\" WHERE VAL2 = 1.2 AND METRICID = " + 0x7FFFFFFD;
            String expectedViewStatement2 = "SELECT * FROM \"" + tableName + "\" WHERE METRICID = " + 0x7FFFFFFE;
            String expectedViewStatement3 = "SELECT * FROM \"" + tableName + "\" WHERE (VAL1 = 1.0 OR VAL2 = 2.0) AND METRICID = " + Integer.MAX_VALUE;
            Assert.assertEquals((String)"Unexpected view statement", (Object)expectedViewStatement1, (Object)view1.getViewStatement());
            Assert.assertEquals((String)"Unexpected view statement", (Object)expectedViewStatement2, (Object)view2.getViewStatement());
            Assert.assertEquals((String)"Unexpected view statement", (Object)expectedViewStatement3, (Object)view3.getViewStatement());
            int expectedParitionColIndex = this.isMultiTenant ? 1 : 0;
            PColumn partitionCol1 = (PColumn)view1.getColumns().get(expectedParitionColIndex);
            PColumn partitionCol2 = (PColumn)view2.getColumns().get(expectedParitionColIndex);
            PColumn partitionCol3 = (PColumn)view3.getColumns().get(expectedParitionColIndex);
            Assert.assertTrue((String)"Partition column view referenced attribute should be true ", (boolean)partitionCol1.isViewReferenced());
            Assert.assertTrue((String)"Partition column view referenced attribute should be true ", (boolean)partitionCol2.isViewReferenced());
            Assert.assertTrue((String)"Partition column view referenced attribute should be true ", (boolean)partitionCol3.isViewReferenced());
            byte[] expectedPartition1 = new byte[5];
            PInteger.INSTANCE.toBytes((Object)0x7FFFFFFD, expectedPartition1, 0);
            byte[] expectedPartition2 = new byte[5];
            PInteger.INSTANCE.toBytes((Object)0x7FFFFFFE, expectedPartition2, 0);
            byte[] expectedPartition3 = new byte[5];
            PInteger.INSTANCE.toBytes((Object)Integer.MAX_VALUE, expectedPartition3, 0);
            Assert.assertArrayEquals((String)"Unexpected Partition column view constant attribute", (byte[])expectedPartition1, (byte[])partitionCol1.getViewConstant());
            Assert.assertArrayEquals((String)"Unexpected Partition column view constant attribute", (byte[])expectedPartition2, (byte[])partitionCol2.getViewConstant());
            Assert.assertArrayEquals((String)"Unexpected Partition column view constant attribute", (byte[])expectedPartition3, (byte[])partitionCol3.getViewConstant());
            viewConn2.createStatement().execute("SELECT * FROM " + metricView1);
            viewConn2.createStatement().execute("SELECT * FROM " + metricView2);
            viewConn2.createStatement().execute("SELECT * FROM " + metricView3);
            pconn = viewConn2.unwrap(PhoenixConnection.class);
            view1 = pconn.getTable(new PTableKey(pconn.getTenantId(), metricView1));
            view2 = pconn.getTable(new PTableKey(pconn.getTenantId(), metricView2));
            view3 = pconn.getTable(new PTableKey(pconn.getTenantId(), metricView3));
            Assert.assertEquals((String)"Unexpected view statement", (Object)expectedViewStatement1, (Object)view1.getViewStatement());
            Assert.assertEquals((String)"Unexpected view statement", (Object)expectedViewStatement2, (Object)view2.getViewStatement());
            Assert.assertEquals((String)"Unexpected view statement", (Object)expectedViewStatement3, (Object)view3.getViewStatement());
            partitionCol1 = (PColumn)view1.getColumns().get(expectedParitionColIndex);
            partitionCol2 = (PColumn)view2.getColumns().get(expectedParitionColIndex);
            partitionCol3 = (PColumn)view3.getColumns().get(expectedParitionColIndex);
            Assert.assertTrue((String)"Partition column view referenced attribute should be true ", (boolean)partitionCol1.isViewReferenced());
            Assert.assertTrue((String)"Partition column view referenced attribute should be true ", (boolean)partitionCol2.isViewReferenced());
            Assert.assertTrue((String)"Partition column view referenced attribute should be true ", (boolean)partitionCol3.isViewReferenced());
            Assert.assertArrayEquals((String)"Unexpected Partition column view constant attribute", (byte[])expectedPartition1, (byte[])partitionCol1.getViewConstant());
            Assert.assertArrayEquals((String)"Unexpected Partition column view constant attribute", (byte[])expectedPartition2, (byte[])partitionCol2.getViewConstant());
            Assert.assertArrayEquals((String)"Unexpected Partition column view constant attribute", (byte[])expectedPartition3, (byte[])partitionCol3.getViewConstant());
        }
    }

    @Test
    public void testViewCreationFailure() throws SQLException {
        try (Connection conn = DriverManager.getConnection(AutoPartitionViewsIT.getUrl());
             Connection viewConn1 = this.isMultiTenant ? DriverManager.getConnection(this.TENANT_SPECIFIC_URL1) : DriverManager.getConnection(AutoPartitionViewsIT.getUrl());
             Connection viewConn2 = this.isMultiTenant ? DriverManager.getConnection(this.TENANT_SPECIFIC_URL2) : DriverManager.getConnection(AutoPartitionViewsIT.getUrl());){
            String tableName = AutoPartitionViewsIT.generateUniqueName();
            String autoSeqName = AutoPartitionViewsIT.generateUniqueName();
            String ddl = String.format("CREATE TABLE " + tableName + " (%s metricId INTEGER NOT NULL, val1 DOUBLE, val2 DOUBLE CONSTRAINT PK PRIMARY KEY( %s metricId)) %s", this.isMultiTenant ? "tenantId VARCHAR NOT NULL, " : "", this.isMultiTenant ? "tenantId, " : "", String.format(this.tableDDLOptions, autoSeqName));
            conn.createStatement().execute(ddl);
            conn.createStatement().execute("CREATE SEQUENCE " + autoSeqName + " CACHE 1");
            String baseViewName = AutoPartitionViewsIT.generateUniqueName();
            String metricView1 = baseViewName + "_VIEW1";
            String metricView2 = baseViewName + "_VIEW2";
            viewConn1.createStatement().execute("CREATE VIEW " + metricView1 + " AS SELECT * FROM " + tableName + " WHERE val2=1.2");
            try {
                viewConn1.createStatement().execute("CREATE VIEW " + metricView1 + " AS SELECT * FROM " + tableName);
                Assert.fail((String)"view should already exist");
            }
            catch (TableAlreadyExistsException tableAlreadyExistsException) {
                // empty catch block
            }
            viewConn2.createStatement().execute("CREATE VIEW " + metricView2 + " AS SELECT * FROM " + tableName);
            viewConn1.createStatement().execute("UPSERT INTO " + metricView1 + "(val1) VALUES(1.1)");
            viewConn1.commit();
            viewConn2.createStatement().execute("UPSERT INTO " + metricView2 + "(val1,val2) VALUES(2.1,2.2)");
            viewConn2.commit();
            ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + tableName);
            Assert.assertTrue((boolean)rs.next());
            int offset = 0;
            if (this.isMultiTenant) {
                Assert.assertEquals((Object)"tenant1", (Object)rs.getString(1));
                offset = 1;
            }
            Assert.assertEquals((long)1L, (long)rs.getInt(1 + offset));
            Assert.assertEquals((double)1.1, (double)rs.getDouble(2 + offset), (double)1.0E-6);
            Assert.assertEquals((double)1.2, (double)rs.getDouble(3 + offset), (double)1.0E-6);
            Assert.assertTrue((boolean)rs.next());
            if (this.isMultiTenant) {
                Assert.assertEquals((Object)"tenant2", (Object)rs.getString(1));
            }
            Assert.assertEquals((long)2L, (long)rs.getInt(1 + offset));
            Assert.assertEquals((double)2.1, (double)rs.getDouble(2 + offset), (double)1.0E-6);
            Assert.assertEquals((double)2.2, (double)rs.getDouble(3 + offset), (double)1.0E-6);
            Assert.assertFalse((boolean)rs.next());
            rs = viewConn1.createStatement().executeQuery("SELECT * FROM " + metricView1);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertEquals((double)1.1, (double)rs.getDouble(2), (double)1.0E-6);
            Assert.assertEquals((double)1.2, (double)rs.getDouble(3), (double)1.0E-6);
            Assert.assertFalse((boolean)rs.next());
            rs = viewConn2.createStatement().executeQuery("SELECT * FROM " + metricView2);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Assert.assertEquals((double)2.1, (double)rs.getDouble(2), (double)1.0E-6);
            Assert.assertEquals((double)2.2, (double)rs.getDouble(3), (double)1.0E-6);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testAddDropColumns() throws SQLException {
        try (Connection conn = DriverManager.getConnection(AutoPartitionViewsIT.getUrl());
             Connection viewConn1 = this.isMultiTenant ? DriverManager.getConnection(this.TENANT_SPECIFIC_URL1) : DriverManager.getConnection(AutoPartitionViewsIT.getUrl());){
            String tableName = AutoPartitionViewsIT.generateUniqueName();
            String autoSeqName = AutoPartitionViewsIT.generateUniqueName();
            String ddl = String.format("CREATE TABLE " + tableName + " (%s metricId INTEGER NOT NULL, val1 DOUBLE, CONSTRAINT PK PRIMARY KEY( %s metricId)) %s", this.isMultiTenant ? "tenantId VARCHAR NOT NULL, " : "", this.isMultiTenant ? "tenantId, " : "", String.format(this.tableDDLOptions, autoSeqName));
            conn.createStatement().execute(ddl);
            conn.createStatement().execute("CREATE SEQUENCE " + autoSeqName + " CACHE 1");
            String metricView = AutoPartitionViewsIT.generateUniqueName() + "_VIEW";
            viewConn1.createStatement().execute("CREATE VIEW " + metricView + " AS SELECT * FROM " + tableName);
            conn.createStatement().execute("ALTER TABLE " + tableName + " add val2 DOUBLE");
            viewConn1.createStatement().execute("ALTER VIEW " + metricView + " add val3 DOUBLE");
            viewConn1.createStatement().execute("UPSERT INTO " + metricView + "(val1,val2,val3) VALUES(1.1,1.2,1.3)");
            viewConn1.commit();
            ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + tableName);
            Assert.assertTrue((boolean)rs.next());
            int offset = 0;
            if (this.isMultiTenant) {
                Assert.assertEquals((Object)"tenant1", (Object)rs.getString(1));
                offset = 1;
            }
            Assert.assertEquals((long)1L, (long)rs.getInt(1 + offset));
            Assert.assertEquals((double)1.1, (double)rs.getDouble(2 + offset), (double)1.0E-6);
            Assert.assertEquals((double)1.2, (double)rs.getDouble(3 + offset), (double)1.0E-6);
            Assert.assertFalse((boolean)rs.next());
            rs = viewConn1.createStatement().executeQuery("SELECT * FROM " + metricView);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertEquals((double)1.1, (double)rs.getDouble(2), (double)1.0E-6);
            Assert.assertEquals((double)1.2, (double)rs.getDouble(3), (double)1.0E-6);
            Assert.assertEquals((double)1.3, (double)rs.getDouble(4), (double)1.0E-6);
            Assert.assertFalse((boolean)rs.next());
            conn.createStatement().execute("ALTER TABLE " + tableName + " DROP COLUMN val2");
            viewConn1.createStatement().execute("ALTER VIEW " + metricView + " DROP COLUMN val3");
            try {
                viewConn1.createStatement().executeQuery("SELECT val2 FROM " + metricView);
                Assert.fail((String)"column should have been dropped");
            }
            catch (ColumnNotFoundException columnNotFoundException) {
                // empty catch block
            }
            try {
                viewConn1.createStatement().executeQuery("SELECT val3 FROM " + metricView);
                Assert.fail((String)"column should have been dropped");
            }
            catch (ColumnNotFoundException columnNotFoundException) {
                // empty catch block
            }
        }
    }
}

