/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Properties;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class AutoCommitIT
extends ParallelStatsDisabledIT {
    @Test
    public void testMutationJoin() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(AutoCommitIT.getUrl(), props);
        conn.setAutoCommit(true);
        String testTable = AutoCommitIT.generateUniqueName();
        String ddl = "CREATE TABLE " + testTable + "   (r varchar not null, col1 integer  CONSTRAINT pk PRIMARY KEY (r))\n";
        AutoCommitIT.createTestTable(AutoCommitIT.getUrl(), ddl);
        String query = "UPSERT INTO " + testTable + "(r, col1) VALUES('row1', 1)";
        PreparedStatement statement = conn.prepareStatement(query);
        statement.executeUpdate();
        conn.commit();
        conn.setAutoCommit(false);
        query = "UPSERT INTO " + testTable + "(r, col1) VALUES('row1', 2)";
        statement = conn.prepareStatement(query);
        statement.executeUpdate();
        query = "DELETE FROM " + testTable + " WHERE r='row1'";
        statement = conn.prepareStatement(query);
        statement.executeUpdate();
        conn.commit();
        query = "SELECT * FROM " + testTable;
        statement = conn.prepareStatement(query);
        ResultSet rs = statement.executeQuery();
        Assert.assertFalse((boolean)rs.next());
        query = "DELETE FROM " + testTable + " WHERE r='row1'";
        statement = conn.prepareStatement(query);
        statement.executeUpdate();
        query = "UPSERT INTO " + testTable + "(r, col1) VALUES('row1', 3)";
        statement = conn.prepareStatement(query);
        statement.executeUpdate();
        conn.commit();
        query = "SELECT * FROM " + testTable;
        statement = conn.prepareStatement(query);
        rs = statement.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"row1", (Object)rs.getString(1));
        Assert.assertEquals((long)3L, (long)rs.getInt(2));
        conn.close();
    }
}

