/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Array;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.query.BaseTest;

public abstract class ArrayIT
extends ParallelStatsDisabledIT {
    protected static String createTableWithArray(String url, byte[][] bs, Object object) throws SQLException {
        String tableName = ArrayIT.generateUniqueName();
        String ddlStmt = "create table " + tableName + "   (organization_id char(15) not null, \n    entity_id char(15) not null,\n    a_string_array varchar(100) array[3],\n    b_string varchar(100),\n    a_integer integer,\n    a_date date,\n    a_time time,\n    a_timestamp timestamp,\n    x_decimal decimal(31,10),\n    x_long_array bigint[5],\n    x_integer integer,\n    a_byte_array tinyint array,\n    a_short smallint,\n    a_float float,\n    a_double_array double array[],\n    a_unsigned_float unsigned_float,\n    a_unsigned_double unsigned_double \n    CONSTRAINT pk PRIMARY KEY (organization_id, entity_id)\n)";
        BaseTest.createTestTable(url, ddlStmt, bs, null);
        return tableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void initTablesWithArrays(String tableName, String tenantId, Date date, boolean useNull, String url) throws Exception {
        Properties props = new Properties();
        try (Connection conn = DriverManager.getConnection(url, props);){
            PreparedStatement stmt = conn.prepareStatement("upsert into " + tableName + "(    ORGANIZATION_ID,     ENTITY_ID,     a_string_array,     B_STRING,     A_INTEGER,     A_DATE,     X_DECIMAL,     x_long_array,     X_INTEGER,    a_byte_array,    A_SHORT,    A_FLOAT,    a_double_array,    A_UNSIGNED_FLOAT,    A_UNSIGNED_DOUBLE)VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            stmt.setString(1, tenantId);
            stmt.setString(2, "00A123122312312");
            Object[] strArr = new String[]{"ABC", useNull ? null : "CEDF", "XYZWER", "AB"};
            Array array = conn.createArrayOf("VARCHAR", strArr);
            stmt.setArray(3, array);
            stmt.setString(4, "b");
            stmt.setInt(5, 1);
            stmt.setDate(6, date);
            stmt.setBigDecimal(7, null);
            Object[] longArr = new Long[]{25L, 36L};
            array = conn.createArrayOf("BIGINT", longArr);
            stmt.setArray(8, array);
            stmt.setNull(9, 4);
            Object[] byteArr = new Byte[]{(byte)25, (byte)36};
            array = conn.createArrayOf("TINYINT", byteArr);
            stmt.setArray(10, array);
            stmt.setShort(11, (short)128);
            stmt.setFloat(12, 0.01f);
            Object[] doubleArr = new Double[]{25.343, 36.763, 37.56, 386.63};
            array = conn.createArrayOf("DOUBLE", doubleArr);
            stmt.setArray(13, array);
            stmt.setFloat(14, 0.01f);
            stmt.setDouble(15, 1.0E-4);
            stmt.execute();
            conn.commit();
        }
    }
}

