/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Array;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.phoenix.end2end.ArrayIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.schema.types.PhoenixArray;
import org.apache.phoenix.thirdparty.com.google.common.primitives.Floats;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class Array1IT
extends ArrayIT {
    private void assertArrayGetString(ResultSet rs, int arrayIndex, Array expectedArray, String expectedString) throws SQLException {
        Assert.assertEquals((Object)expectedArray, (Object)rs.getArray(arrayIndex));
        Assert.assertEquals((Object)("[" + expectedString + "]"), (Object)rs.getString(arrayIndex));
    }

    private static String createTableWithAllArrayTypes(String url, byte[][] bs, Object object) throws SQLException {
        String tableName = Array1IT.generateUniqueName();
        String ddlStmt = "create table " + tableName + "   (organization_id char(15) not null, \n    entity_id char(15) not null,\n    boolean_array boolean array,\n    byte_array tinyint array,\n    double_array double array[],\n    float_array float array,\n    int_array integer array,\n    long_array bigint[5],\n    short_array smallint array,\n    string_array varchar(100) array[3],\n    CONSTRAINT pk PRIMARY KEY (organization_id, entity_id)\n)";
        BaseTest.createTestTable(url, ddlStmt, bs, null);
        return tableName;
    }

    private static String createSimpleTableWithArray(String url, byte[][] bs, Object object) throws SQLException {
        String tableName = Array1IT.generateUniqueName();
        String ddlStmt = "create table " + tableName + "   (organization_id char(15) not null, \n    entity_id char(15) not null,\n    x_double double,\n    a_double_array double array[],\n    a_char_array char(5) array[],\n    CONSTRAINT pk PRIMARY KEY (organization_id, entity_id)\n)";
        BaseTest.createTestTable(url, ddlStmt, bs, null);
        return tableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initSimpleArrayTable(String tableName, String tenantId, Date date, boolean useNull) throws Exception {
        Properties props = new Properties();
        try (Connection conn = DriverManager.getConnection(Array1IT.getUrl(), props);){
            PreparedStatement stmt = conn.prepareStatement("upsert into " + tableName + "(    ORGANIZATION_ID,     ENTITY_ID,     x_double,     a_double_array, a_char_array)VALUES (?, ?, ?, ?, ?)");
            stmt.setString(1, tenantId);
            stmt.setString(2, "00A123122312312");
            stmt.setDouble(3, 1.2);
            Object[] doubleArr = new Double[]{64.87, 89.96};
            Array array = conn.createArrayOf("DOUBLE", doubleArr);
            stmt.setArray(4, array);
            Object[] charArr = new String[]{"a", "b"};
            array = conn.createArrayOf("CHAR", charArr);
            stmt.setArray(5, array);
            stmt.execute();
            conn.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScanByArrayValue() throws Exception {
        String tenantId = Array1IT.getOrganizationId();
        String tableName = Array1IT.createTableWithArray(Array1IT.getUrl(), Array1IT.getDefaultSplits(tenantId), null);
        Array1IT.initTablesWithArrays(tableName, tenantId, null, false, Array1IT.getUrl());
        String query = "SELECT a_double_array, /* comment ok? */ b_string, a_float FROM " + tableName + " WHERE ?=organization_id and ?=a_float";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        TestUtil.analyzeTable(conn, tableName);
        try (Connection conn = DriverManager.getConnection(Array1IT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            statement.setFloat(2, 0.01f);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Object[] doubleArr = new Double[]{25.343, 36.763, 37.56, 386.63};
            Array array = conn.createArrayOf("DOUBLE", doubleArr);
            PhoenixArray resultArray = (PhoenixArray)rs.getArray(1);
            Assert.assertEquals((Object)resultArray, (Object)array);
            Assert.assertEquals((Object)"[25.343, 36.763, 37.56, 386.63]", (Object)rs.getString(1));
            Assert.assertEquals((Object)rs.getString("B_string"), (Object)"b");
            Assert.assertTrue((Floats.compare((float)rs.getFloat(3), (float)0.01f) == 0 ? 1 : 0) != 0);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScanWithArrayInWhereClause() throws Exception {
        String tenantId = Array1IT.getOrganizationId();
        String tableName = Array1IT.createTableWithArray(Array1IT.getUrl(), Array1IT.getDefaultSplits(tenantId), null);
        Array1IT.initTablesWithArrays(tableName, tenantId, null, false, Array1IT.getUrl());
        String query = "SELECT a_double_array, /* comment ok? */ b_string, a_float FROM " + tableName + " WHERE ?=organization_id and ?=a_byte_array";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        TestUtil.analyzeTable(conn, tableName);
        try (Connection conn = DriverManager.getConnection(Array1IT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            Object[] byteArr = new Byte[]{(byte)25, (byte)36};
            Array array = conn.createArrayOf("TINYINT", byteArr);
            statement.setArray(2, array);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Object[] doubleArr = new Double[]{25.343, 36.763, 37.56, 386.63};
            array = conn.createArrayOf("DOUBLE", doubleArr);
            Array resultArray = rs.getArray(1);
            Assert.assertEquals((Object)resultArray, (Object)array);
            Assert.assertEquals((Object)"[25.343, 36.763, 37.56, 386.63]", (Object)rs.getString(1));
            Assert.assertEquals((Object)rs.getString("B_string"), (Object)"b");
            Assert.assertTrue((Floats.compare((float)rs.getFloat(3), (float)0.01f) == 0 ? 1 : 0) != 0);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScanWithNonFixedWidthArrayInWhereClause() throws Exception {
        String tenantId = Array1IT.getOrganizationId();
        String tableName = Array1IT.createTableWithArray(Array1IT.getUrl(), Array1IT.getDefaultSplits(tenantId), null);
        Array1IT.initTablesWithArrays(tableName, tenantId, null, false, Array1IT.getUrl());
        String query = "SELECT a_double_array, /* comment ok? */ b_string, a_float FROM  " + tableName + "  WHERE ?=organization_id and ?=a_string_array";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(Array1IT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            Object[] strArr = new String[]{"ABC", "CEDF", "XYZWER", "AB"};
            Array array = conn.createArrayOf("VARCHAR", strArr);
            statement.setArray(2, array);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Object[] doubleArr = new Double[]{25.343, 36.763, 37.56, 386.63};
            array = conn.createArrayOf("DOUBLE", doubleArr);
            Array resultArray = rs.getArray(1);
            Assert.assertEquals((Object)resultArray, (Object)array);
            Assert.assertEquals((Object)"[25.343, 36.763, 37.56, 386.63]", (Object)rs.getString(1));
            Assert.assertEquals((Object)rs.getString("B_string"), (Object)"b");
            Assert.assertTrue((Floats.compare((float)rs.getFloat(3), (float)0.01f) == 0 ? 1 : 0) != 0);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScanWithNonFixedWidthArrayInSelectClause() throws Exception {
        String tenantId = Array1IT.getOrganizationId();
        String tableName = Array1IT.createTableWithArray(Array1IT.getUrl(), Array1IT.getDefaultSplits(tenantId), null);
        Array1IT.initTablesWithArrays(tableName, tenantId, null, false, Array1IT.getUrl());
        String query = "SELECT a_string_array FROM  " + tableName;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(Array1IT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Object[] strArr = new String[]{"ABC", "CEDF", "XYZWER", "AB"};
            Array array = conn.createArrayOf("VARCHAR", strArr);
            PhoenixArray resultArray = (PhoenixArray)rs.getArray(1);
            Assert.assertEquals((Object)resultArray, (Object)array);
            Assert.assertEquals((Object)"['ABC', 'CEDF', 'XYZWER', 'AB']", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelectSpecificIndexOfAnArrayAsArrayFunction() throws Exception {
        String tenantId = Array1IT.getOrganizationId();
        String tableName = Array1IT.createTableWithArray(Array1IT.getUrl(), Array1IT.getDefaultSplits(tenantId), null);
        Array1IT.initTablesWithArrays(tableName, tenantId, null, false, Array1IT.getUrl());
        String query = "SELECT ARRAY_ELEM(a_double_array,2) FROM  " + tableName;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(Array1IT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Object[] doubleArr = new Double[]{36.763};
            conn.createArrayOf("DOUBLE", doubleArr);
            Double result = rs.getDouble(1);
            Assert.assertEquals((Object)doubleArr[0], (Object)result);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelectSpecificIndexOfAnArray() throws Exception {
        String tenantId = Array1IT.getOrganizationId();
        String tableName = Array1IT.createTableWithArray(Array1IT.getUrl(), Array1IT.getDefaultSplits(tenantId), null);
        Array1IT.initTablesWithArrays(tableName, tenantId, null, false, Array1IT.getUrl());
        String query = "SELECT a_double_array[3] FROM  " + tableName;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(Array1IT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Double[] doubleArr = new Double[]{37.56};
            Double result = rs.getDouble(1);
            Assert.assertEquals((Object)doubleArr[0], (Object)result);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCaseWithArray() throws Exception {
        String tenantId = Array1IT.getOrganizationId();
        String tableName = Array1IT.createTableWithArray(Array1IT.getUrl(), Array1IT.getDefaultSplits(tenantId), null);
        Array1IT.initTablesWithArrays(tableName, tenantId, null, false, Array1IT.getUrl());
        String query = "SELECT CASE WHEN A_INTEGER = 1 THEN a_double_array ELSE null END [3] FROM  " + tableName;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(Array1IT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Double[] doubleArr = new Double[]{37.56};
            Double result = rs.getDouble(1);
            Assert.assertEquals((Object)doubleArr[0], (Object)result);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpsertValuesWithArray() throws Exception {
        String tenantId = Array1IT.getOrganizationId();
        String tableName = Array1IT.createTableWithArray(Array1IT.getUrl(), Array1IT.getDefaultSplits(tenantId), null);
        String query = "upsert into  " + tableName + " (ORGANIZATION_ID,ENTITY_ID,a_double_array) values('" + tenantId + "','00A123122312312',ARRAY[2.0,345.8])";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(Array1IT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            int executeUpdate = statement.executeUpdate();
            Assert.assertEquals((long)1L, (long)executeUpdate);
            conn.commit();
            statement.close();
            conn.close();
            props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
            conn = DriverManager.getConnection(Array1IT.getUrl(), props);
            query = "SELECT ARRAY_ELEM(a_double_array,2) FROM  " + tableName;
            statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Object[] doubleArr = new Double[]{345.8};
            conn.createArrayOf("DOUBLE", doubleArr);
            Double result = rs.getDouble(1);
            Assert.assertEquals((Object)doubleArr[0], (Object)result);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpsertSelectWithSelectAsSubQuery1() throws Exception {
        String tenantId = Array1IT.getOrganizationId();
        String table1 = Array1IT.createTableWithArray(Array1IT.getUrl(), Array1IT.getDefaultSplits(tenantId), null);
        try (Connection conn = null;){
            String table2 = Array1IT.createSimpleTableWithArray(Array1IT.getUrl(), Array1IT.getDefaultSplits(tenantId), null);
            Array1IT.initSimpleArrayTable(table2, tenantId, null, false);
            Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
            conn = DriverManager.getConnection(Array1IT.getUrl(), props);
            String query = "upsert into " + table1 + " (ORGANIZATION_ID,ENTITY_ID,a_double_array) SELECT organization_id, entity_id, a_double_array  FROM " + table2 + " WHERE a_double_array[2] = 89.96";
            PreparedStatement statement = conn.prepareStatement(query);
            int executeUpdate = statement.executeUpdate();
            Assert.assertEquals((long)1L, (long)executeUpdate);
            conn.commit();
            statement.close();
            conn.close();
            props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
            conn = DriverManager.getConnection(Array1IT.getUrl(), props);
            query = "SELECT ARRAY_ELEM(a_double_array,2) FROM " + table1;
            statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Double[] doubleArr = new Double[]{89.96};
            Double result = rs.getDouble(1);
            Assert.assertEquals((Object)result, (Object)doubleArr[0]);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testArraySelectWithORCondition() throws Exception {
        String tenantId = Array1IT.getOrganizationId();
        try (Connection conn = null;){
            String table = Array1IT.createSimpleTableWithArray(Array1IT.getUrl(), Array1IT.getDefaultSplits(tenantId), null);
            Array1IT.initSimpleArrayTable(table, tenantId, null, false);
            Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
            conn = DriverManager.getConnection(Array1IT.getUrl(), props);
            String query = "SELECT a_double_array[1]  FROM " + table + " WHERE a_double_array[2] = 89.96 or a_char_array[0] = 'a'";
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Double[] doubleArr = new Double[]{64.87};
            Double result = rs.getDouble(1);
            Assert.assertEquals((Object)result, (Object)doubleArr[0]);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testArraySelectWithANY() throws Exception {
        String tenantId = Array1IT.getOrganizationId();
        try (Connection conn = null;){
            String table = Array1IT.createSimpleTableWithArray(Array1IT.getUrl(), Array1IT.getDefaultSplits(tenantId), null);
            Array1IT.initSimpleArrayTable(table, tenantId, null, false);
            Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
            conn = DriverManager.getConnection(Array1IT.getUrl(), props);
            String query = "SELECT a_double_array[1]  FROM " + table + " WHERE CAST(89.96 AS DOUBLE) = ANY(a_double_array)";
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Double[] doubleArr = new Double[]{64.87};
            Double result = rs.getDouble(1);
            Assert.assertEquals((Object)result, (Object)doubleArr[0]);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testArraySelectWithALL() throws Exception {
        String tenantId = Array1IT.getOrganizationId();
        try (Connection conn = null;){
            String table = Array1IT.createSimpleTableWithArray(Array1IT.getUrl(), Array1IT.getDefaultSplits(tenantId), null);
            Array1IT.initSimpleArrayTable(table, tenantId, null, false);
            Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
            conn = DriverManager.getConnection(Array1IT.getUrl(), props);
            String query = "SELECT a_double_array[1]  FROM " + table + " WHERE CAST(64.87 as DOUBLE) = ALL(a_double_array)";
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testArraySelectWithANYCombinedWithOR() throws Exception {
        String tenantId = Array1IT.getOrganizationId();
        try (Connection conn = null;){
            String table = Array1IT.createSimpleTableWithArray(Array1IT.getUrl(), Array1IT.getDefaultSplits(tenantId), null);
            Array1IT.initSimpleArrayTable(table, tenantId, null, false);
            Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
            conn = DriverManager.getConnection(Array1IT.getUrl(), props);
            String query = "SELECT a_double_array[1]  FROM " + table + " WHERE  a_char_array[0] = 'f' or CAST(89.96 AS DOUBLE) > ANY(a_double_array)";
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Double[] doubleArr = new Double[]{64.87};
            Double result = rs.getDouble(1);
            Assert.assertEquals((Object)result, (Object)doubleArr[0]);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testArraySelectWithALLCombinedWithOR() throws Exception {
        String tenantId = Array1IT.getOrganizationId();
        try (Connection conn = null;){
            String table = Array1IT.createSimpleTableWithArray(Array1IT.getUrl(), Array1IT.getDefaultSplits(tenantId), null);
            Array1IT.initSimpleArrayTable(table, tenantId, null, false);
            Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
            conn = DriverManager.getConnection(Array1IT.getUrl(), props);
            String query = "SELECT a_double_array[1], a_double_array[2]  FROM " + table + " WHERE  a_char_array[0] = 'f' or CAST(100.0 AS DOUBLE) > ALL(a_double_array)";
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Double[] doubleArr = new Double[]{64.87};
            Double result = rs.getDouble(1);
            Assert.assertEquals((Object)result, (Object)doubleArr[0]);
            doubleArr = new Double[]{89.96};
            result = rs.getDouble(2);
            Assert.assertEquals((Object)result, (Object)doubleArr[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testArraySelectWithANYUsingVarLengthArray() throws Exception {
        try (Connection conn = null;){
            String tenantId = Array1IT.getOrganizationId();
            String table = Array1IT.createTableWithArray(Array1IT.getUrl(), Array1IT.getDefaultSplits(tenantId), null);
            Array1IT.initTablesWithArrays(table, tenantId, null, false, Array1IT.getUrl());
            Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
            conn = DriverManager.getConnection(Array1IT.getUrl(), props);
            String query = "SELECT a_string_array[1]  FROM " + table + " WHERE 'XYZWER' = ANY(a_string_array)";
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            String[] strArr = new String[]{"ABC"};
            String result = rs.getString(1);
            Assert.assertEquals((Object)result, (Object)strArr[0]);
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT a_string_array[1]  FROM " + table + " WHERE 'AB' = ANY(a_string_array)";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            result = rs.getString(1);
            Assert.assertEquals((Object)result, (Object)strArr[0]);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelectWithArrayWithColumnRef() throws Exception {
        String tenantId = Array1IT.getOrganizationId();
        String table = Array1IT.createTableWithArray(Array1IT.getUrl(), Array1IT.getDefaultSplits(tenantId), null);
        Array1IT.initTablesWithArrays(table, tenantId, null, false, Array1IT.getUrl());
        String query = "SELECT a_integer,ARRAY[1,2,a_integer] FROM " + table + " where organization_id =  '" + tenantId + "'";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(Array1IT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            int val = rs.getInt(1);
            Assert.assertEquals((long)val, (long)1L);
            Array array = rs.getArray(2);
            Object[] intArr = new Integer[]{1, 2, 1};
            Array resultArr = conn.createArrayOf("INTEGER", intArr);
            Assert.assertEquals((Object)resultArr, (Object)array);
            Assert.assertEquals((Object)"[1, 2, 1]", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelectWithArrayWithColumnRefWithVarLengthArray() throws Exception {
        String tenantId = Array1IT.getOrganizationId();
        String table = Array1IT.createTableWithArray(Array1IT.getUrl(), Array1IT.getDefaultSplits(tenantId), null);
        Array1IT.initTablesWithArrays(table, tenantId, null, false, Array1IT.getUrl());
        String query = "SELECT b_string,ARRAY['abc','defgh',b_string] FROM " + table + " where organization_id =  '" + tenantId + "'";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(Array1IT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            String val = rs.getString(1);
            Assert.assertEquals((Object)val, (Object)"b");
            Array array = rs.getArray(2);
            Object[] strArr = new String[]{"abc", "defgh", "b"};
            Array resultArr = conn.createArrayOf("VARCHAR", strArr);
            Assert.assertEquals((Object)resultArr, (Object)array);
            String expectedPrefix = "['abc', 'defgh', 'b";
            Assert.assertTrue((String)("Expected to start with " + expectedPrefix), (boolean)rs.getString(2).startsWith(expectedPrefix));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelectWithArrayWithColumnRefWithVarLengthArrayWithNullValue() throws Exception {
        String tenantId = Array1IT.getOrganizationId();
        String table = Array1IT.createTableWithArray(Array1IT.getUrl(), Array1IT.getDefaultSplits(tenantId), null);
        Array1IT.initTablesWithArrays(table, tenantId, null, false, Array1IT.getUrl());
        String query = "SELECT b_string,ARRAY['abc',null,'bcd',null,null,b_string] FROM " + table + " where organization_id =  '" + tenantId + "'";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(Array1IT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            String val = rs.getString(1);
            Assert.assertEquals((Object)val, (Object)"b");
            Array array = rs.getArray(2);
            Object[] strArr = new String[]{"abc", null, "bcd", null, null, "b"};
            Array resultArr = conn.createArrayOf("VARCHAR", strArr);
            Assert.assertEquals((Object)resultArr, (Object)array);
            String expectedPrefix = "['abc', null, 'bcd', null, null, 'b";
            Assert.assertTrue((String)("Expected to start with " + expectedPrefix), (boolean)rs.getString(2).startsWith(expectedPrefix));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpsertSelectWithColumnRef() throws Exception {
        String tenantId = Array1IT.getOrganizationId();
        String table1 = Array1IT.createTableWithArray(Array1IT.getUrl(), Array1IT.getDefaultSplits(tenantId), null);
        try (Connection conn = null;){
            String table2 = Array1IT.createSimpleTableWithArray(Array1IT.getUrl(), Array1IT.getDefaultSplits(tenantId), null);
            Array1IT.initSimpleArrayTable(table2, tenantId, null, false);
            Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
            conn = DriverManager.getConnection(Array1IT.getUrl(), props);
            String query = "upsert into " + table1 + " (ORGANIZATION_ID,ENTITY_ID, a_unsigned_double, a_double_array) SELECT organization_id, entity_id, x_double, ARRAY[23.4, 22.1, x_double]  FROM " + table2 + " WHERE a_double_array[2] = 89.96";
            PreparedStatement statement = conn.prepareStatement(query);
            int executeUpdate = statement.executeUpdate();
            Assert.assertEquals((long)1L, (long)executeUpdate);
            conn.commit();
            statement.close();
            conn.close();
            props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
            conn = DriverManager.getConnection(Array1IT.getUrl(), props);
            query = "SELECT ARRAY_ELEM(a_double_array,2) FROM " + table1;
            statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Double[] doubleArr = new Double[]{22.1};
            Double result = rs.getDouble(1);
            Assert.assertEquals((Object)result, (Object)doubleArr[0]);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCharArraySpecificIndex() throws Exception {
        String tenantId = Array1IT.getOrganizationId();
        String table = Array1IT.createSimpleTableWithArray(Array1IT.getUrl(), Array1IT.getDefaultSplits(tenantId), null);
        Array1IT.initSimpleArrayTable(table, tenantId, null, false);
        String query = "SELECT a_char_array[2] FROM " + table;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(Array1IT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            String[] charArr = new String[]{"b"};
            String result = rs.getString(1);
            Assert.assertEquals((Object)charArr[0], (Object)result);
        }
    }

    @Test
    public void testArrayWithDescOrder() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(Array1IT.getUrl(), props);
        String table = Array1IT.generateUniqueName();
        conn.createStatement().execute("CREATE TABLE  " + table + "  ( k VARCHAR, a_string_array VARCHAR(100) ARRAY[4], b_string_array VARCHAR(100) ARRAY[4] \n CONSTRAINT pk PRIMARY KEY (k, b_string_array DESC)) \n");
        conn.close();
        conn = DriverManager.getConnection(Array1IT.getUrl(), props);
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + table + " VALUES(?,?,?)");
        stmt.setString(1, "a");
        Object[] s = new String[]{"abc", "def", "ghi", "jkll", null, null, "xxx"};
        Array array = conn.createArrayOf("VARCHAR", s);
        stmt.setArray(2, array);
        s = new String[]{"abc", "def", "ghi", "jkll", null, null, null, "xxx"};
        array = conn.createArrayOf("VARCHAR", s);
        stmt.setArray(3, array);
        stmt.execute();
        conn.commit();
        conn.close();
        conn = DriverManager.getConnection(Array1IT.getUrl(), props);
        ResultSet rs = conn.createStatement().executeQuery("SELECT b_string_array FROM  " + table);
        Assert.assertTrue((boolean)rs.next());
        PhoenixArray strArr = (PhoenixArray)rs.getArray(1);
        Assert.assertEquals((Object)array, (Object)strArr);
        Assert.assertEquals((Object)"['abc', 'def', 'ghi', 'jkll', null, null, null, 'xxx']", (Object)rs.getString(1));
        conn.close();
    }

    @Test
    public void testArrayWithFloatArray() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(Array1IT.getUrl(), props);
        String table = Array1IT.generateUniqueName();
        conn.createStatement().execute("CREATE TABLE  " + table + "  ( k VARCHAR PRIMARY KEY, a Float ARRAY[])");
        conn.close();
        conn = DriverManager.getConnection(Array1IT.getUrl(), props);
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO  " + table + "  VALUES('a',ARRAY[2.0,3.0])");
        int res = stmt.executeUpdate();
        Assert.assertEquals((long)1L, (long)res);
        conn.commit();
        conn.close();
        conn = DriverManager.getConnection(Array1IT.getUrl(), props);
        ResultSet rs = conn.createStatement().executeQuery("SELECT ARRAY_ELEM(a,2) FROM  " + table);
        Assert.assertTrue((boolean)rs.next());
        Float f = new Float(3.0);
        Assert.assertEquals((Object)f, (Object)Float.valueOf(rs.getFloat(1)));
        conn.close();
    }

    @Test
    public void testArrayWithVarCharArray() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(Array1IT.getUrl(), props);
        String table = Array1IT.generateUniqueName();
        conn.createStatement().execute("CREATE TABLE  " + table + "  ( k VARCHAR PRIMARY KEY, a VARCHAR ARRAY[])");
        conn.close();
        conn = DriverManager.getConnection(Array1IT.getUrl(), props);
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO  " + table + "  VALUES('a',ARRAY['a',null])");
        int res = stmt.executeUpdate();
        Assert.assertEquals((long)1L, (long)res);
        conn.commit();
        conn.close();
        conn = DriverManager.getConnection(Array1IT.getUrl(), props);
        ResultSet rs = conn.createStatement().executeQuery("SELECT ARRAY_ELEM(a,2) FROM  " + table);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals(null, (Object)rs.getString(1));
        conn.close();
    }

    @Test
    public void testArraySelectSingleArrayElemWithCast() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(Array1IT.getUrl(), props);
        String table = Array1IT.generateUniqueName();
        conn.createStatement().execute("CREATE TABLE  " + table + "  ( k VARCHAR PRIMARY KEY, a bigint ARRAY[])");
        conn.close();
        conn = DriverManager.getConnection(Array1IT.getUrl(), props);
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO  " + table + "  VALUES(?,?)");
        stmt.setString(1, "a");
        Object[] s = new Long[]{1L, 2L};
        Array array = conn.createArrayOf("BIGINT", s);
        stmt.setArray(2, array);
        stmt.execute();
        conn.commit();
        conn.close();
        conn = DriverManager.getConnection(Array1IT.getUrl(), props);
        ResultSet rs = conn.createStatement().executeQuery("SELECT k, CAST(a[2] AS DOUBLE) FROM  " + table);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Double d = new Double(2.0);
        Assert.assertEquals((Object)d, (Object)rs.getDouble(2));
        conn.close();
    }

    @Test
    public void testArraySelectGetString() throws Exception {
        String tenantId = Array1IT.getOrganizationId();
        String tableName = Array1IT.createTableWithAllArrayTypes(Array1IT.getUrl(), Array1IT.getDefaultSplits(tenantId), null);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(Array1IT.getUrl(), props);
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + "(ORGANIZATION_ID, ENTITY_ID, BOOLEAN_ARRAY, BYTE_ARRAY, DOUBLE_ARRAY, FLOAT_ARRAY, INT_ARRAY, LONG_ARRAY, SHORT_ARRAY, STRING_ARRAY)\nVALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        stmt.setString(1, tenantId);
        stmt.setString(2, "00A123122312312");
        Array boolArray = conn.createArrayOf("BOOLEAN", new Boolean[]{true, false});
        int boolIndex = 3;
        stmt.setArray(boolIndex, boolArray);
        Array byteArray = conn.createArrayOf("TINYINT", new Byte[]{(byte)11, (byte)22});
        int byteIndex = 4;
        stmt.setArray(byteIndex, byteArray);
        Array doubleArray = conn.createArrayOf("DOUBLE", new Double[]{67.78, 78.89});
        int doubleIndex = 5;
        stmt.setArray(doubleIndex, doubleArray);
        Array floatArray = conn.createArrayOf("FLOAT", new Float[]{Float.valueOf(12.23f), Float.valueOf(45.56f)});
        int floatIndex = 6;
        stmt.setArray(floatIndex, floatArray);
        Array intArray = conn.createArrayOf("INTEGER", new Integer[]{5555, 6666});
        int intIndex = 7;
        stmt.setArray(intIndex, intArray);
        Array longArray = conn.createArrayOf("BIGINT", new Long[]{7777777L, 8888888L});
        int longIndex = 8;
        stmt.setArray(longIndex, longArray);
        Array shortArray = conn.createArrayOf("SMALLINT", new Short[]{(short)333, (short)444});
        int shortIndex = 9;
        stmt.setArray(shortIndex, shortArray);
        Array stringArray = conn.createArrayOf("VARCHAR", new String[]{"a", "b"});
        int stringIndex = 10;
        stmt.setArray(stringIndex, stringArray);
        stmt.execute();
        conn.commit();
        conn.close();
        conn = DriverManager.getConnection(Array1IT.getUrl(), props);
        stmt = conn.prepareStatement("SELECT organization_id, entity_id, boolean_array, byte_array, double_array, float_array, int_array, long_array, short_array, string_array FROM " + tableName);
        TestUtil.analyzeTable(conn, tableName);
        ResultSet rs = stmt.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)tenantId, (Object)rs.getString(1));
        Assert.assertEquals((Object)"00A123122312312", (Object)rs.getString(2));
        this.assertArrayGetString(rs, boolIndex, boolArray, "true, false");
        this.assertArrayGetString(rs, byteIndex, byteArray, "11, 22");
        this.assertArrayGetString(rs, doubleIndex, doubleArray, "67.78, 78.89");
        this.assertArrayGetString(rs, floatIndex, floatArray, "12.23, 45.56");
        this.assertArrayGetString(rs, intIndex, intArray, "5555, 6666");
        this.assertArrayGetString(rs, longIndex, longArray, "7777777, 8888888");
        this.assertArrayGetString(rs, shortIndex, shortArray, "333, 444");
        this.assertArrayGetString(rs, stringIndex, stringArray, "'a', 'b'");
        conn.close();
    }

    @Test
    public void testArrayWithCast() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(Array1IT.getUrl(), props);
        String table = Array1IT.generateUniqueName();
        conn.createStatement().execute("CREATE TABLE " + table + " ( k VARCHAR PRIMARY KEY, a bigint ARRAY[])");
        conn.close();
        conn = DriverManager.getConnection(Array1IT.getUrl(), props);
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO  " + table + "  VALUES(?,?)");
        stmt.setString(1, "a");
        Object[] s = new Long[]{1L, 2L};
        Array array = conn.createArrayOf("BIGINT", s);
        stmt.setArray(2, array);
        stmt.execute();
        conn.commit();
        conn.close();
        conn = DriverManager.getConnection(Array1IT.getUrl(), props);
        ResultSet rs = conn.createStatement().executeQuery("SELECT CAST(a AS DOUBLE []) FROM  " + table);
        Assert.assertTrue((boolean)rs.next());
        Object[] d = new Double[]{1.0, 2.0};
        array = conn.createArrayOf("DOUBLE", d);
        PhoenixArray arr = (PhoenixArray)rs.getArray(1);
        Assert.assertEquals((Object)array, (Object)arr);
        Assert.assertEquals((Object)"[1.0, 2.0]", (Object)rs.getString(1));
        conn.close();
    }

    @Test
    public void testArrayWithCastForVarLengthArr() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(Array1IT.getUrl(), props);
        String table = Array1IT.generateUniqueName();
        conn.createStatement().execute("CREATE TABLE  " + table + "  ( k VARCHAR PRIMARY KEY, a VARCHAR(5) ARRAY)");
        conn.close();
        conn = DriverManager.getConnection(Array1IT.getUrl(), props);
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO  " + table + "  VALUES(?,?)");
        stmt.setString(1, "a");
        Object[] s = new String[]{"1", "2"};
        PhoenixArray array = (PhoenixArray)conn.createArrayOf("VARCHAR", s);
        stmt.setArray(2, (Array)array);
        stmt.execute();
        conn.commit();
        conn.close();
        conn = DriverManager.getConnection(Array1IT.getUrl(), props);
        ResultSet rs = conn.createStatement().executeQuery("SELECT CAST(a AS CHAR ARRAY) FROM  " + table);
        Assert.assertTrue((boolean)rs.next());
        PhoenixArray arr = (PhoenixArray)rs.getArray(1);
        String[] array2 = (String[])array.getArray();
        String[] array3 = (String[])arr.getArray();
        Assert.assertEquals((Object)array2[0], (Object)array3[0]);
        Assert.assertEquals((Object)array2[1], (Object)array3[1]);
        Assert.assertEquals((Object)"['1', '2']", (Object)rs.getString(1));
        conn.close();
    }

    @Test
    public void testGetSetObject() throws SQLException {
        String table = Array1IT.generateUniqueName();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Object[] s = new String[]{"1", "2"};
        try (Connection conn = DriverManager.getConnection(Array1IT.getUrl(), props);
             Statement stmt = conn.createStatement();
             PreparedStatement insertStmt = conn.prepareStatement("upsert into " + table + "(k, a) values (?,?)");){
            stmt.executeUpdate("CREATE TABLE  " + table + "  ( k VARCHAR PRIMARY KEY, a VARCHAR(5) ARRAY)");
            PhoenixArray phoenixArray = (PhoenixArray)conn.createArrayOf("VARCHAR", s);
            insertStmt.setString(1, "a");
            insertStmt.setArray(2, (Array)phoenixArray);
            insertStmt.executeUpdate();
            insertStmt.setString(1, "b");
            insertStmt.setObject(2, phoenixArray);
            insertStmt.executeUpdate();
            conn.commit();
            try {
                insertStmt.setString(1, "c");
                insertStmt.setObject(2, s);
                insertStmt.executeUpdate();
                conn.commit();
                Assert.fail((String)"must only accept java.sql.Array objects");
            }
            catch (Exception exception) {
                // empty catch block
            }
            ResultSet rs = stmt.executeQuery("select * from " + table);
            int rows = 0;
            while (rs.next()) {
                ++rows;
                Assert.assertEquals((Object)phoenixArray, (Object)rs.getObject(2));
                Assert.assertEquals((Object)phoenixArray, (Object)rs.getObject(2, Array.class));
                Assert.assertEquals((Object)phoenixArray, (Object)rs.getArray(2));
                try {
                    rs.getObject(2, String[].class);
                    Assert.fail((String)"must only accept java.sql.Array subclasses");
                }
                catch (SQLException sQLException) {}
            }
            Assert.assertEquals((long)2L, (long)rows);
        }
    }
}

