/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.thirdparty.com.google.common.primitives.Doubles;
import org.apache.phoenix.thirdparty.com.google.common.primitives.Floats;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class ArithmeticQueryIT
extends ParallelStatsDisabledIT {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDecimalUpsertValue() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        conn.setAutoCommit(false);
        try (Connection conn = DriverManager.getConnection(ArithmeticQueryIT.getUrl(), props);){
            String testDecimalArithmetic = ArithmeticQueryIT.generateUniqueName();
            String ddl = "CREATE TABLE " + testDecimalArithmetic + "  (pk VARCHAR NOT NULL PRIMARY KEY, col1 DECIMAL(31,0), col2 DECIMAL(5), col3 DECIMAL(5,2), col4 DECIMAL)";
            ArithmeticQueryIT.createTestTable(ArithmeticQueryIT.getUrl(), ddl);
            String query = "UPSERT INTO " + testDecimalArithmetic + "(pk, col1, col2, col3, col4) VALUES(?,?,?,?,?)";
            PreparedStatement stmt = conn.prepareStatement(query);
            stmt.setString(1, "valueOne");
            stmt.setBigDecimal(2, new BigDecimal("123456789123456789"));
            stmt.setBigDecimal(3, new BigDecimal("12345"));
            stmt.setBigDecimal(4, new BigDecimal("12.34"));
            stmt.setBigDecimal(5, new BigDecimal("12345.6789"));
            stmt.execute();
            conn.commit();
            query = "SELECT col1, col2, col3, col4 FROM " + testDecimalArithmetic + " WHERE pk = 'valueOne'";
            stmt = conn.prepareStatement(query);
            ResultSet rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)new BigDecimal("123456789123456789"), (Object)rs.getBigDecimal(1));
            Assert.assertEquals((Object)new BigDecimal("12345"), (Object)rs.getBigDecimal(2));
            Assert.assertEquals((Object)new BigDecimal("12.34"), (Object)rs.getBigDecimal(3));
            Assert.assertEquals((Object)new BigDecimal("12345.6789"), (Object)rs.getBigDecimal(4));
            Assert.assertFalse((boolean)rs.next());
            query = "UPSERT INTO " + testDecimalArithmetic + "(pk, col1, col2, col3) VALUES(?,?,?,?)";
            stmt = conn.prepareStatement(query);
            stmt.setString(1, "valueTwo");
            stmt.setBigDecimal(2, new BigDecimal("1234567890123456789012345678901.12345"));
            stmt.setBigDecimal(3, new BigDecimal("12345.6789"));
            stmt.setBigDecimal(4, new BigDecimal("123.45678"));
            stmt.execute();
            conn.commit();
            query = "SELECT col1, col2, col3 FROM " + testDecimalArithmetic + " WHERE pk = 'valueTwo'";
            stmt = conn.prepareStatement(query);
            rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)new BigDecimal("1234567890123456789012345678901"), (Object)rs.getBigDecimal(1));
            Assert.assertEquals((Object)new BigDecimal("12345"), (Object)rs.getBigDecimal(2));
            Assert.assertEquals((Object)new BigDecimal("123.45"), (Object)rs.getBigDecimal(3));
            Assert.assertFalse((boolean)rs.next());
            try {
                query = "UPSERT INTO " + testDecimalArithmetic + "(pk, col1, col2, col3) VALUES(?,?,?,?)";
                stmt = conn.prepareStatement(query);
                stmt.setString(1, "badValues");
                stmt.setBigDecimal(2, new BigDecimal("12345678901234567890123456789012"));
                stmt.setBigDecimal(3, new BigDecimal("12345"));
                stmt.setBigDecimal(4, new BigDecimal("123.45"));
                stmt.execute();
                conn.commit();
                Assert.fail((String)"Should have caught bad values.");
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.DATA_EXCEEDS_MAX_CAPACITY.getErrorCode(), (long)e.getErrorCode());
            }
            try {
                query = "UPSERT INTO " + testDecimalArithmetic + "(pk, col1, col2, col3) VALUES(?,?,?,?)";
                stmt = conn.prepareStatement(query);
                stmt.setString(1, "badValues");
                stmt.setBigDecimal(2, new BigDecimal("123456"));
                stmt.setBigDecimal(3, new BigDecimal("123456"));
                stmt.setBigDecimal(4, new BigDecimal("123.45"));
                stmt.execute();
                conn.commit();
                Assert.fail((String)"Should have caught bad values.");
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.DATA_EXCEEDS_MAX_CAPACITY.getErrorCode(), (long)e.getErrorCode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDecimalUpsertSelect() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        conn.setAutoCommit(false);
        try (Connection conn = DriverManager.getConnection(ArithmeticQueryIT.getUrl(), props);){
            String source = ArithmeticQueryIT.generateUniqueName();
            String ddl = "CREATE TABLE " + source + " (pk VARCHAR NOT NULL PRIMARY KEY, col1 DECIMAL(5,2), col2 DECIMAL(5,1), col3 DECIMAL(5,2), col4 DECIMAL(4,4))";
            ArithmeticQueryIT.createTestTable(ArithmeticQueryIT.getUrl(), ddl);
            String target = ArithmeticQueryIT.generateUniqueName();
            ddl = "CREATE TABLE " + target + " (pk VARCHAR NOT NULL PRIMARY KEY, col1 DECIMAL(5,1), col2 DECIMAL(5,2), col3 DECIMAL(4,4))";
            ArithmeticQueryIT.createTestTable(ArithmeticQueryIT.getUrl(), ddl);
            String query = "UPSERT INTO " + source + "(pk, col1) VALUES(?,?)";
            PreparedStatement stmt = conn.prepareStatement(query);
            stmt.setString(1, "1");
            stmt.setBigDecimal(2, new BigDecimal("100.12"));
            stmt.execute();
            conn.commit();
            stmt.setString(1, "2");
            stmt.setBigDecimal(2, new BigDecimal("100.34"));
            stmt.execute();
            conn.commit();
            query = "UPSERT INTO " + target + "(pk, col2) SELECT pk, col1 from " + source;
            stmt = conn.prepareStatement(query);
            stmt.execute();
            conn.commit();
            query = "SELECT col2 FROM " + target;
            stmt = conn.prepareStatement(query);
            ResultSet rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)new BigDecimal("100.12"), (Object)rs.getBigDecimal(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)new BigDecimal("100.34"), (Object)rs.getBigDecimal(1));
            Assert.assertFalse((boolean)rs.next());
            query = "UPSERT INTO " + target + "(pk, col1) SELECT pk, col1 from " + source;
            stmt = conn.prepareStatement(query);
            stmt.execute();
            conn.commit();
            query = "SELECT col1 FROM " + target;
            stmt = conn.prepareStatement(query);
            rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)new BigDecimal("100.1"), (Object)rs.getBigDecimal(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)new BigDecimal("100.3"), (Object)rs.getBigDecimal(1));
            Assert.assertFalse((boolean)rs.next());
            try {
                query = "UPSERT INTO " + target + "(pk, col3) SELECT pk, col1 from " + source;
                stmt = conn.prepareStatement(query);
                stmt.execute();
                conn.commit();
                Assert.fail((String)"Should have caught bad upsert.");
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.DATA_EXCEEDS_MAX_CAPACITY.getErrorCode(), (long)e.getErrorCode());
            }
            conn.setAutoCommit(true);
            query = "UPSERT INTO " + source + "(pk, col3) SELECT pk, col1 from " + source;
            stmt = conn.prepareStatement(query);
            stmt.execute();
            conn.commit();
            query = "SELECT col3 FROM " + source;
            stmt = conn.prepareStatement(query);
            rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)new BigDecimal("100.12"), (Object)rs.getBigDecimal(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)new BigDecimal("100.34"), (Object)rs.getBigDecimal(1));
            Assert.assertFalse((boolean)rs.next());
            query = "UPSERT INTO " + source + "(pk, col2) SELECT pk, col1 from " + source;
            stmt = conn.prepareStatement(query);
            stmt.execute();
            conn.commit();
            query = "SELECT col2 FROM " + source;
            stmt = conn.prepareStatement(query);
            rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)new BigDecimal("100.1"), (Object)rs.getBigDecimal(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)new BigDecimal("100.3"), (Object)rs.getBigDecimal(1));
            Assert.assertFalse((boolean)rs.next());
            query = "UPSERT INTO " + source + "(pk, col4) SELECT pk, col1 from " + source;
            stmt = conn.prepareStatement(query);
            try {
                stmt.execute();
                conn.commit();
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.DATA_EXCEEDS_MAX_CAPACITY.getErrorCode(), (long)e.getErrorCode());
            }
            query = "SELECT col4 FROM " + source;
            stmt = conn.prepareStatement(query);
            rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertNull((Object)rs.getBigDecimal(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertNull((Object)rs.getBigDecimal(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDecimalAveraging() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        conn.setAutoCommit(false);
        try (Connection conn = DriverManager.getConnection(ArithmeticQueryIT.getUrl(), props);){
            String testDecimalArithmetic = ArithmeticQueryIT.generateUniqueName();
            String ddl = "CREATE TABLE " + testDecimalArithmetic + "  (pk VARCHAR NOT NULL PRIMARY KEY, col1 DECIMAL(31, 11), col2 DECIMAL(31,1), col3 DECIMAL(38,1))";
            ArithmeticQueryIT.createTestTable(ArithmeticQueryIT.getUrl(), ddl);
            String query = "UPSERT INTO " + testDecimalArithmetic + "(pk, col1, col2, col3) VALUES(?,?,?,?)";
            PreparedStatement stmt = conn.prepareStatement(query);
            stmt.setString(1, "1");
            stmt.setBigDecimal(2, new BigDecimal("99999999999999999999.1"));
            stmt.setBigDecimal(3, new BigDecimal("99999999999999999999.1"));
            stmt.setBigDecimal(4, new BigDecimal("9999999999999999999999999999999999999.1"));
            stmt.execute();
            conn.commit();
            stmt.setString(1, "2");
            stmt.setBigDecimal(2, new BigDecimal("0"));
            stmt.setBigDecimal(3, new BigDecimal("0"));
            stmt.setBigDecimal(4, new BigDecimal("0"));
            stmt.execute();
            conn.commit();
            stmt.setString(1, "3");
            stmt.setBigDecimal(2, new BigDecimal("0"));
            stmt.setBigDecimal(3, new BigDecimal("0"));
            stmt.setBigDecimal(4, new BigDecimal("0"));
            stmt.execute();
            conn.commit();
            query = "SELECT avg(col1) FROM " + testDecimalArithmetic;
            stmt = conn.prepareStatement(query);
            ResultSet rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            BigDecimal result = rs.getBigDecimal(1);
            Assert.assertEquals((Object)new BigDecimal("33333333333333333333.03333333333"), (Object)result);
            query = "SELECT avg(col2) FROM " + testDecimalArithmetic;
            stmt = conn.prepareStatement(query);
            rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            result = rs.getBigDecimal(1);
            Assert.assertEquals((Object)new BigDecimal("33333333333333333333.0333"), (Object)result);
            query = "SELECT avg(col3) FROM " + testDecimalArithmetic;
            stmt = conn.prepareStatement(query);
            rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            result = rs.getBigDecimal(1);
            Assert.assertEquals((Object)new BigDecimal("3333333333333333333333333333333333333"), (Object)result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRandomFunction() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        conn.setAutoCommit(false);
        try (Connection conn = DriverManager.getConnection(ArithmeticQueryIT.getUrl(), props);){
            String testRandomFunction = ArithmeticQueryIT.generateUniqueName();
            String ddl = "CREATE TABLE " + testRandomFunction + " (pk VARCHAR NOT NULL PRIMARY KEY)";
            ArithmeticQueryIT.createTestTable(ArithmeticQueryIT.getUrl(), ddl);
            conn.createStatement().execute("upsert into " + testRandomFunction + " values ('x')");
            conn.createStatement().execute("upsert into " + testRandomFunction + " values ('y')");
            conn.createStatement().execute("upsert into " + testRandomFunction + " values ('z')");
            conn.commit();
            ResultSet rs = conn.createStatement().executeQuery("select rand(), rand(), rand(1), rand(2), rand(1) from " + testRandomFunction);
            Assert.assertTrue((boolean)rs.next());
            double rand0 = rs.getDouble(1);
            double rand1 = rs.getDouble(3);
            double rand2 = rs.getDouble(4);
            Assert.assertTrue((rs.getDouble(1) != rs.getDouble(2) ? 1 : 0) != 0);
            Assert.assertTrue((rs.getDouble(2) != rs.getDouble(3) ? 1 : 0) != 0);
            Assert.assertTrue((rs.getDouble(3) == rs.getDouble(5) ? 1 : 0) != 0);
            Assert.assertTrue((rs.getDouble(4) != rs.getDouble(5) ? 1 : 0) != 0);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((rand0 != rs.getDouble(1) ? 1 : 0) != 0);
            Assert.assertTrue((rand1 != rs.getDouble(3) ? 1 : 0) != 0);
            Assert.assertTrue((rand2 != rs.getDouble(4) ? 1 : 0) != 0);
            double rand01 = rs.getDouble(1);
            double rand11 = rs.getDouble(3);
            double rand21 = rs.getDouble(4);
            Assert.assertTrue((rs.getDouble(1) != rs.getDouble(2) ? 1 : 0) != 0);
            Assert.assertTrue((rs.getDouble(2) != rs.getDouble(3) ? 1 : 0) != 0);
            Assert.assertTrue((rs.getDouble(3) == rs.getDouble(5) ? 1 : 0) != 0);
            Assert.assertTrue((rs.getDouble(4) != rs.getDouble(5) ? 1 : 0) != 0);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((rand01 != rs.getDouble(1) ? 1 : 0) != 0);
            Assert.assertTrue((rand11 != rs.getDouble(3) ? 1 : 0) != 0);
            Assert.assertTrue((rand21 != rs.getDouble(4) ? 1 : 0) != 0);
            Assert.assertTrue((rs.getDouble(1) != rs.getDouble(2) ? 1 : 0) != 0);
            Assert.assertTrue((rs.getDouble(2) != rs.getDouble(3) ? 1 : 0) != 0);
            Assert.assertTrue((rs.getDouble(3) == rs.getDouble(5) ? 1 : 0) != 0);
            Assert.assertTrue((rs.getDouble(4) != rs.getDouble(5) ? 1 : 0) != 0);
            double rand12 = rs.getDouble(3);
            rs = conn.createStatement().executeQuery("select rand(), rand(), rand(1), rand(2), rand(1) from " + testRandomFunction);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((rs.getDouble(1) != rs.getDouble(2) ? 1 : 0) != 0);
            Assert.assertTrue((rs.getDouble(2) != rs.getDouble(3) ? 1 : 0) != 0);
            Assert.assertTrue((rs.getDouble(3) == rs.getDouble(5) ? 1 : 0) != 0);
            Assert.assertTrue((rs.getDouble(4) != rs.getDouble(5) ? 1 : 0) != 0);
            Assert.assertTrue((rand0 != rs.getDouble(1) ? 1 : 0) != 0);
            Assert.assertTrue((rand1 == rs.getDouble(3) ? 1 : 0) != 0);
            Assert.assertTrue((rand2 == rs.getDouble(4) ? 1 : 0) != 0);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((rand01 != rs.getDouble(1) ? 1 : 0) != 0);
            Assert.assertTrue((rand11 == rs.getDouble(3) ? 1 : 0) != 0);
            Assert.assertTrue((rand21 == rs.getDouble(4) ? 1 : 0) != 0);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((rand12 == rs.getDouble(3) ? 1 : 0) != 0);
            String testRandomFunction1 = ArithmeticQueryIT.generateUniqueName();
            ddl = "CREATE TABLE " + testRandomFunction1 + " (pk VARCHAR NOT NULL PRIMARY KEY, v1 UNSIGNED_DOUBLE)";
            ArithmeticQueryIT.createTestTable(ArithmeticQueryIT.getUrl(), ddl);
            conn.createStatement().execute("upsert into " + testRandomFunction1 + " select pk, rand(1) from " + testRandomFunction);
            conn.commit();
            rs = conn.createStatement().executeQuery("select count(*) from " + testRandomFunction1 + " where v1 = rand(1)");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            rs = conn.createStatement().executeQuery("select count(*) from " + testRandomFunction1 + " where v1 = rand(2)");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)0L, (long)rs.getInt(1));
            conn.createStatement().execute("delete from " + testRandomFunction1 + " where v1 = rand(2)");
            conn.commit();
            rs = conn.createStatement().executeQuery("select count(*) from " + testRandomFunction1 + " where v1 = rand(1)");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            conn.setAutoCommit(true);
            conn.createStatement().execute("upsert into " + testRandomFunction1 + " select pk, rand(2) from " + testRandomFunction1);
            rs = conn.createStatement().executeQuery("select count(*) from " + testRandomFunction1 + " where v1 = rand(1)");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)0L, (long)rs.getInt(1));
            rs = conn.createStatement().executeQuery("select count(*) from " + testRandomFunction1 + " where v1 = rand(2)");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            conn.createStatement().execute("delete from " + testRandomFunction1 + " where v1 = rand(2)");
            rs = conn.createStatement().executeQuery("select count(*) from " + testRandomFunction1 + " where v1 = rand(2)");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)0L, (long)rs.getInt(1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDecimalArithmeticWithIntAndLong() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        conn.setAutoCommit(false);
        try (Connection conn = DriverManager.getConnection(ArithmeticQueryIT.getUrl(), props);){
            String testDecimalArithmetic = ArithmeticQueryIT.generateUniqueName();
            String ddl = "CREATE TABLE " + testDecimalArithmetic + "  (pk VARCHAR NOT NULL PRIMARY KEY, col1 DECIMAL(38,0), col2 DECIMAL(5, 2), col3 INTEGER, col4 BIGINT, col5 DECIMAL)";
            ArithmeticQueryIT.createTestTable(ArithmeticQueryIT.getUrl(), ddl);
            String query = "UPSERT INTO " + testDecimalArithmetic + "(pk, col1, col2, col3, col4, col5) VALUES(?,?,?,?,?,?)";
            PreparedStatement stmt = conn.prepareStatement(query);
            stmt.setString(1, "testValueOne");
            stmt.setBigDecimal(2, new BigDecimal("1234567890123456789012345678901"));
            stmt.setBigDecimal(3, new BigDecimal("123.45"));
            stmt.setInt(4, 10);
            stmt.setLong(5, 10L);
            stmt.setBigDecimal(6, new BigDecimal("111.111"));
            stmt.execute();
            conn.commit();
            stmt.setString(1, "testValueTwo");
            stmt.setBigDecimal(2, new BigDecimal("12345678901234567890123456789012345678"));
            stmt.setBigDecimal(3, new BigDecimal("123.45"));
            stmt.setInt(4, 10);
            stmt.setLong(5, 10L);
            stmt.setBigDecimal(6, new BigDecimal("123456789.0123456789"));
            stmt.execute();
            conn.commit();
            query = "SELECT col1 + col3 FROM " + testDecimalArithmetic + " WHERE pk='testValueOne'";
            stmt = conn.prepareStatement(query);
            ResultSet rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            BigDecimal result = rs.getBigDecimal(1);
            Assert.assertEquals((Object)new BigDecimal("1234567890123456789012345678911"), (Object)result);
            query = "SELECT col1 + col4 FROM " + testDecimalArithmetic + " WHERE pk='testValueOne'";
            stmt = conn.prepareStatement(query);
            rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            result = rs.getBigDecimal(1);
            Assert.assertEquals((Object)new BigDecimal("1234567890123456789012345678911"), (Object)result);
            query = "SELECT col2 + col3 FROM " + testDecimalArithmetic + " WHERE pk='testValueOne'";
            stmt = conn.prepareStatement(query);
            rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            result = rs.getBigDecimal(1);
            Assert.assertEquals((Object)new BigDecimal("133.45"), (Object)result);
            query = "SELECT col2 + col4 FROM " + testDecimalArithmetic + " WHERE pk='testValueOne'";
            stmt = conn.prepareStatement(query);
            rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            result = rs.getBigDecimal(1);
            Assert.assertEquals((Object)new BigDecimal("133.45"), (Object)result);
            query = "SELECT col5 + col3 FROM " + testDecimalArithmetic + " WHERE pk='testValueOne'";
            stmt = conn.prepareStatement(query);
            rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            result = rs.getBigDecimal(1);
            Assert.assertEquals((Object)new BigDecimal("121.111"), (Object)result);
            query = "SELECT col5 + col4 FROM " + testDecimalArithmetic + " WHERE pk='testValueOne'";
            stmt = conn.prepareStatement(query);
            rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            result = rs.getBigDecimal(1);
            Assert.assertEquals((Object)new BigDecimal("121.111"), (Object)result);
            query = "SELECT col1 - col3 FROM " + testDecimalArithmetic + " WHERE pk='testValueOne'";
            stmt = conn.prepareStatement(query);
            rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            result = rs.getBigDecimal(1);
            Assert.assertEquals((Object)new BigDecimal("1234567890123456789012345678891"), (Object)result);
            query = "SELECT col1 - col4 FROM " + testDecimalArithmetic + " WHERE pk='testValueOne'";
            stmt = conn.prepareStatement(query);
            rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            result = rs.getBigDecimal(1);
            Assert.assertEquals((Object)new BigDecimal("1234567890123456789012345678891"), (Object)result);
            query = "SELECT col2 - col3 FROM " + testDecimalArithmetic + " WHERE pk='testValueOne'";
            stmt = conn.prepareStatement(query);
            rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            result = rs.getBigDecimal(1);
            Assert.assertEquals((Object)new BigDecimal("113.45"), (Object)result);
            query = "SELECT col2 - col4 FROM " + testDecimalArithmetic + " WHERE pk='testValueOne'";
            stmt = conn.prepareStatement(query);
            rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            result = rs.getBigDecimal(1);
            Assert.assertEquals((Object)new BigDecimal("113.45"), (Object)result);
            query = "SELECT col5 - col3 FROM " + testDecimalArithmetic + " WHERE pk='testValueOne'";
            stmt = conn.prepareStatement(query);
            rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            result = rs.getBigDecimal(1);
            Assert.assertEquals((Object)new BigDecimal("101.111"), (Object)result);
            query = "SELECT col5 - col4 FROM " + testDecimalArithmetic + " WHERE pk='testValueOne'";
            stmt = conn.prepareStatement(query);
            rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            result = rs.getBigDecimal(1);
            Assert.assertEquals((Object)new BigDecimal("101.111"), (Object)result);
            query = "SELECT col1 * col3 FROM " + testDecimalArithmetic + " WHERE pk='testValueOne'";
            stmt = conn.prepareStatement(query);
            rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            result = rs.getBigDecimal(1);
            Assert.assertEquals((Object)new BigDecimal("1.234567890123456789012345678901E+31"), (Object)result);
            query = "SELECT col1 * col4 FROM " + testDecimalArithmetic + " WHERE pk='testValueOne'";
            stmt = conn.prepareStatement(query);
            rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            result = rs.getBigDecimal(1);
            Assert.assertEquals((Object)new BigDecimal("1.234567890123456789012345678901E+31"), (Object)result);
            query = "SELECT col1 * col3 FROM " + testDecimalArithmetic + " WHERE pk='testValueOne'";
            stmt = conn.prepareStatement(query);
            rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            result = rs.getBigDecimal(1);
            Assert.assertEquals((Object)new BigDecimal("1.234567890123456789012345678901E+31"), (Object)result);
            try {
                query = "SELECT col1 * col3 FROM " + testDecimalArithmetic + " WHERE pk='testValueTwo'";
                stmt = conn.prepareStatement(query);
                rs = stmt.executeQuery();
                Assert.assertTrue((boolean)rs.next());
                result = rs.getBigDecimal(1);
                Assert.fail((String)"Should have caught error.");
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.DATA_EXCEEDS_MAX_CAPACITY.getErrorCode(), (long)e.getErrorCode());
            }
            try {
                query = "SELECT col1 * col4 FROM " + testDecimalArithmetic + " WHERE pk='testValueTwo'";
                stmt = conn.prepareStatement(query);
                rs = stmt.executeQuery();
                Assert.assertTrue((boolean)rs.next());
                result = rs.getBigDecimal(1);
                Assert.fail((String)"Should have caught error.");
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.DATA_EXCEEDS_MAX_CAPACITY.getErrorCode(), (long)e.getErrorCode());
            }
            query = "SELECT col4 * col5 FROM " + testDecimalArithmetic + " WHERE pk='testValueOne'";
            stmt = conn.prepareStatement(query);
            rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            result = rs.getBigDecimal(1);
            Assert.assertEquals((long)0L, (long)result.compareTo(new BigDecimal("1111.11")));
            query = "SELECT col3 * col5 FROM " + testDecimalArithmetic + " WHERE pk='testValueOne'";
            stmt = conn.prepareStatement(query);
            rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            result = rs.getBigDecimal(1);
            Assert.assertEquals((long)0L, (long)result.compareTo(new BigDecimal("1111.11")));
            query = "SELECT col2 * col4 FROM " + testDecimalArithmetic + " WHERE pk='testValueOne'";
            stmt = conn.prepareStatement(query);
            rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            result = rs.getBigDecimal(1);
            Assert.assertEquals((Object)new BigDecimal("1234.5"), (Object)result);
            query = "SELECT col1 / col3 FROM " + testDecimalArithmetic + " WHERE pk='testValueOne'";
            stmt = conn.prepareStatement(query);
            rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            result = rs.getBigDecimal(1);
            Assert.assertEquals((Object)new BigDecimal("1.2345678901234567890123456789E+29"), (Object)result);
            query = "SELECT col1 / col4 FROM " + testDecimalArithmetic + " WHERE pk='testValueOne'";
            stmt = conn.prepareStatement(query);
            rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            result = rs.getBigDecimal(1);
            Assert.assertEquals((Object)new BigDecimal("1.2345678901234567890123456789E+29"), (Object)result);
            query = "SELECT col2 / col3 FROM " + testDecimalArithmetic + " WHERE pk='testValueOne'";
            stmt = conn.prepareStatement(query);
            rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            result = rs.getBigDecimal(1);
            Assert.assertEquals((Object)new BigDecimal("12.34"), (Object)result);
            query = "SELECT col2 / col4 FROM " + testDecimalArithmetic + " WHERE pk='testValueOne'";
            stmt = conn.prepareStatement(query);
            rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            result = rs.getBigDecimal(1);
            Assert.assertEquals((Object)new BigDecimal("12.34"), (Object)result);
            query = "SELECT col5 / col3 FROM " + testDecimalArithmetic + " WHERE pk='testValueOne'";
            stmt = conn.prepareStatement(query);
            rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            result = rs.getBigDecimal(1);
            Assert.assertEquals((Object)new BigDecimal("11.1111"), (Object)result);
            query = "SELECT col5 / col4 FROM " + testDecimalArithmetic + " WHERE pk='testValueOne'";
            stmt = conn.prepareStatement(query);
            rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            result = rs.getBigDecimal(1);
            Assert.assertEquals((Object)new BigDecimal("11.1111"), (Object)result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSumDouble() throws Exception {
        String tableName = "TBL_" + ArithmeticQueryIT.generateUniqueName();
        ArithmeticQueryIT.initSumDoubleValues(tableName, null, ArithmeticQueryIT.getUrl());
        String query = "SELECT SUM(d) FROM " + tableName;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ArithmeticQueryIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((Doubles.compare((double)rs.getDouble(1), (double)0.015) == 0 ? 1 : 0) != 0);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSumUnsignedDouble() throws Exception {
        String tableName = "TBL_" + ArithmeticQueryIT.generateUniqueName();
        ArithmeticQueryIT.initSumDoubleValues(tableName, null, ArithmeticQueryIT.getUrl());
        String query = "SELECT SUM(ud) FROM " + tableName;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ArithmeticQueryIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((Doubles.compare((double)rs.getDouble(1), (double)0.015) == 0 ? 1 : 0) != 0);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSumFloat() throws Exception {
        String tableName = "TBL_" + ArithmeticQueryIT.generateUniqueName();
        ArithmeticQueryIT.initSumDoubleValues(tableName, null, ArithmeticQueryIT.getUrl());
        String query = "SELECT SUM(f) FROM " + tableName;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ArithmeticQueryIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((Floats.compare((float)rs.getFloat(1), (float)0.15f) == 0 ? 1 : 0) != 0);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSumUnsignedFloat() throws Exception {
        String tableName = "TBL_" + ArithmeticQueryIT.generateUniqueName();
        ArithmeticQueryIT.initSumDoubleValues(tableName, null, ArithmeticQueryIT.getUrl());
        String query = "SELECT SUM(uf) FROM " + tableName;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ArithmeticQueryIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((Floats.compare((float)rs.getFloat(1), (float)0.15f) == 0 ? 1 : 0) != 0);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    private String initIntegerTable(Connection conn) throws SQLException {
        String arithmetic_test = ArithmeticQueryIT.generateUniqueName();
        String ddl = "CREATE TABLE " + arithmetic_test + " (six INTEGER PRIMARY KEY, four INTEGER, three INTEGER)";
        conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + arithmetic_test + " VALUES(6, 4, 3)";
        conn.createStatement().execute(dml);
        conn.commit();
        return arithmetic_test;
    }

    @Test
    public void testOrderOfOperationsAdditionSubtraction() throws Exception {
        Connection conn = DriverManager.getConnection(ArithmeticQueryIT.getUrl());
        String tableName = this.initIntegerTable(conn);
        ResultSet rs = conn.createStatement().executeQuery("SELECT six + four - three FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)7L, (long)rs.getLong(1));
        Assert.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery("SELECT four - three + six FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)7L, (long)rs.getLong(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testOrderOfOperationsAdditionMultiplication() throws Exception {
        Connection conn = DriverManager.getConnection(ArithmeticQueryIT.getUrl());
        String tableName = this.initIntegerTable(conn);
        ResultSet rs = conn.createStatement().executeQuery("SELECT six + four * three FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)18L, (long)rs.getLong(1));
        Assert.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery("SELECT four * three + six FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)18L, (long)rs.getLong(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testOrderOfOperationsAdditionDivision() throws Exception {
        Connection conn = DriverManager.getConnection(ArithmeticQueryIT.getUrl());
        String tableName = this.initIntegerTable(conn);
        ResultSet rs = conn.createStatement().executeQuery("SELECT six + four / three FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)7L, (long)rs.getLong(1));
        Assert.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery("SELECT four / three + six FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)7L, (long)rs.getLong(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testOrderOfOperationsAdditionModulus() throws Exception {
        Connection conn = DriverManager.getConnection(ArithmeticQueryIT.getUrl());
        String tableName = this.initIntegerTable(conn);
        ResultSet rs = conn.createStatement().executeQuery("SELECT six + four % three FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)7L, (long)rs.getLong(1));
        Assert.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery("SELECT four % three + six FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)7L, (long)rs.getLong(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testOrderOfOperationsSubtrationMultiplication() throws Exception {
        Connection conn = DriverManager.getConnection(ArithmeticQueryIT.getUrl());
        String tableName = this.initIntegerTable(conn);
        ResultSet rs = conn.createStatement().executeQuery("SELECT six - four * three FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)-6L, (long)rs.getLong(1));
        Assert.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery("SELECT four * three - six FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)6L, (long)rs.getLong(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testOrderOfOperationsSubtractionDivision() throws Exception {
        Connection conn = DriverManager.getConnection(ArithmeticQueryIT.getUrl());
        String tableName = this.initIntegerTable(conn);
        ResultSet rs = conn.createStatement().executeQuery("SELECT six - four / three FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)5L, (long)rs.getLong(1));
        Assert.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery("SELECT four / three - six FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)-5L, (long)rs.getLong(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testOrderOfOperationsSubtractionModulus() throws Exception {
        Connection conn = DriverManager.getConnection(ArithmeticQueryIT.getUrl());
        String tableName = this.initIntegerTable(conn);
        ResultSet rs = conn.createStatement().executeQuery("SELECT six - four % three FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)5L, (long)rs.getLong(1));
        Assert.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery("SELECT four % three - six FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)-5L, (long)rs.getLong(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testOrderOfOperationsMultiplicationDivision() throws Exception {
        Connection conn = DriverManager.getConnection(ArithmeticQueryIT.getUrl());
        String tableName = this.initIntegerTable(conn);
        ResultSet rs = conn.createStatement().executeQuery("SELECT six * four / three FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)8L, (long)rs.getLong(1));
        Assert.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery("SELECT four / three * six FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)6L, (long)rs.getLong(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testOrderOfOperationsMultiplicationModulus() throws Exception {
        Connection conn = DriverManager.getConnection(ArithmeticQueryIT.getUrl());
        String tableName = this.initIntegerTable(conn);
        ResultSet rs = conn.createStatement().executeQuery("SELECT six * four % three FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)0L, (long)rs.getLong(1));
        Assert.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery("SELECT four % three * six FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)6L, (long)rs.getLong(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testOrderOfOperationsDivisionModulus() throws Exception {
        Connection conn = DriverManager.getConnection(ArithmeticQueryIT.getUrl());
        String tableName = this.initIntegerTable(conn);
        ResultSet rs = conn.createStatement().executeQuery("SELECT six / four % three FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getLong(1));
        Assert.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery("SELECT four % three / six FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)0L, (long)rs.getLong(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testCastingOnConstantAddInArithmeticEvaluation() throws Exception {
        Connection conn = DriverManager.getConnection(ArithmeticQueryIT.getUrl());
        String testTable = ArithmeticQueryIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + testTable + " (k1 INTEGER NOT NULL, v1 INTEGER CONSTRAINT pk PRIMARY KEY (k1))";
        conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + testTable + " (k1, v1) VALUES (2, 2)";
        conn.createStatement().execute(dml);
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT k1 / (v1 + 0.5) FROM " + testTable);
        Assert.assertTrue((boolean)rs.next());
        double d = rs.getDouble(1);
        Assert.assertEquals((double)0.8, (double)d, (double)0.01);
    }

    @Test
    public void testCastingOnConstantSubInArithmeticEvaluation() throws Exception {
        Connection conn = DriverManager.getConnection(ArithmeticQueryIT.getUrl());
        String testTable = ArithmeticQueryIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + testTable + " (k1 INTEGER NOT NULL, v1 INTEGER CONSTRAINT pk PRIMARY KEY (k1))";
        conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + testTable + " (k1, v1) VALUES (2, 2)";
        conn.createStatement().execute(dml);
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT k1 / (v1 - 0.5) FROM " + testTable);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((double)1.333333333, (double)rs.getDouble(1), (double)0.001);
    }

    @Test
    public void testFloatingPointUpsert() throws Exception {
        Connection conn = DriverManager.getConnection(ArithmeticQueryIT.getUrl());
        String test = ArithmeticQueryIT.generateUniqueName();
        String ddl = "CREATE TABLE " + test + " (id VARCHAR not null primary key, name VARCHAR, lat FLOAT)";
        conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + test + "(id,name,lat) VALUES ('testid', 'testname', -1.00)";
        conn.createStatement().execute(dml);
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT lat FROM " + test);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((double)-1.0, (double)rs.getFloat(1), (double)0.001);
    }

    @Test
    public void testFloatingPointMultiplicationUpsert() throws Exception {
        Connection conn = DriverManager.getConnection(ArithmeticQueryIT.getUrl());
        String test = ArithmeticQueryIT.generateUniqueName();
        String ddl = "CREATE TABLE " + test + " (id VARCHAR not null primary key, name VARCHAR, lat FLOAT)";
        conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + test + "(id,name,lat) VALUES ('testid', 'testname', -1.00 * 1)";
        conn.createStatement().execute(dml);
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT lat FROM " + test);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((double)-1.0, (double)rs.getFloat(1), (double)0.001);
    }

    @Test
    public void testSystemTableHasDoubleForExponentialNumber() throws Exception {
        Connection conn = DriverManager.getConnection(ArithmeticQueryIT.getUrl());
        String test = ArithmeticQueryIT.generateUniqueName();
        String ddl = "CREATE TABLE " + test + " (id VARCHAR not null primary key, num FLOAT)";
        conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + test + "(id,num) VALUES ('testid', 1.2E3)";
        conn.createStatement().execute(dml);
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT 1.2E3 FROM \"SYSTEM\".\"CATALOG\" LIMIT 1");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertTrue((boolean)(rs.getObject(1) instanceof Double));
    }

    @Test
    public void testFloatingPointWithExponentialNotation() throws Exception {
        Float[] expected = new Float[]{Float.valueOf(1.5E7f), Float.valueOf(1.5E-7f), Float.valueOf(-1.5E-7f), Float.valueOf(1.2E-4f), Float.valueOf(-1.2E33f)};
        String[] values = new String[]{"1.5e7", "1.5e-7", "-1.5e-7", "12E-5", "-.12E+34"};
        ResultSet rs = this.createTableWithValues(values, "FLOAT");
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((double)expected[i].floatValue(), (double)rs.getFloat(i + 1), (double)0.001);
        }
    }

    @Test
    public void testDoubleWithExponentialNotation() throws Exception {
        Double[] expected = new Double[]{1.5E7, 1.5E-7, -1.5E-7, 1.2E-4, -6.5E-322, 1.234E55};
        String[] values = new String[]{"1.5e7", "1.5e-7", "-1.5e-7", "12E-5", "-.654E-321", ".1234E+56"};
        ResultSet rs = this.createTableWithValues(values, "DOUBLE");
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((double)expected[i], (double)rs.getDouble(i + 1), (double)0.001);
        }
    }

    private ResultSet createTableWithValues(String[] values, String valueType) throws SQLException {
        Connection conn = DriverManager.getConnection(ArithmeticQueryIT.getUrl());
        String test = ArithmeticQueryIT.generateUniqueName();
        StringBuilder ddl = new StringBuilder("CREATE TABLE " + test + " (id VARCHAR not null primary key");
        StringBuilder dmll = new StringBuilder("UPSERT INTO " + test + "(id,");
        StringBuilder dmlr = new StringBuilder(") VALUES ('testid'");
        StringBuilder select = new StringBuilder("SELECT");
        for (int i = 0; i < values.length; ++i) {
            ddl.append(", num").append(i).append(" ").append(valueType);
            dmll.append("num").append(i).append(",");
            dmlr.append(", ").append(values[i]);
            select.append(" num").append(i).append(",");
        }
        ddl.append(")");
        dmlr.append(")");
        dmll.deleteCharAt(dmll.length() - 1);
        select.deleteCharAt(select.length() - 1);
        select.append(" FROM " + test);
        conn.createStatement().execute(ddl.toString());
        conn.createStatement().execute(dmll.toString() + dmlr.toString());
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery(select.toString());
        rs.next();
        return rs;
    }
}

