/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixEmbeddedDriver;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.schema.ColumnAlreadyExistsException;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.TableAlreadyExistsException;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.AdditionalMatchers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Category(value={ParallelStatsDisabledTest.class})
public class AppendOnlySchemaIT
extends ParallelStatsDisabledIT {
    private void testTableWithSameSchema(boolean notExists, boolean sameClient) throws Exception {
        ConnectionQueryServices connectionQueryServices = (ConnectionQueryServices)Mockito.spy((Object)driver.getConnectionQueryServices(AppendOnlySchemaIT.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES)));
        Properties props = new Properties();
        props.putAll((Map<?, ?>)PhoenixEmbeddedDriver.DEFAULT_PROPS.asMap());
        try (PhoenixConnection conn1 = connectionQueryServices.connect(AppendOnlySchemaIT.getUrl(), props);
             PhoenixConnection conn2 = sameClient ? conn1 : connectionQueryServices.connect(AppendOnlySchemaIT.getUrl(), props);){
            String viewName;
            String metricTableName;
            block31: {
                String ddl;
                block30: {
                    metricTableName = AppendOnlySchemaIT.generateUniqueName();
                    viewName = AppendOnlySchemaIT.generateUniqueName();
                    String metricIdSeqTableName = AppendOnlySchemaIT.generateUniqueName();
                    conn1.createStatement().execute("CREATE SEQUENCE " + metricIdSeqTableName + " CACHE 1");
                    conn1.createStatement().execute("CREATE TABLE " + metricTableName + "(metricId INTEGER NOT NULL, metricVal DOUBLE, CONSTRAINT PK PRIMARY KEY(metricId)) APPEND_ONLY_SCHEMA = true, UPDATE_CACHE_FREQUENCY=1, AUTO_PARTITION_SEQ=" + metricIdSeqTableName);
                    ddl = "CREATE VIEW " + (notExists ? "IF NOT EXISTS " : "") + viewName + " ( hostName varchar NOT NULL, tagName varChar CONSTRAINT HOSTNAME_PK PRIMARY KEY (hostName)) AS SELECT * FROM " + metricTableName + " UPDATE_CACHE_FREQUENCY=300000";
                    conn1.createStatement().execute(ddl);
                    conn1.createStatement().execute("UPSERT INTO " + viewName + "(hostName, metricVal) VALUES('host1', 1.0)");
                    conn1.commit();
                    Mockito.reset((Object[])new ConnectionQueryServices[]{connectionQueryServices});
                    try {
                        conn2.createStatement().execute(ddl);
                        if (!notExists) {
                            Assert.fail((String)"Create Table should fail");
                        }
                    }
                    catch (TableAlreadyExistsException e) {
                        if (!notExists) break block30;
                        Assert.fail((String)"Create Table should not fail");
                    }
                }
                ((ConnectionQueryServices)Mockito.verify((Object)connectionQueryServices, (VerificationMode)Mockito.never())).getTable((PName)ArgumentMatchers.isNull(), AdditionalMatchers.aryEq((byte[])new byte[0]), AdditionalMatchers.aryEq((byte[])Bytes.toBytes((String)viewName)), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
                ((ConnectionQueryServices)Mockito.verify((Object)connectionQueryServices, (VerificationMode)Mockito.never())).createTable(ArgumentMatchers.anyList(), (byte[])ArgumentMatchers.any(byte[].class), (PTableType)ArgumentMatchers.any(PTableType.class), ArgumentMatchers.anyMap(), ArgumentMatchers.anyList(), (byte[][])ArgumentMatchers.any(byte[][].class), ArgumentMatchers.eq((boolean)false), ArgumentMatchers.eq((boolean)false), ArgumentMatchers.eq((boolean)false), (PTable)ArgumentMatchers.any(PTable.class));
                Mockito.reset((Object[])new ConnectionQueryServices[]{connectionQueryServices});
                ddl = "ALTER VIEW " + viewName + " ADD " + (notExists ? "IF NOT EXISTS" : "") + " tagName varchar";
                try {
                    conn2.createStatement().execute(ddl);
                    if (!notExists) {
                        Assert.fail((String)"Alter Table should fail");
                    }
                }
                catch (ColumnAlreadyExistsException e) {
                    if (!notExists) break block31;
                    Assert.fail((String)"Alter Table should not fail");
                }
            }
            ((ConnectionQueryServices)Mockito.verify((Object)connectionQueryServices, (VerificationMode)(notExists ? Mockito.times((int)1) : Mockito.never()))).addColumn((List)ArgumentMatchers.eq(Collections.emptyList()), (PTable)ArgumentMatchers.any(), (PTable)ArgumentMatchers.any(), (PTable)ArgumentMatchers.any(), ArgumentMatchers.anyMap(), ArgumentMatchers.anySet(), ArgumentMatchers.anyList());
            conn2.createStatement().execute("UPSERT INTO " + viewName + "(hostName, metricVal) VALUES('host2', 2.0)");
            conn2.commit();
            ResultSet rs = conn2.createStatement().executeQuery("SELECT * from " + metricTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertEquals((double)1.0, (double)rs.getDouble(2), (double)1.0E-6);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertEquals((double)2.0, (double)rs.getDouble(2), (double)1.0E-6);
            Assert.assertFalse((boolean)rs.next());
            rs = conn2.createStatement().executeQuery("SELECT * from " + viewName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertEquals((double)1.0, (double)rs.getDouble(2), (double)1.0E-6);
            Assert.assertEquals((Object)"host1", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertEquals((double)2.0, (double)rs.getDouble(2), (double)1.0E-6);
            Assert.assertEquals((Object)"host2", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testSameSchemaWithNotExistsSameClient() throws Exception {
        this.testTableWithSameSchema(true, true);
    }

    @Test
    public void testSameSchemaWithNotExistsDifferentClient() throws Exception {
        this.testTableWithSameSchema(true, false);
    }

    @Test
    public void testSameSchemaSameClient() throws Exception {
        this.testTableWithSameSchema(false, true);
    }

    @Test
    public void testSameSchemaDifferentClient() throws Exception {
        this.testTableWithSameSchema(false, false);
    }

    private void testAddColumns(boolean sameClient) throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn1 = DriverManager.getConnection(AppendOnlySchemaIT.getUrl(), props);
             Connection conn2 = sameClient ? conn1 : DriverManager.getConnection(AppendOnlySchemaIT.getUrl(), props);){
            String metricTableName = AppendOnlySchemaIT.generateUniqueName();
            String viewName = AppendOnlySchemaIT.generateUniqueName();
            String metricIdSeqTableName = AppendOnlySchemaIT.generateUniqueName();
            conn1.createStatement().execute("CREATE SEQUENCE " + metricIdSeqTableName + " CACHE 1");
            conn1.createStatement().execute("CREATE TABLE " + metricTableName + " (metricId INTEGER NOT NULL, metricVal1 DOUBLE, CONSTRAINT PK PRIMARY KEY(metricId)) APPEND_ONLY_SCHEMA = true, UPDATE_CACHE_FREQUENCY=1, AUTO_PARTITION_SEQ=" + metricIdSeqTableName);
            String ddl = "CREATE VIEW IF NOT EXISTS " + viewName + "( hostName varchar NOT NULL, CONSTRAINT HOSTNAME_PK PRIMARY KEY (hostName)) AS SELECT * FROM " + metricTableName + " UPDATE_CACHE_FREQUENCY=300000";
            conn1.createStatement().execute(ddl);
            conn1.createStatement().execute("UPSERT INTO " + viewName + "(hostName, metricVal1) VALUES('host1', 1.0)");
            conn1.commit();
            ddl = "CREATE VIEW IF NOT EXISTS " + viewName + "( instanceName varchar, hostName varchar, metricVal2 double, metricVal1 double CONSTRAINT HOSTNAME_PK PRIMARY KEY (instancename, hostName)) AS SELECT * FROM " + metricTableName + " UPDATE_CACHE_FREQUENCY=300000";
            conn2.createStatement().execute(ddl);
            conn2.createStatement().execute("UPSERT INTO " + viewName + "(hostName, instanceName, metricVal1, metricval2) VALUES('host2', 'instance2', 21.0, 22.0)");
            conn2.commit();
            conn1.createStatement().execute("UPSERT INTO " + viewName + "(hostName, metricVal1) VALUES('host3', 3.0)");
            conn1.commit();
            ResultSet rs = conn2.createStatement().executeQuery("SELECT * from " + viewName);
            PTable table = conn2.unwrap(PhoenixConnection.class).getTable(new PTableKey(null, viewName));
            List pkColumns = table.getPKColumns();
            Assert.assertEquals((long)3L, (long)table.getPKColumns().size());
            PColumn metricId = (PColumn)pkColumns.get(0);
            Assert.assertEquals((Object)"METRICID", (Object)metricId.getName().getString());
            Assert.assertFalse((boolean)metricId.isNullable());
            PColumn hostName = (PColumn)pkColumns.get(1);
            Assert.assertEquals((Object)"HOSTNAME", (Object)hostName.getName().getString());
            Assert.assertFalse((boolean)hostName.isNullable());
            PColumn instanceName = (PColumn)pkColumns.get(2);
            Assert.assertEquals((Object)"INSTANCENAME", (Object)instanceName.getName().getString());
            Assert.assertTrue((boolean)instanceName.isNullable());
            List columns = table.getColumns();
            Assert.assertEquals((Object)"METRICID", (Object)((PColumn)columns.get(0)).getName().getString());
            Assert.assertEquals((Object)"METRICVAL1", (Object)((PColumn)columns.get(1)).getName().getString());
            Assert.assertEquals((Object)"HOSTNAME", (Object)((PColumn)columns.get(2)).getName().getString());
            Assert.assertEquals((Object)"INSTANCENAME", (Object)((PColumn)columns.get(3)).getName().getString());
            Assert.assertEquals((Object)"METRICVAL2", (Object)((PColumn)columns.get(4)).getName().getString());
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertEquals((double)1.0, (double)rs.getDouble(2), (double)1.0E-6);
            Assert.assertEquals((Object)"host1", (Object)rs.getString(3));
            Assert.assertEquals(null, (Object)rs.getString(4));
            Assert.assertEquals((double)0.0, (double)rs.getDouble(5), (double)1.0E-6);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertEquals((double)21.0, (double)rs.getDouble(2), (double)1.0E-6);
            Assert.assertEquals((Object)"host2", (Object)rs.getString(3));
            Assert.assertEquals((Object)"instance2", (Object)rs.getString(4));
            Assert.assertEquals((double)22.0, (double)rs.getDouble(5), (double)1.0E-6);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertEquals((double)3.0, (double)rs.getDouble(2), (double)1.0E-6);
            Assert.assertEquals((Object)"host3", (Object)rs.getString(3));
            Assert.assertEquals(null, (Object)rs.getString(4));
            Assert.assertEquals((double)0.0, (double)rs.getDouble(5), (double)1.0E-6);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testAddColumnsSameClient() throws Exception {
        this.testAddColumns(true);
    }

    @Test
    public void testTableAddColumnsDifferentClient() throws Exception {
        this.testAddColumns(false);
    }

    @Test
    public void testValidateAttributes() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(AppendOnlySchemaIT.getUrl(), props);){
            String tableName = AppendOnlySchemaIT.generateUniqueName();
            String viewName = AppendOnlySchemaIT.generateUniqueName();
            try {
                conn.createStatement().execute("create table IF NOT EXISTS " + tableName + " ( id char(1) NOT NULL, col1 integer NOT NULL, CONSTRAINT NAME_PK PRIMARY KEY (id, col1)) APPEND_ONLY_SCHEMA = true, UPDATE_CACHE_FREQUENCY=always");
                Assert.fail((String)"UPDATE_CACHE_FREQUENCY attribute must not be set to ALWAYS if APPEND_ONLY_SCHEMA is true");
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.UPDATE_CACHE_FREQUENCY_INVALID.getErrorCode(), (long)e.getErrorCode());
            }
            conn.createStatement().execute("create table IF NOT EXISTS " + tableName + " ( id char(1) NOT NULL, col1 integer NOT NULL CONSTRAINT NAME_PK PRIMARY KEY (id, col1)) APPEND_ONLY_SCHEMA = true, UPDATE_CACHE_FREQUENCY=1000");
            conn.createStatement().execute("create view IF NOT EXISTS " + viewName + " (val1 integer) AS SELECT * FROM " + tableName);
            PhoenixConnection pconn = conn.unwrap(PhoenixConnection.class);
            PTable view = pconn.getTable(new PTableKey(pconn.getTenantId(), viewName));
            Assert.assertEquals((Object)true, (Object)view.isAppendOnlySchema());
            Assert.assertEquals((long)1000L, (long)view.getUpdateCacheFrequency());
        }
    }

    @Test
    public void testAlterTableOptions() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(AppendOnlySchemaIT.getUrl(), props);
             Statement stmt = conn.createStatement();){
            String tableName = AppendOnlySchemaIT.generateUniqueName();
            stmt.execute("CREATE TABLE " + tableName + " (ID INTEGER PRIMARY KEY, COL INTEGER) APPEND_ONLY_SCHEMA = true, UPDATE_CACHE_FREQUENCY = 1");
            stmt.execute("ALTER TABLE " + tableName + " SET STORE_NULLS = true");
            try (ResultSet rs = stmt.executeQuery("SELECT STORE_NULLS FROM \"SYSTEM\".\"CATALOG\" WHERE TABLE_NAME = '" + tableName + "' AND STORE_NULLS IS NOT NULL AND TENANT_ID IS NULL AND TABLE_SCHEM IS NULL");){
                Assert.assertTrue((boolean)rs.next());
                Assert.assertTrue((boolean)rs.getBoolean(1));
                Assert.assertFalse((boolean)rs.next());
            }
        }
    }
}

