/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.end2end.AlterMultiTenantTableWithViewsIT;
import org.apache.phoenix.end2end.CreateTableIT;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.SplitSystemCatalogIT;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.thirdparty.com.google.common.base.Function;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={NeedsOwnMiniClusterTest.class})
@RunWith(value=Parameterized.class)
public class AlterTableWithViewsIT
extends SplitSystemCatalogIT {
    private final boolean isMultiTenant;
    private final boolean columnEncoded;
    private final boolean salted;
    private final String TENANT_SPECIFIC_URL1 = AlterTableWithViewsIT.getUrl() + ';' + "TenantId" + "=" + TENANT1;
    private final String TENANT_SPECIFIC_URL2 = AlterTableWithViewsIT.getUrl() + ';' + "TenantId" + "=" + TENANT2;
    private Function<PColumn, String> function = new Function<PColumn, String>(){

        public String apply(PColumn input) {
            return input.getName().getString();
        }
    };

    public AlterTableWithViewsIT(boolean columnEncoded, boolean isMultiTenant, boolean salted) {
        this.columnEncoded = columnEncoded;
        this.isMultiTenant = isMultiTenant;
        this.salted = salted;
    }

    @Parameterized.Parameters(name="AlterTableWithViewsIT_columnEncoded={0}, multiTenant={1}, salted={2}")
    public static synchronized Collection<Boolean[]> data() {
        return Arrays.asList({false, false, false}, {true, false, true}, {true, true, false}, {true, true, true});
    }

    private String generateDDL(String format) {
        return this.generateDDL("", format);
    }

    private String generateDDL(String options, String format) {
        StringBuilder optionsBuilder = new StringBuilder(options);
        if (!this.columnEncoded) {
            if (optionsBuilder.length() != 0) {
                optionsBuilder.append(",");
            }
            optionsBuilder.append("COLUMN_ENCODED_BYTES=0");
        }
        if (this.isMultiTenant) {
            if (optionsBuilder.length() != 0) {
                optionsBuilder.append(",");
            }
            optionsBuilder.append("MULTI_TENANT=true");
        }
        if (this.salted) {
            if (optionsBuilder.length() != 0) {
                optionsBuilder.append(",");
            }
            optionsBuilder.append("SALT_BUCKETS=4");
        }
        return String.format(format, this.isMultiTenant ? "TENANT_ID VARCHAR NOT NULL, " : "", this.isMultiTenant ? "TENANT_ID, " : "", optionsBuilder.toString());
    }

    @Test
    public void testAddNewColumnsToBaseTableWithViews() throws Exception {
        try (Connection conn = DriverManager.getConnection(AlterTableWithViewsIT.getUrl());
             Connection viewConn = this.isMultiTenant ? DriverManager.getConnection(this.TENANT_SPECIFIC_URL1) : conn;){
            String tableName = SchemaUtil.getTableName((String)SCHEMA1, (String)AlterTableWithViewsIT.generateUniqueName());
            String viewOfTable = SchemaUtil.getTableName((String)SCHEMA2, (String)AlterTableWithViewsIT.generateUniqueName());
            String ddlFormat = "CREATE TABLE IF NOT EXISTS " + tableName + " ( %s ID char(1) NOT NULL, COL1 integer NOT NULL, COL2 bigint NOT NULL, CONSTRAINT NAME_PK PRIMARY KEY (%s ID, COL1, COL2) ) %s";
            conn.createStatement().execute(this.generateDDL(ddlFormat));
            this.assertTableDefinition(conn, tableName, PTableType.TABLE, null, 0, 3, -1, true, "ID", "COL1", "COL2");
            viewConn.createStatement().execute("CREATE VIEW " + viewOfTable + " ( VIEW_COL1 DECIMAL(10,2), VIEW_COL2 VARCHAR ) AS SELECT * FROM " + tableName);
            this.assertTableDefinition(viewConn, viewOfTable, PTableType.VIEW, tableName, 0, 5, 3, true, "ID", "COL1", "COL2", "VIEW_COL1", "VIEW_COL2");
            conn.createStatement().execute("ALTER TABLE " + tableName + " ADD COL3 varchar(10) PRIMARY KEY, COL4 integer");
            this.assertTableDefinition(conn, tableName, PTableType.TABLE, null, this.columnEncoded ? 2 : 1, 5, -1, false, "ID", "COL1", "COL2", "COL3", "COL4");
            this.assertTableDefinition(viewConn, viewOfTable, PTableType.VIEW, tableName, 0, 5, 3, true, "ID", "COL1", "COL2", "COL3", "COL4", "VIEW_COL1", "VIEW_COL2");
        }
    }

    @Test
    public void testAlterPropertiesOfParentTable() throws Exception {
        try (Connection conn = DriverManager.getConnection(AlterTableWithViewsIT.getUrl());
             Connection viewConn = this.isMultiTenant ? DriverManager.getConnection(this.TENANT_SPECIFIC_URL1) : conn;){
            String tableName = SchemaUtil.getTableName((String)SCHEMA1, (String)AlterTableWithViewsIT.generateUniqueName());
            String viewOfTable1 = SchemaUtil.getTableName((String)SCHEMA2, (String)AlterTableWithViewsIT.generateUniqueName());
            String viewOfTable2 = SchemaUtil.getTableName((String)SCHEMA3, (String)AlterTableWithViewsIT.generateUniqueName());
            String ddlFormat = "CREATE TABLE IF NOT EXISTS " + tableName + " ( %s ID char(1) NOT NULL, COL1 integer NOT NULL, COL2 bigint NOT NULL, CONSTRAINT NAME_PK PRIMARY KEY (%s ID, COL1, COL2) ) %s ";
            conn.createStatement().execute(this.generateDDL("UPDATE_CACHE_FREQUENCY=2", ddlFormat));
            viewConn.createStatement().execute("CREATE VIEW " + viewOfTable1 + " ( VIEW_COL1 DECIMAL(10,2), VIEW_COL2 VARCHAR ) AS SELECT * FROM " + tableName);
            viewConn.createStatement().execute("CREATE VIEW " + viewOfTable2 + " ( VIEW_COL1 DECIMAL(10,2), VIEW_COL2 VARCHAR ) AS SELECT * FROM " + tableName);
            PName tenantId = this.isMultiTenant ? PNameFactory.newName((String)TENANT1) : null;
            PTable table = conn.unwrap(PhoenixConnection.class).getTable(new PTableKey(null, tableName));
            PTable viewTable1 = viewConn.unwrap(PhoenixConnection.class).getTable(new PTableKey(tenantId, viewOfTable1));
            PTable viewTable2 = viewConn.unwrap(PhoenixConnection.class).getTable(new PTableKey(tenantId, viewOfTable2));
            Assert.assertFalse((boolean)table.isImmutableRows());
            Assert.assertFalse((boolean)viewTable1.isImmutableRows());
            Assert.assertFalse((boolean)viewTable2.isImmutableRows());
            Assert.assertEquals((long)2L, (long)table.getUpdateCacheFrequency());
            Assert.assertEquals((long)2L, (long)viewTable1.getUpdateCacheFrequency());
            Assert.assertEquals((long)2L, (long)viewTable2.getUpdateCacheFrequency());
            Assert.assertNull((Object)table.useStatsForParallelization());
            Assert.assertNull((Object)viewTable1.useStatsForParallelization());
            Assert.assertNull((Object)viewTable2.useStatsForParallelization());
            viewConn.createStatement().execute("ALTER VIEW " + viewOfTable2 + " SET UPDATE_CACHE_FREQUENCY=1, USE_STATS_FOR_PARALLELIZATION=false");
            viewConn.createStatement().execute("SELECT * FROM " + viewOfTable2);
            viewTable2 = viewConn.unwrap(PhoenixConnection.class).getTable(new PTableKey(tenantId, viewOfTable2));
            Assert.assertEquals((long)1L, (long)viewTable2.getUpdateCacheFrequency());
            Assert.assertFalse((boolean)viewTable2.useStatsForParallelization());
            conn.createStatement().execute("ALTER TABLE " + tableName + " SET IMMUTABLE_ROWS=true, UPDATE_CACHE_FREQUENCY=3, USE_STATS_FOR_PARALLELIZATION=true");
            viewConn.createStatement().execute("SELECT * FROM " + viewOfTable1);
            viewConn.createStatement().execute("SELECT * FROM " + viewOfTable2);
            table = conn.unwrap(PhoenixConnection.class).getTable(new PTableKey(null, tableName));
            viewTable1 = viewConn.unwrap(PhoenixConnection.class).getTable(new PTableKey(tenantId, viewOfTable1));
            viewTable2 = viewConn.unwrap(PhoenixConnection.class).getTable(new PTableKey(tenantId, viewOfTable2));
            Assert.assertTrue((boolean)table.isImmutableRows());
            Assert.assertTrue((boolean)viewTable1.isImmutableRows());
            Assert.assertTrue((boolean)viewTable2.isImmutableRows());
            Assert.assertEquals((long)3L, (long)table.getUpdateCacheFrequency());
            Assert.assertEquals((long)3L, (long)viewTable1.getUpdateCacheFrequency());
            Assert.assertEquals((long)1L, (long)viewTable2.getUpdateCacheFrequency());
            Assert.assertTrue((boolean)table.useStatsForParallelization());
            Assert.assertTrue((boolean)viewTable1.useStatsForParallelization());
            Assert.assertFalse((boolean)viewTable2.useStatsForParallelization());
            long gpw = 1000000L;
            conn.createStatement().execute("ALTER TABLE " + tableName + " SET GUIDE_POSTS_WIDTH=" + gpw);
            DatabaseMetaData md = conn.getMetaData();
            ResultSet rs = md.getTables("", SchemaUtil.getSchemaNameFromFullName((String)tableName), SchemaUtil.getTableNameFromFullName((String)tableName), null);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)gpw, (long)rs.getLong("GUIDE_POSTS_WIDTH"));
            rs = md.getTables(null, SchemaUtil.getSchemaNameFromFullName((String)viewOfTable1), SchemaUtil.getTableNameFromFullName((String)viewOfTable1), null);
            Assert.assertTrue((boolean)rs.next());
            rs.getLong("GUIDE_POSTS_WIDTH");
            Assert.assertTrue((boolean)rs.wasNull());
            rs = md.getTables(null, SchemaUtil.getSchemaNameFromFullName((String)viewOfTable2), SchemaUtil.getTableNameFromFullName((String)viewOfTable2), null);
            Assert.assertTrue((boolean)rs.next());
            rs.getLong("GUIDE_POSTS_WIDTH");
            Assert.assertTrue((boolean)rs.wasNull());
        }
    }

    @Test
    public void testCreateViewWithPropsMaintainsOwnProps() throws Exception {
        try (Connection conn = DriverManager.getConnection(AlterTableWithViewsIT.getUrl());
             Connection viewConn = this.isMultiTenant ? DriverManager.getConnection(this.TENANT_SPECIFIC_URL1) : conn;){
            String tableName = SchemaUtil.getTableName((String)SCHEMA1, (String)AlterTableWithViewsIT.generateUniqueName());
            String viewOfTable1 = SchemaUtil.getTableName((String)SCHEMA2, (String)AlterTableWithViewsIT.generateUniqueName());
            String viewOfTable2 = SchemaUtil.getTableName((String)SCHEMA3, (String)AlterTableWithViewsIT.generateUniqueName());
            String ddlFormat = "CREATE TABLE IF NOT EXISTS " + tableName + " ( %s ID char(1) NOT NULL, COL1 integer NOT NULL, COL2 bigint NOT NULL, CONSTRAINT NAME_PK PRIMARY KEY (%s ID, COL1, COL2)) %s ";
            conn.createStatement().execute(this.generateDDL("UPDATE_CACHE_FREQUENCY=2", ddlFormat));
            viewConn.createStatement().execute("CREATE VIEW " + viewOfTable1 + " ( VIEW_COL1 DECIMAL(10,2), VIEW_COL2 VARCHAR ) AS SELECT * FROM " + tableName + " UPDATE_CACHE_FREQUENCY=7");
            viewConn.createStatement().execute("CREATE VIEW " + viewOfTable2 + " ( VIEW_COL1 DECIMAL(10,2), VIEW_COL2 VARCHAR ) AS SELECT * FROM " + tableName + " USE_STATS_FOR_PARALLELIZATION=true");
            PName tenantId = this.isMultiTenant ? PNameFactory.newName((String)TENANT1) : null;
            PTable table = conn.unwrap(PhoenixConnection.class).getTable(new PTableKey(null, tableName));
            PTable viewTable1 = viewConn.unwrap(PhoenixConnection.class).getTable(new PTableKey(tenantId, viewOfTable1));
            PTable viewTable2 = viewConn.unwrap(PhoenixConnection.class).getTable(new PTableKey(tenantId, viewOfTable2));
            Assert.assertEquals((long)2L, (long)table.getUpdateCacheFrequency());
            Assert.assertEquals((long)7L, (long)viewTable1.getUpdateCacheFrequency());
            Assert.assertEquals((long)2L, (long)viewTable2.getUpdateCacheFrequency());
            Assert.assertNull((Object)table.useStatsForParallelization());
            Assert.assertNull((Object)viewTable1.useStatsForParallelization());
            Assert.assertTrue((boolean)viewTable2.useStatsForParallelization());
            conn.createStatement().execute("ALTER TABLE " + tableName + " SET UPDATE_CACHE_FREQUENCY=3, USE_STATS_FOR_PARALLELIZATION=false");
            Thread.sleep(2L);
            viewConn.createStatement().execute("SELECT * FROM " + viewOfTable1);
            viewConn.createStatement().execute("SELECT * FROM " + viewOfTable2);
            table = conn.unwrap(PhoenixConnection.class).getTable(new PTableKey(null, tableName));
            viewTable1 = viewConn.unwrap(PhoenixConnection.class).getTable(new PTableKey(tenantId, viewOfTable1));
            viewTable2 = viewConn.unwrap(PhoenixConnection.class).getTable(new PTableKey(tenantId, viewOfTable2));
            Assert.assertEquals((long)3L, (long)table.getUpdateCacheFrequency());
            Assert.assertEquals((long)7L, (long)viewTable1.getUpdateCacheFrequency());
            Assert.assertEquals((long)3L, (long)viewTable2.getUpdateCacheFrequency());
            Assert.assertFalse((boolean)table.useStatsForParallelization());
            Assert.assertFalse((boolean)viewTable1.useStatsForParallelization());
            Assert.assertTrue((boolean)viewTable2.useStatsForParallelization());
        }
    }

    @Test
    public void testDropColumnsFromBaseTableWithView() throws Exception {
        try (Connection conn = DriverManager.getConnection(AlterTableWithViewsIT.getUrl());
             Connection viewConn = this.isMultiTenant ? DriverManager.getConnection(this.TENANT_SPECIFIC_URL1) : conn;){
            String tableName = SchemaUtil.getTableName((String)SCHEMA1, (String)AlterTableWithViewsIT.generateUniqueName());
            String viewOfTable = SchemaUtil.getTableName((String)SCHEMA2, (String)AlterTableWithViewsIT.generateUniqueName());
            String ddlFormat = "CREATE TABLE IF NOT EXISTS " + tableName + " ( %s ID char(1) NOT NULL, COL1 integer NOT NULL, COL2 bigint NOT NULL, COL3 varchar(10), COL4 varchar(10), COL5 varchar(10), CONSTRAINT NAME_PK PRIMARY KEY (%s ID, COL1, COL2) ) %s";
            conn.createStatement().execute(this.generateDDL(ddlFormat));
            this.assertTableDefinition(conn, tableName, PTableType.TABLE, null, 0, 6, -1, true, "ID", "COL1", "COL2", "COL3", "COL4", "COL5");
            viewConn.createStatement().execute("CREATE VIEW " + viewOfTable + " ( VIEW_COL1 DECIMAL(10,2), VIEW_COL2 VARCHAR ) AS SELECT * FROM " + tableName);
            this.assertTableDefinition(viewConn, viewOfTable, PTableType.VIEW, tableName, 0, 8, 6, true, "ID", "COL1", "COL2", "COL3", "COL4", "COL5", "VIEW_COL1", "VIEW_COL2");
            conn.createStatement().execute("ALTER TABLE " + tableName + " DROP COLUMN COL3, COL5");
            this.assertTableDefinition(conn, tableName, PTableType.TABLE, null, this.columnEncoded ? 2 : 1, 4, -1, false, "ID", "COL1", "COL2", "COL4");
            this.assertTableDefinition(viewConn, viewOfTable, PTableType.VIEW, tableName, 0, 8, 6, true, "ID", "COL1", "COL2", "COL4", "VIEW_COL1", "VIEW_COL2");
        }
    }

    @Test
    public void testAddExistingViewColumnToBaseTableWithViews() throws Exception {
        try (Connection conn = DriverManager.getConnection(AlterTableWithViewsIT.getUrl());
             Connection viewConn = this.isMultiTenant ? DriverManager.getConnection(this.TENANT_SPECIFIC_URL1) : conn;){
            conn.setAutoCommit(false);
            viewConn.setAutoCommit(false);
            String tableName = SchemaUtil.getTableName((String)SCHEMA1, (String)AlterTableWithViewsIT.generateUniqueName());
            String viewOfTable = SchemaUtil.getTableName((String)SCHEMA2, (String)AlterTableWithViewsIT.generateUniqueName());
            String ddlFormat = "CREATE TABLE IF NOT EXISTS " + tableName + " ( %s ID char(10) NOT NULL, COL1 integer NOT NULL, COL2 bigint NOT NULL, COL3 varchar, CONSTRAINT NAME_PK PRIMARY KEY (%s ID, COL1, COL2) ) %s";
            conn.createStatement().execute(this.generateDDL(ddlFormat));
            this.assertTableDefinition(conn, tableName, PTableType.TABLE, null, 0, 4, -1, true, "ID", "COL1", "COL2", "COL3");
            viewConn.createStatement().execute("CREATE VIEW " + viewOfTable + " ( VIEW_COL1 DECIMAL(10,2), VIEW_COL2 VARCHAR(256), VIEW_COL3 VARCHAR, VIEW_COL4 DECIMAL, VIEW_COL5 DECIMAL(10,2), VIEW_COL6 VARCHAR, CONSTRAINT pk PRIMARY KEY (VIEW_COL5, VIEW_COL6) ) AS SELECT * FROM " + tableName);
            this.assertTableDefinition(viewConn, viewOfTable, PTableType.VIEW, tableName, 0, 10, 4, true, "ID", "COL1", "COL2", "COL3", "VIEW_COL1", "VIEW_COL2", "VIEW_COL3", "VIEW_COL4", "VIEW_COL5", "VIEW_COL6");
            String dml = "UPSERT INTO " + viewOfTable + " VALUES(?,?,?,?,?, ?, ?, ?, ?, ?)";
            PreparedStatement stmt = viewConn.prepareStatement(dml);
            stmt.setString(1, "view1");
            stmt.setInt(2, 12);
            stmt.setInt(3, 13);
            stmt.setString(4, "view4");
            stmt.setInt(5, 15);
            stmt.setString(6, "view6");
            stmt.setString(7, "view7");
            stmt.setInt(8, 18);
            stmt.setInt(9, 19);
            stmt.setString(10, "view10");
            stmt.execute();
            viewConn.commit();
            try {
                conn.createStatement().execute("ALTER TABLE " + tableName + " ADD VIEW_COL1 char(10)");
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((String)"Unexpected exception", (long)SQLExceptionCode.CANNOT_MUTATE_TABLE.getErrorCode(), (long)e.getErrorCode());
            }
            try {
                conn.createStatement().execute("ALTER TABLE " + tableName + " ADD VIEW_COL1 DECIMAL(10,1)");
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((String)"Unexpected exception", (long)SQLExceptionCode.CANNOT_MUTATE_TABLE.getErrorCode(), (long)e.getErrorCode());
            }
            try {
                conn.createStatement().execute("ALTER TABLE " + tableName + " ADD VIEW_COL1 DECIMAL(9,2)");
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((String)"Unexpected exception", (long)SQLExceptionCode.CANNOT_MUTATE_TABLE.getErrorCode(), (long)e.getErrorCode());
            }
            try {
                conn.createStatement().execute("ALTER TABLE " + tableName + " ADD VIEW_COL2 VARCHAR");
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((String)"Unexpected exception", (long)SQLExceptionCode.CANNOT_MUTATE_TABLE.getErrorCode(), (long)e.getErrorCode());
            }
            this.assertTableDefinition(conn, tableName, PTableType.TABLE, null, this.columnEncoded ? 1 : 0, 4, -1, true, "ID", "COL1", "COL2", "COL3");
            this.assertTableDefinition(viewConn, viewOfTable, PTableType.VIEW, tableName, 0, 10, 4, true, "ID", "COL1", "COL2", "COL3", "VIEW_COL1", "VIEW_COL2", "VIEW_COL3", "VIEW_COL4", "VIEW_COL5", "VIEW_COL6");
            if (this.columnEncoded) {
                try {
                    conn.createStatement().execute("ALTER TABLE " + tableName + " ADD VIEW_COL4 DECIMAL, VIEW_COL2 VARCHAR(256)");
                    Assert.fail();
                }
                catch (SQLException e) {
                    Assert.assertEquals((String)"Unexpected exception", (long)SQLExceptionCode.CANNOT_MUTATE_TABLE.getErrorCode(), (long)e.getErrorCode());
                }
            } else {
                conn.createStatement().execute("ALTER TABLE " + tableName + " ADD VIEW_COL4 DECIMAL, VIEW_COL2 VARCHAR(256)");
                this.assertTableDefinition(conn, tableName, PTableType.TABLE, null, this.columnEncoded ? 2 : 1, 6, -1, false, "ID", "COL1", "COL2", "COL3", "VIEW_COL4", "VIEW_COL2");
                this.assertTableDefinition(viewConn, viewOfTable, PTableType.VIEW, tableName, 0, 10, 4, true, "ID", "COL1", "COL2", "COL3", "VIEW_COL4", "VIEW_COL2", "VIEW_COL1", "VIEW_COL3", "VIEW_COL5", "VIEW_COL6");
                ResultSet rs = stmt.executeQuery("SELECT * FROM " + tableName);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"view1", (Object)rs.getString("ID"));
                Assert.assertEquals((long)12L, (long)rs.getInt("COL1"));
                Assert.assertEquals((long)13L, (long)rs.getInt("COL2"));
                Assert.assertEquals((Object)"view4", (Object)rs.getString("COL3"));
                Assert.assertEquals((Object)"view6", (Object)rs.getString("VIEW_COL2"));
                Assert.assertEquals((long)18L, (long)rs.getInt("VIEW_COL4"));
                Assert.assertFalse((boolean)rs.next());
                rs = stmt.executeQuery("SELECT * FROM " + viewOfTable);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"view1", (Object)rs.getString("ID"));
                Assert.assertEquals((long)12L, (long)rs.getInt("COL1"));
                Assert.assertEquals((long)13L, (long)rs.getInt("COL2"));
                Assert.assertEquals((Object)"view4", (Object)rs.getString("COL3"));
                Assert.assertEquals((long)15L, (long)rs.getInt("VIEW_COL1"));
                Assert.assertEquals((Object)"view6", (Object)rs.getString("VIEW_COL2"));
                Assert.assertEquals((Object)"view7", (Object)rs.getString("VIEW_COL3"));
                Assert.assertEquals((long)18L, (long)rs.getInt("VIEW_COL4"));
                Assert.assertEquals((long)19L, (long)rs.getInt("VIEW_COL5"));
                Assert.assertEquals((Object)"view10", (Object)rs.getString("VIEW_COL6"));
                Assert.assertFalse((boolean)rs.next());
                PName tenantId = this.isMultiTenant ? PNameFactory.newName((String)TENANT1) : null;
                PTable view = viewConn.unwrap(PhoenixConnection.class).getTable(new PTableKey(tenantId, viewOfTable));
                this.assertBaseColumnCount(4, view.getBaseColumnCount());
                this.assertColumnsMatch(view.getColumns(), "ID", "COL1", "COL2", "COL3", "VIEW_COL4", "VIEW_COL2", "VIEW_COL1", "VIEW_COL3", "VIEW_COL5", "VIEW_COL6");
            }
        }
    }

    @Test
    public void testAddExistingViewPkColumnToBaseTableWithViews() throws Exception {
        try (Connection conn = DriverManager.getConnection(AlterTableWithViewsIT.getUrl());
             Connection viewConn = this.isMultiTenant ? DriverManager.getConnection(this.TENANT_SPECIFIC_URL1) : conn;){
            conn.setAutoCommit(false);
            viewConn.setAutoCommit(false);
            String tableName = SchemaUtil.getTableName((String)SCHEMA1, (String)AlterTableWithViewsIT.generateUniqueName());
            String viewOfTable = SchemaUtil.getTableName((String)SCHEMA2, (String)AlterTableWithViewsIT.generateUniqueName());
            String ddlFormat = "CREATE TABLE IF NOT EXISTS " + tableName + " ( %s ID char(10) NOT NULL, COL1 integer NOT NULL, COL2 integer NOT NULL, CONSTRAINT NAME_PK PRIMARY KEY (%s ID, COL1, COL2) ) %s";
            conn.createStatement().execute(this.generateDDL(ddlFormat));
            this.assertTableDefinition(conn, tableName, PTableType.TABLE, null, 0, 3, -1, true, "ID", "COL1", "COL2");
            viewConn.createStatement().execute("CREATE VIEW " + viewOfTable + " ( VIEW_COL1 DECIMAL(10,2), VIEW_COL2 VARCHAR(256) CONSTRAINT pk PRIMARY KEY (VIEW_COL1, VIEW_COL2)) AS SELECT * FROM " + tableName);
            this.assertTableDefinition(viewConn, viewOfTable, PTableType.VIEW, tableName, 0, 5, 3, true, "ID", "COL1", "COL2", "VIEW_COL1", "VIEW_COL2");
            String dml = "UPSERT INTO " + viewOfTable + " VALUES(?,?,?,?,?)";
            PreparedStatement stmt = viewConn.prepareStatement(dml);
            stmt.setString(1, "view1");
            stmt.setInt(2, 12);
            stmt.setInt(3, 13);
            stmt.setInt(4, 14);
            stmt.setString(5, "view5");
            stmt.execute();
            viewConn.commit();
            try {
                conn.createStatement().execute("ALTER TABLE " + tableName + " ADD VIEW_COL2 VARCHAR(256) PRIMARY KEY");
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((String)"Unexpected exception", (long)SQLExceptionCode.CANNOT_MUTATE_TABLE.getErrorCode(), (long)e.getErrorCode());
            }
            try {
                conn.createStatement().execute("ALTER TABLE " + tableName + " ADD VIEW_COL1 DECIMAL(10,2) PRIMARY KEY");
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((String)"Unexpected exception", (long)SQLExceptionCode.CANNOT_MUTATE_TABLE.getErrorCode(), (long)e.getErrorCode());
            }
            try {
                conn.createStatement().execute("ALTER TABLE " + tableName + " ADD VIEW_COL1 DECIMAL(10,2), VIEW_COL2 VARCHAR(256) PRIMARY KEY");
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((String)"Unexpected exception", (long)SQLExceptionCode.CANNOT_MUTATE_TABLE.getErrorCode(), (long)e.getErrorCode());
            }
            try {
                conn.createStatement().execute("ALTER TABLE " + tableName + " ADD VIEW_COL1 DECIMAL(10,2) PRIMARY KEY, VIEW_COL2 VARCHAR(256)");
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((String)"Unexpected exception", (long)SQLExceptionCode.CANNOT_MUTATE_TABLE.getErrorCode(), (long)e.getErrorCode());
            }
            try {
                conn.createStatement().execute("ALTER TABLE " + tableName + "  ADD VIEW_COL2 VARCHAR(256) PRIMARY KEY, VIEW_COL1 DECIMAL(10,2) PRIMARY KEY");
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((String)"Unexpected exception", (long)SQLExceptionCode.CANNOT_MUTATE_TABLE.getErrorCode(), (long)e.getErrorCode());
            }
            try {
                conn.createStatement().execute("ALTER TABLE " + tableName + " ADD VIEW_COL1 DECIMAL(10,2) PRIMARY KEY DESC, VIEW_COL2 VARCHAR(256) PRIMARY KEY");
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((String)"Unexpected exception", (long)SQLExceptionCode.CANNOT_MUTATE_TABLE.getErrorCode(), (long)e.getErrorCode());
            }
            conn.createStatement().execute("ALTER TABLE " + tableName + " ADD VIEW_COL1 DECIMAL(10,2) PRIMARY KEY, VIEW_COL2 VARCHAR(256) PRIMARY KEY");
            this.assertTableDefinition(conn, tableName, PTableType.TABLE, null, 1, 5, -1, false, "ID", "COL1", "COL2", "VIEW_COL1", "VIEW_COL2");
            this.assertTableDefinition(viewConn, viewOfTable, PTableType.VIEW, tableName, 0, 5, 3, true, "ID", "COL1", "COL2", "VIEW_COL1", "VIEW_COL2");
            ResultSet rs = stmt.executeQuery("SELECT * FROM " + tableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"view1", (Object)rs.getString("ID"));
            Assert.assertEquals((long)12L, (long)rs.getInt("COL1"));
            Assert.assertEquals((long)13L, (long)rs.getInt("COL2"));
            Assert.assertEquals((long)14L, (long)rs.getInt("VIEW_COL1"));
            Assert.assertEquals((Object)"view5", (Object)rs.getString("VIEW_COL2"));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + viewOfTable);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"view1", (Object)rs.getString("ID"));
            Assert.assertEquals((long)12L, (long)rs.getInt("COL1"));
            Assert.assertEquals((long)13L, (long)rs.getInt("COL2"));
            Assert.assertEquals((long)14L, (long)rs.getInt("VIEW_COL1"));
            Assert.assertEquals((Object)"view5", (Object)rs.getString("VIEW_COL2"));
            Assert.assertFalse((boolean)rs.next());
            PName tenantId = this.isMultiTenant ? PNameFactory.newName((String)TENANT1) : null;
            PTable view = viewConn.unwrap(PhoenixConnection.class).getTableNoCache(viewOfTable.toUpperCase());
            view = viewConn.unwrap(PhoenixConnection.class).getTable(new PTableKey(tenantId, viewOfTable));
            this.assertBaseColumnCount(3, view.getBaseColumnCount());
        }
    }

    @Test
    public void testAddExistingViewPkColumnToBaseTableWithMultipleViews() throws Exception {
        try (Connection conn = DriverManager.getConnection(AlterTableWithViewsIT.getUrl());
             Connection viewConn = this.isMultiTenant ? DriverManager.getConnection(this.TENANT_SPECIFIC_URL1) : conn;){
            String tableName = SchemaUtil.getTableName((String)SCHEMA1, (String)AlterTableWithViewsIT.generateUniqueName());
            String viewOfTable1 = SchemaUtil.getTableName((String)SCHEMA2, (String)AlterTableWithViewsIT.generateUniqueName());
            String viewOfTable2 = SchemaUtil.getTableName((String)SCHEMA2, (String)AlterTableWithViewsIT.generateUniqueName());
            String ddlFormat = "CREATE TABLE IF NOT EXISTS " + tableName + "( %s ID char(10) NOT NULL, COL1 integer NOT NULL, COL2 integer NOT NULL, CONSTRAINT NAME_PK PRIMARY KEY (%s ID, COL1, COL2) ) %s";
            conn.createStatement().execute(this.generateDDL(ddlFormat));
            this.assertTableDefinition(conn, tableName, PTableType.TABLE, null, 0, 3, -1, true, "ID", "COL1", "COL2");
            viewConn.createStatement().execute("CREATE VIEW " + viewOfTable1 + " ( VIEW_COL1 DECIMAL(10,2), VIEW_COL2 VARCHAR(256) CONSTRAINT pk PRIMARY KEY (VIEW_COL1, VIEW_COL2)) AS SELECT * FROM " + tableName);
            this.assertTableDefinition(viewConn, viewOfTable1, PTableType.VIEW, tableName, 0, 5, 3, true, "ID", "COL1", "COL2", "VIEW_COL1", "VIEW_COL2");
            viewConn.createStatement().execute("CREATE VIEW " + viewOfTable2 + " ( VIEW_COL3 VARCHAR(256), VIEW_COL4 DECIMAL(10,2) CONSTRAINT pk PRIMARY KEY (VIEW_COL3, VIEW_COL4)) AS SELECT * FROM " + tableName);
            this.assertTableDefinition(viewConn, viewOfTable2, PTableType.VIEW, tableName, 0, 5, 3, true, "ID", "COL1", "COL2", "VIEW_COL3", "VIEW_COL4");
            try {
                conn.createStatement().execute("ALTER TABLE " + tableName + " ADD VIEW_COL1 DECIMAL(10,2) PRIMARY KEY, VIEW_COL2 VARCHAR(256) PRIMARY KEY");
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((String)"Unexpected exception", (long)SQLExceptionCode.CANNOT_MUTATE_TABLE.getErrorCode(), (long)e.getErrorCode());
            }
            try {
                conn.createStatement().execute("ALTER TABLE " + tableName + " ADD VIEW_COL3 VARCHAR PRIMARY KEY, VIEW_COL4 DECIMAL PRIMARY KEY");
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((String)"Unexpected exception", (long)SQLExceptionCode.CANNOT_MUTATE_TABLE.getErrorCode(), (long)e.getErrorCode());
            }
            try {
                conn.createStatement().execute("ALTER TABLE " + tableName + " ADD VIEW_COL1 DECIMAL PRIMARY KEY, VIEW_COL2 VARCHAR PRIMARY KEY, VIEW_COL3 VARCHAR PRIMARY KEY, VIEW_COL4 DECIMAL PRIMARY KEY");
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((String)"Unexpected exception", (long)SQLExceptionCode.CANNOT_MUTATE_TABLE.getErrorCode(), (long)e.getErrorCode());
            }
            try {
                conn.createStatement().execute("ALTER TABLE " + tableName + " ADD VIEW_COL3 VARCHAR PRIMARY KEY, VIEW_COL4 DECIMAL PRIMARY KEY, VIEW_COL1 DECIMAL PRIMARY KEY, VIEW_COL2 VARCHAR PRIMARY KEY");
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((String)"Unexpected exception", (long)SQLExceptionCode.CANNOT_MUTATE_TABLE.getErrorCode(), (long)e.getErrorCode());
            }
        }
    }

    @Test
    public void testAddExistingViewPkColumnToBaseTableWithMultipleViewsHavingSamePks() throws Exception {
        try (Connection conn = DriverManager.getConnection(AlterTableWithViewsIT.getUrl());
             Connection viewConn = this.isMultiTenant ? DriverManager.getConnection(this.TENANT_SPECIFIC_URL1) : conn;
             Connection viewConn2 = this.isMultiTenant ? DriverManager.getConnection(this.TENANT_SPECIFIC_URL1) : conn;){
            conn.setAutoCommit(false);
            viewConn.setAutoCommit(false);
            viewConn2.setAutoCommit(false);
            String tableName = SchemaUtil.getTableName((String)SCHEMA1, (String)AlterTableWithViewsIT.generateUniqueName());
            String viewOfTable1 = SchemaUtil.getTableName((String)SCHEMA2, (String)AlterTableWithViewsIT.generateUniqueName());
            String viewOfTable2 = SchemaUtil.getTableName((String)SCHEMA3, (String)AlterTableWithViewsIT.generateUniqueName());
            String ddlFormat = "CREATE TABLE IF NOT EXISTS " + tableName + "( %s ID char(10) NOT NULL, COL1 integer NOT NULL, COL2 integer NOT NULL, CONSTRAINT NAME_PK PRIMARY KEY (%s ID, COL1, COL2) ) %s";
            conn.createStatement().execute(this.generateDDL(ddlFormat));
            this.assertTableDefinition(conn, tableName, PTableType.TABLE, null, 0, 3, -1, true, "ID", "COL1", "COL2");
            viewConn.createStatement().execute("CREATE VIEW " + viewOfTable1 + " ( VIEW_COL1 DECIMAL(10,2), VIEW_COL2 VARCHAR(256) CONSTRAINT pk PRIMARY KEY (VIEW_COL1, VIEW_COL2)) AS SELECT * FROM " + tableName);
            this.assertTableDefinition(viewConn, viewOfTable1, PTableType.VIEW, tableName, 0, 5, 3, true, "ID", "COL1", "COL2", "VIEW_COL1", "VIEW_COL2");
            viewConn2.createStatement().execute("CREATE VIEW " + viewOfTable2 + " ( VIEW_COL1 DECIMAL(10,2), VIEW_COL2 VARCHAR(256) CONSTRAINT pk PRIMARY KEY (VIEW_COL1, VIEW_COL2)) AS SELECT * FROM " + tableName);
            this.assertTableDefinition(viewConn2, viewOfTable2, PTableType.VIEW, tableName, 0, 5, 3, true, "ID", "COL1", "COL2", "VIEW_COL1", "VIEW_COL2");
            String dml = "UPSERT INTO " + viewOfTable1 + " VALUES(?,?,?,?,?)";
            PreparedStatement stmt = viewConn.prepareStatement(dml);
            stmt.setString(1, "view1");
            stmt.setInt(2, 12);
            stmt.setInt(3, 13);
            stmt.setInt(4, 14);
            stmt.setString(5, "view5");
            stmt.execute();
            viewConn.commit();
            dml = "UPSERT INTO " + viewOfTable2 + " VALUES(?,?,?,?,?)";
            stmt = viewConn2.prepareStatement(dml);
            stmt.setString(1, "view1");
            stmt.setInt(2, 12);
            stmt.setInt(3, 13);
            stmt.setInt(4, 14);
            stmt.setString(5, "view5");
            stmt.execute();
            viewConn2.commit();
            try {
                conn.createStatement().execute("ALTER TABLE " + tableName + " ADD VIEW_COL1 DECIMAL(10,2) PRIMARY KEY");
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((String)"Unexpected exception", (long)SQLExceptionCode.CANNOT_MUTATE_TABLE.getErrorCode(), (long)e.getErrorCode());
            }
            try {
                conn.createStatement().execute("ALTER TABLE " + tableName + " ADD VIEW_COL2 VARCHAR(256) PRIMARY KEY");
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((String)"Unexpected exception", (long)SQLExceptionCode.CANNOT_MUTATE_TABLE.getErrorCode(), (long)e.getErrorCode());
            }
            try {
                conn.createStatement().execute("ALTER TABLE " + tableName + " ADD VIEW_COL2 DECIMAL(10,2) PRIMARY KEY, VIEW_COL1 VARCHAR(256) PRIMARY KEY");
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((String)"Unexpected exception", (long)SQLExceptionCode.CANNOT_MUTATE_TABLE.getErrorCode(), (long)e.getErrorCode());
            }
            conn.createStatement().execute("ALTER TABLE " + tableName + " ADD VIEW_COL1 DECIMAL(10,2) PRIMARY KEY, VIEW_COL2 VARCHAR(256) PRIMARY KEY");
            this.assertTableDefinition(conn, tableName, PTableType.TABLE, null, 1, 5, -1, false, "ID", "COL1", "COL2", "VIEW_COL1", "VIEW_COL2");
            this.assertTableDefinition(viewConn, viewOfTable1, PTableType.VIEW, tableName, 0, 5, 3, true, "ID", "COL1", "COL2", "VIEW_COL1", "VIEW_COL2");
            this.assertTableDefinition(viewConn, viewOfTable2, PTableType.VIEW, tableName, 0, 5, 3, true, "ID", "COL1", "COL2", "VIEW_COL1", "VIEW_COL2");
            ResultSet rs = stmt.executeQuery("SELECT * FROM " + tableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"view1", (Object)rs.getString("ID"));
            Assert.assertEquals((long)12L, (long)rs.getInt("COL1"));
            Assert.assertEquals((long)13L, (long)rs.getInt("COL2"));
            Assert.assertEquals((long)14L, (long)rs.getInt("VIEW_COL1"));
            Assert.assertEquals((Object)"view5", (Object)rs.getString("VIEW_COL2"));
            Assert.assertFalse((boolean)rs.next());
            rs = viewConn.createStatement().executeQuery("SELECT * FROM " + viewOfTable1);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"view1", (Object)rs.getString("ID"));
            Assert.assertEquals((long)12L, (long)rs.getInt("COL1"));
            Assert.assertEquals((long)13L, (long)rs.getInt("COL2"));
            Assert.assertEquals((long)14L, (long)rs.getInt("VIEW_COL1"));
            Assert.assertEquals((Object)"view5", (Object)rs.getString("VIEW_COL2"));
            Assert.assertFalse((boolean)rs.next());
            rs = viewConn2.createStatement().executeQuery("SELECT * FROM " + viewOfTable2);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"view1", (Object)rs.getString("ID"));
            Assert.assertEquals((long)12L, (long)rs.getInt("COL1"));
            Assert.assertEquals((long)13L, (long)rs.getInt("COL2"));
            Assert.assertEquals((long)14L, (long)rs.getInt("VIEW_COL1"));
            Assert.assertEquals((Object)"view5", (Object)rs.getString("VIEW_COL2"));
            Assert.assertFalse((boolean)rs.next());
            PTable table = conn.unwrap(PhoenixConnection.class).getTable(new PTableKey(null, tableName));
            this.assertColumnsMatch(table.getColumns(), "ID", "COL1", "COL2", "VIEW_COL1", "VIEW_COL2");
        }
    }

    public void assertTableDefinition(Connection conn, String fullTableName, PTableType tableType, String parentTableName, int sequenceNumber, int columnCount, int baseColumnCount, boolean offsetCountsForSaltedTables, String ... columnNames) throws Exception {
        int delta = 0;
        delta += this.isMultiTenant ? 1 : 0;
        if (offsetCountsForSaltedTables) {
            delta += this.salted ? 1 : 0;
        }
        String[] cols = this.isMultiTenant && tableType != PTableType.VIEW ? (String[])ArrayUtils.addAll((Object[])new String[]{"TENANT_ID"}, (Object[])columnNames) : columnNames;
        AlterMultiTenantTableWithViewsIT.assertTableDefinition(conn, fullTableName, tableType, parentTableName, sequenceNumber, columnCount + delta, baseColumnCount == -1 ? baseColumnCount : baseColumnCount + delta, cols);
    }

    private void assertBaseColumnCount(int expected, int actual) {
        if (this.salted) {
            ++expected;
        }
        if (this.isMultiTenant) {
            ++expected;
        }
        Assert.assertEquals((String)"Base column count does not match", (long)expected, (long)actual);
    }

    private void assertColumnsMatch(List<PColumn> actual, String ... expected) {
        ArrayList expectedCols = Lists.newArrayList((Object[])expected);
        if (this.isMultiTenant) {
            expectedCols.add(0, "TENANT_ID");
        }
        if (this.salted) {
            expectedCols.add(0, "_SALT");
        }
        Assert.assertEquals((Object)expectedCols, (Object)Lists.transform(actual, this.function));
    }

    public static String getSystemCatalogEntriesForTable(Connection conn, String tableName, String message) throws Exception {
        StringBuilder sb = new StringBuilder(message);
        sb.append("\n\n\n");
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM \"SYSTEM\".\"CATALOG\" WHERE TABLE_NAME='" + tableName + "'");
        ResultSetMetaData metaData = rs.getMetaData();
        int rowNum = 0;
        while (rs.next()) {
            sb.append(rowNum++).append("------\n");
            for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                sb.append("\t").append(metaData.getColumnLabel(i)).append("=").append(rs.getString(i)).append("\n");
            }
            sb.append("\n");
        }
        rs.close();
        return sb.toString();
    }

    @Test
    public void testAlteringViewThatHasChildViews() throws Exception {
        String baseTable = SchemaUtil.getTableName((String)SCHEMA1, (String)AlterTableWithViewsIT.generateUniqueName());
        String childView = SchemaUtil.getTableName((String)SCHEMA2, (String)AlterTableWithViewsIT.generateUniqueName());
        String grandChildView = SchemaUtil.getTableName((String)SCHEMA4, (String)AlterTableWithViewsIT.generateUniqueName());
        try (PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(AlterTableWithViewsIT.getUrl());
             PhoenixConnection viewConn = this.isMultiTenant ? (PhoenixConnection)DriverManager.getConnection(this.TENANT_SPECIFIC_URL1) : conn;){
            String ddlFormat = "CREATE TABLE IF NOT EXISTS " + baseTable + "  ( %s PK2 VARCHAR NOT NULL, V1 VARCHAR, V2 VARCHAR  CONSTRAINT NAME_PK PRIMARY KEY (%s PK2) ) %s";
            conn.createStatement().execute(this.generateDDL(ddlFormat));
            String childViewDDL = "CREATE VIEW " + childView + " AS SELECT * FROM " + baseTable;
            viewConn.createStatement().execute(childViewDDL);
            PTable view = viewConn.getTableNoCache(childView.toUpperCase());
            this.assertColumnsMatch(view.getColumns(), "PK2", "V1", "V2");
            String grandChildViewDDL = "CREATE VIEW " + grandChildView + " AS SELECT * FROM " + childView;
            viewConn.createStatement().execute(grandChildViewDDL);
            String addColumnToChildViewDDL = "ALTER VIEW " + childView + " ADD CHILD_VIEW_COL VARCHAR";
            viewConn.createStatement().execute(addColumnToChildViewDDL);
            view = viewConn.getTableNoCache(childView.toUpperCase());
            this.assertColumnsMatch(view.getColumns(), "PK2", "V1", "V2", "CHILD_VIEW_COL");
            PTable gcView = viewConn.getTableNoCache(grandChildView.toUpperCase());
            this.assertColumnsMatch(gcView.getColumns(), "PK2", "V1", "V2", "CHILD_VIEW_COL");
            String dropColumnFromChildView = "ALTER VIEW " + childView + " DROP COLUMN V2";
            viewConn.createStatement().execute(dropColumnFromChildView);
            view = viewConn.getTableNoCache(childView.toUpperCase());
            this.assertColumnsMatch(view.getColumns(), "PK2", "V1", "CHILD_VIEW_COL");
            dropColumnFromChildView = "ALTER VIEW " + childView + " DROP COLUMN CHILD_VIEW_COL";
            viewConn.createStatement().execute(dropColumnFromChildView);
            view = viewConn.getTableNoCache(childView.toUpperCase());
            this.assertColumnsMatch(view.getColumns(), "PK2", "V1");
            String addColumnToChildView = "ALTER VIEW " + childView + " ADD V5 VARCHAR";
            viewConn.createStatement().execute(addColumnToChildView);
            viewConn.createStatement().execute("SELECT V5 FROM " + childView);
            viewConn.createStatement().execute("SELECT V5 FROM " + grandChildView);
            view = viewConn.getTableNoCache(childView.toUpperCase());
            this.assertColumnsMatch(view.getColumns(), "PK2", "V1", "V5");
            gcView = viewConn.getTableNoCache(grandChildView.toUpperCase());
            this.assertColumnsMatch(gcView.getColumns(), "PK2", "V1", "V5");
        }
    }

    @Test
    public void testDivergedViewsStayDiverged() throws Exception {
        String baseTable = SchemaUtil.getTableName((String)SCHEMA1, (String)AlterTableWithViewsIT.generateUniqueName());
        String view1 = SchemaUtil.getTableName((String)SCHEMA2, (String)AlterTableWithViewsIT.generateUniqueName());
        String view2 = SchemaUtil.getTableName((String)SCHEMA3, (String)AlterTableWithViewsIT.generateUniqueName());
        try (PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(AlterTableWithViewsIT.getUrl());
             PhoenixConnection viewConn = this.isMultiTenant ? (PhoenixConnection)DriverManager.getConnection(this.TENANT_SPECIFIC_URL1) : conn;
             PhoenixConnection viewConn2 = this.isMultiTenant ? (PhoenixConnection)DriverManager.getConnection(this.TENANT_SPECIFIC_URL2) : conn;){
            String ddlFormat = "CREATE TABLE IF NOT EXISTS " + baseTable + " ( %s PK1 VARCHAR NOT NULL, V0 VARCHAR, V1 VARCHAR, V2 VARCHAR  CONSTRAINT NAME_PK PRIMARY KEY (%s PK1) ) %s";
            conn.createStatement().execute(this.generateDDL(ddlFormat));
            String viewDDL = "CREATE VIEW " + view1 + " AS SELECT * FROM " + baseTable;
            viewConn.createStatement().execute(viewDDL);
            viewDDL = "CREATE VIEW " + view2 + " AS SELECT * FROM " + baseTable;
            viewConn2.createStatement().execute(viewDDL);
            String dropColumn = "ALTER VIEW " + view1 + " DROP COLUMN V2";
            viewConn.createStatement().execute(dropColumn);
            PTable table = viewConn.getTableNoCache(view1);
            Assert.assertEquals((long)-100L, (long)table.getBaseColumnCount());
            try {
                viewConn.createStatement().execute("SELECT V2 FROM " + view1);
                Assert.fail((String)"V2 should have been droppped");
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.COLUMN_NOT_FOUND.getErrorCode(), (long)e.getErrorCode());
            }
            String alterBaseTable = "ALTER TABLE " + baseTable + " ADD V3 VARCHAR, PK2 VARCHAR PRIMARY KEY";
            conn.createStatement().execute(alterBaseTable);
            try {
                viewConn.createStatement().execute("SELECT V3 FROM " + view1);
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.COLUMN_NOT_FOUND.getErrorCode(), (long)e.getErrorCode());
            }
            viewConn2.createStatement().execute("SELECT V3 FROM " + view2);
            viewConn.createStatement().execute("SELECT PK2 FROM " + view1);
            viewConn2.createStatement().execute("SELECT PK2 FROM " + view2);
            alterBaseTable = "ALTER TABLE " + baseTable + " DROP COLUMN V1";
            conn.createStatement().execute(alterBaseTable);
            try {
                conn.createStatement().execute("SELECT V1 FROM " + baseTable);
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.COLUMN_NOT_FOUND.getErrorCode(), (long)e.getErrorCode());
            }
            try {
                viewConn2.createStatement().execute("SELECT V1 FROM " + view2);
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.COLUMN_NOT_FOUND.getErrorCode(), (long)e.getErrorCode());
            }
            try {
                viewConn.createStatement().execute("SELECT V1 FROM " + view1);
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.COLUMN_NOT_FOUND.getErrorCode(), (long)e.getErrorCode());
            }
            viewConn.createStatement().execute("SELECT V0 FROM " + view1);
            viewConn2.createStatement().execute("SELECT V0 FROM " + view2);
            try {
                viewConn.createStatement().execute("ALTER VIEW " + view1 + " ADD V2 VARCHAR");
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.CANNOT_MUTATE_TABLE.getErrorCode(), (long)e.getErrorCode());
            }
            try {
                viewConn.createStatement().execute("SELECT V2 FROM " + view1);
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.COLUMN_NOT_FOUND.getErrorCode(), (long)e.getErrorCode());
            }
        }
    }

    @Test
    public void testMakeBaseTableTransactional() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.setProperty("phoenix.transactions.enabled", Boolean.TRUE.toString());
        try (Connection conn = DriverManager.getConnection(AlterTableWithViewsIT.getUrl(), props);
             Connection viewConn = this.isMultiTenant ? DriverManager.getConnection(this.TENANT_SPECIFIC_URL1) : conn;){
            String baseTableName = SchemaUtil.getTableName((String)SCHEMA1, (String)AlterTableWithViewsIT.generateUniqueName());
            String viewOfTable = SchemaUtil.getTableName((String)SCHEMA2, (String)AlterTableWithViewsIT.generateUniqueName());
            String ddlFormat = "CREATE TABLE IF NOT EXISTS " + baseTableName + " ( %s ID char(1) NOT NULL, COL1 integer NOT NULL, COL2 bigint NOT NULL, CONSTRAINT NAME_PK PRIMARY KEY (%s ID, COL1, COL2) ) %s";
            conn.createStatement().execute(this.generateDDL(ddlFormat));
            this.assertTableDefinition(conn, baseTableName, PTableType.TABLE, null, 0, 3, -1, true, "ID", "COL1", "COL2");
            viewConn.createStatement().execute("CREATE VIEW " + viewOfTable + " ( VIEW_COL1 DECIMAL(10,2), VIEW_COL2 VARCHAR ) AS SELECT * FROM " + baseTableName);
            this.assertTableDefinition(viewConn, viewOfTable, PTableType.VIEW, baseTableName, 0, 5, 3, true, "ID", "COL1", "COL2", "VIEW_COL1", "VIEW_COL2");
            PName tenantId = this.isMultiTenant ? PNameFactory.newName((String)TENANT1) : null;
            PhoenixConnection phoenixConn = conn.unwrap(PhoenixConnection.class);
            Table table = phoenixConn.getQueryServices().getTable(Bytes.toBytes((String)baseTableName));
            Assert.assertFalse((boolean)phoenixConn.getTable(new PTableKey(null, baseTableName)).isTransactional());
            Assert.assertFalse((boolean)viewConn.unwrap(PhoenixConnection.class).getTable(new PTableKey(tenantId, viewOfTable)).isTransactional());
        }
    }

    @Test
    public void testAlterTablePropertyOnView() throws Exception {
        try (Connection conn = DriverManager.getConnection(AlterTableWithViewsIT.getUrl());
             Connection viewConn = this.isMultiTenant ? DriverManager.getConnection(this.TENANT_SPECIFIC_URL1) : conn;){
            String baseTableName = SchemaUtil.getTableName((String)SCHEMA1, (String)AlterTableWithViewsIT.generateUniqueName());
            String viewOfTable = SchemaUtil.getTableName((String)SCHEMA2, (String)AlterTableWithViewsIT.generateUniqueName());
            String ddl = "CREATE TABLE " + baseTableName + " (\n%s ID VARCHAR(15) NOT NULL,\n COL1 integer NOT NULL,CREATED_DATE DATE,\nCONSTRAINT PK PRIMARY KEY (%s ID, COL1)) %s";
            conn.createStatement().execute(this.generateDDL(ddl));
            ddl = "CREATE VIEW " + viewOfTable + " AS SELECT * FROM " + baseTableName;
            viewConn.createStatement().execute(ddl);
            try {
                viewConn.createStatement().execute("ALTER VIEW " + viewOfTable + " SET IMMUTABLE_ROWS = true");
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.CANNOT_ALTER_TABLE_PROPERTY_ON_VIEW.getErrorCode(), (long)e.getErrorCode());
            }
            viewConn.createStatement().execute("ALTER VIEW " + viewOfTable + " SET UPDATE_CACHE_FREQUENCY = 100");
            viewConn.createStatement().execute("SELECT * FROM " + viewOfTable);
            PName tenantId = this.isMultiTenant ? PNameFactory.newName((String)TENANT1) : null;
            Assert.assertEquals((long)100L, (long)viewConn.unwrap(PhoenixConnection.class).getTable(new PTableKey(tenantId, viewOfTable)).getUpdateCacheFrequency());
            try {
                viewConn.createStatement().execute("ALTER VIEW " + viewOfTable + " SET APPEND_ONLY_SCHEMA = true");
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.CANNOT_ALTER_TABLE_PROPERTY_ON_VIEW.getErrorCode(), (long)e.getErrorCode());
            }
        }
    }

    @Test
    public void testAlterAppendOnlySchema() throws Exception {
        try (Connection conn = DriverManager.getConnection(AlterTableWithViewsIT.getUrl());
             Connection viewConn = this.isMultiTenant ? DriverManager.getConnection(this.TENANT_SPECIFIC_URL1) : conn;){
            String baseTableName = SchemaUtil.getTableName((String)SCHEMA1, (String)AlterTableWithViewsIT.generateUniqueName());
            String viewOfTable = SchemaUtil.getTableName((String)SCHEMA2, (String)AlterTableWithViewsIT.generateUniqueName());
            String ddl = "CREATE TABLE " + baseTableName + " (\n%s ID VARCHAR(15) NOT NULL,\n COL1 integer NOT NULL,CREATED_DATE DATE,\nCONSTRAINT PK PRIMARY KEY (%s ID, COL1)) %s";
            conn.createStatement().execute(this.generateDDL(ddl));
            ddl = "CREATE VIEW " + viewOfTable + " AS SELECT * FROM " + baseTableName;
            viewConn.createStatement().execute(ddl);
            PhoenixConnection phoenixConn = conn.unwrap(PhoenixConnection.class);
            PTable table = phoenixConn.getTable(new PTableKey(null, baseTableName));
            PName tenantId = this.isMultiTenant ? PNameFactory.newName((String)TENANT1) : null;
            Assert.assertFalse((boolean)table.isAppendOnlySchema());
            PTable viewTable = viewConn.unwrap(PhoenixConnection.class).getTable(new PTableKey(tenantId, viewOfTable));
            Assert.assertFalse((boolean)viewTable.isAppendOnlySchema());
            try {
                viewConn.createStatement().execute("ALTER VIEW " + viewOfTable + " SET APPEND_ONLY_SCHEMA = true");
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.CANNOT_ALTER_TABLE_PROPERTY_ON_VIEW.getErrorCode(), (long)e.getErrorCode());
            }
            conn.createStatement().execute("ALTER TABLE " + baseTableName + " SET APPEND_ONLY_SCHEMA = true");
            viewConn.createStatement().execute("SELECT * FROM " + viewOfTable);
            phoenixConn = conn.unwrap(PhoenixConnection.class);
            table = phoenixConn.getTable(new PTableKey(null, baseTableName));
            Assert.assertTrue((boolean)table.isAppendOnlySchema());
            viewTable = viewConn.unwrap(PhoenixConnection.class).getTable(new PTableKey(tenantId, viewOfTable));
            Assert.assertTrue((boolean)viewTable.isAppendOnlySchema());
        }
    }

    @Test
    public void testDroppingIndexedColDropsViewIndex() throws Exception {
        try (Connection conn = DriverManager.getConnection(AlterTableWithViewsIT.getUrl());
             Connection viewConn = this.isMultiTenant ? DriverManager.getConnection(this.TENANT_SPECIFIC_URL1) : conn;){
            String tableWithView = SchemaUtil.getTableName((String)SCHEMA1, (String)AlterTableWithViewsIT.generateUniqueName());
            String viewOfTable = SchemaUtil.getTableName((String)SCHEMA2, (String)AlterTableWithViewsIT.generateUniqueName());
            String viewSchemaName = SchemaUtil.getSchemaNameFromFullName((String)viewOfTable);
            String viewIndex1 = AlterTableWithViewsIT.generateUniqueName();
            String viewIndex2 = AlterTableWithViewsIT.generateUniqueName();
            String fullNameViewIndex1 = SchemaUtil.getTableName((String)viewSchemaName, (String)viewIndex1);
            String fullNameViewIndex2 = SchemaUtil.getTableName((String)viewSchemaName, (String)viewIndex2);
            List<String> fullViewIndexNames = Arrays.asList(fullNameViewIndex1, fullNameViewIndex2);
            conn.setAutoCommit(false);
            viewConn.setAutoCommit(false);
            String ddlFormat = "CREATE TABLE " + tableWithView + " (%s k VARCHAR NOT NULL, v1 VARCHAR, v2 VARCHAR, v3 VARCHAR, v4 VARCHAR CONSTRAINT PK PRIMARY KEY(%s k))%s";
            conn.createStatement().execute(this.generateDDL(ddlFormat));
            viewConn.createStatement().execute("CREATE VIEW " + viewOfTable + " ( VIEW_COL1 DECIMAL(10,2), VIEW_COL2 VARCHAR ) AS SELECT * FROM " + tableWithView);
            viewConn.createStatement().execute("CREATE INDEX " + viewIndex1 + " ON " + viewOfTable + "(v2) INCLUDE (v4)");
            viewConn.createStatement().execute("CREATE INDEX " + viewIndex2 + " ON " + viewOfTable + "(v1) INCLUDE (v4)");
            try {
                viewConn.createStatement().execute("SELECT * FROM " + fullNameViewIndex1);
            }
            catch (TableNotFoundException e) {
                Assert.fail((String)"Index on view was not created");
            }
            PreparedStatement stmt = viewConn.prepareStatement("UPSERT INTO " + viewOfTable + " VALUES(?,?,?,?,?,?,?)");
            stmt.setString(1, "a");
            stmt.setString(2, "b");
            stmt.setString(3, "c");
            stmt.setString(4, "d");
            stmt.setString(5, "e");
            stmt.setInt(6, 1);
            stmt.setString(7, "g");
            stmt.execute();
            viewConn.commit();
            PhoenixConnection pconn = viewConn.unwrap(PhoenixConnection.class);
            PName tenantId = this.isMultiTenant ? PNameFactory.newName((String)TENANT1) : null;
            PTable view = pconn.getTable(new PTableKey(tenantId, viewOfTable));
            PTable viewIndex = pconn.getTable(new PTableKey(tenantId, fullNameViewIndex1));
            byte[] viewIndexPhysicalTable = viewIndex.getPhysicalName().getBytes();
            Assert.assertNotNull((String)"Can't find view index", (Object)viewIndex);
            Assert.assertEquals((String)"Unexpected number of indexes ", (long)2L, (long)view.getIndexes().size());
            Assert.assertTrue((String)"Expected index not found ", (boolean)fullViewIndexNames.contains(((PTable)view.getIndexes().get(0)).getName().getString()));
            Assert.assertTrue((String)"Expected index not found ", (boolean)fullViewIndexNames.contains(((PTable)view.getIndexes().get(1)).getName().getString()));
            Assert.assertEquals((String)"Unexpected salt buckets", (Object)view.getBucketNum(), (Object)((PTable)view.getIndexes().get(0)).getBucketNum());
            Assert.assertEquals((String)"Unexpected salt buckets", (Object)view.getBucketNum(), (Object)((PTable)view.getIndexes().get(1)).getBucketNum());
            conn.createStatement().execute("ALTER TABLE " + tableWithView + " DROP COLUMN v2, v3 ");
            try {
                conn.createStatement().execute("SELECT v2 FROM " + tableWithView);
                Assert.fail((String)"Column should have been dropped");
            }
            catch (ColumnNotFoundException columnNotFoundException) {
                // empty catch block
            }
            try {
                conn.createStatement().execute("SELECT v3 FROM " + tableWithView);
                Assert.fail((String)"Column should have been dropped");
            }
            catch (ColumnNotFoundException columnNotFoundException) {
                // empty catch block
            }
            try {
                viewConn.createStatement().execute("SELECT * FROM " + fullNameViewIndex1);
                Assert.fail((String)"Index metadata should have been dropped");
            }
            catch (TableNotFoundException tableNotFoundException) {
                // empty catch block
            }
            pconn = viewConn.unwrap(PhoenixConnection.class);
            view = pconn.getTableNoCache(viewOfTable);
            Assert.assertEquals((String)"Unexpected number of indexes ", (long)1L, (long)view.getIndexes().size());
            Assert.assertEquals((String)"Unexpected index ", (Object)fullNameViewIndex2, (Object)((PTable)view.getIndexes().get(0)).getName().getString());
            Assert.assertNotEquals((String)"Dropped index should not be in view metadata ", (Object)fullNameViewIndex1, (Object)((PTable)view.getIndexes().get(0)).getName().getString());
            try {
                viewIndex = pconn.getTableNoCache(fullNameViewIndex1);
                Assert.fail((String)"View index should have been dropped");
            }
            catch (TableNotFoundException tableNotFoundException) {
                // empty catch block
            }
            conn.unwrap(PhoenixConnection.class).getQueryServices().getTableDescriptor(viewIndexPhysicalTable);
            Scan scan = new Scan();
            Table table = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(viewIndexPhysicalTable);
            ResultScanner results = table.getScanner(scan);
            Result result = results.next();
            Assert.assertNotNull((Object)result);
            PTable viewIndexPTable = pconn.getTable(new PTableKey(pconn.getTenantId(), fullNameViewIndex2));
            PColumn column = viewIndexPTable.getColumnForColumnName(IndexUtil.getIndexColumnName((String)"0", (String)"V4"));
            byte[] cq = column.getColumnQualifierBytes();
            Assert.assertNotNull((String)(fullNameViewIndex2 + " row is missing"), (Object)result.getValue(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, cq));
            Assert.assertNull((Object)results.next());
        }
    }

    @Test
    public void testAddThenDropColumnTableDDLTimestamp() throws Exception {
        Properties props = new Properties();
        String schemaName = SCHEMA1;
        String dataTableName = "T_" + AlterTableWithViewsIT.generateUniqueName();
        String viewName = "V_" + AlterTableWithViewsIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String viewFullName = SchemaUtil.getTableName((String)schemaName, (String)viewName);
        String tableDDL = this.generateDDL("CREATE TABLE IF NOT EXISTS " + dataTableFullName + " ( %s ID char(1) NOT NULL, COL1 integer NOT NULL, COL2 bigint NOT NULL, CONSTRAINT NAME_PK PRIMARY KEY (%s ID, COL1, COL2) ) %s");
        String viewDDL = "CREATE VIEW " + viewFullName + " AS SELECT * FROM " + dataTableFullName;
        String columnAddDDL = "ALTER VIEW " + viewFullName + " ADD COL3 varchar(50) NULL ";
        String columnDropDDL = "ALTER VIEW " + viewFullName + " DROP COLUMN COL3 ";
        long startTS = EnvironmentEdgeManager.currentTimeMillis();
        try (Connection conn = DriverManager.getConnection(AlterTableWithViewsIT.getUrl(), props);){
            conn.createStatement().execute(tableDDL);
            long tableDDLTimestamp = CreateTableIT.verifyLastDDLTimestamp(dataTableFullName, startTS, conn);
            Thread.sleep(1L);
            conn.createStatement().execute(viewDDL);
            tableDDLTimestamp = CreateTableIT.verifyLastDDLTimestamp(viewFullName, tableDDLTimestamp + 1L, conn);
            Thread.sleep(1L);
            conn.createStatement().execute(columnAddDDL);
            tableDDLTimestamp = CreateTableIT.verifyLastDDLTimestamp(viewFullName, tableDDLTimestamp + 1L, conn);
            Thread.sleep(1L);
            conn.createStatement().execute(columnDropDDL);
            CreateTableIT.verifyLastDDLTimestamp(viewFullName, tableDDLTimestamp + 1L, conn);
        }
    }

    @Test
    public void testLastDDLTimestampForDivergedViews() throws Exception {
        String schemaName = SCHEMA1;
        String dataTableName = "T_" + AlterTableWithViewsIT.generateUniqueName();
        String viewName = "V_" + AlterTableWithViewsIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String viewFullName = SchemaUtil.getTableName((String)schemaName, (String)viewName);
        String tableDDL = this.generateDDL("CREATE TABLE IF NOT EXISTS " + dataTableFullName + " ( %s ID char(1) NOT NULL, COL1 integer NOT NULL, COL2 bigint, COL3 bigint, CONSTRAINT NAME_PK PRIMARY KEY (%s ID, COL1) ) %s");
        String viewDDL = "CREATE VIEW " + viewFullName + " AS SELECT * FROM " + dataTableFullName;
        String divergeDDL = "ALTER VIEW " + viewFullName + " DROP COLUMN COL2";
        String viewColumnAddDDL = "ALTER VIEW " + viewFullName + " ADD COL4 varchar(50) NULL ";
        String viewColumnDropDDL = "ALTER VIEW " + viewFullName + " DROP COLUMN COL4 ";
        String tableColumnAddDDL = "ALTER TABLE " + dataTableFullName + " ADD COL5 varchar(50) NULL";
        String tableColumnDropDDL = "ALTER TABLE " + dataTableFullName + " DROP COLUMN COL3 ";
        try (Connection conn = DriverManager.getConnection(AlterTableWithViewsIT.getUrl());){
            conn.createStatement().execute(tableDDL);
            long tableDDLTimestamp = CreateTableIT.getLastDDLTimestamp(conn, dataTableFullName);
            conn.createStatement().execute(viewDDL);
            long viewDDLTimestamp = CreateTableIT.getLastDDLTimestamp(conn, viewFullName);
            Thread.sleep(1L);
            conn.createStatement().execute(divergeDDL);
            Assert.assertEquals((long)tableDDLTimestamp, (long)CreateTableIT.getLastDDLTimestamp(conn, dataTableFullName));
            viewDDLTimestamp = CreateTableIT.verifyLastDDLTimestamp(viewFullName, viewDDLTimestamp + 1L, conn);
            Thread.sleep(1L);
            conn.createStatement().execute(viewColumnAddDDL);
            viewDDLTimestamp = CreateTableIT.verifyLastDDLTimestamp(viewFullName, viewDDLTimestamp + 1L, conn);
            Thread.sleep(1L);
            conn.createStatement().execute(viewColumnDropDDL);
            viewDDLTimestamp = CreateTableIT.verifyLastDDLTimestamp(viewFullName, viewDDLTimestamp + 1L, conn);
            Thread.sleep(1L);
            conn.createStatement().execute(tableColumnAddDDL);
            viewDDLTimestamp = CreateTableIT.verifyLastDDLTimestamp(viewFullName, viewDDLTimestamp + 1L, conn);
            conn.createStatement().execute(tableColumnDropDDL);
            viewDDLTimestamp = CreateTableIT.verifyLastDDLTimestamp(viewFullName, viewDDLTimestamp + 1L, conn);
        }
    }

    @Test
    public void testLastDDLTimestampWithChildViews() throws Exception {
        Throwable throwable;
        long globalViewDDLTimestamp;
        long tableDDLTimestamp;
        Assume.assumeTrue((boolean)this.isMultiTenant);
        Properties props = new Properties();
        String schemaName = SCHEMA1;
        String dataTableName = "T_" + AlterTableWithViewsIT.generateUniqueName();
        String globalViewName = "V_" + AlterTableWithViewsIT.generateUniqueName();
        String tenantViewName = "V_" + AlterTableWithViewsIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String globalViewFullName = SchemaUtil.getTableName((String)schemaName, (String)globalViewName);
        String tenantViewFullName = SchemaUtil.getTableName((String)schemaName, (String)tenantViewName);
        String tableDDL = this.generateDDL("CREATE TABLE IF NOT EXISTS " + dataTableFullName + " ( %s ID char(1) NOT NULL, COL1 integer NOT NULL, COL2 bigint NOT NULL, CONSTRAINT NAME_PK PRIMARY KEY (%s ID, COL1, COL2) ) %s");
        String globalViewDDL = "CREATE VIEW " + globalViewFullName + " AS SELECT * FROM " + dataTableFullName;
        String tenantViewDDL = "CREATE VIEW " + tenantViewFullName + " AS SELECT * FROM " + globalViewFullName;
        long startTS = EnvironmentEdgeManager.currentTimeMillis();
        try (Connection conn = DriverManager.getConnection(AlterTableWithViewsIT.getUrl());){
            conn.createStatement().execute(tableDDL);
            conn.createStatement().execute(globalViewDDL);
            tableDDLTimestamp = CreateTableIT.getLastDDLTimestamp(conn, dataTableFullName);
            globalViewDDLTimestamp = CreateTableIT.getLastDDLTimestamp(conn, globalViewFullName);
        }
        props.setProperty("TenantId", TENANT1);
        var19_14 = null;
        try (Connection tenantConn = DriverManager.getConnection(AlterTableWithViewsIT.getUrl(), props);){
            tenantConn.createStatement().execute(tenantViewDDL);
        }
        catch (Throwable throwable2) {
            var19_14 = throwable2;
            throw throwable2;
        }
        conn = DriverManager.getConnection(AlterTableWithViewsIT.getUrl());
        var19_14 = null;
        try {
            long newTableDDLTimestamp = CreateTableIT.getLastDDLTimestamp(conn, dataTableFullName);
            Assert.assertEquals((long)tableDDLTimestamp, (long)newTableDDLTimestamp);
            long newGlobalViewDDLTimestamp = CreateTableIT.getLastDDLTimestamp(conn, globalViewFullName);
            Assert.assertEquals((long)globalViewDDLTimestamp, (long)newGlobalViewDDLTimestamp);
        }
        catch (Throwable newTableDDLTimestamp) {
            var19_14 = newTableDDLTimestamp;
            throw newTableDDLTimestamp;
        }
        finally {
            if (conn != null) {
                if (var19_14 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable newTableDDLTimestamp) {
                        var19_14.addSuppressed(newTableDDLTimestamp);
                    }
                } else {
                    conn.close();
                }
            }
        }
        Thread.sleep(1L);
        String tenantViewColumnAddDDL = "ALTER VIEW " + tenantViewFullName + " ADD COL3 varchar(50) NULL ";
        String tenantViewColumnDropDDL = "ALTER VIEW " + tenantViewFullName + " DROP COLUMN COL3 ";
        try (Connection tenantConn = DriverManager.getConnection(AlterTableWithViewsIT.getUrl(), props);){
            tenantConn.createStatement().execute(tenantViewColumnAddDDL);
            long newTableDDLTimestamp = CreateTableIT.getLastDDLTimestamp(tenantConn, dataTableFullName);
            Assert.assertEquals((long)tableDDLTimestamp, (long)newTableDDLTimestamp);
            long afterTenantColumnAddViewDDLTimestamp = CreateTableIT.getLastDDLTimestamp(tenantConn, globalViewFullName);
            Assert.assertEquals((long)globalViewDDLTimestamp, (long)afterTenantColumnAddViewDDLTimestamp);
            tenantConn.createStatement().execute(tenantViewColumnDropDDL);
            long afterTenantColumnDropTableDDLTimestamp = CreateTableIT.getLastDDLTimestamp(tenantConn, dataTableFullName);
            Assert.assertEquals((long)tableDDLTimestamp, (long)afterTenantColumnDropTableDDLTimestamp);
            long afterTenantColumnDropViewDDLTimestamp = CreateTableIT.getLastDDLTimestamp(tenantConn, globalViewFullName);
            Assert.assertEquals((long)globalViewDDLTimestamp, (long)afterTenantColumnDropViewDDLTimestamp);
        }
        Thread.sleep(1L);
        String tableColumnAddDDL = "ALTER TABLE " + dataTableFullName + " ADD COL4 varchar(50) NULL ";
        String tableColumnDropDDL = "ALTER TABLE " + dataTableFullName + " DROP COLUMN COL4 ";
        try (Connection conn = DriverManager.getConnection(AlterTableWithViewsIT.getUrl());){
            conn.createStatement().execute(tableColumnAddDDL);
            tableDDLTimestamp = CreateTableIT.getLastDDLTimestamp(conn, dataTableFullName);
            throwable = null;
            try (Connection tenantConn = DriverManager.getConnection(AlterTableWithViewsIT.getUrl(), props);){
                long tenantViewDDLTimestamp = CreateTableIT.getLastDDLTimestamp(tenantConn, tenantViewFullName);
                Assert.assertEquals((long)tableDDLTimestamp, (long)tenantViewDDLTimestamp);
            }
            catch (Throwable tenantViewDDLTimestamp) {
                throwable = tenantViewDDLTimestamp;
                throw tenantViewDDLTimestamp;
            }
            globalViewDDLTimestamp = CreateTableIT.getLastDDLTimestamp(conn, globalViewFullName);
            Assert.assertEquals((long)tableDDLTimestamp, (long)globalViewDDLTimestamp);
            conn.createStatement().execute(tableColumnDropDDL);
            tableDDLTimestamp = CreateTableIT.getLastDDLTimestamp(conn, dataTableFullName);
            tenantConn = DriverManager.getConnection(AlterTableWithViewsIT.getUrl(), props);
            throwable = null;
            try {
                long tenantViewDDLTimestamp = CreateTableIT.getLastDDLTimestamp(tenantConn, tenantViewFullName);
                Assert.assertEquals((long)tableDDLTimestamp, (long)tenantViewDDLTimestamp);
            }
            catch (Throwable tenantViewDDLTimestamp) {
                throwable = tenantViewDDLTimestamp;
                throw tenantViewDDLTimestamp;
            }
            finally {
                if (tenantConn != null) {
                    if (throwable != null) {
                        try {
                            tenantConn.close();
                        }
                        catch (Throwable tenantViewDDLTimestamp) {
                            throwable.addSuppressed(tenantViewDDLTimestamp);
                        }
                    } else {
                        tenantConn.close();
                    }
                }
            }
            globalViewDDLTimestamp = CreateTableIT.getLastDDLTimestamp(conn, globalViewFullName);
            Assert.assertEquals((long)tableDDLTimestamp, (long)globalViewDDLTimestamp);
        }
        String globalViewColumnAddDDL = "ALTER VIEW " + globalViewFullName + " ADD COL5 varchar(50) NULL ";
        String globalViewColumnDropDDL = "ALTER VIEW " + globalViewFullName + " DROP COLUMN COL5 ";
        throwable = null;
        try (Connection conn = DriverManager.getConnection(AlterTableWithViewsIT.getUrl());){
            conn.createStatement().execute(globalViewColumnAddDDL);
            globalViewDDLTimestamp = CreateTableIT.getLastDDLTimestamp(conn, globalViewFullName);
            long newTableDDLTimestamp = CreateTableIT.getLastDDLTimestamp(conn, dataTableFullName);
            Assert.assertEquals((long)tableDDLTimestamp, (long)newTableDDLTimestamp);
            try (Connection tenantConn = DriverManager.getConnection(AlterTableWithViewsIT.getUrl(), props);){
                long tenantViewDDLTimestamp = CreateTableIT.getLastDDLTimestamp(tenantConn, tenantViewFullName);
                Assert.assertEquals((long)globalViewDDLTimestamp, (long)tenantViewDDLTimestamp);
            }
            conn.createStatement().execute(globalViewColumnDropDDL);
            globalViewDDLTimestamp = CreateTableIT.getLastDDLTimestamp(conn, globalViewFullName);
            newTableDDLTimestamp = CreateTableIT.getLastDDLTimestamp(conn, dataTableFullName);
            Assert.assertEquals((long)tableDDLTimestamp, (long)newTableDDLTimestamp);
            tenantConn = DriverManager.getConnection(AlterTableWithViewsIT.getUrl(), props);
            var29_68 = null;
            try {
                long tenantViewDDLTimestamp = CreateTableIT.getLastDDLTimestamp(tenantConn, tenantViewFullName);
                Assert.assertEquals((long)globalViewDDLTimestamp, (long)tenantViewDDLTimestamp);
            }
            catch (Throwable throwable3) {
                var29_68 = throwable3;
                throw throwable3;
            }
            finally {
                if (tenantConn != null) {
                    if (var29_68 != null) {
                        try {
                            tenantConn.close();
                        }
                        catch (Throwable throwable4) {
                            var29_68.addSuppressed(throwable4);
                        }
                    } else {
                        tenantConn.close();
                    }
                }
            }
        }
        catch (Throwable throwable5) {
            throwable = throwable5;
            throw throwable5;
        }
    }

    @Test
    public void testCreateViewSchemaVersion() throws Exception {
        Properties props = new Properties();
        String schemaName = AlterTableWithViewsIT.generateUniqueName();
        String tableName = AlterTableWithViewsIT.generateUniqueName();
        String viewName = AlterTableWithViewsIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        String viewFullName = SchemaUtil.getTableName((String)schemaName, (String)viewName);
        try (PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(AlterTableWithViewsIT.getUrl(), props);){
            String oldVersion = "V1.0";
            CreateTableIT.testCreateTableSchemaVersionAndTopicNameHelper((Connection)conn, schemaName, tableName, oldVersion, null);
            String createViewSql = "CREATE VIEW " + viewFullName + " AS SELECT * FROM " + dataTableFullName + " SCHEMA_VERSION='" + oldVersion + "'";
            conn.createStatement().execute(createViewSql);
            PTable view = conn.getTableNoCache(viewFullName);
            Assert.assertEquals((Object)oldVersion, (Object)view.getSchemaVersion());
            Assert.assertNull((Object)view.getStreamingTopicName());
            String newVersion = "V1.1";
            String topicName = "MyTopicName";
            String alterViewSql = "ALTER VIEW " + viewFullName + " SET SCHEMA_VERSION='" + newVersion + "', STREAMING_TOPIC_NAME='" + topicName + "'";
            conn.createStatement().execute(alterViewSql);
            PTable view2 = conn.getTableNoCache(viewFullName);
            Assert.assertEquals((Object)newVersion, (Object)view2.getSchemaVersion());
            PTable baseTable = conn.getTableNoCache(dataTableFullName);
            Assert.assertEquals((Object)oldVersion, (Object)baseTable.getSchemaVersion());
            Assert.assertNull((Object)baseTable.getStreamingTopicName());
            Assert.assertEquals((Object)topicName, (Object)view2.getStreamingTopicName());
        }
    }
}

