/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PDouble;
import org.apache.phoenix.schema.types.PFloat;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.util.ColumnInfo;
import org.apache.phoenix.util.SchemaUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={ParallelStatsDisabledTest.class})
@RunWith(value=Parameterized.class)
public class AlterAddCascadeIndexIT
extends ParallelStatsDisabledIT {
    public static final String SYNTAX_ERROR = "Syntax error";
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private static Connection conn;
    private Properties prop;
    private boolean isViewScenario;
    private boolean mutable;
    private String phoenixObjectName;
    private String indexNames;
    private final String tableDDLOptions;
    String fullIndexNameOne;
    String fullIndexNameTwo;
    String fullTableName;

    public AlterAddCascadeIndexIT(boolean isViewScenario, boolean mutable) {
        this.isViewScenario = isViewScenario;
        StringBuilder optionBuilder = new StringBuilder("COLUMN_ENCODED_BYTES=0");
        if (!mutable) {
            optionBuilder.append(", IMMUTABLE_ROWS=true, IMMUTABLE_STORAGE_SCHEME='ONE_CELL_PER_COLUMN'");
        }
        this.mutable = mutable;
        this.tableDDLOptions = optionBuilder.toString();
    }

    @Parameterized.Parameters(name="AlterAddCascadeIndexIT_isViewIndex={0},mutable={1}")
    public static Collection<Object[]> data() {
        return Arrays.asList({true, true}, {true, false}, {false, true}, {false, false});
    }

    @Before
    public void setup() throws SQLException {
        this.prop = new Properties();
        conn = DriverManager.getConnection(AlterAddCascadeIndexIT.getUrl(), this.prop);
        conn.setAutoCommit(true);
        String schemaName = "S_" + AlterAddCascadeIndexIT.generateUniqueName();
        String indexNameOne = "I_" + AlterAddCascadeIndexIT.generateUniqueName();
        String indexNameTwo = "I_" + AlterAddCascadeIndexIT.generateUniqueName();
        String tableName = "T_" + AlterAddCascadeIndexIT.generateUniqueName();
        String viewName = "V_" + AlterAddCascadeIndexIT.generateUniqueName();
        String fullViewName = SchemaUtil.getQualifiedTableName((String)schemaName, (String)viewName);
        this.fullTableName = SchemaUtil.getQualifiedTableName((String)schemaName, (String)tableName);
        conn.createStatement().execute("CREATE TABLE IF NOT EXISTS " + this.fullTableName + " (\n      state CHAR(2) NOT NULL,\n      city VARCHAR NOT NULL,\n      population BIGINT,\n      CONSTRAINT my_pk PRIMARY KEY (state, city)) " + this.tableDDLOptions);
        if (this.isViewScenario) {
            conn.createStatement().execute("CREATE VIEW IF NOT EXISTS " + fullViewName + " (city_area INTEGER, avg_fam_size INTEGER) AS SELECT * FROM " + this.fullTableName + " WHERE state = 'CA'");
            conn.createStatement().execute("CREATE INDEX IF NOT EXISTS " + indexNameOne + " ON " + fullViewName + " (city_area) INCLUDE (population)");
            conn.createStatement().execute("CREATE INDEX IF NOT EXISTS " + indexNameTwo + " ON " + fullViewName + " (avg_fam_size) INCLUDE (population)");
            this.phoenixObjectName = fullViewName;
        } else {
            conn.createStatement().execute("CREATE INDEX IF NOT EXISTS " + indexNameOne + " ON " + this.fullTableName + " (population)");
            conn.createStatement().execute("CREATE INDEX IF NOT EXISTS " + indexNameTwo + " ON " + this.fullTableName + " (state, population)");
            this.phoenixObjectName = this.fullTableName;
        }
        this.fullIndexNameOne = SchemaUtil.getQualifiedTableName((String)schemaName, (String)indexNameOne);
        this.fullIndexNameTwo = SchemaUtil.getQualifiedTableName((String)schemaName, (String)indexNameTwo);
        this.indexNames = indexNameOne + ", " + indexNameTwo;
    }

    @Test
    public void testAlterDBOAddCascadeIndexAllUpsert() throws Exception {
        String query = "ALTER " + (this.isViewScenario ? "VIEW " : "TABLE ") + this.phoenixObjectName + " ADD new_column_3 VARCHAR(64) CASCADE INDEX ALL";
        conn.createStatement().execute(query);
        PreparedStatement ps = this.isViewScenario ? conn.prepareStatement("UPSERT INTO " + this.phoenixObjectName + "(state,city,population,city_area,avg_fam_size,new_column_3) VALUES('CA','Santa Barbara',912332,1300,4,'test_column')") : conn.prepareStatement("UPSERT INTO " + this.phoenixObjectName + "(state,city,population,new_column_3) VALUES('CA','Santa Barbara',912332,'test_column')");
        ps.executeUpdate();
        ColumnInfo[] columnArray = new ColumnInfo[]{new ColumnInfo("new_column_3", PVarchar.INSTANCE.getSqlType(), Integer.valueOf(64))};
        ColumnInfo[] columnIndexArray = new ColumnInfo[]{new ColumnInfo("0:new_column_3", PVarchar.INSTANCE.getSqlType(), Integer.valueOf(64))};
        if (this.isViewScenario) {
            this.assertDBODefinition(conn, this.phoenixObjectName, PTableType.VIEW, 6, columnArray, false);
            this.assertDBODefinition(conn, this.fullIndexNameOne, PTableType.INDEX, 5, columnIndexArray, false);
            this.assertDBODefinition(conn, this.fullIndexNameTwo, PTableType.INDEX, 5, columnIndexArray, false);
            if (this.mutable) {
                this.assertNumberOfHBaseCells("_IDX_" + this.fullTableName, 6);
            } else {
                this.assertNumberOfHBaseCells("_IDX_" + this.fullTableName, 6);
            }
        } else {
            this.assertDBODefinition(conn, this.phoenixObjectName, PTableType.TABLE, 4, columnArray, false);
            this.assertDBODefinition(conn, this.fullIndexNameOne, PTableType.INDEX, 4, columnIndexArray, false);
            this.assertDBODefinition(conn, this.fullIndexNameTwo, PTableType.INDEX, 4, columnIndexArray, false);
            this.assertNumberOfHBaseCells(this.fullIndexNameOne, 2);
            this.assertNumberOfHBaseCells(this.fullIndexNameOne, 2);
        }
    }

    @Test
    public void testAlterDBOAddCascadeIndexAll_noIndexes() throws Exception {
        String schemaName = "S_" + AlterAddCascadeIndexIT.generateUniqueName();
        String tableName = "T_" + AlterAddCascadeIndexIT.generateUniqueName();
        String viewName = "V_" + AlterAddCascadeIndexIT.generateUniqueName();
        String fullViewName = SchemaUtil.getQualifiedTableName((String)schemaName, (String)viewName);
        String fullTableName = SchemaUtil.getQualifiedTableName((String)schemaName, (String)tableName);
        conn.createStatement().execute("CREATE TABLE IF NOT EXISTS " + fullTableName + " (\n      state CHAR(2) NOT NULL,\n      city VARCHAR NOT NULL,\n      population BIGINT,\n      CONSTRAINT my_pk PRIMARY KEY (state, city)) " + this.tableDDLOptions);
        if (this.isViewScenario) {
            conn.createStatement().execute("CREATE VIEW IF NOT EXISTS " + fullViewName + " (city_area INTEGER, avg_fam_size INTEGER) AS SELECT * FROM " + fullTableName + " WHERE state = 'CA'");
        }
        String query = "ALTER " + (this.isViewScenario ? "VIEW " : "TABLE ") + (this.isViewScenario ? fullViewName : fullTableName) + " ADD new_column_3 VARCHAR(64) CASCADE INDEX ALL";
        conn.createStatement().execute(query);
        ColumnInfo[] columnArray = new ColumnInfo[]{new ColumnInfo("new_column_3", PVarchar.INSTANCE.getSqlType(), Integer.valueOf(64))};
        if (this.isViewScenario) {
            this.assertDBODefinition(conn, fullViewName, PTableType.VIEW, 6, columnArray, false);
        } else {
            this.assertDBODefinition(conn, fullTableName, PTableType.TABLE, 4, columnArray, false);
        }
    }

    @Test
    public void testAlterDBOAddCascadeIndex() throws Exception {
        ColumnInfo[] columnArray = new ColumnInfo[]{new ColumnInfo("new_column_1", PFloat.INSTANCE.getSqlType())};
        ColumnInfo[] columnIndexArray = new ColumnInfo[]{new ColumnInfo("0:new_column_1", PFloat.INSTANCE.getSqlType())};
        String query = "ALTER " + (this.isViewScenario ? "VIEW " : "TABLE ") + this.phoenixObjectName + " ADD new_column_1 FLOAT CASCADE INDEX " + this.indexNames.split(",")[0];
        conn.createStatement().execute(query);
        if (this.isViewScenario) {
            this.assertDBODefinition(conn, this.phoenixObjectName, PTableType.VIEW, 6, columnArray, false);
            this.assertDBODefinition(conn, this.fullIndexNameOne, PTableType.INDEX, 5, columnIndexArray, false);
            this.assertDBODefinition(conn, this.fullIndexNameTwo, PTableType.INDEX, 4, columnIndexArray, true);
        } else {
            this.assertDBODefinition(conn, this.phoenixObjectName, PTableType.TABLE, 4, columnArray, false);
            this.assertDBODefinition(conn, this.fullIndexNameOne, PTableType.INDEX, 4, columnIndexArray, false);
            this.assertDBODefinition(conn, this.fullIndexNameTwo, PTableType.INDEX, 3, columnIndexArray, true);
        }
    }

    @Test
    public void testAlterDBOAddCascadeTwoColsOneIndex() throws Exception {
        ColumnInfo[] columnArray = new ColumnInfo[]{new ColumnInfo("new_column_1", PFloat.INSTANCE.getSqlType()), new ColumnInfo("new_column_2", PDouble.INSTANCE.getSqlType())};
        ColumnInfo[] columnIndexArray = new ColumnInfo[]{new ColumnInfo("0:new_column_1", PFloat.INSTANCE.getSqlType()), new ColumnInfo("0:new_column_2", PDouble.INSTANCE.getSqlType())};
        String query = "ALTER " + (this.isViewScenario ? "VIEW " : "TABLE ") + this.phoenixObjectName + " ADD new_column_1 FLOAT, new_column_2 DOUBLE CASCADE INDEX " + this.indexNames.split(",")[0];
        conn.createStatement().execute(query);
        if (this.isViewScenario) {
            this.assertDBODefinition(conn, this.phoenixObjectName, PTableType.VIEW, 7, columnArray, false);
            this.assertDBODefinition(conn, this.fullIndexNameOne, PTableType.INDEX, 6, columnIndexArray, false);
            this.assertDBODefinition(conn, this.fullIndexNameTwo, PTableType.INDEX, 4, columnIndexArray, true);
        } else {
            this.assertDBODefinition(conn, this.phoenixObjectName, PTableType.TABLE, 5, columnArray, false);
            this.assertDBODefinition(conn, this.fullIndexNameOne, PTableType.INDEX, 5, columnIndexArray, false);
            this.assertDBODefinition(conn, this.fullIndexNameTwo, PTableType.INDEX, 3, columnIndexArray, true);
        }
    }

    @Test
    public void testAlterDBOAddCascadeIndexes() throws Exception {
        ColumnInfo[] columnArray = new ColumnInfo[]{new ColumnInfo("new_column_1", PDouble.INSTANCE.getSqlType())};
        ColumnInfo[] columnIndexArray = new ColumnInfo[]{new ColumnInfo("0:new_column_1", PDouble.INSTANCE.getSqlType())};
        String query = "ALTER " + (this.isViewScenario ? "VIEW " : "TABLE ") + this.phoenixObjectName + " ADD new_column_1 DOUBLE CASCADE INDEX " + this.indexNames;
        conn.createStatement().execute(query);
        if (this.isViewScenario) {
            this.assertDBODefinition(conn, this.phoenixObjectName, PTableType.VIEW, 6, columnArray, false);
            this.assertDBODefinition(conn, this.fullIndexNameOne, PTableType.INDEX, 5, columnIndexArray, false);
            this.assertDBODefinition(conn, this.fullIndexNameTwo, PTableType.INDEX, 5, columnIndexArray, false);
        } else {
            this.assertDBODefinition(conn, this.phoenixObjectName, PTableType.TABLE, 4, columnArray, false);
            this.assertDBODefinition(conn, this.fullIndexNameOne, PTableType.INDEX, 4, columnIndexArray, false);
            this.assertDBODefinition(conn, this.fullIndexNameTwo, PTableType.INDEX, 4, columnIndexArray, false);
        }
    }

    @Test
    public void testAlterDBOAddCascadeTwoColsTwoIndexes() throws Exception {
        ColumnInfo[] columnArray = new ColumnInfo[]{new ColumnInfo("new_column_1", PFloat.INSTANCE.getSqlType()), new ColumnInfo("new_column_2", PDouble.INSTANCE.getSqlType())};
        ColumnInfo[] columIndexArray = new ColumnInfo[]{new ColumnInfo("0:new_column_1", PFloat.INSTANCE.getSqlType()), new ColumnInfo("0:new_column_2", PDouble.INSTANCE.getSqlType())};
        String query = "ALTER " + (this.isViewScenario ? "VIEW " : "TABLE ") + this.phoenixObjectName + " ADD new_column_1 FLOAT, new_column_2 DOUBLE CASCADE INDEX " + this.indexNames;
        conn.createStatement().execute(query);
        if (this.isViewScenario) {
            this.assertDBODefinition(conn, this.phoenixObjectName, PTableType.VIEW, 7, columnArray, false);
            this.assertDBODefinition(conn, this.fullIndexNameOne, PTableType.INDEX, 6, columIndexArray, false);
            this.assertDBODefinition(conn, this.fullIndexNameTwo, PTableType.INDEX, 6, columIndexArray, false);
        } else {
            this.assertDBODefinition(conn, this.phoenixObjectName, PTableType.TABLE, 5, columnArray, false);
            this.assertDBODefinition(conn, this.fullIndexNameOne, PTableType.INDEX, 5, columIndexArray, false);
            this.assertDBODefinition(conn, this.fullIndexNameTwo, PTableType.INDEX, 5, columIndexArray, false);
        }
    }

    @Test
    public void testAlterDBOException() throws SQLException {
        String query = "ALTER " + (this.isViewScenario ? "VIEW " : "TABLE ") + this.phoenixObjectName + " ADD new_column VARCHAR ALL";
        try {
            conn.createStatement().execute(query);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains(SYNTAX_ERROR));
        }
        query = "ALTER " + (this.isViewScenario ? "VIEW " : "TABLE ") + this.phoenixObjectName + " ADD new_column VARCHAR CASCADE " + this.indexNames.split(",")[0];
        try {
            conn.createStatement().execute(query);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains(SYNTAX_ERROR));
        }
        query = "ALTER " + (this.isViewScenario ? "VIEW " : "TABLE ") + this.phoenixObjectName + " ADD new_column VARCHAR INDEX " + this.indexNames.split(",")[0];
        try {
            conn.createStatement().execute(query);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains(SYNTAX_ERROR));
        }
        query = "ALTER " + (this.isViewScenario ? "VIEW " : "TABLE ") + this.phoenixObjectName + " ADD new_column_1 DOUBLE CASCADE INDEX INCORRECT_NAME";
        try {
            conn.createStatement().execute(query);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains(SQLExceptionCode.INCORRECT_INDEX_NAME.getMessage()));
        }
        String localIndex = AlterAddCascadeIndexIT.generateUniqueName();
        String createLocalIndex = "CREATE LOCAL INDEX " + localIndex + " ON " + this.phoenixObjectName + "(avg_fam_size) INCLUDE (population)";
        if (!this.isViewScenario) {
            createLocalIndex = "CREATE LOCAL INDEX " + localIndex + " ON " + this.phoenixObjectName + "(state, population)";
        }
        conn.createStatement().execute(createLocalIndex);
        query = "ALTER " + (this.isViewScenario ? "VIEW " : "TABLE ") + this.phoenixObjectName + " ADD new_column_1 DOUBLE CASCADE INDEX " + localIndex;
        try {
            conn.createStatement().execute(query);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains(SQLExceptionCode.NOT_SUPPORTED_CASCADE_FEATURE_LOCAL_INDEX.getMessage()));
        }
        query = "ALTER " + (this.isViewScenario ? "VIEW " : "TABLE ") + this.phoenixObjectName + " ADD new_column_2 DOUBLE CASCADE INDEX " + localIndex + "," + this.indexNames;
        try {
            conn.createStatement().execute(query);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains(SQLExceptionCode.NOT_SUPPORTED_CASCADE_FEATURE_LOCAL_INDEX.getMessage()));
        }
    }

    @Test
    public void testAlterDBOIncorrectIndexNameCombination() throws Exception {
        String query = "ALTER " + (this.isViewScenario ? "VIEW " : "TABLE ") + this.phoenixObjectName + " ADD new_column_1 DOUBLE CASCADE INDEX INCORRECT_NAME, " + this.indexNames;
        try {
            conn.createStatement().execute(query);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains(SQLExceptionCode.INCORRECT_INDEX_NAME.getMessage()));
        }
        ColumnInfo[] columnArray = new ColumnInfo[]{new ColumnInfo("new_column_1", PFloat.INSTANCE.getSqlType())};
        ColumnInfo[] columnIndexArray = new ColumnInfo[]{new ColumnInfo("0:new_column_1", PDecimal.INSTANCE.getSqlType())};
        if (this.isViewScenario) {
            this.assertDBODefinition(conn, this.phoenixObjectName, PTableType.VIEW, 5, columnArray, true);
            this.assertDBODefinition(conn, this.fullIndexNameOne, PTableType.INDEX, 4, columnIndexArray, true);
            this.assertDBODefinition(conn, this.fullIndexNameTwo, PTableType.INDEX, 4, columnIndexArray, true);
        } else {
            this.assertDBODefinition(conn, this.phoenixObjectName, PTableType.TABLE, 3, columnArray, true);
            this.assertDBODefinition(conn, this.fullIndexNameOne, PTableType.INDEX, 3, columnIndexArray, true);
            this.assertDBODefinition(conn, this.fullIndexNameTwo, PTableType.INDEX, 3, columnIndexArray, true);
        }
    }

    @Test
    public void testAlterTableCascadeIndexAllBigInt() throws Exception {
        String schemaName = "S_" + AlterAddCascadeIndexIT.generateUniqueName();
        String tableName = "T_" + AlterAddCascadeIndexIT.generateUniqueName();
        String indexNameThree = "I_" + AlterAddCascadeIndexIT.generateUniqueName();
        String fullTableName = SchemaUtil.getQualifiedTableName((String)schemaName, (String)tableName);
        String fullIndexNameThree = SchemaUtil.getQualifiedTableName((String)schemaName, (String)indexNameThree);
        String createTableQuery = "CREATE TABLE " + fullTableName + " (mykey INTEGER NOT NULL PRIMARY KEY, col1 BIGINT)";
        String createIndexQuery = "CREATE INDEX " + indexNameThree + " ON " + fullTableName + " (col1)";
        conn.createStatement().execute(createTableQuery);
        conn.createStatement().execute(createIndexQuery);
        PreparedStatement ps = conn.prepareStatement("UPSERT INTO " + fullTableName + "(mykey, col1) VALUES(1, 2)");
        ps.executeUpdate();
        conn.commit();
        String alterTableQuery = "ALTER TABLE " + fullTableName + " ADD IF NOT EXISTS col3 BIGINT CASCADE INDEX ALL";
        conn.createStatement().execute(alterTableQuery);
        PreparedStatement pss = conn.prepareStatement("UPSERT INTO " + fullTableName + "(mykey, col1, col3) VALUES(6, 7, 8)");
        pss.executeUpdate();
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + fullTableName);
        rs.next();
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertEquals((long)2L, (long)rs.getLong(2));
        rs.next();
        Assert.assertEquals((long)6L, (long)rs.getInt(1));
        Assert.assertEquals((long)7L, (long)rs.getLong(2));
        Assert.assertEquals((long)8L, (long)rs.getLong(3));
        rs = conn.createStatement().executeQuery("SELECT * FROM " + fullIndexNameThree);
        rs.next();
        Assert.assertEquals((long)2L, (long)rs.getLong(1));
        Assert.assertEquals((long)1L, (long)rs.getInt(2));
        rs.next();
        Assert.assertEquals((long)7L, (long)rs.getLong(1));
        Assert.assertEquals((long)6L, (long)rs.getInt(2));
        Assert.assertEquals((long)8L, (long)rs.getLong(3));
        ColumnInfo[] columnArray = new ColumnInfo[]{new ColumnInfo("col3", PLong.INSTANCE.getSqlType())};
        ColumnInfo[] columnIndexArray = new ColumnInfo[]{new ColumnInfo("0:col3", PLong.INSTANCE.getSqlType())};
        this.assertDBODefinition(conn, fullTableName, PTableType.TABLE, 3, columnArray, false);
        this.assertDBODefinition(conn, fullIndexNameThree, PTableType.INDEX, 3, columnIndexArray, false);
    }

    private void assertDBODefinition(Connection conn, String phoenixObjectName, PTableType pTableType, int baseColumnCount, ColumnInfo[] columnInfo, boolean fail) throws Exception {
        String schemaName = SchemaUtil.getSchemaNameFromFullName((String)phoenixObjectName);
        String tableName = SchemaUtil.getTableNameFromFullName((String)phoenixObjectName);
        PreparedStatement p = conn.prepareStatement("SELECT * FROM SYSTEM.CATALOG WHERE TABLE_SCHEM=? AND TABLE_NAME=? AND TABLE_TYPE=?");
        p.setString(1, schemaName.toUpperCase());
        p.setString(2, tableName.toUpperCase());
        p.setString(3, pTableType.getSerializedValue());
        ResultSet rs = p.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((String)"Mismatch in ColumnCount", (long)baseColumnCount, (long)rs.getInt("COLUMN_COUNT"));
        p = conn.prepareStatement("SELECT * FROM SYSTEM.CATALOG WHERE TABLE_SCHEM=? AND TABLE_NAME=? AND COLUMN_NAME=? AND DATA_TYPE=?");
        p.setString(1, schemaName.toUpperCase());
        p.setString(2, tableName.toUpperCase());
        int iPos = baseColumnCount - columnInfo.length + 1;
        for (ColumnInfo column : columnInfo) {
            p.setString(3, column.getDisplayName().toUpperCase());
            p.setInt(4, column.getSqlType());
            rs = p.executeQuery();
            if (!fail) {
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((long)iPos, (long)rs.getInt("ORDINAL_POSITION"));
                ++iPos;
                continue;
            }
            Assert.assertFalse((boolean)rs.next());
        }
        rs.close();
        p.close();
    }

    public void assertNumberOfHBaseCells(String tableName, int expected) {
        try {
            ConnectionQueryServices cqs = conn.unwrap(PhoenixConnection.class).getQueryServices();
            Table table = cqs.getTable(Bytes.toBytes((String)tableName));
            Scan scan = new Scan();
            scan.setRaw(true);
            scan.readAllVersions();
            int count = 0;
            ResultScanner scanner = table.getScanner(scan);
            Result result = scanner.next();
            while (result != null) {
                count += result.listCells().size();
                result = scanner.next();
            }
            Assert.assertEquals((long)expected, (long)count);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

