/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.end2end.ParallelStatsEnabledIT;
import org.apache.phoenix.end2end.ParallelStatsEnabledTest;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.schema.stats.StatisticsCollectionRunTracker;
import org.apache.phoenix.util.SchemaUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsEnabledTest.class})
public class StatisticsCollectionRunTrackerIT
extends ParallelStatsEnabledIT {
    private static final StatisticsCollectionRunTracker tracker = StatisticsCollectionRunTracker.getInstance((Configuration)new Configuration());
    private String fullTableName;

    @Before
    public void generateTableNames() {
        String schemaName = "S";
        String tableName = "T_" + StatisticsCollectionRunTrackerIT.generateUniqueName();
        this.fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
    }

    @Test
    public void testStateBeforeAndAfterUpdateStatsCommand() throws Exception {
        String tableName = this.fullTableName;
        RegionInfo regionInfo = this.createTableAndGetRegion(tableName);
        StatisticsCollectionRunTracker tracker = StatisticsCollectionRunTracker.getInstance((Configuration)new Configuration());
        Assert.assertTrue((boolean)tracker.addUpdateStatsCommandRegion(regionInfo, new HashSet(Arrays.asList(new byte[][]{Bytes.toBytes((String)"0")}))));
        Assert.assertTrue((boolean)tracker.addUpdateStatsCommandRegion(regionInfo, new HashSet(Arrays.asList(new byte[][]{Bytes.toBytes((String)"L#0")}))));
        Assert.assertTrue((boolean)tracker.removeUpdateStatsCommandRegion(regionInfo, new HashSet(Arrays.asList(new byte[][]{Bytes.toBytes((String)"0")}))));
        Assert.assertTrue((boolean)tracker.removeUpdateStatsCommandRegion(regionInfo, new HashSet(Arrays.asList(new byte[][]{Bytes.toBytes((String)"L#0")}))));
        this.runUpdateStats(tableName);
        Assert.assertFalse((boolean)tracker.removeUpdateStatsCommandRegion(regionInfo, new HashSet(Arrays.asList(new byte[][]{Bytes.toBytes((String)"0")}))));
        Assert.assertFalse((boolean)tracker.removeUpdateStatsCommandRegion(regionInfo, new HashSet(Arrays.asList(new byte[][]{Bytes.toBytes((String)"L#0")}))));
    }

    @Test
    public void testStateBeforeAndAfterMajorCompaction() throws Exception {
        String tableName = this.fullTableName;
        RegionInfo regionInfo = this.createTableAndGetRegion(tableName);
        StatisticsCollectionRunTracker tracker = StatisticsCollectionRunTracker.getInstance((Configuration)new Configuration());
        String keyPrefix = "aaaaaaaaaaaaaaaaaaaa";
        String upsert = "UPSERT INTO " + tableName + " VALUES (?, ?)";
        try (Connection conn = DriverManager.getConnection(StatisticsCollectionRunTrackerIT.getUrl());){
            PreparedStatement stmt = conn.prepareStatement(upsert);
            for (int i = 0; i < 1000; ++i) {
                stmt.setString(1, keyPrefix + i);
                stmt.setString(2, "KV" + i);
                stmt.executeUpdate();
            }
            conn.commit();
        }
        Assert.assertTrue((boolean)tracker.addCompactingRegion(regionInfo));
        Assert.assertTrue((boolean)tracker.removeCompactingRegion(regionInfo));
        this.runMajorCompaction(tableName);
        Assert.assertFalse((boolean)tracker.removeCompactingRegion(regionInfo));
    }

    @Test
    public void testMajorCompactionPreventsUpdateStatsFromRunning() throws Exception {
        String tableName = this.fullTableName;
        RegionInfo regionInfo = this.createTableAndGetRegion(tableName);
        this.markRegionAsCompacting(regionInfo);
        Assert.assertEquals((String)"Row count didn't match", (long)-400L, (long)this.runUpdateStats(tableName));
        StatisticsCollectionRunTracker tracker = StatisticsCollectionRunTracker.getInstance((Configuration)new Configuration());
        HashSet familyMap = new HashSet(Arrays.asList(new byte[][]{Bytes.toBytes((String)"0")}));
        Assert.assertFalse((boolean)tracker.removeUpdateStatsCommandRegion(regionInfo, familyMap));
    }

    @Test
    public void testUpdateStatsPreventsAnotherUpdateStatsFromRunning() throws Exception {
        String tableName = this.fullTableName;
        RegionInfo regionInfo = this.createTableAndGetRegion(tableName);
        HashSet<byte[]> familyMap = new HashSet<byte[]>(Arrays.asList(new byte[][]{Bytes.toBytes((String)"0")}));
        this.markRunningUpdateStats(regionInfo, familyMap);
        Assert.assertTrue((String)"Local index stats are not updated!", (-100L < this.runUpdateStats(tableName) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)tracker.removeUpdateStatsCommandRegion(regionInfo, familyMap));
    }

    private void markRegionAsCompacting(RegionInfo regionInfo) {
        StatisticsCollectionRunTracker tracker = StatisticsCollectionRunTracker.getInstance((Configuration)new Configuration());
        tracker.addCompactingRegion(regionInfo);
    }

    private void markRunningUpdateStats(RegionInfo regionInfo, HashSet<byte[]> familyMap) {
        StatisticsCollectionRunTracker tracker = StatisticsCollectionRunTracker.getInstance((Configuration)new Configuration());
        tracker.addUpdateStatsCommandRegion(regionInfo, familyMap);
    }

    /*
     * Exception decompiling
     */
    private RegionInfo createTableAndGetRegion(String tableName) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private long runUpdateStats(String tableName) throws Exception {
        try (Connection conn = DriverManager.getConnection(StatisticsCollectionRunTrackerIT.getUrl());){
            long l = conn.createStatement().executeUpdate("UPDATE STATISTICS " + tableName);
            return l;
        }
    }

    private void runMajorCompaction(String tableName) throws Exception {
        try (PhoenixConnection conn = DriverManager.getConnection(StatisticsCollectionRunTrackerIT.getUrl()).unwrap(PhoenixConnection.class);
             Admin admin = conn.getQueryServices().getAdmin();){
            TableName t = TableName.valueOf((String)tableName);
            admin.flush(t);
            admin.majorCompact(t);
            Thread.sleep(10000L);
        }
    }
}

