/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.compile.ExpressionCompiler;
import org.apache.phoenix.compile.FromCompiler;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.compile.WhereOptimizer;
import org.apache.phoenix.expression.AndExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.SubstrFunction;
import org.apache.phoenix.filter.BooleanExpressionFilter;
import org.apache.phoenix.filter.RowKeyComparisonFilter;
import org.apache.phoenix.filter.SingleCQKeyValueComparisonFilter;
import org.apache.phoenix.filter.SingleKeyValueComparisonFilter;
import org.apache.phoenix.filter.SkipScanFilter;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.parse.ColumnParseNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.ParseNodeVisitor;
import org.apache.phoenix.parse.SQLParser;
import org.apache.phoenix.parse.SelectStatement;
import org.apache.phoenix.query.BaseConnectionlessQueryTest;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.AmbiguousColumnException;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.ColumnRef;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnFamily;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.types.PChar;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PDouble;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PTimestamp;
import org.apache.phoenix.schema.types.PUnsignedLong;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.thirdparty.com.google.common.base.Optional;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Sets;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.DateUtil;
import org.apache.phoenix.util.EncodedColumnsUtil;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.StringUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;

public class WhereOptimizerTest
extends BaseConnectionlessQueryTest {
    private static final String TENANT_PREFIX = "Txt00tst1";

    private static StatementContext compileStatement(String query) throws SQLException {
        return WhereOptimizerTest.compileStatement(query, Collections.emptyList(), null);
    }

    private static StatementContext compileStatement(String query, Integer limit) throws SQLException {
        return WhereOptimizerTest.compileStatement(query, Collections.emptyList(), limit);
    }

    private static StatementContext compileStatement(String query, List<Object> binds) throws SQLException {
        return WhereOptimizerTest.compileStatement(query, binds, null);
    }

    private static StatementContext compileStatement(String query, List<Object> binds, Integer limit) throws SQLException {
        PhoenixConnection pconn = DriverManager.getConnection(WhereOptimizerTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES)).unwrap(PhoenixConnection.class);
        PhoenixPreparedStatement pstmt = new PhoenixPreparedStatement(pconn, query);
        WhereOptimizerTest.assertRoundtrip(query);
        TestUtil.bindParams(pstmt, binds);
        QueryPlan plan = pstmt.compileQuery();
        Assert.assertEquals((Object)limit, (Object)plan.getLimit());
        return plan.getContext();
    }

    @Test
    public void testTrailingRangesIterator() throws Exception {
        KeyRange[] all = new KeyRange[]{KeyRange.EVERYTHING_RANGE, KeyRange.EVERYTHING_RANGE, KeyRange.EVERYTHING_RANGE, KeyRange.EVERYTHING_RANGE, KeyRange.EVERYTHING_RANGE, KeyRange.EVERYTHING_RANGE};
        List<KeyRange[]> singleAll = Collections.singletonList(all);
        KeyRange[] r1 = new KeyRange[]{KeyRange.EVERYTHING_RANGE, KeyRange.EVERYTHING_RANGE, KeyRange.EVERYTHING_RANGE, KeyRange.getKeyRange((byte[])Bytes.toBytes((String)"A")), KeyRange.EVERYTHING_RANGE, KeyRange.EVERYTHING_RANGE};
        KeyRange[] r2 = new KeyRange[]{KeyRange.EVERYTHING_RANGE, KeyRange.EVERYTHING_RANGE, KeyRange.EVERYTHING_RANGE, KeyRange.getKeyRange((byte[])Bytes.toBytes((String)"B")), KeyRange.EVERYTHING_RANGE, KeyRange.EVERYTHING_RANGE};
        KeyRange[] r3 = new KeyRange[]{KeyRange.EVERYTHING_RANGE, KeyRange.EVERYTHING_RANGE, KeyRange.EVERYTHING_RANGE, KeyRange.getKeyRange((byte[])Bytes.toBytes((String)"C")), KeyRange.EVERYTHING_RANGE, KeyRange.EVERYTHING_RANGE};
        KeyRange[] r4 = new KeyRange[]{KeyRange.EVERYTHING_RANGE, KeyRange.EVERYTHING_RANGE, KeyRange.EVERYTHING_RANGE, KeyRange.getKeyRange((byte[])Bytes.toBytes((String)"D")), KeyRange.EVERYTHING_RANGE, KeyRange.EVERYTHING_RANGE};
        KeyRange[] r5 = new KeyRange[]{KeyRange.EVERYTHING_RANGE, KeyRange.EVERYTHING_RANGE, KeyRange.EVERYTHING_RANGE, KeyRange.getKeyRange((byte[])Bytes.toBytes((String)"A"), (boolean)true, (byte[])Bytes.toBytes((String)"D"), (boolean)true), KeyRange.EVERYTHING_RANGE, KeyRange.EVERYTHING_RANGE};
        int initPkPos = 1;
        int pkPos = 3;
        ArrayList slotsTrailingRangesList = Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new KeyRange[][]{r5})}), Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new KeyRange[][]{r1, r2}), Lists.newArrayList((Object[])new KeyRange[][]{r3, r4})}), Lists.newArrayList(), Lists.newArrayList((Object[])new List[]{singleAll})});
        ArrayList results = Lists.newArrayList();
        ArrayList expectedResults = Lists.newArrayList((Object[])new KeyRange[]{KeyRange.getKeyRange((byte[])Bytes.toBytes((String)"A")), KeyRange.getKeyRange((byte[])Bytes.toBytes((String)"B")), KeyRange.getKeyRange((byte[])Bytes.toBytes((String)"C")), KeyRange.getKeyRange((byte[])Bytes.toBytes((String)"D"))});
        WhereOptimizer.KeyExpressionVisitor.TrailingRangeIterator iterator = new WhereOptimizer.KeyExpressionVisitor.TrailingRangeIterator(initPkPos, pkPos, (List)slotsTrailingRangesList);
        while (iterator.hasNext()) {
            do {
                KeyRange range = iterator.getRange();
                results.add(range);
            } while (iterator.nextTrailingRange() || iterator.nextRange());
        }
        Assert.assertEquals((Object)expectedResults, (Object)results);
    }

    @Test
    public void testSlotsIterator() throws Exception {
        ArrayList keySlotsList = Lists.newArrayList();
        keySlotsList.add(new WhereOptimizer.KeyExpressionVisitor.SingleKeySlot(null, 0, (List)Lists.newArrayList((Object[])new KeyRange[]{KeyRange.getKeyRange((byte[])Bytes.toBytes((String)"A")), KeyRange.getKeyRange((byte[])Bytes.toBytes((String)"B"))})));
        keySlotsList.add(new WhereOptimizer.KeyExpressionVisitor.SingleKeySlot(null, 1, (List)Lists.newArrayList((Object[])new KeyRange[]{KeyRange.getKeyRange((byte[])Bytes.toBytes((String)"C"))})));
        keySlotsList.add(new WhereOptimizer.KeyExpressionVisitor.SingleKeySlot(null, 0, (List)Lists.newArrayList((Object[])new KeyRange[]{KeyRange.getKeyRange((byte[])Bytes.toBytes((String)"D")), KeyRange.getKeyRange((byte[])Bytes.toBytes((String)"E"))})));
        keySlotsList.add(new WhereOptimizer.KeyExpressionVisitor.SingleKeySlot(null, 1, (List)Lists.newArrayList()));
        WhereOptimizer.KeyExpressionVisitor.SlotsIterator iterator = new WhereOptimizer.KeyExpressionVisitor.SlotsIterator((List)keySlotsList, 0);
        String[][] expectedResults = new String[][]{{"A", null, "D", null}, {"B", null, "D", null}, {"A", null, "E", null}, {"B", null, "E", null}};
        int j = 0;
        while (iterator.next()) {
            int i;
            for (i = 0; i < keySlotsList.size(); ++i) {
                KeyRange range = iterator.getRange(i);
                String result = range == null ? null : Bytes.toString((byte[])range.getLowerRange());
                String expectedResult = expectedResults[j][i];
                Assert.assertEquals((Object)expectedResult, (Object)result);
            }
            Assert.assertEquals((long)i, (long)expectedResults[j].length);
            ++j;
        }
        Assert.assertEquals((long)j, (long)expectedResults.length);
    }

    @Test
    public void testMathFunc() throws SQLException {
        Connection conn = DriverManager.getConnection(WhereOptimizerTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
        conn.createStatement().execute("create table test (id integer primary key)");
        Scan scan = WhereOptimizerTest.compileStatement("select ID, exp(ID) from test where exp(ID) < 10").getScan();
        Assert.assertNotNull((Object)scan.getFilter());
        Assert.assertTrue((scan.getStartRow().length == 0 ? 1 : 0) != 0);
        Assert.assertTrue((scan.getStopRow().length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSingleKeyExpression() throws SQLException {
        String tenantId = "000000000000001";
        String query = "select * from atable where organization_id='" + tenantId + "'";
        Scan scan = WhereOptimizerTest.compileStatement(query).getScan();
        Assert.assertNull((Object)scan.getFilter());
        Assert.assertArrayEquals((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId), (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])ByteUtil.nextKey((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId)), (byte[])scan.getStopRow());
    }

    @Test
    public void testGetByteBitExpression() throws SQLException {
        WhereOptimizerTest.ensureTableCreated(WhereOptimizerTest.getUrl(), "BinaryTable", "BinaryTable");
        int result = 1;
        String query = "select * from BinaryTable where GET_BYTE(a_binary, 0)=" + result;
        Scan scan = WhereOptimizerTest.compileStatement(query).getScan();
        byte[] tmpBytes = PInteger.INSTANCE.toBytes((Object)result);
        byte[] tmpBytes2 = new byte[16];
        System.arraycopy(tmpBytes, 0, tmpBytes2, 0, tmpBytes.length);
        tmpBytes = ByteUtil.nextKey((byte[])tmpBytes);
        byte[] tmpBytes3 = new byte[16];
        System.arraycopy(tmpBytes, 0, tmpBytes3, 0, tmpBytes.length);
        Assert.assertArrayEquals((byte[])tmpBytes2, (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])tmpBytes3, (byte[])scan.getStopRow());
        query = "select * from BinaryTable where GET_BIT(a_binary, 0)=" + result;
        scan = WhereOptimizerTest.compileStatement(query).getScan();
        tmpBytes = PInteger.INSTANCE.toBytes((Object)result);
        tmpBytes2 = new byte[16];
        System.arraycopy(tmpBytes, 0, tmpBytes2, 0, tmpBytes.length);
        tmpBytes = ByteUtil.nextKey((byte[])tmpBytes);
        tmpBytes3 = new byte[16];
        System.arraycopy(tmpBytes, 0, tmpBytes3, 0, tmpBytes.length);
        Assert.assertArrayEquals((byte[])tmpBytes2, (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])tmpBytes3, (byte[])scan.getStopRow());
    }

    @Test
    public void testDescDecimalRange() throws SQLException {
        String ddl = "create table t (k1 bigint not null, k2 decimal, constraint pk primary key (k1,k2 desc))";
        Connection conn = DriverManager.getConnection(WhereOptimizerTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
        conn.createStatement().execute(ddl);
        String query = "select * from t where k1 in (1,2) and k2>1.0";
        Scan scan = WhereOptimizerTest.compileStatement(query).getScan();
        byte[] startRow = ByteUtil.concat((byte[])PLong.INSTANCE.toBytes((Object)1), (byte[][])new byte[][]{ByteUtil.nextKey((byte[])QueryConstants.SEPARATOR_BYTE_ARRAY), QueryConstants.DESC_SEPARATOR_BYTE_ARRAY});
        byte[] upperValue = PDecimal.INSTANCE.toBytes((Object)BigDecimal.valueOf(1.0));
        byte[] stopRow = ByteUtil.concat((byte[])PLong.INSTANCE.toBytes((Object)2), (byte[][])new byte[][]{SortOrder.invert((byte[])upperValue, (int)0, (int)upperValue.length), QueryConstants.DESC_SEPARATOR_BYTE_ARRAY});
        Assert.assertTrue((boolean)(scan.getFilter() instanceof SkipScanFilter));
        Assert.assertArrayEquals((byte[])startRow, (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])stopRow, (byte[])scan.getStopRow());
    }

    @Test
    public void testSingleCharPaddedKeyExpression() throws SQLException {
        String tenantId = "1";
        String query = "select * from atable where organization_id='" + tenantId + "'";
        Scan scan = WhereOptimizerTest.compileStatement(query).getScan();
        Assert.assertNull((Object)scan.getFilter());
        byte[] key = StringUtil.padChar((byte[])PChar.INSTANCE.toBytes((Object)tenantId), (Integer)15);
        Assert.assertArrayEquals((byte[])key, (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])ByteUtil.nextKey((byte[])key), (byte[])scan.getStopRow());
    }

    @Test
    public void testSingleBinaryPaddedKeyExpression() throws SQLException {
        Connection conn = DriverManager.getConnection(WhereOptimizerTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
        conn.createStatement().execute("create table bintable (k BINARY(15) PRIMARY KEY)");
        String tenantId = "1";
        String query = "select * from bintable where k='" + tenantId + "'";
        Scan scan = WhereOptimizerTest.compileStatement(query).getScan();
        Assert.assertNull((Object)scan.getFilter());
        byte[] key = ByteUtil.fillKey((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId), (int)15);
        Assert.assertArrayEquals((byte[])key, (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])ByteUtil.nextKey((byte[])key), (byte[])scan.getStopRow());
    }

    @Test
    public void testReverseSingleKeyExpression() throws SQLException {
        String tenantId = "000000000000001";
        String query = "select * from atable where '" + tenantId + "' = organization_id";
        Scan scan = WhereOptimizerTest.compileStatement(query).getScan();
        Assert.assertNull((Object)scan.getFilter());
        Assert.assertArrayEquals((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId), (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])ByteUtil.nextKey((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId)), (byte[])scan.getStopRow());
    }

    @Test
    public void testStartKeyStopKey() throws SQLException {
        Connection conn = DriverManager.getConnection(WhereOptimizerTest.getUrl());
        conn.createStatement().execute("CREATE TABLE start_stop_test (pk char(2) not null primary key)");
        conn.close();
        String query = "select * from start_stop_test where pk >= 'EA' and pk < 'EZ'";
        Scan scan = WhereOptimizerTest.compileStatement(query).getScan();
        Assert.assertNull((Object)scan.getFilter());
        Assert.assertArrayEquals((byte[])PVarchar.INSTANCE.toBytes((Object)"EA"), (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])PVarchar.INSTANCE.toBytes((Object)"EZ"), (byte[])scan.getStopRow());
    }

    @Test
    public void testConcatSingleKeyExpression() throws SQLException {
        String tenantId = "000000000000001";
        String query = "select * from atable where organization_id || 'foo' ='" + tenantId + "'||'foo'";
        Scan scan = WhereOptimizerTest.compileStatement(query).getScan();
        Assert.assertNotNull((Object)scan.getFilter());
        Assert.assertEquals((long)0L, (long)scan.getStartRow().length);
        Assert.assertEquals((long)0L, (long)scan.getStopRow().length);
    }

    @Test
    public void testLiteralConcatExpression() throws SQLException {
        String query = "select * from atable where null||'foo'||'bar' = 'foobar'";
        Scan scan = new Scan();
        List<Object> binds = Collections.emptyList();
        WhereOptimizerTest.compileStatement(query, binds);
        Assert.assertNull((Object)scan.getFilter());
        Assert.assertEquals((long)0L, (long)scan.getStartRow().length);
        Assert.assertEquals((long)0L, (long)scan.getStopRow().length);
    }

    @Test
    public void testSingleKeyNotExpression() throws SQLException {
        String tenantId = "000000000000001";
        String query = "select * from atable where not organization_id='" + tenantId + "'";
        Scan scan = WhereOptimizerTest.compileStatement(query).getScan();
        Assert.assertNotNull((Object)scan.getFilter());
        Assert.assertEquals((long)0L, (long)scan.getStartRow().length);
        Assert.assertEquals((long)0L, (long)scan.getStopRow().length);
    }

    @Test
    public void testMultiKeyExpression() throws SQLException {
        String tenantId = "000000000000001";
        String keyPrefix = "002";
        String query = "select * from atable where organization_id='" + tenantId + "' and substr(entity_id,1,3)='" + keyPrefix + "'";
        Scan scan = WhereOptimizerTest.compileStatement(query).getScan();
        Assert.assertNull((Object)scan.getFilter());
        byte[] startRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId), (byte[][])new byte[][]{StringUtil.padChar((byte[])PVarchar.INSTANCE.toBytes((Object)keyPrefix), (Integer)15)});
        Assert.assertArrayEquals((byte[])startRow, (byte[])scan.getStartRow());
        byte[] stopRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId), (byte[][])new byte[][]{StringUtil.padChar((byte[])ByteUtil.nextKey((byte[])PVarchar.INSTANCE.toBytes((Object)keyPrefix)), (Integer)15)});
        Assert.assertArrayEquals((byte[])stopRow, (byte[])scan.getStopRow());
    }

    @Test
    public void testMultiKeyBindExpression() throws SQLException {
        String tenantId = "000000000000001";
        String keyPrefix = "002";
        String query = "select * from atable where organization_id=? and substr(entity_id,1,3)=?";
        List<Object> binds = Arrays.asList(tenantId, keyPrefix);
        Scan scan = WhereOptimizerTest.compileStatement(query, binds).getScan();
        Assert.assertNull((Object)scan.getFilter());
        byte[] startRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId), (byte[][])new byte[][]{StringUtil.padChar((byte[])PVarchar.INSTANCE.toBytes((Object)keyPrefix), (Integer)15)});
        Assert.assertArrayEquals((byte[])startRow, (byte[])scan.getStartRow());
        byte[] stopRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId), (byte[][])new byte[][]{StringUtil.padChar((byte[])ByteUtil.nextKey((byte[])PVarchar.INSTANCE.toBytes((Object)keyPrefix)), (Integer)15)});
        Assert.assertArrayEquals((byte[])stopRow, (byte[])scan.getStopRow());
    }

    @Test
    public void testEqualRound() throws Exception {
        String inst = "a";
        String host = "b";
        Date roundDate = DateUtil.parseDate((String)"2012-01-01 00:00:00");
        Date startDate = DateUtil.parseDate((String)"2011-12-31 12:00:00");
        Date endDate = DateUtil.parseDate((String)"2012-01-01 12:00:00");
        String query = "select * from ptsdb where inst=? and host=? and round(date,'DAY')=?";
        List<Object> binds = Arrays.asList(inst, host, roundDate);
        Scan scan = WhereOptimizerTest.compileStatement(query, binds).getScan();
        Assert.assertNull((Object)scan.getFilter());
        byte[] startRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)inst), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, PVarchar.INSTANCE.toBytes((Object)host), QueryConstants.SEPARATOR_BYTE_ARRAY, PDate.INSTANCE.toBytes((Object)startDate)});
        Assert.assertArrayEquals((byte[])startRow, (byte[])scan.getStartRow());
        Assert.assertTrue((boolean)scan.includeStartRow());
        byte[] stopRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)inst), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, PVarchar.INSTANCE.toBytes((Object)host), QueryConstants.SEPARATOR_BYTE_ARRAY, PDate.INSTANCE.toBytes((Object)endDate)});
        Assert.assertArrayEquals((byte[])stopRow, (byte[])scan.getStopRow());
        Assert.assertFalse((boolean)scan.includeStopRow());
    }

    @Test
    public void testDegenerateRound() throws Exception {
        String inst = "a";
        String host = "b";
        Date startDate = DateUtil.parseDate((String)"2012-01-01 01:00:00");
        String query = "select * from ptsdb where inst=? and host=? and round(date,'DAY')=?";
        List<Object> binds = Arrays.asList(inst, host, startDate);
        Scan scan = WhereOptimizerTest.compileStatement(query, binds).getScan();
        TestUtil.assertDegenerate(scan);
    }

    @Test
    public void testBoundaryGreaterThanRound() throws Exception {
        String inst = "a";
        String host = "b";
        Date roundDate = DateUtil.parseDate((String)"2012-01-01 00:00:00");
        Date startDate = DateUtil.parseDate((String)"2012-01-01 12:00:00");
        String query = "select * from ptsdb where inst=? and host=? and round(date,'DAY')>?";
        List<Object> binds = Arrays.asList(inst, host, roundDate);
        Scan scan = WhereOptimizerTest.compileStatement(query, binds).getScan();
        Assert.assertNull((Object)scan.getFilter());
        byte[] startRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)inst), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, PVarchar.INSTANCE.toBytes((Object)host), QueryConstants.SEPARATOR_BYTE_ARRAY, PDate.INSTANCE.toBytes((Object)startDate)});
        Assert.assertArrayEquals((byte[])startRow, (byte[])scan.getStartRow());
        Assert.assertTrue((boolean)scan.includeStartRow());
        byte[] stopRow = ByteUtil.nextKey((byte[])ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)inst), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, PVarchar.INSTANCE.toBytes((Object)host), QueryConstants.SEPARATOR_BYTE_ARRAY}));
        Assert.assertArrayEquals((byte[])stopRow, (byte[])scan.getStopRow());
    }

    @Test
    public void testBoundaryGreaterThanOrEqualRound() throws Exception {
        String inst = "a";
        String host = "b";
        Date startDate = DateUtil.parseDate((String)"2012-01-01 00:00:00");
        Date startDateHalfRange = DateUtil.parseDate((String)"2011-12-31 12:00:00.000");
        String query = "select * from ptsdb where inst=? and host=? and round(date,'DAY')>=?";
        List<Object> binds = Arrays.asList(inst, host, startDate);
        Scan scan = WhereOptimizerTest.compileStatement(query, binds).getScan();
        Assert.assertNull((Object)scan.getFilter());
        byte[] startRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)inst), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, PVarchar.INSTANCE.toBytes((Object)host), QueryConstants.SEPARATOR_BYTE_ARRAY, PDate.INSTANCE.toBytes((Object)startDateHalfRange)});
        Assert.assertArrayEquals((byte[])startRow, (byte[])scan.getStartRow());
        byte[] stopRow = ByteUtil.nextKey((byte[])ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)inst), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, PVarchar.INSTANCE.toBytes((Object)host), QueryConstants.SEPARATOR_BYTE_ARRAY}));
        Assert.assertArrayEquals((byte[])stopRow, (byte[])scan.getStopRow());
    }

    @Test
    public void testGreaterThanRound() throws Exception {
        String inst = "a";
        String host = "b";
        Date roundDate = DateUtil.parseDate((String)"2012-01-01 01:00:00");
        Date startDate = DateUtil.parseDate((String)"2012-01-01 12:00:00");
        String query = "select * from ptsdb where inst=? and host=? and round(date,'DAY')>?";
        List<Object> binds = Arrays.asList(inst, host, roundDate);
        Scan scan = WhereOptimizerTest.compileStatement(query, binds).getScan();
        Assert.assertNull((Object)scan.getFilter());
        byte[] startRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)inst), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, PVarchar.INSTANCE.toBytes((Object)host), QueryConstants.SEPARATOR_BYTE_ARRAY, PDate.INSTANCE.toBytes((Object)startDate)});
        Assert.assertArrayEquals((byte[])startRow, (byte[])scan.getStartRow());
        Assert.assertTrue((boolean)scan.includeStartRow());
        byte[] stopRow = ByteUtil.nextKey((byte[])ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)inst), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, PVarchar.INSTANCE.toBytes((Object)host), QueryConstants.SEPARATOR_BYTE_ARRAY}));
        Assert.assertArrayEquals((byte[])stopRow, (byte[])scan.getStopRow());
    }

    @Test
    public void testLessThanRound() throws Exception {
        String inst = "a";
        String host = "b";
        Date roundDate = DateUtil.parseDate((String)"2012-01-01 01:00:00");
        Date endDate = DateUtil.parseDate((String)"2012-01-01 12:00:00");
        String query = "select * from ptsdb where inst=? and host=? and round(date,'DAY')<?";
        List<Object> binds = Arrays.asList(inst, host, roundDate);
        Scan scan = WhereOptimizerTest.compileStatement(query, binds).getScan();
        Assert.assertNull((Object)scan.getFilter());
        byte[] startRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)inst), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, PVarchar.INSTANCE.toBytes((Object)host)});
        Assert.assertArrayEquals((byte[])startRow, (byte[])scan.getStartRow());
        byte[] stopRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)inst), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, PVarchar.INSTANCE.toBytes((Object)host), QueryConstants.SEPARATOR_BYTE_ARRAY, PDate.INSTANCE.toBytes((Object)endDate)});
        Assert.assertArrayEquals((byte[])stopRow, (byte[])scan.getStopRow());
        Assert.assertTrue((boolean)scan.includeStartRow());
    }

    @Test
    public void testBoundaryLessThanRound() throws Exception {
        String inst = "a";
        String host = "b";
        Date roundDate = DateUtil.parseDate((String)"2012-01-01 00:00:00");
        Date endDate = DateUtil.parseDate((String)"2011-12-31 12:00:00");
        String query = "select * from ptsdb where inst=? and host=? and round(date,'DAY')<?";
        List<Object> binds = Arrays.asList(inst, host, roundDate);
        Scan scan = WhereOptimizerTest.compileStatement(query, binds).getScan();
        Assert.assertNull((Object)scan.getFilter());
        byte[] startRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)inst), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, PVarchar.INSTANCE.toBytes((Object)host)});
        Assert.assertArrayEquals((byte[])startRow, (byte[])scan.getStartRow());
        byte[] stopRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)inst), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, PVarchar.INSTANCE.toBytes((Object)host), QueryConstants.SEPARATOR_BYTE_ARRAY, PDate.INSTANCE.toBytes((Object)endDate)});
        Assert.assertArrayEquals((byte[])stopRow, (byte[])scan.getStopRow());
        Assert.assertFalse((boolean)scan.includeStopRow());
    }

    @Test
    public void testLessThanOrEqualRound() throws Exception {
        String inst = "a";
        String host = "b";
        Date roundDate = DateUtil.parseDate((String)"2012-01-01 01:00:00");
        Date endDate = DateUtil.parseDate((String)"2012-01-01 12:00:00");
        String query = "select * from ptsdb where inst=? and host=? and round(date,'DAY')<=?";
        List<Object> binds = Arrays.asList(inst, host, roundDate);
        Scan scan = WhereOptimizerTest.compileStatement(query, binds).getScan();
        Assert.assertNull((Object)scan.getFilter());
        byte[] startRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)inst), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, PVarchar.INSTANCE.toBytes((Object)host)});
        Assert.assertArrayEquals((byte[])startRow, (byte[])scan.getStartRow());
        byte[] stopRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)inst), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, PVarchar.INSTANCE.toBytes((Object)host), QueryConstants.SEPARATOR_BYTE_ARRAY, PDate.INSTANCE.toBytes((Object)endDate)});
        Assert.assertArrayEquals((byte[])stopRow, (byte[])scan.getStopRow());
        Assert.assertFalse((boolean)scan.includeStopRow());
    }

    @Test
    public void testLessThanOrEqualRound2() throws Exception {
        String inst = "a";
        String host = "b";
        Date roundDate = DateUtil.parseDate((String)"2011-12-31 23:00:00");
        Date endDate = DateUtil.parseDate((String)"2011-12-31 12:00:00");
        String query = "select * from ptsdb where inst=? and host=? and round(date,'DAY')<=?";
        List<Object> binds = Arrays.asList(inst, host, roundDate);
        Scan scan = WhereOptimizerTest.compileStatement(query, binds).getScan();
        Assert.assertNull((Object)scan.getFilter());
        byte[] startRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)inst), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, PVarchar.INSTANCE.toBytes((Object)host)});
        Assert.assertArrayEquals((byte[])startRow, (byte[])scan.getStartRow());
        byte[] stopRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)inst), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, PVarchar.INSTANCE.toBytes((Object)host), QueryConstants.SEPARATOR_BYTE_ARRAY, PDate.INSTANCE.toBytes((Object)endDate)});
        Assert.assertArrayEquals((byte[])stopRow, (byte[])scan.getStopRow());
        Assert.assertFalse((boolean)scan.includeStopRow());
    }

    @Test
    public void testBoundaryLessThanOrEqualRound() throws Exception {
        String inst = "a";
        String host = "b";
        Date roundDate = DateUtil.parseDate((String)"2012-01-01 00:00:00");
        Date endDate = DateUtil.parseDate((String)"2012-01-01 12:00:00");
        String query = "select * from ptsdb where inst=? and host=? and round(date,'DAY')<=?";
        List<Object> binds = Arrays.asList(inst, host, roundDate);
        Scan scan = WhereOptimizerTest.compileStatement(query, binds).getScan();
        Assert.assertNull((Object)scan.getFilter());
        byte[] startRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)inst), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, PVarchar.INSTANCE.toBytes((Object)host)});
        Assert.assertArrayEquals((byte[])startRow, (byte[])scan.getStartRow());
        Assert.assertTrue((boolean)scan.includeStartRow());
        byte[] stopRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)inst), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, PVarchar.INSTANCE.toBytes((Object)host), QueryConstants.SEPARATOR_BYTE_ARRAY, PDate.INSTANCE.toBytes((Object)endDate)});
        Assert.assertArrayEquals((byte[])stopRow, (byte[])scan.getStopRow());
        Assert.assertFalse((boolean)scan.includeStopRow());
    }

    @Test
    public void testLessThanOrEqualFloor() throws Exception {
        String inst = "a";
        String host = "b";
        Date floorDate = DateUtil.parseDate((String)"2012-01-01 01:00:00");
        Date endDate = DateUtil.parseDate((String)"2012-01-02 00:00:00");
        String query = "select * from ptsdb where inst=? and host=? and floor(date,'DAY')<=?";
        List<Object> binds = Arrays.asList(inst, host, floorDate);
        Scan scan = WhereOptimizerTest.compileStatement(query, binds).getScan();
        Assert.assertNull((Object)scan.getFilter());
        byte[] startRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)inst), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, PVarchar.INSTANCE.toBytes((Object)host)});
        Assert.assertArrayEquals((byte[])startRow, (byte[])scan.getStartRow());
        byte[] stopRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)inst), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, PVarchar.INSTANCE.toBytes((Object)host), QueryConstants.SEPARATOR_BYTE_ARRAY, PDate.INSTANCE.toBytes((Object)endDate)});
        Assert.assertArrayEquals((byte[])stopRow, (byte[])scan.getStopRow());
        Assert.assertFalse((boolean)scan.includeStopRow());
    }

    @Test
    public void testLessThanOrEqualFloorBoundary() throws Exception {
        String inst = "a";
        String host = "b";
        Date floorDate = DateUtil.parseDate((String)"2012-01-01 00:00:00");
        Date endDate = DateUtil.parseDate((String)"2012-01-02 00:00:00");
        String query = "select * from ptsdb where inst=? and host=? and floor(date,'DAY')<=?";
        List<Object> binds = Arrays.asList(inst, host, floorDate);
        Scan scan = WhereOptimizerTest.compileStatement(query, binds).getScan();
        Assert.assertNull((Object)scan.getFilter());
        byte[] startRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)inst), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, PVarchar.INSTANCE.toBytes((Object)host)});
        Assert.assertArrayEquals((byte[])startRow, (byte[])scan.getStartRow());
        byte[] stopRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)inst), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, PVarchar.INSTANCE.toBytes((Object)host), QueryConstants.SEPARATOR_BYTE_ARRAY, PDate.INSTANCE.toBytes((Object)endDate)});
        Assert.assertArrayEquals((byte[])stopRow, (byte[])scan.getStopRow());
        Assert.assertFalse((boolean)scan.includeStopRow());
    }

    @Test
    public void testGreaterThanOrEqualFloor() throws Exception {
        String inst = "a";
        String host = "b";
        Date floorDate = DateUtil.parseDate((String)"2012-01-01 01:00:00");
        Date startDate = DateUtil.parseDate((String)"2012-01-02 00:00:00");
        String query = "select * from ptsdb where inst=? and host=? and floor(date,'DAY')>=?";
        List<Object> binds = Arrays.asList(inst, host, floorDate);
        Scan scan = WhereOptimizerTest.compileStatement(query, binds).getScan();
        Assert.assertNull((Object)scan.getFilter());
        byte[] startRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)inst), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, PVarchar.INSTANCE.toBytes((Object)host), QueryConstants.SEPARATOR_BYTE_ARRAY, PDate.INSTANCE.toBytes((Object)startDate)});
        Assert.assertArrayEquals((byte[])startRow, (byte[])scan.getStartRow());
        byte[] stopRow = ByteUtil.nextKey((byte[])ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)inst), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, PVarchar.INSTANCE.toBytes((Object)host), QueryConstants.SEPARATOR_BYTE_ARRAY}));
        Assert.assertArrayEquals((byte[])stopRow, (byte[])scan.getStopRow());
        Assert.assertFalse((boolean)scan.includeStopRow());
    }

    @Test
    public void testGreaterThanOrEqualFloorBoundary() throws Exception {
        String inst = "a";
        String host = "b";
        Date floorDate = DateUtil.parseDate((String)"2012-01-01 00:00:00");
        Date startDate = DateUtil.parseDate((String)"2012-01-01 00:00:00");
        String query = "select * from ptsdb where inst=? and host=? and floor(date,'DAY')>=?";
        List<Object> binds = Arrays.asList(inst, host, floorDate);
        Scan scan = WhereOptimizerTest.compileStatement(query, binds).getScan();
        Assert.assertNull((Object)scan.getFilter());
        byte[] startRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)inst), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, PVarchar.INSTANCE.toBytes((Object)host), QueryConstants.SEPARATOR_BYTE_ARRAY, PDate.INSTANCE.toBytes((Object)startDate)});
        Assert.assertArrayEquals((byte[])startRow, (byte[])scan.getStartRow());
        byte[] stopRow = ByteUtil.nextKey((byte[])ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)inst), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, PVarchar.INSTANCE.toBytes((Object)host), QueryConstants.SEPARATOR_BYTE_ARRAY}));
        Assert.assertArrayEquals((byte[])stopRow, (byte[])scan.getStopRow());
        Assert.assertFalse((boolean)scan.includeStopRow());
    }

    @Test
    public void testLessThanOrEqualCeil() throws Exception {
        String inst = "a";
        String host = "b";
        Date ceilDate = DateUtil.parseDate((String)"2012-01-01 01:00:00");
        Date endDate = DateUtil.parseDate((String)"2012-01-01 00:00:00.001");
        String query = "select * from ptsdb where inst=? and host=? and ceil(date,'DAY')<=?";
        List<Object> binds = Arrays.asList(inst, host, ceilDate);
        Scan scan = WhereOptimizerTest.compileStatement(query, binds).getScan();
        Assert.assertNull((Object)scan.getFilter());
        byte[] startRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)inst), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, PVarchar.INSTANCE.toBytes((Object)host)});
        Assert.assertArrayEquals((byte[])startRow, (byte[])scan.getStartRow());
        byte[] stopRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)inst), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, PVarchar.INSTANCE.toBytes((Object)host), QueryConstants.SEPARATOR_BYTE_ARRAY, PDate.INSTANCE.toBytes((Object)endDate)});
        Assert.assertArrayEquals((byte[])stopRow, (byte[])scan.getStopRow());
        Assert.assertFalse((boolean)scan.includeStopRow());
    }

    @Test
    public void testLessThanOrEqualCeilBoundary() throws Exception {
        String inst = "a";
        String host = "b";
        Date ceilDate = DateUtil.parseDate((String)"2012-01-01 00:00:00");
        Date endDate = DateUtil.parseDate((String)"2012-01-01 00:00:00.001");
        String query = "select * from ptsdb where inst=? and host=? and ceil(date,'DAY')<=?";
        List<Object> binds = Arrays.asList(inst, host, ceilDate);
        Scan scan = WhereOptimizerTest.compileStatement(query, binds).getScan();
        Assert.assertNull((Object)scan.getFilter());
        byte[] startRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)inst), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, PVarchar.INSTANCE.toBytes((Object)host)});
        Assert.assertArrayEquals((byte[])startRow, (byte[])scan.getStartRow());
        byte[] stopRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)inst), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, PVarchar.INSTANCE.toBytes((Object)host), QueryConstants.SEPARATOR_BYTE_ARRAY, PDate.INSTANCE.toBytes((Object)endDate)});
        Assert.assertArrayEquals((byte[])stopRow, (byte[])scan.getStopRow());
        Assert.assertFalse((boolean)scan.includeStopRow());
    }

    @Test
    public void testGreaterThanOrEqualCeil() throws Exception {
        String inst = "a";
        String host = "b";
        Date ceilDate = DateUtil.parseDate((String)"2012-01-01 01:00:00");
        Date startDate = DateUtil.parseDate((String)"2012-01-01 00:00:00.001");
        String query = "select * from ptsdb where inst=? and host=? and ceil(date,'DAY')>=?";
        List<Object> binds = Arrays.asList(inst, host, ceilDate);
        Scan scan = WhereOptimizerTest.compileStatement(query, binds).getScan();
        Assert.assertNull((Object)scan.getFilter());
        byte[] startRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)inst), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, PVarchar.INSTANCE.toBytes((Object)host), QueryConstants.SEPARATOR_BYTE_ARRAY, PDate.INSTANCE.toBytes((Object)startDate)});
        Assert.assertArrayEquals((byte[])startRow, (byte[])scan.getStartRow());
        byte[] stopRow = ByteUtil.nextKey((byte[])ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)inst), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, PVarchar.INSTANCE.toBytes((Object)host), QueryConstants.SEPARATOR_BYTE_ARRAY}));
        Assert.assertArrayEquals((byte[])stopRow, (byte[])scan.getStopRow());
        Assert.assertFalse((boolean)scan.includeStopRow());
    }

    @Test
    public void testGreaterThanOrEqualCeilBoundary() throws Exception {
        String inst = "a";
        String host = "b";
        Date ceilDate = DateUtil.parseDate((String)"2012-01-01 00:00:00");
        Date startDate = DateUtil.parseDate((String)"2011-12-31 00:00:00.001");
        String query = "select * from ptsdb where inst=? and host=? and ceil(date,'DAY')>=?";
        List<Object> binds = Arrays.asList(inst, host, ceilDate);
        Scan scan = WhereOptimizerTest.compileStatement(query, binds).getScan();
        Assert.assertNull((Object)scan.getFilter());
        byte[] startRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)inst), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, PVarchar.INSTANCE.toBytes((Object)host), QueryConstants.SEPARATOR_BYTE_ARRAY, PDate.INSTANCE.toBytes((Object)startDate)});
        Assert.assertArrayEquals((byte[])startRow, (byte[])scan.getStartRow());
        byte[] stopRow = ByteUtil.nextKey((byte[])ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)inst), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, PVarchar.INSTANCE.toBytes((Object)host), QueryConstants.SEPARATOR_BYTE_ARRAY}));
        Assert.assertArrayEquals((byte[])stopRow, (byte[])scan.getStopRow());
        Assert.assertFalse((boolean)scan.includeStopRow());
    }

    @Test
    public void testOverlappingKeyExpression() throws SQLException {
        String tenantId = "000000000000001";
        String keyPrefix = "002";
        String entityId = "002333333333333";
        String query = "select * from atable where organization_id='" + tenantId + "' and substr(entity_id,1,3)='" + keyPrefix + "' and entity_id='" + entityId + "'";
        Scan scan = WhereOptimizerTest.compileStatement(query).getScan();
        Assert.assertNull((Object)scan.getFilter());
        byte[] startRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId), (byte[][])new byte[][]{PVarchar.INSTANCE.toBytes((Object)entityId)});
        Assert.assertArrayEquals((byte[])startRow, (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])ByteUtil.nextKey((byte[])startRow), (byte[])scan.getStopRow());
    }

    @Test
    public void testSubstrExpressionWithoutLengthVariable() {
        Assert.assertEquals((Object)"SUBSTR(ENTITY_ID, 1)", (Object)((SubstrFunction)TestUtil.substr2(ENTITY_ID, 1)).toString());
    }

    @Test
    public void testSubstrExpressionWithLengthVariable() {
        Assert.assertEquals((Object)"SUBSTR(ENTITY_ID, 1, 10)", (Object)((SubstrFunction)TestUtil.substr(ENTITY_ID, 1, 10)).toString());
    }

    @Test
    public void testTrailingSubstrExpression() throws SQLException {
        String tenantId = "0xD000000000001";
        String entityId = "002333333333333";
        String query = "select * from atable where substr(organization_id,1,3)='" + tenantId.substring(0, 3) + "' and entity_id='" + entityId + "'";
        Scan scan = WhereOptimizerTest.compileStatement(query).getScan();
        Assert.assertNotNull((Object)scan.getFilter());
        byte[] startRow = ByteUtil.concat((byte[])StringUtil.padChar((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId.substring(0, 3)), (Integer)15), (byte[][])new byte[][]{PVarchar.INSTANCE.toBytes((Object)entityId)});
        Assert.assertArrayEquals((byte[])startRow, (byte[])scan.getStartRow());
        byte[] stopRow = ByteUtil.concat((byte[])StringUtil.padChar((byte[])ByteUtil.nextKey((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId.substring(0, 3))), (Integer)15), (byte[][])new byte[0][]);
        Assert.assertArrayEquals((byte[])stopRow, (byte[])scan.getStopRow());
    }

    @Test
    public void testBasicRangeExpression() throws SQLException {
        String tenantId = "000000000000001";
        String query = "select * from atable where organization_id <= '" + tenantId + "'";
        Scan scan = WhereOptimizerTest.compileStatement(query).getScan();
        Assert.assertNull((Object)scan.getFilter());
        Assert.assertTrue((scan.getStartRow().length == 0 ? 1 : 0) != 0);
        byte[] stopRow = ByteUtil.concat((byte[])ByteUtil.nextKey((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId)), (byte[][])new byte[0][]);
        Assert.assertArrayEquals((byte[])stopRow, (byte[])scan.getStopRow());
    }

    @Test
    public void testKeyRangeExpression1() throws SQLException {
        String tenantId = "000000000000001";
        String keyPrefix1 = "002";
        String keyPrefix2 = "004";
        String query = "select * from atable where organization_id='" + tenantId + "' and substr(entity_id,1,3) >= '" + keyPrefix1 + "' and substr(entity_id,1,3) < '" + keyPrefix2 + "'";
        Scan scan = WhereOptimizerTest.compileStatement(query).getScan();
        Assert.assertNull((Object)scan.getFilter());
        byte[] startRow = ByteUtil.concat((byte[])PChar.INSTANCE.toBytes((Object)tenantId), (byte[][])new byte[][]{StringUtil.padChar((byte[])PChar.INSTANCE.toBytes((Object)keyPrefix1), (Integer)15)});
        Assert.assertArrayEquals((byte[])startRow, (byte[])scan.getStartRow());
        byte[] stopRow = ByteUtil.concat((byte[])PChar.INSTANCE.toBytes((Object)tenantId), (byte[][])new byte[][]{StringUtil.padChar((byte[])PChar.INSTANCE.toBytes((Object)keyPrefix2), (Integer)15)});
        Assert.assertArrayEquals((byte[])stopRow, (byte[])scan.getStopRow());
    }

    @Test
    public void testKeyRangeExpression2() throws SQLException {
        String tenantId = "000000000000001";
        String keyPrefix1 = "002";
        String keyPrefix2 = "004";
        String query = "select * from atable where organization_id='" + tenantId + "' and substr(entity_id,1,3) >= '" + keyPrefix1 + "' and substr(entity_id,1,3) <= '" + keyPrefix2 + "'";
        Scan scan = WhereOptimizerTest.compileStatement(query).getScan();
        Assert.assertNull((Object)scan.getFilter());
        byte[] startRow = ByteUtil.concat((byte[])PChar.INSTANCE.toBytes((Object)tenantId), (byte[][])new byte[][]{StringUtil.padChar((byte[])PChar.INSTANCE.toBytes((Object)keyPrefix1), (Integer)15)});
        Assert.assertArrayEquals((byte[])startRow, (byte[])scan.getStartRow());
        byte[] stopRow = ByteUtil.concat((byte[])PChar.INSTANCE.toBytes((Object)tenantId), (byte[][])new byte[][]{StringUtil.padChar((byte[])ByteUtil.nextKey((byte[])PChar.INSTANCE.toBytes((Object)keyPrefix2)), (Integer)15)});
        Assert.assertArrayEquals((byte[])stopRow, (byte[])scan.getStopRow());
    }

    @Test
    public void testKeyRangeExpression3() throws SQLException {
        String tenantId = "000000000000001";
        String keyPrefix1 = "002";
        String keyPrefix2 = "004";
        String query = "select * from atable where organization_id='" + tenantId + "' and substr(entity_id,1,3) > '" + keyPrefix1 + "' and substr(entity_id,1,3) <= '" + keyPrefix2 + "'";
        Scan scan = WhereOptimizerTest.compileStatement(query).getScan();
        Assert.assertNull((Object)scan.getFilter());
        byte[] startRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId), (byte[][])new byte[][]{StringUtil.padChar((byte[])ByteUtil.nextKey((byte[])PVarchar.INSTANCE.toBytes((Object)keyPrefix1)), (Integer)15)});
        Assert.assertArrayEquals((byte[])startRow, (byte[])scan.getStartRow());
        byte[] stopRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId), (byte[][])new byte[][]{StringUtil.padChar((byte[])ByteUtil.nextKey((byte[])PVarchar.INSTANCE.toBytes((Object)keyPrefix2)), (Integer)15)});
        Assert.assertArrayEquals((byte[])stopRow, (byte[])scan.getStopRow());
    }

    @Test
    public void testKeyRangeExpression4() throws SQLException {
        String tenantId = "000000000000001";
        String keyPrefix1 = "002";
        String entityId = "002000000000002";
        String query = "select * from atable where organization_id='" + tenantId + "' and substr(entity_id,1,3) > '" + keyPrefix1 + "' and substr(entity_id,1,3) = '" + entityId + "'";
        Scan scan = WhereOptimizerTest.compileStatement(query).getScan();
        TestUtil.assertDegenerate(scan);
    }

    @Test
    public void testKeyRangeExpression5() throws SQLException {
        String tenantId = "000000000000001";
        String keyPrefix1 = "002";
        String entityId = "002000000000002";
        String query = "select * from atable where organization_id='" + tenantId + "' and substr(entity_id,1,3) <= '" + keyPrefix1 + "' and entity_id = '" + entityId + "'";
        Scan scan = WhereOptimizerTest.compileStatement(query).getScan();
        Assert.assertNull((Object)scan.getFilter());
        byte[] startRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId), (byte[][])new byte[][]{PVarchar.INSTANCE.toBytes((Object)entityId)});
        Assert.assertArrayEquals((byte[])startRow, (byte[])scan.getStartRow());
        byte[] stopRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId), (byte[][])new byte[][]{PVarchar.INSTANCE.toBytes((Object)entityId)});
        Assert.assertArrayEquals((byte[])ByteUtil.nextKey((byte[])stopRow), (byte[])scan.getStopRow());
    }

    @Test
    public void testKeyRangeExpression6() throws SQLException {
        String tenantId = "000000000000001";
        String keyPrefix1 = "002";
        String entityId = "002000000000002";
        String query = "select * from atable where organization_id='" + tenantId + "' and substr(entity_id,1,3) < '" + keyPrefix1 + "' and entity_id = '" + entityId + "'";
        Scan scan = WhereOptimizerTest.compileStatement(query).getScan();
        TestUtil.assertDegenerate(scan);
    }

    @Test
    public void testKeyRangeExpression7() throws SQLException {
        String tenantId = "000000000000001";
        String keyPrefix1 = "002";
        String entityId = "002000000000002";
        String query = "select * from atable where organization_id='" + tenantId + "' and substr(entity_id,1,3) < '" + keyPrefix1 + "' and entity_id < '" + entityId + "'";
        Scan scan = WhereOptimizerTest.compileStatement(query).getScan();
        Assert.assertNull((Object)scan.getFilter());
        byte[] startRow = PChar.INSTANCE.toBytes((Object)tenantId);
        Assert.assertArrayEquals((byte[])startRow, (byte[])scan.getStartRow());
        byte[] stopRow = ByteUtil.concat((byte[])PChar.INSTANCE.toBytes((Object)tenantId), (byte[][])new byte[][]{StringUtil.padChar((byte[])PChar.INSTANCE.toBytes((Object)keyPrefix1), (Integer)entityId.length())});
        Assert.assertArrayEquals((byte[])stopRow, (byte[])scan.getStopRow());
    }

    @Test
    public void testKeyRangeExpression8() throws SQLException {
        String tenantId = "000000000000001";
        String keyPrefix1 = "001";
        String entityId = "002000000000002";
        String query = "select * from atable where organization_id='" + tenantId + "' and substr(entity_id,1,3) > '" + keyPrefix1 + "' and entity_id = '" + entityId + "'";
        Scan scan = WhereOptimizerTest.compileStatement(query).getScan();
        Assert.assertNull((Object)scan.getFilter());
        byte[] startRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId), (byte[][])new byte[][]{PVarchar.INSTANCE.toBytes((Object)entityId)});
        Assert.assertArrayEquals((byte[])startRow, (byte[])scan.getStartRow());
        byte[] stopRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId), (byte[][])new byte[][]{PVarchar.INSTANCE.toBytes((Object)entityId)});
        Assert.assertArrayEquals((byte[])ByteUtil.nextKey((byte[])stopRow), (byte[])scan.getStopRow());
    }

    @Test
    public void testKeyRangeExpression9() throws SQLException {
        String tenantId = "000000000000001";
        String keyPrefix1 = "002";
        String keyPrefix2 = "0033";
        String query = "select * from atable where organization_id='" + tenantId + "' and substr(entity_id,1,3) >= '" + keyPrefix1 + "' and substr(entity_id,1,4) <= '" + keyPrefix2 + "'";
        Scan scan = WhereOptimizerTest.compileStatement(query).getScan();
        Assert.assertNull((Object)scan.getFilter());
        byte[] startRow = ByteUtil.concat((byte[])PChar.INSTANCE.toBytes((Object)tenantId), (byte[][])new byte[][]{StringUtil.padChar((byte[])PChar.INSTANCE.toBytes((Object)keyPrefix1), (Integer)15)});
        Assert.assertArrayEquals((byte[])startRow, (byte[])scan.getStartRow());
        byte[] stopRow = ByteUtil.concat((byte[])PChar.INSTANCE.toBytes((Object)tenantId), (byte[][])new byte[][]{StringUtil.padChar((byte[])ByteUtil.nextKey((byte[])PChar.INSTANCE.toBytes((Object)keyPrefix2)), (Integer)15)});
        Assert.assertArrayEquals((byte[])stopRow, (byte[])scan.getStopRow());
    }

    @Test
    public void testUnequalOverlappingKeyExpression() throws SQLException {
        String tenantId = "000000000000001";
        String keyPrefix = "002";
        String entityId = "001333333333333";
        String query = "select * from atable where organization_id='" + tenantId + "' and substr(entity_id,1,3)='" + keyPrefix + "' and entity_id='" + entityId + "'";
        Scan scan = WhereOptimizerTest.compileStatement(query).getScan();
        TestUtil.assertDegenerate(scan);
    }

    @Test
    public void testTopLevelOrKeyExpression() throws SQLException {
        String tenantId = "000000000000001";
        String query = "select * from atable where organization_id='" + tenantId + "' or a_integer=2";
        Scan scan = WhereOptimizerTest.compileStatement(query).getScan();
        Assert.assertNotNull((Object)scan.getFilter());
        Assert.assertEquals((long)0L, (long)scan.getStartRow().length);
        Assert.assertEquals((long)0L, (long)scan.getStopRow().length);
    }

    @Test
    public void testSiblingOrKeyExpression() throws SQLException {
        String tenantId = "000000000000001";
        String query = "select * from atable where organization_id='" + tenantId + "' and (a_integer = 2 or a_integer = 3)";
        Scan scan = WhereOptimizerTest.compileStatement(query).getScan();
        Assert.assertNotNull((Object)scan.getFilter());
        Assert.assertArrayEquals((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId), (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])ByteUtil.nextKey((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId)), (byte[])scan.getStopRow());
    }

    @Test
    public void testColumnNotFound() throws SQLException {
        String tenantId = "000000000000001";
        String query = "select * from atable where bar='" + tenantId + "'";
        try {
            WhereOptimizerTest.compileStatement(query);
            Assert.fail();
        }
        catch (ColumnNotFoundException columnNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testNotContiguousPkColumn() throws SQLException {
        String keyPrefix = "002";
        String query = "select * from atable where substr(entity_id,1,3)='" + keyPrefix + "'";
        StatementContext context = WhereOptimizerTest.compileStatement(query);
        Scan scan = context.getScan();
        Assert.assertNotNull((Object)scan.getFilter());
        Assert.assertEquals((long)0L, (long)scan.getStartRow().length);
        Assert.assertEquals((long)0L, (long)scan.getStopRow().length);
    }

    @Test
    public void testMultipleNonEqualitiesPkColumn() throws SQLException {
        String tenantId = "000000000000001";
        String keyPrefix = "002";
        String query = "select * from atable where organization_id >= '" + tenantId + "' AND substr(entity_id,1,3) > '" + keyPrefix + "'";
        StatementContext context = WhereOptimizerTest.compileStatement(query);
        Scan scan = context.getScan();
        Assert.assertNotNull((Object)scan.getFilter());
        Assert.assertArrayEquals((byte[])ByteUtil.concat((byte[])PChar.INSTANCE.toBytes((Object)tenantId), (byte[][])new byte[][]{PChar.INSTANCE.toBytes(PChar.INSTANCE.pad(PChar.INSTANCE.toObject(ByteUtil.nextKey((byte[])PChar.INSTANCE.toBytes((Object)keyPrefix))), Integer.valueOf(15)))}), (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])HConstants.EMPTY_END_ROW, (byte[])scan.getStopRow());
    }

    @Test
    public void testRHSLiteral() throws SQLException {
        String tenantId = "000000000000001";
        String query = "select * from atable where organization_id='" + tenantId + "' and 0 >= a_integer limit 1000";
        StatementContext context = WhereOptimizerTest.compileStatement(query, 1000);
        Scan scan = context.getScan();
        Assert.assertNotNull((Object)scan.getFilter());
        Assert.assertArrayEquals((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId), (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])ByteUtil.nextKey((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId)), (byte[])scan.getStopRow());
    }

    @Test
    public void testKeyTypeMismatch() {
        String query = "select * from atable where organization_id=5";
        try {
            WhereOptimizerTest.compileStatement(query);
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Type mismatch"));
        }
    }

    @Test
    public void testLikeExtractAllKeyExpression() throws SQLException {
        String tenantId = "000000000000001";
        String keyPrefix = "002";
        String query = "select * from atable where organization_id = ? and entity_id  LIKE '" + keyPrefix + "%'";
        List<Object> binds = Arrays.asList(tenantId);
        StatementContext context = WhereOptimizerTest.compileStatement(query, binds);
        Scan scan = context.getScan();
        Assert.assertNull((Object)scan.getFilter());
        byte[] startRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId), (byte[][])new byte[][]{StringUtil.padChar((byte[])PVarchar.INSTANCE.toBytes((Object)keyPrefix), (Integer)15)});
        Assert.assertArrayEquals((byte[])startRow, (byte[])scan.getStartRow());
        byte[] stopRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId), (byte[][])new byte[][]{StringUtil.padChar((byte[])ByteUtil.nextKey((byte[])PVarchar.INSTANCE.toBytes((Object)keyPrefix)), (Integer)15)});
        Assert.assertArrayEquals((byte[])stopRow, (byte[])scan.getStopRow());
    }

    @Test
    public void testLikeExtractAllKeyExpression2() throws SQLException {
        String tenantId = "000000000000001";
        String keyPrefix = "\u4e2d\u6587";
        String query = "select * from atable where organization_id = ? and entity_id  LIKE '" + keyPrefix + "%'";
        List<Object> binds = Arrays.asList(tenantId);
        StatementContext context = WhereOptimizerTest.compileStatement(query, binds);
        Scan scan = context.getScan();
        Assert.assertNull((Object)scan.getFilter());
        byte[] startRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId), (byte[][])new byte[][]{StringUtil.padChar((byte[])PVarchar.INSTANCE.toBytes((Object)keyPrefix), (Integer)15)});
        Assert.assertArrayEquals((byte[])startRow, (byte[])scan.getStartRow());
        byte[] stopRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId), (byte[][])new byte[][]{StringUtil.padChar((byte[])ByteUtil.nextKey((byte[])PVarchar.INSTANCE.toBytes((Object)keyPrefix)), (Integer)15)});
        Assert.assertArrayEquals((byte[])stopRow, (byte[])scan.getStopRow());
    }

    @Test
    public void testLikeExtractAllAsEqKeyExpression() throws SQLException {
        String tenantId = "000000000000001";
        String keyPrefix = "002";
        String query = "select * from atable where organization_id LIKE ? and entity_id  LIKE '" + keyPrefix + "%'";
        List<Object> binds = Arrays.asList(tenantId);
        StatementContext context = WhereOptimizerTest.compileStatement(query, binds);
        Scan scan = context.getScan();
        Assert.assertNull((Object)scan.getFilter());
        byte[] startRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId), (byte[][])new byte[][]{StringUtil.padChar((byte[])PVarchar.INSTANCE.toBytes((Object)keyPrefix), (Integer)15)});
        Assert.assertArrayEquals((byte[])startRow, (byte[])scan.getStartRow());
        byte[] stopRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId), (byte[][])new byte[][]{StringUtil.padChar((byte[])ByteUtil.nextKey((byte[])PVarchar.INSTANCE.toBytes((Object)keyPrefix)), (Integer)15)});
        Assert.assertArrayEquals((byte[])stopRow, (byte[])scan.getStopRow());
    }

    @Test
    public void testLikeExpressionWithDescOrder() throws SQLException {
        Connection conn = DriverManager.getConnection(WhereOptimizerTest.getUrl());
        String tableName = WhereOptimizerTest.generateUniqueName();
        conn.createStatement().execute("CREATE TABLE " + tableName + " (id varchar, name varchar, type decimal, status integer CONSTRAINT pk PRIMARY KEY(id desc, type))");
        String query = "SELECT * FROM " + tableName + " where type = 1 and id like 'xy%'";
        StatementContext context = WhereOptimizerTest.compileStatement(query);
        Scan scan = context.getScan();
        Assert.assertTrue((boolean)(scan.getFilter() instanceof SkipScanFilter));
        SkipScanFilter filter = (SkipScanFilter)scan.getFilter();
        byte[] lowerRange = ((KeyRange)((List)filter.getSlots().get(0)).get(0)).getLowerRange();
        byte[] upperRange = ((KeyRange)((List)filter.getSlots().get(0)).get(0)).getUpperRange();
        boolean lowerInclusive = ((KeyRange)((List)filter.getSlots().get(0)).get(0)).isLowerInclusive();
        boolean upperInclusive = ((KeyRange)((List)filter.getSlots().get(0)).get(0)).isUpperInclusive();
        byte[] startRow = PVarchar.INSTANCE.toBytes((Object)"xy");
        byte[] invStartRow = new byte[startRow.length];
        SortOrder.invert((byte[])startRow, (int)0, (byte[])invStartRow, (int)0, (int)startRow.length);
        byte[] stopRow = PVarchar.INSTANCE.toBytes((Object)"xz");
        byte[] invStopRow = new byte[startRow.length];
        SortOrder.invert((byte[])stopRow, (int)0, (byte[])invStopRow, (int)0, (int)stopRow.length);
        Assert.assertArrayEquals((byte[])invStopRow, (byte[])lowerRange);
        Assert.assertArrayEquals((byte[])invStartRow, (byte[])upperRange);
        Assert.assertFalse((boolean)lowerInclusive);
        Assert.assertTrue((boolean)upperInclusive);
        byte[] expectedStartRow = ByteUtil.concat((byte[])invStartRow, (byte[][])new byte[][]{{0}, PDecimal.INSTANCE.toBytes((Object)new BigDecimal(1))});
        Assert.assertArrayEquals((byte[])expectedStartRow, (byte[])scan.getStartRow());
        byte[] expectedStopRow = ByteUtil.concat((byte[])invStartRow, (byte[][])new byte[][]{{-1}, PDecimal.INSTANCE.toBytes((Object)new BigDecimal(1)), {1}});
        Assert.assertArrayEquals((byte[])expectedStopRow, (byte[])scan.getStopRow());
        query = "SELECT * FROM " + tableName + " where type = 1 and id like 'x%'";
        context = WhereOptimizerTest.compileStatement(query);
        scan = context.getScan();
        Assert.assertTrue((boolean)(scan.getFilter() instanceof SkipScanFilter));
        filter = (SkipScanFilter)scan.getFilter();
        lowerRange = ((KeyRange)((List)filter.getSlots().get(0)).get(0)).getLowerRange();
        upperRange = ((KeyRange)((List)filter.getSlots().get(0)).get(0)).getUpperRange();
        lowerInclusive = ((KeyRange)((List)filter.getSlots().get(0)).get(0)).isLowerInclusive();
        upperInclusive = ((KeyRange)((List)filter.getSlots().get(0)).get(0)).isUpperInclusive();
        startRow = PVarchar.INSTANCE.toBytes((Object)"x");
        invStartRow = new byte[startRow.length];
        SortOrder.invert((byte[])startRow, (int)0, (byte[])invStartRow, (int)0, (int)startRow.length);
        stopRow = PVarchar.INSTANCE.toBytes((Object)"y");
        invStopRow = new byte[startRow.length];
        SortOrder.invert((byte[])stopRow, (int)0, (byte[])invStopRow, (int)0, (int)stopRow.length);
        Assert.assertArrayEquals((byte[])invStopRow, (byte[])lowerRange);
        Assert.assertArrayEquals((byte[])invStartRow, (byte[])upperRange);
        Assert.assertFalse((boolean)lowerInclusive);
        Assert.assertTrue((boolean)upperInclusive);
        expectedStartRow = ByteUtil.concat((byte[])invStartRow, (byte[][])new byte[][]{{0}, PDecimal.INSTANCE.toBytes((Object)new BigDecimal(1))});
        Assert.assertArrayEquals((byte[])expectedStartRow, (byte[])scan.getStartRow());
        expectedStopRow = ByteUtil.concat((byte[])invStartRow, (byte[][])new byte[][]{{-1}, PDecimal.INSTANCE.toBytes((Object)new BigDecimal(1)), {1}});
        Assert.assertArrayEquals((byte[])expectedStopRow, (byte[])scan.getStopRow());
    }

    @Test
    public void testLikeNoWildcardExpression() throws SQLException {
        String tenantId = "000000000000001";
        String keyPrefix = "002";
        String query = "select * from atable where organization_id LIKE ? and entity_id  LIKE '" + keyPrefix + "'";
        List<Object> binds = Arrays.asList(tenantId);
        StatementContext context = WhereOptimizerTest.compileStatement(query, binds);
        Scan scan = context.getScan();
        byte[] startRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId), (byte[][])new byte[][]{StringUtil.padChar((byte[])PVarchar.INSTANCE.toBytes((Object)keyPrefix), (Integer)15)});
        Assert.assertArrayEquals((byte[])startRow, (byte[])scan.getStartRow());
        byte[] stopRow = ByteUtil.nextKey((byte[])startRow);
        Assert.assertArrayEquals((byte[])stopRow, (byte[])scan.getStopRow());
    }

    @Test
    public void testLikeExtractKeyExpression2() throws SQLException {
        String tenantId = "000000000000001";
        String keyPrefix = "002";
        String likeArg = keyPrefix + "_";
        String query = "select * from atable where organization_id = ? and entity_id  LIKE '" + likeArg + "'";
        List<Object> binds = Arrays.asList(tenantId);
        StatementContext context = WhereOptimizerTest.compileStatement(query, binds);
        Scan scan = context.getScan();
        Filter filter = scan.getFilter();
        Assert.assertNotNull((Object)filter);
        Assert.assertEquals((Object)TestUtil.rowKeyFilter(TestUtil.like(ENTITY_ID, likeArg, context)), (Object)filter);
        byte[] startRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId), (byte[][])new byte[][]{StringUtil.padChar((byte[])PVarchar.INSTANCE.toBytes((Object)keyPrefix), (Integer)15)});
        Assert.assertArrayEquals((byte[])startRow, (byte[])scan.getStartRow());
        byte[] stopRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId), (byte[][])new byte[][]{StringUtil.padChar((byte[])ByteUtil.nextKey((byte[])PVarchar.INSTANCE.toBytes((Object)keyPrefix)), (Integer)15)});
        Assert.assertArrayEquals((byte[])stopRow, (byte[])scan.getStopRow());
    }

    @Test
    public void testLikeOptKeyExpression() throws SQLException {
        String tenantId = "000000000000001";
        String keyPrefix = "002";
        String likeArg = keyPrefix + "%003%";
        String query = "select * from atable where organization_id = ? and entity_id  LIKE '" + likeArg + "'";
        List<Object> binds = Arrays.asList(tenantId);
        StatementContext context = WhereOptimizerTest.compileStatement(query, binds);
        Scan scan = context.getScan();
        Filter filter = scan.getFilter();
        Assert.assertNotNull((Object)filter);
        Assert.assertEquals((Object)TestUtil.rowKeyFilter(TestUtil.like(ENTITY_ID, likeArg, context)), (Object)filter);
        byte[] startRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId), (byte[][])new byte[][]{StringUtil.padChar((byte[])PVarchar.INSTANCE.toBytes((Object)keyPrefix), (Integer)15)});
        Assert.assertArrayEquals((byte[])startRow, (byte[])scan.getStartRow());
        byte[] stopRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId), (byte[][])new byte[][]{StringUtil.padChar((byte[])ByteUtil.nextKey((byte[])PVarchar.INSTANCE.toBytes((Object)keyPrefix)), (Integer)15)});
        Assert.assertArrayEquals((byte[])stopRow, (byte[])scan.getStopRow());
    }

    @Test
    public void testLikeOptKeyExpression2() throws SQLException {
        String tenantId = "000000000000001";
        String keyPrefix = "002";
        String likeArg = keyPrefix + "%003%";
        String query = "select * from atable where organization_id = ? and substr(entity_id,1,10)  LIKE '" + likeArg + "'";
        List<Object> binds = Arrays.asList(tenantId);
        StatementContext context = WhereOptimizerTest.compileStatement(query, binds);
        Scan scan = context.getScan();
        Filter filter = scan.getFilter();
        Assert.assertNotNull((Object)filter);
        Assert.assertEquals((Object)TestUtil.rowKeyFilter(TestUtil.like(TestUtil.substr(ENTITY_ID, 1, 10), likeArg, context)), (Object)filter);
        byte[] startRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId), (byte[][])new byte[][]{StringUtil.padChar((byte[])PVarchar.INSTANCE.toBytes((Object)keyPrefix), (Integer)15)});
        byte[] stopRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId), (byte[][])new byte[][]{StringUtil.padChar((byte[])ByteUtil.nextKey((byte[])PVarchar.INSTANCE.toBytes((Object)keyPrefix)), (Integer)15)});
        Assert.assertArrayEquals((byte[])startRow, (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])stopRow, (byte[])scan.getStopRow());
    }

    @Test
    public void testLikeNoOptKeyExpression3() throws SQLException {
        String tenantId = "000000000000001";
        String keyPrefix = "002";
        String likeArg = keyPrefix + "%003%";
        String query = "select * from atable where organization_id = ? and substr(entity_id,4,10)  LIKE '" + likeArg + "'";
        List<Object> binds = Arrays.asList(tenantId);
        StatementContext context = WhereOptimizerTest.compileStatement(query, binds);
        Scan scan = context.getScan();
        Filter filter = scan.getFilter();
        Assert.assertNotNull((Object)filter);
        Assert.assertEquals((Object)TestUtil.rowKeyFilter(TestUtil.like(TestUtil.substr(ENTITY_ID, 4, 10), likeArg, context)), (Object)filter);
        byte[] startRow = PVarchar.INSTANCE.toBytes((Object)tenantId);
        Assert.assertArrayEquals((byte[])startRow, (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])ByteUtil.nextKey((byte[])startRow), (byte[])scan.getStopRow());
    }

    @Test
    public void testLikeNoOptKeyExpression() throws SQLException {
        String tenantId = "000000000000001";
        String keyPrefix = "002";
        String likeArg = "%001%" + keyPrefix + "%";
        String query = "select * from atable where organization_id = ? and entity_id  LIKE '" + likeArg + "'";
        List<Object> binds = Arrays.asList(tenantId);
        StatementContext context = WhereOptimizerTest.compileStatement(query, binds);
        Scan scan = context.getScan();
        Filter filter = scan.getFilter();
        Assert.assertNotNull((Object)filter);
        Assert.assertEquals((Object)TestUtil.rowKeyFilter(TestUtil.like(ENTITY_ID, likeArg, context)), (Object)filter);
        byte[] startRow = PVarchar.INSTANCE.toBytes((Object)tenantId);
        Assert.assertArrayEquals((byte[])startRow, (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])ByteUtil.nextKey((byte[])startRow), (byte[])scan.getStopRow());
    }

    @Test
    public void testLikeNoOptKeyExpression2() throws SQLException {
        String tenantId = "000000000000001";
        String keyPrefix = "002";
        String likeArg = keyPrefix + "%";
        String query = "select * from atable where organization_id = ? and entity_id  NOT LIKE '" + likeArg + "'";
        List<Object> binds = Arrays.asList(tenantId);
        StatementContext context = WhereOptimizerTest.compileStatement(query, binds);
        Scan scan = context.getScan();
        Filter filter = scan.getFilter();
        Assert.assertNotNull((Object)filter);
        Assert.assertEquals((Object)TestUtil.rowKeyFilter(TestUtil.not(TestUtil.like(ENTITY_ID, likeArg, context))), (Object)filter);
        byte[] startRow = PVarchar.INSTANCE.toBytes((Object)tenantId);
        Assert.assertArrayEquals((byte[])startRow, (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])ByteUtil.nextKey((byte[])startRow), (byte[])scan.getStopRow());
    }

    @Test
    public void testLikeDegenerate() throws SQLException {
        String tenantId = "000000000000001";
        String query = "select * from atable where organization_id = ? and entity_id  LIKE '0000000000000012%003%'";
        List<Object> binds = Arrays.asList(tenantId);
        StatementContext context = WhereOptimizerTest.compileStatement(query, binds);
        Scan scan = context.getScan();
        TestUtil.assertDegenerate(scan);
    }

    @Test
    public void testDegenerateDivision1() throws SQLException {
        String query = "select * from atable where a_integer = 3 / null";
        StatementContext context = WhereOptimizerTest.compileStatement(query);
        Scan scan = context.getScan();
        TestUtil.assertDegenerate(scan);
    }

    @Test
    public void testDegenerateDivision2() throws SQLException {
        String query = "select * from atable where a_integer / null = 3";
        StatementContext context = WhereOptimizerTest.compileStatement(query);
        Scan scan = context.getScan();
        TestUtil.assertDegenerate(scan);
    }

    @Test
    public void testDegenerateMult1() throws SQLException {
        String query = "select * from atable where a_integer = 3 * null";
        StatementContext context = WhereOptimizerTest.compileStatement(query);
        Scan scan = context.getScan();
        TestUtil.assertDegenerate(scan);
    }

    @Test
    public void testDegenerateMult2() throws SQLException {
        String query = "select * from atable where a_integer * null = 3";
        StatementContext context = WhereOptimizerTest.compileStatement(query);
        Scan scan = context.getScan();
        TestUtil.assertDegenerate(scan);
    }

    @Test
    public void testDegenerateAdd1() throws SQLException {
        String query = "select * from atable where a_integer = 3 + null";
        StatementContext context = WhereOptimizerTest.compileStatement(query);
        Scan scan = context.getScan();
        TestUtil.assertDegenerate(scan);
    }

    @Test
    public void testDegenerateAdd2() throws SQLException {
        String query = "select * from atable where a_integer + null = 3";
        StatementContext context = WhereOptimizerTest.compileStatement(query);
        Scan scan = context.getScan();
        TestUtil.assertDegenerate(scan);
    }

    @Test
    public void testDegenerateSub1() throws SQLException {
        String query = "select * from atable where a_integer = 3 - null";
        StatementContext context = WhereOptimizerTest.compileStatement(query);
        Scan scan = context.getScan();
        TestUtil.assertDegenerate(scan);
    }

    @Test
    public void testDegenerateSub2() throws SQLException {
        String query = "select * from atable where a_integer - null = 3";
        StatementContext context = WhereOptimizerTest.compileStatement(query);
        Scan scan = context.getScan();
        TestUtil.assertDegenerate(scan);
    }

    @Test
    public void testValueComparisonInt() throws SQLException {
        WhereOptimizerTest.ensureTableCreated(WhereOptimizerTest.getUrl(), "PKIntValueTest", "PKIntValueTest");
        String query = "SELECT * FROM PKintValueTest where pk = 9223372036854775807";
        this.assertQueryConditionAlwaysFalse(query);
        query = "SELECT * FROM PKintValueTest where pk != 9223372036854775807";
        this.assertQueryConditionAlwaysTrue(query);
        query = "SELECT * FROM PKintValueTest where pk >= 9223372036854775807";
        this.assertQueryConditionAlwaysFalse(query);
        query = "SELECT * FROM PKintValueTest where pk <= 9223372036854775807";
        this.assertQueryConditionAlwaysTrue(query);
        query = "SELECT * FROM PKintValueTest where pk >= -9223372036854775807";
        this.assertQueryConditionAlwaysTrue(query);
        query = "SELECT * FROM PKintValueTest where pk <= -9223372036854775807";
        this.assertQueryConditionAlwaysFalse(query);
    }

    @Test
    public void testValueComparisonUnsignedInt() throws SQLException {
        WhereOptimizerTest.ensureTableCreated(WhereOptimizerTest.getUrl(), "PKUnsignedIntValueTest", "PKUnsignedIntValueTest");
        String query = "SELECT * FROM PKUnsignedIntValueTest where pk = -1";
        this.assertQueryConditionAlwaysFalse(query);
        query = "SELECT * FROM PKUnsignedIntValueTest where pk != -1";
        this.assertQueryConditionAlwaysTrue(query);
        query = "SELECT * FROM PKUnsignedIntValueTest where pk > -9223372036854775807";
        this.assertQueryConditionAlwaysTrue(query);
        query = "SELECT * FROM PKUnsignedIntValueTest where pk < -9223372036854775807";
        this.assertQueryConditionAlwaysFalse(query);
        query = "SELECT * FROM PKUnsignedIntValueTest where pk = 9223372036854775807";
        this.assertQueryConditionAlwaysFalse(query);
        query = "SELECT * FROM PKUnsignedIntValueTest where pk != 9223372036854775807";
        this.assertQueryConditionAlwaysTrue(query);
        query = "SELECT * FROM PKUnsignedIntValueTest where pk >= 9223372036854775807";
        this.assertQueryConditionAlwaysFalse(query);
        query = "SELECT * FROM PKUnsignedIntValueTest where pk <= 9223372036854775807";
        this.assertQueryConditionAlwaysTrue(query);
    }

    @Test
    public void testValueComparisonUnsignedLong() throws SQLException {
        WhereOptimizerTest.ensureTableCreated(WhereOptimizerTest.getUrl(), "PKUnsignedLongValueTest", "PKUnsignedLongValueTest");
        String query = "SELECT * FROM PKUnsignedLongValueTest where pk = -1";
        this.assertQueryConditionAlwaysFalse(query);
        query = "SELECT * FROM PKUnsignedLongValueTest where pk != -9223372036854775807";
        this.assertQueryConditionAlwaysTrue(query);
        query = "SELECT * FROM PKUnsignedLongValueTest where pk > -1";
        this.assertQueryConditionAlwaysTrue(query);
        query = "SELECT * FROM PKUnsignedLongValueTest where pk < -9223372036854775807";
        this.assertQueryConditionAlwaysFalse(query);
    }

    private void assertQueryConditionAlwaysTrue(String query) throws SQLException {
        Scan scan = WhereOptimizerTest.compileStatement(query).getScan();
        TestUtil.assertEmptyScanKey(scan);
    }

    private void assertQueryConditionAlwaysFalse(String query) throws SQLException {
        Scan scan = WhereOptimizerTest.compileStatement(query).getScan();
        TestUtil.assertDegenerate(scan);
    }

    @Test
    public void testOrSameColExpression() throws SQLException {
        String tenantId1 = "000000000000001";
        String tenantId2 = "000000000000003";
        String query = "select * from atable where organization_id = ? or organization_id  = ?";
        List<Object> binds = Arrays.asList(tenantId1, tenantId2);
        StatementContext context = WhereOptimizerTest.compileStatement(query, binds);
        Scan scan = context.getScan();
        Filter filter = scan.getFilter();
        Assert.assertNotNull((Object)filter);
        Assert.assertTrue((boolean)(filter instanceof SkipScanFilter));
        ScanRanges scanRanges = context.getScanRanges();
        Assert.assertNotNull((Object)scanRanges);
        List ranges = scanRanges.getRanges();
        Assert.assertEquals((long)1L, (long)ranges.size());
        List<List<KeyRange>> expectedRanges = Collections.singletonList(Arrays.asList(PChar.INSTANCE.getKeyRange(PChar.INSTANCE.toBytes((Object)tenantId1), true, PChar.INSTANCE.toBytes((Object)tenantId1), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(PChar.INSTANCE.toBytes((Object)tenantId2), true, PChar.INSTANCE.toBytes((Object)tenantId2), true, SortOrder.ASC)));
        Assert.assertEquals(expectedRanges, (Object)ranges);
        byte[] startRow = PVarchar.INSTANCE.toBytes((Object)tenantId1);
        Assert.assertArrayEquals((byte[])startRow, (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])ByteUtil.nextKey((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId2)), (byte[])scan.getStopRow());
    }

    @Test
    public void testAndOrExpression() throws SQLException {
        String tenantId1 = "000000000000001";
        String tenantId2 = "000000000000003";
        String entityId1 = "002333333333331";
        String entityId2 = "002333333333333";
        String query = "select * from atable where (organization_id = ? and entity_id  = ?) or (organization_id = ? and entity_id  = ?)";
        List<Object> binds = Arrays.asList(tenantId1, entityId1, tenantId2, entityId2);
        StatementContext context = WhereOptimizerTest.compileStatement(query, binds);
        Scan scan = context.getScan();
        Filter filter = scan.getFilter();
        Assert.assertNotNull((Object)filter);
        Assert.assertTrue((boolean)(filter instanceof RowKeyComparisonFilter));
        ScanRanges scanRanges = context.getScanRanges();
        Assert.assertEquals((Object)ScanRanges.EVERYTHING, (Object)scanRanges);
        Assert.assertArrayEquals((byte[])HConstants.EMPTY_START_ROW, (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])HConstants.EMPTY_END_ROW, (byte[])scan.getStopRow());
    }

    @Test
    public void testOrDiffColExpression() throws SQLException {
        String tenantId1 = "000000000000001";
        String entityId1 = "002333333333331";
        String query = "select * from atable where organization_id = ? or entity_id  = ?";
        List<Object> binds = Arrays.asList(tenantId1, entityId1);
        StatementContext context = WhereOptimizerTest.compileStatement(query, binds);
        Scan scan = context.getScan();
        Filter filter = scan.getFilter();
        Assert.assertNotNull((Object)filter);
        Assert.assertTrue((boolean)(filter instanceof RowKeyComparisonFilter));
        ScanRanges scanRanges = context.getScanRanges();
        Assert.assertEquals((Object)ScanRanges.EVERYTHING, (Object)scanRanges);
        Assert.assertArrayEquals((byte[])HConstants.EMPTY_START_ROW, (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])HConstants.EMPTY_END_ROW, (byte[])scan.getStopRow());
    }

    @Test
    public void testOrSameColRangeExpression() throws SQLException {
        String query = "select * from atable where substr(organization_id,1,3) = ? or organization_id LIKE 'foo%'";
        List<Object> binds = Arrays.asList("00D");
        StatementContext context = WhereOptimizerTest.compileStatement(query, binds);
        Scan scan = context.getScan();
        Filter filter = scan.getFilter();
        Assert.assertNotNull((Object)filter);
        Assert.assertTrue((boolean)(filter instanceof SkipScanFilter));
        ScanRanges scanRanges = context.getScanRanges();
        Assert.assertNotNull((Object)scanRanges);
        List ranges = scanRanges.getRanges();
        Assert.assertEquals((long)1L, (long)ranges.size());
        List<List<KeyRange>> expectedRanges = Collections.singletonList(Arrays.asList(PChar.INSTANCE.getKeyRange(StringUtil.padChar((byte[])PChar.INSTANCE.toBytes((Object)"00D"), (Integer)15), true, StringUtil.padChar((byte[])ByteUtil.nextKey((byte[])PChar.INSTANCE.toBytes((Object)"00D")), (Integer)15), false, SortOrder.ASC), PChar.INSTANCE.getKeyRange(StringUtil.padChar((byte[])PChar.INSTANCE.toBytes((Object)"foo"), (Integer)15), true, StringUtil.padChar((byte[])ByteUtil.nextKey((byte[])PChar.INSTANCE.toBytes((Object)"foo")), (Integer)15), false, SortOrder.ASC)));
        Assert.assertEquals(expectedRanges, (Object)ranges);
    }

    @Test
    public void testOrPKRanges() throws SQLException {
        Connection conn = DriverManager.getConnection(WhereOptimizerTest.getUrl());
        WhereOptimizerTest.ensureTableCreated(WhereOptimizerTest.getUrl(), "BTABLE");
        Statement stmt = conn.createStatement();
        String query = "select * from BTABLE where (a_string > '1' and a_string < '5') or (a_string > '6' and a_string < '9')";
        StatementContext context = WhereOptimizerTest.compileStatement(query);
        Filter filter = context.getScan().getFilter();
        Assert.assertNotNull((Object)filter);
        Assert.assertTrue((boolean)(filter instanceof SkipScanFilter));
        ScanRanges scanRanges = context.getScanRanges();
        Assert.assertNotNull((Object)scanRanges);
        List ranges = scanRanges.getRanges();
        Assert.assertEquals((long)1L, (long)ranges.size());
        List<List<KeyRange>> expectedRanges = Collections.singletonList(Arrays.asList(KeyRange.getKeyRange((byte[])Bytes.toBytes((String)"1"), (boolean)false, (byte[])Bytes.toBytes((String)"5"), (boolean)false), KeyRange.getKeyRange((byte[])Bytes.toBytes((String)"6"), (boolean)false, (byte[])Bytes.toBytes((String)"9"), (boolean)false)));
        Assert.assertEquals(expectedRanges, (Object)ranges);
        stmt.close();
        conn.close();
    }

    @Test
    public void testOrPKRangesNotOptimized() throws SQLException {
        String[] queries;
        Connection conn = DriverManager.getConnection(WhereOptimizerTest.getUrl());
        WhereOptimizerTest.ensureTableCreated(WhereOptimizerTest.getUrl(), "BTABLE");
        Statement stmt = conn.createStatement();
        for (String query : queries = new String[]{"select * from BTABLE where (a_string > '1' and a_string < '5') or (a_string > '6' and a_string < '9' and a_id = 'foo')", "select * from BTABLE where (a_id > 'aaa' and a_id < 'ccc') or (a_id > 'jjj' and a_id < 'mmm')"}) {
            StatementContext context = WhereOptimizerTest.compileStatement(query);
            Iterator it = ScanUtil.getFilterIterator((Scan)context.getScan());
            while (it.hasNext()) {
                Assert.assertFalse((boolean)(it.next() instanceof SkipScanFilter));
            }
            TestUtil.assertNotDegenerate(context.getScan());
        }
        stmt.close();
        conn.close();
    }

    @Test
    public void testForceSkipScanOnSaltedTable() throws SQLException {
        Connection conn = DriverManager.getConnection(WhereOptimizerTest.getUrl());
        conn.createStatement().execute("CREATE TABLE IF NOT EXISTS user_messages (\n        SENDER_ID UNSIGNED_LONG NOT NULL,\n        RECIPIENT_ID UNSIGNED_LONG NOT NULL,\n        SENDER_IP VARCHAR,\n        IS_READ VARCHAR,\n        IS_DELETED VARCHAR,\n        M_TEXT VARCHAR,\n        M_TIMESTAMP timestamp  NOT NULL,\n        ROW_ID UNSIGNED_LONG NOT NULL\n        constraint rowkey primary key (SENDER_ID,RECIPIENT_ID,M_TIMESTAMP DESC,ROW_ID))\nSALT_BUCKETS=12\n");
        String query = "select /*+ SKIP_SCAN */ count(*) from user_messages where is_read='N' and recipient_id=5399179882";
        StatementContext context = WhereOptimizerTest.compileStatement(query);
        Scan scan = context.getScan();
        Filter filter = scan.getFilter();
        Assert.assertNotNull((Object)filter);
        Assert.assertTrue((boolean)(filter instanceof FilterList));
        FilterList filterList = (FilterList)filter;
        Assert.assertEquals((Object)FilterList.Operator.MUST_PASS_ALL, (Object)filterList.getOperator());
        Assert.assertEquals((long)2L, (long)filterList.getFilters().size());
        Assert.assertTrue((boolean)(filterList.getFilters().get(0) instanceof SkipScanFilter));
        Assert.assertTrue((boolean)(filterList.getFilters().get(1) instanceof SingleKeyValueComparisonFilter));
        ScanRanges scanRanges = context.getScanRanges();
        Assert.assertNotNull((Object)scanRanges);
        Assert.assertEquals((long)3L, (long)scanRanges.getRanges().size());
        Assert.assertEquals((long)1L, (long)((List)scanRanges.getRanges().get(1)).size());
        Assert.assertEquals((Object)KeyRange.EVERYTHING_RANGE, ((List)scanRanges.getRanges().get(1)).get(0));
        Assert.assertEquals((long)1L, (long)((List)scanRanges.getRanges().get(2)).size());
        Assert.assertTrue((boolean)((KeyRange)((List)scanRanges.getRanges().get(2)).get(0)).isSingleKey());
        Assert.assertEquals((Object)5399179882L, (Object)PUnsignedLong.INSTANCE.toObject(((KeyRange)((List)scanRanges.getRanges().get(2)).get(0)).getLowerRange()));
    }

    @Test
    public void testForceRangeScanKeepsFilters() throws SQLException {
        WhereOptimizerTest.ensureTableCreated(WhereOptimizerTest.getUrl(), "ENTITY_HISTORY", "ENTITY_HISTORY");
        String tenantId = "000000000000001";
        String keyPrefix = "002";
        String query = "select /*+ RANGE_SCAN */ ORGANIZATION_ID, PARENT_ID, CREATED_DATE, ENTITY_HISTORY_ID from ENTITY_HISTORY where ORGANIZATION_ID=? and SUBSTR(PARENT_ID, 1, 3) = ? and  CREATED_DATE >= ? and CREATED_DATE < ? order by ORGANIZATION_ID, PARENT_ID, CREATED_DATE, ENTITY_HISTORY_ID limit 6";
        Date startTime = new Date(System.currentTimeMillis());
        Date stopTime = new Date(startTime.getTime() + 86400000L);
        List<Object> binds = Arrays.asList(tenantId, keyPrefix, startTime, stopTime);
        StatementContext context = WhereOptimizerTest.compileStatement(query, binds, 6);
        Scan scan = context.getScan();
        Filter filter = scan.getFilter();
        Assert.assertNotNull((Object)filter);
        Assert.assertTrue((boolean)(filter instanceof RowKeyComparisonFilter));
        byte[] expectedStartRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId), (byte[][])new byte[][]{StringUtil.padChar((byte[])PVarchar.INSTANCE.toBytes((Object)keyPrefix), (Integer)15), PDate.INSTANCE.toBytes((Object)startTime)});
        Assert.assertArrayEquals((byte[])expectedStartRow, (byte[])scan.getStartRow());
        byte[] expectedStopRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId), (byte[][])new byte[][]{StringUtil.padChar((byte[])ByteUtil.nextKey((byte[])PVarchar.INSTANCE.toBytes((Object)keyPrefix)), (Integer)15)});
        Assert.assertArrayEquals((byte[])expectedStopRow, (byte[])scan.getStopRow());
    }

    @Test
    public void testBasicRVCExpression() throws SQLException {
        String tenantId = "000000000000001";
        String entityId = "002333333333331";
        String query = "select * from atable where (organization_id,entity_id) >= (?,?)";
        List<Object> binds = Arrays.asList(tenantId, entityId);
        StatementContext context = WhereOptimizerTest.compileStatement(query, binds);
        Scan scan = context.getScan();
        Assert.assertNull((Object)scan.getFilter());
        byte[] expectedStartRow = ByteUtil.concat((byte[])PChar.INSTANCE.toBytes((Object)tenantId), (byte[][])new byte[][]{PChar.INSTANCE.toBytes((Object)entityId)});
        Assert.assertArrayEquals((byte[])expectedStartRow, (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])HConstants.EMPTY_END_ROW, (byte[])scan.getStopRow());
    }

    @Test
    public void testRVCExpressionThroughOr() throws SQLException {
        String tenantId = "000000000000001";
        String entityId = "002333333333331";
        String entityId1 = "002333333333330";
        String entityId2 = "002333333333332";
        String query = "select * from atable where (organization_id,entity_id) >= (?,?) and organization_id = ? and  (entity_id = ? or entity_id = ?)";
        List<Object> binds = Arrays.asList(tenantId, entityId, tenantId, entityId1, entityId2);
        StatementContext context = WhereOptimizerTest.compileStatement(query, binds);
        Scan scan = context.getScan();
        byte[] expectedStartRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId), (byte[][])new byte[][]{PVarchar.INSTANCE.toBytes((Object)entityId1)});
        byte[] expectedStopRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId), (byte[][])new byte[][]{PVarchar.INSTANCE.toBytes((Object)entityId2), QueryConstants.SEPARATOR_BYTE_ARRAY});
        Assert.assertArrayEquals((byte[])expectedStartRow, (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])expectedStopRow, (byte[])scan.getStopRow());
        Filter filter = scan.getFilter();
        Assert.assertTrue((boolean)(filter instanceof SkipScanFilter));
        SkipScanFilter skipScanFilter = (SkipScanFilter)filter;
        List<List> skipScanRanges = Arrays.asList(Arrays.asList(KeyRange.getKeyRange((byte[])ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId), (byte[][])new byte[][]{PVarchar.INSTANCE.toBytes((Object)entityId1)})), KeyRange.getKeyRange((byte[])ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId), (byte[][])new byte[][]{PVarchar.INSTANCE.toBytes((Object)entityId2)}))));
        Assert.assertEquals(skipScanRanges, (Object)skipScanFilter.getSlots());
    }

    @Test
    public void testNotRepresentableBySkipScan() throws SQLException {
        Connection conn = DriverManager.getConnection(WhereOptimizerTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
        String tableName = WhereOptimizerTest.generateUniqueName();
        conn.createStatement().execute("CREATE TABLE " + tableName + "(a INTEGER NOT NULL, b INTEGER NOT NULL, CONSTRAINT pk PRIMARY KEY (a,b))");
        String query = "SELECT * FROM " + tableName + " WHERE (a,b) >= (1,5) and (a,b) < (3,8) and (a = 1 or a = 3) and ((b >= 6 and b < 9) or (b > 3 and b <= 5))";
        StatementContext context = WhereOptimizerTest.compileStatement(query);
        Scan scan = context.getScan();
        byte[] expectedStartRow = ByteUtil.concat((byte[])PInteger.INSTANCE.toBytes((Object)1), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)4)});
        byte[] expectedStopRow = ByteUtil.concat((byte[])PInteger.INSTANCE.toBytes((Object)3), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)9)});
        Assert.assertArrayEquals((byte[])expectedStartRow, (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])expectedStopRow, (byte[])scan.getStopRow());
        Filter filter = scan.getFilter();
        Assert.assertTrue((boolean)(filter instanceof FilterList));
        FilterList filterList = (FilterList)filter;
        Assert.assertTrue((boolean)(filterList.getFilters().get(0) instanceof SkipScanFilter));
        Assert.assertTrue((boolean)(filterList.getFilters().get(1) instanceof BooleanExpressionFilter));
        SkipScanFilter skipScanFilter = (SkipScanFilter)filterList.getFilters().get(0);
        List<List> skipScanRanges = Arrays.asList(Arrays.asList(KeyRange.getKeyRange((byte[])PInteger.INSTANCE.toBytes((Object)1)), KeyRange.getKeyRange((byte[])PInteger.INSTANCE.toBytes((Object)3))), Arrays.asList(KeyRange.getKeyRange((byte[])PInteger.INSTANCE.toBytes((Object)4), (boolean)true, (byte[])PInteger.INSTANCE.toBytes((Object)5), (boolean)true), KeyRange.getKeyRange((byte[])PInteger.INSTANCE.toBytes((Object)6), (boolean)true, (byte[])PInteger.INSTANCE.toBytes((Object)9), (boolean)false)));
        Assert.assertEquals(skipScanRanges, (Object)skipScanFilter.getSlots());
    }

    @Test
    public void testRVCExpressionWithSubsetOfPKCols() throws SQLException {
        String tenantId = "000000000000001";
        String parentId = "000000000000002";
        String entityHistId = "000000000000003";
        String query = "select * from entity_history where (organization_id, parent_id, entity_history_id) >= (?,?,?)";
        List<Object> binds = Arrays.asList(tenantId, parentId, entityHistId);
        StatementContext context = WhereOptimizerTest.compileStatement(query, binds);
        Scan scan = context.getScan();
        Filter filter = scan.getFilter();
        Assert.assertNotNull((Object)filter);
        Assert.assertTrue((boolean)(filter instanceof RowKeyComparisonFilter));
        byte[] expectedStartRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId), (byte[][])new byte[][]{PVarchar.INSTANCE.toBytes((Object)parentId)});
        Assert.assertArrayEquals((byte[])expectedStartRow, (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])HConstants.EMPTY_END_ROW, (byte[])scan.getStopRow());
    }

    @Test
    public void testRVCExpressionWithoutLeadingColOfRowKey() throws SQLException {
        String parentId = "000000000000002";
        String entityHistId = "000000000000003";
        String query = "select * from entity_history where (parent_id, entity_history_id) >= (?,?)";
        List<Object> binds = Arrays.asList(parentId, entityHistId);
        StatementContext context = WhereOptimizerTest.compileStatement(query, binds);
        Scan scan = context.getScan();
        Filter filter = scan.getFilter();
        Assert.assertNotNull((Object)filter);
        Assert.assertTrue((boolean)(filter instanceof RowKeyComparisonFilter));
        Assert.assertArrayEquals((byte[])HConstants.EMPTY_START_ROW, (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])HConstants.EMPTY_END_ROW, (byte[])scan.getStopRow());
    }

    @Test
    public void testRVCExpressionWithNonFirstLeadingColOfRowKey() throws SQLException {
        String old_value = "value";
        String orgId = WhereOptimizerTest.getOrganizationId();
        String query = "select * from entity_history where (old_value, organization_id) >= (?,?)";
        List<Object> binds = Arrays.asList(old_value, orgId);
        StatementContext context = WhereOptimizerTest.compileStatement(query, binds);
        Scan scan = context.getScan();
        Filter filter = scan.getFilter();
        Assert.assertNotNull((Object)filter);
        Assert.assertTrue((boolean)(filter instanceof SingleKeyValueComparisonFilter));
        Assert.assertArrayEquals((byte[])HConstants.EMPTY_START_ROW, (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])HConstants.EMPTY_END_ROW, (byte[])scan.getStopRow());
    }

    @Test
    public void testMultiRVCExpressionsCombinedWithAnd() throws SQLException {
        String lowerTenantId = "000000000000001";
        String lowerParentId = "000000000000002";
        Date lowerCreatedDate = new Date(System.currentTimeMillis());
        String upperTenantId = "000000000000008";
        String upperParentId = "000000000000009";
        String query = "select * from entity_history where (organization_id, parent_id, created_date) >= (?, ?, ?) AND (organization_id, parent_id) <= (?, ?)";
        List<Object> binds = Arrays.asList(lowerTenantId, lowerParentId, lowerCreatedDate, upperTenantId, upperParentId);
        StatementContext context = WhereOptimizerTest.compileStatement(query, binds);
        Scan scan = context.getScan();
        Filter filter = scan.getFilter();
        Assert.assertNull((Object)filter);
        byte[] expectedStartRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)lowerTenantId), (byte[][])new byte[][]{PVarchar.INSTANCE.toBytes((Object)lowerParentId), PDate.INSTANCE.toBytes((Object)lowerCreatedDate)});
        byte[] expectedStopRow = ByteUtil.nextKey((byte[])ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)upperTenantId), (byte[][])new byte[][]{PVarchar.INSTANCE.toBytes((Object)upperParentId)}));
        Assert.assertArrayEquals((byte[])expectedStartRow, (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])expectedStopRow, (byte[])scan.getStopRow());
    }

    @Test
    public void testMultiRVCExpressionsCombinedUsingLiteralExpressions() throws SQLException {
        String lowerTenantId = "000000000000001";
        String lowerParentId = "000000000000002";
        Date lowerCreatedDate = new Date(System.currentTimeMillis());
        String query = "select * from entity_history where (organization_id, parent_id, created_date) >= (?, ?, ?) AND (organization_id, parent_id) <= ('7', '7')";
        List<Object> binds = Arrays.asList(lowerTenantId, lowerParentId, lowerCreatedDate);
        StatementContext context = WhereOptimizerTest.compileStatement(query, binds);
        Scan scan = context.getScan();
        Filter filter = scan.getFilter();
        Assert.assertNull((Object)filter);
        byte[] expectedStartRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)lowerTenantId), (byte[][])new byte[][]{PVarchar.INSTANCE.toBytes((Object)lowerParentId), PDate.INSTANCE.toBytes((Object)lowerCreatedDate)});
        byte[] expectedStopRow = ByteUtil.nextKey((byte[])ByteUtil.concat((byte[])StringUtil.padChar((byte[])PVarchar.INSTANCE.toBytes((Object)"7"), (Integer)15), (byte[][])new byte[][]{StringUtil.padChar((byte[])PVarchar.INSTANCE.toBytes((Object)"7"), (Integer)15)}));
        Assert.assertArrayEquals((byte[])expectedStartRow, (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])expectedStopRow, (byte[])scan.getStopRow());
    }

    @Test
    public void testUseOfFunctionOnLHSInRVC() throws SQLException {
        String tenantId = "000000000000001";
        String subStringTenantId = tenantId.substring(0, 3);
        String parentId = "000000000000002";
        Date createdDate = new Date(System.currentTimeMillis());
        String query = "select * from entity_history where (substr(organization_id, 1, 3), parent_id, created_date) >= (?,?,?)";
        List<Object> binds = Arrays.asList(subStringTenantId, parentId, createdDate);
        StatementContext context = WhereOptimizerTest.compileStatement(query, binds);
        Scan scan = context.getScan();
        Filter filter = scan.getFilter();
        Assert.assertNotNull((Object)filter);
        Assert.assertTrue((boolean)(filter instanceof RowKeyComparisonFilter));
        byte[] expectedStartRow = PVarchar.INSTANCE.toBytes((Object)subStringTenantId);
        Assert.assertArrayEquals((byte[])expectedStartRow, (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])HConstants.EMPTY_END_ROW, (byte[])scan.getStopRow());
    }

    @Test
    public void testUseOfFunctionOnLHSInMiddleOfRVC() throws SQLException {
        String tenantId = "000000000000001";
        String parentId = "000000000000002";
        String subStringParentId = parentId.substring(0, 3);
        Date createdDate = new Date(System.currentTimeMillis());
        String query = "select * from entity_history where (organization_id, substr(parent_id, 1, 3), created_date) >= (?,?,?)";
        List<Object> binds = Arrays.asList(tenantId, subStringParentId, createdDate);
        StatementContext context = WhereOptimizerTest.compileStatement(query, binds);
        Scan scan = context.getScan();
        Filter filter = scan.getFilter();
        Assert.assertNotNull((Object)filter);
        Assert.assertTrue((boolean)(filter instanceof RowKeyComparisonFilter));
        byte[] expectedStartRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId), (byte[][])new byte[][]{PVarchar.INSTANCE.toBytes((Object)subStringParentId)});
        Assert.assertArrayEquals((byte[])expectedStartRow, (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])HConstants.EMPTY_END_ROW, (byte[])scan.getStopRow());
    }

    @Test
    public void testUseOfFunctionOnLHSInMiddleOfRVCForLTE() throws SQLException {
        String tenantId = "000000000000001";
        String parentId = "000000000000002";
        String subStringParentId = parentId.substring(0, 3);
        Date createdDate = new Date(System.currentTimeMillis());
        String query = "select * from entity_history where (organization_id, substr(parent_id, 1, 3), created_date) <= (?,?,?)";
        List<Object> binds = Arrays.asList(tenantId, subStringParentId, createdDate);
        StatementContext context = WhereOptimizerTest.compileStatement(query, binds);
        Scan scan = context.getScan();
        Filter filter = scan.getFilter();
        Assert.assertNotNull((Object)filter);
        Assert.assertTrue((boolean)(filter instanceof RowKeyComparisonFilter));
        byte[] expectedStopRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId), (byte[][])new byte[][]{ByteUtil.nextKey((byte[])PVarchar.INSTANCE.toBytes((Object)subStringParentId))});
        Assert.assertArrayEquals((byte[])HConstants.EMPTY_END_ROW, (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])expectedStopRow, (byte[])scan.getStopRow());
    }

    @Test
    public void testNullAtEndOfRVC() throws SQLException {
        String tenantId = "000000000000001";
        String parentId = "000000000000002";
        Object createdDate = null;
        String query = "select * from entity_history where (organization_id, parent_id, created_date) >= (?,?,?)";
        List<Object> binds = Arrays.asList(tenantId, parentId, createdDate);
        StatementContext context = WhereOptimizerTest.compileStatement(query, binds);
        Scan scan = context.getScan();
        Filter filter = scan.getFilter();
        Assert.assertNull((Object)filter);
        byte[] expectedStartRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId), (byte[][])new byte[][]{PVarchar.INSTANCE.toBytes((Object)parentId)});
        Assert.assertArrayEquals((byte[])expectedStartRow, (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])HConstants.EMPTY_END_ROW, (byte[])scan.getStopRow());
    }

    @Test
    public void testNullInMiddleOfRVC() throws SQLException {
        String tenantId = "000000000000001";
        Object parentId = null;
        Date createdDate = new Date(System.currentTimeMillis());
        String query = "select * from entity_history where (organization_id, parent_id, created_date) >= (?,?,?)";
        List<Object> binds = Arrays.asList(tenantId, parentId, createdDate);
        StatementContext context = WhereOptimizerTest.compileStatement(query, binds);
        Scan scan = context.getScan();
        Filter filter = scan.getFilter();
        Assert.assertNull((Object)filter);
        byte[] expectedStartRow = ByteUtil.concat((byte[])PChar.INSTANCE.toBytes((Object)tenantId), (byte[][])new byte[][]{new byte[15], ByteUtil.previousKey((byte[])PDate.INSTANCE.toBytes((Object)createdDate))});
        Assert.assertArrayEquals((byte[])expectedStartRow, (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])HConstants.EMPTY_END_ROW, (byte[])scan.getStopRow());
    }

    @Test
    public void testNullAtStartOfRVC() throws SQLException {
        Object tenantId = null;
        String parentId = "000000000000002";
        Date createdDate = new Date(System.currentTimeMillis());
        String query = "select * from entity_history where (organization_id, parent_id, created_date) >= (?,?,?)";
        List<Object> binds = Arrays.asList(tenantId, parentId, createdDate);
        StatementContext context = WhereOptimizerTest.compileStatement(query, binds);
        Scan scan = context.getScan();
        Filter filter = scan.getFilter();
        Assert.assertNull((Object)filter);
        byte[] expectedStartRow = ByteUtil.concat((byte[])new byte[15], (byte[][])new byte[][]{ByteUtil.previousKey((byte[])PChar.INSTANCE.toBytes((Object)parentId)), PDate.INSTANCE.toBytes((Object)createdDate)});
        Assert.assertArrayEquals((byte[])expectedStartRow, (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])HConstants.EMPTY_END_ROW, (byte[])scan.getStopRow());
    }

    @Test
    public void testRVCInCombinationWithOtherNonRVC() throws SQLException {
        String firstOrgId = "000000000000001";
        String secondOrgId = "000000000000008";
        String parentId = "000000000000002";
        Date createdDate = new Date(System.currentTimeMillis());
        String query = "select * from entity_history where (organization_id, parent_id, created_date) >= (?,?,?) AND organization_id <= ?";
        List<Object> binds = Arrays.asList(firstOrgId, parentId, createdDate, secondOrgId);
        StatementContext context = WhereOptimizerTest.compileStatement(query, binds);
        Scan scan = context.getScan();
        Filter filter = scan.getFilter();
        Assert.assertNull((Object)filter);
        Assert.assertArrayEquals((byte[])ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)firstOrgId), (byte[][])new byte[][]{PVarchar.INSTANCE.toBytes((Object)parentId), PDate.INSTANCE.toBytes((Object)createdDate)}), (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])ByteUtil.nextKey((byte[])PVarchar.INSTANCE.toBytes((Object)secondOrgId)), (byte[])scan.getStopRow());
    }

    @Test
    public void testGreaterThanEqualTo_NonRVCOnLHSAndRVCOnRHS_WithNonNullBindParams() throws SQLException {
        String tenantId = "000000000000001";
        String parentId = "000000000000008";
        String query = "select * from entity_history where organization_id >= (?,?)";
        List<Object> binds = Arrays.asList(tenantId, parentId);
        StatementContext context = WhereOptimizerTest.compileStatement(query, binds);
        Scan scan = context.getScan();
        Filter filter = scan.getFilter();
        Assert.assertNull((Object)filter);
        Assert.assertArrayEquals((byte[])ByteUtil.nextKey((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId)), (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])HConstants.EMPTY_END_ROW, (byte[])scan.getStopRow());
    }

    @Test
    public void testGreaterThan_NonRVCOnLHSAndRVCOnRHS_WithNonNullBindParams() throws SQLException {
        String tenantId = "000000000000001";
        String parentId = "000000000000008";
        String query = "select * from entity_history where organization_id > (?,?)";
        List<Object> binds = Arrays.asList(tenantId, parentId);
        StatementContext context = WhereOptimizerTest.compileStatement(query, binds);
        Scan scan = context.getScan();
        Filter filter = scan.getFilter();
        Assert.assertNull((Object)filter);
        Assert.assertArrayEquals((byte[])ByteUtil.nextKey((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId)), (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])HConstants.EMPTY_END_ROW, (byte[])scan.getStopRow());
    }

    @Test
    public void testGreaterThan() throws SQLException {
        String tenantId = "000000000000001";
        String query = "select * from entity_history where organization_id >?";
        List<Object> binds = Arrays.asList(tenantId);
        StatementContext context = WhereOptimizerTest.compileStatement(query, binds);
        Scan scan = context.getScan();
        Filter filter = scan.getFilter();
        Assert.assertNull((Object)filter);
        Assert.assertArrayEquals((byte[])ByteUtil.nextKey((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId)), (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])HConstants.EMPTY_END_ROW, (byte[])scan.getStopRow());
    }

    @Test
    public void testLessThanEqualTo_NonRVCOnLHSAndRVCOnRHS_WithNonNullBindParams() throws SQLException {
        String tenantId = "000000000000001";
        String parentId = "000000000000008";
        String query = "select * from entity_history where organization_id <= (?,?)";
        List<Object> binds = Arrays.asList(tenantId, parentId);
        StatementContext context = WhereOptimizerTest.compileStatement(query, binds);
        Scan scan = context.getScan();
        Filter filter = scan.getFilter();
        Assert.assertNull((Object)filter);
        Assert.assertArrayEquals((byte[])HConstants.EMPTY_START_ROW, (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])ByteUtil.nextKey((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId)), (byte[])scan.getStopRow());
    }

    @Test
    public void testLessThan_NonRVCOnLHSAndRVCOnRHS_WithNonNullBindParams() throws SQLException {
        String tenantId = "000000000000001";
        String parentId = "000000000000008";
        String query = "select * from entity_history where organization_id < (?,?)";
        List<Object> binds = Arrays.asList(tenantId, parentId);
        StatementContext context = WhereOptimizerTest.compileStatement(query, binds);
        Scan scan = context.getScan();
        Filter filter = scan.getFilter();
        Assert.assertNull((Object)filter);
        Assert.assertArrayEquals((byte[])HConstants.EMPTY_START_ROW, (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])ByteUtil.nextKey((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId)), (byte[])scan.getStopRow());
    }

    @Test
    public void testQueryMoreRVC() throws SQLException {
        String ddl = "CREATE TABLE rvcTestIdx  (\n    pk1 VARCHAR NOT NULL,\n    v1 VARCHAR,\n    pk2 DECIMAL NOT NULL,\n    CONSTRAINT PK PRIMARY KEY \n    (\n        pk1,\n        v1,\n        pk2\n    )\n) MULTI_TENANT=true,IMMUTABLE_ROWS=true";
        Connection conn = DriverManager.getConnection(WhereOptimizerTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
        conn.createStatement().execute(ddl);
        String query = "SELECT pk1, pk2, v1 FROM rvcTestIdx WHERE pk1 = 'a' AND\n(pk1, pk2) > ('a', 1)\nORDER BY PK1, PK2\nLIMIT 2";
        StatementContext context = WhereOptimizerTest.compileStatement(query, 2);
        Scan scan = context.getScan();
        Filter filter = scan.getFilter();
        Assert.assertNotNull((Object)filter);
        byte[] startRow = Bytes.toBytes((String)"a");
        byte[] stopRow = ByteUtil.concat((byte[])startRow, (byte[][])new byte[][]{ByteUtil.nextKey((byte[])QueryConstants.SEPARATOR_BYTE_ARRAY)});
        Assert.assertArrayEquals((byte[])startRow, (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])stopRow, (byte[])scan.getStopRow());
    }

    @Test
    public void testCombiningRVCUsingOr() throws SQLException {
        String firstTenantId = "000000000000001";
        String secondTenantId = "000000000000005";
        String firstParentId = "000000000000011";
        String secondParentId = "000000000000015";
        String query = "select * from entity_history where (organization_id, parent_id) >= (?,?) OR (organization_id, parent_id) <= (?, ?)";
        List<Object> binds = Arrays.asList(firstTenantId, firstParentId, secondTenantId, secondParentId);
        StatementContext context = WhereOptimizerTest.compileStatement(query, binds);
        Scan scan = context.getScan();
        Filter filter = scan.getFilter();
        Assert.assertNull((Object)filter);
        Assert.assertArrayEquals((byte[])HConstants.EMPTY_START_ROW, (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])HConstants.EMPTY_END_ROW, (byte[])scan.getStopRow());
    }

    @Test
    public void testCombiningRVCUsingOr2() throws SQLException {
        String firstTenantId = "000000000000001";
        String secondTenantId = "000000000000005";
        String firstParentId = "000000000000011";
        String secondParentId = "000000000000015";
        String query = "select * from entity_history where (organization_id, parent_id) >= (?,?) OR (organization_id, parent_id) >= (?, ?)";
        List<Object> binds = Arrays.asList(firstTenantId, firstParentId, secondTenantId, secondParentId);
        StatementContext context = WhereOptimizerTest.compileStatement(query, binds);
        Scan scan = context.getScan();
        Filter filter = scan.getFilter();
        Assert.assertNull((Object)filter);
        Assert.assertArrayEquals((byte[])ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)firstTenantId), (byte[][])new byte[][]{PVarchar.INSTANCE.toBytes((Object)firstParentId)}), (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])HConstants.EMPTY_END_ROW, (byte[])scan.getStopRow());
    }

    @Test
    public void testCombiningRVCWithNonRVCUsingOr() throws SQLException {
        String firstTenantId = "000000000000001";
        String secondTenantId = "000000000000005";
        String firstParentId = "000000000000011";
        String query = "select * from entity_history where (organization_id, parent_id) >= (?,?) OR organization_id  >= ?";
        List<Object> binds = Arrays.asList(firstTenantId, firstParentId, secondTenantId);
        StatementContext context = WhereOptimizerTest.compileStatement(query, binds);
        Scan scan = context.getScan();
        Filter filter = scan.getFilter();
        Assert.assertNull((Object)filter);
        Assert.assertArrayEquals((byte[])ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)firstTenantId), (byte[][])new byte[][]{PVarchar.INSTANCE.toBytes((Object)firstParentId)}), (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])HConstants.EMPTY_END_ROW, (byte[])scan.getStopRow());
    }

    @Test
    public void testCombiningRVCWithNonRVCUsingOr2() throws SQLException {
        String firstTenantId = "000000000000001";
        String secondTenantId = "000000000000005";
        String firstParentId = "000000000000011";
        String query = "select * from entity_history where (organization_id, parent_id) >= (?,?) OR organization_id  <= ?";
        List<Object> binds = Arrays.asList(firstTenantId, firstParentId, secondTenantId);
        StatementContext context = WhereOptimizerTest.compileStatement(query, binds);
        Scan scan = context.getScan();
        Filter filter = scan.getFilter();
        Assert.assertNull((Object)filter);
        Assert.assertArrayEquals((byte[])HConstants.EMPTY_START_ROW, (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])HConstants.EMPTY_END_ROW, (byte[])scan.getStopRow());
    }

    @Test
    public void testCombiningRVCWithNonRVCUsingOr3() throws SQLException {
        String firstTenantId = "000000000000005";
        String secondTenantId = "000000000000001";
        String firstParentId = "000000000000011";
        String query = "select * from entity_history where (organization_id, parent_id) >= (?,?) OR organization_id  <= ?";
        List<Object> binds = Arrays.asList(firstTenantId, firstParentId, secondTenantId);
        StatementContext context = WhereOptimizerTest.compileStatement(query, binds);
        Scan scan = context.getScan();
        Filter filter = scan.getFilter();
        Assert.assertTrue((boolean)(filter instanceof SkipScanFilter));
        Assert.assertArrayEquals((byte[])HConstants.EMPTY_START_ROW, (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])HConstants.EMPTY_END_ROW, (byte[])scan.getStopRow());
        SkipScanFilter skipScanFilter = (SkipScanFilter)filter;
        List keyRanges = skipScanFilter.getSlots();
        Assert.assertEquals((long)1L, (long)keyRanges.size());
        Assert.assertEquals((long)2L, (long)((List)keyRanges.get(0)).size());
        KeyRange range1 = (KeyRange)((List)keyRanges.get(0)).get(0);
        KeyRange range2 = (KeyRange)((List)keyRanges.get(0)).get(1);
        Assert.assertEquals((Object)KeyRange.getKeyRange((byte[])KeyRange.UNBOUND, (boolean)false, (byte[])Bytes.toBytes((String)secondTenantId), (boolean)true), (Object)range1);
        Assert.assertEquals((Object)KeyRange.getKeyRange((byte[])ByteUtil.concat((byte[])Bytes.toBytes((String)firstTenantId), (byte[][])new byte[][]{Bytes.toBytes((String)firstParentId)}), (boolean)true, (byte[])KeyRange.UNBOUND, (boolean)true), (Object)range2);
    }

    @Test
    public void testUsingRVCNonFullyQualifiedInClause() throws Exception {
        String firstOrgId = "000000000000001";
        String secondOrgId = "000000000000009";
        String firstParentId = "000000000000011";
        String secondParentId = "000000000000021";
        String query = "select * from entity_history where (organization_id, parent_id) IN ((?, ?), (?, ?))";
        List<Object> binds = Arrays.asList(firstOrgId, firstParentId, secondOrgId, secondParentId);
        StatementContext context = WhereOptimizerTest.compileStatement(query, binds);
        Scan scan = context.getScan();
        Filter filter = scan.getFilter();
        Assert.assertTrue((boolean)(filter instanceof SkipScanFilter));
        Assert.assertArrayEquals((byte[])ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)firstOrgId), (byte[][])new byte[][]{PVarchar.INSTANCE.toBytes((Object)firstParentId)}), (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])ByteUtil.nextKey((byte[])ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)secondOrgId), (byte[][])new byte[][]{PVarchar.INSTANCE.toBytes((Object)secondParentId)})), (byte[])scan.getStopRow());
    }

    @Test
    public void testUsingRVCFullyQualifiedInClause() throws Exception {
        String firstOrgId = "000000000000001";
        String secondOrgId = "000000000000009";
        String firstParentId = "000000000000011";
        String secondParentId = "000000000000021";
        String query = "select * from atable where (organization_id, entity_id) IN ((?, ?), (?, ?))";
        List<Object> binds = Arrays.asList(firstOrgId, firstParentId, secondOrgId, secondParentId);
        StatementContext context = WhereOptimizerTest.compileStatement(query, binds);
        Scan scan = context.getScan();
        Filter filter = scan.getFilter();
        Assert.assertTrue((boolean)(filter instanceof SkipScanFilter));
        List<List<KeyRange>> skipScanRanges = Collections.singletonList(Arrays.asList(KeyRange.getKeyRange((byte[])ByteUtil.concat((byte[])PChar.INSTANCE.toBytes((Object)firstOrgId), (byte[][])new byte[][]{PChar.INSTANCE.toBytes((Object)firstParentId)})), KeyRange.getKeyRange((byte[])ByteUtil.concat((byte[])PChar.INSTANCE.toBytes((Object)secondOrgId), (byte[][])new byte[][]{PChar.INSTANCE.toBytes((Object)secondParentId)}))));
        Assert.assertEquals(skipScanRanges, (Object)context.getScanRanges().getRanges());
        Assert.assertArrayEquals((byte[])ByteUtil.concat((byte[])PChar.INSTANCE.toBytes((Object)firstOrgId), (byte[][])new byte[][]{PChar.INSTANCE.toBytes((Object)firstParentId)}), (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])ByteUtil.concat((byte[])PChar.INSTANCE.toBytes((Object)secondOrgId), (byte[][])new byte[][]{PChar.INSTANCE.toBytes((Object)secondParentId), QueryConstants.SEPARATOR_BYTE_ARRAY}), (byte[])scan.getStopRow());
    }

    @Test
    public void testFullyQualifiedRVCWithTenantSpecificViewAndConnection() throws Exception {
        String baseTableDDL = "CREATE TABLE BASE_MULTI_TENANT_TABLE(\n   tenant_id VARCHAR(5) NOT NULL,\n  userid INTEGER NOT NULL,\n  username VARCHAR NOT NULL,\n  col VARCHAR\n   CONSTRAINT pk PRIMARY KEY (tenant_id, userid, username)) MULTI_TENANT=true";
        Connection conn = DriverManager.getConnection(WhereOptimizerTest.getUrl());
        conn.createStatement().execute(baseTableDDL);
        conn.close();
        String tenantId = "tenantId";
        String tenantViewDDL = "CREATE VIEW TENANT_VIEW AS SELECT * FROM BASE_MULTI_TENANT_TABLE";
        Properties tenantProps = new Properties();
        tenantProps.put("TenantId", tenantId);
        conn = DriverManager.getConnection(WhereOptimizerTest.getUrl(), tenantProps);
        conn.createStatement().execute(tenantViewDDL);
        String query = "SELECT * FROM TENANT_VIEW WHERE (userid, username) IN ((?, ?), (?, ?))";
        List<Object> binds = Arrays.asList(1, "uname1", 2, "uname2");
        StatementContext context = WhereOptimizerTest.compileStatementTenantSpecific(tenantId, query, binds);
        Scan scan = context.getScan();
        Filter filter = scan.getFilter();
        Assert.assertEquals(SkipScanFilter.class, filter.getClass());
    }

    @Test
    public void testFullyQualifiedRVCWithNonTenantSpecificView() throws Exception {
        String baseTableDDL = "CREATE TABLE BASE_TABLE(\n   tenant_id VARCHAR(5) NOT NULL,\n  userid INTEGER NOT NULL,\n  username VARCHAR NOT NULL,\n  col VARCHAR\n   CONSTRAINT pk PRIMARY KEY (tenant_id, userid, username))";
        Connection conn = DriverManager.getConnection(WhereOptimizerTest.getUrl());
        conn.createStatement().execute(baseTableDDL);
        conn.close();
        String viewDDL = "CREATE VIEW VIEWXYZ AS SELECT * FROM BASE_TABLE";
        conn = DriverManager.getConnection(WhereOptimizerTest.getUrl());
        conn.createStatement().execute(viewDDL);
        String query = "SELECT * FROM VIEWXYZ WHERE (tenant_id, userid, username) IN ((?, ?, ?), (?, ?, ?))";
        List<Object> binds = Arrays.asList("tenantId", 1, "uname1", "tenantId", 2, "uname2");
        StatementContext context = WhereOptimizerTest.compileStatement(query, binds);
        Scan scan = context.getScan();
        Filter filter = scan.getFilter();
        Assert.assertEquals(SkipScanFilter.class, filter.getClass());
    }

    @Test
    public void testRVCWithCompareOpsForRowKeyColumnValuesSmallerThanSchema() throws SQLException {
        String orgId = "0000005";
        String entityId = "011";
        String orgId2 = "000005";
        String entityId2 = "11";
        String query = "select * from atable where (organization_id, entity_id) >= (?,?)";
        List<Object> binds = Arrays.asList(orgId, entityId);
        StatementContext context = WhereOptimizerTest.compileStatement(query, binds);
        Scan scan = context.getScan();
        Filter filter = scan.getFilter();
        Assert.assertNull((Object)filter);
        Assert.assertArrayEquals((byte[])ByteUtil.concat((byte[])StringUtil.padChar((byte[])PChar.INSTANCE.toBytes((Object)orgId), (Integer)15), (byte[][])new byte[][]{StringUtil.padChar((byte[])PChar.INSTANCE.toBytes((Object)entityId), (Integer)15)}), (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])HConstants.EMPTY_END_ROW, (byte[])scan.getStopRow());
        query = "select * from atable where (organization_id, entity_id) > (?,?)";
        binds = Arrays.asList(orgId, entityId);
        context = WhereOptimizerTest.compileStatement(query, binds);
        scan = context.getScan();
        filter = scan.getFilter();
        Assert.assertNull((Object)filter);
        Assert.assertArrayEquals((byte[])ByteUtil.nextKey((byte[])ByteUtil.concat((byte[])StringUtil.padChar((byte[])PChar.INSTANCE.toBytes((Object)orgId), (Integer)15), (byte[][])new byte[][]{StringUtil.padChar((byte[])PChar.INSTANCE.toBytes((Object)entityId), (Integer)15)})), (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])HConstants.EMPTY_END_ROW, (byte[])scan.getStopRow());
        query = "select * from atable where (organization_id, entity_id) <= (?,?)";
        binds = Arrays.asList(orgId, entityId);
        context = WhereOptimizerTest.compileStatement(query, binds);
        scan = context.getScan();
        filter = scan.getFilter();
        Assert.assertNull((Object)filter);
        Assert.assertArrayEquals((byte[])HConstants.EMPTY_END_ROW, (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])ByteUtil.nextKey((byte[])ByteUtil.concat((byte[])StringUtil.padChar((byte[])PChar.INSTANCE.toBytes((Object)orgId), (Integer)15), (byte[][])new byte[][]{StringUtil.padChar((byte[])PChar.INSTANCE.toBytes((Object)entityId), (Integer)15)})), (byte[])scan.getStopRow());
        query = "select * from atable where (organization_id, entity_id) < (?,?)";
        binds = Arrays.asList(orgId, entityId);
        context = WhereOptimizerTest.compileStatement(query, binds);
        scan = context.getScan();
        filter = scan.getFilter();
        Assert.assertNull((Object)filter);
        Assert.assertArrayEquals((byte[])HConstants.EMPTY_END_ROW, (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])ByteUtil.concat((byte[])StringUtil.padChar((byte[])PChar.INSTANCE.toBytes((Object)orgId), (Integer)15), (byte[][])new byte[][]{StringUtil.padChar((byte[])PChar.INSTANCE.toBytes((Object)entityId), (Integer)15)}), (byte[])scan.getStopRow());
        query = "select * from atable where (organization_id, entity_id) IN ((?,?),(?,?))";
        binds = Arrays.asList(orgId, entityId, orgId2, entityId2);
        context = WhereOptimizerTest.compileStatement(query, binds);
        scan = context.getScan();
        filter = scan.getFilter();
        Assert.assertTrue((boolean)(filter instanceof SkipScanFilter));
        ScanRanges scanRanges = context.getScanRanges();
        Assert.assertEquals((long)2L, (long)scanRanges.getPointLookupCount());
        Iterator iterator = scanRanges.getPointLookupKeyIterator();
        KeyRange k1 = (KeyRange)iterator.next();
        Assert.assertTrue((boolean)k1.isSingleKey());
        Assert.assertArrayEquals((byte[])ByteUtil.concat((byte[])StringUtil.padChar((byte[])PChar.INSTANCE.toBytes((Object)orgId), (Integer)15), (byte[][])new byte[][]{StringUtil.padChar((byte[])PChar.INSTANCE.toBytes((Object)entityId), (Integer)15)}), (byte[])k1.getLowerRange());
        KeyRange k2 = (KeyRange)iterator.next();
        Assert.assertTrue((boolean)k2.isSingleKey());
        Assert.assertArrayEquals((byte[])ByteUtil.concat((byte[])StringUtil.padChar((byte[])PChar.INSTANCE.toBytes((Object)orgId2), (Integer)15), (byte[][])new byte[][]{StringUtil.padChar((byte[])PChar.INSTANCE.toBytes((Object)entityId2), (Integer)15)}), (byte[])k2.getLowerRange());
    }

    @Test
    public void testRVCInView() throws Exception {
        Connection conn = DriverManager.getConnection(WhereOptimizerTest.getUrl());
        conn.createStatement().execute("CREATE TABLE TEST_TABLE.TEST1 (\nPK1 CHAR(3) NOT NULL, \nPK2 CHAR(3) NOT NULL,\nDATA1 CHAR(10)\nCONSTRAINT PK PRIMARY KEY (PK1, PK2))");
        conn.createStatement().execute("CREATE VIEW TEST_TABLE.FOO AS SELECT * FROM TEST_TABLE.TEST1 WHERE PK1 = 'FOO'");
        String query = "SELECT * FROM TEST_TABLE.FOO WHERE PK2 < '004' AND (PK1,PK2) > ('FOO','002') LIMIT 2";
        Scan scan = WhereOptimizerTest.compileStatement(query, Collections.emptyList(), 2).getScan();
        byte[] startRow = ByteUtil.nextKey((byte[])ByteUtil.concat((byte[])PChar.INSTANCE.toBytes((Object)"FOO"), (byte[][])new byte[][]{PVarchar.INSTANCE.toBytes((Object)"002")}));
        Assert.assertArrayEquals((byte[])startRow, (byte[])scan.getStartRow());
        byte[] stopRow = ByteUtil.concat((byte[])PChar.INSTANCE.toBytes((Object)"FOO"), (byte[][])new byte[][]{PChar.INSTANCE.toBytes((Object)"004")});
        Assert.assertArrayEquals((byte[])stopRow, (byte[])scan.getStopRow());
    }

    @Test
    public void testScanRangeForPointLookup() throws SQLException {
        String tenantId = "000000000000001";
        String entityId = "002333333333333";
        String query = String.format("select * from atable where organization_id='%s' and entity_id='%s'", tenantId, entityId);
        try (Connection conn = DriverManager.getConnection(WhereOptimizerTest.getUrl());){
            QueryPlan optimizedPlan = TestUtil.getOptimizeQueryPlan(conn, query);
            byte[] startRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId), (byte[][])new byte[][]{PVarchar.INSTANCE.toBytes((Object)entityId)});
            byte[] stopRow = ByteUtil.nextKey((byte[])startRow);
            WhereOptimizerTest.validateScanRangesForPointLookup(optimizedPlan, startRow, stopRow);
        }
    }

    @Test
    public void testScanRangeForPointLookupRVC() throws SQLException {
        String tenantId = "000000000000001";
        String entityId = "002333333333333";
        String query = String.format("select * from atable where (organization_id, entity_id) IN (('%s','%s'))", tenantId, entityId);
        try (Connection conn = DriverManager.getConnection(WhereOptimizerTest.getUrl());){
            QueryPlan optimizedPlan = TestUtil.getOptimizeQueryPlan(conn, query);
            byte[] startRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId), (byte[][])new byte[][]{PVarchar.INSTANCE.toBytes((Object)entityId)});
            byte[] stopRow = ByteUtil.nextKey((byte[])startRow);
            WhereOptimizerTest.validateScanRangesForPointLookup(optimizedPlan, startRow, stopRow);
        }
    }

    @Test
    public void testScanRangeForPointLookupWithLimit() throws SQLException {
        String tenantId = "000000000000001";
        String entityId = "002333333333333";
        String query = String.format("select * from atable where organization_id='%s' and entity_id='%s' LIMIT 1", tenantId, entityId);
        try (Connection conn = DriverManager.getConnection(WhereOptimizerTest.getUrl());){
            QueryPlan optimizedPlan = TestUtil.getOptimizeQueryPlan(conn, query);
            byte[] startRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId), (byte[][])new byte[][]{PVarchar.INSTANCE.toBytes((Object)entityId)});
            byte[] stopRow = ByteUtil.nextKey((byte[])startRow);
            WhereOptimizerTest.validateScanRangesForPointLookup(optimizedPlan, startRow, stopRow);
        }
    }

    @Test
    public void testScanRangeForPointLookupAggregate() throws SQLException {
        String tenantId = "000000000000001";
        String entityId = "002333333333333";
        String query = String.format("select count(*) from atable where organization_id='%s' and entity_id='%s'", tenantId, entityId);
        try (Connection conn = DriverManager.getConnection(WhereOptimizerTest.getUrl());){
            QueryPlan optimizedPlan = TestUtil.getOptimizeQueryPlan(conn, query);
            byte[] startRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId), (byte[][])new byte[][]{PVarchar.INSTANCE.toBytes((Object)entityId)});
            byte[] stopRow = ByteUtil.nextKey((byte[])startRow);
            WhereOptimizerTest.validateScanRangesForPointLookup(optimizedPlan, startRow, stopRow);
        }
    }

    private static void validateScanRangesForPointLookup(QueryPlan optimizedPlan, byte[] startRow, byte[] stopRow) {
        StatementContext context = optimizedPlan.getContext();
        ScanRanges scanRanges = context.getScanRanges();
        Assert.assertTrue((boolean)scanRanges.isPointLookup());
        Assert.assertEquals((long)1L, (long)scanRanges.getPointLookupCount());
        Scan scanFromContext = context.getScan();
        Assert.assertArrayEquals((byte[])startRow, (byte[])scanFromContext.getStartRow());
        Assert.assertTrue((boolean)scanFromContext.includeStartRow());
        Assert.assertArrayEquals((byte[])stopRow, (byte[])scanFromContext.getStopRow());
        Assert.assertFalse((boolean)scanFromContext.includeStopRow());
        List scans = optimizedPlan.getScans();
        Assert.assertEquals((long)1L, (long)scans.size());
        Assert.assertEquals((long)1L, (long)((List)scans.get(0)).size());
        Scan scanFromIterator = (Scan)((List)scans.get(0)).get(0);
        if (optimizedPlan.getLimit() == null && !optimizedPlan.getStatement().isAggregate()) {
            Assert.assertTrue((boolean)scanFromIterator.isGetScan());
            Assert.assertTrue((boolean)scanFromIterator.includeStartRow());
            Assert.assertTrue((boolean)scanFromIterator.includeStopRow());
        } else {
            Assert.assertArrayEquals((byte[])startRow, (byte[])scanFromIterator.getStartRow());
            Assert.assertTrue((boolean)scanFromIterator.includeStartRow());
            Assert.assertArrayEquals((byte[])stopRow, (byte[])scanFromIterator.getStopRow());
            Assert.assertFalse((boolean)scanFromIterator.includeStopRow());
        }
    }

    private static StatementContext compileStatementTenantSpecific(String tenantId, String query, List<Object> binds) throws Exception {
        PhoenixConnection pconn = WhereOptimizerTest.getTenantSpecificConnection("tenantId").unwrap(PhoenixConnection.class);
        PhoenixPreparedStatement pstmt = new PhoenixPreparedStatement(pconn, query);
        TestUtil.bindParams(pstmt, binds);
        QueryPlan plan = pstmt.compileQuery();
        return plan.getContext();
    }

    private static Connection getTenantSpecificConnection(String tenantId) throws Exception {
        Properties tenantProps = new Properties();
        tenantProps.put("TenantId", tenantId);
        Connection conn = DriverManager.getConnection(WhereOptimizerTest.getUrl(), tenantProps);
        return conn;
    }

    @Test
    public void testTrailingIsNull() throws Exception {
        String baseTableDDL = "CREATE TABLE t(\n   a VARCHAR,\n  b VARCHAR,\n  CONSTRAINT pk PRIMARY KEY (a, b))";
        Connection conn = DriverManager.getConnection(WhereOptimizerTest.getUrl());
        conn.createStatement().execute(baseTableDDL);
        conn.close();
        String query = "SELECT * FROM t WHERE a = 'a' and b is null";
        StatementContext context = WhereOptimizerTest.compileStatement(query, Collections.emptyList());
        Scan scan = context.getScan();
        Filter filter = scan.getFilter();
        Assert.assertNull((Object)filter);
        Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"a"), (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])ByteUtil.concat((byte[])Bytes.toBytes((String)"a"), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, QueryConstants.SEPARATOR_BYTE_ARRAY}), (byte[])scan.getStopRow());
    }

    @Test
    public void testTrailingIsNullWithOr() throws Exception {
        String baseTableDDL = "CREATE TABLE t(\n   a VARCHAR,\n  b VARCHAR,\n  CONSTRAINT pk PRIMARY KEY (a, b))";
        Connection conn = DriverManager.getConnection(WhereOptimizerTest.getUrl());
        conn.createStatement().execute(baseTableDDL);
        conn.close();
        String query = "SELECT * FROM t WHERE a = 'a' and (b is null or b = 'b')";
        StatementContext context = WhereOptimizerTest.compileStatement(query, Collections.emptyList());
        Scan scan = context.getScan();
        Filter filter = scan.getFilter();
        Assert.assertTrue((boolean)(filter instanceof SkipScanFilter));
        SkipScanFilter skipScan = (SkipScanFilter)filter;
        List slots = skipScan.getSlots();
        Assert.assertEquals((long)2L, (long)slots.size());
        Assert.assertEquals((long)1L, (long)((List)slots.get(0)).size());
        Assert.assertEquals((long)2L, (long)((List)slots.get(1)).size());
        Assert.assertEquals((Object)KeyRange.getKeyRange((byte[])Bytes.toBytes((String)"a")), ((List)slots.get(0)).get(0));
        Assert.assertTrue((KeyRange.IS_NULL_RANGE == ((List)slots.get(1)).get(0) ? 1 : 0) != 0);
        Assert.assertEquals((Object)KeyRange.getKeyRange((byte[])Bytes.toBytes((String)"b")), ((List)slots.get(1)).get(1));
        Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"a"), (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])ByteUtil.concat((byte[])Bytes.toBytes((String)"a"), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, Bytes.toBytes((String)"b"), QueryConstants.SEPARATOR_BYTE_ARRAY}), (byte[])scan.getStopRow());
    }

    @Test
    public void testAndWithRVC() throws Exception {
        Connection conn = DriverManager.getConnection(WhereOptimizerTest.getUrl());
        String ddl = "create table t (a integer not null, b integer not null, c integer constraint pk primary key (a,b))";
        conn.createStatement().execute(ddl);
        String query = "select c from t where a in (1,2) and b = 3 and (a,b) in ( (1,2) , (1,3))";
        StatementContext context = WhereOptimizerTest.compileStatement(query, Collections.emptyList());
        Assert.assertArrayEquals((byte[])ByteUtil.concat((byte[])PInteger.INSTANCE.toBytes((Object)1), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)3)}), (byte[])context.getScan().getStartRow());
        Assert.assertArrayEquals((byte[])ByteUtil.concat((byte[])PInteger.INSTANCE.toBytes((Object)1), (byte[][])new byte[][]{ByteUtil.nextKey((byte[])PInteger.INSTANCE.toBytes((Object)3))}), (byte[])context.getScan().getStopRow());
        query = "select c from t where (a,b) in ( (1,2) , (1,3) ) and b = 4";
        context = WhereOptimizerTest.compileStatement(query, Collections.emptyList());
        TestUtil.assertDegenerate(context.getScan());
        query = "select c from t where a = 1 and b = 3 and (a,b) in ( (1,2) , (1,3))";
        context = WhereOptimizerTest.compileStatement(query, Collections.emptyList());
        Assert.assertArrayEquals((byte[])ByteUtil.concat((byte[])PInteger.INSTANCE.toBytes((Object)1), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)3)}), (byte[])context.getScan().getStartRow());
        Assert.assertArrayEquals((byte[])ByteUtil.concat((byte[])PInteger.INSTANCE.toBytes((Object)1), (byte[][])new byte[][]{ByteUtil.nextKey((byte[])PInteger.INSTANCE.toBytes((Object)3))}), (byte[])context.getScan().getStopRow());
        ddl = "create table t1 (d varchar, e char(3) not null, a integer not null, b integer not null, c integer constraint pk primary key (d, e, a,b))";
        conn.createStatement().execute(ddl);
        query = "select c from t1 where d = 'a' and e = 'foo' and a in (1,2) and b = 3 and (a,b) in ( (1,2) , (1,3))";
        context = WhereOptimizerTest.compileStatement(query, Collections.emptyList());
        Scan scan = context.getScan();
        Assert.assertArrayEquals((byte[])ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)"a"), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, PChar.INSTANCE.toBytes((Object)"foo"), PInteger.INSTANCE.toBytes((Object)1), PInteger.INSTANCE.toBytes((Object)3)}), (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)"a"), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, PChar.INSTANCE.toBytes((Object)"foo"), PInteger.INSTANCE.toBytes((Object)1), ByteUtil.nextKey((byte[])PInteger.INSTANCE.toBytes((Object)3))}), (byte[])scan.getStopRow());
        conn.close();
    }

    @Test
    public void testNoAggregatorForOrderBy() throws SQLException {
        Connection conn = DriverManager.getConnection(WhereOptimizerTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
        conn.createStatement().execute("create table test (pk1 integer not null, pk2 integer not null, constraint pk primary key (pk1,pk2))");
        StatementContext context = WhereOptimizerTest.compileStatement("select count(distinct pk1) from test order by count(distinct pk2)");
        Assert.assertEquals((long)1L, (long)context.getAggregationManager().getAggregators().getAggregatorCount());
        context = WhereOptimizerTest.compileStatement("select sum(pk1) from test order by count(distinct pk2)");
        Assert.assertEquals((long)1L, (long)context.getAggregationManager().getAggregators().getAggregatorCount());
        context = WhereOptimizerTest.compileStatement("select min(pk1) from test order by count(distinct pk2)");
        Assert.assertEquals((long)1L, (long)context.getAggregationManager().getAggregators().getAggregatorCount());
        context = WhereOptimizerTest.compileStatement("select max(pk1) from test order by count(distinct pk2)");
        Assert.assertEquals((long)1L, (long)context.getAggregationManager().getAggregators().getAggregatorCount());
        context = WhereOptimizerTest.compileStatement("select avg(pk1) from test order by count(distinct pk2)");
        Assert.assertEquals((long)2L, (long)context.getAggregationManager().getAggregators().getAggregatorCount());
    }

    @Test
    public void testPartialRVCWithLeadingPKEq() throws SQLException {
        String tenantId = "o1";
        Connection conn = DriverManager.getConnection(WhereOptimizerTest.getUrl());
        conn.createStatement().execute("CREATE TABLE COMMUNITIES.TEST (\n    ORGANIZATION_ID CHAR(2) NOT NULL,\n    SCORE DOUBLE NOT NULL,\n    ENTITY_ID CHAR(2) NOT NULL\n    CONSTRAINT PAGE_SNAPSHOT_PK PRIMARY KEY (\n        ORGANIZATION_ID,\n        SCORE,\n        ENTITY_ID\n    )\n) VERSIONS=1, MULTI_TENANT=TRUE");
        String query = "SELECT entity_id, score\nFROM communities.test\nWHERE organization_id = '" + tenantId + "'\nAND (score, entity_id) > (2.0, '04')\nORDER BY score, entity_id";
        Scan scan = WhereOptimizerTest.compileStatement(query).getScan();
        Assert.assertNull((Object)scan.getFilter());
        byte[] startRow = ByteUtil.nextKey((byte[])ByteUtil.concat((byte[])PChar.INSTANCE.toBytes((Object)tenantId), (byte[][])new byte[][]{PDouble.INSTANCE.toBytes((Object)2.0), PChar.INSTANCE.toBytes((Object)"04")}));
        Assert.assertArrayEquals((byte[])startRow, (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])ByteUtil.nextKey((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId)), (byte[])scan.getStopRow());
    }

    @Test
    public void testPartialRVCWithLeadingPKEqDesc() throws SQLException {
        String tenantId = "o1";
        Connection conn = DriverManager.getConnection(WhereOptimizerTest.getUrl());
        conn.createStatement().execute("CREATE TABLE COMMUNITIES.TEST (\n    ORGANIZATION_ID CHAR(2) NOT NULL,\n    SCORE DOUBLE NOT NULL,\n    ENTITY_ID CHAR(2) NOT NULL\n    CONSTRAINT PAGE_SNAPSHOT_PK PRIMARY KEY (\n        ORGANIZATION_ID,\n        SCORE DESC,\n        ENTITY_ID DESC\n    )\n) VERSIONS=1, MULTI_TENANT=TRUE");
        String query = "SELECT entity_id, score\nFROM communities.test\nWHERE organization_id = '" + tenantId + "'\nAND (score, entity_id) < (2.0, '04')\nORDER BY score DESC, entity_id DESC";
        Scan scan = WhereOptimizerTest.compileStatement(query).getScan();
        Assert.assertNull((Object)scan.getFilter());
        byte[] startRow = ByteUtil.nextKey((byte[])ByteUtil.concat((byte[])PChar.INSTANCE.toBytes((Object)tenantId), (byte[][])new byte[][]{PDouble.INSTANCE.toBytes((Object)2.0, SortOrder.DESC), PChar.INSTANCE.toBytes((Object)"04", SortOrder.DESC)}));
        Assert.assertArrayEquals((byte[])startRow, (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])ByteUtil.nextKey((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId)), (byte[])scan.getStopRow());
    }

    @Test
    public void testFullRVCWithLeadingPKEqDesc() throws SQLException {
        String tenantId = "o1";
        Connection conn = DriverManager.getConnection(WhereOptimizerTest.getUrl());
        conn.createStatement().execute("CREATE TABLE COMMUNITIES.TEST (\n    ORGANIZATION_ID CHAR(2) NOT NULL,\n    SCORE DOUBLE NOT NULL,\n    ENTITY_ID CHAR(2) NOT NULL\n    CONSTRAINT PAGE_SNAPSHOT_PK PRIMARY KEY (\n        ORGANIZATION_ID,\n        SCORE DESC,\n        ENTITY_ID DESC\n    )\n) VERSIONS=1, MULTI_TENANT=TRUE");
        String query = "SELECT entity_id, score\nFROM communities.test\nWHERE organization_id = '" + tenantId + "'\nAND (organization_id, score, entity_id) < ('" + tenantId + "',2.0, '04')\nORDER BY score DESC, entity_id DESC";
        Scan scan = WhereOptimizerTest.compileStatement(query).getScan();
        Assert.assertNull((Object)scan.getFilter());
        byte[] startRow = ByteUtil.concat((byte[])PChar.INSTANCE.toBytes((Object)tenantId), (byte[][])new byte[][]{PDouble.INSTANCE.toBytes((Object)2.0, SortOrder.DESC), ByteUtil.nextKey((byte[])PChar.INSTANCE.toBytes((Object)"04", SortOrder.DESC))});
        Assert.assertArrayEquals((byte[])startRow, (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])ByteUtil.nextKey((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId)), (byte[])scan.getStopRow());
    }

    @Test
    public void testTrimTrailing() throws Exception {
        try (Connection conn = DriverManager.getConnection(WhereOptimizerTest.getUrl());){
            String sql = "CREATE TABLE T(A CHAR(1) NOT NULL,B CHAR(1) NOT NULL,C CHAR(1) NOT NULL,D CHAR(1) NOT NULL,DATA INTEGER, CONSTRAINT TEST_PK PRIMARY KEY (A,B,C,D))";
            conn.createStatement().execute(sql);
            sql = "select * from T where (A,B,C) >= ('A','A','A') and (A,B,C) < ('D','D','D') and (B,C) > ('E','E')";
            QueryPlan queryPlan = TestUtil.getOptimizeQueryPlan(conn, sql);
            Scan scan = queryPlan.getContext().getScan();
            Assert.assertTrue((boolean)(scan.getFilter() instanceof SkipScanFilter));
            List rowKeyRanges = ((SkipScanFilter)scan.getFilter()).getSlots();
            Assert.assertEquals(Arrays.asList(Arrays.asList(KeyRange.getKeyRange((byte[])PChar.INSTANCE.toBytes((Object)"A"), (boolean)true, (byte[])PChar.INSTANCE.toBytes((Object)"D"), (boolean)false)), Arrays.asList(KeyRange.getKeyRange((byte[])PChar.INSTANCE.toBytes((Object)"EE"), (boolean)false, (byte[])KeyRange.UNBOUND, (boolean)false))), (Object)rowKeyRanges);
            Assert.assertArrayEquals((byte[])scan.getStartRow(), (byte[])PChar.INSTANCE.toBytes((Object)"AEF"));
            Assert.assertArrayEquals((byte[])scan.getStopRow(), (byte[])PChar.INSTANCE.toBytes((Object)"D"));
            sql = "select * from T where (A,B,C) > ('A','A','A') and (A,B,C) <= ('D','D','D') and (B,C) >= ('E','E')";
            queryPlan = TestUtil.getOptimizeQueryPlan(conn, sql);
            scan = queryPlan.getContext().getScan();
            Assert.assertTrue((boolean)(scan.getFilter() instanceof SkipScanFilter));
            rowKeyRanges = ((SkipScanFilter)scan.getFilter()).getSlots();
            Assert.assertEquals(Arrays.asList(Arrays.asList(KeyRange.getKeyRange((byte[])PChar.INSTANCE.toBytes((Object)"A"), (boolean)true, (byte[])PChar.INSTANCE.toBytes((Object)"D"), (boolean)true)), Arrays.asList(KeyRange.getKeyRange((byte[])PChar.INSTANCE.toBytes((Object)"EE"), (boolean)true, (byte[])KeyRange.UNBOUND, (boolean)false))), (Object)rowKeyRanges);
            Assert.assertArrayEquals((byte[])PChar.INSTANCE.toBytes((Object)"AEE"), (byte[])scan.getStartRow());
            Assert.assertArrayEquals((byte[])PChar.INSTANCE.toBytes((Object)"E"), (byte[])scan.getStopRow());
        }
    }

    @Test
    public void testMultiSlotTrailingIntersect() throws Exception {
        try (Connection conn = DriverManager.getConnection(WhereOptimizerTest.getUrl());){
            String sql = "CREATE TABLE T(A CHAR(1) NOT NULL,B CHAR(1) NOT NULL,C CHAR(1) NOT NULL,D CHAR(1) NOT NULL,DATA INTEGER, CONSTRAINT TEST_PK PRIMARY KEY (A,B,C,D))";
            conn.createStatement().execute(sql);
            sql = "select * from t where (a,b) in (('A','B'),('B','A'),('B','B'),('A','A')) and (a,b,c) in ( ('A','B','C') , ('A','C','D'), ('B','B','E'))";
            QueryPlan queryPlan = TestUtil.getOptimizeQueryPlan(conn, sql);
            Scan scan = queryPlan.getContext().getScan();
            Assert.assertTrue((boolean)(scan.getFilter() instanceof SkipScanFilter));
            List rowKeyRanges = ((SkipScanFilter)scan.getFilter()).getSlots();
            Assert.assertEquals(Arrays.asList(Arrays.asList((KeyRange)KeyRange.POINT.apply((Object)PChar.INSTANCE.toBytes((Object)"ABC")), (KeyRange)KeyRange.POINT.apply((Object)PChar.INSTANCE.toBytes((Object)"BBE")))), (Object)rowKeyRanges);
            Assert.assertArrayEquals((byte[])scan.getStartRow(), (byte[])PChar.INSTANCE.toBytes((Object)"ABC"));
            Assert.assertArrayEquals((byte[])scan.getStopRow(), (byte[])PChar.INSTANCE.toBytes((Object)"BBF"));
        }
    }

    @Test
    public void testEqualityAndGreaterThanRVC() throws SQLException {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(WhereOptimizerTest.getUrl(), props);){
            conn.createStatement().execute("CREATE TABLE T (\n    A CHAR(1) NOT NULL,\n    B CHAR(1) NOT NULL,\n    C CHAR(1) NOT NULL,\n    D CHAR(1) NOT NULL,\n    CONSTRAINT PK PRIMARY KEY (\n        A,\n        B,\n        C,\n        D\n    )\n)");
            String query = "SELECT * FROM T WHERE A = 'C' and (A,B,C) > ('C','B','X') and C='C'";
            QueryPlan queryPlan = TestUtil.getOptimizeQueryPlan(conn, query);
            Scan scan = queryPlan.getContext().getScan();
            Assert.assertArrayEquals((byte[])ByteUtil.concat((byte[])PChar.INSTANCE.toBytes((Object)"C"), (byte[][])new byte[][]{PChar.INSTANCE.toBytes((Object)"B"), PChar.INSTANCE.toBytes((Object)"C")}), (byte[])scan.getStartRow());
            Assert.assertArrayEquals((byte[])PChar.INSTANCE.toBytes((Object)"D"), (byte[])scan.getStopRow());
        }
    }

    @Test
    public void testEqualityAndGreaterThanRVC2() throws SQLException {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(WhereOptimizerTest.getUrl(), props);){
            conn.createStatement().execute("CREATE TABLE T (\n    A CHAR(1) NOT NULL,\n    B CHAR(1) NOT NULL,\n    C CHAR(1) NOT NULL,\n    D CHAR(1) NOT NULL,\n    CONSTRAINT PK PRIMARY KEY (\n        A,\n        B,\n        C,\n        D\n    )\n)");
            String query = "SELECT * FROM T WHERE A = 'C' and (A,B,C) > ('C','B','A') and C='C'";
            QueryPlan queryPlan = TestUtil.getOptimizeQueryPlan(conn, query);
            Scan scan = queryPlan.getContext().getScan();
            Assert.assertArrayEquals((byte[])ByteUtil.concat((byte[])PChar.INSTANCE.toBytes((Object)"C"), (byte[][])new byte[][]{PChar.INSTANCE.toBytes((Object)"B"), PChar.INSTANCE.toBytes((Object)"C")}), (byte[])scan.getStartRow());
            Assert.assertArrayEquals((byte[])PChar.INSTANCE.toBytes((Object)"D"), (byte[])scan.getStopRow());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOrExpressionNonLeadingPKPushToScanBug4602() throws Exception {
        try (Connection conn = null;){
            conn = DriverManager.getConnection(WhereOptimizerTest.getUrl());
            String testTableName = "OR_NO_LEADING_PK4602";
            String sql = "CREATE TABLE " + testTableName + "(PK1 INTEGER NOT NULL,PK2 INTEGER NOT NULL,PK3 INTEGER NOT NULL,DATA INTEGER, CONSTRAINT TEST_PK PRIMARY KEY (PK1,PK2,PK3))";
            conn.createStatement().execute(sql);
            sql = "select * from " + testTableName + " t where (t.pk1 = 2) and ((t.pk2 >= 4 and t.pk2 <6) or (t.pk2 >= 8 and t.pk2 <9))";
            QueryPlan queryPlan = TestUtil.getOptimizeQueryPlan(conn, sql);
            Scan scan = queryPlan.getContext().getScan();
            Assert.assertTrue((boolean)(scan.getFilter() instanceof SkipScanFilter));
            List rowKeyRanges = ((SkipScanFilter)scan.getFilter()).getSlots();
            Assert.assertEquals(Arrays.asList(Arrays.asList((KeyRange)KeyRange.POINT.apply((Object)PInteger.INSTANCE.toBytes((Object)2))), Arrays.asList(KeyRange.getKeyRange((byte[])PInteger.INSTANCE.toBytes((Object)4), (boolean)true, (byte[])PInteger.INSTANCE.toBytes((Object)6), (boolean)false), KeyRange.getKeyRange((byte[])PInteger.INSTANCE.toBytes((Object)8), (boolean)true, (byte[])PInteger.INSTANCE.toBytes((Object)9), (boolean)false))), (Object)rowKeyRanges);
            Assert.assertArrayEquals((byte[])scan.getStartRow(), (byte[])ByteUtil.concat((byte[])PInteger.INSTANCE.toBytes((Object)2), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)4)}));
            Assert.assertArrayEquals((byte[])scan.getStopRow(), (byte[])ByteUtil.concat((byte[])PInteger.INSTANCE.toBytes((Object)2), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)9)}));
            sql = "select * from " + testTableName + " t where (t.pk1 >=2 and t.pk1<5) and ((t.pk2 >= 4 and t.pk2 <6) or (t.pk2 >= 8 and t.pk2 <9))";
            queryPlan = TestUtil.getOptimizeQueryPlan(conn, sql);
            scan = queryPlan.getContext().getScan();
            Assert.assertTrue((boolean)(scan.getFilter() instanceof SkipScanFilter));
            rowKeyRanges = ((SkipScanFilter)scan.getFilter()).getSlots();
            Assert.assertEquals(Arrays.asList(Arrays.asList(KeyRange.getKeyRange((byte[])PInteger.INSTANCE.toBytes((Object)2), (boolean)true, (byte[])PInteger.INSTANCE.toBytes((Object)5), (boolean)false)), Arrays.asList(KeyRange.getKeyRange((byte[])PInteger.INSTANCE.toBytes((Object)4), (boolean)true, (byte[])PInteger.INSTANCE.toBytes((Object)6), (boolean)false), KeyRange.getKeyRange((byte[])PInteger.INSTANCE.toBytes((Object)8), (boolean)true, (byte[])PInteger.INSTANCE.toBytes((Object)9), (boolean)false))), (Object)rowKeyRanges);
            Assert.assertArrayEquals((byte[])scan.getStartRow(), (byte[])ByteUtil.concat((byte[])PInteger.INSTANCE.toBytes((Object)2), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)4)}));
            Assert.assertArrayEquals((byte[])scan.getStopRow(), (byte[])PInteger.INSTANCE.toBytes((Object)5));
            sql = "select * from " + testTableName + " t where ((t.pk1 >=2 and t.pk1<5) or (t.pk1 >=7 and t.pk1 <9)) and ((t.pk2 >= 4 and t.pk2 <6) or (t.pk2 >= 8 and t.pk2 <9))";
            queryPlan = TestUtil.getOptimizeQueryPlan(conn, sql);
            scan = queryPlan.getContext().getScan();
            Assert.assertTrue((boolean)(scan.getFilter() instanceof SkipScanFilter));
            rowKeyRanges = ((SkipScanFilter)scan.getFilter()).getSlots();
            Assert.assertEquals(Arrays.asList(Arrays.asList(KeyRange.getKeyRange((byte[])PInteger.INSTANCE.toBytes((Object)2), (boolean)true, (byte[])PInteger.INSTANCE.toBytes((Object)5), (boolean)false), KeyRange.getKeyRange((byte[])PInteger.INSTANCE.toBytes((Object)7), (boolean)true, (byte[])PInteger.INSTANCE.toBytes((Object)9), (boolean)false)), Arrays.asList(KeyRange.getKeyRange((byte[])PInteger.INSTANCE.toBytes((Object)4), (boolean)true, (byte[])PInteger.INSTANCE.toBytes((Object)6), (boolean)false), KeyRange.getKeyRange((byte[])PInteger.INSTANCE.toBytes((Object)8), (boolean)true, (byte[])PInteger.INSTANCE.toBytes((Object)9), (boolean)false))), (Object)rowKeyRanges);
            Assert.assertArrayEquals((byte[])scan.getStartRow(), (byte[])ByteUtil.concat((byte[])PInteger.INSTANCE.toBytes((Object)2), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)4)}));
            Assert.assertArrayEquals((byte[])scan.getStopRow(), (byte[])PInteger.INSTANCE.toBytes((Object)9));
            sql = "select * from " + testTableName + " t where ((t.pk1 >=2 and t.pk1<5) or (t.pk1 >=7 and t.pk1 <9)) and ((t.pk3 >= 4 and t.pk3 <6) or (t.pk3 >= 8 and t.pk3 <9))";
            queryPlan = TestUtil.getOptimizeQueryPlan(conn, sql);
            scan = queryPlan.getContext().getScan();
            Assert.assertTrue((boolean)(scan.getFilter() instanceof SkipScanFilter));
            rowKeyRanges = ((SkipScanFilter)scan.getFilter()).getSlots();
            Assert.assertEquals(Arrays.asList(Arrays.asList(KeyRange.getKeyRange((byte[])PInteger.INSTANCE.toBytes((Object)2), (boolean)true, (byte[])PInteger.INSTANCE.toBytes((Object)5), (boolean)false), KeyRange.getKeyRange((byte[])PInteger.INSTANCE.toBytes((Object)7), (boolean)true, (byte[])PInteger.INSTANCE.toBytes((Object)9), (boolean)false)), Arrays.asList(KeyRange.EVERYTHING_RANGE), Arrays.asList(KeyRange.getKeyRange((byte[])PInteger.INSTANCE.toBytes((Object)4), (boolean)true, (byte[])PInteger.INSTANCE.toBytes((Object)6), (boolean)false), KeyRange.getKeyRange((byte[])PInteger.INSTANCE.toBytes((Object)8), (boolean)true, (byte[])PInteger.INSTANCE.toBytes((Object)9), (boolean)false))), (Object)rowKeyRanges);
            Assert.assertArrayEquals((byte[])scan.getStartRow(), (byte[])PInteger.INSTANCE.toBytes((Object)2));
            Assert.assertArrayEquals((byte[])scan.getStopRow(), (byte[])PInteger.INSTANCE.toBytes((Object)9));
            sql = "select * from " + testTableName + " t where ((t.pk1 >=2) or (t.data >= 4 and t.data <9))";
            queryPlan = TestUtil.getOptimizeQueryPlan(conn, sql);
            scan = queryPlan.getContext().getScan();
            Assert.assertTrue((boolean)(scan.getFilter() instanceof SingleCQKeyValueComparisonFilter));
            Expression pk1Expression = new ColumnRef(queryPlan.getTableRef(), queryPlan.getTableRef().getTable().getColumnForColumnName("PK1").getPosition()).newColumnExpression();
            Expression dataExpression = new ColumnRef(queryPlan.getTableRef(), queryPlan.getTableRef().getTable().getColumnForColumnName("DATA").getPosition()).newColumnExpression();
            Assert.assertEquals((Object)TestUtil.singleKVFilter(TestUtil.or(TestUtil.constantComparison(CompareOperator.GREATER_OR_EQUAL, pk1Expression, (Object)2), TestUtil.and(TestUtil.constantComparison(CompareOperator.GREATER_OR_EQUAL, dataExpression, (Object)4), TestUtil.constantComparison(CompareOperator.LESS, dataExpression, (Object)9)))), (Object)scan.getFilter());
            Assert.assertArrayEquals((byte[])scan.getStartRow(), (byte[])HConstants.EMPTY_START_ROW);
            Assert.assertArrayEquals((byte[])scan.getStopRow(), (byte[])HConstants.EMPTY_END_ROW);
            sql = "select * from " + testTableName + " t where (t.pk1 >=2 and t.pk1<5) or ((t.pk2 >= 4 and t.pk2 <6) and (t.pk2 >= 8 and t.pk2 <9))";
            queryPlan = TestUtil.getOptimizeQueryPlan(conn, sql);
            scan = queryPlan.getContext().getScan();
            Assert.assertNull((Object)scan.getFilter());
            Assert.assertArrayEquals((byte[])scan.getStartRow(), (byte[])PInteger.INSTANCE.toBytes((Object)2));
            Assert.assertArrayEquals((byte[])scan.getStopRow(), (byte[])PInteger.INSTANCE.toBytes((Object)5));
            sql = "select * from " + testTableName + " t where (t.pk1 >=2 and t.pk1<5) or (t.pk2 >=7 or t.pk2 <9)";
            queryPlan = TestUtil.getOptimizeQueryPlan(conn, sql);
            scan = queryPlan.getContext().getScan();
            Expression pk2Expression = new ColumnRef(queryPlan.getTableRef(), queryPlan.getTableRef().getTable().getColumnForColumnName("PK2").getPosition()).newColumnExpression();
            Assert.assertTrue((boolean)(scan.getFilter() instanceof RowKeyComparisonFilter));
            Assert.assertEquals((Object)TestUtil.rowKeyFilter(TestUtil.or(TestUtil.and(TestUtil.constantComparison(CompareOperator.GREATER_OR_EQUAL, pk1Expression, (Object)2), TestUtil.constantComparison(CompareOperator.LESS, pk1Expression, (Object)5)), TestUtil.or(TestUtil.constantComparison(CompareOperator.GREATER_OR_EQUAL, pk2Expression, (Object)7), TestUtil.constantComparison(CompareOperator.LESS, pk2Expression, (Object)9)))), (Object)scan.getFilter());
            Assert.assertArrayEquals((byte[])scan.getStartRow(), (byte[])HConstants.EMPTY_START_ROW);
            Assert.assertArrayEquals((byte[])scan.getStopRow(), (byte[])HConstants.EMPTY_END_ROW);
            sql = "select * from " + testTableName + " t where ((t.pk1 >=2 and t.pk1<5) or (t.pk1 >=7 or t.pk1 <9)) and ((t.pk2 >= 4 and t.pk2 <6) or (t.pk2 >= 8 and t.pk2 <9))";
            queryPlan = TestUtil.getOptimizeQueryPlan(conn, sql);
            scan = queryPlan.getContext().getScan();
            Assert.assertTrue((boolean)(scan.getFilter() instanceof RowKeyComparisonFilter));
            Assert.assertEquals((Object)TestUtil.rowKeyFilter(TestUtil.or(TestUtil.and(TestUtil.constantComparison(CompareOperator.GREATER_OR_EQUAL, pk2Expression, (Object)4), TestUtil.constantComparison(CompareOperator.LESS, pk2Expression, (Object)6)), TestUtil.and(TestUtil.constantComparison(CompareOperator.GREATER_OR_EQUAL, pk2Expression, (Object)8), TestUtil.constantComparison(CompareOperator.LESS, pk2Expression, (Object)9)))), (Object)scan.getFilter());
            Assert.assertArrayEquals((byte[])scan.getStartRow(), (byte[])HConstants.EMPTY_START_ROW);
            Assert.assertArrayEquals((byte[])scan.getStopRow(), (byte[])HConstants.EMPTY_END_ROW);
            sql = "select * from " + testTableName + " t where ((t.pk1 >= 4 and t.pk1 <6) or (t.pk1 >= 8 and t.pk1 <9)) and ((t.pk2 >=2 and t.pk2<5) or (t.pk2 >=7 or t.pk2 <9))";
            queryPlan = TestUtil.getOptimizeQueryPlan(conn, sql);
            scan = queryPlan.getContext().getScan();
            Assert.assertTrue((boolean)(scan.getFilter() instanceof SkipScanFilter));
            rowKeyRanges = ((SkipScanFilter)scan.getFilter()).getSlots();
            Assert.assertEquals(Arrays.asList(Arrays.asList(KeyRange.getKeyRange((byte[])PInteger.INSTANCE.toBytes((Object)4), (boolean)true, (byte[])PInteger.INSTANCE.toBytes((Object)6), (boolean)false), KeyRange.getKeyRange((byte[])PInteger.INSTANCE.toBytes((Object)8), (boolean)true, (byte[])PInteger.INSTANCE.toBytes((Object)9), (boolean)false)), Arrays.asList(KeyRange.EVERYTHING_RANGE)), (Object)rowKeyRanges);
            Assert.assertArrayEquals((byte[])scan.getStartRow(), (byte[])PInteger.INSTANCE.toBytes((Object)4));
            Assert.assertArrayEquals((byte[])scan.getStopRow(), (byte[])PInteger.INSTANCE.toBytes((Object)9));
            sql = "select * from " + testTableName + " t where (pk2 <=7 or pk2>9)";
            queryPlan = TestUtil.getOptimizeQueryPlan(conn, sql);
            pk2Expression = new ColumnRef(queryPlan.getTableRef(), queryPlan.getTableRef().getTable().getColumnForColumnName("PK2").getPosition()).newColumnExpression();
            scan = queryPlan.getContext().getScan();
            Assert.assertTrue((boolean)(scan.getFilter() instanceof RowKeyComparisonFilter));
            Assert.assertEquals((Object)TestUtil.rowKeyFilter(TestUtil.or(TestUtil.constantComparison(CompareOperator.LESS_OR_EQUAL, pk2Expression, (Object)7), TestUtil.constantComparison(CompareOperator.GREATER, pk2Expression, (Object)9))), (Object)scan.getFilter());
            Assert.assertArrayEquals((byte[])scan.getStartRow(), (byte[])HConstants.EMPTY_START_ROW);
            Assert.assertArrayEquals((byte[])scan.getStopRow(), (byte[])HConstants.EMPTY_END_ROW);
            sql = "select /*+ SKIP_SCAN */ * from " + testTableName + " t where ((t.pk1 >=2 and t.pk1<5) or (t.pk1 >=7 or t.pk1 <9)) and ((t.pk2 >= 4 and t.pk2 <6) or (t.pk2 >= 8 and t.pk2 <9))";
            queryPlan = TestUtil.getOptimizeQueryPlan(conn, sql);
            scan = queryPlan.getContext().getScan();
            Assert.assertTrue((boolean)(scan.getFilter() instanceof SkipScanFilter));
            rowKeyRanges = ((SkipScanFilter)scan.getFilter()).getSlots();
            Assert.assertEquals(Arrays.asList(Arrays.asList(KeyRange.EVERYTHING_RANGE), Arrays.asList(KeyRange.getKeyRange((byte[])PInteger.INSTANCE.toBytes((Object)4), (boolean)true, (byte[])PInteger.INSTANCE.toBytes((Object)6), (boolean)false), KeyRange.getKeyRange((byte[])PInteger.INSTANCE.toBytes((Object)8), (boolean)true, (byte[])PInteger.INSTANCE.toBytes((Object)9), (boolean)false))), (Object)rowKeyRanges);
            Assert.assertArrayEquals((byte[])scan.getStartRow(), (byte[])HConstants.EMPTY_START_ROW);
            Assert.assertArrayEquals((byte[])scan.getStopRow(), (byte[])HConstants.EMPTY_END_ROW);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLastPkColumnIsVariableLengthAndDescBug5307() throws Exception {
        try (Connection conn = null;){
            conn = DriverManager.getConnection(WhereOptimizerTest.getUrl());
            String sql = "CREATE TABLE t1 (\nOBJECT_VERSION VARCHAR NOT NULL,\nLOC VARCHAR,\nCONSTRAINT PK PRIMARY KEY (OBJECT_VERSION DESC))";
            conn.createStatement().execute(sql);
            byte[] startKey = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)"2222", SortOrder.DESC), (byte[][])new byte[][]{QueryConstants.DESC_SEPARATOR_BYTE_ARRAY});
            byte[] endKey = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)"1111", SortOrder.DESC), (byte[][])new byte[][]{QueryConstants.DESC_SEPARATOR_BYTE_ARRAY});
            ByteUtil.nextKey((byte[])endKey, (int)endKey.length);
            sql = "SELECT /*+ RANGE_SCAN */ OBJ.OBJECT_VERSION, OBJ.LOC from t1 AS OBJ where OBJ.OBJECT_VERSION in ('1111','2222')";
            QueryPlan queryPlan = TestUtil.getOptimizeQueryPlan(conn, sql);
            Scan scan = queryPlan.getContext().getScan();
            Assert.assertArrayEquals((byte[])startKey, (byte[])scan.getStartRow());
            Assert.assertArrayEquals((byte[])endKey, (byte[])scan.getStopRow());
            sql = "CREATE TABLE t2 (\nOBJECT_ID VARCHAR NOT NULL,\nOBJECT_VERSION VARCHAR NOT NULL,\nLOC VARCHAR,\nCONSTRAINT PK PRIMARY KEY (OBJECT_ID, OBJECT_VERSION DESC))";
            conn.createStatement().execute(sql);
            startKey = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)"obj1", SortOrder.ASC), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, PVarchar.INSTANCE.toBytes((Object)"2222", SortOrder.DESC), QueryConstants.DESC_SEPARATOR_BYTE_ARRAY});
            endKey = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)"obj3", SortOrder.ASC), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, PVarchar.INSTANCE.toBytes((Object)"1111", SortOrder.DESC), QueryConstants.DESC_SEPARATOR_BYTE_ARRAY, QueryConstants.SEPARATOR_BYTE_ARRAY});
            sql = "SELECT OBJ.OBJECT_ID, OBJ.OBJECT_VERSION, OBJ.LOC from t2 AS OBJ where (OBJ.OBJECT_ID, OBJ.OBJECT_VERSION) in (('obj1', '2222'),('obj2', '1111'),('obj3', '1111'))";
            queryPlan = TestUtil.getOptimizeQueryPlan(conn, sql);
            scan = queryPlan.getContext().getScan();
            FilterList filterList = (FilterList)scan.getFilter();
            Assert.assertTrue((filterList.getOperator() == FilterList.Operator.MUST_PASS_ALL ? 1 : 0) != 0);
            Assert.assertEquals((long)filterList.getFilters().size(), (long)2L);
            Assert.assertTrue((boolean)(filterList.getFilters().get(0) instanceof SkipScanFilter));
            Assert.assertTrue((boolean)(filterList.getFilters().get(1) instanceof RowKeyComparisonFilter));
            RowKeyComparisonFilter rowKeyComparisonFilter = (RowKeyComparisonFilter)filterList.getFilters().get(1);
            Assert.assertEquals((Object)rowKeyComparisonFilter.toString(), (Object)"(OBJECT_ID, OBJECT_VERSION) IN (X'6f626a3100cdcdcdcd',X'6f626a3200cececece',X'6f626a3300cececece')");
            Assert.assertTrue((boolean)queryPlan.getContext().getScanRanges().isPointLookup());
            Assert.assertArrayEquals((byte[])startKey, (byte[])scan.getStartRow());
            Assert.assertArrayEquals((byte[])endKey, (byte[])scan.getStopRow());
        }
    }

    @Test
    public void testRVCClipBug5753() throws Exception {
        String tableName = WhereOptimizerTest.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(WhereOptimizerTest.getUrl());){
            conn.setAutoCommit(true);
            Statement stmt = conn.createStatement();
            String sql = "CREATE TABLE " + tableName + " ( pk1 INTEGER NOT NULL ,  pk2 INTEGER NOT NULL,  pk3 INTEGER NOT NULL,  pk4 INTEGER NOT NULL,  pk5 INTEGER NOT NULL,  pk6 INTEGER NOT NULL,  pk7 INTEGER NOT NULL,  pk8 INTEGER NOT NULL,  v INTEGER, CONSTRAINT PK PRIMARY KEY(pk1,pk2,pk3 desc,pk4,pk5,pk6 desc,pk7,pk8))";
            stmt.execute(sql);
            List rowKeyRanges = null;
            RowKeyComparisonFilter rowKeyComparisonFilter = null;
            QueryPlan queryPlan = null;
            Scan scan = null;
            sql = "SELECT  /*+ RANGE_SCAN */ * FROM  " + tableName + " WHERE (pk1, pk2) IN ((2, 3), (2, 4)) AND pk3 = 5";
            queryPlan = TestUtil.getOptimizeQueryPlan(conn, sql);
            scan = queryPlan.getContext().getScan();
            Assert.assertTrue((boolean)(scan.getFilter() instanceof RowKeyComparisonFilter));
            rowKeyComparisonFilter = (RowKeyComparisonFilter)scan.getFilter();
            Assert.assertEquals((Object)rowKeyComparisonFilter.toString(), (Object)"((PK1, PK2) IN (X'8000000280000003',X'8000000280000004') AND PK3 = 5)");
            Assert.assertArrayEquals((byte[])scan.getStartRow(), (byte[])ByteUtil.concat((byte[])PInteger.INSTANCE.toBytes((Object)2), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)3), PInteger.INSTANCE.toBytes((Object)5, SortOrder.DESC)}));
            Assert.assertArrayEquals((byte[])scan.getStopRow(), (byte[])ByteUtil.concat((byte[])PInteger.INSTANCE.toBytes((Object)2), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)4), ByteUtil.nextKey((byte[])PInteger.INSTANCE.toBytes((Object)5, SortOrder.DESC))}));
            sql = "select * from " + tableName + " where (pk1 >=1 and pk1<=2) and (pk2>=2 and pk2<=3) and (pk3,pk4) < (3,5)";
            queryPlan = TestUtil.getOptimizeQueryPlan(conn, sql);
            scan = queryPlan.getContext().getScan();
            Assert.assertTrue((boolean)(scan.getFilter() instanceof FilterList));
            FilterList filterList = (FilterList)scan.getFilter();
            Assert.assertTrue((filterList.getOperator() == FilterList.Operator.MUST_PASS_ALL ? 1 : 0) != 0);
            Assert.assertEquals((long)filterList.getFilters().size(), (long)2L);
            Assert.assertTrue((boolean)(filterList.getFilters().get(0) instanceof SkipScanFilter));
            rowKeyRanges = ((SkipScanFilter)filterList.getFilters().get(0)).getSlots();
            Assert.assertEquals(Arrays.asList(Arrays.asList(KeyRange.getKeyRange((byte[])PInteger.INSTANCE.toBytes((Object)1), (boolean)true, (byte[])PInteger.INSTANCE.toBytes((Object)2), (boolean)true)), Arrays.asList(KeyRange.getKeyRange((byte[])PInteger.INSTANCE.toBytes((Object)2), (boolean)true, (byte[])PInteger.INSTANCE.toBytes((Object)3), (boolean)true)), Arrays.asList(KeyRange.getKeyRange((byte[])PInteger.INSTANCE.toBytes((Object)3, SortOrder.DESC), (boolean)true, (byte[])KeyRange.UNBOUND, (boolean)false))), (Object)rowKeyRanges);
            Assert.assertArrayEquals((byte[])scan.getStartRow(), (byte[])ByteUtil.concat((byte[])PInteger.INSTANCE.toBytes((Object)1), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)2), PInteger.INSTANCE.toBytes((Object)3, SortOrder.DESC)}));
            Assert.assertArrayEquals((byte[])scan.getStopRow(), (byte[])ByteUtil.concat((byte[])PInteger.INSTANCE.toBytes((Object)2), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)4)}));
            Assert.assertTrue((boolean)(filterList.getFilters().get(1) instanceof RowKeyComparisonFilter));
            rowKeyComparisonFilter = (RowKeyComparisonFilter)filterList.getFilters().get(1);
            Assert.assertTrue((boolean)rowKeyComparisonFilter.toString().equals("(TO_INTEGER(PK3), PK4) < (TO_INTEGER(TO_INTEGER(3)), 5)"));
            sql = "select * from " + tableName + " where (pk1 >=1 and pk1<=2) and (pk2>=2 and pk2<=3) and (pk3,pk4) in ((3,4),(4,5)) and  (pk5,pk6,pk7) in ((5,6,7),(6,7,8)) and pk8 > 8";
            queryPlan = TestUtil.getOptimizeQueryPlan(conn, sql);
            scan = queryPlan.getContext().getScan();
            Assert.assertTrue((boolean)(scan.getFilter() instanceof FilterList));
            filterList = (FilterList)scan.getFilter();
            Assert.assertTrue((filterList.getOperator() == FilterList.Operator.MUST_PASS_ALL ? 1 : 0) != 0);
            Assert.assertEquals((long)filterList.getFilters().size(), (long)2L);
            Assert.assertTrue((boolean)(filterList.getFilters().get(0) instanceof SkipScanFilter));
            rowKeyRanges = ((SkipScanFilter)filterList.getFilters().get(0)).getSlots();
            Assert.assertEquals(Arrays.asList(Arrays.asList(KeyRange.getKeyRange((byte[])PInteger.INSTANCE.toBytes((Object)1), (boolean)true, (byte[])PInteger.INSTANCE.toBytes((Object)2), (boolean)true)), Arrays.asList(KeyRange.getKeyRange((byte[])PInteger.INSTANCE.toBytes((Object)2), (boolean)true, (byte[])PInteger.INSTANCE.toBytes((Object)3), (boolean)true)), Arrays.asList(KeyRange.getKeyRange((byte[])PInteger.INSTANCE.toBytes((Object)4, SortOrder.DESC), (boolean)true, (byte[])PInteger.INSTANCE.toBytes((Object)4, SortOrder.DESC), (boolean)true), KeyRange.getKeyRange((byte[])PInteger.INSTANCE.toBytes((Object)3, SortOrder.DESC), (boolean)true, (byte[])PInteger.INSTANCE.toBytes((Object)3, SortOrder.DESC), (boolean)true)), Arrays.asList(KeyRange.getKeyRange((byte[])PInteger.INSTANCE.toBytes((Object)4), (boolean)true, (byte[])PInteger.INSTANCE.toBytes((Object)4), (boolean)true), KeyRange.getKeyRange((byte[])PInteger.INSTANCE.toBytes((Object)5), (boolean)true, (byte[])PInteger.INSTANCE.toBytes((Object)5), (boolean)true)), Arrays.asList(KeyRange.getKeyRange((byte[])PInteger.INSTANCE.toBytes((Object)5), (boolean)true, (byte[])PInteger.INSTANCE.toBytes((Object)5), (boolean)true), KeyRange.getKeyRange((byte[])PInteger.INSTANCE.toBytes((Object)6), (boolean)true, (byte[])PInteger.INSTANCE.toBytes((Object)6), (boolean)true)), Arrays.asList(KeyRange.getKeyRange((byte[])PInteger.INSTANCE.toBytes((Object)7, SortOrder.DESC), (boolean)true, (byte[])PInteger.INSTANCE.toBytes((Object)7, SortOrder.DESC), (boolean)true), KeyRange.getKeyRange((byte[])PInteger.INSTANCE.toBytes((Object)6, SortOrder.DESC), (boolean)true, (byte[])PInteger.INSTANCE.toBytes((Object)6, SortOrder.DESC), (boolean)true)), Arrays.asList(KeyRange.getKeyRange((byte[])PInteger.INSTANCE.toBytes((Object)7), (boolean)true, (byte[])PInteger.INSTANCE.toBytes((Object)7), (boolean)true), KeyRange.getKeyRange((byte[])PInteger.INSTANCE.toBytes((Object)8), (boolean)true, (byte[])PInteger.INSTANCE.toBytes((Object)8), (boolean)true)), Arrays.asList(KeyRange.getKeyRange((byte[])PInteger.INSTANCE.toBytes((Object)9), (boolean)true, (byte[])KeyRange.UNBOUND, (boolean)false))), (Object)rowKeyRanges);
            Assert.assertArrayEquals((byte[])scan.getStartRow(), (byte[])ByteUtil.concat((byte[])PInteger.INSTANCE.toBytes((Object)1), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)2), PInteger.INSTANCE.toBytes((Object)4, SortOrder.DESC), PInteger.INSTANCE.toBytes((Object)4), PInteger.INSTANCE.toBytes((Object)5), PInteger.INSTANCE.toBytes((Object)7, SortOrder.DESC), PInteger.INSTANCE.toBytes((Object)7), PInteger.INSTANCE.toBytes((Object)9)}));
            Assert.assertArrayEquals((byte[])scan.getStopRow(), (byte[])ByteUtil.concat((byte[])PInteger.INSTANCE.toBytes((Object)2), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)3), PInteger.INSTANCE.toBytes((Object)3, SortOrder.DESC), PInteger.INSTANCE.toBytes((Object)5), PInteger.INSTANCE.toBytes((Object)6), PInteger.INSTANCE.toBytes((Object)6, SortOrder.DESC), PInteger.INSTANCE.toBytes((Object)9)}));
            Assert.assertTrue((boolean)(filterList.getFilters().get(1) instanceof RowKeyComparisonFilter));
            rowKeyComparisonFilter = (RowKeyComparisonFilter)filterList.getFilters().get(1);
            Assert.assertEquals((Object)rowKeyComparisonFilter.toString(), (Object)"((PK3, PK4) IN (X'7ffffffb80000005',X'7ffffffc80000004') AND (PK5, PK6, PK7) IN (X'800000057ffffff980000007',X'800000067ffffff880000008'))");
            sql = "select * from " + tableName + " where (pk1 >=1 and pk1<=2) and (pk2>=2 and pk2<=3) and (pk3,pk4) < (3,4) and  (pk5,pk6,pk7) < (5,6,7) and pk8 > 8";
            queryPlan = TestUtil.getOptimizeQueryPlan(conn, sql);
            scan = queryPlan.getContext().getScan();
            Assert.assertTrue((boolean)(scan.getFilter() instanceof FilterList));
            filterList = (FilterList)scan.getFilter();
            Assert.assertTrue((filterList.getOperator() == FilterList.Operator.MUST_PASS_ALL ? 1 : 0) != 0);
            Assert.assertEquals((long)filterList.getFilters().size(), (long)2L);
            Assert.assertTrue((boolean)(filterList.getFilters().get(0) instanceof SkipScanFilter));
            rowKeyRanges = ((SkipScanFilter)filterList.getFilters().get(0)).getSlots();
            Assert.assertEquals(Arrays.asList(Arrays.asList(KeyRange.getKeyRange((byte[])PInteger.INSTANCE.toBytes((Object)1), (boolean)true, (byte[])PInteger.INSTANCE.toBytes((Object)2), (boolean)true)), Arrays.asList(KeyRange.getKeyRange((byte[])PInteger.INSTANCE.toBytes((Object)2), (boolean)true, (byte[])PInteger.INSTANCE.toBytes((Object)3), (boolean)true)), Arrays.asList(KeyRange.getKeyRange((byte[])PInteger.INSTANCE.toBytes((Object)3, SortOrder.DESC), (boolean)true, (byte[])KeyRange.UNBOUND, (boolean)false)), Arrays.asList(KeyRange.EVERYTHING_RANGE), Arrays.asList(KeyRange.getKeyRange((byte[])KeyRange.UNBOUND, (boolean)false, (byte[])PInteger.INSTANCE.toBytes((Object)5), (boolean)true)), Arrays.asList(KeyRange.EVERYTHING_RANGE), Arrays.asList(KeyRange.EVERYTHING_RANGE), Arrays.asList(KeyRange.getKeyRange((byte[])PInteger.INSTANCE.toBytes((Object)9), (boolean)true, (byte[])KeyRange.UNBOUND, (boolean)false))), (Object)rowKeyRanges);
            Assert.assertArrayEquals((byte[])scan.getStartRow(), (byte[])ByteUtil.concat((byte[])PInteger.INSTANCE.toBytes((Object)1), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)2), PInteger.INSTANCE.toBytes((Object)3, SortOrder.DESC)}));
            Assert.assertArrayEquals((byte[])scan.getStopRow(), (byte[])ByteUtil.concat((byte[])PInteger.INSTANCE.toBytes((Object)2), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)4)}));
            Assert.assertTrue((boolean)(filterList.getFilters().get(1) instanceof RowKeyComparisonFilter));
            rowKeyComparisonFilter = (RowKeyComparisonFilter)filterList.getFilters().get(1);
            Assert.assertTrue((boolean)rowKeyComparisonFilter.toString().equals("((PK5, TO_INTEGER(PK6), PK7) < (5, TO_INTEGER(TO_INTEGER(6)), 7) AND (TO_INTEGER(PK3), PK4) < (TO_INTEGER(TO_INTEGER(3)), 4))"));
        }
    }

    @Test
    public void testWithLargeORs() throws Exception {
        SortOrder[][] sortOrders = new SortOrder[][]{{SortOrder.ASC, SortOrder.ASC, SortOrder.ASC}, {SortOrder.ASC, SortOrder.ASC, SortOrder.DESC}, {SortOrder.ASC, SortOrder.DESC, SortOrder.ASC}, {SortOrder.ASC, SortOrder.DESC, SortOrder.DESC}, {SortOrder.DESC, SortOrder.ASC, SortOrder.ASC}, {SortOrder.DESC, SortOrder.ASC, SortOrder.DESC}, {SortOrder.DESC, SortOrder.DESC, SortOrder.ASC}, {SortOrder.DESC, SortOrder.DESC, SortOrder.DESC}};
        String tableName = WhereOptimizerTest.generateUniqueName();
        String viewName = String.format("Z_%s", tableName);
        PDataType[] testTSVarVarPKTypes = new PDataType[]{PTimestamp.INSTANCE, PVarchar.INSTANCE, PInteger.INSTANCE};
        String baseTableName = String.format("TEST_ENTITY.%s", tableName);
        int tenantId = 1;
        int numTestCases = 1;
        for (int index = 0; index < sortOrders.length; ++index) {
            String view1Name = String.format("TEST_ENTITY.%s%d", viewName, index * numTestCases + 1);
            String partition1 = String.format("Z%d", index * numTestCases + 1);
            this.createTenantView(tenantId, baseTableName, view1Name, partition1, testTSVarVarPKTypes[0], sortOrders[index][0], testTSVarVarPKTypes[1], sortOrders[index][1], testTSVarVarPKTypes[2], sortOrders[index][2]);
            this.testTSVarIntAndLargeORs(tenantId, view1Name, sortOrders[index]);
        }
    }

    @Test
    public void testScanKeyInheritedIndexTenantView() throws Exception {
        String baseTableName = WhereOptimizerTest.generateUniqueName();
        String globalViewName = WhereOptimizerTest.generateUniqueName();
        String globalViewIndexName = WhereOptimizerTest.generateUniqueName();
        String tenantViewName = WhereOptimizerTest.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(WhereOptimizerTest.getUrl());){
            conn.createStatement().execute("CREATE TABLE " + baseTableName + " (TENANT_ID CHAR(8) NOT NULL, KP CHAR(3) NOT NULL, PK CHAR(3) NOT NULL, KV CHAR(2), KV2 CHAR(2) CONSTRAINT PK PRIMARY KEY(TENANT_ID, KP, PK)) MULTI_TENANT=true");
            conn.createStatement().execute("CREATE VIEW " + globalViewName + " AS SELECT * FROM " + baseTableName + " WHERE  KP = '001'");
            conn.createStatement().execute("CREATE INDEX " + globalViewIndexName + " on " + globalViewName + " (KV)  INCLUDE (KV2)");
            String tenantId = "tenantId";
            Properties tenantProps = new Properties();
            tenantProps.setProperty("TenantId", tenantId);
            try (Connection tenantConn = DriverManager.getConnection(WhereOptimizerTest.getUrl(), tenantProps);){
                tenantConn.createStatement().execute("CREATE VIEW " + tenantViewName + " AS SELECT * FROM " + globalViewName);
                String query = "SELECT KV2 FROM  " + tenantViewName + " WHERE KV = 'KV'";
                PhoenixConnection pconn = tenantConn.unwrap(PhoenixConnection.class);
                PhoenixPreparedStatement pstmt = new PhoenixPreparedStatement(pconn, query);
                QueryPlan plan = pstmt.compileQuery();
                plan = tenantConn.unwrap(PhoenixConnection.class).getQueryServices().getOptimizer().optimize((PhoenixStatement)pstmt, plan);
                Assert.assertEquals((Object)(tenantViewName + "#" + globalViewIndexName), (Object)plan.getContext().getCurrentTable().getTable().getName().getString());
                Scan scan = plan.getContext().getScan();
                PTable viewIndexPTable = tenantConn.unwrap(PhoenixConnection.class).getTable(globalViewIndexName);
                byte[] startRow = ByteUtil.concat((byte[])PLong.INSTANCE.toBytes((Object)viewIndexPTable.getViewIndexId()), (byte[][])new byte[][]{PChar.INSTANCE.toBytes((Object)tenantId), PChar.INSTANCE.toBytes((Object)"KV")});
                Assert.assertArrayEquals((byte[])startRow, (byte[])scan.getStartRow());
            }
        }
    }

    private void createBaseTable(String baseTable) throws SQLException {
        try (Connection globalConnection = DriverManager.getConnection(WhereOptimizerTest.getUrl());
             Statement cstmt = globalConnection.createStatement();){
            String CO_BASE_TBL_TEMPLATE = "CREATE TABLE IF NOT EXISTS %s(OID CHAR(15) NOT NULL,KP CHAR(3) NOT NULL,ROW_ID VARCHAR, COL1 VARCHAR,COL2 VARCHAR,COL3 VARCHAR,CREATED_DATE DATE,CREATED_BY CHAR(15),LAST_UPDATE DATE,LAST_UPDATE_BY CHAR(15),SYSTEM_MODSTAMP DATE CONSTRAINT pk PRIMARY KEY (OID,KP)) MULTI_TENANT=true,COLUMN_ENCODED_BYTES=0";
            cstmt.execute(String.format(CO_BASE_TBL_TEMPLATE, baseTable));
        }
    }

    private void createTenantView(int tenant, String baseTable, String tenantView, String partition, PDataType pkType1, SortOrder pk1Order, PDataType pkType2, SortOrder pk2Order, PDataType pkType3, SortOrder pk3Order) throws SQLException {
        String pkType1Str = this.getType(pkType1);
        String pkType2Str = this.getType(pkType2);
        String pkType3Str = this.getType(pkType3);
        this.createBaseTable(baseTable);
        String tenantConnectionUrl = String.format("%s;%s=%s%06d", WhereOptimizerTest.getUrl(), "TenantId", TENANT_PREFIX, tenant);
        try (Connection tenantConnection = DriverManager.getConnection(tenantConnectionUrl);
             Statement cstmt = tenantConnection.createStatement();){
            String TENANT_VIEW_TEMPLATE = "CREATE VIEW IF NOT EXISTS %s(ID1 %s not null,ID2 %s not null,ID3 %s not null,COL4 VARCHAR,COL5 VARCHAR,COL6 VARCHAR CONSTRAINT pk PRIMARY KEY (ID1 %s, ID2 %s, ID3 %s)) AS SELECT * FROM %s WHERE KP = '%s'";
            cstmt.execute(String.format(TENANT_VIEW_TEMPLATE, tenantView, pkType1Str, pkType2Str, pkType3Str, pk1Order.name(), pk2Order.name(), pk3Order.name(), baseTable, partition));
        }
    }

    private int setBindVariables(PhoenixPreparedStatement stmt, int startBindIndex, int numBinds, PDataType[] testPKTypes) throws SQLException {
        Random rnd = new Random();
        int lastBindCol = 0;
        int numCols = testPKTypes.length;
        for (int i = 0; i < numBinds; ++i) {
            for (int b = 0; b < testPKTypes.length; ++b) {
                int colIndex = startBindIndex + i * numCols + b + 1;
                switch (testPKTypes[b].getSqlType()) {
                    case 12: {
                        stmt.setString(colIndex, RandomStringUtils.randomAlphanumeric((int)25));
                        break;
                    }
                    case 1: {
                        stmt.setString(colIndex, RandomStringUtils.randomAlphanumeric((int)15));
                        break;
                    }
                    case 3: {
                        stmt.setDouble(colIndex, rnd.nextDouble());
                        break;
                    }
                    case 4: {
                        stmt.setInt(colIndex, rnd.nextInt(50000));
                        break;
                    }
                    case -5: {
                        stmt.setLong(colIndex, System.currentTimeMillis() + (long)rnd.nextInt(50000));
                        break;
                    }
                    case 91: {
                        stmt.setDate(colIndex, new Date(System.currentTimeMillis() + (long)rnd.nextInt(50000)));
                        break;
                    }
                    case 93: {
                        stmt.setTimestamp(colIndex, new Timestamp(System.currentTimeMillis() + (long)rnd.nextInt(50000)));
                        break;
                    }
                    default: {
                        stmt.setString(colIndex, RandomStringUtils.randomAlphanumeric((int)25));
                    }
                }
                lastBindCol = colIndex;
            }
        }
        return lastBindCol;
    }

    private String getType(PDataType pkType) {
        String pkTypeStr = "VARCHAR(25)";
        switch (pkType.getSqlType()) {
            case 12: {
                pkTypeStr = "VARCHAR(25)";
                break;
            }
            case 1: {
                pkTypeStr = "CHAR(15)";
                break;
            }
            case 3: {
                pkTypeStr = "DECIMAL(8,2)";
                break;
            }
            case 4: {
                pkTypeStr = "INTEGER";
                break;
            }
            case -5: {
                pkTypeStr = "BIGINT";
                break;
            }
            case 91: {
                pkTypeStr = "DATE";
                break;
            }
            case 93: {
                pkTypeStr = "TIMESTAMP";
                break;
            }
            default: {
                pkTypeStr = "VARCHAR(25)";
            }
        }
        return pkTypeStr;
    }

    private void testTSVarIntAndLargeORs(int tenantId, String viewName, SortOrder[] sortOrder) throws SQLException {
        String testName = "testLargeORs";
        String testLargeORs = String.format("SELECT ROW_ID FROM %s ", viewName);
        PDataType[] testPKTypes = new PDataType[]{PTimestamp.INSTANCE, PVarchar.INSTANCE, PInteger.INSTANCE};
        this.assertExpectedWithMaxInListAndLargeORs(tenantId, testName, testPKTypes, testLargeORs, sortOrder);
    }

    public void assertExpectedWithMaxInListAndLargeORs(int tenantId, String testType, PDataType[] testPKTypes, String testSQL, SortOrder[] sortOrder) throws SQLException {
        Properties tenantProps = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        int numINs = 25;
        int expectedExtractedNodes = Arrays.asList(sortOrder[0], sortOrder[1]).stream().allMatch(Predicate.isEqual(SortOrder.ASC)) ? 3 : 2;
        for (int o = 0; o < 4; ++o) {
            int numORs = (int)(5.0 * Math.pow(10.0, o));
            String context = "ORs:" + numORs + ", sql: " + testSQL + ", type: " + testType + ", sort-order: " + Arrays.stream(sortOrder).map(s -> s.name()).collect(Collectors.joining(","));
            String tenantConnectionUrl = String.format("%s;%s=%s%06d", WhereOptimizerTest.getUrl(), "TenantId", TENANT_PREFIX, tenantId);
            try (Connection tenantConnection = DriverManager.getConnection(tenantConnectionUrl, tenantProps);){
                int i;
                StringBuilder whereClause = new StringBuilder("(ID1,ID2) IN ((?,?)");
                for (i = 0; i < numINs; ++i) {
                    whereClause.append(",(?,?)");
                }
                whereClause.append(") AND (ID3 = ? ");
                for (i = 0; i < numORs; ++i) {
                    whereClause.append(" OR ID3 = ?");
                }
                whereClause.append(") LIMIT 200");
                String query = testSQL + " WHERE " + whereClause;
                PhoenixPreparedStatement stmtForExtractNodesCheck = tenantConnection.prepareStatement(query).unwrap(PhoenixPreparedStatement.class);
                int lastBoundCol = 0;
                lastBoundCol = this.setBindVariables(stmtForExtractNodesCheck, lastBoundCol, numINs + 1, new PDataType[]{testPKTypes[0], testPKTypes[1]});
                lastBoundCol = this.setBindVariables(stmtForExtractNodesCheck, lastBoundCol, numORs + 1, new PDataType[]{testPKTypes[2]});
                SelectStatement selectStatement = new SQLParser(query).parseQuery();
                ColumnResolver resolver = FromCompiler.getResolverForQuery((SelectStatement)selectStatement, (PhoenixConnection)tenantConnection.unwrap(PhoenixConnection.class));
                ParseNode whereNode = selectStatement.getWhere();
                Expression whereExpression = (Expression)whereNode.accept((ParseNodeVisitor)new TestWhereExpressionCompiler(new StatementContext((PhoenixStatement)stmtForExtractNodesCheck, resolver)));
                ParseNode viewWhere = SQLParser.parseCondition((String)"KP = 'ECZ'");
                Expression viewWhereExpression = (Expression)viewWhere.accept((ParseNodeVisitor)new TestWhereExpressionCompiler(new StatementContext((PhoenixStatement)stmtForExtractNodesCheck, resolver)));
                Expression testExpression = AndExpression.create((List)Lists.newArrayList((Object[])new Expression[]{whereExpression, viewWhereExpression}));
                HashSet extractedNodes = Sets.newHashSet();
                WhereOptimizer.pushKeyExpressionsToScan((StatementContext)new StatementContext((PhoenixStatement)stmtForExtractNodesCheck, resolver), Collections.emptySet(), (Expression)testExpression, (Set)extractedNodes, (Optional)Optional.absent());
                Assert.assertEquals((String)String.format("Unexpected results expected = %d, actual = %d extracted nodes", expectedExtractedNodes, extractedNodes.size()), (long)expectedExtractedNodes, (long)extractedNodes.size());
                continue;
            }
        }
    }

    private static class TestWhereExpressionCompiler
    extends ExpressionCompiler {
        private boolean disambiguateWithFamily;

        public TestWhereExpressionCompiler(StatementContext context) {
            super(context);
        }

        public Expression visit(ColumnParseNode node) throws SQLException {
            ColumnRef ref = this.resolveColumn(node);
            TableRef tableRef = ref.getTableRef();
            Expression newColumnExpression = ref.newColumnExpression(node.isTableNameCaseSensitive(), node.isCaseSensitive());
            if (tableRef.equals((Object)this.context.getCurrentTable()) && !SchemaUtil.isPKColumn((PColumn)ref.getColumn())) {
                byte[] cq = tableRef.getTable().getImmutableStorageScheme() == PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS ? QueryConstants.SINGLE_KEYVALUE_COLUMN_QUALIFIER_BYTES : ref.getColumn().getColumnQualifierBytes();
                this.context.addWhereConditionColumn(ref.getColumn().getFamilyName().getBytes(), cq);
            }
            return newColumnExpression;
        }

        protected ColumnRef resolveColumn(ColumnParseNode node) throws SQLException {
            ColumnRef ref = super.resolveColumn(node);
            if (this.disambiguateWithFamily) {
                return ref;
            }
            PTable table = ref.getTable();
            if (!SchemaUtil.isPKColumn((PColumn)ref.getColumn())) {
                if (!EncodedColumnsUtil.usesEncodedColumnNames((PTable)table) || ref.getColumn().isDynamic()) {
                    try {
                        table.getColumnForColumnName(ref.getColumn().getName().getString());
                    }
                    catch (AmbiguousColumnException e) {
                        this.disambiguateWithFamily = true;
                    }
                } else {
                    for (PColumnFamily columnFamily : table.getColumnFamilies()) {
                        if (columnFamily.getName().equals(ref.getColumn().getFamilyName())) continue;
                        try {
                            table.getColumnForColumnQualifier(columnFamily.getName().getBytes(), ref.getColumn().getColumnQualifierBytes());
                            this.disambiguateWithFamily = true;
                            break;
                        }
                        catch (ColumnNotFoundException columnNotFoundException) {
                        }
                    }
                }
            }
            return ref;
        }
    }
}

