/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.compile.WhereCompiler;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.KeyValueColumnExpression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.RowKeyColumnExpression;
import org.apache.phoenix.expression.function.SubstrFunction;
import org.apache.phoenix.filter.RowKeyComparisonFilter;
import org.apache.phoenix.filter.SkipScanFilter;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.query.BaseConnectionlessQueryTest;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.ColumnRef;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PDatum;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.RowKeyValueAccessor;
import org.apache.phoenix.schema.SaltingUtil;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.types.PChar;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.DateUtil;
import org.apache.phoenix.util.NumberUtil;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.StringUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class WhereCompilerTest
extends BaseConnectionlessQueryTest {
    private PhoenixPreparedStatement newPreparedStatement(PhoenixConnection pconn, String query) throws SQLException {
        PhoenixPreparedStatement pstmt = new PhoenixPreparedStatement(pconn, query);
        WhereCompilerTest.assertRoundtrip(query);
        return pstmt;
    }

    @Test
    public void testSingleEqualFilter() throws SQLException {
        String tenantId = "000000000000001";
        String query = "select * from atable where organization_id='" + tenantId + "' and a_integer=0";
        PhoenixConnection pconn = DriverManager.getConnection(WhereCompilerTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES)).unwrap(PhoenixConnection.class);
        PhoenixPreparedStatement pstmt = this.newPreparedStatement(pconn, query);
        QueryPlan plan = pstmt.optimizeQuery();
        Scan scan = plan.getContext().getScan();
        Filter filter = scan.getFilter();
        Assert.assertEquals((Object)TestUtil.singleKVFilter(TestUtil.constantComparison(CompareOperator.EQUAL, A_INTEGER, (Object)0)), (Object)filter);
    }

    @Test
    public void testOrPKWithAndPKAndNotPK() throws SQLException {
        String query = "select * from bugTable where ID = 'i1' or (ID = 'i2' and company = 'c3')";
        PhoenixConnection pconn = DriverManager.getConnection(WhereCompilerTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES)).unwrap(PhoenixConnection.class);
        pconn.createStatement().execute("create table bugTable(ID varchar primary key,company varchar)");
        PhoenixPreparedStatement pstmt = this.newPreparedStatement(pconn, query);
        QueryPlan plan = pstmt.optimizeQuery();
        Scan scan = plan.getContext().getScan();
        Filter filter = scan.getFilter();
        Expression idExpression = new ColumnRef(plan.getTableRef(), plan.getTableRef().getTable().getColumnForColumnName("ID").getPosition()).newColumnExpression();
        RowKeyColumnExpression id = new RowKeyColumnExpression((PDatum)idExpression, new RowKeyValueAccessor(plan.getTableRef().getTable().getPKColumns(), 0));
        KeyValueColumnExpression company = new KeyValueColumnExpression(plan.getTableRef().getTable().getColumnForColumnName("COMPANY"));
        Assert.assertTrue((boolean)(filter instanceof FilterList));
        FilterList filterList = (FilterList)filter;
        Assert.assertEquals((Object)FilterList.Operator.MUST_PASS_ALL, (Object)filterList.getOperator());
        Assert.assertEquals(Arrays.asList(new SkipScanFilter((List)ImmutableList.of(Arrays.asList(WhereCompilerTest.pointRange("i1"), WhereCompilerTest.pointRange("i2"))), SchemaUtil.VAR_BINARY_SCHEMA, false), TestUtil.singleKVFilter(TestUtil.or(TestUtil.constantComparison(CompareOperator.EQUAL, (Expression)id, (Object)"i1"), TestUtil.and(TestUtil.constantComparison(CompareOperator.EQUAL, (Expression)id, (Object)"i2"), TestUtil.constantComparison(CompareOperator.EQUAL, (Expression)company, (Object)"c3"))))), (Object)filterList.getFilters());
    }

    @Test
    public void testAndPKAndNotPK() throws SQLException {
        String query = "select * from bugTable where ID = 'i2' and company = 'c3'";
        PhoenixConnection pconn = DriverManager.getConnection(WhereCompilerTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES)).unwrap(PhoenixConnection.class);
        pconn.createStatement().execute("create table bugTable(ID varchar primary key,company varchar)");
        PhoenixPreparedStatement pstmt = this.newPreparedStatement(pconn, query);
        QueryPlan plan = pstmt.optimizeQuery();
        Scan scan = plan.getContext().getScan();
        Filter filter = scan.getFilter();
        PColumn column = plan.getTableRef().getTable().getColumnForColumnName("COMPANY");
        Assert.assertEquals((Object)TestUtil.singleKVFilter(TestUtil.constantComparison(CompareOperator.EQUAL, (Expression)new KeyValueColumnExpression(column), (Object)"c3")), (Object)filter);
    }

    @Test
    public void testSingleFixedFullPkSalted() throws SQLException {
        PhoenixConnection pconn = DriverManager.getConnection(WhereCompilerTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES)).unwrap(PhoenixConnection.class);
        pconn.createStatement().execute("CREATE TABLE t (k bigint not null primary key, v varchar) SALT_BUCKETS=20");
        String query = "select * from t where k=1";
        PhoenixPreparedStatement pstmt = this.newPreparedStatement(pconn, query);
        QueryPlan plan = pstmt.optimizeQuery();
        Scan scan = plan.getContext().getScan();
        Filter filter = scan.getFilter();
        Assert.assertNull((Object)filter);
        byte[] key = new byte[PLong.INSTANCE.getByteSize() + 1];
        PLong.INSTANCE.toBytes((Object)1L, key, 1);
        key[0] = SaltingUtil.getSaltingByte((byte[])key, (int)1, (int)PLong.INSTANCE.getByteSize(), (int)20);
        byte[] expectedStartKey = key;
        byte[] expectedEndKey = ByteUtil.nextKey((byte[])key);
        byte[] startKey = scan.getStartRow();
        byte[] stopKey = scan.getStopRow();
        Assert.assertArrayEquals((byte[])expectedStartKey, (byte[])startKey);
        Assert.assertArrayEquals((byte[])expectedEndKey, (byte[])stopKey);
    }

    @Test
    public void testSingleVariableFullPkSalted() throws SQLException {
        PhoenixConnection pconn = DriverManager.getConnection(WhereCompilerTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES)).unwrap(PhoenixConnection.class);
        pconn.createStatement().execute("CREATE TABLE t (k varchar(10) primary key, v varchar) SALT_BUCKETS=20");
        String query = "select * from t where k='a'";
        PhoenixPreparedStatement pstmt = this.newPreparedStatement(pconn, query);
        QueryPlan plan = pstmt.optimizeQuery();
        Scan scan = plan.getContext().getScan();
        Filter filter = scan.getFilter();
        Assert.assertNull((Object)filter);
        byte[] key = new byte[2];
        PVarchar.INSTANCE.toBytes((Object)"a", key, 1);
        key[0] = SaltingUtil.getSaltingByte((byte[])key, (int)1, (int)1, (int)20);
        byte[] expectedStartKey = key;
        byte[] expectedEndKey = ByteUtil.concat((byte[])key, (byte[][])new byte[][]{{0}});
        byte[] startKey = scan.getStartRow();
        byte[] stopKey = scan.getStopRow();
        Assert.assertTrue((Bytes.compareTo((byte[])expectedStartKey, (byte[])startKey) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((Bytes.compareTo((byte[])expectedEndKey, (byte[])stopKey) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testMultiFixedFullPkSalted() throws SQLException {
        byte[] expectedEndKey;
        byte[] expectedStartKey;
        PhoenixConnection pconn = DriverManager.getConnection(WhereCompilerTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES)).unwrap(PhoenixConnection.class);
        pconn.createStatement().execute("CREATE TABLE t (k bigint not null primary key, v varchar) SALT_BUCKETS=20");
        String query = "select * from t where k in (1,3)";
        PhoenixPreparedStatement pstmt = this.newPreparedStatement(pconn, query);
        QueryPlan plan = pstmt.optimizeQuery();
        Scan scan = plan.getContext().getScan();
        Filter filter = scan.getFilter();
        byte[] key = new byte[PLong.INSTANCE.getByteSize() + 1];
        PLong.INSTANCE.toBytes((Object)1L, key, 1);
        key[0] = SaltingUtil.getSaltingByte((byte[])key, (int)1, (int)PLong.INSTANCE.getByteSize(), (int)20);
        byte[] startKey1 = key;
        key = new byte[PLong.INSTANCE.getByteSize() + 1];
        PLong.INSTANCE.toBytes((Object)3L, key, 1);
        key[0] = SaltingUtil.getSaltingByte((byte[])key, (int)1, (int)PLong.INSTANCE.getByteSize(), (int)20);
        byte[] startKey2 = key;
        byte[] startKey = scan.getStartRow();
        byte[] stopKey = scan.getStopRow();
        List<List<KeyRange>> expectedRanges = Collections.singletonList(Arrays.asList(KeyRange.getKeyRange((byte[])startKey1), KeyRange.getKeyRange((byte[])startKey2)));
        if (Bytes.compareTo((byte[])startKey1, (byte[])startKey2) > 0) {
            expectedStartKey = startKey2;
            expectedEndKey = startKey1;
            Collections.reverse(expectedRanges.get(0));
        } else {
            expectedStartKey = startKey1;
            expectedEndKey = startKey2;
        }
        Assert.assertEquals((long)0L, (long)startKey.length);
        Assert.assertEquals((long)0L, (long)stopKey.length);
        Assert.assertNotNull((Object)filter);
        Assert.assertTrue((boolean)(filter instanceof SkipScanFilter));
        SkipScanFilter skipScanFilter = (SkipScanFilter)filter;
        Assert.assertEquals((long)1L, (long)skipScanFilter.getSlots().size());
        Assert.assertEquals((long)2L, (long)((List)skipScanFilter.getSlots().get(0)).size());
        Assert.assertArrayEquals((byte[])expectedStartKey, (byte[])((KeyRange)((List)skipScanFilter.getSlots().get(0)).get(0)).getLowerRange());
        Assert.assertArrayEquals((byte[])expectedEndKey, (byte[])((KeyRange)((List)skipScanFilter.getSlots().get(0)).get(1)).getLowerRange());
        StatementContext context = plan.getContext();
        ScanRanges scanRanges = context.getScanRanges();
        List ranges = scanRanges.getRanges();
        Assert.assertEquals(expectedRanges, (Object)ranges);
    }

    @Test
    public void testMultiColumnEqualFilter() throws SQLException {
        String tenantId = "000000000000001";
        String query = "select * from atable where organization_id='" + tenantId + "' and a_string=b_string";
        PhoenixConnection pconn = DriverManager.getConnection(WhereCompilerTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES)).unwrap(PhoenixConnection.class);
        PhoenixPreparedStatement pstmt = this.newPreparedStatement(pconn, query);
        QueryPlan plan = pstmt.optimizeQuery();
        Scan scan = plan.getContext().getScan();
        Filter filter = scan.getFilter();
        Assert.assertEquals((Object)TestUtil.multiEncodedKVFilter(TestUtil.columnComparison(CompareOperator.EQUAL, A_STRING, B_STRING), PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS), (Object)filter);
    }

    @Test
    public void testCollapseFunctionToNull() throws SQLException {
        String query = "select * from atable where substr(entity_id,null) = 'foo'";
        PhoenixConnection pconn = DriverManager.getConnection(WhereCompilerTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES)).unwrap(PhoenixConnection.class);
        PhoenixPreparedStatement pstmt = this.newPreparedStatement(pconn, query);
        QueryPlan plan = pstmt.optimizeQuery();
        Scan scan = plan.getContext().getScan();
        Filter filter = scan.getFilter();
        Assert.assertNull((Object)filter);
        Assert.assertArrayEquals((byte[])scan.getStartRow(), (byte[])KeyRange.EMPTY_RANGE.getLowerRange());
        Assert.assertArrayEquals((byte[])scan.getStopRow(), (byte[])KeyRange.EMPTY_RANGE.getUpperRange());
    }

    @Test
    public void testAndFilter() throws SQLException {
        String tenantId = "000000000000001";
        String query = "select * from atable where organization_id=? and a_integer=0 and a_string='foo'";
        List<Object> binds = Arrays.asList(tenantId);
        PhoenixConnection pconn = DriverManager.getConnection(WhereCompilerTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES)).unwrap(PhoenixConnection.class);
        PhoenixPreparedStatement pstmt = this.newPreparedStatement(pconn, query);
        TestUtil.bindParams(pstmt, binds);
        QueryPlan plan = pstmt.optimizeQuery();
        Scan scan = plan.getContext().getScan();
        Filter filter = scan.getFilter();
        Assert.assertEquals((Object)TestUtil.multiEncodedKVFilter(TestUtil.and(TestUtil.constantComparison(CompareOperator.EQUAL, A_INTEGER, (Object)0), TestUtil.constantComparison(CompareOperator.EQUAL, A_STRING, (Object)"foo")), PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS), (Object)filter);
    }

    @Test
    public void testRHSLiteral() throws SQLException {
        String tenantId = "000000000000001";
        String query = "select * from atable where organization_id='" + tenantId + "' and 0 >= a_integer";
        PhoenixConnection pconn = DriverManager.getConnection(WhereCompilerTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES)).unwrap(PhoenixConnection.class);
        PhoenixPreparedStatement pstmt = this.newPreparedStatement(pconn, query);
        QueryPlan plan = pstmt.optimizeQuery();
        Scan scan = plan.getContext().getScan();
        Filter filter = scan.getFilter();
        Assert.assertEquals((Object)TestUtil.singleKVFilter(TestUtil.constantComparison(CompareOperator.LESS_OR_EQUAL, A_INTEGER, (Object)0)), (Object)filter);
    }

    @Test
    public void testToDateFilter() throws Exception {
        String tenantId = "000000000000001";
        String dateStr = "2012-01-01 12:00:00";
        String query = "select * from atable where organization_id='" + tenantId + "' and a_date >= to_date('" + dateStr + "')";
        PhoenixConnection pconn = DriverManager.getConnection(WhereCompilerTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES)).unwrap(PhoenixConnection.class);
        PhoenixPreparedStatement pstmt = this.newPreparedStatement(pconn, query);
        QueryPlan plan = pstmt.optimizeQuery();
        Scan scan = plan.getContext().getScan();
        Filter filter = scan.getFilter();
        Date date = DateUtil.parseDate((String)dateStr);
        Assert.assertEquals((Object)TestUtil.singleKVFilter(TestUtil.constantComparison(CompareOperator.GREATER_OR_EQUAL, A_DATE, (Object)date)), (Object)filter);
    }

    private void helpTestToNumberFilter(String toNumberClause, BigDecimal expectedDecimal) throws Exception {
        String tenantId = "000000000000001";
        String query = "select * from atable where organization_id='" + tenantId + "' and x_decimal >= " + toNumberClause;
        PhoenixConnection pconn = DriverManager.getConnection(WhereCompilerTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES)).unwrap(PhoenixConnection.class);
        PhoenixPreparedStatement pstmt = this.newPreparedStatement(pconn, query);
        QueryPlan plan = pstmt.optimizeQuery();
        Scan scan = plan.getContext().getScan();
        Filter filter = scan.getFilter();
        Assert.assertEquals((Object)TestUtil.singleKVFilter(TestUtil.constantComparison(CompareOperator.GREATER_OR_EQUAL, X_DECIMAL, (Object)expectedDecimal)), (Object)filter);
    }

    private void helpTestToNumberFilterWithNoPattern(String stringValue) throws Exception {
        String toNumberClause = "to_number('" + stringValue + "')";
        BigDecimal expectedDecimal = NumberUtil.normalize((BigDecimal)new BigDecimal(stringValue));
        this.helpTestToNumberFilter(toNumberClause, expectedDecimal);
    }

    @Test
    public void testToNumberFilterWithInteger() throws Exception {
        String stringValue = "123";
        this.helpTestToNumberFilterWithNoPattern(stringValue);
    }

    @Test
    public void testToNumberFilterWithDecimal() throws Exception {
        String stringValue = "123.33";
        this.helpTestToNumberFilterWithNoPattern(stringValue);
    }

    @Test
    public void testToNumberFilterWithNegativeDecimal() throws Exception {
        String stringValue = "-123.33";
        this.helpTestToNumberFilterWithNoPattern(stringValue);
    }

    @Test
    public void testToNumberFilterWithPatternParam() throws Exception {
        String toNumberClause = "to_number('!1.23333E2', '!0.00000E0')";
        BigDecimal expectedDecimal = NumberUtil.normalize((BigDecimal)new BigDecimal("123.333"));
        this.helpTestToNumberFilter(toNumberClause, expectedDecimal);
    }

    @Test(expected=AssertionError.class)
    public void testToNumberFilterWithPatternParamNegativeTest() throws Exception {
        String toNumberClause = "to_number('$123.33', '000.00')";
        BigDecimal expectedDecimal = NumberUtil.normalize((BigDecimal)new BigDecimal("123.33"));
        this.helpTestToNumberFilter(toNumberClause, expectedDecimal);
    }

    @Test
    public void testRowKeyFilter() throws SQLException {
        String keyPrefix = "foo";
        String query = "select * from atable where substr(entity_id,1,3)=?";
        List<Object> binds = Arrays.asList(keyPrefix);
        PhoenixConnection pconn = DriverManager.getConnection(WhereCompilerTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES)).unwrap(PhoenixConnection.class);
        PhoenixPreparedStatement pstmt = this.newPreparedStatement(pconn, query);
        TestUtil.bindParams(pstmt, binds);
        QueryPlan plan = pstmt.optimizeQuery();
        Scan scan = plan.getContext().getScan();
        Filter filter = scan.getFilter();
        Assert.assertEquals((Object)new RowKeyComparisonFilter(TestUtil.constantComparison(CompareOperator.EQUAL, (Expression)new SubstrFunction(Arrays.asList(new RowKeyColumnExpression((PDatum)ENTITY_ID, new RowKeyValueAccessor(ATABLE.getPKColumns(), 1)), LiteralExpression.newConstant((Object)1), LiteralExpression.newConstant((Object)3))), (Object)keyPrefix), QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES), (Object)filter);
    }

    @Test
    public void testPaddedRowKeyFilter() throws SQLException {
        String keyPrefix = "fo";
        String query = "select * from atable where entity_id=?";
        List<Object> binds = Arrays.asList(keyPrefix);
        PhoenixConnection pconn = DriverManager.getConnection(WhereCompilerTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES)).unwrap(PhoenixConnection.class);
        PhoenixPreparedStatement pstmt = this.newPreparedStatement(pconn, query);
        TestUtil.bindParams(pstmt, binds);
        QueryPlan plan = pstmt.optimizeQuery();
        Scan scan = plan.getContext().getScan();
        Assert.assertEquals((long)0L, (long)scan.getStartRow().length);
        Assert.assertEquals((long)0L, (long)scan.getStopRow().length);
        Assert.assertNotNull((Object)scan.getFilter());
    }

    @Test
    public void testPaddedStartStopKey() throws SQLException {
        String tenantId = "000000000000001";
        String keyPrefix = "fo";
        String query = "select * from atable where organization_id=? AND entity_id=?";
        List<Object> binds = Arrays.asList(tenantId, keyPrefix);
        PhoenixConnection pconn = DriverManager.getConnection(WhereCompilerTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES)).unwrap(PhoenixConnection.class);
        PhoenixPreparedStatement pstmt = this.newPreparedStatement(pconn, query);
        TestUtil.bindParams(pstmt, binds);
        QueryPlan plan = pstmt.optimizeQuery();
        Scan scan = plan.getContext().getScan();
        byte[] expectedStartRow = ByteUtil.concat((byte[])Bytes.toBytes((String)tenantId), (byte[][])new byte[][]{StringUtil.padChar((byte[])Bytes.toBytes((String)keyPrefix), (Integer)15)});
        Assert.assertArrayEquals((byte[])expectedStartRow, (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])ByteUtil.nextKey((byte[])expectedStartRow), (byte[])scan.getStopRow());
    }

    @Test
    public void testDegenerateRowKeyFilter() throws SQLException {
        String keyPrefix = "foobar";
        String query = "select * from atable where substr(entity_id,1,3)=?";
        List<Object> binds = Arrays.asList(keyPrefix);
        PhoenixConnection pconn = DriverManager.getConnection(WhereCompilerTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES)).unwrap(PhoenixConnection.class);
        PhoenixPreparedStatement pstmt = this.newPreparedStatement(pconn, query);
        TestUtil.bindParams(pstmt, binds);
        QueryPlan plan = pstmt.optimizeQuery();
        TestUtil.assertDegenerate(plan.getContext());
    }

    @Test
    public void testDegenerateBiggerThanMaxLengthVarchar() throws SQLException {
        byte[] tooBigValue = new byte[101];
        Arrays.fill(tooBigValue, (byte)50);
        String aString = (String)PVarchar.INSTANCE.toObject(tooBigValue);
        String query = "select * from atable where a_string=?";
        List<Object> binds = Arrays.asList(aString);
        PhoenixConnection pconn = DriverManager.getConnection(WhereCompilerTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES)).unwrap(PhoenixConnection.class);
        PhoenixPreparedStatement pstmt = this.newPreparedStatement(pconn, query);
        TestUtil.bindParams(pstmt, binds);
        QueryPlan plan = pstmt.optimizeQuery();
        TestUtil.assertDegenerate(plan.getContext());
    }

    @Test
    public void testOrFilter() throws SQLException {
        String tenantId = "000000000000001";
        String keyPrefix = "foo";
        int aInt = 2;
        String query = "select * from atable where organization_id=? and (substr(entity_id,1,3)=? or a_integer=?)";
        List<Object> binds = Arrays.asList(tenantId, keyPrefix, aInt);
        PhoenixConnection pconn = DriverManager.getConnection(WhereCompilerTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES)).unwrap(PhoenixConnection.class);
        PhoenixPreparedStatement pstmt = this.newPreparedStatement(pconn, query);
        TestUtil.bindParams(pstmt, binds);
        QueryPlan plan = pstmt.optimizeQuery();
        Scan scan = plan.getContext().getScan();
        Filter filter = scan.getFilter();
        Assert.assertEquals((Object)TestUtil.singleKVFilter(TestUtil.or(TestUtil.constantComparison(CompareOperator.EQUAL, (Expression)new SubstrFunction(Arrays.asList(new RowKeyColumnExpression((PDatum)ENTITY_ID, new RowKeyValueAccessor(ATABLE.getPKColumns(), 1)), LiteralExpression.newConstant((Object)1), LiteralExpression.newConstant((Object)3))), (Object)keyPrefix), TestUtil.constantComparison(CompareOperator.EQUAL, A_INTEGER, (Object)aInt))), (Object)filter);
    }

    @Test
    public void testTypeMismatch() throws SQLException {
        String tenantId = "000000000000001";
        String query = "select * from atable where organization_id='" + tenantId + "' and a_integer > 'foo'";
        PhoenixConnection pconn = DriverManager.getConnection(WhereCompilerTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES)).unwrap(PhoenixConnection.class);
        PhoenixPreparedStatement pstmt = this.newPreparedStatement(pconn, query);
        try {
            pstmt.optimizeQuery();
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Type mismatch"));
        }
    }

    @Test
    public void testAndFalseFilter() throws SQLException {
        String tenantId = "000000000000001";
        String query = "select * from atable where organization_id='" + tenantId + "' and a_integer=0 and 2=3";
        PhoenixConnection pconn = DriverManager.getConnection(WhereCompilerTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES)).unwrap(PhoenixConnection.class);
        PhoenixPreparedStatement pstmt = this.newPreparedStatement(pconn, query);
        QueryPlan plan = pstmt.optimizeQuery();
        TestUtil.assertDegenerate(plan.getContext());
    }

    @Test
    public void testFalseFilter() throws SQLException {
        String tenantId = "000000000000001";
        String query = "select * from atable where organization_id='" + tenantId + "' and 2=3";
        PhoenixConnection pconn = DriverManager.getConnection(WhereCompilerTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES)).unwrap(PhoenixConnection.class);
        PhoenixPreparedStatement pstmt = this.newPreparedStatement(pconn, query);
        QueryPlan plan = pstmt.optimizeQuery();
        TestUtil.assertDegenerate(plan.getContext());
    }

    @Test
    public void testTrueFilter() throws SQLException {
        String tenantId = "000000000000001";
        String query = "select * from atable where organization_id='" + tenantId + "' and 2<=2";
        PhoenixConnection pconn = DriverManager.getConnection(WhereCompilerTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES)).unwrap(PhoenixConnection.class);
        PhoenixPreparedStatement pstmt = this.newPreparedStatement(pconn, query);
        QueryPlan plan = pstmt.optimizeQuery();
        Scan scan = plan.getContext().getScan();
        Assert.assertNull((Object)scan.getFilter());
        byte[] startRow = PVarchar.INSTANCE.toBytes((Object)tenantId);
        Assert.assertArrayEquals((byte[])startRow, (byte[])scan.getStartRow());
        byte[] stopRow = startRow;
        Assert.assertArrayEquals((byte[])ByteUtil.nextKey((byte[])stopRow), (byte[])scan.getStopRow());
    }

    @Test
    public void testAndTrueFilter() throws SQLException {
        String tenantId = "000000000000001";
        String query = "select * from atable where organization_id='" + tenantId + "' and a_integer=0 and 2<3";
        PhoenixConnection pconn = DriverManager.getConnection(WhereCompilerTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES)).unwrap(PhoenixConnection.class);
        PhoenixPreparedStatement pstmt = this.newPreparedStatement(pconn, query);
        QueryPlan plan = pstmt.optimizeQuery();
        Scan scan = plan.getContext().getScan();
        Filter filter = scan.getFilter();
        Assert.assertEquals((Object)TestUtil.singleKVFilter(TestUtil.constantComparison(CompareOperator.EQUAL, A_INTEGER, (Object)0)), (Object)filter);
        byte[] startRow = PVarchar.INSTANCE.toBytes((Object)tenantId);
        Assert.assertArrayEquals((byte[])startRow, (byte[])scan.getStartRow());
        byte[] stopRow = startRow;
        Assert.assertArrayEquals((byte[])ByteUtil.nextKey((byte[])stopRow), (byte[])scan.getStopRow());
    }

    @Test
    public void testOrFalseFilter() throws SQLException {
        String tenantId = "000000000000001";
        String query = "select * from atable where organization_id='" + tenantId + "' and (a_integer=0 or 3!=3)";
        PhoenixConnection pconn = DriverManager.getConnection(WhereCompilerTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES)).unwrap(PhoenixConnection.class);
        PhoenixPreparedStatement pstmt = this.newPreparedStatement(pconn, query);
        QueryPlan plan = pstmt.optimizeQuery();
        Scan scan = plan.getContext().getScan();
        Filter filter = scan.getFilter();
        Assert.assertEquals((Object)TestUtil.singleKVFilter(TestUtil.constantComparison(CompareOperator.EQUAL, A_INTEGER, (Object)0)), (Object)filter);
        byte[] startRow = PVarchar.INSTANCE.toBytes((Object)tenantId);
        Assert.assertArrayEquals((byte[])startRow, (byte[])scan.getStartRow());
        byte[] stopRow = startRow;
        Assert.assertArrayEquals((byte[])ByteUtil.nextKey((byte[])stopRow), (byte[])scan.getStopRow());
    }

    @Test
    public void testOrTrueFilter() throws SQLException {
        String tenantId = "000000000000001";
        String query = "select * from atable where organization_id='" + tenantId + "' and (a_integer=0 or 3>2)";
        PhoenixConnection pconn = DriverManager.getConnection(WhereCompilerTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES)).unwrap(PhoenixConnection.class);
        PhoenixPreparedStatement pstmt = this.newPreparedStatement(pconn, query);
        QueryPlan plan = pstmt.optimizeQuery();
        Scan scan = plan.getContext().getScan();
        Filter filter = scan.getFilter();
        Assert.assertNull((Object)filter);
        byte[] startRow = PVarchar.INSTANCE.toBytes((Object)tenantId);
        Assert.assertArrayEquals((byte[])startRow, (byte[])scan.getStartRow());
        byte[] stopRow = startRow;
        Assert.assertArrayEquals((byte[])ByteUtil.nextKey((byte[])stopRow), (byte[])scan.getStopRow());
    }

    @Test
    public void testInFilter() throws SQLException {
        String tenantId = "000000000000001";
        String query = "select * from atable where organization_id='" + tenantId + "' and a_string IN ('a','b')";
        PhoenixConnection pconn = DriverManager.getConnection(WhereCompilerTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES)).unwrap(PhoenixConnection.class);
        PhoenixPreparedStatement pstmt = this.newPreparedStatement(pconn, query);
        QueryPlan plan = pstmt.optimizeQuery();
        Scan scan = plan.getContext().getScan();
        byte[] startRow = PVarchar.INSTANCE.toBytes((Object)tenantId);
        Assert.assertArrayEquals((byte[])startRow, (byte[])scan.getStartRow());
        byte[] stopRow = startRow;
        Assert.assertArrayEquals((byte[])ByteUtil.nextKey((byte[])stopRow), (byte[])scan.getStopRow());
        Filter filter = scan.getFilter();
        Assert.assertEquals((Object)TestUtil.singleKVFilter(TestUtil.in(A_STRING, "a", "b")), (Object)filter);
    }

    @Test
    public void testInListFilter() throws SQLException {
        String tenantId1 = "000000000000001";
        String tenantId2 = "000000000000002";
        String tenantId3 = "000000000000003";
        String query = String.format("select * from %s where organization_id IN ('%s','%s','%s')", "ATABLE", tenantId1, tenantId3, tenantId2);
        PhoenixConnection pconn = DriverManager.getConnection(WhereCompilerTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES)).unwrap(PhoenixConnection.class);
        PhoenixPreparedStatement pstmt = this.newPreparedStatement(pconn, query);
        QueryPlan plan = pstmt.optimizeQuery();
        Scan scan = plan.getContext().getScan();
        byte[] startRow = PVarchar.INSTANCE.toBytes((Object)tenantId1);
        Assert.assertArrayEquals((byte[])startRow, (byte[])scan.getStartRow());
        byte[] stopRow = PVarchar.INSTANCE.toBytes((Object)tenantId3);
        Assert.assertArrayEquals((byte[])ByteUtil.nextKey((byte[])stopRow), (byte[])scan.getStopRow());
        Filter filter = scan.getFilter();
        Assert.assertEquals((Object)new SkipScanFilter((List)ImmutableList.of(Arrays.asList(WhereCompilerTest.pointRange(tenantId1), WhereCompilerTest.pointRange(tenantId2), WhereCompilerTest.pointRange(tenantId3))), plan.getTableRef().getTable().getRowKeySchema(), false), (Object)filter);
    }

    @Test
    @Ignore(value="OR not yet optimized")
    public void testOr2InFilter() throws SQLException {
        String tenantId1 = "000000000000001";
        String tenantId2 = "000000000000002";
        String tenantId3 = "000000000000003";
        String query = String.format("select * from %s where organization_id='%s' OR organization_id='%s' OR organization_id='%s'", "ATABLE", tenantId1, tenantId3, tenantId2);
        PhoenixConnection pconn = DriverManager.getConnection(WhereCompilerTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES)).unwrap(PhoenixConnection.class);
        PhoenixPreparedStatement pstmt = this.newPreparedStatement(pconn, query);
        QueryPlan plan = pstmt.optimizeQuery();
        Scan scan = plan.getContext().getScan();
        Filter filter = scan.getFilter();
        Assert.assertEquals((Object)new SkipScanFilter((List)ImmutableList.of(Arrays.asList(WhereCompilerTest.pointRange(tenantId1), WhereCompilerTest.pointRange(tenantId2), WhereCompilerTest.pointRange(tenantId3))), plan.getTableRef().getTable().getRowKeySchema(), false), (Object)filter);
        byte[] startRow = PVarchar.INSTANCE.toBytes((Object)tenantId1);
        Assert.assertArrayEquals((byte[])startRow, (byte[])scan.getStartRow());
        byte[] stopRow = PVarchar.INSTANCE.toBytes((Object)tenantId3);
        Assert.assertArrayEquals((byte[])ByteUtil.nextKey((byte[])stopRow), (byte[])scan.getStopRow());
    }

    @Test
    public void testSecondPkColInListFilter() throws SQLException {
        String tenantId = "000000000000001";
        String entityId1 = "00000000000000X";
        String entityId2 = "00000000000000Y";
        String query = String.format("select * from %s where organization_id='%s' AND entity_id IN ('%s','%s')", "ATABLE", tenantId, entityId1, entityId2);
        PhoenixConnection pconn = DriverManager.getConnection(WhereCompilerTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES)).unwrap(PhoenixConnection.class);
        PhoenixPreparedStatement pstmt = this.newPreparedStatement(pconn, query);
        QueryPlan plan = pstmt.optimizeQuery();
        Scan scan = plan.getContext().getScan();
        byte[] startRow = PVarchar.INSTANCE.toBytes((Object)(tenantId + entityId1));
        Assert.assertArrayEquals((byte[])startRow, (byte[])scan.getStartRow());
        byte[] stopRow = PVarchar.INSTANCE.toBytes((Object)(tenantId + entityId2));
        Assert.assertArrayEquals((byte[])ByteUtil.concat((byte[])stopRow, (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY}), (byte[])scan.getStopRow());
        Filter filter = scan.getFilter();
        Assert.assertEquals((Object)new SkipScanFilter((List)ImmutableList.of(Arrays.asList(WhereCompilerTest.pointRange(tenantId, entityId1), WhereCompilerTest.pointRange(tenantId, entityId2))), SchemaUtil.VAR_BINARY_SCHEMA, false), (Object)filter);
    }

    @Test
    public void testInListWithAnd1GTEFilter() throws SQLException {
        String tenantId1 = "000000000000001";
        String tenantId2 = "000000000000002";
        String tenantId3 = "000000000000003";
        String entityId1 = "00000000000000X";
        String entityId2 = "00000000000000Y";
        String query = String.format("select * from %s where organization_id IN ('%s','%s','%s') AND entity_id>='%s' AND entity_id<='%s'", "ATABLE", tenantId1, tenantId3, tenantId2, entityId1, entityId2);
        PhoenixConnection pconn = DriverManager.getConnection(WhereCompilerTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES)).unwrap(PhoenixConnection.class);
        PhoenixPreparedStatement pstmt = this.newPreparedStatement(pconn, query);
        QueryPlan plan = pstmt.optimizeQuery();
        Scan scan = plan.getContext().getScan();
        Filter filter = scan.getFilter();
        Assert.assertEquals((Object)new SkipScanFilter((List)ImmutableList.of(Arrays.asList(WhereCompilerTest.pointRange(tenantId1), WhereCompilerTest.pointRange(tenantId2), WhereCompilerTest.pointRange(tenantId3)), Arrays.asList(PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)entityId1), true, Bytes.toBytes((String)entityId2), true, SortOrder.ASC))), plan.getTableRef().getTable().getRowKeySchema(), false), (Object)filter);
    }

    @Test
    public void testInListWithAnd1Filter() throws SQLException {
        String tenantId1 = "000000000000001";
        String tenantId2 = "000000000000002";
        String tenantId3 = "000000000000003";
        String entityId = "00000000000000X";
        String query = String.format("select * from %s where organization_id IN ('%s','%s','%s') AND entity_id='%s'", "ATABLE", tenantId1, tenantId3, tenantId2, entityId);
        PhoenixConnection pconn = DriverManager.getConnection(WhereCompilerTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES)).unwrap(PhoenixConnection.class);
        PhoenixPreparedStatement pstmt = this.newPreparedStatement(pconn, query);
        QueryPlan plan = pstmt.optimizeQuery();
        Scan scan = plan.getContext().getScan();
        Filter filter = scan.getFilter();
        Assert.assertEquals((Object)new SkipScanFilter((List)ImmutableList.of(Arrays.asList(WhereCompilerTest.pointRange(tenantId1, entityId), WhereCompilerTest.pointRange(tenantId2, entityId), WhereCompilerTest.pointRange(tenantId3, entityId))), SchemaUtil.VAR_BINARY_SCHEMA, false), (Object)filter);
    }

    @Test
    public void testInListWithAnd1FilterScankey() throws SQLException {
        String tenantId1 = "000000000000001";
        String tenantId2 = "000000000000002";
        String tenantId3 = "000000000000003";
        String entityId = "00000000000000X";
        String query = String.format("select * from %s where organization_id IN ('%s','%s','%s') AND entity_id='%s'", "ATABLE", tenantId1, tenantId3, tenantId2, entityId);
        PhoenixConnection pconn = DriverManager.getConnection(WhereCompilerTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES)).unwrap(PhoenixConnection.class);
        PhoenixPreparedStatement pstmt = this.newPreparedStatement(pconn, query);
        QueryPlan plan = pstmt.optimizeQuery();
        Scan scan = plan.getContext().getScan();
        byte[] startRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId1), (byte[][])new byte[][]{PVarchar.INSTANCE.toBytes((Object)entityId)});
        Assert.assertArrayEquals((byte[])startRow, (byte[])scan.getStartRow());
        byte[] stopRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId3), (byte[][])new byte[][]{PVarchar.INSTANCE.toBytes((Object)entityId)});
        Assert.assertArrayEquals((byte[])ByteUtil.concat((byte[])stopRow, (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY}), (byte[])scan.getStopRow());
    }

    private static KeyRange pointRange(String ... ids) {
        byte[] theKey = ByteUtil.EMPTY_BYTE_ARRAY;
        for (String id : ids) {
            theKey = ByteUtil.concat((byte[])theKey, (byte[][])new byte[][]{Bytes.toBytes((String)id)});
        }
        return WhereCompilerTest.pointRange(theKey);
    }

    private static KeyRange pointRange(byte[] bytes) {
        return (KeyRange)KeyRange.POINT.apply((Object)bytes);
    }

    @Test
    public void testInListWithAnd2Filter() throws SQLException {
        String tenantId1 = "000000000000001";
        String tenantId2 = "000000000000002";
        String entityId1 = "00000000000000X";
        String entityId2 = "00000000000000Y";
        String query = String.format("select * from %s where organization_id IN ('%s','%s') AND entity_id IN ('%s', '%s')", "ATABLE", tenantId1, tenantId2, entityId1, entityId2);
        PhoenixConnection pconn = DriverManager.getConnection(WhereCompilerTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES)).unwrap(PhoenixConnection.class);
        PhoenixPreparedStatement pstmt = this.newPreparedStatement(pconn, query);
        QueryPlan plan = pstmt.optimizeQuery();
        Scan scan = plan.getContext().getScan();
        Filter filter = scan.getFilter();
        Assert.assertEquals((Object)new SkipScanFilter((List)ImmutableList.of((Object)ImmutableList.of((Object)WhereCompilerTest.pointRange(tenantId1, entityId1), (Object)WhereCompilerTest.pointRange(tenantId1, entityId2), (Object)WhereCompilerTest.pointRange(tenantId2, entityId1), (Object)WhereCompilerTest.pointRange(tenantId2, entityId2))), SchemaUtil.VAR_BINARY_SCHEMA, false), (Object)filter);
    }

    @Test
    public void testPartialRangeFilter() throws SQLException {
        String tenantId1 = "001";
        String tenantId2 = "02";
        String query = String.format("select * from %s where organization_id > '%s' AND organization_id < '%s'", "ATABLE", tenantId1, tenantId2);
        PhoenixConnection pconn = DriverManager.getConnection(WhereCompilerTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES)).unwrap(PhoenixConnection.class);
        PhoenixPreparedStatement pstmt = this.newPreparedStatement(pconn, query);
        QueryPlan plan = pstmt.optimizeQuery();
        Scan scan = plan.getContext().getScan();
        Assert.assertNull((Object)scan.getFilter());
        byte[] wideLower = ByteUtil.nextKey((byte[])StringUtil.padChar((byte[])Bytes.toBytes((String)tenantId1), (Integer)15));
        byte[] wideUpper = StringUtil.padChar((byte[])Bytes.toBytes((String)tenantId2), (Integer)15);
        Assert.assertArrayEquals((byte[])wideLower, (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])wideUpper, (byte[])scan.getStopRow());
    }

    @Test
    public void testInListWithAnd2FilterScanKey() throws SQLException {
        String tenantId1 = "000000000000001";
        String tenantId2 = "000000000000002";
        String tenantId3 = "000000000000003";
        String entityId1 = "00000000000000X";
        String entityId2 = "00000000000000Y";
        String query = String.format("select * from %s where organization_id IN ('%s','%s','%s') AND entity_id IN ('%s', '%s')", "ATABLE", tenantId1, tenantId3, tenantId2, entityId1, entityId2);
        PhoenixConnection pconn = DriverManager.getConnection(WhereCompilerTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES)).unwrap(PhoenixConnection.class);
        PhoenixPreparedStatement pstmt = this.newPreparedStatement(pconn, query);
        QueryPlan plan = pstmt.optimizeQuery();
        Scan scan = plan.getContext().getScan();
        byte[] startRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId1), (byte[][])new byte[][]{PVarchar.INSTANCE.toBytes((Object)entityId1)});
        Assert.assertArrayEquals((byte[])startRow, (byte[])scan.getStartRow());
        byte[] stopRow = ByteUtil.concat((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId3), (byte[][])new byte[][]{PVarchar.INSTANCE.toBytes((Object)entityId2)});
        Assert.assertArrayEquals((byte[])ByteUtil.concat((byte[])stopRow, (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY}), (byte[])scan.getStopRow());
    }

    @Test
    public void testBetweenFilter() throws SQLException {
        String tenantId = "000000000000001";
        String query = "select * from atable where organization_id='" + tenantId + "' and a_integer between 0 and 10";
        PhoenixConnection pconn = DriverManager.getConnection(WhereCompilerTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES)).unwrap(PhoenixConnection.class);
        PhoenixPreparedStatement pstmt = this.newPreparedStatement(pconn, query);
        QueryPlan plan = pstmt.optimizeQuery();
        Scan scan = plan.getContext().getScan();
        Filter filter = scan.getFilter();
        Assert.assertEquals((Object)TestUtil.singleKVFilter(TestUtil.and(TestUtil.constantComparison(CompareOperator.GREATER_OR_EQUAL, A_INTEGER, (Object)0), TestUtil.constantComparison(CompareOperator.LESS_OR_EQUAL, A_INTEGER, (Object)10))), (Object)filter);
    }

    @Test
    public void testNotBetweenFilter() throws SQLException {
        String tenantId = "000000000000001";
        String query = "select * from atable where organization_id='" + tenantId + "' and a_integer not between 0 and 10";
        PhoenixConnection pconn = DriverManager.getConnection(WhereCompilerTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES)).unwrap(PhoenixConnection.class);
        PhoenixPreparedStatement pstmt = this.newPreparedStatement(pconn, query);
        QueryPlan plan = pstmt.optimizeQuery();
        Scan scan = plan.getContext().getScan();
        Filter filter = scan.getFilter();
        Assert.assertEquals((Object)TestUtil.singleKVFilter(TestUtil.not(TestUtil.and(TestUtil.constantComparison(CompareOperator.GREATER_OR_EQUAL, A_INTEGER, (Object)0), TestUtil.constantComparison(CompareOperator.LESS_OR_EQUAL, A_INTEGER, (Object)10)))).toString(), (Object)filter.toString());
    }

    @Test
    public void testTenantConstraintsAddedToScan() throws SQLException {
        String tenantTypeId = "5678";
        String tenantId = "000000000000123";
        String url = WhereCompilerTest.getUrl(tenantId);
        WhereCompilerTest.createTestTable(WhereCompilerTest.getUrl(), "create table base_table_for_tenant_filter_test (tenant_id char(15) not null, type_id char(4) not null, id char(5) not null, a_integer integer, a_string varchar(100) constraint pk primary key (tenant_id, type_id, id)) multi_tenant=true");
        WhereCompilerTest.createTestTable(url, "create view tenant_filter_test (tenant_col integer) AS SELECT * FROM BASE_TABLE_FOR_TENANT_FILTER_TEST WHERE type_id= '" + tenantTypeId + "'");
        String query = "select * from tenant_filter_test where a_integer=0 and a_string='foo'";
        PhoenixConnection pconn = DriverManager.getConnection(url, PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES)).unwrap(PhoenixConnection.class);
        PhoenixPreparedStatement pstmt = this.newPreparedStatement(pconn, query);
        QueryPlan plan = pstmt.optimizeQuery();
        Scan scan = plan.getContext().getScan();
        Filter filter = scan.getFilter();
        PTable table = plan.getTableRef().getTable();
        Expression aInteger = new ColumnRef(new TableRef(table), table.getColumnForColumnName("A_INTEGER").getPosition()).newColumnExpression();
        Expression aString = new ColumnRef(new TableRef(table), table.getColumnForColumnName("A_STRING").getPosition()).newColumnExpression();
        Assert.assertEquals((Object)TestUtil.multiEncodedKVFilter(TestUtil.and(TestUtil.constantComparison(CompareOperator.EQUAL, aInteger, (Object)0), TestUtil.constantComparison(CompareOperator.EQUAL, aString, (Object)"foo")), PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS), (Object)filter);
        byte[] startRow = PVarchar.INSTANCE.toBytes((Object)(tenantId + tenantTypeId));
        Assert.assertArrayEquals((byte[])startRow, (byte[])scan.getStartRow());
        byte[] stopRow = startRow;
        Assert.assertArrayEquals((byte[])ByteUtil.nextKey((byte[])stopRow), (byte[])scan.getStopRow());
    }

    @Test
    public void testTenantConstraintsAddedToScanWithNullTenantTypeId() throws SQLException {
        String tenantId = "000000000000123";
        WhereCompilerTest.createTestTable(WhereCompilerTest.getUrl(), "create table base_table_for_tenant_filter_test (tenant_id char(15) not null, id char(5) not null, a_integer integer, a_string varchar(100) constraint pk primary key (tenant_id, id)) multi_tenant=true");
        WhereCompilerTest.createTestTable(WhereCompilerTest.getUrl(tenantId), "create view tenant_filter_test (tenant_col integer) AS SELECT * FROM BASE_TABLE_FOR_TENANT_FILTER_TEST");
        String query = "select * from tenant_filter_test where a_integer=0 and a_string='foo'";
        PhoenixConnection pconn = DriverManager.getConnection(WhereCompilerTest.getUrl(tenantId), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES)).unwrap(PhoenixConnection.class);
        PhoenixPreparedStatement pstmt = this.newPreparedStatement(pconn, query);
        QueryPlan plan = pstmt.optimizeQuery();
        Scan scan = plan.getContext().getScan();
        Filter filter = scan.getFilter();
        PTable table = plan.getTableRef().getTable();
        Expression aInteger = new ColumnRef(new TableRef(table), table.getColumnForColumnName("A_INTEGER").getPosition()).newColumnExpression();
        Expression aString = new ColumnRef(new TableRef(table), table.getColumnForColumnName("A_STRING").getPosition()).newColumnExpression();
        Assert.assertEquals((Object)TestUtil.multiEncodedKVFilter(TestUtil.and(TestUtil.constantComparison(CompareOperator.EQUAL, aInteger, (Object)0), TestUtil.constantComparison(CompareOperator.EQUAL, aString, (Object)"foo")), PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS), (Object)filter);
        byte[] startRow = PVarchar.INSTANCE.toBytes((Object)tenantId);
        Assert.assertArrayEquals((byte[])startRow, (byte[])scan.getStartRow());
        byte[] stopRow = startRow;
        Assert.assertArrayEquals((byte[])ByteUtil.nextKey((byte[])stopRow), (byte[])scan.getStopRow());
    }

    @Test
    public void testScanCaching_Default() throws SQLException {
        String query = "select * from atable where a_integer=0";
        PhoenixConnection pconn = DriverManager.getConnection(WhereCompilerTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES)).unwrap(PhoenixConnection.class);
        PhoenixPreparedStatement pstmt = this.newPreparedStatement(pconn, query);
        QueryPlan plan = pstmt.optimizeQuery();
        Scan scan = plan.getContext().getScan();
        Configuration config = HBaseConfiguration.create();
        int defaultScannerCacheSize = config.getInt("hbase.client.scanner.caching", Integer.MAX_VALUE);
        Assert.assertEquals((long)defaultScannerCacheSize, (long)pstmt.getFetchSize());
        Assert.assertEquals((long)defaultScannerCacheSize, (long)scan.getCaching());
    }

    @Test
    public void testScanCaching_CustomFetchSizeOnStatement() throws SQLException {
        String query = "select * from atable where a_integer=0";
        PhoenixConnection pconn = DriverManager.getConnection(WhereCompilerTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES)).unwrap(PhoenixConnection.class);
        PhoenixPreparedStatement pstmt = this.newPreparedStatement(pconn, query);
        int FETCH_SIZE = 25;
        pstmt.setFetchSize(25);
        QueryPlan plan = pstmt.optimizeQuery();
        Scan scan = plan.getContext().getScan();
        Assert.assertEquals((long)25L, (long)pstmt.getFetchSize());
        Assert.assertEquals((long)25L, (long)scan.getCaching());
    }

    private Expression getDNF(PhoenixConnection pconn, String query) throws SQLException {
        PhoenixPreparedStatement pstmt = this.newPreparedStatement(pconn, query);
        QueryPlan plan = pstmt.compileQuery();
        ParseNode where = plan.getStatement().getWhere();
        return WhereCompiler.transformDNF((ParseNode)where, (StatementContext)plan.getContext());
    }

    @Test
    public void testWhereInclusion() throws SQLException {
        PhoenixConnection pconn = DriverManager.getConnection(WhereCompilerTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES)).unwrap(PhoenixConnection.class);
        String ddl = "create table myTable(ID varchar primary key, A integer, B varchar, C date, D double, E integer, F json, G varbinary, H varbinary_encoded)";
        pconn.createStatement().execute(ddl);
        ddl = "create table myTableDesc(ID varchar primary key DESC, A integer, B varchar, C date, D double, E integer, F json, G varbinary, H varbinary_encoded)";
        pconn.createStatement().execute(ddl);
        int NUM = 25;
        String[] containingQueries = new String[25];
        String[] containedQueries = new String[25];
        containingQueries[0] = "select * from myTable where ID = 'i1' or (ID = 'i2' and A > 1)";
        containedQueries[0] = "select * from myTableDesc where ID = 'i1' or (ID = 'i2' and A > 2 + 2)";
        containingQueries[1] = "select * from myTable where ID > 'i3' and A > 1";
        containedQueries[1] = "select * from myTableDesc where (ID > 'i7' or ID = 'i4') and A > 2 * 10";
        containingQueries[2] = "select * from myTable where ID IN ('i3', 'i7', 'i1') and A < 10";
        containedQueries[2] = "select * from myTableDesc where ID IN ('i1', 'i7') and A < 10 / 2";
        containingQueries[3] = "select * from myTableDesc where (ID, B) > ('i3', 'a') and A >= 10";
        containedQueries[3] = "select * from myTable where ID = 'i3' and B = 'c' and A = 10";
        containingQueries[4] = "select * from myTable where ID >= 'i3' and A between 5 and 15";
        containedQueries[4] = "select * from myTableDesc where ID = 'i3' and A between 5 and 10";
        containingQueries[5] = "select * from myTable where (A between 5 and 15) and (D < 10.67 or C <= CURRENT_DATE())";
        containedQueries[5] = "select * from myTable where (A = 5 and D between 1.5 and 9.99) or (A = 6 and C <= CURRENT_DATE() - 1000)";
        containingQueries[6] = "select * from myTable where A is not null";
        containedQueries[6] = "select * from myTable where A > 0";
        containingQueries[7] = "select * from myTable where NOT (B is null)";
        containedQueries[7] = "select * from myTable where (B > 'abc')";
        containingQueries[8] = "select * from myTable where A >= E and D <= A";
        containedQueries[8] = "select * from myTable where (A > E and D = A)";
        containingQueries[9] = "select * from myTable where A > E";
        containedQueries[9] = "select * from myTable where (A > E  and B is not null)";
        containingQueries[10] = "select * from myTable where B like '%abc'";
        containedQueries[10] = "select * from myTable where (B like '%abc' and ID > 'i1')";
        containingQueries[11] = "select * from myTable where PHOENIX_ROW_TIMESTAMP() < CURRENT_TIME()";
        containedQueries[11] = "select * from myTable where (PHOENIX_ROW_TIMESTAMP() < CURRENT_TIME() - 1)";
        containingQueries[12] = "select * from myTable where (A, E) IN ((2,3), (7,8), (10,11))";
        containedQueries[12] = "select * from myTable where (A, E) IN ((2,3), (7,8))";
        containingQueries[13] = "select * from myTable where ID > 'i3' and ID < 'i5'";
        containedQueries[13] = "select * from myTable where (ID = 'i4') ";
        containingQueries[14] = "select * from myTable where CURRENT_DATE() - PHOENIX_ROW_TIMESTAMP() < 10";
        containedQueries[14] = "select * from myTable where  CURRENT_DATE() - PHOENIX_ROW_TIMESTAMP() < 5 ";
        containingQueries[15] = "select * from myTable where ID > 'i3' and A > 1 and JSON_VALUE(F, '$.type') > 'i3'";
        containedQueries[15] = "select * from myTableDesc where (ID > 'i7' or ID = 'i4') and A > 2 * 10 and (JSON_VALUE(F, '$.type') > 'i7' or JSON_VALUE(F, '$.type') = 'i4')";
        containingQueries[16] = "select * from myTable where JSON_VALUE(F, '$.type') is not null";
        containedQueries[16] = "select * from myTable where JSON_VALUE(F, '$.type') > 'i3'";
        containingQueries[17] = "select * from myTable where JSON_VALUE(F, '$.type') like '%abc'";
        containedQueries[17] = "select * from myTable where (JSON_VALUE(F, '$.type') like '%abc' and ID > 'i1')";
        containingQueries[18] = "select * from myTable where JSON_EXISTS(F, '$.type')";
        containedQueries[18] = "select * from myTable where JSON_EXISTS(F, '$.type') and JSON_VALUE(F, '$.type') > 'i3'";
        containingQueries[19] = "select * from myTable where JSON_VALUE(F, '$.type') IN ('i3', 'i7', 'i1') and A < 10";
        containedQueries[19] = "select * from myTableDesc where JSON_VALUE(F, '$.type') IN ('i1', 'i7') and A < 10 / 2";
        String val1 = Base64.getEncoder().encodeToString(Bytes.toBytes((String)"Hello"));
        String val2 = Base64.getEncoder().encodeToString(Bytes.toBytes((String)"Hello1"));
        String val3 = Base64.getEncoder().encodeToString(Bytes.toBytes((String)"Hello2"));
        containingQueries[20] = "select * from myTable where ID = 'i1' or (ID = 'i2' and G > '" + val1 + "')";
        containedQueries[20] = "select * from myTable where ID = 'i1' or (ID = 'i2' and G > '" + val2 + "')";
        containingQueries[21] = "select * from myTable where ID = 'i1' or (ID = 'i2' and H > '" + val1 + "')";
        containedQueries[21] = "select * from myTable where ID = 'i1' or (ID = 'i2' and H > '" + val2 + "')";
        containingQueries[22] = "select * from myTable where G > '" + val1 + "' and G < '" + val3 + "'";
        containedQueries[22] = "select * from myTable where (G = '" + val2 + "') ";
        containingQueries[23] = "select * from myTable where H > '" + val1 + "' and H < '" + val3 + "'";
        containedQueries[23] = "select * from myTable where (H = '" + val2 + "') ";
        containingQueries[24] = "select * from myTable where (G, H) IN (('" + val1 + "', '" + val2 + "'), ('" + val1 + "', '" + val3 + "'), ('" + val2 + "', '" + val3 + "'))";
        containedQueries[24] = "select * from myTable where (G, H) IN (('" + val1 + "', '" + val3 + "'), ('" + val2 + "', '" + val3 + "'))";
        for (int i = 0; i < 25; ++i) {
            Assert.assertTrue((String)("Containing query: " + containingQueries[i] + " , Contained query: " + containedQueries[i]), (boolean)WhereCompiler.contains((Expression)this.getDNF(pconn, containingQueries[i]), (Expression)this.getDNF(pconn, containedQueries[i])));
            Assert.assertFalse((String)("Containing query: " + containingQueries[i] + " , Contained query: " + containedQueries[i]), (boolean)WhereCompiler.contains((Expression)this.getDNF(pconn, containedQueries[i]), (Expression)this.getDNF(pconn, containingQueries[i])));
        }
    }
}

