/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.query.BaseConnectionlessQueryTest;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;

public class SelectStatementRewriterTest
extends BaseConnectionlessQueryTest {
    private static Filter compileStatement(String query) throws SQLException {
        PhoenixConnection pconn = DriverManager.getConnection(SelectStatementRewriterTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES)).unwrap(PhoenixConnection.class);
        PhoenixPreparedStatement pstmt = new PhoenixPreparedStatement(pconn, query);
        QueryPlan plan = pstmt.compileQuery();
        return plan.getContext().getScan().getFilter();
    }

    @Test
    public void testCollapseAnd() throws SQLException {
        String tenantId = "000000000000001";
        String query = "select * from atable where organization_id='" + tenantId + "' and a_integer=0";
        Filter filter = SelectStatementRewriterTest.compileStatement(query);
        Assert.assertEquals((Object)TestUtil.singleKVFilter(TestUtil.constantComparison(CompareOperator.EQUAL, A_INTEGER, (Object)0)), (Object)filter);
    }

    @Test
    public void testLHSLiteralCollapseAnd() throws SQLException {
        String tenantId = "000000000000001";
        String query = "select * from atable where '" + tenantId + "'=organization_id and 0=a_integer";
        Filter filter = SelectStatementRewriterTest.compileStatement(query);
        Assert.assertEquals((Object)TestUtil.singleKVFilter(TestUtil.constantComparison(CompareOperator.EQUAL, A_INTEGER, (Object)0)), (Object)filter);
    }

    @Test
    public void testRewriteAnd() throws SQLException {
        String tenantId = "000000000000001";
        String query = "select * from atable where organization_id='" + tenantId + "' and a_integer=0 and a_string='foo'";
        Filter filter = SelectStatementRewriterTest.compileStatement(query);
        Assert.assertEquals((Object)TestUtil.multiEncodedKVFilter(TestUtil.and(TestUtil.constantComparison(CompareOperator.EQUAL, A_INTEGER, (Object)0), TestUtil.constantComparison(CompareOperator.EQUAL, A_STRING, (Object)"foo")), PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS), (Object)filter);
    }

    @Test
    public void testCollapseWhere() throws SQLException {
        String tenantId = "000000000000001";
        String query = "select * from atable where organization_id='" + tenantId + "' and substr(organization_id,1,3)='foo' LIMIT 2";
        Filter filter = SelectStatementRewriterTest.compileStatement(query);
        Assert.assertNull((Object)filter);
    }

    @Test
    public void testNoCollapse() throws SQLException {
        String query = "select * from atable where a_integer=0 and a_string='foo'";
        Filter filter = SelectStatementRewriterTest.compileStatement(query);
        Assert.assertEquals((Object)TestUtil.multiEncodedKVFilter(TestUtil.and(TestUtil.constantComparison(CompareOperator.EQUAL, A_INTEGER, (Object)0), TestUtil.constantComparison(CompareOperator.EQUAL, A_STRING, (Object)"foo")), PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS), (Object)filter);
    }
}

