/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.schema.PDatum;
import org.apache.phoenix.schema.RowKeySchema;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PChar;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.thirdparty.com.google.common.base.Function;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.ByteUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ScanRangesTest {
    private final ScanRanges scanRanges;
    private final KeyRange keyRange;
    private final boolean expectedResult;
    private static final Function<KeyRange[], List<KeyRange>> ARRAY_TO_LIST = new Function<KeyRange[], List<KeyRange>>(){

        public List<KeyRange> apply(KeyRange[] input) {
            return Lists.newArrayList((Object[])input);
        }
    };

    public ScanRangesTest(ScanRanges scanRanges, int[] widths, KeyRange keyRange, boolean expectedResult) {
        this.keyRange = keyRange;
        this.scanRanges = scanRanges;
        this.expectedResult = expectedResult;
    }

    @Test
    public void test() {
        byte[] lowerInclusiveKey = this.keyRange.getLowerRange();
        if (!this.keyRange.isLowerInclusive() && !Bytes.equals((byte[])lowerInclusiveKey, (byte[])KeyRange.UNBOUND)) {
            lowerInclusiveKey = ByteUtil.nextKey((byte[])lowerInclusiveKey);
        }
        byte[] upperExclusiveKey = this.keyRange.getUpperRange();
        if (this.keyRange.isUpperInclusive()) {
            upperExclusiveKey = ByteUtil.nextKey((byte[])upperExclusiveKey);
        }
        Assert.assertEquals((Object)this.expectedResult, (Object)this.scanRanges.intersectRegion(lowerInclusiveKey, upperExclusiveKey, false));
    }

    @Parameterized.Parameters(name="{0} {2}")
    public static synchronized Collection<Object> data() {
        ArrayList testCases = Lists.newArrayList();
        testCases.addAll(ScanRangesTest.foreach(new KeyRange[][]{{PVarchar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b"), false, Bytes.toBytes((String)"c"), true, SortOrder.ASC)}}, new int[]{0}, PVarchar.INSTANCE.getKeyRange(Bytes.toBytes((String)"ba"), true, Bytes.toBytes((String)"bb"), true, SortOrder.ASC), true));
        testCases.addAll(ScanRangesTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b"), true, Bytes.toBytes((String)"b"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"B"), true, Bytes.toBytes((String)"D"), true, SortOrder.ASC)}}, new int[]{1, 1, 1}, PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"a9Z"), true, Bytes.toBytes((String)"c0A"), true, SortOrder.ASC), true));
        testCases.addAll(ScanRangesTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b"), true, Bytes.toBytes((String)"b"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"A"), false, Bytes.toBytes((String)"B"), true, SortOrder.ASC)}}, new int[]{1, 1, 1}, PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b1A"), true, Bytes.toBytes((String)"b1A"), true, SortOrder.ASC), false));
        testCases.addAll(ScanRangesTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b"), true, Bytes.toBytes((String)"b"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"B"), true, Bytes.toBytes((String)"D"), true, SortOrder.ASC)}}, new int[]{1, 1, 1}, PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b0A"), true, Bytes.toBytes((String)"b1C"), true, SortOrder.ASC), true));
        testCases.addAll(ScanRangesTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b"), true, Bytes.toBytes((String)"b"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"B"), true, Bytes.toBytes((String)"B"), true, SortOrder.ASC)}}, new int[]{1, 1, 1}, PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b0A"), true, Bytes.toBytes((String)"b1B"), true, SortOrder.ASC), true));
        testCases.addAll(ScanRangesTest.foreach(ScanRanges.EVERYTHING, null, PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC), true));
        testCases.addAll(ScanRangesTest.foreach(ScanRanges.NOTHING, null, PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC), false));
        testCases.addAll(ScanRangesTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b"), true, Bytes.toBytes((String)"b"), true, SortOrder.ASC)}}, new int[]{1}, PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"a"), true, Bytes.toBytes((String)"a"), true, SortOrder.ASC), false));
        testCases.addAll(ScanRangesTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b"), true, Bytes.toBytes((String)"b"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"2"), true, Bytes.toBytes((String)"2"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"C"), true, Bytes.toBytes((String)"C"), true, SortOrder.ASC)}}, new int[]{1, 1, 1}, PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b0Y"), true, Bytes.toBytes((String)"b0Z"), true, SortOrder.ASC), false));
        testCases.addAll(ScanRangesTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b"), true, Bytes.toBytes((String)"b"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"2"), true, Bytes.toBytes((String)"2"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"C"), true, Bytes.toBytes((String)"C"), true, SortOrder.ASC)}}, new int[]{1, 1, 1}, PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b0A"), true, Bytes.toBytes((String)"b2A"), true, SortOrder.ASC), false));
        testCases.addAll(ScanRangesTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b"), true, Bytes.toBytes((String)"b"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"B"), true, Bytes.toBytes((String)"B"), true, SortOrder.ASC)}}, new int[]{1, 1, 1}, PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b1A"), true, Bytes.toBytes((String)"b1B"), false, SortOrder.ASC), false));
        testCases.addAll(ScanRangesTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"a"), true, Bytes.toBytes((String)"a"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"B"), true, Bytes.toBytes((String)"E"), true, SortOrder.ASC)}}, new int[]{1, 1, 1}, PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"a0Z"), false, Bytes.toBytes((String)"a1A"), false, SortOrder.ASC), false));
        testCases.addAll(ScanRangesTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b"), true, Bytes.toBytes((String)"c"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"2"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"B"), true, Bytes.toBytes((String)"C"), true, SortOrder.ASC)}}, new int[]{1, 1, 1}, PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"a1A"), true, Bytes.toBytes((String)"b1B"), false, SortOrder.ASC), false));
        testCases.addAll(ScanRangesTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b"), true, Bytes.toBytes((String)"b"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"B"), true, Bytes.toBytes((String)"D"), true, SortOrder.ASC)}}, new int[]{1, 1, 1}, PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b1C"), true, Bytes.toBytes((String)"b2E"), true, SortOrder.ASC), true));
        testCases.addAll(ScanRangesTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b"), true, Bytes.toBytes((String)"b"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"B"), true, Bytes.toBytes((String)"D"), true, SortOrder.ASC)}}, new int[]{1, 1, 1}, PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b1D"), true, Bytes.toBytes((String)"b2E"), true, SortOrder.ASC), true));
        testCases.addAll(ScanRangesTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b"), true, Bytes.toBytes((String)"b"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"B"), true, Bytes.toBytes((String)"D"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"G"), true, Bytes.toBytes((String)"H"), true, SortOrder.ASC)}}, new int[]{1, 1, 1}, PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b1E"), true, Bytes.toBytes((String)"b1F"), true, SortOrder.ASC), false));
        testCases.addAll(ScanRangesTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"a"), true, Bytes.toBytes((String)"a"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b"), true, Bytes.toBytes((String)"b"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"2"), true, Bytes.toBytes((String)"2"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"A"), true, Bytes.toBytes((String)"A"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"C"), true, Bytes.toBytes((String)"D"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"G"), true, Bytes.toBytes((String)"G"), true, SortOrder.ASC)}}, new int[]{1, 1, 1}, PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"a1I"), true, Bytes.toBytes((String)"a2A"), false, SortOrder.ASC), false));
        testCases.addAll(ScanRangesTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b"), true, Bytes.toBytes((String)"b"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"B"), true, Bytes.toBytes((String)"D"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"G"), true, Bytes.toBytes((String)"I"), true, SortOrder.ASC)}}, new int[]{1, 1, 1}, PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b1E"), true, Bytes.toBytes((String)"b1H"), true, SortOrder.ASC), true));
        testCases.addAll(ScanRangesTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b"), true, Bytes.toBytes((String)"b"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"c"), true, Bytes.toBytes((String)"c"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"d"), true, Bytes.toBytes((String)"d"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"B"), true, Bytes.toBytes((String)"D"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"G"), true, Bytes.toBytes((String)"I"), true, SortOrder.ASC)}}, new int[]{1, 1, 1}, PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b00"), true, Bytes.toBytes((String)"d00"), true, SortOrder.ASC), true));
        testCases.addAll(ScanRangesTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b"), true, Bytes.toBytes((String)"b"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"c"), true, Bytes.toBytes((String)"c"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"d"), true, Bytes.toBytes((String)"d"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"3"), true, Bytes.toBytes((String)"4"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"B"), true, Bytes.toBytes((String)"D"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"G"), true, Bytes.toBytes((String)"I"), true, SortOrder.ASC)}}, new int[]{1, 1, 1}, PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b20"), true, Bytes.toBytes((String)"b50"), true, SortOrder.ASC), true));
        testCases.addAll(ScanRangesTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b"), true, Bytes.toBytes((String)"b"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"B"), true, Bytes.toBytes((String)"B"), true, SortOrder.ASC)}}, new int[]{1, 1, 1}, PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b1B"), false, Bytes.toBytes((String)"b2A"), true, SortOrder.ASC), false));
        testCases.addAll(ScanRangesTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b"), true, Bytes.toBytes((String)"b"), false, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), false, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"B"), true, Bytes.toBytes((String)"B"), false, SortOrder.ASC)}}, new int[]{1, 1, 1}, PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b2A"), true, Bytes.toBytes((String)"b2A"), true, SortOrder.ASC), false));
        testCases.addAll(ScanRangesTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b"), true, Bytes.toBytes((String)"b"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"B"), true, Bytes.toBytes((String)"B"), true, SortOrder.ASC)}}, new int[]{1, 1, 1}, PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"c1A"), false, Bytes.toBytes((String)"c9Z"), true, SortOrder.ASC), false));
        testCases.addAll(ScanRangesTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b"), true, Bytes.toBytes((String)"b"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"A"), true, Bytes.toBytes((String)"B"), true, SortOrder.ASC)}}, new int[]{1, 1, 1}, PChar.INSTANCE.getKeyRange(KeyRange.UNBOUND, false, Bytes.toBytes((String)"a0Z"), true, SortOrder.ASC), false));
        testCases.addAll(ScanRangesTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"a"), true, Bytes.toBytes((String)"a"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"A"), true, Bytes.toBytes((String)"B"), true, SortOrder.ASC)}}, new int[]{1, 1, 1}, PChar.INSTANCE.getKeyRange(KeyRange.UNBOUND, false, Bytes.toBytes((String)"a0Z"), true, SortOrder.ASC), false));
        testCases.addAll(ScanRangesTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"a"), true, Bytes.toBytes((String)"a"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"D"), true, Bytes.toBytes((String)"E"), true, SortOrder.ASC)}}, new int[]{1, 1, 1}, PChar.INSTANCE.getKeyRange(KeyRange.UNBOUND, false, Bytes.toBytes((String)"a1C"), true, SortOrder.ASC), false));
        testCases.addAll(ScanRangesTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"a"), true, Bytes.toBytes((String)"a"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"D"), true, Bytes.toBytes((String)"E"), true, SortOrder.ASC)}}, new int[]{1, 1, 1}, PChar.INSTANCE.getKeyRange(KeyRange.UNBOUND, false, Bytes.toBytes((String)"a1D"), true, SortOrder.ASC), true));
        testCases.addAll(ScanRangesTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"a"), true, Bytes.toBytes((String)"a"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"D"), true, Bytes.toBytes((String)"E"), true, SortOrder.ASC)}}, new int[]{1, 1, 1}, PChar.INSTANCE.getKeyRange(KeyRange.UNBOUND, false, Bytes.toBytes((String)"a2D"), true, SortOrder.ASC), true));
        testCases.addAll(ScanRangesTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"a"), true, Bytes.toBytes((String)"a"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"A"), true, Bytes.toBytes((String)"B"), true, SortOrder.ASC)}}, new int[]{1, 1, 1}, PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"a0A"), true, KeyRange.UNBOUND, false, SortOrder.ASC), true));
        testCases.addAll(ScanRangesTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"a"), true, Bytes.toBytes((String)"a"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"A"), true, Bytes.toBytes((String)"B"), true, SortOrder.ASC)}}, new int[]{1, 1, 1}, PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"a1B"), true, KeyRange.UNBOUND, false, SortOrder.ASC), true));
        testCases.addAll(ScanRangesTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"a"), true, Bytes.toBytes((String)"a"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"A"), true, Bytes.toBytes((String)"B"), true, SortOrder.ASC)}}, new int[]{1, 1, 1}, PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"a1C"), true, KeyRange.UNBOUND, false, SortOrder.ASC), false));
        testCases.addAll(ScanRangesTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"a"), true, Bytes.toBytes((String)"a"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"A"), true, Bytes.toBytes((String)"B"), true, SortOrder.ASC)}}, new int[]{1, 1, 1}, PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"a3A"), true, KeyRange.UNBOUND, false, SortOrder.ASC), false));
        testCases.addAll(ScanRangesTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"a"), true, Bytes.toBytes((String)"a"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"A"), true, Bytes.toBytes((String)"B"), true, SortOrder.ASC)}}, new int[]{1, 1, 1}, PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"d0A"), true, KeyRange.UNBOUND, false, SortOrder.ASC), false));
        testCases.addAll(ScanRangesTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"a"), true, Bytes.toBytes((String)"a"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"A"), true, Bytes.toBytes((String)"B"), true, SortOrder.ASC)}}, new int[]{1, 1, 1}, PChar.INSTANCE.getKeyRange(KeyRange.UNBOUND, false, KeyRange.UNBOUND, false, SortOrder.ASC), true));
        return testCases;
    }

    private static Collection<?> foreach(ScanRanges ranges, int[] widths, KeyRange keyRange, boolean expectedResult) {
        ArrayList ret = Lists.newArrayList();
        ret.add(new Object[]{ranges, widths, keyRange, expectedResult});
        return ret;
    }

    private static Collection<?> foreach(KeyRange[][] ranges, int[] widths, KeyRange keyRange, boolean expectedResult) {
        List slots = Lists.transform((List)Lists.newArrayList((Object[])ranges), ARRAY_TO_LIST);
        RowKeySchema.RowKeySchemaBuilder builder = new RowKeySchema.RowKeySchemaBuilder(10);
        for (final int width : widths) {
            if (width > 0) {
                builder.addField(new PDatum(){

                    public boolean isNullable() {
                        return false;
                    }

                    public PDataType getDataType() {
                        return PChar.INSTANCE;
                    }

                    public Integer getMaxLength() {
                        return width;
                    }

                    public Integer getScale() {
                        return null;
                    }

                    public SortOrder getSortOrder() {
                        return SortOrder.getDefault();
                    }
                }, false, SortOrder.getDefault());
                continue;
            }
            builder.addField(new PDatum(){

                public boolean isNullable() {
                    return false;
                }

                public PDataType getDataType() {
                    return PVarchar.INSTANCE;
                }

                public Integer getMaxLength() {
                    return width;
                }

                public Integer getScale() {
                    return null;
                }

                public SortOrder getSortOrder() {
                    return SortOrder.getDefault();
                }
            }, false, SortOrder.getDefault());
        }
        ScanRanges scanRanges = ScanRanges.createSingleSpan((RowKeySchema)builder.build(), (List)slots);
        return ScanRangesTest.foreach(scanRanges, widths, keyRange, expectedResult);
    }
}

