/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.util.ArrayList;
import java.util.List;
import org.apache.phoenix.compile.RVCOffsetCompiler;
import org.apache.phoenix.expression.AndExpression;
import org.apache.phoenix.expression.CoerceExpression;
import org.apache.phoenix.expression.ComparisonExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.IsNullExpression;
import org.apache.phoenix.expression.RowKeyColumnExpression;
import org.apache.phoenix.parse.CastParseNode;
import org.apache.phoenix.parse.ColumnParseNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.ParseNodeFactory;
import org.apache.phoenix.parse.RowValueConstructorParseNode;
import org.apache.phoenix.parse.TableName;
import org.apache.phoenix.schema.PColumnImpl;
import org.apache.phoenix.schema.PDatum;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class RVCOffsetCompilerTest {
    private static TableName TABLE_NAME = TableName.create(null, (String)"TABLE1");
    RVCOffsetCompiler offsetCompiler;

    @Before
    public void init() {
        this.offsetCompiler = RVCOffsetCompiler.getInstance();
    }

    @Test
    public void buildListOfColumnParseNodesTest() throws Exception {
        ArrayList<ColumnParseNode> children = new ArrayList<ColumnParseNode>();
        ColumnParseNode col1 = new ColumnParseNode(TABLE_NAME, "col1");
        ColumnParseNode col2 = new ColumnParseNode(TABLE_NAME, "col2");
        children.add(col1);
        children.add(col2);
        RowValueConstructorParseNode rvc = new RowValueConstructorParseNode(children);
        List result = this.offsetCompiler.buildListOfColumnParseNodes(rvc, true);
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((Object)col1, result.get(0));
        Assert.assertEquals((Object)col2, result.get(1));
    }

    @Test
    public void buildListOfColumnParseNodesTestIndex() throws Exception {
        ArrayList<CastParseNode> children = new ArrayList<CastParseNode>();
        ColumnParseNode col1 = new ColumnParseNode(TABLE_NAME, "col1");
        ColumnParseNode col2 = new ColumnParseNode(TABLE_NAME, "col2");
        ParseNodeFactory factory = new ParseNodeFactory();
        children.add(factory.cast((ParseNode)col1, (PDataType)PDecimal.INSTANCE, null, null, false));
        children.add(factory.cast((ParseNode)col2, (PDataType)PDecimal.INSTANCE, null, null, false));
        RowValueConstructorParseNode rvc = new RowValueConstructorParseNode(children);
        List result = this.offsetCompiler.buildListOfColumnParseNodes(rvc, true);
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((Object)col1, result.get(0));
        Assert.assertEquals((Object)col2, result.get(1));
    }

    @Test
    public void buildListOfRowKeyColumnExpressionsTest() throws Exception {
        ArrayList<ComparisonExpression> expressions = new ArrayList<ComparisonExpression>();
        RowKeyColumnExpression rvc1 = new RowKeyColumnExpression();
        RowKeyColumnExpression rvc2 = new RowKeyColumnExpression();
        ComparisonExpression expression1 = (ComparisonExpression)Mockito.mock(ComparisonExpression.class);
        ComparisonExpression expression2 = (ComparisonExpression)Mockito.mock(ComparisonExpression.class);
        Mockito.when((Object)expression1.getChildren()).thenReturn((Object)Lists.newArrayList((Object[])new Expression[]{rvc1}));
        Mockito.when((Object)expression2.getChildren()).thenReturn((Object)Lists.newArrayList((Object[])new Expression[]{rvc2}));
        expressions.add(expression1);
        expressions.add(expression2);
        AndExpression expression = (AndExpression)Mockito.mock(AndExpression.class);
        Mockito.when((Object)expression.getChildren()).thenReturn(expressions);
        RVCOffsetCompiler.RowKeyColumnExpressionOutput output = this.offsetCompiler.buildListOfRowKeyColumnExpressions((Expression)expression, false);
        List result = output.getRowKeyColumnExpressions();
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((Object)rvc1, result.get(0));
        Assert.assertEquals((Object)rvc2, result.get(1));
    }

    @Test
    public void buildListOfRowKeyColumnExpressionsIndexTest() throws Exception {
        ArrayList<ComparisonExpression> expressions = new ArrayList<ComparisonExpression>();
        PColumnImpl column = new PColumnImpl(PName.EMPTY_COLUMN_NAME, PName.EMPTY_NAME, (PDataType)PDecimal.INSTANCE, Integer.valueOf(10), Integer.valueOf(1), true, 1, SortOrder.getDefault(), Integer.valueOf(0), null, false, null, false, false, null, Long.MAX_VALUE);
        RowKeyColumnExpression rvc1 = new RowKeyColumnExpression((PDatum)column, null);
        RowKeyColumnExpression rvc2 = new RowKeyColumnExpression((PDatum)column, null);
        Expression coerce1 = CoerceExpression.create((Expression)rvc1, (PDataType)PDecimal.INSTANCE);
        Expression coerce2 = CoerceExpression.create((Expression)rvc2, (PDataType)PDecimal.INSTANCE);
        ComparisonExpression expression1 = (ComparisonExpression)Mockito.mock(ComparisonExpression.class);
        ComparisonExpression expression2 = (ComparisonExpression)Mockito.mock(ComparisonExpression.class);
        Mockito.when((Object)expression1.getChildren()).thenReturn((Object)Lists.newArrayList((Object[])new Expression[]{coerce1}));
        Mockito.when((Object)expression2.getChildren()).thenReturn((Object)Lists.newArrayList((Object[])new Expression[]{coerce2}));
        expressions.add(expression1);
        expressions.add(expression2);
        AndExpression expression = (AndExpression)Mockito.mock(AndExpression.class);
        Mockito.when((Object)expression.getChildren()).thenReturn(expressions);
        RVCOffsetCompiler.RowKeyColumnExpressionOutput output = this.offsetCompiler.buildListOfRowKeyColumnExpressions((Expression)expression, true);
        List result = output.getRowKeyColumnExpressions();
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((Object)rvc1, result.get(0));
        Assert.assertEquals((Object)rvc2, result.get(1));
    }

    @Test
    public void buildListOfRowKeyColumnExpressionsSingleNodeComparisonTest() throws Exception {
        ArrayList expressions = new ArrayList();
        RowKeyColumnExpression rvc = new RowKeyColumnExpression();
        ComparisonExpression expression = (ComparisonExpression)Mockito.mock(ComparisonExpression.class);
        Mockito.when((Object)expression.getChildren()).thenReturn((Object)Lists.newArrayList((Object[])new Expression[]{rvc}));
        RVCOffsetCompiler.RowKeyColumnExpressionOutput output = this.offsetCompiler.buildListOfRowKeyColumnExpressions((Expression)expression, false);
        List result = output.getRowKeyColumnExpressions();
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)rvc, result.get(0));
    }

    @Test
    public void buildListOfRowKeyColumnExpressionsSingleNodeIsNullTest() throws Exception {
        ArrayList expressions = new ArrayList();
        RowKeyColumnExpression rvc = new RowKeyColumnExpression();
        IsNullExpression expression = (IsNullExpression)Mockito.mock(IsNullExpression.class);
        Mockito.when((Object)expression.getChildren()).thenReturn((Object)Lists.newArrayList((Object[])new Expression[]{rvc}));
        RVCOffsetCompiler.RowKeyColumnExpressionOutput output = this.offsetCompiler.buildListOfRowKeyColumnExpressions((Expression)expression, false);
        List result = output.getRowKeyColumnExpressions();
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)rvc, result.get(0));
        Assert.assertTrue((boolean)output.isTrailingNull());
    }

    @Test
    public void buildListOfRowKeyColumnExpressionsIsNullTest() throws Exception {
        ArrayList<IsNullExpression> expressions = new ArrayList<IsNullExpression>();
        RowKeyColumnExpression rvc1 = new RowKeyColumnExpression();
        RowKeyColumnExpression rvc2 = new RowKeyColumnExpression();
        IsNullExpression expression1 = (IsNullExpression)Mockito.mock(IsNullExpression.class);
        IsNullExpression expression2 = (IsNullExpression)Mockito.mock(IsNullExpression.class);
        Mockito.when((Object)expression1.getChildren()).thenReturn((Object)Lists.newArrayList((Object[])new Expression[]{rvc1}));
        Mockito.when((Object)expression2.getChildren()).thenReturn((Object)Lists.newArrayList((Object[])new Expression[]{rvc2}));
        expressions.add(expression1);
        expressions.add(expression2);
        AndExpression expression = (AndExpression)Mockito.mock(AndExpression.class);
        Mockito.when((Object)expression.getChildren()).thenReturn(expressions);
        RVCOffsetCompiler.RowKeyColumnExpressionOutput output = this.offsetCompiler.buildListOfRowKeyColumnExpressions((Expression)expression, false);
        List result = output.getRowKeyColumnExpressions();
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((Object)rvc1, result.get(0));
        Assert.assertEquals((Object)rvc2, result.get(1));
        Assert.assertTrue((boolean)output.isTrailingNull());
    }
}

