/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.phoenix.compile.JoinCompiler;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.query.BaseConnectionlessQueryTest;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class JoinQueryCompilerTest
extends BaseConnectionlessQueryTest {
    @BeforeClass
    public static synchronized void createJoinTables() throws SQLException {
        try (Connection conn = DriverManager.getConnection(JoinQueryCompilerTest.getUrl());){
            conn.createStatement().execute("create table \"Join\".\"OrderTable\"   (\"order_id\" varchar(15) not null primary key,     \"customer_id\" varchar(10),     \"item_id\" varchar(10),     price integer,     quantity integer,     \"date\" timestamp)");
            conn.createStatement().execute("create table \"Join\".\"CustomerTable\"   (\"customer_id\" varchar(10) not null primary key,     name varchar,     phone varchar(12),     address varchar,     loc_id varchar(5),     \"date\" date)");
            conn.createStatement().execute("create table \"Join\".\"ItemTable\"   (\"item_id\" varchar(10) not null primary key,     name varchar,     price integer,     discount1 integer,     discount2 integer,     \"supplier_id\" varchar(10),     description varchar)");
            conn.createStatement().execute("create table \"Join\".\"SupplierTable\"   (\"supplier_id\" varchar(10) not null primary key,     name varchar,     phone varchar(12),     address varchar,     loc_id varchar(5))");
        }
    }

    @Test
    public void testExplainPlan() throws Exception {
        Connection conn = DriverManager.getConnection(JoinQueryCompilerTest.getUrl());
        String query = "EXPLAIN SELECT s.\"supplier_id\", \"order_id\", c.name, i.name, quantity, o.\"date\" FROM \"Join\".\"OrderTable\" o LEFT JOIN \"Join\".\"CustomerTable\" c ON o.\"customer_id\" = c.\"customer_id\" AND c.name LIKE 'C%' LEFT JOIN \"Join\".\"ItemTable\" i ON o.\"item_id\" = i.\"item_id\" RIGHT JOIN \"Join\".\"SupplierTable\" s ON s.\"supplier_id\" = i.\"supplier_id\" WHERE i.name LIKE 'T%'";
        ResultSet rs = conn.createStatement().executeQuery(query);
        Assert.assertEquals((Object)"CLIENT PARALLEL 1-WAY FULL SCAN OVER Join.SupplierTable\n    SERVER FILTER BY FIRST KEY ONLY\n    PARALLEL LEFT-JOIN TABLE 0\n        CLIENT PARALLEL 1-WAY FULL SCAN OVER Join.OrderTable\n            PARALLEL LEFT-JOIN TABLE 0\n                CLIENT PARALLEL 1-WAY FULL SCAN OVER Join.CustomerTable\n                    SERVER FILTER BY NAME LIKE 'C%'\n            PARALLEL LEFT-JOIN TABLE 1\n                CLIENT PARALLEL 1-WAY FULL SCAN OVER Join.ItemTable\n    AFTER-JOIN SERVER FILTER BY I.NAME LIKE 'T%'", (Object)QueryUtil.getExplainPlan((ResultSet)rs));
    }

    @Test
    public void testWhereClauseOptimization() throws Exception {
        PhoenixConnection pconn = DriverManager.getConnection(JoinQueryCompilerTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES)).unwrap(PhoenixConnection.class);
        String queryTemplate = "SELECT t1.\"item_id\", t2.\"item_id\", t3.\"item_id\" FROM \"Join\".\"ItemTable\" t1 %s JOIN \"Join\".\"ItemTable\" t2 ON t1.\"item_id\" = t2.\"item_id\" %s JOIN \"Join\".\"ItemTable\" t3 ON t1.\"item_id\" = t3.\"item_id\" WHERE t1.\"item_id\" = '0000000001' AND t2.\"item_id\" = '0000000002' AND t3.\"item_id\" = '0000000003'";
        String query = String.format(queryTemplate, "INNER", "INNER");
        JoinCompiler.JoinTable joinTable = TestUtil.getJoinTable(query, pconn);
        Assert.assertEquals((long)1L, (long)joinTable.getLeftTable().getPreFilterParseNodes().size());
        Assert.assertEquals((long)1L, (long)((JoinCompiler.JoinSpec)joinTable.getJoinSpecs().get(0)).getRhsJoinTable().getLeftTable().getPreFilterParseNodes().size());
        Assert.assertEquals((long)1L, (long)((JoinCompiler.JoinSpec)joinTable.getJoinSpecs().get(1)).getRhsJoinTable().getLeftTable().getPreFilterParseNodes().size());
        query = String.format(queryTemplate, "INNER", "LEFT");
        joinTable = TestUtil.getJoinTable(query, pconn);
        Assert.assertEquals((long)1L, (long)joinTable.getLeftTable().getPreFilterParseNodes().size());
        Assert.assertEquals((long)1L, (long)((JoinCompiler.JoinSpec)joinTable.getJoinSpecs().get(0)).getRhsJoinTable().getLeftTable().getPreFilterParseNodes().size());
        Assert.assertEquals((long)0L, (long)((JoinCompiler.JoinSpec)joinTable.getJoinSpecs().get(1)).getRhsJoinTable().getLeftTable().getPreFilterParseNodes().size());
        query = String.format(queryTemplate, "INNER", "RIGHT");
        joinTable = TestUtil.getJoinTable(query, pconn);
        Assert.assertEquals((long)0L, (long)joinTable.getLeftTable().getPreFilterParseNodes().size());
        Assert.assertEquals((long)0L, (long)((JoinCompiler.JoinSpec)joinTable.getJoinSpecs().get(0)).getRhsJoinTable().getLeftTable().getPreFilterParseNodes().size());
        Assert.assertEquals((long)1L, (long)((JoinCompiler.JoinSpec)joinTable.getJoinSpecs().get(1)).getRhsJoinTable().getLeftTable().getPreFilterParseNodes().size());
        query = String.format(queryTemplate, "LEFT", "INNER");
        joinTable = TestUtil.getJoinTable(query, pconn);
        Assert.assertEquals((long)1L, (long)joinTable.getLeftTable().getPreFilterParseNodes().size());
        Assert.assertEquals((long)0L, (long)((JoinCompiler.JoinSpec)joinTable.getJoinSpecs().get(0)).getRhsJoinTable().getLeftTable().getPreFilterParseNodes().size());
        Assert.assertEquals((long)1L, (long)((JoinCompiler.JoinSpec)joinTable.getJoinSpecs().get(1)).getRhsJoinTable().getLeftTable().getPreFilterParseNodes().size());
        query = String.format(queryTemplate, "LEFT", "LEFT");
        joinTable = TestUtil.getJoinTable(query, pconn);
        Assert.assertEquals((long)1L, (long)joinTable.getLeftTable().getPreFilterParseNodes().size());
        Assert.assertEquals((long)0L, (long)((JoinCompiler.JoinSpec)joinTable.getJoinSpecs().get(0)).getRhsJoinTable().getLeftTable().getPreFilterParseNodes().size());
        Assert.assertEquals((long)0L, (long)((JoinCompiler.JoinSpec)joinTable.getJoinSpecs().get(1)).getRhsJoinTable().getLeftTable().getPreFilterParseNodes().size());
        query = String.format(queryTemplate, "LEFT", "RIGHT");
        joinTable = TestUtil.getJoinTable(query, pconn);
        Assert.assertEquals((long)0L, (long)joinTable.getLeftTable().getPreFilterParseNodes().size());
        Assert.assertEquals((long)0L, (long)((JoinCompiler.JoinSpec)joinTable.getJoinSpecs().get(0)).getRhsJoinTable().getLeftTable().getPreFilterParseNodes().size());
        Assert.assertEquals((long)1L, (long)((JoinCompiler.JoinSpec)joinTable.getJoinSpecs().get(1)).getRhsJoinTable().getLeftTable().getPreFilterParseNodes().size());
        query = String.format(queryTemplate, "RIGHT", "INNER");
        joinTable = TestUtil.getJoinTable(query, pconn);
        Assert.assertEquals((long)0L, (long)joinTable.getLeftTable().getPreFilterParseNodes().size());
        Assert.assertEquals((long)1L, (long)((JoinCompiler.JoinSpec)joinTable.getJoinSpecs().get(0)).getRhsJoinTable().getLeftTable().getPreFilterParseNodes().size());
        Assert.assertEquals((long)1L, (long)((JoinCompiler.JoinSpec)joinTable.getJoinSpecs().get(1)).getRhsJoinTable().getLeftTable().getPreFilterParseNodes().size());
        query = String.format(queryTemplate, "RIGHT", "RIGHT");
        joinTable = TestUtil.getJoinTable(query, pconn);
        Assert.assertEquals((long)0L, (long)joinTable.getLeftTable().getPreFilterParseNodes().size());
        Assert.assertEquals((long)0L, (long)((JoinCompiler.JoinSpec)joinTable.getJoinSpecs().get(0)).getRhsJoinTable().getLeftTable().getPreFilterParseNodes().size());
        Assert.assertEquals((long)1L, (long)((JoinCompiler.JoinSpec)joinTable.getJoinSpecs().get(1)).getRhsJoinTable().getLeftTable().getPreFilterParseNodes().size());
    }
}

