/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix;

import org.apache.phoenix.TestSecurityManager;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemExitRule
implements TestRule {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemExitRule.class);
    private static final SecurityManager SECURITY_MANAGER = new TestSecurityManager();

    public Statement apply(final Statement s, Description d) {
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    System.setSecurityManager(SECURITY_MANAGER);
                    s.evaluate();
                }
                catch (UnsupportedOperationException e) {
                    LOGGER.warn("Was unable to set SecurityManager, JVM exits in tests will not behandled correctly ", (Throwable)e);
                }
                finally {
                    try {
                        System.setSecurityManager(null);
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {}
                }
            }
        };
    }

    public static class SystemExitInTestException
    extends SecurityException {
    }
}

