/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.phoenix.hbase.index.wal.IndexedKeyValue;
import org.apache.phoenix.hbase.index.wal.KeyValueCodec;
import org.junit.Assert;
import org.junit.Test;

public class IndexedKeyValueTest {
    private static final byte[] ROW_KEY = Bytes.toBytes((String)"foo");
    private static final byte[] FAMILY = Bytes.toBytes((String)"family");
    private static final byte[] QUALIFIER = Bytes.toBytes((String)"qualifier");
    private static final byte[] VALUE = Bytes.toBytes((String)"value");
    private static final byte[] TABLE_NAME = Bytes.toBytes((String)"MyTableName");

    @Test
    public void testIndexedKeyValueExceptionWhenMutationEmpty() throws IOException {
        boolean caughtNullMutation = false;
        boolean caughtNullEntry = false;
        try {
            IndexedKeyValue indexedKeyValue = IndexedKeyValue.newIndexedKeyValue((byte[])TABLE_NAME, null);
        }
        catch (IllegalArgumentException iae) {
            caughtNullMutation = true;
        }
        try {
            Put m = new Put(ROW_KEY);
            IndexedKeyValue indexedKeyValue = IndexedKeyValue.newIndexedKeyValue((byte[])TABLE_NAME, (Mutation)m);
        }
        catch (IllegalArgumentException iae) {
            caughtNullEntry = true;
        }
        Assert.assertTrue((boolean)(caughtNullMutation & caughtNullEntry));
    }

    @Test
    public void testIndexedKeyValuePopulatesKVFields() throws Exception {
        byte[] row = ROW_KEY;
        Put mutation = new Put(row);
        mutation.addColumn(FAMILY, QUALIFIER, VALUE);
        IndexedKeyValue indexedKeyValue = IndexedKeyValue.newIndexedKeyValue((byte[])TABLE_NAME, (Mutation)mutation);
        this.testIndexedKeyValueHelper(indexedKeyValue, row, TABLE_NAME, (Mutation)mutation);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        KeyValueCodec.write((DataOutput)out, (KeyValue)indexedKeyValue);
        IndexedKeyValue deSerializedKV = (IndexedKeyValue)KeyValueCodec.readKeyValue((DataInput)new DataInputStream(new ByteArrayInputStream(baos.toByteArray())));
        this.testIndexedKeyValueHelper(deSerializedKV, row, TABLE_NAME, (Mutation)mutation);
    }

    private void testIndexedKeyValueHelper(IndexedKeyValue indexedKeyValue, byte[] row, byte[] tableNameBytes, Mutation mutation) {
        Assert.assertArrayEquals((byte[])row, (byte[])CellUtil.cloneRow((Cell)indexedKeyValue));
        Assert.assertArrayEquals((byte[])tableNameBytes, (byte[])indexedKeyValue.getIndexTable());
        Assert.assertEquals((Object)mutation.toString(), (Object)indexedKeyValue.getMutation().toString());
        Assert.assertArrayEquals((byte[])WALEdit.METAFAMILY, (byte[])CellUtil.cloneFamily((Cell)indexedKeyValue));
    }
}

