/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ipc.PhoenixRpcSchedulerFactory;
import org.apache.hadoop.hbase.regionserver.RpcSchedulerFactory;
import org.apache.hadoop.hbase.regionserver.SimpleRpcSchedulerFactory;
import org.junit.Assert;
import org.junit.Test;

public class PhoenixRpcSchedulerFactoryTest {
    @Test
    public void ensureInstantiation() throws Exception {
        Configuration conf = new Configuration(false);
        conf.setClass("hbase.region.server.rpc.scheduler.factory.class", PhoenixRpcSchedulerFactory.class, RpcSchedulerFactory.class);
        try {
            Class rpcSchedulerFactoryClass = conf.getClass("hbase.region.server.rpc.scheduler.factory.class", SimpleRpcSchedulerFactory.class);
            Object o = rpcSchedulerFactoryClass.newInstance();
            Assert.assertTrue((boolean)(o instanceof PhoenixRpcSchedulerFactory));
        }
        catch (InstantiationException e) {
            Assert.assertTrue((String)("Should not have got an exception when instantiing the rpc scheduler: " + e), (boolean)false);
        }
        catch (IllegalAccessException e) {
            Assert.assertTrue((String)("Should not have got an exception when instantiing the rpc scheduler: " + e), (boolean)false);
        }
    }

    @Test
    public void testValidateRpcPriorityRanges() throws Exception {
        Configuration conf = new Configuration(false);
        PhoenixRpcSchedulerFactory factory = new PhoenixRpcSchedulerFactory();
        factory.create(conf, null);
        this.setPriorities(conf, -4, -1);
        factory.create(conf, null);
        this.setPriorities(conf, 1001, 1002);
        factory.create(conf, null);
        this.setPriorities(conf, 1, 201);
        try {
            factory.create(conf, null);
            Assert.fail((String)"Should not have allowed priorities in HBase range");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.setPriorities(conf, 1001, 1);
        try {
            factory.create(conf, null);
            Assert.fail((String)"Should not have allowed priorities in HBase range");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.setPriorities(conf, 1001, 0);
        try {
            factory.create(conf, null);
            Assert.fail((String)"Should not have allowed priorities in HBase range");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.setPriorities(conf, 0, 1001);
        try {
            factory.create(conf, null);
            Assert.fail((String)"Should not have allowed priorities in HBase range");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.setPriorities(conf, 1001, 200);
        try {
            factory.create(conf, null);
            Assert.fail((String)"Should not have allowed priorities in HBase range");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.setPriorities(conf, 200, 1001);
        try {
            factory.create(conf, null);
            Assert.fail((String)"Should not have allowed priorities in HBase range");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void setPriorities(Configuration conf, int indexPrioritymin, int metadataPriority) {
        conf.setInt("phoenix.index.rpc.priority", indexPrioritymin);
        conf.setInt("phoenix.metadata.rpc.priority", metadataPriority);
    }
}

