/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.net.InetSocketAddress;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.ipc.BalancedQueueRpcExecutor;
import org.apache.hadoop.hbase.ipc.CallRunner;
import org.apache.hadoop.hbase.ipc.PhoenixRpcScheduler;
import org.apache.hadoop.hbase.ipc.PriorityFunction;
import org.apache.hadoop.hbase.ipc.RpcExecutor;
import org.apache.hadoop.hbase.ipc.RpcScheduler;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.RpcServerFactory;
import org.apache.hadoop.hbase.ipc.ServerCall;
import org.apache.hadoop.hbase.ipc.TestProtobufRpcServiceImpl;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RPCProtos;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class PhoenixRpcSchedulerTest {
    private static final Configuration conf = HBaseConfiguration.create();
    private static final InetSocketAddress isa = new InetSocketAddress("localhost", 0);

    @Test
    public void testIndexPriorityWritesToIndexHandler() throws Exception {
        RpcScheduler mock = (RpcScheduler)Mockito.mock(RpcScheduler.class);
        PriorityFunction qosFunction = (PriorityFunction)Mockito.mock(PriorityFunction.class);
        AbortServer abortable = new AbortServer();
        PhoenixRpcScheduler scheduler = new PhoenixRpcScheduler(conf, mock, 200, 250, 225, 230, qosFunction, (Abortable)abortable);
        BalancedQueueRpcExecutor executor = new BalancedQueueRpcExecutor("test-queue", 1, 1, qosFunction, conf, (Abortable)abortable);
        scheduler.setIndexExecutorForTesting((RpcExecutor)executor);
        this.dispatchCallWithPriority((RpcScheduler)scheduler, 200);
        List queues = executor.getQueues();
        Assert.assertEquals((long)1L, (long)queues.size());
        BlockingQueue queue = (BlockingQueue)queues.get(0);
        Assert.assertNotNull(queue.poll(5L, TimeUnit.SECONDS));
        scheduler = new PhoenixRpcScheduler(conf, mock, 101, 110, 105, 115, qosFunction, (Abortable)abortable);
        scheduler.setIndexExecutorForTesting((RpcExecutor)executor);
        this.dispatchCallWithPriority((RpcScheduler)scheduler, 101);
        Assert.assertNotNull(queue.poll(5L, TimeUnit.SECONDS));
        ((RpcScheduler)Mockito.verify((Object)mock, (VerificationMode)Mockito.times((int)2))).init((RpcScheduler.Context)Mockito.any(RpcScheduler.Context.class));
        scheduler.stop();
        executor.stop();
    }

    @Test
    public void testServerSideRPCalls() throws Exception {
        RpcScheduler mock = (RpcScheduler)Mockito.mock(RpcScheduler.class);
        PriorityFunction qosFunction = (PriorityFunction)Mockito.mock(PriorityFunction.class);
        AbortServer abortable = new AbortServer();
        PhoenixRpcScheduler scheduler1 = new PhoenixRpcScheduler(conf, mock, 200, 250, 100, 300, qosFunction, (Abortable)abortable);
        RpcExecutor executor1 = scheduler1.getServerSideExecutorForTesting();
        for (int c = 0; c < 10; ++c) {
            this.dispatchCallWithPriority((RpcScheduler)scheduler1, 100);
        }
        List queues1 = executor1.getQueues();
        int numDispatches1 = 0;
        for (BlockingQueue queue1 : queues1) {
            if (queue1.size() <= 0) continue;
            numDispatches1 += queue1.size();
            for (int i = 0; i < queue1.size(); ++i) {
                Assert.assertNotNull(queue1.poll(5L, TimeUnit.SECONDS));
            }
        }
        Assert.assertEquals((long)10L, (long)numDispatches1);
        scheduler1.stop();
        PhoenixRpcScheduler scheduler2 = new PhoenixRpcScheduler(conf, mock, 101, 110, 50, 25, qosFunction, (Abortable)abortable);
        RpcExecutor executor2 = scheduler2.getIndexExecutorForTesting();
        this.dispatchCallWithPriority((RpcScheduler)scheduler2, 50);
        List queues2 = executor2.getQueues();
        int numDispatches2 = 0;
        for (BlockingQueue queue2 : queues2) {
            if (queue2.size() <= 0) continue;
            ++numDispatches2;
            Assert.assertNotNull(queue2.poll(5L, TimeUnit.SECONDS));
        }
        Assert.assertEquals((long)0L, (long)numDispatches2);
        scheduler2.stop();
        ((RpcScheduler)Mockito.verify((Object)mock, (VerificationMode)Mockito.times((int)(numDispatches1 + 1)))).init((RpcScheduler.Context)Mockito.any(RpcScheduler.Context.class));
        ((RpcScheduler)Mockito.verify((Object)mock, (VerificationMode)Mockito.times((int)0))).dispatch((CallRunner)Mockito.any(CallRunner.class));
    }

    @Test
    public void testDelegateWhenOutsideRange() throws Exception {
        PriorityFunction qosFunction = (PriorityFunction)Mockito.mock(PriorityFunction.class);
        AbortServer abortable = new AbortServer();
        RpcScheduler mock = (RpcScheduler)Mockito.mock(RpcScheduler.class);
        PhoenixRpcScheduler scheduler = new PhoenixRpcScheduler(conf, mock, 200, 250, 225, 275, qosFunction, (Abortable)abortable);
        this.dispatchCallWithPriority((RpcScheduler)scheduler, 100);
        this.dispatchCallWithPriority((RpcScheduler)scheduler, 251);
        scheduler = new PhoenixRpcScheduler(conf, mock, 101, 110, 105, 115, qosFunction, (Abortable)abortable);
        this.dispatchCallWithPriority((RpcScheduler)scheduler, 200);
        this.dispatchCallWithPriority((RpcScheduler)scheduler, 111);
        ((RpcScheduler)Mockito.verify((Object)mock, (VerificationMode)Mockito.times((int)4))).init((RpcScheduler.Context)Mockito.any(RpcScheduler.Context.class));
        ((RpcScheduler)Mockito.verify((Object)mock, (VerificationMode)Mockito.times((int)4))).dispatch((CallRunner)Mockito.any(CallRunner.class));
        scheduler.stop();
    }

    @Test
    public void testInvalidateMetadataCacheExecutor() throws Exception {
        RpcScheduler mock = (RpcScheduler)Mockito.mock(RpcScheduler.class);
        PriorityFunction qosFunction = (PriorityFunction)Mockito.mock(PriorityFunction.class);
        AbortServer abortable = new AbortServer();
        int invalidateMetadataCacheCallPriority = 230;
        PhoenixRpcScheduler scheduler = new PhoenixRpcScheduler(conf, mock, 200, 250, 225, invalidateMetadataCacheCallPriority, qosFunction, (Abortable)abortable);
        BalancedQueueRpcExecutor executor = new BalancedQueueRpcExecutor("test-queue", 1, 1, qosFunction, conf, (Abortable)abortable);
        scheduler.setInvalidateMetadataCacheExecutorForTesting((RpcExecutor)executor);
        this.dispatchCallWithPriority((RpcScheduler)scheduler, invalidateMetadataCacheCallPriority);
        List queues = executor.getQueues();
        Assert.assertEquals((long)1L, (long)queues.size());
        BlockingQueue queue = (BlockingQueue)queues.get(0);
        Assert.assertEquals((long)1L, (long)queue.size());
        Assert.assertNotNull(queue.poll(5L, TimeUnit.SECONDS));
        ((RpcScheduler)Mockito.verify((Object)mock, (VerificationMode)Mockito.times((int)1))).init((RpcScheduler.Context)Mockito.any(RpcScheduler.Context.class));
        scheduler.stop();
        executor.stop();
    }

    private void dispatchCallWithPriority(RpcScheduler scheduler, int priority) throws Exception {
        CallRunner task = (CallRunner)Mockito.mock(CallRunner.class);
        RPCProtos.RequestHeader header = RPCProtos.RequestHeader.newBuilder().setPriority(priority).build();
        RpcServer server = RpcServerFactory.createRpcServer(null, (String)"test-rpcserver", (List)Lists.newArrayList((Object[])new RpcServer.BlockingServiceAndInterface[]{new RpcServer.BlockingServiceAndInterface(TestProtobufRpcServiceImpl.SERVICE, null)}), (InetSocketAddress)isa, (Configuration)conf, (RpcScheduler)scheduler);
        ServerCall call = (ServerCall)Mockito.mock(ServerCall.class);
        Mockito.when((Object)call.getHeader()).thenReturn((Object)header);
        Mockito.when((Object)call.getRequestUser()).thenReturn(Optional.empty());
        Mockito.when((Object)task.getRpcCall()).thenReturn((Object)call);
        scheduler.dispatch(task);
        ((CallRunner)Mockito.verify((Object)task)).getRpcCall();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{task});
        server.stop();
    }

    private class AbortServer
    implements Abortable {
        private boolean aborted = false;

        private AbortServer() {
        }

        public void abort(String why, Throwable e) {
            this.aborted = true;
        }

        public boolean isAborted() {
            return this.aborted;
        }
    }
}

