/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util.i18n;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Locale;
import junit.framework.TestCase;

public class OracleUpperTableGeneratorTest
extends TestCase {
    private static final char[] charsToTest = new char[]{'i', '\u00df', '\u0386', '\u0388', '\u0389', '\u038a', '\u038c', '\u038e', '\u038f', '\u03ac', '\u03ad', '\u03ae', '\u03af', '\u03cc', '\u03cd', '\u03ce'};

    public static void generateUpperCaseExceptions(PrintWriter out) {
        String template;
        out.println("set serveroutput on;");
        out.println("set define off;");
        out.println("/");
        out.println("BEGIN");
        OracleUpperTableGeneratorTest.putLine(out, "/*", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, " * Licensed to the Apache Software Foundation (ASF) under one or more", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, " * contributor license agreements.  See the NOTICE file distributed with", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, " * this work for additional information regarding copyright ownership.", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, " * The ASF licenses this file to you under the Apache License, Version 2.0", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, " * (the \"License\"); you may not use this file except in compliance with", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, " * the License.  You may obtain a copy of the License at", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, " *", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, " * http://www.apache.org/licenses/LICENSE-2.0", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, " *", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, " * Unless required by applicable law or agreed to in writing, software", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, " * distributed under the License is distributed on an \"AS IS\" BASIS,", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, " * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, " * See the License for the specific language governing permissions and", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, " * limitations under the License.", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, " */", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "package i18n;", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "import java.util.Locale;", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "import edu.umd.cs.findbugs.annotations.NonNull;", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "/**", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, " * Generated by " + OracleUpperTableGeneratorTest.class.getCanonicalName(), new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, " * <p>", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, " * An instance of this enum codifies the difference between executing a {@link #getSqlFormatString() particular PL/SQL", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, " * expression} in Oracle and executing {@link String#toUpperCase(Locale)} for a {@link #getLocale() particular locale}", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, " * in Java. These differences (also called exceptions) are expressed by the output of {@link #getUpperCaseExceptions()}", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, " * and {@link #getUpperCaseExceptionMapping(char)}.", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, " * <p>", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, " * The tables are generated by testing a particular set of characters that are known to contain exceptions and", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, " * {@link #toUpperCase(String) may be used} to compensate for exceptions found and generate output in Java that will be", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, " * consistent with Oracle for the given (sql expression, locale) pair over all tested values.", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, " * <p>", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, " * Characters tested:", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, " * <ul>", new String[0]);
        for (char c : charsToTest) {
            OracleUpperTableGeneratorTest.putLine(out, " * <li>U+%1$s &#x%1$s</li>", OracleUpperTableGeneratorTest.hexCodePoint(c));
        }
        OracleUpperTableGeneratorTest.putLine(out, " * </ul>", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, " *", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, " * @see OracleUpper", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, " */", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "public enum OracleUpperTable {", new String[0]);
        for (UpperExpr u : UpperExpr.values()) {
            OracleUpperTableGeneratorTest.put(out, "    %s(\"%s\", \"%s\", \"", u.name(), u.expr, u.locale.getLanguage());
            if (u != UpperExpr.ESPERANTO) {
                for (char c : charsToTest) {
                    template = "IF %1$s <> '%2$s' THEN dbms_output.put(unistr('\\%3$s')); END IF;";
                    out.println(String.format(template, u.getSql(c), u.getJava(c), OracleUpperTableGeneratorTest.hexCodePoint(c)));
                }
            }
            OracleUpperTableGeneratorTest.putLine(out, "\"),", new String[0]);
        }
        OracleUpperTableGeneratorTest.putLine(out, "    ;", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "    private final String sql;", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "    private final Locale locale;", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "    private final char[] exceptionChars;", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "    private OracleUpperTable(String sql, String lang, String exceptionChars) {", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "        this.sql = sql;", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "        this.locale = new Locale(lang);", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "        this.exceptionChars = exceptionChars.toCharArray();", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "    }", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "    /**", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "    * Return an array containing characters for which Java's String.toUpperCase method is known to", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "    * deviate from the result of Oracle evaluating {@link #getSql(String) this expression}.", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "    *", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "    * @return an array containing all exceptional characters.", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "    */", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "    final @NonNull char[] getUpperCaseExceptions() {", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "        return exceptionChars;", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "    }", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "   /**", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "    * For a character, {@code exception}, contained in the String returned from", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "    * {@link #getUpperCaseExceptions()}, this method returns the anticipated result of upper-casing", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "    *  the character in Oracle when evaluating {@link #getSql(String) this expression}.", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "    *", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "    * @return the upper case of {@code exception}, according to what Oracle would do.", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "    * @throws IllegalArgumentException", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "    *             if the character is not contained in the String returned", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "    *             by {@link #getUpperCaseExceptions()}.", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "    */", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "    final String getUpperCaseExceptionMapping(char exception) {", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "        switch (exception) {", new String[0]);
        for (char c : charsToTest) {
            OracleUpperTableGeneratorTest.putLine(out, "        case '%s':", "" + c);
            OracleUpperTableGeneratorTest.putLine(out, "            switch (this) {", new String[0]);
            for (UpperExpr u : UpperExpr.values()) {
                if (u == UpperExpr.ESPERANTO) continue;
                template = "IF %1$s <> '%2$s' THEN dbms_output.put_line('            case %3$s: return ' || '\"' || %1$s || '\"; // %2$s'); END IF;";
                out.println(String.format(template, u.getSql(c), u.getJava(c), u.name()));
            }
            OracleUpperTableGeneratorTest.putLine(out, "            default: // fall out", new String[0]);
            OracleUpperTableGeneratorTest.putLine(out, "            }", new String[0]);
            OracleUpperTableGeneratorTest.putLine(out, "            break;", new String[0]);
        }
        OracleUpperTableGeneratorTest.putLine(out, "        }", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "        throw new IllegalArgumentException(", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "                \"No upper case mapping for char=\" + exception", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "                + \" and this=\" + this);", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "    }", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "    public final Locale getLocale() {", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "        return locale;", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "    }", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "    public String getSqlFormatString() {", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "        return sql;", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "    }", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "    public String getSql(String expr) {", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "        return String.format(sql, expr);", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "    }", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "    public String toUpperCase(String value) {", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "        return OracleUpper.toUpperCase(this, value);", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "    }", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "    public static final OracleUpperTable forLinguisticSort(String sort) {", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "        return Enum.valueOf(OracleUpperTable.class, sort);", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "    }", new String[0]);
        OracleUpperTableGeneratorTest.putLine(out, "}", new String[0]);
        out.println("END;");
    }

    private static String sqlEscape(String str) {
        return str.replace("'", "''");
    }

    private static String hexCodePoint(char c) {
        Object cp = Integer.toHexString(c);
        while (((String)cp).length() < 4) {
            cp = "0" + (String)cp;
        }
        return cp;
    }

    private static void put(PrintWriter out, String str, String ... args) {
        out.println("dbms_output.put('" + OracleUpperTableGeneratorTest.format(str, args) + "');");
    }

    private static void putLine(PrintWriter out, String str, String ... args) {
        out.println("dbms_output.put_line('" + OracleUpperTableGeneratorTest.format(str, args) + "');");
    }

    private static String format(String str, String ... args) {
        str = OracleUpperTableGeneratorTest.sqlEscape(str);
        if (args != null && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                args[i] = OracleUpperTableGeneratorTest.sqlEscape(args[i]);
            }
            str = String.format(str, args);
        }
        return str;
    }

    public static void main(String[] args) {
        OracleUpperTableGeneratorTest.generateUpperCaseExceptions(new PrintWriter(System.out));
    }

    public void testGenerateUpperCaseExceptions() {
        OracleUpperTableGeneratorTest.generateUpperCaseExceptions(new PrintWriter(new StringWriter()));
    }

    private static enum UpperExpr {
        ENGLISH("upper(%s)", "en"),
        GERMAN("nls_upper(%s, 'nls_sort=xgerman')", "de"),
        FRENCH("nls_upper(%s, 'nls_sort=xfrench')", "fr"),
        ITALIAN("nls_upper(%s, 'nls_sort=italian')", "it"),
        SPANISH("nls_upper(%s, 'nls_sort=spanish')", "es"),
        CATALAN("nls_upper(%s, 'nls_sort=catalan')", "ca"),
        DUTCH("nls_upper(%s, 'nls_sort=dutch')", "nl"),
        PORTUGUESE("nls_upper(%s, 'nls_sort=west_european')", "pt"),
        DANISH("nls_upper(%s, 'nls_sort=danish')", "da"),
        NORWEGIAN("nls_upper(%s, 'nls_sort=norwegian')", "no"),
        SWEDISH("nls_upper(%s, 'nls_sort=swedish')", "sv"),
        FINNISH("nls_upper(%s, 'nls_sort=finnish')", "fi"),
        CZECH("nls_upper(%s, 'nls_sort=xczech')", "cs"),
        POLISH("nls_upper(%s, 'nls_sort=polish')", "pl"),
        TURKISH("nls_upper(translate(%s,'i','\u0130'), 'nls_sort=xturkish')", "tr"),
        CHINESE_HK("nls_upper(to_single_byte(%s), 'nls_sort=tchinese_radical_m')", "zh"),
        CHINESE_TW("nls_upper(to_single_byte(%s), 'nls_sort=tchinese_radical_m')", "zh"),
        CHINESE("nls_upper(to_single_byte(%s), 'nls_sort=schinese_radical_m')", "zh"),
        JAPANESE("nls_upper(to_single_byte(%s), 'nls_sort=japanese_m')", "ja"),
        KOREAN("nls_upper(to_single_byte(%s), 'nls_sort=korean_m')", "ko"),
        RUSSIAN("nls_upper(%s, 'nls_sort=russian')", "ru"),
        BULGARIAN("nls_upper(%s, 'nls_sort=bulgarian')", "bg"),
        INDONESIAN("nls_upper(%s, 'nls_sort=indonesian')", "in"),
        ROMANIAN("nls_upper(%s, 'nls_sort=romanian')", "ro"),
        VIETNAMESE("nls_upper(%s, 'nls_sort=vietnamese')", "vi"),
        UKRAINIAN("nls_upper(%s, 'nls_sort=ukrainian')", "uk"),
        HUNGARIAN("nls_upper(%s, 'nls_sort=xhungarian')", "hu"),
        GREEK("nls_upper(%s, 'nls_sort=greek')", "el"),
        HEBREW("nls_upper(%s, 'nls_sort=hebrew')", "iw"),
        SLOVAK("nls_upper(%s, 'nls_sort=slovak')", "sk"),
        SERBIAN_CYRILLIC("nls_upper(%s, 'nls_sort=generic_m')", "sr"),
        SERBIAN_LATIN("nls_upper(%s, 'nls_sort=xcroatian')", "sh"),
        BOSNIAN("nls_upper(%s, 'nls_sort=xcroatian')", "bs"),
        GEORGIAN("nls_upper(%s, 'nls_sort=binary')", "ka"),
        BASQUE("nls_upper(%s, 'nls_sort=west_european')", "eu"),
        MALTESE("nls_upper(%s, 'nls_sort=west_european')", "mt"),
        ROMANSH("nls_upper(%s, 'nls_sort=west_european')", "rm"),
        LUXEMBOURGISH("nls_upper(%s, 'nls_sort=west_european')", "lb"),
        IRISH("nls_upper(%s, 'nls_sort=west_european')", "ga"),
        SLOVENE("nls_upper(%s, 'nls_sort=xslovenian')", "sl"),
        CROATIAN("nls_upper(%s, 'nls_sort=xcroatian')", "hr"),
        MALAY("nls_upper(%s, 'nls_sort=malay')", "ms"),
        ARABIC("nls_upper(%s, 'nls_sort=arabic')", "ar"),
        ESTONIAN("nls_upper(%s, 'nls_sort=estonian')", "et"),
        ICELANDIC("nls_upper(%s, 'nls_sort=icelandic')", "is"),
        LATVIAN("nls_upper(%s, 'nls_sort=latvian')", "lv"),
        LITHUANIAN("nls_upper(%s, 'nls_sort=lithuanian')", "lt"),
        KYRGYZ("nls_upper(%s, 'nls_sort=binary')", "ky"),
        KAZAKH("nls_upper(%s, 'nls_sort=binary')", "kk"),
        TAJIK("nls_upper(%s, 'nls_sort=russian')", "tg"),
        BELARUSIAN("nls_upper(%s, 'nls_sort=russian')", "be"),
        TURKMEN("nls_upper(translate(%s,'i','\u0130'), 'nls_sort=xturkish')", "tk"),
        AZERBAIJANI("nls_upper(translate(%s,'i','\u0130'), 'nls_sort=xturkish')", "az"),
        ARMENIAN("nls_upper(%s, 'nls_sort=binary')", "hy"),
        THAI("nls_upper(%s, 'nls_sort=thai_dictionary')", "th"),
        HINDI("nls_upper(%s, 'nls_sort=binary')", "hi"),
        URDU("nls_upper(%s, 'nls_sort=arabic')", "ur"),
        BENGALI("nls_upper(%s, 'nls_sort=bengali')", "bn"),
        TAMIL("nls_upper(%s, 'nls_sort=binary')", "ta"),
        ESPERANTO("upper(%s)", "eo"),
        XWEST_EUROPEAN("NLS_UPPER(%s,'NLS_SORT=xwest_european')", "en");

        private final String expr;
        private final Locale locale;

        private UpperExpr(String expr, String langCode) {
            this.expr = expr;
            this.locale = new Locale(langCode);
        }

        private String getSql(char value) {
            return String.format(this.expr, "unistr('\\" + OracleUpperTableGeneratorTest.hexCodePoint(value) + "')");
        }

        private String getJava(char value) {
            return Character.toString(value).toUpperCase(this.locale);
        }
    }
}

