/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util.i18n;

import com.ibm.icu.text.Normalizer2;
import java.text.CollationKey;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.phoenix.thirdparty.com.google.common.collect.Ordering;
import org.apache.phoenix.util.i18n.LinguisticSort;

public class LinguisticSortTest
extends TestCase {
    public LinguisticSortTest(String name) {
        super(name);
    }

    public void testThaiBasicSorting() {
        Locale thaiLoc = new Locale("th");
        LinguisticSort thaiSort = LinguisticSort.get((Locale)thaiLoc);
        ImmutableList unsorted = ImmutableList.of((Object)"azw", (Object)"Ac", (Object)"ab", (Object)"21", (Object)"zaa", (Object)"b\u0e40k", (Object)"bk");
        ImmutableList sorted = ImmutableList.of((Object)"21", (Object)"ab", (Object)"Ac", (Object)"azw", (Object)"bk", (Object)"b\u0e40k", (Object)"zaa");
        LinguisticSortTest.assertEquals((Object)sorted, (Object)Ordering.from((Comparator)thaiSort.getNonCachingComparator()).sortedCopy((Iterable)unsorted));
        LinguisticSortTest.assertEquals((Object)sorted, (Object)Ordering.from((Comparator)thaiSort.getComparator(16)).sortedCopy((Iterable)unsorted));
    }

    public void testThaiCharactersOfDeath() {
        String[] oomStrings;
        Collator c = Collator.getInstance(new Locale("th"));
        String s = "\u0e40";
        System.out.println(c.compare(s, s));
        Locale thaiLoc = new Locale("th");
        LinguisticSort thaiSort = LinguisticSort.get((Locale)thaiLoc);
        Collator thaiColl = thaiSort.getCollator();
        String[] srcStrings = oomStrings = new String[]{"\u0e3f", "\u0e45", "\u0e40k", "\u0e44", "\u0e43", "\u0e42", "\u0e41", "\u0e40"};
        for (int i = 0; i < oomStrings.length; ++i) {
            String oomString = oomStrings[i];
            CollationKey key = thaiColl.getCollationKey(oomString);
            LinguisticSortTest.assertEquals((String)("string #" + i), (String)srcStrings[i], (String)key.getSourceString());
        }
    }

    public void testRolodexIndexByChar() throws Exception {
        LinguisticSort englishSort = LinguisticSort.ENGLISH;
        LinguisticSortTest.assertEquals((int)0, (int)englishSort.getRolodexIndexForChar("a"));
        LinguisticSortTest.assertEquals((int)0, (int)englishSort.getRolodexIndexForChar("\u00c1"));
        LinguisticSortTest.assertEquals((int)1, (int)englishSort.getRolodexIndexForChar("b"));
        LinguisticSortTest.assertEquals((int)13, (int)englishSort.getRolodexIndexForChar("N"));
        LinguisticSortTest.assertEquals((int)13, (int)englishSort.getRolodexIndexForChar("\u00d1"));
        LinguisticSortTest.assertEquals((int)25, (int)englishSort.getRolodexIndexForChar("z"));
        this.assertOther(Arrays.asList("\u0410", "\u3053"), englishSort);
        LinguisticSort spanishSort = LinguisticSort.SPANISH;
        LinguisticSortTest.assertEquals((int)0, (int)spanishSort.getRolodexIndexForChar("a"));
        LinguisticSortTest.assertEquals((int)0, (int)spanishSort.getRolodexIndexForChar("\u00c1"));
        LinguisticSortTest.assertEquals((int)1, (int)spanishSort.getRolodexIndexForChar("b"));
        LinguisticSortTest.assertEquals((int)13, (int)spanishSort.getRolodexIndexForChar("N"));
        LinguisticSortTest.assertEquals((int)14, (int)spanishSort.getRolodexIndexForChar("\u00d1"));
        LinguisticSortTest.assertEquals((int)26, (int)spanishSort.getRolodexIndexForChar("z"));
        this.assertOther(Arrays.asList("\u0410", "\u3053"), spanishSort);
        LinguisticSort japaneseSort = LinguisticSort.JAPANESE;
        LinguisticSortTest.assertEquals((int)0, (int)japaneseSort.getRolodexIndexForChar("a"));
        LinguisticSortTest.assertEquals((int)0, (int)japaneseSort.getRolodexIndexForChar("\u00c1"));
        LinguisticSortTest.assertEquals((int)1, (int)japaneseSort.getRolodexIndexForChar("b"));
        LinguisticSortTest.assertEquals((int)13, (int)japaneseSort.getRolodexIndexForChar("N"));
        LinguisticSortTest.assertEquals((int)13, (int)japaneseSort.getRolodexIndexForChar("\u00d1"));
        LinguisticSortTest.assertEquals((int)25, (int)japaneseSort.getRolodexIndexForChar("z"));
        LinguisticSortTest.assertEquals((int)27, (int)japaneseSort.getRolodexIndexForChar("\u3053"));
        LinguisticSortTest.assertEquals((int)27, (int)japaneseSort.getRolodexIndexForChar("\u304f"));
        LinguisticSortTest.assertEquals((int)31, (int)japaneseSort.getRolodexIndexForChar("\u3075"));
        this.assertOther(Arrays.asList("\u0410"), spanishSort);
        LinguisticSort malaySort = LinguisticSort.MALAY;
        LinguisticSortTest.assertEquals((int)0, (int)malaySort.getRolodexIndexForChar("a"));
        LinguisticSortTest.assertEquals((int)25, (int)malaySort.getRolodexIndexForChar("z"));
        this.assertOther(Arrays.asList("\u0410", "\u304f"), malaySort);
        LinguisticSort thaiSort = LinguisticSort.THAI;
        this.assertConstant(Arrays.asList("A", "\u00c1", "b", "\u304f", "\u0410"), thaiSort, 46, "had a rolodex index.");
    }

    public void testRolodexComparedToIcu() {
        EnumSet<LinguisticSort[]> knownDifferences = EnumSet.of(LinguisticSort.CATALAN, new LinguisticSort[]{LinguisticSort.FINNISH, LinguisticSort.TURKISH, LinguisticSort.CHINESE_HK, LinguisticSort.CHINESE_HK_STROKE, LinguisticSort.CHINESE_TW, LinguisticSort.CHINESE_TW_STROKE, LinguisticSort.JAPANESE, LinguisticSort.KOREAN, LinguisticSort.BULGARIAN, LinguisticSort.ROMANIAN, LinguisticSort.VIETNAMESE, LinguisticSort.HUNGARIAN, LinguisticSort.SLOVAK, LinguisticSort.SERBIAN_LATIN, LinguisticSort.BOSNIAN, LinguisticSort.BASQUE, LinguisticSort.LUXEMBOURGISH, LinguisticSort.SLOVENE, LinguisticSort.CROATIAN, LinguisticSort.ESTONIAN, LinguisticSort.ICELANDIC, LinguisticSort.LATVIAN, LinguisticSort.LITHUANIAN, LinguisticSort.TAJIK, LinguisticSort.TURKMEN, LinguisticSort.AZERBAIJANI, LinguisticSort.URDU, LinguisticSort.BENGALI, LinguisticSort.TAMIL, LinguisticSort.ESPERANTO});
        for (LinguisticSort sort : LinguisticSort.values()) {
            if (knownDifferences.contains(sort)) continue;
            Object[] alphabet = sort.getAlphabet();
            Object[] icuAlphabet = LinguisticSort.getAlphabetFromICU((Locale)sort.getLocale());
            String alphaAsString = Arrays.toString(alphabet);
            String icuAlphaAsString = Arrays.toString(icuAlphabet);
            LinguisticSortTest.assertEquals((String)("LinguisticSort for " + sort + " doesn't match"), (String)icuAlphaAsString, (String)alphaAsString);
            if (icuAlphaAsString.equals(alphaAsString)) continue;
            System.out.println(sort + "\n" + icuAlphaAsString + "\n" + alphaAsString);
        }
    }

    private void assertOther(Collection<String> chars, LinguisticSort sort) {
        this.assertConstant(chars, sort, sort.getAlphabetLength(), "wasn't in 'Other' category");
    }

    private void assertConstant(Collection<String> chars, LinguisticSort sort, int constant, String message) {
        for (String c : chars) {
            LinguisticSortTest.assertEquals((String)(c + " " + message), (int)constant, (int)sort.getRolodexIndexForChar(c));
        }
    }

    public void testUpperCaseCollator() {
        boolean repeatTimes = true;
        int testSize = 1000;
        this.testUpperCaseCollator(true, 1, 1000);
        this.testUpperCaseCollator(false, 1, 1000);
    }

    private void testUpperCaseCollator(boolean asciiOnly, int repeatTimes, int testSize) {
        LinguisticSort sort = LinguisticSort.ENGLISH;
        Collator collator = sort.getCollator();
        Collator ucCollator = sort.getUpperCaseCollator(false);
        Random r = new Random();
        int maxLength = 100;
        for (int iteration = 0; iteration < repeatTimes; ++iteration) {
            boolean lastTime = iteration == repeatTimes - 1;
            String[] originals = new String[testSize];
            block24: for (int i = 0; i < testSize; ++i) {
                switch (i) {
                    case 0: {
                        originals[i] = "ab\u00df";
                        continue block24;
                    }
                    case 1: {
                        originals[i] = "abSS";
                        continue block24;
                    }
                    case 2: {
                        originals[i] = "ab\u00df";
                        continue block24;
                    }
                    case 3: {
                        originals[i] = "ffo";
                        continue block24;
                    }
                    case 4: {
                        originals[i] = "\ufb03";
                        continue block24;
                    }
                    case 5: {
                        originals[i] = "FFI";
                        continue block24;
                    }
                    case 6: {
                        originals[i] = "fred";
                        continue block24;
                    }
                    case 7: {
                        originals[i] = "FRED";
                        continue block24;
                    }
                    case 8: {
                        originals[i] = "FREE";
                        continue block24;
                    }
                    case 9: {
                        originals[i] = "\u526b";
                        continue block24;
                    }
                    case 10: {
                        originals[i] = "\ubece";
                        continue block24;
                    }
                    case 11: {
                        originals[i] = "\u1fe3";
                        continue block24;
                    }
                    case 12: {
                        originals[i] = "\u05d7";
                        continue block24;
                    }
                    case 13: {
                        originals[i] = "\u1fd3";
                        continue block24;
                    }
                    case 14: {
                        originals[i] = "\u1441";
                        continue block24;
                    }
                    case 15: {
                        originals[i] = "\ub9fe";
                        continue block24;
                    }
                    case 16: {
                        originals[i] = "\u0398";
                        continue block24;
                    }
                    case 17: {
                        originals[i] = "\u0399";
                        continue block24;
                    }
                    case 18: {
                        originals[i] = "\u039a";
                        continue block24;
                    }
                    case 19: {
                        originals[i] = "\u4371";
                        continue block24;
                    }
                    case 20: {
                        originals[i] = "\ufb06";
                        continue block24;
                    }
                    default: {
                        originals[i] = this.randomString(r, 100, asciiOnly);
                    }
                }
            }
            int[] upperResults = new int[testSize];
            long start = System.currentTimeMillis();
            for (int i = 0; i < testSize; ++i) {
                int next = i + 1 == testSize ? 0 : i + 1;
                upperResults[i] = collator.compare(sort.getUpperCaseValue(originals[i], false), sort.getUpperCaseValue(originals[next], false));
            }
            if (lastTime) {
                long time = System.currentTimeMillis() - start;
                System.out.println("Compared " + testSize + " " + (asciiOnly ? "ascii " : "") + "strings with upper casing in " + time + "ms");
            }
            int[] caseResults = new int[testSize];
            long start2 = System.currentTimeMillis();
            for (int i = 0; i < testSize; ++i) {
                int next = i + 1 == testSize ? 0 : i + 1;
                caseResults[i] = ucCollator.compare(originals[i], originals[next]);
            }
            if (lastTime) {
                long time = System.currentTimeMillis() - start2;
                System.out.println("Compared " + testSize + " " + (asciiOnly ? "ascii " : "") + "strings with upper case collator comparison in " + time + "ms");
            }
            int[] keyResults = new int[testSize];
            long start3 = System.currentTimeMillis();
            for (int i = 0; i < testSize; ++i) {
                int next = i + 1 == testSize ? 0 : i + 1;
                keyResults[i] = ucCollator.getCollationKey(originals[i]).compareTo(ucCollator.getCollationKey(originals[next]));
            }
            if (lastTime) {
                long time = System.currentTimeMillis() - start3;
                System.out.println("Compared " + testSize + " " + (asciiOnly ? "ascii " : "") + "strings with collation keys in " + time + "ms");
            }
            if (lastTime) {
                System.out.println();
            }
            if (!lastTime) continue;
            Normalizer2 normalizer = Normalizer2.getNFKDInstance();
            for (int i = 0; i < testSize; ++i) {
                boolean keyOk;
                int next = i + 1 == testSize ? 0 : i + 1;
                boolean caseOk = upperResults[i] == caseResults[i];
                boolean bl = keyOk = upperResults[i] == keyResults[i];
                if (caseOk && keyOk) continue;
                String message = "Did not get expected result when comparing string " + i + " " + (caseOk ? "" : "using upper case collator comparison ") + (caseOk || keyOk ? "" : "or ") + (keyOk ? "" : "using collation key comparison ") + "\n'" + this.escape(originals[i]) + "'\n(" + this.escape(sort.getUpperCaseValue(originals[i], false)) + ")\n<" + this.escape(normalizer.normalize((CharSequence)originals[i])) + "> with string " + next + " \n'" + this.escape(originals[next]) + "'\n(" + this.escape(sort.getUpperCaseValue(originals[next], false)) + ")\n <" + this.escape(normalizer.normalize((CharSequence)originals[next])) + ">";
                LinguisticSortTest.assertEquals((String)message, (int)upperResults[i], (int)caseResults[i]);
            }
        }
    }

    private String escape(String string) {
        int ch;
        StringBuilder sb = new StringBuilder(string.length() * 2);
        for (int index = 0; index < string.length(); index += Character.charCount(ch)) {
            ch = string.codePointAt(index);
            this.escapeCodePoint(sb, ch);
        }
        return sb.toString();
    }

    private void escapeCodePoint(StringBuilder sb, int ch) {
        switch (ch) {
            case 8: {
                sb.append("\\b");
                break;
            }
            case 9: {
                sb.append("\\t");
                break;
            }
            case 10: {
                sb.append("\\n");
                break;
            }
            case 13: {
                sb.append("\\r");
                break;
            }
            case 12: {
                sb.append("\\f");
                break;
            }
            case 34: {
                sb.append("\\\"");
                break;
            }
            case 92: {
                sb.append("\\\\");
                break;
            }
            default: {
                if (ch < 32 || ch > 126) {
                    sb.append(String.format("\\u%04x", ch));
                    break;
                }
                sb.appendCodePoint(ch);
            }
        }
    }

    private String randomString(Random r, int maxLength, boolean asciiOnly) {
        int length = r.nextInt(maxLength);
        return this.randomFixedLengthString(r, length, asciiOnly);
    }

    private String randomFixedLengthString(Random r, int length, boolean asciiOnly) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char c = '\u0000';
            while (!Character.isDefined(c) || Character.isISOControl(c)) {
                c = (char)(asciiOnly ? r.nextInt(128) : r.nextInt());
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public void testUpperCaseExceptionChars() {
        String[][] greekCases;
        String[][] enCases;
        for (String[] c : enCases = new String[][]{{"\u00df", "\u00df"}, {"\u00df\u00df", "\u00df\u00df"}, {"\u00df\u00df\u00df", "\u00df\u00df\u00df"}, {"a\u00df", "A\u00df"}, {"aaa\u00df", "AAA\u00df"}, {"\u00dfa", "\u00dfA"}, {"\u00dfaaa", "\u00dfAAA"}, {"a\u00dfb", "A\u00dfB"}, {"aaa\u00dfbbb", "AAA\u00dfBBB"}, {"\u00dfa\u00df", "\u00dfA\u00df"}, {"\u00dfaaa\u00df", "\u00dfAAA\u00df"}, {"a\u00dfb\u00dfc", "A\u00dfB\u00dfC"}, {"aaa\u00dfbbb\u00dfccc", "AAA\u00dfBBB\u00dfCCC"}, {"a\u00df\u00dfc", "A\u00df\u00dfC"}, {"aaa\u00df\u00dfccc", "AAA\u00df\u00dfCCC"}}) {
            LinguisticSortTest.assertEquals((String)c[1], (String)LinguisticSort.ENGLISH.getUpperCaseValue(c[0], false));
        }
        for (String[] c : greekCases = new String[][]{{"\u039f", "\u039f"}, {"\u038c", "\u039f"}}) {
            LinguisticSortTest.assertEquals((String)c[1], (String)LinguisticSort.GREEK.getUpperCaseValue(c[0], false));
        }
    }

    public void testUsesUpper() {
        LinguisticSortTest.assertTrue((boolean)LinguisticSort.ENGLISH.usesUpperToGetUpperCase(false));
        LinguisticSortTest.assertTrue((boolean)LinguisticSort.ESPERANTO.usesUpperToGetUpperCase(false));
        LinguisticSortTest.assertTrue((!LinguisticSort.GERMAN.usesUpperToGetUpperCase(false) ? 1 : 0) != 0);
    }

    public void testGetUpperCaseCollationKey() {
        LinguisticSortTest.assertEquals((String)LinguisticSort.ENGLISH.getUpperCaseSql("x", false), (String)LinguisticSort.ENGLISH.getUpperCollationKeySql("x", false));
    }

    public void _testUpperCasePerf() {
        String[] withSharpS = this.genStrings(1000, true);
        String[] withoutSharpS = this.genStrings(1000, false);
        System.out.println("ENGLISH, with \u00df:");
        this.runUpperCase(LinguisticSort.ENGLISH, withSharpS);
        System.out.println("ENGLISH, without \u00df:");
        this.runUpperCase(LinguisticSort.ENGLISH, withoutSharpS);
        System.out.println("ESPERANTO, with \u00df:");
        this.runUpperCase(LinguisticSort.ESPERANTO, withSharpS);
        System.out.println("ESPERANTO, without \u00df:");
        this.runUpperCase(LinguisticSort.ESPERANTO, withoutSharpS);
        System.out.println("GREEK, with \u00df:");
        this.runUpperCase(LinguisticSort.GREEK, withSharpS);
        System.out.println("GREEK, without \u00df:");
        this.runUpperCase(LinguisticSort.GREEK, withoutSharpS);
    }

    private void runUpperCase(LinguisticSort sort, String[] inputs) {
        int i;
        for (i = 0; i < 10000; ++i) {
            sort.getUpperCaseValue(inputs[i % inputs.length], false);
        }
        for (i = 0; i < 3; ++i) {
            long start = System.currentTimeMillis();
            for (int j = 0; j < 1000000; ++j) {
                sort.getUpperCaseValue(inputs[j % inputs.length], false);
            }
            System.out.println("[" + (i + 1) + "] Complete in " + (System.currentTimeMillis() - start) + "ms.");
        }
    }

    private String[] genStrings(int n, boolean useSharpS) {
        Random r = new Random();
        String[] inputs = new String[n];
        for (int i = 0; i < inputs.length; ++i) {
            inputs[i] = this.randomString(r, r.nextInt(12) + 1, r.nextBoolean()) + (useSharpS ? "\u00df" : "") + (String)(r.nextBoolean() ? this.randomString(r, r.nextInt(12) + 1, r.nextBoolean()) + (useSharpS ? "\u00df" : "") : "") + this.randomString(r, r.nextInt(12) + 1, r.nextBoolean());
            if (useSharpS) continue;
            LinguisticSortTest.assertFalse((boolean)inputs[i].contains("\u00df"));
        }
        return inputs;
    }

    private List<String> cloneAndSort(LinguisticSort sort, List<String> source) {
        ArrayList<String> result = new ArrayList<String>(source);
        Collections.sort(result, sort.getCollator());
        return result;
    }

    public void testChineseSorting() {
        ImmutableList toSort = ImmutableList.of((Object)"\u963f", (Object)"\u55c4", (Object)"\u963e", (Object)"\u554a", (Object)"\u4ec8", (Object)"\u3d9a", (Object)"\u9f51");
        LinguisticSortTest.assertEquals((Object)ImmutableList.of((Object)"\u4ec8", (Object)"\u554a", (Object)"\u55c4", (Object)"\u3d9a", (Object)"\u963e", (Object)"\u963f", (Object)"\u9f51"), this.cloneAndSort(LinguisticSort.CHINESE, (List<String>)toSort));
        LinguisticSortTest.assertEquals((Object)ImmutableList.of((Object)"\u4ec8", (Object)"\u554a", (Object)"\u55c4", (Object)"\u3d9a", (Object)"\u963e", (Object)"\u963f", (Object)"\u9f51"), this.cloneAndSort(LinguisticSort.CHINESE_HK, (List<String>)toSort));
        LinguisticSortTest.assertEquals((Object)ImmutableList.of((Object)"\u4ec8", (Object)"\u554a", (Object)"\u55c4", (Object)"\u3d9a", (Object)"\u963e", (Object)"\u963f", (Object)"\u9f51"), this.cloneAndSort(LinguisticSort.CHINESE_TW, (List<String>)toSort));
        LinguisticSortTest.assertEquals((Object)ImmutableList.of((Object)"\u4ec8", (Object)"\u963e", (Object)"\u963f", (Object)"\u554a", (Object)"\u55c4", (Object)"\u9f51", (Object)"\u3d9a"), this.cloneAndSort(LinguisticSort.CHINESE_STROKE, (List<String>)toSort));
        LinguisticSortTest.assertEquals((Object)ImmutableList.of((Object)"\u4ec8", (Object)"\u963e", (Object)"\u963f", (Object)"\u554a", (Object)"\u55c4", (Object)"\u9f51", (Object)"\u3d9a"), this.cloneAndSort(LinguisticSort.CHINESE_HK_STROKE, (List<String>)toSort));
        LinguisticSortTest.assertEquals((Object)ImmutableList.of((Object)"\u4ec8", (Object)"\u963e", (Object)"\u963f", (Object)"\u554a", (Object)"\u55c4", (Object)"\u9f51", (Object)"\u3d9a"), this.cloneAndSort(LinguisticSort.CHINESE_TW_STROKE, (List<String>)toSort));
        LinguisticSortTest.assertEquals((Object)ImmutableList.of((Object)"\u963f", (Object)"\u55c4", (Object)"\u554a", (Object)"\u4ec8", (Object)"\u9f51", (Object)"\u963e", (Object)"\u3d9a"), this.cloneAndSort(LinguisticSort.CHINESE_PINYIN, (List<String>)toSort));
    }

    public void testChineseLocaleMapping() {
        LinguisticSortTest.assertEquals((Object)LinguisticSort.CHINESE, (Object)LinguisticSort.get((Locale)new Locale("zh")));
        LinguisticSortTest.assertEquals((Object)LinguisticSort.CHINESE_TW, (Object)LinguisticSort.get((Locale)new Locale("zh", "TW")));
        LinguisticSortTest.assertEquals((Object)LinguisticSort.CHINESE, (Object)LinguisticSort.get((Locale)new Locale("zh", "SG")));
        LinguisticSortTest.assertEquals((Object)LinguisticSort.CHINESE_HK, (Object)LinguisticSort.get((Locale)new Locale("zh", "HK")));
        LinguisticSortTest.assertEquals((Object)LinguisticSort.CHINESE_TW_STROKE, (Object)LinguisticSort.get((Locale)new Locale("zh", "TW", "STROKE")));
        LinguisticSortTest.assertEquals((Object)LinguisticSort.CHINESE_HK_STROKE, (Object)LinguisticSort.get((Locale)new Locale("zh", "HK", "STROKE")));
        LinguisticSortTest.assertEquals((Object)LinguisticSort.CHINESE_STROKE, (Object)LinguisticSort.get((Locale)new Locale("zh", "CN", "STROKE")));
        LinguisticSortTest.assertEquals((Object)LinguisticSort.CHINESE_STROKE, (Object)LinguisticSort.get((Locale)new Locale("zh", "SG", "STROKE")));
        LinguisticSortTest.assertEquals((Object)LinguisticSort.CHINESE_STROKE, (Object)LinguisticSort.get((Locale)new Locale("zh", "", "STROKE")));
        LinguisticSortTest.assertEquals((Object)LinguisticSort.CHINESE_PINYIN, (Object)LinguisticSort.get((Locale)new Locale("zh", "CN", "PINYIN")));
        LinguisticSortTest.assertEquals((Object)LinguisticSort.CHINESE_PINYIN, (Object)LinguisticSort.get((Locale)new Locale("zh", "SG", "PINYIN")));
        LinguisticSortTest.assertEquals((Object)LinguisticSort.CHINESE_PINYIN, (Object)LinguisticSort.get((Locale)new Locale("zh", "", "PINYIN")));
    }
}

