/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util.csv;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.phoenix.thirdparty.com.google.common.base.Joiner;
import org.apache.phoenix.thirdparty.com.google.common.collect.Iterables;
import org.apache.phoenix.util.AbstractUpsertExecutorTest;
import org.apache.phoenix.util.UpsertExecutor;
import org.apache.phoenix.util.csv.CsvUpsertExecutor;
import org.junit.Before;

public class CsvUpsertExecutorTest
extends AbstractUpsertExecutorTest<CSVRecord, String> {
    private static final String ARRAY_SEP = ":";
    private UpsertExecutor<CSVRecord, String> upsertExecutor;

    @Override
    public UpsertExecutor<CSVRecord, String> getUpsertExecutor() {
        return this.upsertExecutor;
    }

    @Override
    public UpsertExecutor<CSVRecord, String> getUpsertExecutor(Connection conn) {
        return new CsvUpsertExecutor(conn, this.columnInfoList, this.preparedStatement, this.upsertListener, ARRAY_SEP);
    }

    @Override
    public CSVRecord createRecord(Object ... columnValues) throws IOException {
        for (int i = 0; i < columnValues.length; ++i) {
            if (columnValues[i] == null) {
                columnValues[i] = "";
            }
            if (!(columnValues[i] instanceof List)) continue;
            columnValues[i] = Joiner.on((String)ARRAY_SEP).join((Iterable)((List)columnValues[i]));
        }
        String inputRecord = Joiner.on((char)',').join(columnValues);
        return (CSVRecord)Iterables.getFirst((Iterable)CSVParser.parse((String)inputRecord, (CSVFormat)CSVFormat.DEFAULT), null);
    }

    @Override
    @Before
    public void setUp() throws SQLException {
        super.setUp();
        this.upsertExecutor = new CsvUpsertExecutor(this.conn, this.columnInfoList, this.preparedStatement, this.upsertListener, ARRAY_SEP);
    }
}

