/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util.bson;

import org.apache.phoenix.expression.util.bson.BsonUpdateInvalidArgumentException;
import org.apache.phoenix.expression.util.bson.UpdateExpressionUtils;
import org.bson.BsonDocument;
import org.bson.RawBsonDocument;
import org.junit.Assert;
import org.junit.Test;

public class UpdateExpressionValidationTest {
    @Test
    public void testUnsetFieldMissing() {
        BsonDocument doc = BsonDocument.parse((String)"{}");
        String updateExpression = "{ \"$UNSET\": { \"a\": null } }";
        RawBsonDocument expressionDoc = RawBsonDocument.parse((String)updateExpression);
        UpdateExpressionUtils.updateExpression((BsonDocument)expressionDoc, (BsonDocument)doc);
        Assert.assertEquals((Object)"{}", (Object)doc.toJson());
    }

    @Test
    public void testUnsetFieldExists() {
        BsonDocument doc = BsonDocument.parse((String)"{ \"a\": \"value\" }");
        String updateExpression = "{ \"$UNSET\": { \"a\": null } }";
        RawBsonDocument expressionDoc = RawBsonDocument.parse((String)updateExpression);
        UpdateExpressionUtils.updateExpression((BsonDocument)expressionDoc, (BsonDocument)doc);
        Assert.assertEquals((Object)"{}", (Object)doc.toJson());
    }

    @Test
    public void testUnsetNestedParentMissing() {
        BsonDocument doc = BsonDocument.parse((String)"{}");
        String updateExpression = "{ \"$UNSET\": { \"a.b\": null } }";
        RawBsonDocument expressionDoc = RawBsonDocument.parse((String)updateExpression);
        try {
            UpdateExpressionUtils.updateExpression((BsonDocument)expressionDoc, (BsonDocument)doc);
            Assert.fail((String)"Expected BsonUpdateInvalidArgumentException");
        }
        catch (BsonUpdateInvalidArgumentException bsonUpdateInvalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testUnsetParentNotMap() {
        BsonDocument doc = BsonDocument.parse((String)"{ \"a\": \"notAMap\" }");
        String updateExpression = "{ \"$UNSET\": { \"a.b\": null } }";
        RawBsonDocument expressionDoc = RawBsonDocument.parse((String)updateExpression);
        try {
            UpdateExpressionUtils.updateExpression((BsonDocument)expressionDoc, (BsonDocument)doc);
            Assert.fail((String)"Expected BsonUpdateInvalidArgumentException");
        }
        catch (BsonUpdateInvalidArgumentException bsonUpdateInvalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testUnsetNestedFieldMissing() {
        BsonDocument doc = BsonDocument.parse((String)"{ \"a\": {} }");
        String updateExpression = "{ \"$UNSET\": { \"a.b\": null } }";
        RawBsonDocument expressionDoc = RawBsonDocument.parse((String)updateExpression);
        UpdateExpressionUtils.updateExpression((BsonDocument)expressionDoc, (BsonDocument)doc);
        Assert.assertEquals((Object)"{\"a\": {}}", (Object)doc.toJson());
    }

    @Test
    public void testUnsetNestedFieldExists() {
        BsonDocument doc = BsonDocument.parse((String)"{ \"a\": { \"b\": \"value\" } }");
        String updateExpression = "{ \"$UNSET\": { \"a.b\": null } }";
        RawBsonDocument expressionDoc = RawBsonDocument.parse((String)updateExpression);
        UpdateExpressionUtils.updateExpression((BsonDocument)expressionDoc, (BsonDocument)doc);
        Assert.assertEquals((Object)"{\"a\": {}}", (Object)doc.toJson());
    }

    @Test
    public void testUnsetArrayParentMissing() {
        BsonDocument doc = BsonDocument.parse((String)"{}");
        String updateExpression = "{ \"$UNSET\": { \"a[0]\": null } }";
        RawBsonDocument expressionDoc = RawBsonDocument.parse((String)updateExpression);
        try {
            UpdateExpressionUtils.updateExpression((BsonDocument)expressionDoc, (BsonDocument)doc);
            Assert.fail((String)"Expected BsonUpdateInvalidArgumentException");
        }
        catch (BsonUpdateInvalidArgumentException bsonUpdateInvalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testUnsetParentNotList() {
        BsonDocument doc = BsonDocument.parse((String)"{ \"a\": \"notAList\" }");
        String updateExpression = "{ \"$UNSET\": { \"a[0]\": null } }";
        RawBsonDocument expressionDoc = RawBsonDocument.parse((String)updateExpression);
        try {
            UpdateExpressionUtils.updateExpression((BsonDocument)expressionDoc, (BsonDocument)doc);
            Assert.fail((String)"Expected BsonUpdateInvalidArgumentException");
        }
        catch (BsonUpdateInvalidArgumentException bsonUpdateInvalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testUnsetArrayIndexOutOfRange() {
        BsonDocument doc = BsonDocument.parse((String)"{ \"a\": [\"item1\"] }");
        String updateExpression = "{ \"$UNSET\": { \"a[5]\": null } }";
        RawBsonDocument expressionDoc = RawBsonDocument.parse((String)updateExpression);
        UpdateExpressionUtils.updateExpression((BsonDocument)expressionDoc, (BsonDocument)doc);
        Assert.assertEquals((Object)"{\"a\": [\"item1\"]}", (Object)doc.toJson());
    }

    @Test
    public void testUnsetArrayIndexValid() {
        BsonDocument doc = BsonDocument.parse((String)"{ \"a\": [\"item1\", \"item2\"] }");
        String updateExpression = "{ \"$UNSET\": { \"a[0]\": null } }";
        RawBsonDocument expressionDoc = RawBsonDocument.parse((String)updateExpression);
        UpdateExpressionUtils.updateExpression((BsonDocument)expressionDoc, (BsonDocument)doc);
        Assert.assertEquals((Object)"{\"a\": [\"item2\"]}", (Object)doc.toJson());
    }

    @Test
    public void testSetFieldMissing() {
        BsonDocument doc = BsonDocument.parse((String)"{}");
        String updateExpression = "{ \"$SET\": { \"a\": \"value\" } }";
        RawBsonDocument expressionDoc = RawBsonDocument.parse((String)updateExpression);
        UpdateExpressionUtils.updateExpression((BsonDocument)expressionDoc, (BsonDocument)doc);
        Assert.assertEquals((Object)"{\"a\": \"value\"}", (Object)doc.toJson());
    }

    @Test
    public void testSetNestedParentMissing() {
        BsonDocument doc = BsonDocument.parse((String)"{}");
        String updateExpression = "{ \"$SET\": { \"a.b\": \"value\" } }";
        RawBsonDocument expressionDoc = RawBsonDocument.parse((String)updateExpression);
        try {
            UpdateExpressionUtils.updateExpression((BsonDocument)expressionDoc, (BsonDocument)doc);
            Assert.fail((String)"Expected BsonUpdateInvalidArgumentException");
        }
        catch (BsonUpdateInvalidArgumentException bsonUpdateInvalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSetNestedFieldMissing() {
        BsonDocument doc = BsonDocument.parse((String)"{ \"a\": {} }");
        String updateExpression = "{ \"$SET\": { \"a.b\": \"value\" } }";
        RawBsonDocument expressionDoc = RawBsonDocument.parse((String)updateExpression);
        UpdateExpressionUtils.updateExpression((BsonDocument)expressionDoc, (BsonDocument)doc);
        Assert.assertEquals((Object)"{\"a\": {\"b\": \"value\"}}", (Object)doc.toJson());
    }

    @Test
    public void testSetParentNotMap() {
        BsonDocument doc = BsonDocument.parse((String)"{ \"a\": \"notAMap\" }");
        String updateExpression = "{ \"$SET\": { \"a.b\": \"value\" } }";
        RawBsonDocument expressionDoc = RawBsonDocument.parse((String)updateExpression);
        try {
            UpdateExpressionUtils.updateExpression((BsonDocument)expressionDoc, (BsonDocument)doc);
            Assert.fail((String)"Expected BsonUpdateInvalidArgumentException");
        }
        catch (BsonUpdateInvalidArgumentException bsonUpdateInvalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSetArrayParentMissing() {
        BsonDocument doc = BsonDocument.parse((String)"{}");
        String updateExpression = "{ \"$SET\": { \"a[0]\": \"value\" } }";
        RawBsonDocument expressionDoc = RawBsonDocument.parse((String)updateExpression);
        try {
            UpdateExpressionUtils.updateExpression((BsonDocument)expressionDoc, (BsonDocument)doc);
            Assert.fail((String)"Expected BsonUpdateInvalidArgumentException");
        }
        catch (BsonUpdateInvalidArgumentException bsonUpdateInvalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSetArrayParentNotList() {
        BsonDocument doc = BsonDocument.parse((String)"{ \"a\": \"notAList\" }");
        String updateExpression = "{ \"$SET\": { \"a[0]\": \"value\" } }";
        RawBsonDocument expressionDoc = RawBsonDocument.parse((String)updateExpression);
        try {
            UpdateExpressionUtils.updateExpression((BsonDocument)expressionDoc, (BsonDocument)doc);
            Assert.fail((String)"Expected BsonUpdateInvalidArgumentException");
        }
        catch (BsonUpdateInvalidArgumentException bsonUpdateInvalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSetArrayIndexBeyondSize1() {
        BsonDocument doc = BsonDocument.parse((String)"{ \"a\": [\"item1\"] }");
        String updateExpression = "{ \"$SET\": { \"a[1]\": \"item2\" } }";
        RawBsonDocument expressionDoc = RawBsonDocument.parse((String)updateExpression);
        UpdateExpressionUtils.updateExpression((BsonDocument)expressionDoc, (BsonDocument)doc);
        Assert.assertEquals((Object)"{\"a\": [\"item1\", \"item2\"]}", (Object)doc.toJson());
    }

    @Test
    public void testSetArrayIndexBeyondSize2() {
        BsonDocument doc = BsonDocument.parse((String)"{ \"a\": [\"item1\"] }");
        String updateExpression = "{ \"$SET\": { \"a[6]\": \"item2\" } }";
        RawBsonDocument expressionDoc = RawBsonDocument.parse((String)updateExpression);
        UpdateExpressionUtils.updateExpression((BsonDocument)expressionDoc, (BsonDocument)doc);
        Assert.assertEquals((Object)"{\"a\": [\"item1\", \"item2\"]}", (Object)doc.toJson());
    }

    @Test
    public void testSetArrayIndexValid() {
        BsonDocument doc = BsonDocument.parse((String)"{ \"a\": [\"item1\", \"item2\"] }");
        String updateExpression = "{ \"$SET\": { \"a[0]\": \"newValue\" } }";
        RawBsonDocument expressionDoc = RawBsonDocument.parse((String)updateExpression);
        UpdateExpressionUtils.updateExpression((BsonDocument)expressionDoc, (BsonDocument)doc);
        Assert.assertEquals((Object)"{\"a\": [\"newValue\", \"item2\"]}", (Object)doc.toJson());
    }

    @Test
    public void testAddFieldNotNumberOrSet() {
        BsonDocument doc = BsonDocument.parse((String)"{ \"a\": \"string\" }");
        String updateExpression = "{ \"$ADD\": { \"a\": 5 } }";
        RawBsonDocument expressionDoc = RawBsonDocument.parse((String)updateExpression);
        try {
            UpdateExpressionUtils.updateExpression((BsonDocument)expressionDoc, (BsonDocument)doc);
            Assert.fail((String)"Expected BsonUpdateInvalidArgumentException");
        }
        catch (BsonUpdateInvalidArgumentException bsonUpdateInvalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAddSetDifferentType() {
        BsonDocument doc = BsonDocument.parse((String)"{ \"a\": { \"$set\": [\"string1\"] } }");
        String updateExpression = "{ \"$ADD\": { \"a\": { \"$set\": [123] } } }";
        RawBsonDocument expressionDoc = RawBsonDocument.parse((String)updateExpression);
        try {
            UpdateExpressionUtils.updateExpression((BsonDocument)expressionDoc, (BsonDocument)doc);
            Assert.fail((String)"Expected BsonUpdateInvalidArgumentException");
        }
        catch (BsonUpdateInvalidArgumentException bsonUpdateInvalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAddNumberMissing() {
        BsonDocument doc = BsonDocument.parse((String)"{}");
        String updateExpression = "{ \"$ADD\": { \"a\": 5 } }";
        RawBsonDocument expressionDoc = RawBsonDocument.parse((String)updateExpression);
        UpdateExpressionUtils.updateExpression((BsonDocument)expressionDoc, (BsonDocument)doc);
        Assert.assertEquals((Object)"{\"a\": 5}", (Object)doc.toJson());
    }

    @Test
    public void testAddNumberExists() {
        BsonDocument doc = BsonDocument.parse((String)"{ \"a\": 10 }");
        String updateExpression = "{ \"$ADD\": { \"a\": 5 } }";
        RawBsonDocument expressionDoc = RawBsonDocument.parse((String)updateExpression);
        UpdateExpressionUtils.updateExpression((BsonDocument)expressionDoc, (BsonDocument)doc);
        Assert.assertEquals((Object)"{\"a\": 15}", (Object)doc.toJson());
    }

    @Test
    public void testAddSetMissing() {
        BsonDocument doc = BsonDocument.parse((String)"{}");
        String updateExpression = "{ \"$ADD\": { \"a\": { \"$set\": [\"item1\"] } } }";
        RawBsonDocument expressionDoc = RawBsonDocument.parse((String)updateExpression);
        UpdateExpressionUtils.updateExpression((BsonDocument)expressionDoc, (BsonDocument)doc);
        Assert.assertEquals((Object)"{\"a\": {\"$set\": [\"item1\"]}}", (Object)doc.toJson());
    }

    @Test
    public void testAddSetSameType() {
        BsonDocument doc = BsonDocument.parse((String)"{ \"a\": { \"$set\": [\"item1\"] } }");
        String updateExpression = "{ \"$ADD\": { \"a\": { \"$set\": [\"item2\"] } } }";
        RawBsonDocument expressionDoc = RawBsonDocument.parse((String)updateExpression);
        UpdateExpressionUtils.updateExpression((BsonDocument)expressionDoc, (BsonDocument)doc);
        BsonDocument result = doc;
        String json = result.toJson();
        assert (json.contains("item1"));
        assert (json.contains("item2"));
    }

    @Test
    public void testDeleteFromSetMissing() {
        BsonDocument doc = BsonDocument.parse((String)"{}");
        String updateExpression = "{ \"$DELETE_FROM_SET\": { \"a\": { \"$set\": [\"item1\"] } } }";
        RawBsonDocument expressionDoc = RawBsonDocument.parse((String)updateExpression);
        UpdateExpressionUtils.updateExpression((BsonDocument)expressionDoc, (BsonDocument)doc);
        Assert.assertEquals((Object)"{}", (Object)doc.toJson());
    }

    @Test
    public void testDeleteFromSetNotSet() {
        BsonDocument doc = BsonDocument.parse((String)"{ \"a\": \"string\" }");
        String updateExpression = "{ \"$DELETE_FROM_SET\": { \"a\": { \"$set\": [\"item1\"] } } }";
        RawBsonDocument expressionDoc = RawBsonDocument.parse((String)updateExpression);
        try {
            UpdateExpressionUtils.updateExpression((BsonDocument)expressionDoc, (BsonDocument)doc);
            Assert.fail((String)"Expected BsonUpdateInvalidArgumentException");
        }
        catch (BsonUpdateInvalidArgumentException bsonUpdateInvalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testDeleteFromSetDifferentType() {
        BsonDocument doc = BsonDocument.parse((String)"{ \"a\": { \"$set\": [\"string1\"] } }");
        String updateExpression = "{ \"$DELETE_FROM_SET\": { \"a\": { \"$set\": [123] } } }";
        RawBsonDocument expressionDoc = RawBsonDocument.parse((String)updateExpression);
        try {
            UpdateExpressionUtils.updateExpression((BsonDocument)expressionDoc, (BsonDocument)doc);
            Assert.fail((String)"Expected BsonUpdateInvalidArgumentException");
        }
        catch (BsonUpdateInvalidArgumentException bsonUpdateInvalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testDeleteFromSetSameType() {
        BsonDocument doc = BsonDocument.parse((String)"{ \"a\": { \"$set\": [\"item1\", \"item2\", \"item3\"] } }");
        String updateExpression = "{ \"$DELETE_FROM_SET\": { \"a\": { \"$set\": [\"item2\"] } } }";
        RawBsonDocument expressionDoc = RawBsonDocument.parse((String)updateExpression);
        UpdateExpressionUtils.updateExpression((BsonDocument)expressionDoc, (BsonDocument)doc);
        String json = doc.toJson();
        assert (json.contains("item1"));
        assert (json.contains("item3"));
        assert (!json.contains("item2"));
    }
}

