/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util.bson;

import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.expression.util.bson.SQLComparisonExpressionUtils;
import org.bson.BsonBinary;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.RawBsonDocument;
import org.junit.Assert;
import org.junit.Test;

public class ComparisonExpressionUtils2Test {
    @Test
    public void testSQLComparisonExpression1() {
        RawBsonDocument rawBsonDocument = ComparisonExpressionUtils2Test.getDocumentValue();
        BsonDocument compareValues = ComparisonExpressionUtils2Test.getCompareValDocument();
        BsonDocument keyNames = ComparisonExpressionUtils2Test.getKeyNamesDocument();
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"(field_exists(#id) OR field_not_exists(#title))", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues, (BsonDocument)keyNames));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"((field_not_exists(#id) AND field_not_exists(#title1)) OR field_exists(#isbn2)) OR ((#id <> :title) AND ((#4 = :inpublication) OR ((#isbn = :isbn) AND (#title = :title))))", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues, (BsonDocument)keyNames));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"((field_exists(#nestedmap1.#isbn) AND field_not_exists(#nestedmap1.#nlist1[3])))", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues, (BsonDocument)keyNames));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"#nestedmap1.#id = :id AND (#nestedmap1.#4 = :inpublication)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues, (BsonDocument)keyNames));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"((#nestedmap1.#id = :id) AND ((#nestedmap1.#4[0] = :inpublication) OR ((#isbn[0] = :isbn) AND (#title = :title))) OR (#nestedmap1.#nlist1[0] = :nmap1_nlist1))", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues, (BsonDocument)keyNames));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"((field_not_exists(#id) AND field_not_exists(#title1)) OR field_exists(#isbn2)) OR ((#nestedmap1.#id = :id) AND ((#nestedmap1.#4 = :inpublication) OR ((#isbn = :isbn) AND (#title = :title))))", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues, (BsonDocument)keyNames));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"#nestedlist1[0] <= :nestedlist1_485 AND #nestedlist1[1] > :nestedlist1_1 AND #nestedlist1[2][0] >= :nestedlist1_xyz0123 AND #nestedlist1[2][1].#id < :id1 AND #ids < :ids1 AND #id2 > :id2 AND #nestedmap1.#nlist1[2] > :nestedmap1_nlist1_3", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues, (BsonDocument)keyNames));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"#nestedlist1[0] <= :nestedlist1_485 AND #nestedlist1[1] >= :nestedlist1_1 AND #8 >= :nestedlist1_xyz0123 AND #nestedlist1[2][1].#id <= :id1 AND #ids <= :ids1 AND #id2 >= :id2 AND #nestedmap1.#nlist1[2] >= :nestedmap1_nlist1_3", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues, (BsonDocument)keyNames));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"#nestedlist1[0] >= :nestedlist1_4850 AND #nestedlist1[1] < :nestedlist1_10 AND #nestedlist1[2][0] >= :nestedlist1_xyz0123 AND #nestedlist1[2][1].#id > :id10 AND #ids > :ids10 AND #id2 < :id20 AND #nestedmap1.#nlist1[2] < :nestedmap1_nlist1_30", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues, (BsonDocument)keyNames));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"#nestedlist1[0] >= :nestedlist1_4850 AND #nestedlist1[1] <= :nestedlist1_10 AND #nestedlist1[2][0] >= :nestedlist1_xyz0123 AND #nestedlist1[2][1].#id >= :id10 AND #ids >= :ids10 AND #id2 <= :id20 AND #nestedmap1.#nlist1[2] <= :nestedmap1_nlist1_30 AND #nestedmap1.#nlist1[2] <> :nestedmap1_nlist1_30", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues, (BsonDocument)keyNames));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"#nestedlist1[0] >= :nestedlist1_4850 AND #nestedlist1[1] <= :nestedlist1_10 AND #nestedlist1[2][0] >= :nestedlist1_xyz0123 AND #nestedlist1[2][1].#id >= :id10 AND #ids >= :ids10 AND #id2 <= :id20 AND #nestedmap1.#nlist1[2] <= :nestedmap1_nlist1_30 AND (#nestedmap1.#nlist1[2] = :nestedmap1_nlist1_30 OR #nestedlist1[0] BETWEEN :nestedlist1_4850 AND :id2)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues, (BsonDocument)keyNames));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"#nestedlist1[0] >= :nestedlist1_4850 AND #nestedlist1[1] <= :nestedlist1_10 AND #nestedlist1[2][0] >= :nestedlist1_xyz0123 AND #nestedmap1.#nlist1[0] IN (:id, :id1, :id20, :nmap1_nlist1) AND #nestedmap1.#nlist1[2] <= :nestedmap1_nlist1_30 AND (#nestedmap1.#nlist1[2] = :nestedmap1_nlist1_30 OR #nestedlist1[0] BETWEEN :nestedlist1_4850 AND :id2)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues, (BsonDocument)keyNames));
        Assert.assertTrue((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"#nestedlist1[0] >= :nestedlist1_4850 AND #nestedlist1[1] <= :nestedlist1_10 AND #nestedlist1[2][0] >= :nestedlist1_xyz0123 AND #nestedmap1.#nlist1[0] IN (:id,  :id1, :id20, :nmap1_nlist1) AND #nestedmap1.#nlist1[2] <= :nestedmap1_nlist1_30 AND (#nestedmap1.#nlist1[2] = :nestedmap1_nlist1_30 OR  #nestedlist1[0] BETWEEN :nestedlist1_4850 AND :id2) AND NOT #nestedmap1.#4 IN (:id, :id1, :id20, :id21) AND #7 = :7 AND #10 >= :id2 AND #11 <= :id2 AND #12 = :id2 AND #13 = :id2 AND NOT #14 <> :id2", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues, (BsonDocument)keyNames));
    }

    @Test
    public void testSQLComparisonExpression2() {
        RawBsonDocument rawBsonDocument = ComparisonExpressionUtils2Test.getDocumentValue();
        BsonDocument compareValues = ComparisonExpressionUtils2Test.getCompareValDocument();
        BsonDocument keyNames = ComparisonExpressionUtils2Test.getKeyNamesDocument();
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"(field_not_exists(#id) OR field_not_exists(#title))", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues, (BsonDocument)keyNames));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"((field_not_exists(#id) AND field_not_exists(#title1)) OR field_exists(#isbn2)) OR ((#id = :title) AND ((#4 = #4) OR ((#isbn = :isbn) AND (#title = :title))))", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues, (BsonDocument)keyNames));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"((field_exists(#nestedmap1.#isbn) AND field_exists(#nestedmap1.#nlist1[3])))", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues, (BsonDocument)keyNames));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"#nestedmap1.#id = :id AND (#nestedmap1.#4 <> :inpublication)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues, (BsonDocument)keyNames));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"((#nestedmap1.#id = :id) AND ((#nestedmap1.#4[0] = :inpublication) OR ((#isbn[0] = :isbn) AND (#title = :title))) OR (#nestedmap1.#nlist1[0] <> :nmap1_nlist1))", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues, (BsonDocument)keyNames));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"((field_not_exists(#id) AND field_not_exists(#title1)) OR field_exists(#isbn2)) OR ((#nestedmap1.#id = :id) AND ((#nestedmap1.#4 <> :inpublication) OR NOT ((#isbn = :isbn) AND (#title = :title))))", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues, (BsonDocument)keyNames));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"#nestedlist1[0] <= :nestedlist1_485 AND #nestedlist1[1] > :nestedlist1_1 AND #nestedlist1[2][0] >= :nestedlist1_xyz0123 AND #nestedlist1[2][1].#id < :id1 AND #ids < :ids1 AND #id2 > :id2 AND #nestedmap1.#nlist1[2] < :nestedmap1_nlist1_3", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues, (BsonDocument)keyNames));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"#nestedlist1[0] <= :nestedlist1_485 AND #nestedlist1[1] >= :nestedlist1_1 AND #nestedlist1[2][0] >= :nestedlist1_xyz0123 AND #nestedlist1[2][1].#id <= :id1 AND #ids <= :ids1 AND #id2 >= :id2 AND #nestedmap1.#nlist1[2] < :nestedmap1_nlist1_3", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues, (BsonDocument)keyNames));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"#nestedlist1[0] >= :nestedlist1_4850 AND #nestedlist1[1] < :nestedlist1_10 AND #nestedlist1[2][0] >= :nestedlist1_xyz0123 AND #nestedlist1[2][1].#id > :id10 AND #ids > :ids10 AND #id2 < :id20 AND #nestedmap1.#nlist1[2] >= :nestedmap1_nlist1_30", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues, (BsonDocument)keyNames));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"#nestedlist1[0] >= :nestedlist1_4850 AND #nestedlist1[1] <= :nestedlist1_10 AND #nestedlist1[2][0] >= :nestedlist1_xyz0123 AND #nestedlist1[2][1].#id >= :id10 AND #ids >= :ids10 AND #id2 <= :id20 AND #nestedmap1.#nlist1[2] > :nestedmap1_nlist1_30 AND #nestedmap1.#nlist1[2] <> :nestedmap1_nlist1_30", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues, (BsonDocument)keyNames));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"#nestedlist1[0] >= :nestedlist1_4850 AND #nestedlist1[1] <= :nestedlist1_10 AND #nestedlist1[2][0] >= :nestedlist1_xyz0123 AND #nestedlist1[2][1].#id >= :id10 AND #ids >= :ids10 AND #id2 <= :id20 AND #nestedmap1.#nlist1[2] <= :nestedmap1_nlist1_30 AND (#nestedmap1.#nlist1[2] = :nestedmap1_nlist1_30 OR NOT #nestedlist1[0] BETWEEN :nestedlist1_4850 AND :id2)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues, (BsonDocument)keyNames));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"#nestedlist1[0] >= :nestedlist1_4850 AND #nestedlist1[1] <= :nestedlist1_10 AND #nestedlist1[2][0] >= :nestedlist1_xyz0123 AND #nestedmap1.#nlist1[0] NOT IN (:id, :id1, :id20, :nmap1_nlist1) AND #nestedmap1.#nlist1[2] <= :nestedmap1_nlist1_30 AND (#nestedmap1.#nlist1[2] = :nestedmap1_nlist1_30 OR #nestedlist1[0] BETWEEN :nestedlist1_4850 AND :id2)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues, (BsonDocument)keyNames));
        Assert.assertFalse((boolean)SQLComparisonExpressionUtils.evaluateConditionExpression((String)"#nestedlist1[0] >= :nestedlist1_4850 AND #nestedlist1[1] <= :nestedlist1_10 AND #nestedlist1[2][0] >= :nestedlist1_xyz0123 AND #nestedmap1.#nlist1[0] IN (:id,  :id1, :id20, :nmap1_nlist1) AND #nestedmap1.#nlist1[2] <= :nestedmap1_nlist1_30 AND (#nestedmap1.#nlist1[2] = :nestedmap1_nlist1_30 OR  #nestedlist1[0] NOT BETWEEN :nestedlist1_4850 AND :id2) AND #nestedmap1.#4 IN (:id, :id1, :id20, :id21)", (RawBsonDocument)rawBsonDocument, (BsonDocument)compareValues, (BsonDocument)keyNames));
    }

    private static BsonDocument getCompareValDocument() {
        BsonDocument compareValues = new BsonDocument();
        compareValues.append(":id20", (BsonValue)new BsonDouble(101.011));
        compareValues.append(":id2", (BsonValue)new BsonInt32(12));
        compareValues.append(":nestedlist1_10", (BsonValue)new BsonString("1234abce"));
        compareValues.append(":id1", (BsonValue)new BsonInt32(120));
        compareValues.append(":id10", (BsonValue)new BsonInt32(101));
        compareValues.append(":gt", (BsonValue)new BsonInt32(100));
        compareValues.append(":ids1", (BsonValue)new BsonString("12"));
        compareValues.append(":isbn", (BsonValue)new BsonString("111-1111111111"));
        compareValues.append(":nestedlist1_xyz0123", (BsonValue)new BsonString("xyz0123"));
        compareValues.append(":nestedlist1_485", (BsonValue)new BsonDouble(-485.33));
        compareValues.append(":nestedmap1_nlist1_30", (BsonValue)new BsonBinary(Bytes.toBytes((String)"Whitee")));
        compareValues.append(":inpublication", (BsonValue)new BsonBoolean(false));
        compareValues.append(":ids10", (BsonValue)new BsonString("100"));
        compareValues.append(":nestedmap1_nlist1_3", (BsonValue)new BsonBinary(Bytes.toBytes((String)"Whit")));
        compareValues.append(":nestedlist1_1", (BsonValue)new BsonString("1234abcc"));
        compareValues.append(":nmap1_nlist1", (BsonValue)new BsonString("NListVal01"));
        compareValues.append(":nestedlist1_4850", (BsonValue)new BsonDouble(-485.35));
        compareValues.append(":id", (BsonValue)new BsonDouble(101.01));
        compareValues.append(":title", (BsonValue)new BsonString("Book 101 Title"));
        compareValues.append(":zero", (BsonValue)new BsonInt32(0));
        compareValues.append(":id21", (BsonValue)new BsonInt32(121));
        compareValues.append(":7", (BsonValue)new BsonString("Name_"));
        return compareValues;
    }

    private static BsonDocument getKeyNamesDocument() {
        BsonDocument keyNames = new BsonDocument();
        keyNames.append("#id", (BsonValue)new BsonString("Id"));
        keyNames.append("#title", (BsonValue)new BsonString("Title"));
        keyNames.append("#title1", (BsonValue)new BsonString("Title1"));
        keyNames.append("#isbn", (BsonValue)new BsonString("ISBN"));
        keyNames.append("#isbn2", (BsonValue)new BsonString("ISBN2"));
        keyNames.append("#4", (BsonValue)new BsonString("InPublication"));
        keyNames.append("#nestedmap1", (BsonValue)new BsonString("NestedMap1"));
        keyNames.append("#nestedlist1", (BsonValue)new BsonString("NestedList1"));
        keyNames.append("#nlist1", (BsonValue)new BsonString("NList1"));
        keyNames.append("#ids", (BsonValue)new BsonString("IdS"));
        keyNames.append("#id2", (BsonValue)new BsonString("Id2"));
        keyNames.append("#7", (BsonValue)new BsonString("Id.Name"));
        keyNames.append("#8", (BsonValue)new BsonString("NestedList1[2][0]"));
        keyNames.append("#10", (BsonValue)new BsonString(">"));
        keyNames.append("#11", (BsonValue)new BsonString("["));
        keyNames.append("#12", (BsonValue)new BsonString("#"));
        keyNames.append("#13", (BsonValue)new BsonString("~"));
        keyNames.append("#14", (BsonValue)new BsonString("^"));
        return keyNames;
    }

    private static RawBsonDocument getDocumentValue() {
        String json = "{\n  \"InPublication\" : false,\n  \"ISBN\" : \"111-1111111111\",\n  \"NestedList1\" : [ -485.34, \"1234abcd\", [ \"xyz0123\", {\n    \"InPublication\" : false,\n    \"ISBN\" : \"111-1111111111\",\n    \"Title\" : \"Book 101 Title\",\n    \"Id\" : 101.01\n  } ] ],\n  \"NestedMap1\" : {\n    \"InPublication\" : false,\n    \"ISBN\" : \"111-1111111111\",\n    \"Title\" : \"Book 101 Title\",\n    \"Id\" : 101.01,\n    \"NList1\" : [ \"NListVal01\", -23.4, {\n      \"$binary\" : {\n        \"base64\" : \"V2hpdGU=\",\n        \"subType\" : \"00\"\n      }\n    } ]\n  },\n  \"Id2\" : 101.01,\n  \"Id.Name\" : \"Name_\",\n  \"IdS\" : \"101.01\",\n  \">\" : 12,\n   \"[\" : 12,\n   \"#\" : 12,\n   \"~\" : 12,\n   \"^\" : 12,\n   \"Title\" : \"Book 101 Title\",\n  \"Id\" : 101.01\n}";
        return RawBsonDocument.parse((String)json);
    }
}

