/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.ServerSocket;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.CompactionState;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.CoprocessorDescriptor;
import org.apache.hadoop.hbase.client.CoprocessorDescriptorBuilder;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcUtils;
import org.apache.hadoop.hbase.ipc.ServerRpcController;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.compile.AggregationManager;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.compile.FromCompiler;
import org.apache.phoenix.compile.JoinCompiler;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.SequenceManager;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.compile.StatementNormalizer;
import org.apache.phoenix.compile.SubqueryRewriter;
import org.apache.phoenix.compile.SubselectRewriter;
import org.apache.phoenix.coprocessor.CompactionScanner;
import org.apache.phoenix.coprocessor.generated.MetaDataProtos;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.expression.AndExpression;
import org.apache.phoenix.expression.ByteBasedLikeExpression;
import org.apache.phoenix.expression.ComparisonExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.InListExpression;
import org.apache.phoenix.expression.KeyValueColumnExpression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.NotExpression;
import org.apache.phoenix.expression.OrExpression;
import org.apache.phoenix.expression.RowKeyColumnExpression;
import org.apache.phoenix.expression.StringBasedLikeExpression;
import org.apache.phoenix.expression.aggregator.ClientAggregators;
import org.apache.phoenix.expression.function.SubstrFunction;
import org.apache.phoenix.expression.function.SumAggregateFunction;
import org.apache.phoenix.filter.MultiCQKeyValueComparisonFilter;
import org.apache.phoenix.filter.MultiEncodedCQKeyValueComparisonFilter;
import org.apache.phoenix.filter.MultiKeyValueComparisonFilter;
import org.apache.phoenix.filter.RowKeyComparisonFilter;
import org.apache.phoenix.filter.SingleCQKeyValueComparisonFilter;
import org.apache.phoenix.filter.SingleKeyValueComparisonFilter;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.jdbc.PhoenixResultSet;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.parse.FilterableStatement;
import org.apache.phoenix.parse.LikeParseNode;
import org.apache.phoenix.parse.SQLParser;
import org.apache.phoenix.parse.SelectStatement;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.LiteralTTLExpression;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PDatum;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PLongColumn;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.RowKeyValueAccessor;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TTLExpression;
import org.apache.phoenix.schema.TTLExpressionFactory;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.stats.GuidePostsInfo;
import org.apache.phoenix.schema.stats.GuidePostsKey;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.thirdparty.com.google.common.base.Objects;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.DateUtil;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestUtil.class);
    private static final Long ZERO = new Long(0L);
    public static final String DEFAULT_SCHEMA_NAME = "S";
    public static final String DEFAULT_DATA_TABLE_NAME = "T";
    public static final String DEFAULT_INDEX_TABLE_NAME = "I";
    public static final String DEFAULT_DATA_TABLE_FULL_NAME = SchemaUtil.getTableName((String)"S", (String)"T");
    public static final String DEFAULT_INDEX_TABLE_FULL_NAME = SchemaUtil.getTableName((String)"S", (String)"I");
    public static final String TEST_TABLE_SCHEMA = "(   varchar_pk VARCHAR NOT NULL,    char_pk CHAR(10) NOT NULL,    int_pk INTEGER NOT NULL,    long_pk BIGINT NOT NULL,    decimal_pk DECIMAL(31, 10) NOT NULL,    date_pk DATE NOT NULL,    a.varchar_col1 VARCHAR,    a.char_col1 CHAR(10),    a.int_col1 INTEGER,    a.long_col1 BIGINT,    a.decimal_col1 DECIMAL(31, 10),    a.date1 DATE,    b.varchar_col2 VARCHAR,    b.char_col2 CHAR(10),    b.int_col2 INTEGER,    b.long_col2 BIGINT,    b.decimal_col2 DECIMAL(31, 10),    b.date2 DATE    CONSTRAINT pk PRIMARY KEY (varchar_pk, char_pk, int_pk, long_pk DESC, decimal_pk, date_pk)) ";
    public static final String CF_NAME = "a";
    public static final byte[] CF = Bytes.toBytes((String)"a");
    public static final String CF2_NAME = "b";
    public static final String A_VALUE = "a";
    public static final byte[] A = Bytes.toBytes((String)"a");
    public static final String B_VALUE = "b";
    public static final byte[] B = Bytes.toBytes((String)"b");
    public static final String C_VALUE = "c";
    public static final byte[] C = Bytes.toBytes((String)"c");
    public static final String D_VALUE = "d";
    public static final byte[] D = Bytes.toBytes((String)"d");
    public static final String E_VALUE = "e";
    public static final byte[] E = Bytes.toBytes((String)"e");
    public static final String ROW1 = "00A123122312312";
    public static final String ROW2 = "00A223122312312";
    public static final String ROW3 = "00A323122312312";
    public static final String ROW4 = "00A423122312312";
    public static final String ROW5 = "00B523122312312";
    public static final String ROW6 = "00B623122312312";
    public static final String ROW7 = "00B723122312312";
    public static final String ROW8 = "00B823122312312";
    public static final String ROW9 = "00C923122312312";
    public static final String PARENTID1 = "0500x0000000001";
    public static final String PARENTID2 = "0500x0000000002";
    public static final String PARENTID3 = "0500x0000000003";
    public static final String PARENTID4 = "0500x0000000004";
    public static final String PARENTID5 = "0500x0000000005";
    public static final String PARENTID6 = "0500x0000000006";
    public static final String PARENTID7 = "0500x0000000007";
    public static final String PARENTID8 = "0500x0000000008";
    public static final String PARENTID9 = "0500x0000000009";
    public static final List<String> PARENTIDS = Lists.newArrayList((Object[])new String[]{"0500x0000000001", "0500x0000000002", "0500x0000000003", "0500x0000000004", "0500x0000000005", "0500x0000000006", "0500x0000000007", "0500x0000000008", "0500x0000000009"});
    public static final String ENTITYHISTID1 = "017x00000000001";
    public static final String ENTITYHISTID2 = "017x00000000002";
    public static final String ENTITYHISTID3 = "017x00000000003";
    public static final String ENTITYHISTID4 = "017x00000000004";
    public static final String ENTITYHISTID5 = "017x00000000005";
    public static final String ENTITYHISTID6 = "017x00000000006";
    public static final String ENTITYHISTID7 = "017x00000000007";
    public static final String ENTITYHISTID8 = "017x00000000008";
    public static final String ENTITYHISTID9 = "017x00000000009";
    public static final List<String> ENTITYHISTIDS = Lists.newArrayList((Object[])new String[]{"017x00000000001", "017x00000000002", "017x00000000003", "017x00000000004", "017x00000000005", "017x00000000006", "017x00000000007", "017x00000000008", "017x00000000009"});
    public static final String LOCALHOST = "localhost";
    public static final String PHOENIX_JDBC_URL = "jdbc:phoenix:localhost;test=true";
    public static final String PHOENIX_CONNECTIONLESS_JDBC_URL = "jdbc:phoenix:none;test=true";
    public static final String TEST_SCHEMA_FILE_NAME = "config" + File.separator + "test-schema.xml";
    public static final String CED_SCHEMA_FILE_NAME = "config" + File.separator + "schema.xml";
    public static final String ENTITY_HISTORY_TABLE_NAME = "ENTITY_HISTORY";
    public static final String ENTITY_HISTORY_SALTED_TABLE_NAME = "ENTITY_HISTORY_SALTED";
    public static final String ATABLE_NAME = "ATABLE";
    public static final String TABLE_WITH_ARRAY = "TABLE_WITH_ARRAY";
    public static final String SUM_DOUBLE_NAME = "SumDoubleTest";
    public static final String ATABLE_SCHEMA_NAME = "";
    public static final String BTABLE_NAME = "BTABLE";
    public static final String STABLE_NAME = "STABLE";
    public static final String STABLE_PK_NAME = "ID";
    public static final String STABLE_SCHEMA_NAME = "";
    public static final String CUSTOM_ENTITY_DATA_FULL_NAME = "CORE.CUSTOM_ENTITY_DATA";
    public static final String CUSTOM_ENTITY_DATA_NAME = "CUSTOM_ENTITY_DATA";
    public static final String CUSTOM_ENTITY_DATA_SCHEMA_NAME = "CORE";
    public static final String HBASE_NATIVE = "HBASE_NATIVE";
    public static final String HBASE_NATIVE_SCHEMA_NAME = "";
    public static final String HBASE_DYNAMIC_COLUMNS = "HBASE_DYNAMIC_COLUMNS";
    public static final String HBASE_DYNAMIC_COLUMNS_SCHEMA_NAME = "";
    public static final String PRODUCT_METRICS_NAME = "PRODUCT_METRICS";
    public static final String PTSDB_NAME = "PTSDB";
    public static final String PTSDB2_NAME = "PTSDB2";
    public static final String PTSDB3_NAME = "PTSDB3";
    public static final String PTSDB_SCHEMA_NAME = "";
    public static final String FUNKY_NAME = "FUNKY_NAMES";
    public static final String MULTI_CF_NAME = "MULTI_CF";
    public static final String MDTEST_NAME = "MDTEST";
    public static final String MDTEST_SCHEMA_NAME = "";
    public static final String KEYONLY_NAME = "KEYONLY";
    public static final String TABLE_WITH_SALTING = "TABLE_WITH_SALTING";
    public static final String INDEX_DATA_SCHEMA = "INDEX_TEST";
    public static final String INDEX_DATA_TABLE = "INDEX_DATA_TABLE";
    public static final String MUTABLE_INDEX_DATA_TABLE = "MUTABLE_INDEX_DATA_TABLE";
    public static final String TRANSACTIONAL_DATA_TABLE = "TRANSACTIONAL_DATA_TABLE";
    public static final String JOIN_SCHEMA = "Join";
    public static final String JOIN_ORDER_TABLE = "OrderTable";
    public static final String JOIN_CUSTOMER_TABLE = "CustomerTable";
    public static final String JOIN_ITEM_TABLE = "ItemTable";
    public static final String JOIN_SUPPLIER_TABLE = "SupplierTable";
    public static final String JOIN_COITEM_TABLE = "CoitemTable";
    public static final String JOIN_ORDER_TABLE_FULL_NAME = "\"Join\".\"OrderTable\"";
    public static final String JOIN_CUSTOMER_TABLE_FULL_NAME = "\"Join\".\"CustomerTable\"";
    public static final String JOIN_ITEM_TABLE_FULL_NAME = "\"Join\".\"ItemTable\"";
    public static final String JOIN_SUPPLIER_TABLE_FULL_NAME = "\"Join\".\"SupplierTable\"";
    public static final String JOIN_COITEM_TABLE_FULL_NAME = "\"Join\".\"CoitemTable\"";
    public static final String JOIN_ORDER_TABLE_DISPLAY_NAME = "Join.OrderTable";
    public static final String JOIN_CUSTOMER_TABLE_DISPLAY_NAME = "Join.CustomerTable";
    public static final String JOIN_ITEM_TABLE_DISPLAY_NAME = "Join.ItemTable";
    public static final String JOIN_SUPPLIER_TABLE_DISPLAY_NAME = "Join.SupplierTable";
    public static final String JOIN_COITEM_TABLE_DISPLAY_NAME = "Join.CoitemTable";
    public static final String BINARY_NAME = "BinaryTable";
    public static final Properties TEST_PROPERTIES = new Properties(){

        @Override
        public String put(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }
    };

    private TestUtil() {
    }

    public static byte[][] getSplits(String tenantId) {
        return new byte[][]{HConstants.EMPTY_BYTE_ARRAY, Bytes.toBytes((String)(tenantId + "00A")), Bytes.toBytes((String)(tenantId + "00B")), Bytes.toBytes((String)(tenantId + "00C"))};
    }

    public static void assertRoundEquals(BigDecimal bd1, BigDecimal bd2) {
        if ((bd1 = bd1.round(PDataType.DEFAULT_MATH_CONTEXT)).compareTo(bd2 = bd2.round(PDataType.DEFAULT_MATH_CONTEXT)) != 0) {
            Assert.fail((String)("expected:<" + bd1 + "> but was:<" + bd2 + ">"));
        }
    }

    public static BigDecimal computeAverage(double sum, long count) {
        return BigDecimal.valueOf(sum).divide(BigDecimal.valueOf(count), PDataType.DEFAULT_MATH_CONTEXT);
    }

    public static BigDecimal computeAverage(long sum, long count) {
        return BigDecimal.valueOf(sum).divide(BigDecimal.valueOf(count), PDataType.DEFAULT_MATH_CONTEXT);
    }

    public static Expression constantComparison(CompareOperator op, PColumn c, Object o) {
        return new ComparisonExpression(Arrays.asList(new KeyValueColumnExpression(c), LiteralExpression.newConstant((Object)o)), op);
    }

    public static Expression kvColumn(PColumn c) {
        return new KeyValueColumnExpression(c);
    }

    public static Expression pkColumn(PColumn c, List<PColumn> columns) {
        return new RowKeyColumnExpression((PDatum)c, new RowKeyValueAccessor(columns, columns.indexOf(c)));
    }

    public static Expression constantComparison(CompareOperator op, Expression e, Object o) {
        return new ComparisonExpression(Arrays.asList(e, LiteralExpression.newConstant((Object)o)), op);
    }

    private static boolean useByteBasedRegex(StatementContext context) {
        return context.getConnection().getQueryServices().getProps().getBoolean("phoenix.regex.byteBased", false);
    }

    public static Expression like(Expression e, Object o, StatementContext context) {
        return TestUtil.useByteBasedRegex(context) ? ByteBasedLikeExpression.create(Arrays.asList(e, LiteralExpression.newConstant((Object)o)), (LikeParseNode.LikeType)LikeParseNode.LikeType.CASE_SENSITIVE) : StringBasedLikeExpression.create(Arrays.asList(e, LiteralExpression.newConstant((Object)o)), (LikeParseNode.LikeType)LikeParseNode.LikeType.CASE_SENSITIVE);
    }

    public static Expression ilike(Expression e, Object o, StatementContext context) {
        return TestUtil.useByteBasedRegex(context) ? ByteBasedLikeExpression.create(Arrays.asList(e, LiteralExpression.newConstant((Object)o)), (LikeParseNode.LikeType)LikeParseNode.LikeType.CASE_INSENSITIVE) : StringBasedLikeExpression.create(Arrays.asList(e, LiteralExpression.newConstant((Object)o)), (LikeParseNode.LikeType)LikeParseNode.LikeType.CASE_INSENSITIVE);
    }

    public static Expression substr(Expression e, Object offset, Object length) {
        return new SubstrFunction(Arrays.asList(e, LiteralExpression.newConstant((Object)offset), LiteralExpression.newConstant((Object)length)));
    }

    public static Expression substr2(Expression e, Object offset) {
        return new SubstrFunction(Arrays.asList(e, LiteralExpression.newConstant((Object)offset), LiteralExpression.newConstant(null)));
    }

    public static Expression columnComparison(CompareOperator op, Expression c1, Expression c2) {
        return new ComparisonExpression(Arrays.asList(c1, c2), op);
    }

    public static SingleKeyValueComparisonFilter singleKVFilter(Expression e) {
        return new SingleCQKeyValueComparisonFilter(e);
    }

    public static RowKeyComparisonFilter rowKeyFilter(Expression e) {
        return new RowKeyComparisonFilter(e, QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES);
    }

    public static MultiKeyValueComparisonFilter multiKVFilter(Expression e) {
        return new MultiCQKeyValueComparisonFilter(e, false, ByteUtil.EMPTY_BYTE_ARRAY);
    }

    public static MultiEncodedCQKeyValueComparisonFilter multiEncodedKVFilter(Expression e, PTable.QualifierEncodingScheme encodingScheme) {
        return new MultiEncodedCQKeyValueComparisonFilter(e, encodingScheme, false, null);
    }

    public static Expression and(Expression ... expressions) {
        return new AndExpression(Arrays.asList(expressions));
    }

    public static Expression not(Expression expression) {
        return new NotExpression(expression);
    }

    public static Expression or(Expression ... expressions) {
        return new OrExpression(Arrays.asList(expressions));
    }

    public static Expression in(Expression ... expressions) throws SQLException {
        return InListExpression.create(Arrays.asList(expressions), (boolean)false, (ImmutableBytesWritable)new ImmutableBytesWritable(), (boolean)true);
    }

    public static Expression in(Expression e, Object ... literals) throws SQLException {
        PDataType childType = e.getDataType();
        ArrayList<Object> expressions = new ArrayList<Object>(literals.length + 1);
        expressions.add(e);
        for (Object o : literals) {
            expressions.add(LiteralExpression.newConstant((Object)o, (PDataType)childType));
        }
        return InListExpression.create(expressions, (boolean)false, (ImmutableBytesWritable)new ImmutableBytesWritable(), (boolean)true);
    }

    public static void assertDegenerate(StatementContext context) {
        Scan scan = context.getScan();
        TestUtil.assertDegenerate(scan);
    }

    public static void assertDegenerate(Scan scan) {
        Assert.assertNull((Object)scan.getFilter());
        Assert.assertArrayEquals((byte[])KeyRange.EMPTY_RANGE.getLowerRange(), (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])KeyRange.EMPTY_RANGE.getLowerRange(), (byte[])scan.getStopRow());
        Assert.assertEquals(null, (Object)scan.getFilter());
    }

    public static void assertNotDegenerate(Scan scan) {
        Assert.assertFalse((Bytes.compareTo((byte[])KeyRange.EMPTY_RANGE.getLowerRange(), (byte[])scan.getStartRow()) == 0 && Bytes.compareTo((byte[])KeyRange.EMPTY_RANGE.getLowerRange(), (byte[])scan.getStopRow()) == 0 ? 1 : 0) != 0);
    }

    public static void assertEmptyScanKey(Scan scan) {
        Assert.assertNull((Object)scan.getFilter());
        Assert.assertArrayEquals((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])scan.getStopRow());
        Assert.assertEquals(null, (Object)scan.getFilter());
    }

    public static void compareTuples(Tuple res1, Tuple res2) throws Exception {
        if (res2 == null) {
            throw new Exception("There wasn't enough rows, we stopped at " + res1);
        }
        if (res1.size() != res2.size()) {
            throw new Exception("This row doesn't have the same number of KVs: " + res1.toString() + " compared to " + res2.toString());
        }
        for (int i = 0; i < res1.size(); ++i) {
            Cell replicatedKV;
            Cell ourKV = res1.getValue(i);
            if (ourKV.equals(replicatedKV = res2.getValue(i))) continue;
            throw new Exception("This result was different: " + res1.toString() + " compared to " + res2.toString());
        }
    }

    public static void clearMetaDataCache(java.sql.Connection conn) throws Throwable {
        PhoenixConnection pconn = conn.unwrap(PhoenixConnection.class);
        Table htable = pconn.getQueryServices().getTable(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES);
        htable.coprocessorService(MetaDataProtos.MetaDataService.class, HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, (Batch.Call)new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.ClearCacheResponse>(){

            public MetaDataProtos.ClearCacheResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                ServerRpcController controller = new ServerRpcController();
                CoprocessorRpcUtils.BlockingRpcCallback rpcCallback = new CoprocessorRpcUtils.BlockingRpcCallback();
                MetaDataProtos.ClearCacheRequest.Builder builder = MetaDataProtos.ClearCacheRequest.newBuilder();
                instance.clearCache((RpcController)controller, builder.build(), (RpcCallback)rpcCallback);
                if (controller.getFailedOn() != null) {
                    throw controller.getFailedOn();
                }
                return (MetaDataProtos.ClearCacheResponse)rpcCallback.get();
            }
        });
    }

    public static void closeStatement(Statement stmt) {
        try {
            stmt.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void closeConnection(java.sql.Connection conn) {
        try {
            conn.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void closeStmtAndConn(Statement stmt, java.sql.Connection conn) {
        TestUtil.closeStatement(stmt);
        TestUtil.closeConnection(conn);
    }

    public static void bindParams(PhoenixPreparedStatement stmt, List<Object> binds) throws SQLException {
        for (int i = 0; i < binds.size(); ++i) {
            stmt.setObject(i + 1, binds.get(i));
        }
    }

    public static void upsertRow(java.sql.Connection conn, String tableName, String sortOrder, int id, Object input) throws SQLException {
        String dml = String.format("UPSERT INTO " + tableName + "_%s VALUES(?,?)", sortOrder);
        PreparedStatement stmt = conn.prepareStatement(dml);
        stmt.setInt(1, id);
        if (input instanceof String) {
            stmt.setString(2, (String)input);
        } else if (input instanceof Integer) {
            stmt.setInt(2, (Integer)input);
        } else if (input instanceof Double) {
            stmt.setDouble(2, (Double)input);
        } else if (input instanceof Float) {
            stmt.setFloat(2, ((Float)input).floatValue());
        } else if (input instanceof Boolean) {
            stmt.setBoolean(2, (Boolean)input);
        } else if (input instanceof Long) {
            stmt.setLong(2, (Long)input);
        } else {
            throw new UnsupportedOperationException(input.getClass() + " is not supported by upsertRow");
        }
        stmt.execute();
        conn.commit();
    }

    public static void createGroupByTestTable(java.sql.Connection conn, String tableName) throws SQLException {
        conn.createStatement().execute("create table " + tableName + "   (id varchar not null primary key,\n    uri varchar, appcpu integer)");
    }

    private static void createTable(java.sql.Connection conn, String inputSqlType, String tableName, String sortOrder) throws SQLException {
        String dmlFormat = "CREATE TABLE " + tableName + "_%s (id INTEGER NOT NULL, pk %s NOT NULL, kv %s CONSTRAINT PK_CONSTRAINT PRIMARY KEY (id, pk %s))";
        String ddl = String.format(dmlFormat, sortOrder, inputSqlType, inputSqlType, sortOrder);
        conn.createStatement().execute(ddl);
        conn.commit();
    }

    public static String initTables(java.sql.Connection conn, String inputSqlType, List<Object> inputList) throws Exception {
        String tableName = BaseTest.generateUniqueName();
        TestUtil.createTable(conn, inputSqlType, tableName, "ASC");
        TestUtil.createTable(conn, inputSqlType, tableName, "DESC");
        for (int i = 0; i < inputList.size(); ++i) {
            TestUtil.upsertRow(conn, tableName, "ASC", i, inputList.get(i));
            TestUtil.upsertRow(conn, tableName, "DESC", i, inputList.get(i));
        }
        return tableName;
    }

    public static List<KeyRange> getAllSplits(java.sql.Connection conn, String tableName) throws SQLException {
        return TestUtil.getSplits(conn, tableName, null, null, null, null, null);
    }

    public static List<KeyRange> getAllSplits(java.sql.Connection conn, String tableName, String where, String selectClause) throws SQLException {
        return TestUtil.getSplits(conn, tableName, null, null, null, where, selectClause);
    }

    public static List<KeyRange> getSplits(java.sql.Connection conn, String tableName, String pkCol, byte[] lowerRange, byte[] upperRange, String whereClauseSuffix, String selectClause) throws SQLException {
        String whereClauseStart;
        String string = lowerRange == null && upperRange == null ? "" : (whereClauseStart = " WHERE " + (String)(lowerRange != null ? pkCol + " >= ? " + (upperRange != null ? " AND " : "") : "") + (String)(upperRange != null ? pkCol + " < ?" : ""));
        String whereClause = whereClauseSuffix == null ? whereClauseStart : (whereClauseStart.length() == 0 ? " WHERE " + whereClauseSuffix : " AND " + whereClauseSuffix);
        String query = "SELECT /*+ NO_INDEX */ " + selectClause + " FROM " + tableName + whereClause;
        PhoenixPreparedStatement pstmt = conn.prepareStatement(query).unwrap(PhoenixPreparedStatement.class);
        if (lowerRange != null) {
            pstmt.setBytes(1, lowerRange);
        }
        if (upperRange != null) {
            pstmt.setBytes(lowerRange != null ? 2 : 1, upperRange);
        }
        pstmt.execute();
        List keyRanges = pstmt.getQueryPlan().getSplits();
        return keyRanges;
    }

    public static Collection<GuidePostsInfo> getGuidePostsList(java.sql.Connection conn, String tableName) throws SQLException {
        return TestUtil.getGuidePostsList(conn, tableName, null, null, null, null);
    }

    public static Collection<GuidePostsInfo> getGuidePostsList(java.sql.Connection conn, String tableName, String where) throws SQLException {
        return TestUtil.getGuidePostsList(conn, tableName, null, null, null, where);
    }

    public static Collection<GuidePostsInfo> getGuidePostsList(java.sql.Connection conn, String tableName, String pkCol, byte[] lowerRange, byte[] upperRange, String whereClauseSuffix) throws SQLException {
        String whereClauseStart;
        String string = lowerRange == null && upperRange == null ? "" : (whereClauseStart = " WHERE " + (String)(lowerRange != null ? pkCol + " >= ? " + (upperRange != null ? " AND " : "") : "") + (String)(upperRange != null ? pkCol + " < ?" : ""));
        String whereClause = whereClauseSuffix == null ? whereClauseStart : (whereClauseStart.length() == 0 ? " WHERE " + whereClauseSuffix : " AND " + whereClauseSuffix);
        String query = "SELECT /*+ NO_INDEX */ COUNT(*) FROM " + tableName + whereClause;
        PhoenixPreparedStatement pstmt = conn.prepareStatement(query).unwrap(PhoenixPreparedStatement.class);
        if (lowerRange != null) {
            pstmt.setBytes(1, lowerRange);
        }
        if (upperRange != null) {
            pstmt.setBytes(lowerRange != null ? 2 : 1, upperRange);
        }
        pstmt.execute();
        TableRef tableRef = pstmt.getQueryPlan().getTableRef();
        PhoenixConnection pconn = conn.unwrap(PhoenixConnection.class);
        PTable table = tableRef.getTable();
        GuidePostsInfo info = pconn.getQueryServices().getTableStats(new GuidePostsKey(table.getName().getBytes(), SchemaUtil.getEmptyColumnFamily((PTable)table)));
        return Collections.singletonList(info);
    }

    public static void analyzeTable(java.sql.Connection conn, String tableName) throws IOException, SQLException {
        TestUtil.analyzeTable(conn, tableName, false);
    }

    public static void analyzeTable(java.sql.Connection conn, String tableName, boolean transactional) throws IOException, SQLException {
        String query = "UPDATE STATISTICS " + tableName;
        conn.createStatement().execute(query);
        conn.commit();
    }

    public static void analyzeTableIndex(java.sql.Connection conn, String tableName) throws IOException, SQLException {
        String query = "UPDATE STATISTICS " + tableName + " INDEX";
        conn.createStatement().execute(query);
    }

    public static void analyzeTableColumns(java.sql.Connection conn, String tableName) throws IOException, SQLException {
        String query = "UPDATE STATISTICS " + tableName + " COLUMNS";
        conn.createStatement().execute(query);
    }

    public static void analyzeTable(String url, Properties props, String tableName) throws IOException, SQLException {
        java.sql.Connection conn = DriverManager.getConnection(url, props);
        TestUtil.analyzeTable(conn, tableName);
        conn.close();
    }

    public static void setRowKeyColumns(PreparedStatement stmt, int i) throws SQLException {
        stmt.setString(1, "varchar" + String.valueOf(i));
        stmt.setString(2, "char" + String.valueOf(i));
        stmt.setInt(3, i);
        stmt.setLong(4, i);
        stmt.setBigDecimal(5, new BigDecimal((double)i * 0.5));
        Date date = new Date(DateUtil.parseDate((String)"2015-01-01 00:00:00").getTime() + (long)((i - 1) * 86400000));
        stmt.setDate(6, date);
    }

    public static void validateRowKeyColumns(ResultSet rs, int i) throws SQLException {
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)rs.getString(1), (Object)("varchar" + String.valueOf(i)));
        Assert.assertEquals((Object)rs.getString(2), (Object)("char" + String.valueOf(i)));
        Assert.assertEquals((long)rs.getInt(3), (long)i);
        Assert.assertEquals((long)rs.getInt(4), (long)i);
        Assert.assertEquals((Object)rs.getBigDecimal(5), (Object)new BigDecimal((double)i * 0.5));
        Date date = new Date(DateUtil.parseDate((String)"2015-01-01 00:00:00").getTime() + (long)((i - 1) * 86400000));
        Assert.assertEquals((Object)rs.getDate(6), (Object)date);
    }

    public static ClientAggregators getSingleSumAggregator(String url, Properties props) throws SQLException {
        try (PhoenixConnection pconn = DriverManager.getConnection(url, props).unwrap(PhoenixConnection.class);){
            ClientAggregators aggregators;
            PhoenixStatement statement = new PhoenixStatement(pconn);
            StatementContext context = new StatementContext(statement, null, new Scan(), new SequenceManager(statement));
            AggregationManager aggregationManager = context.getAggregationManager();
            SumAggregateFunction func = new SumAggregateFunction(Arrays.asList(new KeyValueColumnExpression((PColumn)new PLongColumn(){

                public PName getName() {
                    return QueryConstants.SINGLE_COLUMN_NAME;
                }

                public PName getFamilyName() {
                    return QueryConstants.SINGLE_COLUMN_FAMILY_NAME;
                }

                public int getPosition() {
                    return 0;
                }

                public SortOrder getSortOrder() {
                    return SortOrder.getDefault();
                }

                public Integer getArraySize() {
                    return 0;
                }

                public byte[] getViewConstant() {
                    return null;
                }

                public boolean isViewReferenced() {
                    return false;
                }

                public String getExpressionStr() {
                    return null;
                }

                public long getTimestamp() {
                    return Long.MAX_VALUE;
                }

                public boolean isDerived() {
                    return false;
                }

                public boolean isExcluded() {
                    return false;
                }

                public boolean isRowTimestamp() {
                    return false;
                }

                public boolean isDynamic() {
                    return false;
                }

                public byte[] getColumnQualifierBytes() {
                    return QueryConstants.SINGLE_COLUMN_NAME.getBytes();
                }
            })), null);
            aggregationManager.setAggregators(new ClientAggregators(Collections.singletonList(func), 1));
            ClientAggregators clientAggregators = aggregators = aggregationManager.getAggregators();
            return clientAggregators;
        }
    }

    public static void createMultiCFTestTable(java.sql.Connection conn, String tableName, String options) throws SQLException {
        String ddl = "create table if not exists " + tableName + "(   varchar_pk VARCHAR NOT NULL,    char_pk CHAR(5) NOT NULL,    int_pk INTEGER NOT NULL,    long_pk BIGINT NOT NULL,    decimal_pk DECIMAL(31, 10) NOT NULL,    a.varchar_col1 VARCHAR,    a.char_col1 CHAR(5),    a.int_col1 INTEGER,    a.long_col1 BIGINT,    a.decimal_col1 DECIMAL(31, 10),    b.varchar_col2 VARCHAR,    b.char_col2 CHAR(5),    b.int_col2 INTEGER,    b.long_col2 BIGINT,    b.decimal_col2 DECIMAL,    b.date_col DATE    CONSTRAINT pk PRIMARY KEY (varchar_pk, char_pk, int_pk, long_pk DESC, decimal_pk)) " + (options != null ? options : "");
        conn.createStatement().execute(ddl);
    }

    public static void flush(HBaseTestingUtility utility, TableName table) throws IOException {
        Admin admin = utility.getAdmin();
        admin.flush(table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void minorCompact(HBaseTestingUtility utility, TableName table) throws IOException, InterruptedException {
        try {
            CompactionScanner.setForceMinorCompaction((boolean)true);
            Admin admin = utility.getAdmin();
            admin.compact(table);
            int waitForCompactionToCompleteCounter = 0;
            while (CompactionScanner.getForceMinorCompaction()) {
                if (++waitForCompactionToCompleteCounter > 20) {
                    Assert.fail();
                }
                Thread.sleep(1000L);
            }
        }
        finally {
            CompactionScanner.setForceMinorCompaction((boolean)false);
        }
    }

    public static void majorCompact(HBaseTestingUtility utility, TableName table) throws IOException, InterruptedException {
        long lastCompactionTimestamp;
        long compactionRequestedSCN = EnvironmentEdgeManager.currentTimeMillis();
        Admin admin = utility.getAdmin();
        admin.majorCompact(table);
        CompactionState state = null;
        CompactionState previousState = null;
        while (!(!(state = admin.getCompactionState(table)).equals((Object)CompactionState.MAJOR) && !state.equals((Object)CompactionState.MAJOR_AND_MINOR) && (lastCompactionTimestamp = admin.getLastMajorCompactionTimestamp(table)) >= compactionRequestedSCN || state.equals((Object)CompactionState.NONE) && previousState != null && (previousState.equals((Object)CompactionState.MAJOR_AND_MINOR) || previousState.equals((Object)CompactionState.MAJOR)))) {
            previousState = state;
            Thread.sleep(100L);
        }
    }

    public static void doMajorCompaction(java.sql.Connection conn, String tableName) throws Exception {
        tableName = SchemaUtil.normalizeIdentifier((String)tableName);
        PhoenixConnection pconn = conn.unwrap(PhoenixConnection.class);
        PTable table = pconn.getTable(new PTableKey(pconn.getTenantId(), tableName));
        ConnectionQueryServices services = conn.unwrap(PhoenixConnection.class).getQueryServices();
        MutationState mutationState = pconn.getMutationState();
        if (table.isTransactional()) {
            mutationState.startTransaction(table.getTransactionProvider());
        }
        try (Table htable = mutationState.getHTable(table);){
            byte[] markerRowKey = Bytes.toBytes((String)"TO_DELETE");
            Put put = new Put(markerRowKey);
            long timestamp = 0L;
            put.addColumn(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, QueryConstants.EMPTY_COLUMN_VALUE_BYTES, timestamp, QueryConstants.EMPTY_COLUMN_VALUE_BYTES);
            htable.put(put);
            Delete delete = new Delete(markerRowKey);
            delete.addColumn(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, QueryConstants.EMPTY_COLUMN_VALUE_BYTES, timestamp);
            htable.delete(delete);
            htable.close();
            if (table.isTransactional()) {
                mutationState.commit();
            }
            Admin hbaseAdmin = services.getAdmin();
            hbaseAdmin.flush(TableName.valueOf((String)tableName));
            hbaseAdmin.majorCompact(TableName.valueOf((String)tableName));
            hbaseAdmin.close();
            boolean compactionDone = false;
            while (!compactionDone) {
                Thread.sleep(6000L);
                Scan scan = new Scan();
                scan.withStartRow(markerRowKey);
                scan.withStopRow(Bytes.add((byte[])markerRowKey, (byte[])new byte[]{0}));
                scan.setRaw(true);
                try (Table htableForRawScan = services.getTable(Bytes.toBytes((String)tableName));){
                    ResultScanner scanner = htableForRawScan.getScanner(scan);
                    ArrayList results = Lists.newArrayList((Iterable)scanner);
                    LOGGER.info("Results: " + results);
                    compactionDone = results.isEmpty();
                    scanner.close();
                }
                LOGGER.info("Compaction done: " + compactionDone);
                if (compactionDone || !table.isTransactional()) continue;
                hbaseAdmin = services.getAdmin();
                hbaseAdmin.flush(TableName.valueOf((String)tableName));
                hbaseAdmin.majorCompact(TableName.valueOf((String)tableName));
                hbaseAdmin.close();
            }
        }
    }

    public static void createTransactionalTable(java.sql.Connection conn, String tableName) throws SQLException {
        TestUtil.createTransactionalTable(conn, tableName, "");
    }

    public static void createTransactionalTable(java.sql.Connection conn, String tableName, String extraProps) throws SQLException {
        conn.createStatement().execute("create table " + tableName + "(   varchar_pk VARCHAR NOT NULL,    char_pk CHAR(10) NOT NULL,    int_pk INTEGER NOT NULL,    long_pk BIGINT NOT NULL,    decimal_pk DECIMAL(31, 10) NOT NULL,    date_pk DATE NOT NULL,    a.varchar_col1 VARCHAR,    a.char_col1 CHAR(10),    a.int_col1 INTEGER,    a.long_col1 BIGINT,    a.decimal_col1 DECIMAL(31, 10),    a.date1 DATE,    b.varchar_col2 VARCHAR,    b.char_col2 CHAR(10),    b.int_col2 INTEGER,    b.long_col2 BIGINT,    b.decimal_col2 DECIMAL(31, 10),    b.date2 DATE    CONSTRAINT pk PRIMARY KEY (varchar_pk, char_pk, int_pk, long_pk DESC, decimal_pk, date_pk)) TRANSACTIONAL=true" + (String)(extraProps.length() == 0 ? "" : "," + extraProps));
    }

    public static void dumpTable(java.sql.Connection conn, TableName tableName) throws SQLException, IOException {
        ConnectionQueryServices cqs = conn.unwrap(PhoenixConnection.class).getQueryServices();
        Table table = cqs.getTable(tableName.getName());
        TestUtil.dumpTable(table);
    }

    public static void dumpTable(Table table) throws IOException {
        System.out.println("************ dumping " + table + " **************");
        Scan s = new Scan();
        s.setRaw(true);
        s.readAllVersions();
        int cellCount = 0;
        int rowCount = 0;
        try (ResultScanner scanner = table.getScanner(s);){
            Result result;
            while ((result = scanner.next()) != null) {
                System.out.println("Row count: " + ++rowCount);
                CellScanner cellScanner = result.cellScanner();
                while (cellScanner.advance()) {
                    Cell current = cellScanner.current();
                    System.out.println(current + " column= " + Bytes.toStringBinary((byte[])CellUtil.cloneQualifier((Cell)current)) + " val=" + Bytes.toStringBinary((byte[])CellUtil.cloneValue((Cell)current)));
                    ++cellCount;
                }
            }
        }
        System.out.println("----- Row count: " + rowCount + " Cell count: " + cellCount + " -----");
    }

    public static int getRawRowCount(Table table) throws IOException {
        return TestUtil.getRowCount(table, true);
    }

    public static int getRowCount(Table table, boolean isRaw) throws IOException {
        Scan s = new Scan();
        s.setRaw(isRaw);
        int rows = 0;
        try (ResultScanner scanner = table.getScanner(s);){
            while (scanner.next() != null) {
                ++rows;
            }
        }
        return rows;
    }

    public static CellCount getCellCount(Table table, boolean isRaw) throws IOException {
        Scan s = new Scan();
        s.setRaw(isRaw);
        s.readAllVersions();
        CellCount cellCount = new CellCount();
        try (ResultScanner scanner = table.getScanner(s);){
            Result result = null;
            while ((result = scanner.next()) != null) {
                CellScanner cellScanner = result.cellScanner();
                Cell current = null;
                while (cellScanner.advance()) {
                    current = cellScanner.current();
                    cellCount.addOrUpdateCell(Bytes.toString((byte[])CellUtil.cloneRow((Cell)current)));
                }
            }
        }
        return cellCount;
    }

    public static void dumpIndexStatus(java.sql.Connection conn, String indexName) throws IOException, SQLException {
        try (Table table = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES);){
            System.out.println("************ dumping index status for " + indexName + " **************");
            Scan s = new Scan();
            s.setRaw(true);
            s.readAllVersions();
            byte[] startRow = SchemaUtil.getTableKeyFromFullName((String)indexName);
            s.withStartRow(startRow);
            s.withStopRow(ByteUtil.nextKey((byte[])ByteUtil.concat((byte[])startRow, (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY})));
            try (ResultScanner scanner = table.getScanner(s);){
                Result result = null;
                while ((result = scanner.next()) != null) {
                    CellScanner cellScanner = result.cellScanner();
                    Cell current = null;
                    while (cellScanner.advance()) {
                        current = cellScanner.current();
                        if (Bytes.compareTo((byte[])current.getQualifierArray(), (int)current.getQualifierOffset(), (int)current.getQualifierLength(), (byte[])PhoenixDatabaseMetaData.INDEX_STATE_BYTES, (int)0, (int)PhoenixDatabaseMetaData.INDEX_STATE_BYTES.length) != 0) continue;
                        System.out.println(current.getTimestamp() + "/INDEX_STATE=" + PIndexState.fromSerializedValue((byte)current.getValueArray()[current.getValueOffset()]));
                    }
                }
            }
            System.out.println("-----------------------------------------------");
        }
    }

    public static void printResultSet(ResultSet rs) throws SQLException {
        while (rs.next()) {
            TestUtil.printResult(rs, false);
        }
    }

    public static void printResult(ResultSet rs, boolean multiLine) throws SQLException {
        StringBuilder builder = new StringBuilder();
        int columnCount = rs.getMetaData().getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            Object value = rs.getObject(i + 1);
            String output = value == null ? "null" : value.toString();
            builder.append(output);
            if (i + 1 < columnCount) {
                builder.append(",");
                if (multiLine) {
                    builder.append("\n");
                }
            }
            System.out.println(builder.toString());
        }
    }

    public static void waitForIndexRebuild(java.sql.Connection conn, String fullIndexName, PIndexState indexState) throws InterruptedException, SQLException {
        TestUtil.waitForIndexState(conn, fullIndexName, indexState, 0L);
    }

    public static void waitForIndexState(java.sql.Connection conn, String fullIndexName, PIndexState expectedIndexState) throws InterruptedException, SQLException {
        int maxTries = 120;
        int nTries = 0;
        PIndexState actualIndexState = null;
        do {
            boolean matchesExpected;
            String schema = SchemaUtil.getSchemaNameFromFullName((String)fullIndexName);
            String index = SchemaUtil.getTableNameFromFullName((String)fullIndexName);
            Thread.sleep(1000L);
            String query = "SELECT INDEX_STATE FROM " + PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME + " WHERE (TABLE_SCHEM,TABLE_NAME) = ('" + schema + "','" + index + "') AND COLUMN_FAMILY IS NULL AND COLUMN_NAME IS NULL";
            ResultSet rs = conn.createStatement().executeQuery(query);
            if (!rs.next()) continue;
            actualIndexState = PIndexState.fromSerializedValue((String)rs.getString(1));
            boolean bl = matchesExpected = actualIndexState == expectedIndexState;
            if (!matchesExpected) continue;
            return;
        } while (++nTries < maxTries);
        Assert.fail((String)("Ran out of time waiting for index state to become " + expectedIndexState + " last seen actual state is " + (actualIndexState == null ? "Unknown" : actualIndexState.toString())));
    }

    public static void waitForIndexState(java.sql.Connection conn, String fullIndexName, PIndexState expectedIndexState, Long expectedIndexDisableTimestamp) throws InterruptedException, SQLException {
        int maxTries = 60;
        int nTries = 0;
        do {
            Thread.sleep(1000L);
            IndexStateCheck state = TestUtil.checkIndexStateInternal(conn, fullIndexName, expectedIndexState, expectedIndexDisableTimestamp);
            if (state.success == null) continue;
            if (Boolean.TRUE.equals(state.success)) {
                return;
            }
            Assert.fail((String)("Index state will not become " + expectedIndexState));
        } while (++nTries < maxTries);
        Assert.fail((String)("Ran out of time waiting for index state to become " + expectedIndexState));
    }

    public static boolean checkIndexState(java.sql.Connection conn, String fullIndexName, PIndexState expectedIndexState, Long expectedIndexDisableTimestamp) throws SQLException {
        return Boolean.TRUE.equals(TestUtil.checkIndexStateInternal((java.sql.Connection)conn, (String)fullIndexName, (PIndexState)expectedIndexState, (Long)expectedIndexDisableTimestamp).success);
    }

    public static void assertIndexState(java.sql.Connection conn, String fullIndexName, PIndexState expectedIndexState, Long expectedIndexDisableTimestamp) throws SQLException {
        IndexStateCheck state = TestUtil.checkIndexStateInternal(conn, fullIndexName, expectedIndexState, expectedIndexDisableTimestamp);
        if (!Boolean.TRUE.equals(state.success)) {
            if (expectedIndexState != null) {
                Assert.assertEquals((Object)expectedIndexState, (Object)state.indexState);
            }
            if (expectedIndexDisableTimestamp != null) {
                Assert.assertEquals((Object)expectedIndexDisableTimestamp, (Object)state.indexDisableTimestamp);
            }
        }
    }

    public static PIndexState getIndexState(java.sql.Connection conn, String fullIndexName) throws SQLException {
        IndexStateCheck state = TestUtil.checkIndexStateInternal(conn, fullIndexName, null, null);
        return state.indexState;
    }

    public static long getPendingDisableCount(PhoenixConnection conn, String indexTableName) {
        byte[] indexTableKey = SchemaUtil.getTableKeyFromFullName((String)indexTableName);
        Get get = new Get(indexTableKey);
        get.addColumn(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.PENDING_DISABLE_COUNT_BYTES);
        try {
            Result pendingDisableCountResult = conn.getQueryServices().getTable(SchemaUtil.getPhysicalTableName((String)PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME, (ReadOnlyProps)conn.getQueryServices().getProps()).getName()).get(get);
            return Bytes.toLong((byte[])pendingDisableCountResult.getValue(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.PENDING_DISABLE_COUNT_BYTES));
        }
        catch (Exception e) {
            LOGGER.error("Exception in getPendingDisableCount: " + e);
            return 0L;
        }
    }

    private static IndexStateCheck checkIndexStateInternal(java.sql.Connection conn, String fullIndexName, PIndexState expectedIndexState, Long expectedIndexDisableTimestamp) throws SQLException {
        String schema = SchemaUtil.getSchemaNameFromFullName((String)fullIndexName);
        String index = SchemaUtil.getTableNameFromFullName((String)fullIndexName);
        String query = "SELECT CAST(INDEX_DISABLE_TIMESTAMP AS BIGINT),INDEX_STATE FROM " + PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME + " WHERE (TABLE_SCHEM,TABLE_NAME) = ('" + schema + "','" + index + "') AND COLUMN_FAMILY IS NULL AND COLUMN_NAME IS NULL";
        ResultSet rs = conn.createStatement().executeQuery(query);
        Long actualIndexDisableTimestamp = null;
        PIndexState actualIndexState = null;
        if (rs.next()) {
            boolean matchesExpected;
            actualIndexDisableTimestamp = rs.getLong(1);
            actualIndexState = PIndexState.fromSerializedValue((String)rs.getString(2));
            boolean bl = matchesExpected = !(expectedIndexDisableTimestamp != null && !Objects.equal((Object)actualIndexDisableTimestamp, (Object)expectedIndexDisableTimestamp) || expectedIndexState != null && actualIndexState != expectedIndexState);
            if (matchesExpected) {
                return new IndexStateCheck(actualIndexState, actualIndexDisableTimestamp, Boolean.TRUE);
            }
            if (ZERO.equals(actualIndexDisableTimestamp)) {
                return new IndexStateCheck(actualIndexState, actualIndexDisableTimestamp, Boolean.FALSE);
            }
        }
        return new IndexStateCheck(actualIndexState, actualIndexDisableTimestamp, null);
    }

    public static long getRowCount(java.sql.Connection conn, String tableName) throws SQLException {
        ResultSet rs = conn.createStatement().executeQuery("SELECT /*+ NO_INDEX */ count(*) FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        return rs.getLong(1);
    }

    public static long getRowCount(java.sql.Connection conn, String tableName, boolean skipIndex) throws SQLException {
        String query = String.format("SELECT %s count(*) FROM %s", skipIndex ? "/*+ NO_INDEX */" : "", tableName);
        try (ResultSet rs = conn.createStatement().executeQuery(query);){
            Assert.assertTrue((boolean)rs.next());
            long l = rs.getLong(1);
            return l;
        }
    }

    public static long getRowCountFromIndex(java.sql.Connection conn, String tableName, String indexName) throws SQLException {
        String query = String.format("SELECT count(*) FROM %s", tableName);
        try (ResultSet rs = conn.createStatement().executeQuery(query);){
            PhoenixResultSet prs = rs.unwrap(PhoenixResultSet.class);
            String explainPlan = QueryUtil.getExplainPlan((ResultIterator)prs.getUnderlyingIterator());
            Assert.assertTrue((boolean)explainPlan.contains(indexName));
            Assert.assertTrue((boolean)rs.next());
            long l = rs.getLong(1);
            return l;
        }
    }

    public static void addCoprocessor(java.sql.Connection conn, String tableName, Class coprocessorClass) throws Exception {
        int priority = 805306466;
        ConnectionQueryServices services = conn.unwrap(PhoenixConnection.class).getQueryServices();
        TableDescriptor descriptor = services.getTableDescriptor(Bytes.toBytes((String)tableName));
        TableDescriptorBuilder descriptorBuilder = null;
        if (descriptor.getCoprocessorDescriptors().stream().map(CoprocessorDescriptor::getClassName).collect(Collectors.toList()).contains(coprocessorClass.getName())) {
            return;
        }
        descriptorBuilder = TableDescriptorBuilder.newBuilder((TableDescriptor)descriptor);
        descriptorBuilder.setCoprocessor(CoprocessorDescriptorBuilder.newBuilder((String)coprocessorClass.getName()).setPriority(priority).build());
        int retries = 10;
        int numTries = 10;
        descriptor = descriptorBuilder.build();
        try (Admin admin = services.getAdmin();){
            admin.modifyTable(descriptor);
            while (!admin.getDescriptor(TableName.valueOf((String)tableName)).equals(descriptor) && numTries > 0) {
                if (--numTries == 0) {
                    throw new Exception("Failed to add " + coprocessorClass.getName() + " after 10 retries.");
                }
                Thread.sleep(1000L);
            }
        }
    }

    public static void removeCoprocessor(java.sql.Connection conn, String tableName, Class coprocessorClass) throws Exception {
        ConnectionQueryServices services = conn.unwrap(PhoenixConnection.class).getQueryServices();
        TableDescriptor descriptor = services.getTableDescriptor(Bytes.toBytes((String)tableName));
        TableDescriptorBuilder descriptorBuilder = null;
        if (!descriptor.getCoprocessorDescriptors().stream().map(CoprocessorDescriptor::getClassName).collect(Collectors.toList()).contains(coprocessorClass.getName())) {
            return;
        }
        descriptorBuilder = TableDescriptorBuilder.newBuilder((TableDescriptor)descriptor);
        descriptorBuilder.removeCoprocessor(coprocessorClass.getName());
        int retries = 10;
        int numTries = 10;
        descriptor = descriptorBuilder.build();
        try (Admin admin = services.getAdmin();){
            admin.modifyTable(descriptor);
            while (!admin.getDescriptor(TableName.valueOf((String)tableName)).equals(descriptor) && numTries > 0) {
                if (--numTries == 0) {
                    throw new Exception("Failed to remove " + coprocessorClass.getName() + " after 10 retries.");
                }
                Thread.sleep(1000L);
            }
        }
    }

    public static boolean compare(CompareOperator op, ImmutableBytesWritable lhsOutPtr, ImmutableBytesWritable rhsOutPtr) {
        int compareResult = Bytes.compareTo((byte[])lhsOutPtr.get(), (int)lhsOutPtr.getOffset(), (int)lhsOutPtr.getLength(), (byte[])rhsOutPtr.get(), (int)rhsOutPtr.getOffset(), (int)rhsOutPtr.getLength());
        return ByteUtil.compare((CompareOperator)op, (int)compareResult);
    }

    public static QueryPlan getOptimizeQueryPlan(java.sql.Connection conn, String sql) throws SQLException {
        PhoenixPreparedStatement statement = conn.prepareStatement(sql).unwrap(PhoenixPreparedStatement.class);
        QueryPlan queryPlan = statement.optimizeQuery(sql);
        queryPlan.iterator();
        return queryPlan;
    }

    public static QueryPlan getOptimizeQueryPlanNoIterator(java.sql.Connection conn, String sql) throws SQLException {
        PhoenixPreparedStatement statement = conn.prepareStatement(sql).unwrap(PhoenixPreparedStatement.class);
        QueryPlan queryPlan = statement.optimizeQuery(sql);
        return queryPlan;
    }

    public static void assertResultSet(ResultSet rs, Object[][] rows) throws Exception {
        for (int rowIndex = 0; rowIndex < rows.length; ++rowIndex) {
            Assert.assertTrue((String)("rowIndex:[" + rowIndex + "] rs.next error!"), (boolean)rs.next());
            for (int columnIndex = 1; columnIndex <= rows[rowIndex].length; ++columnIndex) {
                Object realValue = rs.getObject(columnIndex);
                Object expectedValue = rows[rowIndex][columnIndex - 1];
                if (realValue == null) {
                    Assert.assertNull((String)("rowIndex:[" + rowIndex + "],columnIndex:[" + columnIndex + "]"), (Object)expectedValue);
                    continue;
                }
                Assert.assertEquals((String)("rowIndex:[" + rowIndex + "],columnIndex:[" + columnIndex + "]"), (Object)expectedValue, (Object)realValue);
            }
        }
        Assert.assertTrue((!rs.next() ? 1 : 0) != 0);
    }

    public static int getRandomPort() {
        int n;
        ServerSocket socket = new ServerSocket(0);
        try {
            socket.setReuseAddress(true);
            n = socket.getLocalPort();
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return -1;
            }
        }
        socket.close();
        return n;
    }

    public static boolean hasFilter(Scan scan, Class<? extends Filter> filterClass) {
        Iterator filterIter = ScanUtil.getFilterIterator((Scan)scan);
        while (filterIter.hasNext()) {
            Filter filter = (Filter)filterIter.next();
            if (!filterClass.isInstance(filter)) continue;
            return true;
        }
        return false;
    }

    public static JoinCompiler.JoinTable getJoinTable(String query, PhoenixConnection connection) throws SQLException {
        SQLParser parser = new SQLParser(query);
        SelectStatement select = SubselectRewriter.flatten((SelectStatement)parser.parseQuery(), (PhoenixConnection)connection);
        ColumnResolver resolver = FromCompiler.getResolverForQuery((SelectStatement)select, (PhoenixConnection)connection);
        SelectStatement transformedSelect = SubqueryRewriter.transform((SelectStatement)(select = StatementNormalizer.normalize((SelectStatement)select, (ColumnResolver)resolver)), (ColumnResolver)resolver, (PhoenixConnection)connection);
        if (transformedSelect != select) {
            resolver = FromCompiler.getResolverForQuery((SelectStatement)transformedSelect, (PhoenixConnection)connection);
            select = StatementNormalizer.normalize((SelectStatement)transformedSelect, (ColumnResolver)resolver);
        }
        PhoenixStatement stmt = connection.createStatement().unwrap(PhoenixStatement.class);
        return JoinCompiler.compile((PhoenixStatement)stmt, (SelectStatement)select, (ColumnResolver)resolver);
    }

    public static void assertSelectStatement(FilterableStatement selectStatement, String sql) {
        Assert.assertTrue((boolean)selectStatement.toString().trim().equals(sql));
    }

    public static void assertSqlExceptionCode(SQLExceptionCode code, SQLException se) {
        Assert.assertEquals((long)code.getErrorCode(), (long)se.getErrorCode());
        Assert.assertTrue((String)"Wrong error message", (boolean)se.getMessage().contains(code.getMessage()));
        Assert.assertEquals((Object)code.getSQLState(), (Object)se.getSQLState());
    }

    public static void assertTTLValue(java.sql.Connection conn, TableName tableName, int ttl, boolean checkTTLInSystemCatalog) throws SQLException, IOException {
        Object tableTTL = checkTTLInSystemCatalog ? conn.unwrap(PhoenixConnection.class).getTable(new PTableKey(null, tableName.getNameAsString())).getTTLExpression() : TTLExpressionFactory.create((int)TestUtil.getColumnDescriptor(conn, tableName).getTimeToLive());
        LiteralTTLExpression expectedTTL = TTLExpressionFactory.create((int)ttl);
        Assert.assertEquals((Object)expectedTTL, (Object)tableTTL);
    }

    public static void assertTTLValue(java.sql.Connection conn, TTLExpression expected, String name) throws SQLException, IOException {
        PTable pTable = PhoenixRuntime.getTableNoCache((java.sql.Connection)conn, (String)name);
        TestUtil.assertTTLValue(conn, pTable, expected);
    }

    public static void assertTTLValue(java.sql.Connection conn, TableName tableName, int ttl) throws SQLException, IOException {
        TestUtil.assertTTLValue(conn, tableName.getNameAsString(), (TTLExpression)TTLExpressionFactory.create((int)ttl));
    }

    public static void assertTTLValue(java.sql.Connection conn, String name, TTLExpression expected) throws SQLException, IOException {
        PTable pTable = PhoenixRuntime.getTableNoCache((java.sql.Connection)conn, (String)name);
        TestUtil.assertTTLValue(conn, pTable, expected);
    }

    public static void assertTTLValue(java.sql.Connection conn, PTable pTable, TTLExpression expected) throws SQLException, IOException {
        TTLExpression actualInSyscat = pTable.getTTLExpression();
        byte[] hbaseTableName = pTable.getPhysicalName().getBytes();
        ColumnFamilyDescriptor cfd = TestUtil.getColumnDescriptor(conn, TableName.valueOf((byte[])hbaseTableName));
        TTLExpression actual = actualInSyscat;
        if (actualInSyscat.equals(LiteralTTLExpression.TTL_EXPRESSION_DEFINED_IN_TABLE_DESCRIPTOR)) {
            actual = TTLExpressionFactory.create((int)cfd.getTimeToLive());
        } else {
            Assert.assertEquals((String)"Table descriptor TTL value did not match :-", (Object)LiteralTTLExpression.TTL_EXPRESSION_FOREVER, (Object)TTLExpressionFactory.create((int)cfd.getTimeToLive()));
        }
        Assert.assertEquals((String)"TTL value did not match :-", (Object)expected, (Object)actual);
    }

    public static void assertTableHasVersions(java.sql.Connection conn, TableName tableName, int versions) throws SQLException, IOException {
        ColumnFamilyDescriptor cd = TestUtil.getColumnDescriptor(conn, tableName);
        Assert.assertEquals((long)versions, (long)cd.getMaxVersions());
    }

    public static ColumnFamilyDescriptor getColumnDescriptor(java.sql.Connection conn, TableName tableName) throws SQLException, IOException {
        Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();
        TableDescriptor td = admin.getDescriptor(tableName);
        return td.getColumnFamilies()[0];
    }

    public static void assertRawRowCount(java.sql.Connection conn, TableName table, int expectedRowCount) throws SQLException, IOException {
        ConnectionQueryServices cqs = conn.unwrap(PhoenixConnection.class).getQueryServices();
        int count = TestUtil.getRawRowCount(cqs.getTable(table.getName()));
        Assert.assertEquals((long)expectedRowCount, (long)count);
    }

    public static int getRawRowCount(java.sql.Connection conn, TableName table) throws SQLException, IOException {
        ConnectionQueryServices cqs = conn.unwrap(PhoenixConnection.class).getQueryServices();
        return TestUtil.getRawRowCount(cqs.getTable(table.getName()));
    }

    public static int getRawCellCount(java.sql.Connection conn, TableName tableName, byte[] row) throws SQLException, IOException {
        ConnectionQueryServices cqs = conn.unwrap(PhoenixConnection.class).getQueryServices();
        Table table = cqs.getTable(tableName.getName());
        CellCount cellCount = TestUtil.getCellCount(table, true);
        return cellCount.getCellCount(Bytes.toString((byte[])row));
    }

    public static CellCount getRawCellCount(java.sql.Connection conn, TableName tableName) throws IOException, SQLException {
        ConnectionQueryServices cqs = conn.unwrap(PhoenixConnection.class).getQueryServices();
        Table table = cqs.getTable(tableName.getName());
        return TestUtil.getCellCount(table, true);
    }

    public static void assertRawCellCount(java.sql.Connection conn, TableName tableName, byte[] row, int expectedCellCount) throws SQLException, IOException {
        int count = TestUtil.getRawCellCount(conn, tableName, row);
        Assert.assertEquals((long)expectedCellCount, (long)count);
    }

    public static void assertRowExistsAtSCN(String url, String sql, long scn, boolean shouldExist) throws SQLException {
        boolean rowExists = false;
        Properties props = new Properties();
        props.setProperty("CurrentSCN", Long.toString(scn));
        try (java.sql.Connection conn = DriverManager.getConnection(url, props);){
            ResultSet rs = conn.createStatement().executeQuery(sql);
            rowExists = rs.next();
            if (shouldExist) {
                Assert.assertTrue((String)("Row was not found at time " + scn + " when it should have been"), (boolean)rowExists);
            } else {
                Assert.assertFalse((String)("Row was found at time " + scn + " when it should not have been"), (boolean)rowExists);
            }
        }
    }

    public static void assertRowHasExpectedValueAtSCN(String url, String sql, long scn, String value) throws SQLException {
        Properties props = new Properties();
        props.setProperty("CurrentSCN", Long.toString(scn));
        try (java.sql.Connection conn = DriverManager.getConnection(url, props);){
            ResultSet rs = conn.createStatement().executeQuery(sql);
            Assert.assertTrue((String)("Value " + value + " does not exist at scn " + scn), (boolean)rs.next());
            Assert.assertEquals((Object)value, (Object)rs.getString(1));
        }
    }

    public static String getExplainPlan(java.sql.Connection conn, String sql) throws SQLException {
        try (ResultSet rs = conn.createStatement().executeQuery("EXPLAIN " + sql);){
            String string = QueryUtil.getExplainPlan((ResultSet)rs);
            return string;
        }
    }

    public static Path createTempDirectory() throws IOException {
        return Files.createTempDirectory(Paths.get(System.getProperty("java.io.tmpdir"), new String[0]), null, new FileAttribute[0]);
    }

    public static void splitTable(java.sql.Connection conn, String tableName, byte[] splitPoint) throws Exception {
        TestUtil.executeHBaseTableRegionOperation(conn, tableName, (admin, regionLocator, nRegions) -> {
            admin.split(TableName.valueOf((String)tableName), splitPoint);
            TestUtil.waitForRegionChange(regionLocator, nRegions);
        });
    }

    public static void mergeTableRegions(java.sql.Connection conn, String tableName, List<String> regions) throws Exception {
        byte[][] regionsToMerge = (byte[][])regions.stream().map(String::getBytes).toArray(x$0 -> new byte[x$0][]);
        TestUtil.executeHBaseTableRegionOperation(conn, tableName, (admin, regionLocator, nRegions) -> {
            admin.mergeRegionsAsync(regionsToMerge, true).get();
            TestUtil.waitForRegionChange(regionLocator, nRegions);
        });
    }

    private static void executeHBaseTableRegionOperation(java.sql.Connection conn, String tableName, TableOperation operation) throws Exception {
        ConnectionQueryServices services = conn.unwrap(PhoenixConnection.class).getQueryServices();
        Configuration configuration = services.getConfiguration();
        try (Connection hbaseConn = ConnectionFactory.createConnection((Configuration)configuration);
             Admin admin = services.getAdmin();){
            RegionLocator regionLocator = hbaseConn.getRegionLocator(TableName.valueOf((String)tableName));
            int nRegions = regionLocator.getAllRegionLocations().size();
            operation.execute(admin, regionLocator, nRegions);
        }
    }

    private static void waitForRegionChange(RegionLocator regionLocator, int initialRegionCount) throws Exception {
        for (int retryCount = 0; retryCount < 20 && regionLocator.getAllRegionLocations().size() == initialRegionCount; ++retryCount) {
            Thread.sleep(5000L);
        }
        Assert.assertNotEquals((long)regionLocator.getAllRegionLocations().size(), (long)initialRegionCount);
    }

    public static List<HRegionLocation> getAllTableRegions(java.sql.Connection conn, String tableName) throws Exception {
        ConnectionQueryServices services = conn.unwrap(PhoenixConnection.class).getQueryServices();
        Configuration configuration = services.getConfiguration();
        Connection hbaseConn = ConnectionFactory.createConnection((Configuration)configuration);
        RegionLocator regionLocator = hbaseConn.getRegionLocator(TableName.valueOf((String)tableName));
        return regionLocator.getAllRegionLocations();
    }

    public static String retainSingleQuotes(String input) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            sb.append(ch);
            if (ch != '\'') continue;
            sb.append('\'');
        }
        return sb.toString();
    }

    public static class CellCount {
        private Map<String, Integer> rowCountMap = new HashMap<String, Integer>();

        public void addOrUpdateCell(String key) {
            this.addOrUpdateCells(key, 1);
        }

        public void addOrUpdateCells(String key, int count) {
            if (this.rowCountMap.containsKey(key)) {
                this.rowCountMap.put(key, this.rowCountMap.get(key) + count);
            } else {
                this.insertRow(key, count);
            }
        }

        public void insertRow(String key, int count) {
            this.rowCountMap.put(key, count);
        }

        public void removeRow(String key) {
            this.rowCountMap.remove(key);
        }

        public int getCellCount(String key) {
            if (this.rowCountMap.containsKey(key)) {
                return this.rowCountMap.get(key);
            }
            return 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CellCount other = (CellCount)o;
            return this.rowCountMap.equals(other.rowCountMap);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("CellCount{");
            sb.append("rowCountMap=").append(this.rowCountMap);
            sb.append('}');
            return sb.toString();
        }
    }

    private static class IndexStateCheck {
        public final PIndexState indexState;
        public final Long indexDisableTimestamp;
        public final Boolean success;

        public IndexStateCheck(PIndexState indexState, Long indexDisableTimestamp, Boolean success) {
            this.indexState = indexState;
            this.indexDisableTimestamp = indexDisableTimestamp;
            this.success = success;
        }
    }

    @FunctionalInterface
    private static interface TableOperation {
        public void execute(Admin var1, RegionLocator var2, int var3) throws Exception;
    }
}

