/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.sql.SQLException;
import org.apache.phoenix.util.SequenceUtil;
import org.junit.Assert;
import org.junit.Test;

public class SequenceUtilTest {
    private static long MIN_VALUE = 1L;
    private static long MAX_VALUE = 10L;
    private static long CACHE_SIZE = 2L;

    @Test
    public void testAscendingNextValueWithinLimit() throws SQLException {
        Assert.assertFalse((boolean)SequenceUtil.checkIfLimitReached((long)5L, (long)MIN_VALUE, (long)MAX_VALUE, (long)2L, (long)CACHE_SIZE));
    }

    @Test
    public void testAscendingNextValueReachLimit() throws SQLException {
        Assert.assertFalse((boolean)SequenceUtil.checkIfLimitReached((long)6L, (long)MIN_VALUE, (long)MAX_VALUE, (long)2L, (long)CACHE_SIZE));
    }

    @Test
    public void testAscendingNextValueGreaterThanMaxValue() throws SQLException {
        Assert.assertTrue((boolean)SequenceUtil.checkIfLimitReached((long)MAX_VALUE, (long)MIN_VALUE, (long)MAX_VALUE, (long)2L, (long)CACHE_SIZE));
    }

    @Test
    public void testAscendingOverflow() throws SQLException {
        Assert.assertTrue((boolean)SequenceUtil.checkIfLimitReached((long)Long.MAX_VALUE, (long)0L, (long)Long.MAX_VALUE, (long)1L, (long)CACHE_SIZE));
    }

    @Test
    public void testDescendingNextValueWithinLimit() throws SQLException {
        Assert.assertFalse((boolean)SequenceUtil.checkIfLimitReached((long)6L, (long)MIN_VALUE, (long)MAX_VALUE, (long)-2L, (long)CACHE_SIZE));
    }

    @Test
    public void testDescendingNextValueReachLimit() throws SQLException {
        Assert.assertFalse((boolean)SequenceUtil.checkIfLimitReached((long)5L, (long)MIN_VALUE, (long)MAX_VALUE, (long)-2L, (long)CACHE_SIZE));
    }

    @Test
    public void testDescendingNextValueLessThanMinValue() throws SQLException {
        Assert.assertTrue((boolean)SequenceUtil.checkIfLimitReached((long)2L, (long)MIN_VALUE, (long)MAX_VALUE, (long)-2L, (long)CACHE_SIZE));
    }

    @Test
    public void testDescendingOverflowCycle() throws SQLException {
        Assert.assertTrue((boolean)SequenceUtil.checkIfLimitReached((long)Long.MIN_VALUE, (long)Long.MIN_VALUE, (long)0L, (long)-1L, (long)CACHE_SIZE));
    }

    @Test
    public void testBulkAllocationAscendingNextValueGreaterThanMax() throws SQLException {
        Assert.assertTrue((boolean)SequenceUtil.checkIfLimitReached((long)MAX_VALUE, (long)MIN_VALUE, (long)MAX_VALUE, (long)2L, (long)CACHE_SIZE, (long)1L));
    }

    @Test
    public void testBulkAllocationAscendingNextValueReachLimit() throws SQLException {
        Assert.assertFalse((boolean)SequenceUtil.checkIfLimitReached((long)6L, (long)MIN_VALUE, (long)MAX_VALUE, (long)2L, (long)CACHE_SIZE, (long)2L));
    }

    @Test
    public void testBulkAllocationAscendingNextValueWithinLimit() throws SQLException {
        Assert.assertFalse((boolean)SequenceUtil.checkIfLimitReached((long)5L, (long)MIN_VALUE, (long)MAX_VALUE, (long)2L, (long)CACHE_SIZE, (long)2L));
    }

    @Test
    public void testBulkAllocationAscendingOverflow() throws SQLException {
        Assert.assertTrue((boolean)SequenceUtil.checkIfLimitReached((long)Long.MAX_VALUE, (long)0L, (long)Long.MAX_VALUE, (long)1L, (long)CACHE_SIZE, (long)100L));
    }

    @Test
    public void testBulkAllocationDescendingNextValueLessThanMax() throws SQLException {
        Assert.assertTrue((boolean)SequenceUtil.checkIfLimitReached((long)10L, (long)MIN_VALUE, (long)MAX_VALUE, (long)-2L, (long)CACHE_SIZE, (long)5L));
    }

    @Test
    public void testBulkAllocationDescendingNextValueReachLimit() throws SQLException {
        Assert.assertFalse((boolean)SequenceUtil.checkIfLimitReached((long)7L, (long)MIN_VALUE, (long)MAX_VALUE, (long)-2L, (long)CACHE_SIZE, (long)3L));
    }

    @Test
    public void testBulkAllocationDescendingNextValueWithinLimit() throws SQLException {
        Assert.assertFalse((boolean)SequenceUtil.checkIfLimitReached((long)8L, (long)MIN_VALUE, (long)MAX_VALUE, (long)-2L, (long)CACHE_SIZE, (long)2L));
    }

    @Test
    public void testBulkAllocationDescendingOverflowCycle() throws SQLException {
        Assert.assertTrue((boolean)SequenceUtil.checkIfLimitReached((long)Long.MIN_VALUE, (long)Long.MIN_VALUE, (long)0L, (long)-1L, (long)CACHE_SIZE, (long)100L));
    }

    @Test
    public void testIsCycleAllowedForBulkAllocation() {
        Assert.assertFalse((boolean)SequenceUtil.isCycleAllowed((long)2L));
    }

    @Test
    public void testIsCycleAllowedForStandardAllocation() {
        Assert.assertTrue((boolean)SequenceUtil.isCycleAllowed((long)1L));
    }
}

