/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.lang.annotation.Annotation;
import org.apache.phoenix.util.Repeat;
import org.junit.Ignore;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class RunUntilFailure
extends BlockJUnit4ClassRunner {
    private boolean hasFailure;

    public RunUntilFailure(Class<?> klass) throws InitializationError {
        super(klass);
    }

    protected Description describeChild(FrameworkMethod method) {
        if (method.getAnnotation(Repeat.class) != null && method.getAnnotation(Ignore.class) == null) {
            return this.describeRepeatTest(method);
        }
        return super.describeChild(method);
    }

    private Description describeRepeatTest(FrameworkMethod method) {
        int times = ((Repeat)method.getAnnotation(Repeat.class)).value();
        Description description = Description.createSuiteDescription((String)(this.testName(method) + " [" + times + " times]"), (Annotation[])method.getAnnotations());
        for (int i = 1; i <= times; ++i) {
            description.addChild(Description.createTestDescription((Class)this.getTestClass().getJavaClass(), (String)(this.testName(method) + "-" + i)));
        }
        return description;
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        Description description = this.describeChild(method);
        if (method.getAnnotation(Repeat.class) != null && method.getAnnotation(Ignore.class) == null) {
            this.runRepeatedly(this.methodBlock(method), description, notifier);
        }
        super.runChild(method, notifier);
    }

    private void runRepeatedly(Statement statement, Description description, RunNotifier notifier) {
        notifier.addListener(new RunListener(){

            public void testFailure(Failure failure) {
                RunUntilFailure.this.hasFailure = true;
            }
        });
        for (Description desc : description.getChildren()) {
            if (this.hasFailure) {
                notifier.fireTestIgnored(desc);
                continue;
            }
            if (desc.isSuite()) continue;
            this.runLeaf(statement, desc, notifier);
        }
    }
}

