/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.phoenix.parse.HintNode;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.ColumnInfo;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.junit.Assert;
import org.junit.Test;

public class QueryUtilTest {
    private static final ColumnInfo ID_COLUMN = new ColumnInfo("ID", -5);
    private static final ColumnInfo NAME_COLUMN = new ColumnInfo("NAME", 12);

    @Test
    public void testConstructUpsertStatement_ColumnInfos() {
        Assert.assertEquals((Object)"UPSERT  INTO MYTAB (\"ID\", \"NAME\") VALUES (?, ?)", (Object)QueryUtil.constructUpsertStatement((String)"MYTAB", (List)ImmutableList.of((Object)ID_COLUMN, (Object)NAME_COLUMN)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstructUpsertStatement_ColumnInfos_NoColumns() {
        QueryUtil.constructUpsertStatement((String)"MYTAB", (List)ImmutableList.of());
    }

    @Test
    public void testConstructGenericUpsertStatement() {
        Assert.assertEquals((Object)"UPSERT INTO MYTAB VALUES (?, ?)", (Object)QueryUtil.constructGenericUpsertStatement((String)"MYTAB", (int)2));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstructGenericUpsertStatement_NoColumns() {
        QueryUtil.constructGenericUpsertStatement((String)"MYTAB", (int)0);
    }

    @Test
    public void testConstructSelectStatement() {
        Assert.assertEquals((Object)"SELECT \"ID\" , \"NAME\" FROM MYTAB", (Object)QueryUtil.constructSelectStatement((String)"MYTAB", (List)ImmutableList.of((Object)ID_COLUMN, (Object)NAME_COLUMN), null));
    }

    @Test
    public void testConstructSelectStatementWithSchema() {
        Assert.assertEquals((Object)"SELECT \"ID\" , \"NAME\" FROM A.MYTAB", (Object)QueryUtil.constructSelectStatement((String)"A.MYTAB", (List)ImmutableList.of((Object)ID_COLUMN, (Object)NAME_COLUMN), null));
    }

    @Test
    public void testConstructSelectStatementWithCaseSensitiveSchema() {
        String tableName = "MYTAB";
        String schemaName = SchemaUtil.getEscapedArgument((String)"a");
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)"MYTAB");
        Assert.assertEquals((Object)"SELECT \"ID\" , \"NAME\" FROM \"a\".MYTAB", (Object)QueryUtil.constructSelectStatement((String)fullTableName, (List)ImmutableList.of((Object)ID_COLUMN, (Object)NAME_COLUMN), null));
    }

    @Test
    public void testConstructSelectStatementWithCaseSensitiveTable() {
        String tableName = SchemaUtil.getEscapedArgument((String)"mytab");
        String schemaName = SchemaUtil.getEscapedArgument((String)"a");
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        Assert.assertEquals((Object)"SELECT \"ID\" , \"NAME\" FROM \"a\".\"mytab\"", (Object)QueryUtil.constructSelectStatement((String)fullTableName, (List)ImmutableList.of((Object)ID_COLUMN, (Object)NAME_COLUMN), null));
    }

    @Test
    public void testConstructSelectWithHint() {
        Assert.assertEquals((Object)"SELECT /*+ NO_INDEX */ \"col1\" , \"col2\" FROM MYTAB WHERE (\"col2\"=? and \"col3\" is null)", (Object)QueryUtil.constructSelectStatement((String)"MYTAB", (List)Lists.newArrayList((Object[])new String[]{"col1", "col2"}), (String)"\"col2\"=? and \"col3\" is null", (HintNode.Hint)HintNode.Hint.NO_INDEX, (boolean)true));
    }

    @Test
    public void testConstructParameterizedInClause() {
        Assert.assertEquals((Object)"((?,?,?),(?,?,?))", (Object)QueryUtil.constructParameterizedInClause((int)3, (int)2));
        Assert.assertEquals((Object)"((?))", (Object)QueryUtil.constructParameterizedInClause((int)1, (int)1));
    }

    @Test
    public void testCreateConnectionFromConfiguration() throws Exception {
        Properties props = new Properties();
        Configuration conf = new Configuration(false);
        conf.set("hbase.client.registry.impl", "org.apache.hadoop.hbase.client.ZKConnectionRegistry");
        conf.set("hbase.zookeeper.quorum", "localhost");
        conf.set("hbase.zookeeper.property.clientPort", "2181");
        String conn = QueryUtil.getConnectionUrl((Properties)props, (Configuration)conf);
        this.validateUrl(conn);
        conf.set("hbase.zookeeper.quorum", "host.at.some.domain.1,localhost,host.at.other.domain.3");
        conn = QueryUtil.getConnectionUrl((Properties)props, (Configuration)conf);
        this.validateUrl(conn);
        conf.set("hbase.zookeeper.peerport", "3338");
        conf.set("hbase.zookeeper.leaderport", "3339");
        conn = QueryUtil.getConnectionUrl((Properties)props, (Configuration)conf);
        this.validateUrl(conn);
    }

    private void validateUrl(String url) {
        String[] servers;
        String prefix = "jdbc:phoenix:";
        String zkPrefix = "jdbc:phoenix+zk:";
        String masterPrefix = "jdbc:phoenix+master:";
        String rpcPrefix = "jdbc:phoenix+rpc:";
        Assert.assertTrue((String)"JDBC URL missing jdbc protocol prefix", (url.startsWith(prefix) || url.startsWith(zkPrefix) || url.startsWith(masterPrefix) || url.startsWith(rpcPrefix) ? 1 : 0) != 0);
        Assert.assertTrue((String)"JDBC URL missing jdbc terminator suffix", (boolean)url.endsWith(";"));
        url = url.replaceAll("\\\\:", "=");
        String[] splits = url.split(":");
        splits = Arrays.copyOfRange(splits, 2, splits.length);
        Assert.assertTrue((String)"zk details should contain at least server component", (splits.length >= 1 ? 1 : 0) != 0);
        for (String server : servers = splits[0].replaceAll("=", "\\\\:").split(",")) {
            Assert.assertFalse((String)("Found whitespace in server names for url: " + url), (boolean)server.contains(" "));
        }
        if (splits.length >= 2 && !splits[1].isEmpty()) {
            try {
                Integer.parseInt(splits[1]);
            }
            catch (NumberFormatException e) {
                Assert.fail((String)e.getMessage());
            }
        }
        if (splits.length >= 3) {
            Assert.assertTrue((String)"znode parent is not an absolute path", (boolean)splits[2].startsWith("/"));
        }
    }
}

