/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.query.BaseConnectionlessQueryTest;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.PhoenixRuntime;
import org.junit.Assert;
import org.junit.Test;

public class PhoenixEncodeDecodeTest
extends BaseConnectionlessQueryTest {
    @Test
    public void testDecodeValues1() throws Exception {
        this.testDecodeValues(false, false);
    }

    @Test
    public void testDecodeValues2() throws Exception {
        this.testDecodeValues(true, false);
    }

    @Test
    public void testDecodeValues3() throws Exception {
        this.testDecodeValues(true, true);
    }

    @Test
    public void testDecodeValues4() throws Exception {
        this.testDecodeValues(false, true);
    }

    private void testDecodeValues(boolean nullFixedWidth, boolean nullVariableWidth) throws Exception {
        Connection conn = DriverManager.getConnection(PhoenixEncodeDecodeTest.getUrl());
        conn.createStatement().execute("CREATE TABLE T(pk1 CHAR(15) not null, pk2 VARCHAR not null, CF1.v1 DATE, CF2.v2 VARCHAR, CF2.v1 VARCHAR CONSTRAINT pk PRIMARY KEY (pk1, pk2)) ");
        Date d = nullFixedWidth ? null : new Date(100L);
        String s = nullVariableWidth ? null : "foo";
        Object[] values = new Object[]{"def", "eid", d, s, s};
        byte[] bytes = PhoenixRuntime.encodeColumnValues((Connection)conn, (String)"T", (Object[])values, (List)Lists.newArrayList((Object[])new Pair[]{new Pair(null, (Object)"pk1"), new Pair(null, (Object)"pk2"), new Pair((Object)"cf1", (Object)"v1"), new Pair((Object)"cf2", (Object)"v2"), new Pair((Object)"cf2", (Object)"v1")}));
        Object[] decodedValues = PhoenixRuntime.decodeColumnValues((Connection)conn, (String)"T", (byte[])bytes, (List)Lists.newArrayList((Object[])new Pair[]{new Pair(null, (Object)"pk1"), new Pair(null, (Object)"pk2"), new Pair((Object)"cf1", (Object)"v1"), new Pair((Object)"cf2", (Object)"v2"), new Pair((Object)"cf2", (Object)"v1")}));
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new Serializable[]{"def", "eid", d, s, s}), Arrays.asList(decodedValues));
    }
}

