/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.hadoop.hbase.ByteBufferKeyValue;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.security.visibility.CellVisibility;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.MutationUtil;
import org.junit.Assert;
import org.junit.Test;

public class MutationUtilTest {
    @Test
    public void testPutCopy() throws IOException {
        byte[] rowKey = Bytes.toBytes((String)"row1");
        byte[] family = Bytes.toBytes((String)"f");
        long ts = EnvironmentEdgeManager.currentTimeMillis();
        int numCols = 5;
        int priority = 255;
        Put source = new Put(rowKey);
        source.setTimestamp(ts);
        source.setDurability(Durability.SKIP_WAL);
        source.setPriority(255);
        for (int i = 0; i < 5; ++i) {
            source.add(this.createOffHeapCell(rowKey, family, Bytes.toBytes((String)("col" + i)), ts, Bytes.toBytes((String)("v_" + i))));
        }
        source.setTTL(345L);
        source.setCellVisibility(new CellVisibility("secret"));
        source.setAttribute("_ClientVersion", Bytes.toBytes((String)"5.2.1"));
        Put copied = MutationUtil.copyPut((Put)source);
        Assert.assertArrayEquals((byte[])source.getRow(), (byte[])copied.getRow());
        Assert.assertEquals((long)source.getTimestamp(), (long)copied.getTimestamp());
        Assert.assertEquals((Object)source.getDurability(), (Object)copied.getDurability());
        Assert.assertEquals((long)source.getPriority(), (long)copied.getPriority());
        Assert.assertTrue((boolean)this.areEqual(source.getAttributesMap(), copied.getAttributesMap()));
        NavigableMap sourceFamilyCellMap = source.getFamilyCellMap();
        NavigableMap copiedFamilyCellMap = copied.getFamilyCellMap();
        Assert.assertEquals((long)sourceFamilyCellMap.size(), (long)copiedFamilyCellMap.size());
        List sourceCells = (List)sourceFamilyCellMap.get(family);
        List copiedCells = (List)copiedFamilyCellMap.get(family);
        Assert.assertEquals((long)sourceCells.size(), (long)copiedCells.size());
        sourceCells.stream().allMatch(cell -> cell instanceof ByteBufferKeyValue);
        copiedCells.stream().allMatch(cell -> cell instanceof KeyValue);
        copied = MutationUtil.copyPut((Put)source, (boolean)true);
        Assert.assertTrue((boolean)copied.getAttributesMap().isEmpty());
    }

    private Cell createOffHeapCell(byte[] rowKey, byte[] family, byte[] qualifier, long ts, byte[] value) {
        KeyValue kv = new KeyValue(rowKey, family, qualifier, ts, KeyValue.Type.Put);
        ByteBuffer dbb = ByteBuffer.allocateDirect(kv.getBuffer().length);
        ByteBufferUtils.copyFromArrayToBuffer((ByteBuffer)dbb, (byte[])kv.getBuffer(), (int)0, (int)kv.getBuffer().length);
        ByteBufferKeyValue offheapKV = new ByteBufferKeyValue(dbb, 0, kv.getBuffer().length, 0L);
        return offheapKV;
    }

    private boolean areEqual(Map<String, byte[]> first, Map<String, byte[]> second) {
        if (first.size() != second.size()) {
            return false;
        }
        return first.entrySet().stream().allMatch(e -> Arrays.equals((byte[])e.getValue(), (byte[])second.get(e.getKey())));
    }
}

